### Configuration:

# Name of your project. Your main source file should be named this,
# plus DASM_EXT (e.g. if PROJ=foo and DASM_EXT=dasm, your source file
# should be called "foo.dasm". Also, if using axe, your DOS .atr image
# should be called "foo.atr"). Unless you have a very good reason not to,
# PROJ should be set to the name of your project directory.
PROJ=buzz

# What do you want to call the binary? If using axe, this
# should be "autorun.sys", unless you want to manually load it using
# the DOS menu.
BIN=autorun.sys

# If you want to name it after your project instead:
# (note: axe only supports 8-character + 3-character extensions for
# filenames, keep this in mind if you're using it).
#BIN=$(PROJ).bin

# Extension you use for DASM source files. I use .dasm, but lots of people
# use .asm, particularly if they're using DOS or Windows (although Windows
# hasn't had a 3-character extension limit since Win95).
DASM_EXT=dasm

# If you have and want to use axe:
HAVE_AXE=yes

# Otherwise, set HAVE_AXE=no, and use a recent AtariSIO snapshot or an
# emulator that supports loading individual binary files (such as atari++).
#HAVE_AXE=no

# If you have an SIO2PC cable and a real Atari:
HAVE_SIO2PC=yes

# Otherwise:
#HAVE_SIO2PC=no

# If HAVE_SIO2PC above is "yes", what software do you want to use with it?

# AtariSIO (Matthias Reichl) works well, but needs to be run from its own
# terminal due to its curses UI. If you're not using X11, you'll need to
# replace "xterm -e" with whatever your system uses to run a console-based
# program in a new window (probably "cmd.exe" on Windows).
SIO2PC_CMD=xterm -e atariserver

# sio2linux (Preston Crow), change the ttyS0 if you need to. I've had
# issues getting sio2linux to work reliably with Steve Tucker's SIO2PC
# cable, but it might work better for you. YMMV.
# As written, this Makefile requires axe, if you're going to use sio2linux.
#SIO2PC_CMD=sio2linux -s /dev/ttyS0

# If you don't have an SIO2PC cable, you'll want to use an emulator
# for testing.
EMU_CMD=atari++ -image.1
#EMU_CMD="atari800"

# For SIO2PC_CMD and EMU_CMD, the filename of the Atari .atr image (if
# using axe) or the Atari executable (if not using axe) gets appended to
# the commands. Keep this in mind if you define your own commands.

