#!/usr/bin/perl -w

sub usage {
	die <<EOF;
Usage: $0 [-annn] note

Where `note' is a letter A through F, with optional # or b (sharp
or flat), followed by an octave number (e.g. A4 is a concert A, E1 is
the low E on a bass, E2 is the low E on a guitar, C4 is "middle C").

Frequencies are by default calculated using "concert pitch", where A4 = 440Hz.
If -annn option is given, the "nnn" will be used as the pitch of A4 instead.
(In other words, "-a440" is the default).

EOF
}

%notes = (
		C => 1,
		'C#' => 2,
		Db => 2,
		D => 3,
		'D#' => 4,
		Eb => 4,
		E => 5,
		F => 6,
		'F#' => 7,
		Gb => 7,
		G => 8,
		'G#' => 9,
		Ab => 9,
		A => 10,
		'A#' => 11,
		Bb => 11,
		B => 12
		);

if(@ARGV && ($ARGV[0] =~ /^-a([.\d]+)$/)) {
	$ref = $1;
	shift;
} else {
	$ref = 440; # A440
}

$refnum = $notes{A} + 12*4;

$_ = shift;
if(not $_) {
	for ($oct=8; $oct>3; $oct--) {
		for $n (reverse "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B") {
			$note = $n;
			$num = $notes{ucfirst lc $note} + (12*$oct) - $refnum;
			$freq = $ref * (2 ** ($num/12));
			$cycles = 1790000/$freq;
			printf "%5s %8.2f %8.2f\n", $note.$oct, $freq, $cycles;
		}
	}
	exit 0;
}

($note, $oct) = /^([A-G][#b]?)-?(\d\d?)/i;

usage unless $note;

$num = $notes{ucfirst lc $note} + (12*$oct) - $refnum;

$freq = $ref * (2 ** ($num/12));

print "$freq\n";
