;
;	>> Alien Swarm - Fix by JAC! & Paul Lay <<
;
;	@com.wudsn.ide.asm.mainsourcefile=AlienSwarm-XL.asm

	opt f+

	.proc main, main_ram

; Conditional equates
	.if .def JAC
	delay_b4 = $da
	delay_fa = $ff
	delay_fc = $ff
	delay_e1 = $f1
	.else
	delay_b4 = $b4
	delay_fa = $fa		
	delay_fc = $fc
	delay_e1 = $e1
	.endif

; Code equates
zp_ptr		= $00cb			;For indirect addressing
stack_l0100	= $0100			;For direct stack manipulation in interrupts
first_fixed	= $29a8			;First fixed address that must not be overwritten

; Fixed addresses.
l29a8	= $29a8
l29b5	= $29b5
l29c2	= $29c2
l29cf	= $29cf
l29dc	= $29dc
l29e9	= $29e9
l29f6	= $29f6
l2a03	= $2a03
l2a10	= $2a10
l2a1d	= $2a1d
l2a31	= $2a31
l2a45	= $2a45
l2a59	= $2a59
l2a6d	= $2a6d
l2a6e	= $2a6e
l2a9b	= $2a9b
l2ac8	= $2ac8
l2af5	= $2af5
l2b22	= $2b22
l2b4f	= $2b4f
l2b50	= $2b50
l2b51	= $2b51
l2b65	= $2b65
l2b66	= $2b66
l2b67	= $2b67
l2b68	= $2b68
l2b69	= $2b69
l2b6a	= $2b6a
l2b6b	= $2b6b
l2b6c	= $2b6c
l2b6d	= $2b6d
l2b6e	= $2b6e
l2b6f	= $2b6f
l2b70	= $2b70
l2b71	= $2b71
l2b72	= $2b72
l2b73	= $2b73
player_energy_lo	= $2b75		;3 bytes, player 1/2/none
player_energy_hi	= $3000
player_up		= $2b78		;1 byte
player_maximum		= $2b79		;1 byte
l2b7a			= $2b7a	
player_score_lo		= $2b7b		;3 bytes, player 1/2/high score
player_score_mid 	= $2b7e		;3 bytes, player 1/2/high score
player_score_hi		= $2b81		;3 bytes, player 1/2/high score
bonus_count_l2b84	= $2b84
l2b85	= $2b85
l2b86	= $2b86
l2b87	= $2b87
score_mid_bonus_flag	= $2b88
l2b89	= $2b89

	.if .not .def JAC
	.proc silly_disk_check
	lda #$30
	sta irqen
	sta pokmsk
	lda #$00
	sta l28f5
	lda #$68
	sta daux1
l1017	lda #$52
	sta dcomnd
	lda #$01
	sta dunit
	lda #$00
	sta dbuflo
	lda #$06
	sta dbufhi
	lda #$01
	sta daux2
	jsr dskinv
	bpl start_l105c
	lda l28f5
	beq l1059
	lda rtclok+1
	bne l1059
	jmp start_l105c
	lda l28f5
	bne l1059
	lda #$b4
	sta rtclok+2
	lda #$00
	sta rtclok+1
	lda #$69
	sta daux1
	inc l28f5
	jmp l1017
l1059	sec
	bcs l1059
	.endp
	.endif

	.proc start_l105c
	.if .def JAC
	lda #$40			;Keyboard IRQ only
	.else
	lda #$70			;Nonsense setting with SIO IRQs
	.endif
	sta irqen
	sta pokmsk
	lda #$3c
	sta pactl

	lda #<keyboard_irq_l1284
	sta vkeybd
	lda #>keyboard_irq_l1284
	sta vkeybd+1

	lda #$00
	ldx #$02
loop	sta player_energy_lo,x

	.if .def JAC_ENERGY
	sta player_energy_hi,x
	.endif

	sta player_score_lo,x
	sta player_score_mid,x
	sta player_score_hi,x
	dex
	bpl loop
	.endp

	.proc start_l1085
	ldx #$ff
	txs
	cld
	lda #$00
	sta audc1
	sta audc2
	jsr open_screen_l13af
	lda #$00
	sta color2
	lda #$74
	sta color1
	ldy #$02
	ldx #$01
l10a2	lda player_score_hi,x
	cmp player_score_hi,y
	bcc l10d0
	bne l10be
	lda player_score_mid,x
	cmp player_score_mid,y
	bcc l10d0
	bne l10be
	lda player_score_lo,x
	cmp player_score_lo,y
	bcc l10d0
l10be	lda player_score_lo,x
	sta player_score_lo,y
	lda player_score_mid,x
	sta player_score_mid,y
	lda player_score_hi,x
	sta player_score_hi,y
l10d0	dex
	bpl l10a2

	jsr print_scores_and_energy
	lda #$00
	ldy #$0e
	sta (zp_ptr),y
	ldy #$19
	sta (zp_ptr),y
	lda memtop
	sta zp_ptr
	lda memtop+1
	sta zp_ptr+1
	lda #$07
	ldy #$0e
	sta (zp_ptr),y
	ldy #$22
	sta (zp_ptr),y
	ldy #$36
	sta (zp_ptr),y
	lda #$06
	ldy #$18
	sta (zp_ptr),y
	ldy #$2c
	sta (zp_ptr),y
	lda #$02
	ldy #$3b
	sta (zp_ptr),y
	iny
	sta (zp_ptr),y
	ldy #$07
	sta (zp_ptr),y
	iny
	sta (zp_ptr),y
	ldx #$04
	lda #$0f
l1116	iny
	sta (zp_ptr),y
	dex
	bpl l1116
	ldy #$10
	ldx #$02
l1120	lda #$0f
	sta (zp_ptr),y
	iny
	sta (zp_ptr),y
	iny
	sta (zp_ptr),y
	tya
	clc
	adc #$08
	tay
	dex
	bpl l1120
	lda savmsc
	clc
	adc #$40
	sta zp_ptr
	lda savmsc+1
	adc #$01
	sta zp_ptr+1
	ldy #$05
	lda #$e0
	ldx #$00
	jsr print_title_l11bd	;ALIEN SWARM
	jsr l11af
	ldy #$04
	lda #$20
	jsr print_title_l11bd	;PRESENTED BY
	jsr l11af
	ldy #$03
	lda #$e0
	jsr print_title_l11bd		;INHOME SOFTWARE
	jsr l11af
	ldy #$05
	lda #$20
	jsr print_title_l11bd		;CREATED BY
	jsr l11af
	ldy #$03
	lda #$e0
	jsr print_title_l11bd		;BRUCE THOMSON
	lda zp_ptr
	clc
	adc #$b4
	sta zp_ptr
	lda zp_ptr+1
	adc #$00
	sta zp_ptr+1
	ldy #$05
	lda #$e0
	jsr print_title_l11bd		;COPYRIGHT...
	lda #$10
	jsr print_title_l11bd
	.if .def JAC
	lda #$00
	ldy #$30
	.else
	lda l28f2			;Use $10 from before
	ldy #$3b
	.endif
	jsr print_title_l11bd
	lda savmsc
	clc
	adc #$28
	sta zp_ptr
	lda savmsc+1
	adc #$00
	sta zp_ptr+1
	ldy #$00
	lda #$60
	jsr print_title_l11bd
	.if .def JAC
	ldy #$30
	.else
	ldy #$34
	.endif
	lda #$60
	jsr print_title_l11bd
	jmp l12bd
	.endp

	.proc l11af
	lda zp_ptr
	clc
	adc #$7c
	sta zp_ptr
	lda zp_ptr+1
	adc #$01
	sta zp_ptr+1
	rts
	.endp

	.proc print_title_l11bd
	sta l28f2
	lda title_text_l11e6,x
l11c3	clc
	adc l28f2
	sta (zp_ptr),y
	inx
	iny
	lda title_text_l11e6,x
	cmp #$fa
	bne l11c3
	inx
	rts
	.endp

	.proc l11d4
	lda rtclok+2
	cmp #$c3
	bcs l11e0
	lda #$00
	.if .def JAC
	sta chact
	.else
	sta chactl
	.endif
	rts
l11e0	lda #$01
	.if .def JAC
	sta chact
	.else
	sta chactl
	.endif
	rts
	.endp

	.local title_text_l11e6
	.byte 'ALIEN SWARM'
	.byte $FA
	.byte 'PRESENTED BY'
	.byte $FA
	.byte 'INHOME SOFTWARE'
	.byte $fa
	.byte 'CREATED BY'
	.byte $fa
	.byte 'BRUCE THOMPSON'
	.byte $fa
	.byte 'COPYRIGHT BRUCE THOMPSON '
	.byte $fa
	.byte $01,$09,$08,$02
	.byte $fa
	.if .def JAC
	.byte "Fix by JAC! 2014-09-23"
	.else
	.byte $00,$06,$fe
	.endif
	.byte $fa
	.if .def JAC
	m_title_options
	.else
	.byte '  SELECT',$ff,'TWO PLAYERS'
	.byte '   OPTION',$ff,'BEGINNER'
	.endif

	.byte $fa
	.byte 'THEN PRESS START'
	.if .def JAC
	.byte ' OR FIRE'
	.endif
	.byte $fa
	.endl

	.proc keyboard_irq_l1284
	lda kbcode
	cmp #$27			;INVERSE?
	beq quit_l12aa
	.if .def JAC
	cmp #$1c
	beq quit_l12aa
	.endif

	cmp #$21			;SPACE?
	bne l129c
	lda pause_l12bb			;Toggle pause
	eor #$80
	sta pause_l12bb
	bpl l12a8
	jmp l12a8

l129c	cmp #$0d			;"I"?
	bne l12a8
	lda toggle_l12bc
	eor #$80
	sta toggle_l12bc

l12a8	pla
	rti

quit_l12aa
	tsx
	lda #<start_L1085
	inx
	inx
	inx
	sta stack_l0100,x
	lda #>start_L1085
	inx
	sta stack_l0100,x
	pla
	rti
	.endp

pause_l12bb	.byte $00		;Pause toggle flag, $00/$80
toggle_l12bc	.byte $00		;Unused toggle flag, $00/$80

	.proc l12bd
	ldy #$00
	lda savmsc
	sta l28f2
	lda savmsc+1
	sta l28f3
l12c9	lda l28f2
	sta screen_offsets_l28f8,y
	lda l28f3
	iny
	sta screen_offsets_l28f8,y
	lda l28f2
	clc
	adc #$28
	sta l28f2
	lda l28f3
	adc #$00
	sta l28f3
	iny

	cpy #.len screen_offsets_l28f8
	bne l12c9
	lda #$56
	asl
	tay
	lda screen_offsets_l28f8,y
	adc #$a0
	sta l2b4f
	iny
	lda screen_offsets_l28f8,y
	adc #$00
	sta l2b50
	lda #$50
	asl
	tay
	lda screen_offsets_l28f8,y
	sta l2b66
	iny
	lda screen_offsets_l28f8,y
	sta l2b67
	lda #$05
	sec
	sbc #$02
	asl
	tay
	lda screen_offsets_l28f8,y
	clc
	adc #$0a
	sta l2b6f
	iny
	lda screen_offsets_l28f8,y
	adc #$00
	sta l2b70
	ldx #$00
	lda #$20			;Set initial energy
	sta player_energy_lo,x
	inx
	sta player_energy_lo,x
	
	.if .def JAC_ENERGY
	lda #0
	sta player_energy_hi+0
	sta player_energy_hi+1
	.endif

	lda #$00
	sta player_maximum
	sta player_up
	sta pause_l12bb
	sta toggle_l12bc
	ldx #$01
l1346	lda #$00
	sta player_score_lo,x
	sta player_score_mid,x
	sta player_score_hi,x
	lda #$aa
	sta l2b73,x
	dex
	bpl l1346
	lda #$00
	sta l2b87
	.if .not .def JAC
	lda #consol_reset
	sta consol
	.endif
console_loop
	lda consol
	and #$02
	bne l137e
	lda player_up
	bne l137e
	inc player_up
	inc player_maximum
	lda #$00
	ldy #$08
l1379	sta (zp_ptr),y
	dey
	bne l1379
l137e	lda consol
	and #$04
	bne l139e
	lda #$ff
	ldx #$00
	sta l2b73,x
	inx
	sta l2b73,x
	sta l2b87
	ldy #$1d
	lda #$00
l1397	sta (zp_ptr),y
	dey
	cpy #$16
	bne l1397
l139e	jsr l11d4
	lda consol
	and #$01			;START?
	.if .def JAC
	and strig0			;FIRE?
	.endif
	bne console_loop
	.if .def JAC
wait_released				;Wait until FIRE is released again
	lda strig0
	beq wait_released
	.endif

	lda #$01
	sta atract
	jmp l13f5
	.endp

	.proc open_screen_l13af
	m_open_screen

	.if .def JAC			;Blank screen before DL modification
	lda #0
	sta sdmactl
	sta dmactl
	.endif

	lda memtop			;Modify first line of DL
	sta zp_ptr
	lda memtop+1
	sta zp_ptr+1
	lda #$42
	ldy #$04
	sta (zp_ptr),y
	lda #$32
	sta color0
	lda #$da
	sta color1
	lda #$c2
	sta color2
	
	.if .def JAC			;Delay re-activation of screen
	lda rtclok+2
wait	cmp rtclok+2
	beq wait
	mva #$22 sdmactl
	.endif
	rts
	.endp

	.proc l13f5
	jsr open_screen_l13af
	lda #$80
	sta l27b1
	lda #$05
	sta l27b3
	lda #$01
	sta l2b72
	ldx #$00
l1409	lda #$00
	sta l2a10,x
	inx
	cpx #$0d
	bmi l1409
	ldx #$00
	lda #$5b
l1417	sta l2a59,x
	inx
	cpx #$14
	bmi l1417
	ldx #$2c
l1421	lda savmsc
	sta l2a6e,x
	lda savmsc+1
	sta l2a9b,x
	lda #$19
	sta l2af5,x
	lda #$50
	sta l2b22,x
	dex
	bne l1421
	lda #$19
	sta l27ae
	lda #$50
	sta l27ad
	lda #$4b
	sta l2b65
	jsr l1e58
	lda #$01
	sta l2b6d
	lda #$00
	sta l2b71
	sta bonus_count_l2b84
	jsr l2437
	ldy #$00
l145c	jsr l2145
	iny
	cpy #$14
	bmi l145c
	lda player_maximum
	beq l147d
	lda player_up
	eor #$01
	sta player_up
	tax
	lda player_energy_lo,x

	.if .def JAC_ENERGY
	ora player_energy_hi,x
	.endif

	bne l1488
	txa
	eor #$01
	sta player_up
l147d	ldx player_up
	lda player_energy_lo,x

	.if .def JAC_ENERGY
	ora player_energy_hi,x
	.endif

	bne l1488
	jmp start_L1085

l1488	lda #$00
	sta score_mid_bonus_flag
	sta l2b86
	lda #$02
	sta l2a6d
	lda l2b87
	beq l149f
	lda #$03
	sta l2a6d
l149f	ldx player_up
	lda player_score_hi,x
	cmp #$10
	bcc l14ae
	lda #$01
	sta l2a6d
l14ae	
	.if .def JAC_ENERGY		;Check if energy is less than $20
	lda player_energy_hi,x
	bne more_than_20
	.endif

	lda player_energy_lo,x
	cmp #$20
	bcc less_than_20

more_than_20
	.if .def JAC_ENERGY		;Ensure <A> contains the correct value in case we branched here from the high byte check
	lda player_energy_lo,x
	.endif
	sed
	sec
	sbc #$20
	sta player_energy_lo,x
	.if .def JAC_ENERGY
	lda player_energy_hi,x
	sbc #$00
	sta player_energy_hi,x
	.endif
	cld
	ldy #$00
l14bf	jsr l2137
	iny
	cpy #$14
	bmi l14bf
	jmp l14f1

	.proc less_than_20
	lda #$20
	sed
	sec
	sbc player_energy_lo,x		;No handling of player_energy_hi, because it's zero here
	cld
	cmp #$0f
	bcc l14db
	and #$0f
	clc
	adc #$0a
l14db	lsr
	tay
l14dd	jsr l2137
	iny
	ldx player_up
	lda player_energy_lo,x		;No handling of player_energy_hi, because it's zero here
	sed
	sec
	sbc #$01
	sta player_energy_lo,x
	cld
	bne l14dd
	.endp

l14f1	jsr print_scores_and_energy
	ldx #$00
	ldy #$0f
	lda #$00
	lda gfx_l281d
l14fd	sta (zp_ptr),y
	iny
	inx
	lda gfx_l281d,x
	bpl l14fd
	lda #$00
	sta l257a
	sta l2b6e

l150e	lda strig0
	bne l150e
	lda #$01
	sta pause_l12bb
	sta atract
	ldy #$0f
	lda #$00
l151e	sta (zp_ptr),y
	iny
	cpy #$19
	bne l151e

l1525	lda rtclok+2
	sta l28f1
l152a	lda pause_l12bb
	bpl l153a
	lda #$00
	sta audc1
	sta audc2
	jmp l152a
l153a	lda toggle_l12bc
	ldx player_up
	lda player_score_hi,x
	cmp #$02
	bcc l155b
	lda l1b46
	bne l155b
	lda #$07
	sta l28f2
	lda #$19
	sta l28f3
	ldx #$00
	jsr l1572
l155b	lda l1b04
	bne l1590
	lda #$08
	sta l28f2
	lda #$05
	sta l28f3
	ldx #$00
	jsr l1572
	jmp l1590
l1572	lda l2a10,x
	bne l158a
	lda l28f2
	sta l2a10,x
	lda #$00
	sta l29cf,x
	lda l28f3
	sta l2a03,x
	ldx #$0c
l158a	inx
	cpx #$0d
	bmi l1572
	rts
	.endp

	.proc l1590
	lda #$00
	sta l1b46
	sta l1b04
	ldx player_up
	inc l2b7a
	dec l2b85
	bne l15d0
	lda player_score_hi,x
	bne l15af
	lda player_score_mid,x
	cmp #$15
	bcc l15c0
l15af	lda random
	and #$07
	bne l15c0
	lda #$00
	sta l27b1
	lda #$3b
	sta l27b3
l15c0	lda l2b73,x
	sta l2b85
	lda #$ff
	sta l27ab
	lda #$00
	sta l27ac
l15d0	lda l2b7a
	and #$3f
	bne l15da
	jsr l15f6
l15da	jsr l1b6b
	jsr l1cdc
	jsr l1710
	jsr l1deb
	jsr l1e42
	jsr l246f
l15ec	lda rtclok+2
	cmp l28f1
	beq l15ec
	jmp l13f5.l1525

	.proc l15f6
	ldx player_up
	ldy bonus_count_l2b84
	beq l1601
	jsr count_l1653
l1601	jsr print_scores_and_energy
	lda l2b71
	bne l1613
	lda l2b6d
	beq l1613
	lda l2b86
	beq l1630
l1613	ldx player_up
	dec l2b72
	bne l162f
	lda #$06
	sta l2b72
	dec l2b73,x
	lda l2b73,x
	cmp #$2d
	bcs l162f
	lda #$2d
	sta l2b73,x
l162f	rts
	.endp

	.endp

	.proc l1630
	pla
	pla
	lda #$00
	sta audc1
	sta audc2
	lda #delay_b4
	sta rtclok+2
l163e	lda rtclok+2
	bne l163e
	jsr l2084
	ldx player_up
	lda player_energy_lo,x

	.if .def JAC_ENERGY
	ora player_energy_hi,x
	.endif

	bne l1650
	jmp out_of_energy_l1fec
l1650	jmp out_of_energy_l1fec.l201a
	.endp

	.proc count_l1653
	sed
l1654	lda player_score_lo,x
	clc
	adc #$10
	sta player_score_lo,x
	bcc l166d
	lda player_energy_lo,x
	clc
	adc #$01

	.if .not .def JAC_ENERGY
	bcc l1669			;Normal cap at $99
	lda #$99
l1669	sta player_energy_lo,x

	.else
	sta player_energy_lo,x		;Extended cap at $9999
	lda player_energy_hi,x
	adc #0
	sta player_energy_hi,x
	bcc no_overflow
	lda #$99
	sta player_energy_lo,x
	sta player_energy_hi,x
no_overflow
	.endif

	sec
l166d	lda player_score_mid,x
	adc #$00
	sta player_score_mid,x
	bcc l167b
	inc score_mid_bonus_flag
	sec
l167b	lda player_score_hi,x
	adc #$00
	sta player_score_hi,x
	dey
	bne l1654
	cld
	lda #$00
	sta bonus_count_l2b84
	rts
	.endp

	.proc print_scores_and_energy
	lda savmsc
	sta zp_ptr
	lda savmsc+1
	sta zp_ptr+1
	ldy #$01
	ldx #$00
	jsr print_score
	ldy #$21
	ldx #$01
	jsr print_score
	ldy #$11
	ldx #$02
	jsr print_score
	jmp print_energy

	.proc print_score
	lda player_score_hi,x
	jsr print_bcd_at
	lda player_score_mid,x
	jsr print_bcd_at
	lda player_score_lo,x
	jsr print_bcd_at
	rts
	.endp
	.endp


	.proc print_bcd_at		;IN: <A>=BD value, <CB>=screen pointer, <Y>=screen pointer offset
	sta l28f2
	and #$f0
	lsr
	lsr
	lsr
	lsr
	clc
	adc #$10
	sta (zp_ptr),y
	iny
	lda l28f2
	and #$0f
	clc
	adc #$10
	sta (zp_ptr),y
	iny
	rts
	.endp

	.proc print_energy
	lda player_up
	bne player2

	lda #$5e			;Arrow left
	ldy #$0e
	sta (zp_ptr),y
	ldy #$19
	lda #$00
	sta (zp_ptr),y
	jmp players_done
player2	lda #$5f			;Arrow right
	ldy #$19
	sta (zp_ptr),y
	ldy #$0e
	lda #$00
	sta (zp_ptr),y
players_done
	ldx #$00			;player 0
	.if .def JAC_ENERGY
	ldy #$08
	lda player_energy_hi,x
	jsr print_bcd_at
	.endif
	ldy #$0a
	lda player_energy_lo,x
	jsr print_bcd_at

	ldx #$01			;player 1
	.if .def JAC_ENERGY
	ldy #$1a
	lda player_energy_hi,x
	jsr print_bcd_at
	.endif
	ldy #$1c
	lda player_energy_lo,x
	jsr print_bcd_at
	rts
	.endp

	.proc l1710
	ldx #$00
l1712	lda l2a10,x
	beq l176a
	cmp #$01
	bne l1721
	jsr l18bc
	jmp l176a
l1721	cmp #$02
	bne l172b
	jsr l18e9
	jmp l176a
l172b	cmp #$03
	bne l1735
	jsr l1945
	jmp l176a
l1735	cmp #$04
	bne l173f
	jsr l1967
	jmp l176a
l173f	cmp #$05
	bne l1749
	jsr l198b
	jmp l176a
l1749	cmp #$06
	bne l1753
	jsr l1a5e
	jmp l176a
l1753	cmp #$07
	bne l175d
	jsr l1b05
	jmp l176a
l175d	cmp #$0c
	bne l1767
	jsr l1b47
	jmp l176a
l1767	jsr l1ac3
l176a	inx
	cpx #$0d
	bmi l1712
	rts
	.endp

l1770	lda #$00
	sta l28f7
	beq l1777.l177c

	.proc l1777
	lda #$01
	sta l28f7
l177c	stx l28f4
	lda #$00
	sta l28f6
	lda l29b5,x
	asl
	tay
	lda screen_offsets_l28f8,y
	sta zp_ptr
	iny
	lda screen_offsets_l28f8,y
	sta zp_ptr+1
	lda l29a8,x
	clc
	ror
	ror l28f6
	ror
	ror l28f6
	adc zp_ptr
	sta zp_ptr
	lda zp_ptr+1
	adc #$00
	sta zp_ptr+1
	lsr l28f6
	lsr l28f6
	lsr l28f6
	lda #$03
	sta l28f5
	ldx l28f6
	ldy #$00
	lda l28f7
	bne l1823
	ldx l28f4
	lda l2a10,x
	cmp #$05
	bcs l17f8
	lda l2a03,x
	asl
	asl
	asl
	asl
	asl
	clc
	adc l28f6
	tax
l17d9	lda gfx_l257b,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	inx
	iny
	lda gfx_l257b,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	tya
	clc
	adc #$27
	tay
	inx
	dec l28f5
	bpl l17d9
	ldx l28f4
	rts
	.endp

	.proc l17f8
	sec
	sbc #$05
	asl
	asl
	asl
	asl
	asl
	adc l28f6
	tax
l1804	lda gfx_l267b,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	inx
	iny
	lda gfx_l267b,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	tya
	clc
	adc #$27
	tay
	inx
	dec l28f5
	bpl l1804
	ldx l28f4
	rts
	.endp

	.proc l1823
	lda l277b,x
	and (zp_ptr),y
	sta (zp_ptr),y
	inx
	iny
	lda l277b,x
	and (zp_ptr),y
	sta (zp_ptr),y
	tya
	clc
	adc #$27
	tay
	inx
	dec l28f5
	bpl l1823
	ldx l28f4
	rts
	.endp

	.proc l1842
	dec l29cf,x
	beq l184a
	jmp l18ad
l184a	lda l29c2,x
	and #$7f
	sta l29cf,x
	lda l29c2,x
	bmi l1867
	inc l29a8,x
	lda #$5b
	clc
	adc l29f6,x
	cmp l29a8,x
	bcc l1877
	bcs l18ad
l1867	dec l29a8,x
	lda #$41
	sec
	sbc l29f6,x
	cmp l29a8,x
	bcs l1877
	bcc l18ad
l1877	lda random
	and #$3f
	sta l29f6,x
	lda random
	and #$03
	sta l28f2
	bne l188c
	inc l28f2
l188c	lda l2b87
	beq l1894
	inc l28f2
l1894	lda l29c2,x
	and #$80
	eor #$80
	ora l28f2
	sta l29c2,x
	lda random
	and #$0c
	clc
	adc l2a6d
	sta l29e9,x
l18ad	dec l29dc,x
	bne l18bb
	inc l29b5,x
	lda l29e9,x
	sta l29dc,x
l18bb	rts
	.endp

	.proc l18bc
	jsr l1777
	jsr l1842
	jsr l1770
	jsr l1d62
	lda l29b5,x
	cmp #$56
	bne l18e8
	lda #$02
	sta l2a10,x
	lda #$05
	sta l2a03,x
	lda l29c2,x
	and #$80
	ora #$04
	sta l29c2,x
	and #$7f
	sta l29cf,x
l18e8	rts
	.endp

	.proc l18e9
	dec l29cf,x
	bne l1944
	jsr l1777
	lda l29c2,x
	bmi l190b
	and #$7f
	sta l29cf,x
	inc l29a8,x
	lda #$9b
	cmp l29a8,x
	bcs l1920
	lda #$00
	sta l2a10,x
	rts
	
l190b	dec l29a8,x
	and #$7f
	sta l29cf,x
	lda #$01
	cmp l29a8,x
	bcc l1920
	lda #$00
	sta l2a10,x
	rts
	
l1920	jsr l1770
	lda l29a8,x
	clc
	adc #$04
	lsr
	lsr
	lsr
	tay
	lda l2b51,y
	bne l1944
	jsr l2145
	lda #$03
	sta l2a10,x
	lda #$06
	sta l2a03,x
	lda #$02
	sta l29dc,x
l1944	rts
	.endp

	.proc l1945
	dec l29dc,x
	bne l1966
	inc l29dc,x
	inc l29dc,x
	jsr l1777
	dec l29b5,x
	lda #$05
	cmp l29b5,x
	bmi l1963
	lda #$00
	sta l2a10,x
	rts
l1963	jsr l1770
l1966	rts
	.endp

l1967	jsr l1777
	inc l29b5,x
	lda #$56
	cmp l29b5,x
	beq l1978
	jsr l1770
	rts
l1978	lda #$00
	sta l2a10,x
	lda l29a8,x
	clc
	adc #$04
	lsr
	lsr
	lsr
	tay
	jsr l2137
	rts
l198b	jsr l1777
	lda l2b6d
	bne l19d1
	lda l29b5,x
	cmp #$4f
	bcs l19d1
	lda l2b6c
	sec
	sbc #$06
	cmp #$c8
	bcc l19a6
	lda #$00
l19a6	cmp l29a8,x
	bne l19b1
	lda #$00
	sta l29c2,x
	clc
l19b1	bcs l19d1
	adc #$08
	cmp l29a8,x
	bcc l19d1
	cmp #$0b
	beq l19c3
	lda l29c2,x
	bmi l19ca
l19c3	inc l29a8,x
	jsr l1770
	rts
l19ca	dec l29a8,x
	jsr l1770
	rts
l19d1	dec l29cf,x
	bmi l19da
	jsr l1770
	rts
l19da	lda #$01
	sta l28f2
	stx l28f4
	ldx player_up
	lda player_score_hi,x
	cmp #$05
	bcc l19f1
	lda #$00
	sta l28f2
l19f1	ldx l28f4
	lda l28f2
	sta l29cf,x
	lda l29e9,x
	bmi l1a11
	lda l29b5,x
	cmp #$56
	bcs l1a11
	inc l29b5,x
	lda #$00
	sta l29e9,x
	jmp l1a28
l1a11	lda #$1b
	cmp l29b5,x
	bcc l1a20
	lda #$00
	sta l29e9,x
	jmp l1a28
l1a20	dec l29b5,x
	lda #$ff
	sta l29e9,x
l1a28	lda l29b5,x
	cmp #$4f
	bcs l1a38
	lda l2b6d
	bne l1a38
	jsr l1770
	rts
l1a38	lda l29a8,x
	cmp l2b65
	bne l1a44
	jsr l1770
	rts
l1a44	bcs l1a52
	lda #$00
	sta l29c2,x
	inc l29a8,x
	jsr l1770
	rts
l1a52	lda #$ff
	sta l29c2,x
	dec l29a8,x
	jsr l1770
	rts
l1a5e	jsr l1777
	dec l29cf,x
	beq l1a6a
	jsr l1770
	rts
l1a6a	lda #$02
	sta l29cf,x
	lda l29c2,x
	bmi l1a81
	inc l29a8,x
	lda #$9b
	cmp l29a8,x
	bcc l1a8e
	jmp l1a96
l1a81	dec l29a8,x
	lda #$01
	cmp l29a8,x
	bcs l1a8e
	jmp l1a96
l1a8e	lda l29c2,x
	eor #$80
	sta l29c2,x
l1a96	lda l29e9,x
	bmi l1aa9
	inc l29b5,x
	lda #$55
	cmp l29b5,x
	bcc l1ab7
	jsr l1770
	rts
l1aa9	dec l29b5,x
	lda #$0b
	cmp l29b5,x
	bcs l1ab7
	jsr l1770
	rts
l1ab7	lda l29e9,x
	eor #$80
	sta l29e9,x
	jsr l1770
	rts
l1ac3	jsr l1777
	lda l27b0
	bmi l1ada
	lda l27b1
	bmi l1ad5
	lda #$09
	jmp l1ae6
l1ad5	lda #$08
	jmp l1ae6
l1ada	lda l27b1
	bmi l1ae4
	lda #$0b
	jmp l1ae6
l1ae4	lda #$0a
l1ae6	sta l2a10,x
	lda l27ad
	sec
	sbc #$02
	sta l29a8,x
	lda l27ae
	sec
	sbc #$01
	sta l29b5,x
	jsr l1770
	lda #$01
	sta l1b04
	rts
l1b04	.byte $00
l1b05	jsr l1777
	lda l29cf,x
	bne l1b3e
	lda random
	and #$3f
	bne l1b20
	lda random
	and #$1f
	bne l1b20
	lda #$02
	sta l29cf,x
l1b20	ldy l27af
	lda l2b22,y
	sec
	sbc #$02
	sta l29a8,x
	lda l2af5,y
	sec
	sbc #$01
	sta l29b5,x
	jsr l1770
	lda #$01
	sta l1b46
	rts
l1b3e	lda #$01
	sta l1b46
	jmp l1a6a
l1b46	.byte $00
l1b47	dec l29cf,x
	bne l1b6a
	jsr l1777
	lda #$04
	sta l29cf,x
	inc l29b5,x
	jsr l1770
	dec l29dc,x
	bne l1b6a
	lda #$01
	sta l2a10,x
	sta l29cf,x
	sta l29dc,x
l1b6a	rts
l1b6b	lda l27ae
	cmp #$37
	bcs l1b7b
	lda l27ab
	bpl l1b7b
	jmp l1c29
	rts
l1b7b	lda #$00
	sta l27ab
	lda l27b0
	bmi l1b96
	inc l27ad
	lda #$5b
	clc
	adc l27b2
	cmp l27ad
	bcc l1ba7
	jmp l1bb7
l1b96	dec l27ad
	lda #$41
	sec
	sbc l27b2
	cmp l27ad
	bcs l1ba7
	jmp l1bb7
l1ba7	lda random
	and #$3f
	sta l27b2
	lda l27b0
	eor #$80
	sta l27b0
l1bb7	dec l27b4
	bne l1c28
	inc l27b4
	inc l27b4
	lda l27b1
	bmi l1bd6
	inc l27ae
	lda #$1b
	clc
	adc l27b3
	cmp l27ae
	bcc l1be5
	rts
l1bd6	dec l27ae
	lda #$18
	sec
	sbc l27b3
	cmp l27ae
	bcs l1be5
	rts
l1be5	lda random
	and #$0f
	sta l27b3
	lda l27b1
	eor #$80
	sta l27b1
	lda l27ae
	cmp #$51
	bcc l1c28
	ldx #$00
l1bfe	lda l2a10,x
	bne l1c23
	lda #$06
	sta l2a10,x
	lda l27ad
	sta l29a8,x
	lda #$52
	sta l29b5,x
	lda #$80
	sta l29e9,x
	lda #$96
	sta l29cf,x
	lda #$05
	sta l2a03,x
	rts
l1c23	inx
	cpx #$0d
	bmi l1bfe
l1c28	rts
l1c29	dec l27b4
	bne l1c28
	lda #$08			;Long break
	sta l27b4
	ldx player_up
	lda player_score_hi,x
	cmp #$07			;>70.000 points?
	bcc l1c42
	.if .not .def JAC_LONG_BREAK
	lda #$01
	sta l27b4			;Short break
	.endif
l1c42	lda l27ac
	bne l1c53
	lda l27b0
	eor #$80
	sta l27b0
	inc l27ac
	rts
l1c53	cmp #$01
	bne l1c63
	lda l27b1
	eor #$80
	sta l27b1
	inc l27ac
	rts
l1c63	cmp #$02
	bne l1c73
	lda l27b0
	eor #$80
	sta l27b0
	inc l27ac
	rts
l1c73	cmp #$03
	bne l1c83
	lda l27b1
	eor #$80
	sta l27b1
	inc l27ac
	rts
l1c83	ldx #$00
l1c85	lda l2a10,x
	bne l1cce
	lda #$0c
	sta l2a10,x
	lda l27ad
	sta l29a8,x
	lda random
	and #$83
	sta l29c2,x
	inc l29c2,x
	dec l29a8,x
	lda l27ae
	sta l29b5,x
	lda #$04
	sta l2a03,x
	lda #$01
	sta l29cf,x
	lda #$06
	sta l29dc,x
	lda #$0c
	sta l29e9,x
	lda random
	and #$3f
	sta l29f6,x
	lda #$00
	sta l27ac
	sta l27ab
	rts
l1cce	inx
	cpx #$0d
	bmi l1c85
	lda #$00
	sta l27ac
	sta l27ab
	rts
l1cdc	ldy #$00
	lda l27af
	clc
	adc #$04
	cmp #$2d
	bcc l1ceb
	sec
	sbc #$2c
l1ceb	tax
	lda l2a6e,x
	sta zp_ptr
	lda l2a9b,x
	sta zp_ptr+1
	lda l2ac8,x
	tax
	lda masks.or_l279f,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	ldx l27af
	lda l2a6e,x
	sta zp_ptr
	lda l2a9b,x
	sta zp_ptr+1
	lda l2ac8,x
	tax
	lda masks.and_l27a3,x
	and (zp_ptr),y
	sta (zp_ptr),y
	ldx l27af
	lda l27ae
	sta l2af5,x
	asl
	tay
	lda #$00
	sta l28f6
	lda l27ad
	sta l2b22,x
	ror
	ror l28f6
	ror
	ror l28f6
	clc
	adc screen_offsets_l28f8,y
	sta l2a6e,x
	sta zp_ptr
	iny
	lda screen_offsets_l28f8,y
	adc #$00
	sta l2a9b,x
	sta zp_ptr+1
	lda l28f6
	lsr
	lsr
	lsr
	lsr
	lsr
	lsr
	sta l2ac8,x
	dec l27af
	bne l1d61
	lda #$2c
	sta l27af
l1d61	rts
l1d62	lda l2a03,x
	bne l1d6a
	jmp l1dea
l1d6a	lda random
	ldy l29b5,x
	cpy #$0a
	bpl l1d7d
	and #$ff
	cmp #$ff
	beq l1da0
	jmp l1dea
l1d7d	cpy #$14
	bpl l1d8a
	and #$7f
	cmp #$7f
	beq l1da0
	jmp l1dea
l1d8a	cpy #$23
	bpl l1d97
	and #$3f
	cmp #$3f
	beq l1da0
	jmp l1dea
l1d97	and #$1f
	cmp #$1f
	beq l1da0
	jmp l1dea
l1da0	dec l2a03,x
	ldy #$00
l1da5	lda l2a59,y
	cmp #$56
	bpl l1db3
	iny
	cpy #$14
	bmi l1da5
	bpl l1dea
l1db3	lda zp_ptr
	clc
	adc #$a0
	sta l2a31,y
	lda zp_ptr+1
	adc #$00
	sta l2a1d,y
	lda l28f6
	lsr
	lsr
	lsr
	eor #$02
	sta l2a45,y
	stx l28f4
	and #$02
	bne l1dde
	tya
	tax
	inc l2a31,x
	bne l1dde
	inc l2a1d,x
l1dde	ldx l28f4
	lda l29b5,x
	clc
	adc #$04
	sta l2a59,y
l1dea	rts
l1deb	ldx #$00
l1ded	lda l2a59,x
	cmp #$56
	bpl l1df7
	jsr l1dfd
l1df7	inx
	cpx #$14
	bmi l1ded
	rts
l1dfd	inc l2a59,x
	lda l2a31,x
	sta zp_ptr
	clc
	adc #$28
	sta l2a31,x
	lda l2a1d,x
	sta zp_ptr+1
	adc #$00
	sta l2a1d,x
	ldy l2a45,x
	lda masks.and_l27a3,y
	sty l28f3
	ldy #$00
	and (zp_ptr),y
	sta (zp_ptr),y
	lda l2a59,x
	cmp #$56
	bpl l1e41
	lda l2a31,x
	sta zp_ptr
	lda l2a1d,x
	sta zp_ptr+1
	ldy l28f3
	lda masks.or_l279b,y
	ldy #$00
	ora (zp_ptr),y
	sta (zp_ptr),y
l1e41	rts
l1e42	jsr l1e68
	jsr l2189
	jsr l2101
	jsr l21fa
	jsr l1e60
	jsr l20d8
	jsr l1e58
	rts
l1e58	lda #$00
	sta l28f7
	jmp l1e6d
l1e60	lda #$01
	sta l28f7
	jmp l1e6d
l1e68	lda #$02
	sta l28f7
l1e6d	clc
	lda #$00
	sta l28f6
	lda l2b65
	ror
	ror l28f6
	ror
	ror l28f6
	clc
	adc l2b66
	sta zp_ptr
	lda l2b67
	adc #$00
	sta zp_ptr+1
	lsr l28f6
	lsr l28f6
	lsr l28f6
	lda l28f7
	cmp #$02
	beq l1ebf
	cmp #$01
	beq l1edf
	ldx l28f6
	ldy #$28
l1ea4	lda gfx_l27b9,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	inx
	iny
	lda gfx_l27b9,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	tya
	clc
	adc #$27
	tay
	inx
	cpy #$a4
	bcc l1ea4
	rts
l1ebf	ldy #$00
	ldx l28f6
	.if .def JAC_SPEED		;Speed 
	clc
	.endif
l1ec4	lda gfx_l27f9,x
	and (zp_ptr),y
	bne l1eff
	inx
	iny
	lda gfx_l27f9,x
	and (zp_ptr),y
	bne l1eff
	inx
	tya
	.if .not .def JAC_SPEED		;<C>=0
	clc
	.endif
	adc #$27
	tay
	cpy #$7c
	bcc l1ec4
	rts
l1edf	ldy #$28
	ldx l28f6
	.if .def JAC_SPEED		;Speed optimization
	clc
	.endif
l1ee4	lda gfx_l27d9,x
	and (zp_ptr),y
	sta (zp_ptr),y
	inx
	iny
	lda gfx_l27d9,x
	and (zp_ptr),y
	sta (zp_ptr),y
	inx
	tya
	.if .not .def JAC_SPEED		;<C>=0
	clc
	.endif
	adc #$27
	tay
	cpy #$a4
	bcc l1ee4
	rts
l1eff	pla
	pla
	pla
	pla
	lda zp_ptr
	sta l2b68
	lda zp_ptr+1
	sta l2b69
	lda #$00
	sta audc1
	sta audc2
	ldx player_up
	ldy bonus_count_l2b84
	beq l1f23
	jsr count_l1653
	jsr print_scores_and_energy
l1f23	lda #$8c
	sta l28f5
	lda #$5a
	sta audf1
	jsr l1e60
	lda #$0d
	sta l2b6e
l1f35	lda #$fa
	sta rtclok+2
	lda l28f5
	sta audc1
	dec l28f5
	jsr l23b7
	lda l2b6e
	beq l1f51
l1f4a	lda rtclok+2
	bne l1f4a
	jmp l1f35

l1f51	lda #$00
	sta audc1
	ldy #$13
l1f58	sty l28f3
	lda l2b51,y
	bne l1f94
	jsr l2145
	ldx player_up
	sed
	lda player_energy_lo,x
	clc
	adc #$01

	.if .not .def JAC_ENERGY
	cld				;Normal cap at $99
	bcc l1f72
	lda #$99
l1f72	sta player_energy_lo,x
	.else
	sta player_energy_lo,x		;Extended cap at $9999
	lda player_energy_hi,x
	adc #0
	sta player_energy_hi,x
	bcc no_overflow
	lda #$99
	sta player_energy_lo,x
	sta player_energy_hi,x
no_overflow
	cld
	.endif

	jsr print_scores_and_energy
	lda #$0a
	sta audf1
	lda #$aa
	sta audc1
	ldx #$02
l1f84	lda #delay_fc
	sta rtclok+2
wait_l1f88
	lda rtclok+2
	bne wait_l1f88
	lda #$00
	sta audc1
	dex
	bne l1f84
l1f94	ldy l28f3
	dey
	bpl l1f58
	lda #delay_e1
	sta rtclok+2
wait_l1f9e
	lda rtclok+2
	bne wait_l1f9e
	jsr l2084

	.proc reduce_energy
	ldy #$05
l1fa7	sty l28f3
	ldx player_up
	lda player_energy_lo,x
	.if .def JAC_ENERGY
	ora player_energy_hi,x
	.endif
	beq out_of_energy_l1fec
	.if .def JAC_ENERGY
	lda player_energy_lo,x
	.endif
	sed
	sec
	sbc #$01
	.if .not .def JAC_ENERGY
	cld
	sta player_energy_lo,x
	.else
	sta player_energy_lo,x
	lda player_energy_hi,x
	sbc #0
	sta player_energy_hi,x
	ora player_energy_lo,x
	cld
	.endif

	beq out_of_energy_l1fec
	jsr print_scores_and_energy
	lda #$c8
	sta audf1
	lda #$ac
	sta audc1
	ldx #$02
l1fcb	lda #delay_fc
	sta rtclok+2
l1fcf	lda rtclok+2
	bne l1fcf
	lda #$00
	sta audc1
	dex
	bne l1fcb
	ldy l28f3
	dey
	bne l1fa7
	jsr print_scores_and_energy
	lda #$50
	sta l28f2
	jmp out_of_energy_l1fec.l201a
	.endp

	.proc out_of_energy_l1fec
	jsr print_scores_and_energy
	lda #$14
	sta l28f2
	lda #$ac
	sta audc1
l1ff9	lda l28f2
	sta audf1
	lda #$01
	sta atract
	lda #$ff
	sta rtclok+2
l2007	lda rtclok+2
	bne l2007
	inc l28f2
	lda l28f2
	cmp #$b4
	bne l1ff9
	lda #$00
	sta audc1

l201a	ldx player_up

 	.if .def JAC_ENERGY
	lda player_energy_hi,x
	bne more_than_21
	.endif
 
	lda player_energy_lo,x
	cmp #$21
	bcc less_than_21
 
more_than_21
	.if .def JAC_ENERGY
	lda player_energy_lo,x		;Ensure <A> contains the correct value in case we branched here from the high byte check
	.endif

	sed
	sec
	sbc #$01
	sta player_energy_lo,x
 
	.if .def JAC_ENERGY
	lda player_energy_hi,x
	sbc #$00
 	sta player_energy_hi,x
	.endif

	lda player_score_mid,x
	clc
	adc #$02
	sta player_score_mid,x
	bcc l203a
	inc score_mid_bonus_flag
	sec
l203a	lda player_score_hi,x
	adc #$00
	sta player_score_hi,x
	cld
	jsr print_scores_and_energy
	lda #$64
	sta audf1
	lda #$aa
	sta audc1
	ldx #$01
l2052	lda #delay_fa
	sta rtclok+2
l2056	lda rtclok+2
	bne l2056
	lda #$28
	sta audf1
	dex
	bpl l2052
	lda #$01
	sta atract
	jmp l201a

less_than_21
	lda #$00
	sta audc1
	lda score_mid_bonus_flag
	beq l2079
	jsr l2084
	jmp l201a

l2079	lda #$e1
	sta rtclok+2
l207d	lda rtclok+2
	bne l207d
	jmp l13f5
	.endp

	.proc l2084
	lda score_mid_bonus_flag
	bne l208a
	rts
l208a	lda #$64
	sta audf1
	sta l28f3
	lda #$aa
	sta audc1
	lda #$05
	sta l28f5
l209c	ldx player_up
	lda player_energy_lo,x
	sed
	clc
	adc #$01

	.if .not .def JAC_ENERGY
	.if .def JAC
	bcc no_overflow			;Normal cap at $99
	lda #$99
no_overflow
	.endif
	sta player_energy_lo,x
	.else
	sta player_energy_lo,x		;Extended cap at $9999
	lda player_energy_hi,x
	adc #0
	sta player_energy_hi,x
	bcc no_overflow
	lda #$99
	sta player_energy_lo,x
	sta player_energy_hi,x
no_overflow
	.endif

	cld
	jsr print_scores_and_energy
	ldx #$0a
l20af	lda #$fe
	sta rtclok+2
l20b3	lda rtclok+2
	bne l20b3
	lda l28f3
	sec
	sbc #$07
	sta l28f3
	sta audf1
	lda #$01
	sta atract
	dex
	bne l20af
	dec l28f5
	bne l209c
	lda #$00
	sta score_mid_bonus_flag
	sta audc1
	rts
	.endp
	
l20d8	lda stick0
	cmp #$08
	bpl l20ee
	lda #$01
	sta atract
	lda #$9a
	cmp l2b65
	bcc l2100
	inc l2b65
	rts

l20ee	cmp #$0c
	bpl l2100
	lda #$01
	sta atract
	lda #$01
	cmp l2b65
	bcs l2100
	dec l2b65
l2100	rts

l2101	lda stick0
	cmp #$0e
	beq l2109
	rts
l2109	lda l2b71
	cmp #$10
	bcc l2111
	rts
l2111	lda l2b65
	clc
	adc #$04
	lsr
	lsr
	lsr
	tay
	lda l2b51,y
	beq l2121
	rts
l2121	jsr l2145
	lda l2b71
	clc
	adc #$05
	cmp #$14
	bcc l2130
	lda #$14
l2130	sta l2b71
	jsr l2437
	rts
l2137	lda #$00
	sta l2b51,y
	sta l28f7
	inc l2b86
	jmp l2157
l2145	lda #$01
	sta l2b51,y
	sta l28f7
	dec l2b86
	bpl l2157
	lda #$00
	sta l2b86
l2157	sty l28f3
	tya
	asl
	adc l2b4f
	sta zp_ptr
	lda l2b50
	adc #$00
	sta zp_ptr+1
	ldy #$00
	lda l28f7
	bne l2175
	lda l27b5
	jmp l2178
l2175	lda l27b6
l2178	sta (zp_ptr),y
	ldy #$28
	sta (zp_ptr),y
	ldy #$50
	sta (zp_ptr),y
	ldy l28f3
	ldx l28f4
	rts
l2189	lda strig0
	bne l21f9
	lda l2b6d
	beq l21f9
	lda l2b6e
	bne l21f9
	lda l2b71
	beq l21f9
	lda #$00
	sta l2b6d
	lda l28f6
	lsr
	lsr
	lsr
	cmp #$02
	bpl l21bf
	clc
	adc #$02
	sta l2b6a
	lda zp_ptr
	sta l2b68
	lda zp_ptr+1
	sta l2b69
	jmp l21d4
l21bf	sec
	sbc #$02
	sta l2b6a
	lda zp_ptr
	clc
	adc #$01
	sta l2b68
	lda zp_ptr+1
	adc #$00
	sta l2b69
l21d4	lda l2b68
	sec
	sbc #$50
	sta l2b68
	lda l2b69
	sbc #$00
	sta l2b69
	lda #$50
	sta l2b6b
	lda l2b65
	clc
	adc #$02
	sta l2b6c
	dec l2b71
	jsr l2437
l21f9	rts
l21fa	lda l2b6e
	beq sprite_l2203
	jsr l23b7
	rts
	
	.proc sprite_l2203
	lda l2b6d
	bne sprite_l2257.l2278
	dec l2b6b
	dec l2b6b
	lda l2b6b
	cmp #$05
	bcc sprite_l2257
	lda l2b6a
	eor #$01
	sta l2b6a
	tax
	lda #$02
	sta l28f5
l2223	lda l2b68
	sec
	sbc #$28
	sta zp_ptr
	sta l2b68
	lda l2b69
	sbc #$00
	sta zp_ptr+1
	sta l2b69
	ldy #$00
	lda masks.and_l27a7,x
	and (zp_ptr),y
	bne score_l2279
	lda masks.or_l279b,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	ldy #$a0
	lda gfx_l2819,x
	and (zp_ptr),y
	sta (zp_ptr),y
	dec l28f5
	bne l2223
	rts
	.endp

	.proc sprite_l2257
	ldy #$00
	ldx l2b6a
	lda l2b68
	sta zp_ptr
	lda l2b69
	sta zp_ptr+1
	.if .def JAC_SPEED		;Speed 
	clc
	.endif
l2266	lda #$00
	and (zp_ptr),y
	sta (zp_ptr),y
	tya
	.if .not .def JAC_SPEED		;<C>=0
	clc
	.endif
	adc #$28
	tay
	cpy #$c8
	bne l2266
	inc l2b6d
l2278	rts
	.endp

	.proc score_l2279
	ldx #$00
l227b	lda l2a10,x
	bne l2283
	jmp l231f
l2283	lda l29b5,x
	sec
	sbc #$04
	cmp l2b6b
	bcc l2291
	jmp l231f
l2291	adc #$0a
	cmp l2b6b
	bcs l229b
	jmp l231f
l229b	lda l29a8,x
	sbc #$04
	cmp #$c8
	bcc l22a6
	lda #$00
l22a6	cmp l2b6c
	bcc l22ae
	jmp l231f
l22ae	adc #$0b
	cmp l2b6c
	bcc l231f
	jsr l1777
	inc l257a
	lda l2a10,x
	cmp #$03
	bne l22dd
	lda bonus_count_l2b84
	beq l22ca
	clc
	adc #$0a
l22ca	clc
	adc #$05
	sta bonus_count_l2b84
	lda #$04
	sta l2a10,x
	lda #$07
	sta l2a03,x
	jmp l231f

l22dd	lda l2a10,x
	cmp #$01
	beq l2309
	cmp #$0c
	beq l2309
	cmp #$05
	bcs l22f5
	inc l23b6
	dec l257a
	jmp l231a
l22f5	inc l257a
	cmp #$05
	bne l22ff
	inc l257a
l22ff	cmp #$07
	bne l2309
	inc l257a
	inc l257a
l2309	lda bonus_count_l2b84
	beq l2311
	clc
	adc #$0a
l2311	clc
	adc #$05
	adc l2a03,x
	sta bonus_count_l2b84
l231a	lda #$00
	sta l2a10,x
l231f	inx
	cpx #$0d
	bpl l2327
	jmp l227b
l2327	lda #$00
	sta l28f5
	ldy #$14
l232e	lda l2a59,y
	cmp #$54
	bcs l233d
	lda l2b68
	cmp l2a31,y
	beq l2395
l233d	dey
	bpl l232e
	lda l28f5
	bne l23a8
	lda l257a
	bne l23a8
	lda l2b87
	bne l23a8
	lda l23b6
	bne l23a8

	ldx player_up
	lda player_score_hi,x
	bne l2363
	lda player_score_mid,x
	cmp #$50
	bcc l23a8
l2363	ldx #$00
l2365	lda l2a10,x
	bne l238d
	lda #$05
	sta l2a10,x
	lda l2b6c
	sta l29a8,x
	lda l2b6b
	sta l29b5,x
	lda #$00
	sta l29e9,x
	lda #$32
	sta l29cf,x
	lda #$0f
	sta l2a03,x
	jmp l23a8
l238d	inx
	cpx #$0d
	bmi l2365
	jmp l23a8
l2395	lda l2b69
	cmp l2a1d,y
	bne l233d
	lda #$57
	sta l2a59,y
	inc l28f5
	jmp l233d
l23a8	lda #$00
	sta l23b6
	jsr sprite_l2257
	lda #$0f
	sta l2b6e
	rts
	.endp

l23b6	.byte $00

	.proc l23b7
	lda l2b68
	sec
	sbc #$a0
	sta zp_ptr
	lda l2b69
	sbc #$00
	sta zp_ptr+1
	ldy #$00
	ldx #$00
l23ca	lda gfx_l288a,x
	and (zp_ptr),y
	sta (zp_ptr),y
	inx
	iny
	lda gfx_l288a,x
	and (zp_ptr),y
	sta (zp_ptr),y
	inx
	tya
	clc
	adc #$27
	tay
	cpx #$0e
	bmi l23ca
	dec l2b6e
	bne sprite_l240b
	lda l257a
	cmp #$02
	bcc l2405
	ldx #$50
	ldy #$00
	jsr sprite_l2537
	ldx #$50
	ldy #$01
	jsr sprite_l2537
	ldx #$50
	ldy #$02
	jsr sprite_l2537
l2405	lda #$00
	sta l257a
	rts
	.endp

	.proc sprite_l240b
	lda l2b6e
	clc
	adc #$01
	lsr
	tax
	lda #$f2
l2415	clc
	adc #$0e
	dex
	bne l2415
	tax
	ldy #$00
	.if .def JAC_SPEED		;Speed 
	clc
	.endif
l241e	lda gfx_l2828,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	inx
	iny
	lda gfx_l2828,x
	ora (zp_ptr),y
	sta (zp_ptr),y
	inx
	tya
	.if .not .def JAC_SPEED		;<C>=0
	clc
	.endif
	adc #$27
	tay
	bcc l241e
	rts
	.endp

	.proc l2437
	lda l2b6f
	sta zp_ptr
	lda l2b70
	sta zp_ptr+1
	ldy #$00
	ldx l2b71
	beq l2452
l2448	lda #$aa
	ora (zp_ptr),y
	sta (zp_ptr),y
	iny
	dex
	bpl l2448
l2452	lda #$00
	and (zp_ptr),y
	sta (zp_ptr),y
	iny
	cpy #$14
	bcc l2452
	ldy #$00
	.if .def JAC_SPEED		;Speed 
	clc
	.endif
l245f	lda #$05
	ora (zp_ptr),y
	sta (zp_ptr),y
	tya
	.if .not .def JAC_SPEED		;<C>=0
	clc
	.endif
	adc #$05
	tay
	cpy #$15
	bcc l245f
	rts
	.endp

	.proc l246f
	dec l2b89
	lda #$13
;	lda #$02
//TODO $02/$12 Paul lay??!?!
	sta skctl
	sta sskctl
	lda l2b6d
	beq l248c
	lda l2b6e
	bne l24b0
	lda #$a0
	sta audc1
	jmp l24ff
l248c	lda l2b6b
	lsr
	lsr
	lsr
	clc
	adc #$a3
	sta audc1
	lda l2b89
	and #$02
	beq l24a2
	jmp l251f
l24a2	lda l255d
	eor #$08
	sta l255d
	sta audf1
	jmp l251f
l24b0	lda #$aa
	sta audc1
	lda l257a
	beq l24e7
	cmp #$01
	beq l24f3
	ldx l2b6e
	lda l256c,x
	sta audf1
	lda l257a
	sec
	sbc #$01
	asl
	asl
	asl
	tax
	ldy #$00
	jsr sprite_l2537
	ldx #$00
	ldy #$01
	jsr sprite_l2537
	ldx #$00
	ldy #$02
	jsr sprite_l2537
	jmp l251f
l24e7	lda l2b6e
	clc
	adc #$05
	sta audf1
	jmp l251f
l24f3	ldx l2b6e
	lda l255e,x
	sta audf1
	jmp l251f
l24ff	lda l2b71
	cmp #$03
	bcs l251f
	lda l2b89
	and #$08
	beq l2515
	lda #$a0
	sta audc1
	jmp l251f
l2515	lda #$a8
	sta audc1
	lda #$1e
	sta audf1
l251f	lda l27ac
	bne l252c
	lda #$00
	sta audc2
	jmp l2536
l252c	lda #$66
	sta audc2
	lda #$78
	sta audf2
l2536	rts
	.endp

	.proc sprite_l2537
	lda l2b6b
	cmp #$0f
	bcc l246f.l2536
	lda l2b68
	sec
	sbc #$68
	sta zp_ptr
	lda l2b69
	sbc #$01
	sta zp_ptr+1
	.if .def JAC_SPEED		;Speed 
	clc
	.endif
l254d	lda gfx_l2898,x
	sta (zp_ptr),y
	tya
	.if .not .def JAC_SPEED		;<C>=0
	clc
	.endif
	adc #$28
	tay
	inx
	cpy #$a5
	bcc l254d
	rts
	.endp

l255d	.byte $37

	.local l255e
	.byte $ff,$ff,$f0,$e1,$b9,$96,$78,$5f,$4b,$3c,$31,$27,$1e,$16
	.endl

	.local l256c
	.byte $05,$05,$0f,$0f,$1e,$1e,$2d,$2d,$3c,$3c,$4b,$4b,$55,$55
	.endl

l257a	.byte $00

	.local gfx_l257b
	.byte $33,$00,$bf,$80,$3f,$00,$c0,$c0,$0c,$c0,$2f,$e0,$0f,$c0,$30,$30
	.byte $03,$30,$0b,$f8,$03,$f0,$0c,$0c,$00,$cc,$02,$fe,$00,$fc,$03,$03
	.byte $33,$00,$bf,$80,$3f,$00,$c8,$c0,$0c,$c0,$2f,$e0,$0f,$c0,$32,$30
	.byte $03,$30,$0b,$f8,$03,$f0,$0c,$8c,$00,$cc,$02,$fe,$00,$fc,$03,$23
	.byte $33,$00,$bf,$80,$3b,$00,$c8,$c0,$0c,$c0,$2f,$e0,$0e,$c0,$32,$30
	.byte $03,$30,$0b,$f8,$03,$b0,$0c,$8c,$00,$cc,$02,$fe,$00,$ec,$03,$23
	.byte $33,$00,$bf,$80,$2b,$00,$c8,$c0,$0c,$c0,$2f,$e0,$0a,$c0,$32,$30
	.byte $03,$30,$0b,$f8,$02,$b0,$0c,$8c,$00,$cc,$02,$fe,$00,$ac,$03,$23
	.byte $33,$00,$bf,$80,$2a,$00,$c8,$c0,$0c,$c0,$2f,$e0,$0a,$80,$32,$30
	.byte $03,$30,$0b,$f8,$02,$a0,$0c,$8c,$00,$cc,$02,$fe,$00,$a8,$03,$23
	.byte $33,$00,$ff,$c0,$3f,$00,$c0,$c0,$0c,$c0,$3f,$f0,$0f,$c0,$0c,$30
	.byte $03,$30,$0b,$f8,$03,$f0,$0c,$30,$00,$cc,$02,$fe,$00,$fc,$03,$03
	.byte $33,$00,$bf,$80,$2a,$00,$ea,$c0,$0c,$c0,$2f,$e0,$0a,$80,$3a,$b0
	.byte $03,$30,$0b,$f8,$02,$a0,$0e,$ac,$00,$cc,$02,$fe,$00,$a8,$03,$ab
	.byte $00,$00,$2a,$00,$2a,$00,$2a,$00,$00,$00,$0a,$80,$0a,$80,$0a,$80
	.byte $00,$00,$02,$a0,$02,$a0,$02,$a0,$00,$00,$00,$a8,$00,$a8,$00,$a8
	.endl

	.local gfx_l267b
	.byte $31,$00,$39,$00,$39,$00,$08,$00,$03,$00,$03,$00,$03,$00,$02,$00
	.byte $01,$30,$01,$b0,$01,$b0,$00,$80,$00,$10,$00,$10,$00,$10,$00,$20
	.byte $08,$00,$15,$00,$a5,$40,$15,$00,$02,$00,$05,$40,$1a,$50,$05,$40
	.byte $00,$c0,$01,$50,$05,$a4,$01,$50,$00,$30,$00,$54,$01,$5a,$00,$54
	.byte $08,$00,$08,$00,$08,$00,$00,$00,$00,$80,$02,$00,$08,$00,$00,$00
	.byte $00,$00,$02,$a0,$00,$00,$00,$00,$00,$80,$00,$20,$00,$08,$00,$00
	.byte $00,$00,$82,$00,$a2,$80,$00,$00,$00,$00,$20,$80,$28,$a0,$00,$00
	.byte $00,$00,$08,$20,$0a,$28,$00,$00,$00,$00,$02,$08,$02,$8a,$00,$00
	.byte $00,$00,$a2,$80,$82,$00,$00,$00,$00,$00,$28,$a0,$20,$80,$00,$00
	.byte $00,$00,$0a,$28,$08,$20,$00,$00,$00,$00,$02,$8a,$02,$08,$00,$00
	.byte $00,$00,$20,$80,$a2,$80,$00,$00,$00,$00,$08,$20,$28,$a0,$00,$00
	.byte $00,$00,$02,$08,$0a,$28,$00,$00,$00,$00,$00,$82,$02,$8a,$00,$00
	.byte $00,$00,$a2,$80,$20,$80,$00,$00,$00,$00,$28,$a0,$08,$20,$00,$00
	.byte $00,$00,$0a,$28,$02,$08,$00,$00,$00,$00,$02,$8a,$00,$82,$00,$00
	.byte $00,$00,$80,$80,$00,$00,$00,$00,$00,$00,$20,$20,$00,$00,$00,$00
	.byte $00,$00,$08,$08,$00,$00,$00,$00,$00,$00,$02,$02,$00,$00,$00,$00
	.endl

	.local l277b
	.byte $c0,$ff,$00,$3f,$00,$3f,$00,$3f,$f0,$3f,$c0,$0f,$c0,$0f,$c0,$0f
	.byte $fc,$0f,$f0,$03,$f0,$03,$f0,$03,$ff,$03,$fc,$00,$fc,$00,$fc,$00
	.endl

	.local masks
or_l279b	.byte $80,$20,$08,$02
or_l279f	.byte $40,$10,$04,$01
and_l27a3	.byte $3f,$cf,$f3,$fc
and_l27a7	.byte $c0,$30,$0c,$03
	.endl

l27ab	.byte $00
l27ac	.byte $00
l27ad	.byte $50
l27ae	.byte $0a
l27af	.byte $2c
l27b0	.byte $80
l27b1	.byte $00
l27b2	.byte $0a
l27b3	.byte $0a
l27b4	.byte $02
l27b5	.byte $2a
l27b6	.byte $00

screen_spec	.byte 'S:'

	.local gfx_l27b9
	.byte $08,$00,$15,$00,$15,$00,$c0,$c0,$02,$00,$05,$40,$05,$40,$0c,$30
	.byte $00,$80,$01,$50,$01,$50,$0c,$30,$00,$20,$00,$54,$00,$54,$03,$03
	.endl

	.local gfx_l27d9
	.byte $f3,$ff,$c0,$ff,$c0,$ff,$00,$3f,$fc,$ff,$f0,$3f,$f0,$3f,$c0,$0f
	.byte $ff,$3f,$fc,$0f,$fc,$0f,$f0,$03,$ff,$cf,$ff,$03,$ff,$03,$fc,$00
	.endl

	.local gfx_l27f9
	.byte $3f,$00,$f3,$c0,$c0,$c0,$c0,$c0,$0f,$c0,$3c,$f0,$30,$30,$30,$30
	.byte $03,$f0,$0f,$3c,$0c,$0c,$0c,$0c,$00,$fc,$03,$cf,$03,$03,$03,$03
	.endl

	.local gfx_l2819
	.byte $3f,$cf,$f3,$fc
	.endl

	.local gfx_l281d
	.byte $30,$32,$25,$33,$33,$00,$26,$29,$32,$25,$ff
	.endl

	.local gfx_l2828
	.byte $40,$01,$13,$c4,$00,$00,$30,$0c,$00,$00,$13,$c4,$40,$01,$40,$01
	.byte $10,$04,$07,$d0,$1c,$34,$07,$d0,$10,$04,$40,$01,$80,$02,$11,$44
	.byte $05,$90,$16,$74,$06,$50,$11,$44,$80,$02,$00,$00,$21,$48,$0a,$60
	.byte $26,$98,$09,$a0,$21,$48,$00,$00,$00,$00,$22,$88,$0a,$a0,$2a,$a8
	.byte $0a,$a0,$22,$88,$00,$00,$00,$00,$02,$80,$0a,$a0,$2a,$a8,$0a,$a0
	.byte $02,$80,$00,$00,$00,$00,$00,$00,$02,$80,$0a,$a0,$02,$80,$00,$00
	.byte $00,$00
	.endl

	.local gfx_l288a
	.byte $3f,$fc,$cc,$33,$f0,$0f,$c0,$03,$f0,$0f,$cc,$33,$3f,$fc
	.endl

	.local gfx_l2898
	.byte $a8,$88,$88,$88,$a8,$00,$00,$00,$08,$08,$08,$08,$08,$00,$00,$00
	.byte $a8,$08,$a0,$80,$a8,$00,$00,$00,$a8,$08,$28,$08,$a8,$00,$00,$00
	.byte $80,$88,$a8,$08,$08,$00,$00,$00,$a8,$80,$28,$08,$a8,$00,$00,$00
	.byte $80,$80,$a8,$88,$a8,$00,$00,$00,$a8,$08,$08,$08,$08,$00,$00,$00
	.byte $a8,$88,$a8,$88,$a8,$00,$00,$00,$a8,$88,$a8,$08,$08,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$ea
	.endl

l28f1	.byte $00
l28f2	.byte $00
l28f3	.byte $00
l28f4	.byte $00
l28f5	.byte $00
l28f6	.byte $00
l28f7	.byte $00

;	Based on Feedback by Paul Lay. Fix for bug in the original game. 
; 	When a snake plants a saucer it was accessing off the end of the table
;	and ended up rampling some zero page memory.
;	Table of screen memory offsets is used with indexes up to $ae/$af
;	so it must be filled to that extend also to prevent overwriting the ZP. 

	.local screen_offsets_l28f8
	.if .def JAC
:$b0	.byte 0
	.else
:$ae	.byte 0				;Bug in the original, space for 1 pair of lo/hi bytes missing
	.endif
	.endl

end_of_code
	.print end_of_code
	.if end_of_code>first_fixed
	.error "Code is ", end_of_code-first_fixed, " bytes too far at ",end_of_code
	.endif

	.endp				;End of main
