#!/bin/sh
export CC65_HOME=/usr/share/cc65

echo "Creating main assembler source: main.c to clm1.asm ..."
cc65 -O2 -t atari  -o build/clm1.asm main.c 

#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi

echo "Assembling main source: clm1.asm to clm1.o ..."
ca65 -t atari -o build/clm1.o build/clm1.asm

#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi

echo "Assembling the supplementary routines: rmt_sup.asm to clm_sup.o ..."
ca65 -t atari -o build/clm_sup.o rmt_sup.asm

#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi

echo "Linking: clm1.o and clm_sup.o to clm1.xex"
cl65 -t atari --start-addr 11776 -o build/clm1.xex build/clm_sup.o build/clm1.o 

#if failed, then terminate processing
if [ $? -ne 0 ]
then
  exit 1
fi

