; "Duszpasterz Jan Rzygon" for Atari 8-bit by mgr_inz_rafal

; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see <http:;www.gnu.org/licenses/>.

;	@com.wudsn.ide.asm.mainsourcefile=main.asm

ADVMSG_COLOR_BCKG		equ $ca
ADVMSG_COLOR_TEXT		equ $c2

TITLE_COLOR_BCKG		equ $00
TITLE_COLOR_TEXT		equ $0f

.var	adv_color_1		.byte
.var	adv_color_2		.byte
.var	adv_color_3		.byte

; Displays the picture for the current adventure message
.proc display_adventure_picture
				build_advmap_picture_file_name
				io_find_free_iocb
				io_open_file_OPT1
				io_read_binary #screen_mem #40*40
				io_read_binary #adv_color_1 #3
				io_close_file
				rts
.endp

; Builds the adventure message font filename in the io_buffer
.proc build_advmap_font_file_name
				ldx #0
@				lda advmsg_font,x
				sta io_buffer+$60,x
				inx
				cpx #12
				bne @-
				lda #$9b
				sta io_buffer+$60,x
				rts
.endp

; Builds the adventure message picture filename in the io_buffer
.proc build_advmap_picture_file_name
				ldy #0
				lda #'D'
				sta io_buffer
				lda #':'
				sta io_buffer+1
				lda #'P'
				sta io_buffer+2
				
				lda use_folders
				cmp #1
				beq @+
				
				
				lda (show_adventure_message_INTERNAL.id),y
				sta io_buffer+3
				iny
				lda (show_adventure_message_INTERNAL.id),y
				sta io_buffer+4
				iny
				lda (show_adventure_message_INTERNAL.id),y
				sta io_buffer+5
				lda #'.'
				sta io_buffer+6
				lda #'S'
				sta io_buffer+7
				lda #'R'
				sta io_buffer+8
				lda #'A'
				sta io_buffer+9
				lda #$9b
				sta io_buffer+10
				rts
				
@				lda #62
				sta io_buffer+3
				lda #'P'
				sta io_buffer+4
				lda (show_adventure_message_INTERNAL.id),y
				sta io_buffer+5
				iny
				lda (show_adventure_message_INTERNAL.id),y
				sta io_buffer+6
				iny
				lda (show_adventure_message_INTERNAL.id),y
				sta io_buffer+7
				lda #'.'
				sta io_buffer+8
				lda #'S'
				sta io_buffer+9
				lda #'R'
				sta io_buffer+10
				lda #'A'
				sta io_buffer+11
				lda #$9b
				sta io_buffer+12

				rts
.endp

; Builds the adventure message filename in the io_buffer
.proc build_advmsg_file_name
				ldx #0
@				lda advmsg_file,x
				sta io_buffer,x
				inx
				cpx #12
				bne @-
				lda #$9b
				sta io_buffer,x
				rts
.endp

; Turns "adventure message-state" on and off
.proc switch_advmessage_state
				lda game_flags
				eor #FLAGS_INADVMESSAGE
				sta game_flags
				rts
.endp

advmsg_file		dta c"D:ADVMSG.SCR"
advmsg_font		dta c"D:ADVMSG.FNT"

