; "Duszpasterz Jan Rzygon" for Atari 8-bit by mgr_inz_rafal

; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see <http:;www.gnu.org/licenses/>.

				opt h+l+
				
pstart			equ $2C20
pocket_scr_buf	equ SCREEN_BUFFER
logic_dll		equ $9c60
logic_dll_post	equ $ad80
immovable		equ $8DFD	; TODO - at the end of the day, immovable (.slow) must finish at $9C5F
loader_start	equ $8CD5

; These three files are generated by Items, Object and Messages compiler.
; They just contain the sizes of particular files.
				icl 'it_size.asm'
				icl 'ob_size.asm'
				icl 'ms_size.asm'
				icl 'mt_size.asm'

				icl 'io_loader.asm'
				
				org pstart

.zpvar =		$80

; Result of MEM_DETECT
.var			ext_ram_banks	.byte

level_font		equ	$2000			; Size = $400
screen_mem		equ $2400			; Size = $81f ($2c20 is next free)
sprite_mem		equ $b800
text_font		equ $b400
display_list	equ	sprite_mem+$200	; Must fit into unused $300 bytes of sprites memory
io_buffer		equ	$b900			; Size = io_buffer_size
io_buffer_size	equ	$ff

;MUSIC			equ $af40
;PLAYER			equ MUSIC-$7db

; Deal with the memory banks at the very beginning
@TAB_MEM_BANKS  EQU $0400
				lda PORTB
				sta game_state
				jsr sparta_detect
				sta sparta_bank
		        JSR @MEM_DETECT
		        sta ext_ram_banks
		        cmp #0
		        beq @+
		        jsr establish_extended_bank 
@				jmp start
				
; Includes				
				; General ATARI registes
				icl 'atari.inc'
				
				; Single-use code, which can be overwritten with buffers, etc.
				icl 'one_use.asm'
				
				; Bank-sensitive code, must be assembled before $4000
				icl 'banked.asm'
				
				; Bank independent section
				; Tools
				icl 'tools.asm'
				icl 'strings_EN.asm'
								
				; Game
				icl	'g_main.asm'
				icl	'g_dl.asm'
				icl 'g_hero.asm'
				icl 'g_map.asm'
				icl 'g_items.asm'
				icl 'g_actmen.asm'
				icl 'g_pocket.asm'
				icl 'g_status.asm'
				icl 'g_logic.asm'
				
				; DLI
				icl 'dli_main.asm'
				
				; Title
				icl 't_main.asm'
				
				; Joystick
				icl 'j_stick.asm'
				
				; Display
				icl 'd_strgs.asm'
				icl 'd_map.asm'
				icl 'd_msgs.asm'
				icl 'd_actmen.asm'
				icl 'd_effect.asm'
				
				; Sprites
				icl 's_main.asm'
				
				; VBXE
				icl 'vbxe.asm'
				
				; Music
				icl 'm_player.asm'
				
; ----------------------
; Program start
;-----------------------		
start
				jsr adapt_mem_banks
				jsr initialization
				lda #0
				sta pocket_loaded
				mva #0 game_state.current_msg_file

				lda #34
				sta 559
				global_init
				legal_disclaimer
restart
				lda #34
				sta 559
				global_init
				title_screen				
				
				run_game
				jmp restart 

; Performs some global initialization tasks
.proc global_init
				lda #1
				sta use_folders
				
				mwa #0 current_action 
				sta SOUNDR
				sta TRANSCHAR_COUNT
				sta logic_flags_000
				sta logic_flags_001
				sta logic_flags_002
				sta logic_flags_003
				sta logic_flags_004
				sta logic_flags_005
				sta logic_flags_006
				sta logic_flags_007
				sta logic_flags_008
				sta logic_flags_009
				sta logic_flags_010
				sta logic_flags_011
				sta logic_flags_012
				sta logic_flags_013
				
				mwa #hero_data hero_data_offset
				mva #hero_anim_time hero_anim_count
;				jsr music_init
				
				; Restore original font (needed when coming back from game)
				lda #>text_font
				sta CHBAS
				rts
.endp

adapt_mem_banks
				lda game_state
				and #%00000001
				cmp #%00000001
				beq @+1
;				bne @+1
				
				; Need to keep the OS-ROM switched off
				ldy #0
@				lda $400,y
				and #%11111110
				sta $400,y
				iny
				cpy ext_ram_banks
				bne @-
				lda $400,y
				and #%11111110
				sta $400,y
				
@				rts

				org PLAYER
				icl "rmtplayr.a65"

; RMT module
	opt h-						;RMT module is standard Atari binary file already
	ins "instruction.rmt"				;include music RMT module
	opt h+
MODUL equ $7750

				org text_font
				ins 'fnt_msg.bin'
				
				org immovable
				icl 'immovabl_EN.asm'
								
				org $02e0
.dw				pstart

				end