/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: DLI (char mode)              */
/***************************************/

	icl "flcreditsa8.h"
	icl "flintro.h"

	org $f0

fcnt	.ds 2
fadr	.ds 2
fhlp	.ds 2
clock	.ds 2
regA	.ds 1
regX	.ds 1
regY	.ds 1

WIDTH	= 32
HEIGHT	= 30

; ---	BASIC switch OFF
;	org $2000\ mva #$ff portb\ rts\ ini $2000

; ---	MAIN PROGRAM
	org a8credits+$1000
scr	ins "flcreditsa8.scr"
	
	org a8credits
fnt	ins "flcreditsa8.fnt"
	ert * <> a8credits_code
	jmp main

ant	dta $70
	dta $70,$44,a(scr),$04,$04,$04,$84,$04,$02,$82,$02,$02,$82,$02,$82,$82,$02
	dta $02,$02,$82,$02,$82,$02,$02,$82,$02,$82,$02,$70,$70
	dta $41,a(ant)


	;.ALIGN $0400

;	ift USESPRITES
;	.ALIGN $0800
;pmg	.ds $0300
;	ift FADECHR = 0
;	SPRITES
;	els
;	.ds $500
;	eif
;	eif

main
; ---	init PMG

	ift USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif

	;lda:cmp:req $14		;wait 1 frame
	mwa #1 clock

	sei			;stop IRQ interrupts
	mva #$00 nmien		;stop NMI interrupts
	sta dmactl
	mva #$fe portb		;switch off ROM to get 16k more ram

	mwa #NMI $fffa		;new NMI handler

	mva #$40 nmien		;switch on NMI again

	ift CHANGES		;if label CHANGES defined

_lp	ldy #0
	lda clock+1
	cmp #$2
	beq stop

	ldy #1
	lda trig0		; FIRE #0
	beq stop

	lda trig1		; FIRE #1
	beq stop

	lda consol		; START
	and #1
	beq stop

	lda skctl
	and #$04
	bne _lp			;wait to press any key; here you can put any own routine

	els

null	jmp DLI.dli1		;CPU is busy here, so no more routines allowed

	eif


stop
	mva #$00 pmcntl		;PMG disabled
	tax
	sta:rne hposp0,x+

	mva #$ff portb		;ROM switch on
	mva #$40 nmien		;only NMI interrupts, DLI disabled
	cli			;IRQ enabled

	tya
	
	rts			;return to ... DOS

; ---	DLI PROGRAM

.local	DLI

	?old_dli = *

	ift !CHANGES

dli1	lda trig0		; FIRE #0
	beq stop

	lda trig1		; FIRE #1
	beq stop

	lda consol		; START
	and #1
	beq stop

	lda skctl
	and #$04
	beq stop

	lda vcount
	cmp #$02
	bne dli1

	:3 sta wsync

	DLINEW dli4

	eif

dli_start

dli4
	sta regA
	stx regX
	sty regY

	sta wsync		;line=56
	sta wsync		;line=57
	sta wsync		;line=58
	sta wsync		;line=59
	sta wsync		;line=60
	sta wsync		;line=61
	lda #$21
	sta wsync		;line=62
	sta gtictl
	sta wsync		;line=63
c7	lda #$0A
c8	ldx #$10
	sta wsync		;line=64
	sta color1
	stx color2
	sta wsync		;line=65
	sta wsync		;line=66
	sta wsync		;line=67
x8	lda #$52
x9	ldx #$AC
	sta wsync		;line=68
	sta hposm0
	stx hposm1
	sta wsync		;line=69
	sta wsync		;line=70
x10	lda #$50
	sta wsync		;line=71
	sta hposm0
	lda >fnt+$400*$01
c9	ldx #$0E
x11	ldy #$52
	sta wsync		;line=72
	sta chbase
	stx color1
	sty hposm1
	sta wsync		;line=73
	lda #$04
	sta wsync		;line=74
	sta gtictl
	DLINEW dli5 1 1 1

dli5
	sta regA

	sta wsync		;line=80
	sta wsync		;line=81
	sta wsync		;line=82
	sta wsync		;line=83
	sta wsync		;line=84
	sta wsync		;line=85
	sta wsync		;line=86
c10	lda #$08
	sta wsync		;line=87
	sta color1
c11	lda #$0E
	sta wsync		;line=88
	sta color1
	sta wsync		;line=89
	sta wsync		;line=90
	sta wsync		;line=91
	sta wsync		;line=92
	sta wsync		;line=93
	sta wsync		;line=94
c12	lda #$08
	sta wsync		;line=95
	sta color1
	DLINEW dli6 1 0 0

dli6
	sta regA

	sta wsync		;line=104
	sta wsync		;line=105
	sta wsync		;line=106
	sta wsync		;line=107
	sta wsync		;line=108
	sta wsync		;line=109
	sta wsync		;line=110
c13	lda #$0A
	sta wsync		;line=111
	sta color1
	DLINEW dli7 1 0 0

dli7
	sta regA

c14	lda #$0E
	sta wsync		;line=120
	sta color1
	DLINEW dli8 1 0 0

dli8
	sta regA

c15	lda #$0A
	sta wsync		;line=128
	sta color1
	DLINEW dli9 1 0 0

dli9
	sta regA

c16	lda #$0E
	sta wsync		;line=160
	sta color1
	DLINEW dli10 1 0 0

dli10
	sta regA

c17	lda #$0A
	sta wsync		;line=176
	sta color1
	DLINEW dli11 1 0 0

dli11
	sta regA

c18	lda #$0E
	sta wsync		;line=200
	sta color1
	DLINEW dli12 1 0 0

dli12
	sta regA

c19	lda #$06
	sta wsync		;line=216
	sta color1

	lda regA
	rti


.endl

; ---

CHANGES = 1
FADECHR	= 0

; ---

.proc	NMI

	bit nmist
	bpl VBL

	jmp DLI.dli_start
dliv	equ *-2

VBL
	sta regA
	stx regX
	sty regY

	sta nmist		;reset NMI flag

	mwa #ant dlptr		;ANTIC address program

	mva #scr32 dmactl	;set new screen width

	mva #$c0 nmien		;switch on NMI+DLI again

	;inc cloc		;little timer

; Initial values

	lda >fnt+$400*$00
	sta chbase
c0	lda #$10
	sta colbak
	lda #$02
	sta chrctl
	lda #$04
	sta gtictl
c1	lda #$EA
	sta color0
c2	lda #$EE
	sta color1
c3	lda #$E4
	sta color2
c4	lda #$24
	sta color3
s0	lda #$00
	sta sizep3
	sta sizem
x0	lda #$A4
	sta hposp3
x1	lda #$5C
	sta hposm1
c5	lda #$EA
	sta colpm1
	sta colpm3
s1	lda #$00
	sta sizep1
x2	lda #$54
	sta hposp1
s2	lda #$00
	sta sizep0
	sta sizep2
x3	lda #$54
	sta hposp0
x4	lda #$A4
	sta hposp2
x5	lda #$5C
	sta hposm0
c6	lda #$E4
	sta colpm0
	sta colpm2
x6	lda #$AC
	sta hposm2
x7	lda #$00
	sta hposm3

	mwa #DLI.dli_start dliv	;set the first address of DLI interrupt

;this area is for yours routines
	inw clock
	jsr flintro_music_player

quit
	lda regA
	ldx regX
	ldy regY
	rti

.endp

	ift USESPRITES
	;.ALIGN $0800
;pmg	.ds $0300
pmg equ a8credits+$0800

	org a8credits+$0800+$0300
	ift FADECHR = 0
	SPRITES
	els
	.ds $500
	eif
	eif

; ---
;	run main
; ---

	opt l-

.MACRO	SPRITES
missiles
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 04 08 00 00 08 0C 11 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player0
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 02 04 04 10 30 80 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player1
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 03 03 07 0F 3C 78 40 80 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player2
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 04 00 08 01 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player3
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 40 A0 F0 38 1C 07 03 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
.ENDM

USESPRITES = 1

.MACRO	DLINEW
	mva <:1 NMI.dliv
	ift [>?old_dli]<>[>:1]
	mva >:1 NMI.dliv+1
	eif

	ift :2
	lda regA
	eif

	ift :3
	ldx regX
	eif

	ift :4
	ldy regY
	eif

	rti

	.def ?old_dli = *
.ENDM

