/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: DLI (char mode)              */
/***************************************/

	icl "fltitle.h"
	icl "flintro.h"
	
	org $f0

fcnt	.ds 2
fadr	.ds 2
fhlp	.ds 2
clock	.ds 2
regA	.ds 1
regX	.ds 1
regY	.ds 1

WIDTH	= 40
HEIGHT	= 30

; ---	BASIC switch OFF
;	org $2000\ mva #$ff portb\ rts\ ini $2000

; ---	MAIN PROGRAM
	org titlescreen
ant	dta $70
	dta $70,$70,$44,a(scr),$04,$04,$84,$84,$04,$04,$04,$04,$04,$84,$84,$84,$04
	dta $04,$04,$84,$04,$04,$84,$84,$84,$04,$04,$70,$70,$70
	dta $41,a(ant)

scr	ins "fltitle.scr"

	.ALIGN $0400
fnt	ins "fltitle.fnt"

	ift USESPRITES
	.ALIGN $0800
pmg	.ds $0300
	ift FADECHR = 0
	SPRITES
	els
	.ds $500
	eif
	eif

main
; ---	init PMG

	ift USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif

	;lda:cmp:req $14		;wait 1 frame

	mwa #1 clock

	sei			;stop IRQ interrupts
	mva #$00 nmien		;stop NMI interrupts
	sta dmactl
	mva #$fe portb		;switch off ROM to get 16k more ram

	mwa #NMI $fffa		;new NMI handler

	mva #$40 nmien		;switch on NMI again

	ift CHANGES		;if label CHANGES defined

_lp	ldy #0
	lda clock+1
	cmp #$02
	beq stop
	
	ldy #1
	lda trig0		; FIRE #0
	beq stop

	lda trig1		; FIRE #1
	beq stop

	lda consol		; START
	and #1
	beq stop

	lda skctl
	and #$04
	bne _lp			;wait to press any key; here you can put any own routine

	els

null	jmp DLI.dli1		;CPU is busy here, so no more routines allowed

	eif


stop
	mva #$00 pmcntl		;PMG disabled
	tax
	sta:rne hposp0,x+

	mva #$ff portb		;ROM switch on
	mva #$40 nmien		;only NMI interrupts, DLI disabled
	cli			;IRQ enabled

	tya
	
	rts			;return to ... DOS

; ---	DLI PROGRAM

.local	DLI

	?old_dli = *

	ift !CHANGES

dli1	lda trig0		; FIRE #0
	beq stop

	lda trig1		; FIRE #1
	beq stop

	lda consol		; START
	and #1
	beq stop

	lda skctl
	and #$04
	beq stop

	lda vcount
	cmp #$02
	bne dli1

	:3 sta wsync

	DLINEW DLI.dli2
	eif


dli_start

dli2
	sta regA
	lda >fnt+$400*$01
	sta wsync		;line=56
	sta chbase
	DLINEW dli10 1 0 0

dli10
	sta regA
	stx regX
	sty regY

	sta wsync		;line=64
x8	lda #$5D
x9	ldx #$7D
	sta wsync		;line=65
	sta hposp2
	stx hposp3
x10	lda #$6A
c8	ldx #$EE
	sta wsync		;line=66
	sta hposp2
	stx colpm2
	sta wsync		;line=67
s4	lda #$01
x11	ldx #$86
c9	ldy #$EE
	sta wsync		;line=68
	sta sizep3
	stx hposp3
	sty colpm3
	sta wsync		;line=69
x12	lda #$A4
	sta wsync		;line=70
	sta hposp1
	sta wsync		;line=71
x13	lda #$A5
	sta wsync		;line=72
	sta hposp1
	sta wsync		;line=73
	sta wsync		;line=74
	sta wsync		;line=75
	sta wsync		;line=76
	sta wsync		;line=77
	sta wsync		;line=78
	lda #$14
s5	ldx #$40
	sta wsync		;line=79
	sta gtictl
	stx sizem
s6	lda #$00
x14	ldx #$C4
c10	ldy #$D8
	sta wsync		;line=80
	sta sizep3
	stx hposp3
	sty colpm3
	lda #$04
x15	ldx #$C3
	sta wsync		;line=81
	sta gtictl
	stx hposp3
s7	lda #$00
x16	ldx #$5C
c11	ldy #$BA
	sta wsync		;line=82
	sta sizep0
	stx hposp0
	sty colpm0
	sta wsync		;line=83
	sta wsync		;line=84
	sta wsync		;line=85
	sta wsync		;line=86
c12	lda #$BA
c13	ldx #$BC
	sta wsync		;line=87
	sta color3
	stx colpm1
	lda >fnt+$400*$02
	ldx #$14
	sta wsync		;line=88
	sta chbase
	stx gtictl
	sta wsync		;line=89
c14	lda #$AA
	sta wsync		;line=90
	sta color1
	sta wsync		;line=91
	sta wsync		;line=92
	sta wsync		;line=93
	sta wsync		;line=94
x17	lda #$70
	sta wsync		;line=95
	sta hposp1
c15	lda #$9C
x18	ldx #$C4
	sta wsync		;line=96
	sta color1
	stx hposp3
x19	lda #$C3
c16	ldx #$AC
	sta wsync		;line=97
	sta hposp3
	stx colpm0
	sta wsync		;line=98
	sta wsync		;line=99
	sta wsync		;line=100
	sta wsync		;line=101
	sta wsync		;line=102
	lda #$04
c17	ldx #$06
	sta wsync		;line=103
	sta gtictl
	stx colpm0
s8	lda #$03
x20	ldx #$30
x21	ldy #$53
	sta wsync		;line=104
	sta sizep0
	stx hposp0
	sty hposm0
	sta wsync		;line=105
	sta wsync		;line=106
	sta wsync		;line=107
	sta wsync		;line=108
s9	lda #$00
x22	ldx #$5C
c18	ldy #$BA
	sta wsync		;line=109
	sta sizep0
	stx hposp0
	sty colpm0
	DLINEW dli3 1 1 1

dli3
	sta regA
	stx regX
	sty regY
	lda >fnt+$400*$03
	sta wsync		;line=112
	sta chbase
x23	lda #$8F
c19	ldx #$0E
	sta wsync		;line=113
	sta hposp0
	stx colpm0
s10	lda #$00
x24	ldx #$65
c20	ldy #$E4
	sta wsync		;line=114
	sta sizep2
	stx hposp2
	sty colpm2
x25	lda #$55
c21	ldx #$E4
	sta wsync		;line=115
	sta hposp1
	stx colpm1
	DLINEW dli11 1 1 1

dli11
	sta regA
	stx regX

c22	lda #$72
	sta wsync		;line=120
	sta colpm0
	sta wsync		;line=121
	sta wsync		;line=122
	sta wsync		;line=123
	sta wsync		;line=124
x26	lda #$4D
c23	ldx #$E4
	sta wsync		;line=125
	sta hposp0
	stx colpm0
	DLINEW dli12 1 1 0

dli12
	sta regA
	stx regX
	sty regY

c24	lda #$24
	ldx #$14
x27	ldy #$C4
	sta wsync		;line=128
	sta color1
	stx gtictl
	sty hposm2
	sta wsync		;line=129
	sta wsync		;line=130
	sta wsync		;line=131
	sta wsync		;line=132
	sta wsync		;line=133
x28	lda #$C2
	sta wsync		;line=134
	sta hposm2
s11	lda #$00
x29	ldx #$BE
x30	ldy #$C0
	sta wsync		;line=135
	sta sizem
	stx hposm0
	sty hposm1
x31	lda #$C4
	sta hposm3
	lda >fnt+$400*$04
	sta wsync		;line=136
	sta chbase
c25	lda #$06
	sta wsync		;line=137
	sta colpm2
c26	lda #$06
	sta wsync		;line=138
	sta colpm1
c27	lda #$06
	sta wsync		;line=139
	sta colpm0
	sta wsync		;line=140
x32	lda #$C4
	sta wsync		;line=141
	sta hposm1
	sta wsync		;line=142
c28	lda #$06
	ldx #$04
s12	ldy #$40
	sta wsync		;line=143
	sta color3
	stx gtictl
	sty sizem
x33	lda #$36
	sta hposm3
	sta wsync		;line=144
	sta wsync		;line=145
	sta wsync		;line=146
	sta wsync		;line=147
	sta wsync		;line=148
	sta wsync		;line=149
	sta wsync		;line=150
x34	lda #$A0
	sta wsync		;line=151
	sta hposm2
	sta wsync		;line=152
c29	lda #$E4
x35	ldx #$98
c30	ldy #$76
	sta wsync		;line=153
	sta color3
	stx hposp2
	sty colpm2
	DLINEW dli4 1 1 1

dli4
	sta regA
	stx regX
	sty regY
	lda >fnt+$400*$05
	sta wsync		;line=160
	sta chbase
s13	lda #$00
x36	ldx #$90
c31	ldy #$76
	sta wsync		;line=161
	sta sizep1
	stx hposp1
	sty colpm1
x37	lda #$88
x38	ldx #$84
c32	ldy #$76
	sta wsync		;line=162
	sta hposp0
	stx hposm0
	sty colpm0
	sta wsync		;line=163
	sta wsync		;line=164
	sta wsync		;line=165
x39	lda #$86
	sta wsync		;line=166
	sta hposm1
	DLINEW dli5 1 1 1

dli5
	sta regA
	stx regX
	lda >fnt+$400*$06
	sta wsync		;line=184
	sta chbase
	sta wsync		;line=185
	sta wsync		;line=186
	sta wsync		;line=187
	sta wsync		;line=188
	sta wsync		;line=189
s14	lda #$00
x40	ldx #$C1
	sta wsync		;line=190
	sta sizem
	stx hposm3
	DLINEW dli6 1 1 0

dli6
	sta regA
	stx regX
	lda >fnt+$400*$05
c33	ldx #$D8
	sta wsync		;line=192
	sta chbase
	stx color1
	lda #$14
	sta wsync		;line=193
	sta gtictl
	DLINEW dli7 1 1 0

dli7
	sta regA
	lda >fnt+$400*$06
	sta wsync		;line=200
	sta chbase

	lda regA
	rti

.endl

; ---

CHANGES = 1
FADECHR	= 0

; ---

	org $4000
.proc	NMI

	bit nmist
	bpl VBL

	jmp DLI.dli_start
dliv	equ *-2

VBL
	sta regA
	stx regX
	sty regY

	sta nmist		;reset NMI flag

	mwa #ant dlptr		;ANTIC address program

	mva #scr40 dmactl	;set new screen width

	mva #$c0 nmien		;switch on NMI+DLI again
	
	;inc clock		;little timer

; Initial values

	lda >fnt+$400*$00
	sta chbase
c0	lda #$E0
	sta colbak
	lda #$02
	sta chrctl
	lda #$04
	sta gtictl
s0	lda #$03
	sta sizep2
	sta sizep3
s1	lda #$30
	sta sizem
x0	lda #$5C
	sta hposp2
x1	lda #$7C
	sta hposp3
x2	lda #$9C
	sta hposm2
c1	lda #$26
	sta colpm2
	sta colpm3
c2	lda #$0A
	sta color0
c3	lda #$8C
	sta color1
c4	lda #$0C
	sta color2
c5	lda #$FE
	sta color3
s2	lda #$01
	sta sizep0
x3	lda #$4D
	sta hposp0
c6	lda #$FA
	sta colpm0
s3	lda #$01
	sta sizep1
x4	lda #$A3
	sta hposp1
c7	lda #$FA
	sta colpm1
x5	lda #$36
	sta hposm3
x6	lda #$3A
	sta hposm0
x7	lda #$C4
	sta hposm1

	mwa #DLI.dli_start dliv	;set the first address of DLI interrupt

;this area is for yours routines
	inw clock
	jsr flintro_music_player

quit
	lda regA
	ldx regX
	ldy regY
	rti

.endp

; ---
;	run main
; ---

	opt l-

.MACRO	SPRITES
missiles
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 30 30 30 30 30
	.he 30 30 30 30 30 30 30 30 30 30 30 30 30 30 30 30
	.he 30 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 40 40 C0 40 40 C0 80
	.he 0F 0F 0D 0F 0F 04 0F 0E 0E 0C 0B 03 03 02 03 40
	.he 82 00 02 80 82 82 00 40 40 40 40 80 80 00 00 00
	.he 00 80 80 80 40 00 00 00 0C 0C 0C 0C 0C 0C 0C C0
	.he FF ED FC F4 F0 1C 04 00 80 80 C0 40 40 40 40 80
	.he 80 80 80 00 00 00 00 20 40 60 70 50 D0 30 10 90
	.he A0 A0 80 A0 60 20 40 40 40 80 80 00 40 C0 84 80
	.he 40 48 80 09 00 02 C0 40 40 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player0
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 10 20 00 28 78 60 70 20 74 B0
	.he 30 10 14 34 18 3E 10 18 18 18 1A 08 1C 08 1C 18
	.he 0C 1E 0C 1C 0C 1C 0C 06 0C 06 1F 06 1E 1F 3E 1D
	.he 1B 06 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 38 40 0A 04 61 8A 6C 10
	.he 3F 3F 3E 3E 00 00 00 00 00 08 1C 39 31 32 3E 34
	.he FE 7C 00 00 00 00 00 00 03 0F 3F 7F 7F 7F FF FF
	.he 00 00 00 00 B3 00 B3 FF 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 06 3F 38 40 01 73 3C 05 00 0C 80 00 40 38 01 00
	.he 00 40 00 80 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player1
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 10 00 00 00 2C 06 1E 1C 0D 0C 1E
	.he 1C 18 4A 1C 18 5C 18 38 38 18 58 38 30 70 70 38
	.he 70 30 70 78 30 70 38 78 68 78 F8 F0 78 B8 D8 60
	.he 30 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 60 10 10 C8 38 00 04 18 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 FF FF FF FF FF FF FF FF
	.he 00 00 00 00 55 00 55 FF 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 01 0C 00 30 62 C4
	.he 19 C0 02 1C F0 80 11 E2 01 60 01 1C 03 00 81 0C
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player2
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 10 80 F0 F0 F0 C0 E4 C6 E6 E6 E4 E0
	.he E0 FF FF FF DF FF FF FF FF FF FF FF FF DF DF DF
	.he DF C0 C0 C0 C0 C0 C0 80 80 00 00 00 00 00 03 7F
	.he 7F FF FF FF FF FF FF FF 7F 7F 7F 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 FF FE FF FE FC F8 FC FC
	.he 00 00 00 00 30 00 00 C0 00 00 00 00 00 00 00 00
	.he 00 00 04 08 00 00 23 04 EC F0 63 87 8B 0B 93 04
	.he 44 82 10 64 03 94 67 8C 18 10 E0 80 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player3
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 C3 C2 C6 C6 E6 E6 E6 E6 E6 C6
	.he C7 FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF 0C 0C 0C 1C 1C 1C 18 00 00 00 00 00 00 2C FC
	.he FC FF FF FE FF FE FF FF FE FF FF 03 05 10 0A 07
	.he 05 00 08 09 03 03 01 00 00 00 04 04 00 0C 04 04
	.he 02 0C 00 05 05 02 02 00 04 00 0C 02 06 00 0E 10
	.he 08 08 11 07 00 02 00 00 00 06 05 04 02 02 15 0D
	.he 04 04 0D 08 00 01 02 02 06 04 00 00 01 02 03 07
	.he 03 17 0C 01 03 01 00 00 04 04 0A 0B 0B 1B 19 09
	.he 0B 0B 19 12 02 04 04 02 03 05 14 02 00 0D 1B 03
	.he 02 04 06 07 03 81 C0 E0 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
.ENDM

USESPRITES = 1

.MACRO	DLINEW
	mva <:1 NMI.dliv
	ift [>?old_dli]<>[>:1]
	mva >:1 NMI.dliv+1
	eif

	ift :2
	lda regA
	eif

	ift :3
	ldx regX
	eif

	ift :4
	ldy regY
	eif

	rti

	.def ?old_dli = *
.ENDM

