/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: GED- (bitmap mode)           */
/***************************************/

	icl "pgloading.h"

; Memory map
; $8000 - $8fff: picture data
; $9000 - $xxxx: DLIST + program
; $9b00 - $9fff: PMG data	

dmactls equ $022f
dlptrs	equ $0230
gtictls equ $026f
colpm0s equ $02c0
colpm1s equ $02c1
colpm2s equ $02c2
colpm3s equ $02c3
color0s equ $02C4
color1s equ $02C5
color2s equ $02C6
color3s equ $02C7
color4s equ $02C8
chact	equ $02f3

	org $00

zc	.ds ZCOLORS

	org $f0

fcnt	.ds 2
fadr	.ds 2
fhlp	.ds 2
cloc	.ds 1
regA	.ds 1
regX	.ds 1
regY	.ds 1

WIDTH	= 32
HEIGHT	= 30

; ---	BASIC switch OFF
;	org $2000\ mva #$ff portb\ rts\ ini $2000

; ---	MAIN PROGRAM
	org $8000
scr	ins "pgloading.raw",0,$1000

;	.ifdef nil_used
;nil	:8*32 brk
;	eif

	.ALIGN $0400
ant	ANTIC_PROGRAM scr,ant

fnt


main
; ---	init PMG

	ift USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif

	lda:cmp:req $14		;wait 1 frame

	;sei			;stop interrups
	;mva #$00 nmien		;stop all interrupts
	;mva #$fe portb		;switch off ROM to get 16k more ram

	ZPINIT

////////////////////
// RASTER PROGRAM //
////////////////////

	;jmp raster_program_end

LOOP	lda vcount		;synchronization for the first screen line
	cmp #$02
	bne LOOP

	mva #scr32 dmactls	;set new screen width
	mva <ant dlptrs
	mva >ant dlptrs+1

; Initial values

c0	lda #$20
	sta colbaks
	;lda #$02
	;sta chrctls
	lda #$01
	sta gtictls
c1	lda #$06
	sta color1s
c2	lda #$20
	sta color2s
c3	lda #$0E
	sta color3s
s0	lda #$03
	sta sizep1
x0	lda #$7C
	sta hposp1
c4	lda #$2E
	sta colpm1s
s1	lda #$03
	sta sizep0
x1	lda #$5C
	sta hposp0
c5	lda #$2E
	sta colpm0s
s2	lda #$03
	sta sizem
x2	lda #$9C
	sta hposm0
;x3	lda #$A0
	lda #$00
	sta hposm2
;c6	lda #$90
;	sta colpm2s
;s3	lda #$03
;	sta sizep2
;s4	lda #$03
;	sta sizep3
;x4	lda #$5C
	lda #$00
	sta hposp2
;x5	lda #$74
	sta hposp3
;x6	lda #$A0
	sta hposm3
;c7	lda #$90
;	sta colpm3s
x7	lda #$7C
	sta hposm1
c8	lda #$00
	sta color0s


raster_program_end

;	lda #$00
;	sta colpm0
;	sta colpm1
;	sta colpm2
;	sta colpm3
;	sta color0
;	sta color1
;	sta color2
;	sta color3
;	sta colbak

// -----------------------------------------------------------
//	EXIT
// -----------------------------------------------------------

;	lda trig0		; FIRE #0
;	beq stop

;	lda trig1		; FIRE #1
;	beq stop

;	lda consol		; START
;	and #1
;	beq stop

;	lda skctl		; ANY KEY
;	and #$04
;	bne skp

;stop	mva #$00 pmcntl		;PMG disabled
;	tax
;	sta:rne hposp0,x+

;	mva #$ff portb		;ROM switch on
;	mva #$40 nmien		;only NMI interrupts, DLI disabled
;	cli			;IRQ enabled

;	jmp *
	lda:cmp:req $14		;wait 1 frame

	rts			;return to ... DOS
skp

// -----------------------------------------------------------

;	jmp LOOP

; ---

;wait60cycle
;	jsr _rts
;	cmp 0,x
;wait44cycle
;	cmp (0,x)
;	nop
;wait36cycle
;	jsr _rts
;wait24cycle
;	jsr _rts
;_rts	rts

; ---

pmg equ $9000
	ift USESPRITES
;	.ALIGN $0800
;pmg	.ds $0300
	org $9300
	ift FADECHR = 0
	SPRITES
	els
	.ds $500
	eif
	eif


;nil_used

.MACRO	ANTIC_PROGRAM
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	dta $70,$70,$70
	dta $70,$70,$70,$70
	dta $4f,a(:1+$0000),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0100),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0200),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0300),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0400),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0500),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0600),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0700),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0800),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0900),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0A00),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0B00),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0C00),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0D00),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0E00),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0F00),$f,$f,$f,$f,$f,$f,$f
	;dta $4f,a(:1+$1000),$f,$f,$f,$f,$f,$f,$f
	;dta $4f,a(:1+$1100),$f,$f,$f,$f,$f,$f,$f
	;dta $4f,a(:1+$1200),$f,$f,$f,$f,$f,$f,$f
	;dta $4f,a(:1+$1300),$f,$f,$f,$f,$f,$f,$f
	;dta $4f,a(:1+$1400),$f,$f,$f,$f,$f,$f,$f
	;dta $4f,a(:1+$1500),$f,$f,$f,$f,$f,$f,$f
	;dta $4f,a(:1+$1600),$f,$f,$f,$f,$f,$f,$f
	;dta $4f,a(:1+$1700),$f,$f,$f,$f,$f,$f,$f
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	dta $41,a(:2)
.ENDM

CL

.MACRO	ZPINIT
.ENDM

ZCOLORS	= 0

FADECHR	= 0
; ---
	ini main
; ---

	opt l-

.MACRO	SPRITES
missiles
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 02 02 02
	.he 02 02 02 02 02 02 02 03 03 03 03 03 03 03 03 03
	.he 03 03 03 02 03 03 03 03 02 02 02 02 02 02 02 02
	.he 02 02 02 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player0
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 0F 1F 1F 1F 1F
	.he 1F 1F 1F 1F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 7F 7F
	.he 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F FF FF FF FF FF FF
	.he FF FF FF FF FF 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F
	.he 7F 7F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F
	.he 3F 1F 1F 1F 1F 1F 1F 1F 1F 1F 0F 0F 0F 0F 0F 0F
	.he 0F 0F 07 07 07 07 07 07 07 03 07 07 07 03 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player1
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 FE FE FE FE FE FE
	.he FE FE FE FE FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FE FE FE FE FE FE FE FC FC FC
	.he FC FC FC FC F8 F8 F8 F8 F8 F0 F0 F0 E0 E0 E0 E0
	.he E0 E0 E0 E0 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;player2
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he FF FF FF FF FF FF FF FF 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;player3
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 1F 1F 1F 1F 1F 1F 1F 1F 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he FE FE FE FE FE FE FE FE 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
.ENDM

USESPRITES = 1

