; Host-dependent Spectrum functions

		icl 'atari.hea'

frame_counter	equ $1f

dlist
		dta $70,$70,$70
		dta $4f, a(spectrum_screen+$0000)
		dta $4f, a(spectrum_screen+$0100)
		dta $4f, a(spectrum_screen+$0200)
		dta $4f, a(spectrum_screen+$0300)
		dta $4f, a(spectrum_screen+$0400)
		dta $4f, a(spectrum_screen+$0500)
		dta $4f, a(spectrum_screen+$0600)
		dta $4f, a(spectrum_screen+$0700)

		dta $4f, a(spectrum_screen+$0000+$20)
		dta $4f, a(spectrum_screen+$0100+$20)
		dta $4f, a(spectrum_screen+$0200+$20)
		dta $4f, a(spectrum_screen+$0300+$20)
		dta $4f, a(spectrum_screen+$0400+$20)
		dta $4f, a(spectrum_screen+$0500+$20)
		dta $4f, a(spectrum_screen+$0600+$20)
		dta $4f, a(spectrum_screen+$0700+$20)
		
		dta $4f, a(spectrum_screen+$0000+$40)
		dta $4f, a(spectrum_screen+$0100+$40)
		dta $4f, a(spectrum_screen+$0200+$40)
		dta $4f, a(spectrum_screen+$0300+$40)
		dta $4f, a(spectrum_screen+$0400+$40)
		dta $4f, a(spectrum_screen+$0500+$40)
		dta $4f, a(spectrum_screen+$0600+$40)
		dta $4f, a(spectrum_screen+$0700+$40)
		
		dta $4f, a(spectrum_screen+$0000+$60)
		dta $4f, a(spectrum_screen+$0100+$60)
		dta $4f, a(spectrum_screen+$0200+$60)
		dta $4f, a(spectrum_screen+$0300+$60)
		dta $4f, a(spectrum_screen+$0400+$60)
		dta $4f, a(spectrum_screen+$0500+$60)
		dta $4f, a(spectrum_screen+$0600+$60)
		dta $4f, a(spectrum_screen+$0700+$60)
		
		dta $4f, a(spectrum_screen+$0000+$80)
		dta $4f, a(spectrum_screen+$0100+$80)
		dta $4f, a(spectrum_screen+$0200+$80)
		dta $4f, a(spectrum_screen+$0300+$80)
		dta $4f, a(spectrum_screen+$0400+$80)
		dta $4f, a(spectrum_screen+$0500+$80)
		dta $4f, a(spectrum_screen+$0600+$80)
		dta $4f, a(spectrum_screen+$0700+$80)
		
		dta $4f, a(spectrum_screen+$0000+$a0)
		dta $4f, a(spectrum_screen+$0100+$a0)
		dta $4f, a(spectrum_screen+$0200+$a0)
		dta $4f, a(spectrum_screen+$0300+$a0)
		dta $4f, a(spectrum_screen+$0400+$a0)
		dta $4f, a(spectrum_screen+$0500+$a0)
		dta $4f, a(spectrum_screen+$0600+$a0)
		dta $4f, a(spectrum_screen+$0700+$a0)
		
		dta $4f, a(spectrum_screen+$0000+$c0)
		dta $4f, a(spectrum_screen+$0100+$c0)
		dta $4f, a(spectrum_screen+$0200+$c0)
		dta $4f, a(spectrum_screen+$0300+$c0)
		dta $4f, a(spectrum_screen+$0400+$c0)
		dta $4f, a(spectrum_screen+$0500+$c0)
		dta $4f, a(spectrum_screen+$0600+$c0)
		dta $4f, a(spectrum_screen+$0700+$c0)
	
		dta $4f, a(spectrum_screen+$0000+$e0)
		dta $4f, a(spectrum_screen+$0100+$e0)
		dta $4f, a(spectrum_screen+$0200+$e0)
		dta $4f, a(spectrum_screen+$0300+$e0)
		dta $4f, a(spectrum_screen+$0400+$e0)
		dta $4f, a(spectrum_screen+$0500+$e0)
		dta $4f, a(spectrum_screen+$0600+$e0)
		dta $4f, a(spectrum_screen+$0700+$e0)
	
		dta $4f, a(spectrum_screen+$0800)
		dta $4f, a(spectrum_screen+$0900)
		dta $4f, a(spectrum_screen+$0a00)
		dta $4f, a(spectrum_screen+$0b00)
		dta $4f, a(spectrum_screen+$0c00)
		dta $4f, a(spectrum_screen+$0d00)
		dta $4f, a(spectrum_screen+$0e00)
		dta $4f, a(spectrum_screen+$0f00)

		dta $4f, a(spectrum_screen+$0800+$20)
		dta $4f, a(spectrum_screen+$0900+$20)
		dta $4f, a(spectrum_screen+$0a00+$20)
		dta $4f, a(spectrum_screen+$0b00+$20)
		dta $4f, a(spectrum_screen+$0c00+$20)
		dta $4f, a(spectrum_screen+$0d00+$20)
		dta $4f, a(spectrum_screen+$0e00+$20)
		dta $4f, a(spectrum_screen+$0f00+$20)
		
		dta $4f, a(spectrum_screen+$0800+$40)
		dta $4f, a(spectrum_screen+$0900+$40)
		dta $4f, a(spectrum_screen+$0a00+$40)
		dta $4f, a(spectrum_screen+$0b00+$40)
		dta $4f, a(spectrum_screen+$0c00+$40)
		dta $4f, a(spectrum_screen+$0d00+$40)
		dta $4f, a(spectrum_screen+$0e00+$40)
		dta $4f, a(spectrum_screen+$0f00+$40)
		
		dta $4f, a(spectrum_screen+$0800+$60)
		dta $4f, a(spectrum_screen+$0900+$60)
		dta $4f, a(spectrum_screen+$0a00+$60)
		dta $4f, a(spectrum_screen+$0b00+$60)
		dta $4f, a(spectrum_screen+$0c00+$60)
		dta $4f, a(spectrum_screen+$0d00+$60)
		dta $4f, a(spectrum_screen+$0e00+$60)
		dta $4f, a(spectrum_screen+$0f00+$60)
		
		dta $4f, a(spectrum_screen+$0800+$80)
		dta $4f, a(spectrum_screen+$0900+$80)
		dta $4f, a(spectrum_screen+$0a00+$80)
		dta $4f, a(spectrum_screen+$0b00+$80)
		dta $4f, a(spectrum_screen+$0c00+$80)
		dta $4f, a(spectrum_screen+$0d00+$80)
		dta $4f, a(spectrum_screen+$0e00+$80)
		dta $4f, a(spectrum_screen+$0f00+$80)
		
		dta $4f, a(spectrum_screen+$0800+$a0)
		dta $4f, a(spectrum_screen+$0900+$a0)
		dta $4f, a(spectrum_screen+$0a00+$a0)
		dta $4f, a(spectrum_screen+$0b00+$a0)
		dta $4f, a(spectrum_screen+$0c00+$a0)
		dta $4f, a(spectrum_screen+$0d00+$a0)
		dta $4f, a(spectrum_screen+$0e00+$a0)
		dta $4f, a(spectrum_screen+$0f00+$a0)
		
		dta $4f, a(spectrum_screen+$0800+$c0)
		dta $4f, a(spectrum_screen+$0900+$c0)
		dta $4f, a(spectrum_screen+$0a00+$c0)
		dta $4f, a(spectrum_screen+$0b00+$c0)
		dta $4f, a(spectrum_screen+$0c00+$c0)
		dta $4f, a(spectrum_screen+$0d00+$c0)
		dta $4f, a(spectrum_screen+$0e00+$c0)
		dta $4f, a(spectrum_screen+$0f00+$c0)
	
		dta $4f, a(spectrum_screen+$0800+$e0)
		dta $4f, a(spectrum_screen+$0900+$e0)
		dta $4f, a(spectrum_screen+$0a00+$e0)
		dta $4f, a(spectrum_screen+$0b00+$e0)
		dta $4f, a(spectrum_screen+$0c00+$e0)
		dta $4f, a(spectrum_screen+$0d00+$e0)
		dta $4f, a(spectrum_screen+$0e00+$e0)
		dta $4f, a(spectrum_screen+$0f00+$e0)

		dta $4f, a(spectrum_screen+$1000)
		dta $4f, a(spectrum_screen+$1100)
		dta $4f, a(spectrum_screen+$1200)
		dta $4f, a(spectrum_screen+$1300)
		dta $4f, a(spectrum_screen+$1400)
		dta $4f, a(spectrum_screen+$1500)
		dta $4f, a(spectrum_screen+$1600)
		dta $4f, a(spectrum_screen+$1700)

		dta $4f, a(spectrum_screen+$1000+$20)
		dta $4f, a(spectrum_screen+$1100+$20)
		dta $4f, a(spectrum_screen+$1200+$20)
		dta $4f, a(spectrum_screen+$1300+$20)
		dta $4f, a(spectrum_screen+$1400+$20)
		dta $4f, a(spectrum_screen+$1500+$20)
		dta $4f, a(spectrum_screen+$1600+$20)
		dta $4f, a(spectrum_screen+$1700+$20)
		
		dta $4f, a(spectrum_screen+$1000+$40)
		dta $4f, a(spectrum_screen+$1100+$40)
		dta $4f, a(spectrum_screen+$1200+$40)
		dta $4f, a(spectrum_screen+$1300+$40)
		dta $4f, a(spectrum_screen+$1400+$40)
		dta $4f, a(spectrum_screen+$1500+$40)
		dta $4f, a(spectrum_screen+$1600+$40)
		dta $4f, a(spectrum_screen+$1700+$40)
		
		dta $4f, a(spectrum_screen+$1000+$60)
		dta $4f, a(spectrum_screen+$1100+$60)
		dta $4f, a(spectrum_screen+$1200+$60)
		dta $4f, a(spectrum_screen+$1300+$60)
		dta $4f, a(spectrum_screen+$1400+$60)
		dta $4f, a(spectrum_screen+$1500+$60)
		dta $4f, a(spectrum_screen+$1600+$60)
		dta $4f, a(spectrum_screen+$1700+$60)
		
		dta $4f, a(spectrum_screen+$1000+$80)
		dta $4f, a(spectrum_screen+$1100+$80)
		dta $4f, a(spectrum_screen+$1200+$80)
		dta $4f, a(spectrum_screen+$1300+$80)
		dta $4f, a(spectrum_screen+$1400+$80)
		dta $4f, a(spectrum_screen+$1500+$80)
		dta $4f, a(spectrum_screen+$1600+$80)
		dta $cf, a(spectrum_screen+$1700+$80)
		
		dta $4f, a(spectrum_screen+$1000+$a0)
		dta $4f, a(spectrum_screen+$1100+$a0)
		dta $4f, a(spectrum_screen+$1200+$a0)
		dta $4f, a(spectrum_screen+$1300+$a0)
		dta $4f, a(spectrum_screen+$1400+$a0)
		dta $4f, a(spectrum_screen+$1500+$a0)
		dta $4f, a(spectrum_screen+$1600+$a0)
		dta $4f, a(spectrum_screen+$1700+$a0)
		
		dta $4f, a(spectrum_screen+$1000+$c0)
		dta $4f, a(spectrum_screen+$1100+$c0)
		dta $4f, a(spectrum_screen+$1200+$c0)
		dta $4f, a(spectrum_screen+$1300+$c0)
		dta $4f, a(spectrum_screen+$1400+$c0)
		dta $4f, a(spectrum_screen+$1500+$c0)
		dta $4f, a(spectrum_screen+$1600+$c0)
		dta $4f, a(spectrum_screen+$1700+$c0)
	
		dta $4f, a(spectrum_screen+$1000+$e0)
		dta $4f, a(spectrum_screen+$1100+$e0)
		dta $4f, a(spectrum_screen+$1200+$e0)
		dta $4f, a(spectrum_screen+$1300+$e0)
		dta $4f, a(spectrum_screen+$1400+$e0)
		dta $4f, a(spectrum_screen+$1500+$e0)
		dta $4f, a(spectrum_screen+$1600+$e0)
		dta $4f, a(spectrum_screen+$1700+$e0)
		
		dta $41,a(dlist)
		
out_fe	
		lsr @
		sta consol ; Buzzer
		rts
		
;out_fd
;		sta readkb+1
;		rts
;in_a_fe
;		;lda #$ff
;readkb	lda $d100
;		rts

out_fd	eor #$ff
		sta keys_rows
		rts
		
in_a_fe	
		lda #$ff
		sta key_result
		lda skstat
		and #$04
		bne nokey
		stx rk_save_x+1
		sty rk_save_y+1
		lda kbcode
		bmi key_exit
		tay
		and #$3f
		tax
		lda atari_spectrum_keys,x
		and #$07
		tax
		lda _bitmem0,x
		and keys_rows
		beq key_exit
		tya
		and #$3f
		tax
		lda atari_spectrum_keys,x
		lsr @
		lsr @
		lsr @
		lsr @
		tax
		lda _bitmem0,x
		eor #$ff
		sta key_result
key_exit
rk_save_x
		ldx #$00
rk_save_y
		ldy #$00
nokey	lda key_result
		rts

		
keys_rows 	dta $00
key_result	dta $00
		
atari_spectrum_keys
; spectrum keyboard matrix
;  Bit    Col0  Col1  Col2  Col3  Col4  
;  Row0   CS    "Z"   "X"   "C"   "V"   ; 0xFEFE
;  Row1   "A"   "S"   "D"   "F"   "G"   ; 0xFDFE
;  Row2   "Q"   "W"   "E"   "R"   "T"   ; 0xFBFE
;  Row3   "1"   "2"   "3"   "4"   "5"	; 0xF7FE   
;  Row4   "0"   "9"   "8"   "7"   "6"   ; 0xEFFE
;  Row5   "P"   "O"   "I"   "U"   "Y"	; 0xDFFE   
;  Row6   ENTER "L"   "K"   "J"   "H"   ; 0xBFFE
;  Row7   SPACE SS    "M"   "N"   "B"   ; 0x7FFE
		dta $16	; L $00
		dta $36	; J $01
		dta $ff	; ;: $02
		dta $ff	; F1 $03
		dta $ff	; F2 $04
		dta $26	; K $05
		dta $ff	; +\ $06
		dta $ff	; *^ $07
		dta $15	; O $08
		dta $ff	;   $09
		dta $05	; P $0A
		dta $35	; U $0B
		dta $06	; RETURN $0C
		dta $25	; I $0D
		dta $ff	; -_ $0E
		dta $ff	; =| $0F
		dta $40	; $10 V
		dta $ff	; $11 HELP
		dta $30	; $12 C
		dta $ff	; $13 F3
		dta $ff	; $14 F4
		dta $47	; $15 B
		dta $20 ; $16 X
		dta $10 ; $17 Z
		dta $33	; $18 4$
		dta $ff ; $19
		dta $24	; $1a 3#
		dta $44	; $1b 6&
		dta $ff ; $1c ESC
		dta $43	; $1d 5%
		dta $13 ; $1e 2"
		dta $03 ; $1f 1!
		dta $ff ; $20 ,[
		dta $07 ; $21 SPACE
		dta $ff	; $22 .]
		dta $37	; $23 N
		dta $ff	; $24
		dta $27	; $25 M
		dta $ff	; $26 /?
		dta $ff ; $27 LOGO (RSHIFT)
		dta $32	; $28 R
		dta $ff	; $29
		dta $22	; $2a E
		dta $45 ; $2b Y
		dta $ff	; $2c TAB
		dta $42	; $2d T
		dta $12	; $2e W
		dta $02	; $2f Q
		dta $14	; $30 9(
		dta $ff ; $31
		dta $04 ; $32 0)
		dta $34 ; $33 7'
		dta $ff	; $34 BACKSPACE/DEL
		dta $24 ; $35 8@
		dta $ff ; $36 <CLEAR
		dta $ff ; $37 >INS
		dta $31 ; $38 F
		dta $46 ; $39 H
		dta $21 ; $3a D
		dta $ff ; $3b
		dta $ff ; $3c CAPS
		dta $41	; $3d G
		dta $11	; $3e S
		dta $01 ; $3f A
		
;in_a_1f
;		lda #$00	; kempston is active high FUDLR
;		rts
in_a_1f
		lda trig0
		lsr @
		lda porta	; RLDU active low
		and #$0f
		tax
		lda joystick_table,x
		scs:ora #$10
		rts
		
joystick_table
		dta %1111; 0000
		dta %0111; 0001
		dta %1011; 0010
		dta %0011; 0011
		dta %1101; 0100
		dta %0101; 0101
		dta %1001; 0110
		dta %0001; 0111
		dta %1110; 1000
		dta %0110; 1001
		dta %1010; 1010
		dta %0010; 1011
		dta %1100; 1100
		dta %0100; 1101
		dta %1000; 1110
		dta %0000; 1111

ld_a_r	.macro
		lda $d20a ; POKEY random number - emulate R register
		.endm
	
; colors
;Spectrum color 0: (00,00,00) = Atari color 00 (00,00,00), distance = 0.000000
;Spectrum color 1: (00,00,bf) = Atari color 82 (05,1d,8e), distance = 57.157677
;Spectrum color 2: (bf,00,00) = Atari color 34 (82,2a,0f), distance = 75.564545
;Spectrum color 3: (bf,00,bf) = Atari color 56 (98,3f,92), distance = 86.689102
;Spectrum color 4: (00,bf,00) = Atari color c5 (26,7c,22), distance = 84.196198
;Spectrum color 5: (00,bf,bf) = Atari color a7 (38,93,a6), distance = 75.478477
;Spectrum color 6: (bf,bf,00) = Atari color 19 (b3,a0,2b), distance = 54.350712
;Spectrum color 7: (bf,bf,bf) = Atari color 0b (bb,bb,bb), distance = 6.928203
;Spectrum color 8: (00,00,00) = Atari color 00 (00,00,00), distance = 0.000000
;Spectrum color 9: (00,00,ff) = Atari color 84 (27,3f,b0), distance = 108.309738
;Spectrum color 10: (ff,00,00) = Atari color 35 (93,3b,20), distance = 127.157379
;Spectrum color 11: (ff,00,ff) = Atari color 59 (cb,72,c5), distance = 138.072449
;Spectrum color 12: (00,ff,00) = Atari color c6 (37,8d,33), distance = 136.462448
;Spectrum color 13: (00,ff,ff) = Atari color aa (6b,c6,d9), distance = 127.051170
;Spectrum color 14: (ff,ff,00) = Atari color 1c (e6,d3,5e), distance = 106.756729
;Spectrum color 15: (ff,ff,ff) = Atari color 0f (ff,ff,ff), distance = 0.000000

spectrum_color
		; 0 - black
		; 1 - blue
		; 2 - red
		; 3 - violet
		; 4 - green
		; 5 -
		; 6 - yellow
		; 7 - white
		.he 00,84,36,46,c4,a4,e4,0a
		.he 00,88,3a,4e,ca,aa,ee,0e
		;.he 00,8a,3a,4a,ca,aa,ea,0a
		;.he 00,8a,3a,4a,ca,aa,ee,0a
		
spectrum_init

		; init ANTIC + interrupts
		sei
		lda #0
		sta nmien	; disable interrupts
		sta irqen
		sta dmactl	; disable screen
		sta frame_counter
		lda #%11111110
		sta portb

		lda #<nmi
		sta $fffa
		lda #>nmi
		sta $fffb
		lda #<irq
		sta $fffe
		lda #>irq
		sta $ffff
		
		; set screen
		lda #<dlist
		sta dlptr
		lda #>dlist
		sta dlptr+1
		lda #%00100001
		sta dmactl

		lda #$40
		sta nmien

		; init POKEY
		ldx #$08
		lda #$00
		sta skctl
clear	sta $d200,x
		dex
		bpl clear
		lda #$03
		sta skctl
		; init GTIA
		ldx #$0f
		lda #$00
cleargtia	sta $d000,x
		dex
		bpl cleargtia
		; colors
		lda #$00
		sta colbak
		sta colpf2
		lda #$0e
		sta colpf1
		
		rts

nmi		bit nmist
		bmi dli
		inc frame_counter
		jsr HostVBI
irq
		rti
		
dli		jmp HostDLI

