/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: GED- (bitmap mode)           */
/***************************************/

dmactls equ $022f
dlptrs	equ $0230
gtictls equ $026f
colpm0s equ $02c0
colpm1s equ $02c1
colpm2s equ $02c2
colpm3s equ $02c3
color0s equ $02C4
color1s equ $02C5
color2s equ $02C6
color3s equ $02C7
color4s equ $02C8
chact	equ $02f3

	icl "loading.h"

	org $00

zc	.ds ZCOLORS

	org $f0

fcnt	.ds 2
fadr	.ds 2
fhlp	.ds 2
cloc	.ds 1
regA	.ds 1
regX	.ds 1
regY	.ds 1

WIDTH	= 40
HEIGHT	= 30

; ---	BASIC switch OFF
	org $2000\ mva #$ff portb\ rts\ ini $2000

; ---	MAIN PROGRAM
	org $2000
scr	ins "loading.raw"

	.ifdef nil_used
nil	:8*40 brk
	eif

	.ALIGN $0400
ant	ANTIC_PROGRAM scr,ant

fnt


main
; ---	init PMG

	ift USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif

	lda:cmp:req $14		;wait 1 frame

	;sei			;stop interrups
	;mva #$00 nmien		;stop all interrupts
	;mva #$fe portb		;switch off ROM to get 16k more ram

	ZPINIT

////////////////////
// RASTER PROGRAM //
////////////////////

	;jmp raster_program_end

LOOP	lda vcount		;synchronization for the first screen line
	cmp #$02
	bne LOOP

	mva #scr40 dmactls	;set new screen width
	mva <ant dlptrs
	mva >ant dlptrs+1

; Initial values

c0	lda #$F0
	sta colbaks
	lda #$02
	sta chact
	lda #$11
	sta gtictls
c1	lda #$F2
	sta color1s
c2	lda #$FE
	sta color2s
c3	lda #$FA
	sta color3s
s0	lda #$03
	sta sizep2
x0	lda #$91
	sta hposp2
c4	lda #$F6
	sta colpm2s
s1	lda #$00
	sta sizep0
s2	lda #$00
	sta sizep1
x1	lda #$93
	sta hposp0
x2	lda #$A8
	sta hposp1
c5	lda #$FC
	sta colpm0s
c6	lda #$FC
	sta colpm1s
s3	lda #$03
	sta sizep3
x3	lda #$6C
	sta hposp3
c7	lda #$FA
	sta colpm3s
x4	lda #$61
	sta hposm1
s4	lda #$FF
	sta sizem
x5	lda #$5A
	sta hposm0
x6	lda #$86
	sta hposm3
x7	lda #$68
	sta hposm2
c8	lda #$00
	sta color0s


raster_program_end

;	lda #$00
;	sta colpm0
;	sta colpm1
;	sta colpm2
;	sta colpm3
;	sta color0
;	sta color1
;	sta color2
;	sta color3
;	sta colbak

// -----------------------------------------------------------
//	EXIT
// -----------------------------------------------------------

;	lda trig0		; FIRE #0
;	beq stop
;
;	lda trig1		; FIRE #1
;	beq stop
;
;	lda consol		; START
;	and #1
;	beq stop
;
;	lda skctl		; ANY KEY
;	and #$04
;	bne skp
;
;stop	mva #$00 pmcntl		;PMG disabled
;	tax
;	sta:rne hposp0,x+
;
;	mva #$ff portb		;ROM switch on
;	mva #$40 nmien		;only NMI interrupts, DLI disabled
;	cli			;IRQ enabled

;	jmp *
	lda:cmp:req $14		;wait 1 frame

	rts			;return to ... DOS
;skp

// -----------------------------------------------------------

;	jmp LOOP

; ---

pmg equ $4000
	ift USESPRITES
;	.ALIGN $0800
;pmg	.ds $0300
	org $4300
	ift FADECHR = 0
	SPRITES
	els
	.ds $500
	eif
	eif

; ---

;nil_used

.MACRO	ANTIC_PROGRAM
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	dta $70,$70,$70	
	dta $4f,a(:1+$0000),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0140),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0280),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$03C0),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0500),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0640),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0780),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$08C0),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0A00),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0B40),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0C80),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$0DC0),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1000),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1140),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1280),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$13C0),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1500),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1640),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1780),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$18C0),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1A00),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1B40),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1C80),$f,$f,$f,$f,$f,$f,$f
	dta $4f,a(:1+$1DC0),$f,$f,$f,$f,$f,$f,$f
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	dta $41,a(:2)
.ENDM

CL

.MACRO	ZPINIT
.ENDM

ZCOLORS	= 0

FADECHR	= 0
; ---
	ini main
; ---

	opt l-

.MACRO	SPRITES
missiles
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 03 03 0B 0B 0B 0B 0B 0F 2F
	.he 2F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7D 7D 7D
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player0
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 1A 3E 3E 7E 7E 7E 78 7C 7E 7E 7E
	.he 7E 7A 7A 5B 5E 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player1
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 40 40 40 30 78 78 78 79 79 39 39
	.he 1F 17 1F 3F 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player2
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF 7F 7F
	.he FF 7F 7F 7F 7F 7F FF FF FF FF FF FF FF FF FF FF
	.he FF FE FE FE FE FE FE FE FE FE FE 7E 7E 7E 7E 7E
	.he 7E 7E 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C
	.he 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 7C 3C 3C
	.he 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C
	.he 3C 3C 3C 3C 3C 3C 3C 3C 3C 38 38 30 20 20 20 10
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player3
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 1C 1C 1C
	.he 1C 1C 1C 1C 1C 1C 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E
	.he 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 1E 3F 3F 3F 3F
	.he 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F 3F
	.he 3F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F
	.he 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F 7F
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
.ENDM

USESPRITES = 1

