/*
Memory map:
0058       : leftmost visible column
0059       : rightmost visible column
005A - 005B: pointer to screen memory $E000
005C - 005D: pointer to color memory $CC00
005E - 005F: pointer to ??? $4000

3C00 - 3FFF: initial data for sprites (copied to C800)
5820 - 58DF: screen data for bottom panel (2)
5920 - 59DF: screen data for bottom panel
5D48 - 5DE7: color data for bottom panel of the screen (used by 2DCB)
B900 - B93F: buffer for saving sprite registers
C000 - C7FF: unused memory
C800 - CBFF: sprites (used for speech ballons)
CC00 - CFFF: color RAM
D000 - DFFF: I/O
E000 - FF37: screen RAM

Rectangle speech: 20DD
>C:d000  e0 34 78 34  90 34 a8 34   .4x4.4.4
>C:d008  78 34 88 34  e0 34 00 00   x4.4.4..
Sprite images:
29 2B 2C 2D 2E 2F 28 1A
Sprite enabled: 3E
Sprites 1,2,3 are text.

Bubble speech: 2453
>C:d000  a8 34 c0 34  a0 34 d8 34   .4.4.4.4
>C:d008  a0 34 d8 34  a8 34 00 00   .4.4.4..
Sprite images:
29 2A 23 25 22 24 28 1A
Sprite enabled: 7F
Sprites 0,1 (29,2A): text
Sprites 2 (23): left side of balloon
Sprites 3 (25): right side of balloon
Sprites 4 (22): mask of left side of balloon
Sprites 5 (24): mask of right side of balloon
Sprites 6 (28): mask of text (doubled)

95F2 - hide bubble sprite when scrolling?
9879 - restore bubble sprite when scrolling?
38EF - save sprite, used when bubble is on the screen and rectangle is about to be displayed
Routines:
0800 - startup
1F77 - Jump to embedded address
2005 – render text to buffer, pointer to string in $D6/$D7, $9D set to $08?, $31 set to $40?
2043 - show speech bubble, x in $FC (in game coordinates), y in $FB
213B – often called afterwards $2005?
2CD9 - init graphics
2D1F - setup VIC
2D3E - VIC enable bitmap mode
2D47 - Init global pointers
2DAD - clear screen
2DCB - set color RAM
2E05 - clear zero page
2EE6 - calculate screen address?
2F20 - Init bottom panel graphics
2F56 - Init bottom panel graphics (2)
2FB6 - Move tiles (used by scrolling routines, moves a column of $15 (21) tiles, $4e - source pointer, $52 - destination pointer)
302A - Init SID (for random number generator only?)
3047 - Init sprites
3072 - Scroll screen left (calls 2FB6)
3113 - Scroll screen right (calls 2FB6)
31DF - Delay
31EA - Update dirty tiles on screen
3326 - Update tile on screen (superimposing sprites if necessary) X = $27, Y = $28
33B5 - Draw tile on screen?
36E3 - Mark tile dirty - X = $49, Y = $4A
3868 – put rendered text on screen, parameters in registers X and Y 
39C7 - IRQ vector
3A8F - NMI vector (RTI)
38EF - Restore sprites (copy registers from B900 to D000)
38AC - Save sprites (copy registers from D000 to B900)
38AC - Restore sprites (copy registers from B900 to D000)
38EF - Save sprites (copy registers from D000 to B900)

SID sound
FREQUENCY = (REGISTER VALUE * CLOCK)/16777216 Hz

where CLOCK=1022730 for NTSC systems and CLOCK=985250 for PAL systems.

register value = $1000
sound frequency = 240,53955078125 Hz ; Voice 2

register value = $3000
sound frequency = 721,61865234375 Hz ; Voice 2

register value = $3100
sound frequency = 736,652374267578125 Hz ; Voice 1

register value = $2900
sound frequency = 616,382598876953125 Hz ; Voice 1

register value = $8080
sound frequency = 1931,8332672119140625 Hz

SID(0000) = 240.54 Hz 	PokeyMain = 0E5F (240.57), Pokey64KHz = 0082 (241.75), Pokey15KHz = 001F (243.07)
						PokeyMain = 0E60 (240.50), Pokey64KHz = 0083 (239.91), Pokey15KHz = 0020 (235.71)
SID(0001) = 721.62 Hz 	PokeyMain = 04C5 (722.09), Pokey64KHz = 002A (736.48), Pokey15KHz = 0009 (777.83)
						PokeyMain = 04C6 (721.50), Pokey64KHz = 002B (719.74), Pokey15KHz = 000A (707.12)
SID(0002) = 736.65 Hz 	PokeyMain = 04AC (737.09), Pokey64KHz = 0029 (754.02), Pokey15KHz = 0009 (777.83)
						PokeyMain = 04AD (736.48), Pokey64KHz = 002A (736.48), Pokey15KHz = 000A (707.12)
SID(0003) = 616.38 Hz 	PokeyMain = 0597 (616.64), Pokey64KHz = 0032 (620.95), Pokey15KHz = 000B (648.19)
						PokeyMain = 0598 (616.21), Pokey64KHz = 0033 (609.01), Pokey15KHz = 000C (598.33)

*/
$0000            .byte $2F,$37,$E8,$B1,$0F,$C8,$D0,$02
$0008            .byte $E6,$10,$C9,$DA,$D0,$0F,$BE,$00
$0010            .byte $00,$C8,$D0,$02,$E6,$10,$B1,$0F
$0018            .byte $C8,$D0,$02,$E6,$10,$8D,$38,$C6
$0020            .byte $E6,$1E,$D0,$04,$E6,$1F,$F0,$07
$0028            .byte $CA,$D0,$F2,$A5,$10,$D0,$D3,$A9
$0030            .byte $37,$85,$01,$58,$4C,$00,$C0,$BD
$0038            .byte $EA,$06,$9D,$00,$5E,$E8,$D0,$F7
$0040            .byte $C6,$3C,$A9,$06,$C7,$39,$D0,$EF
$0048            .byte $F0,$B8,$00,$00,$00,$00,$00,$00
$0050            .byte $19,$00,$00,$03,$4C,$00,$00,$00
$0058            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0060            .byte $00,$8C,$00,$00,$08,$03,$00,$00
$0068            .byte $00,$8C,$80,$20,$00,$00,$00,$00
$0070            .byte $00,$05,$A3,$E6,$7A,$D0,$02,$E6
$0078            .byte $7B,$AD,$0A,$08,$C9,$3A,$B0,$0A
$0080            .byte $C9,$20,$F0,$EF,$38,$E9,$30,$38
$0088            .byte $E9,$D0,$60,$80,$4F,$C7,$52,$58
$0090            .byte $40,$FF,$00,$00,$40,$FF,$00,$00
$0098            .byte $00,$00,$03,$00,$00,$00,$00,$00
$00A0            .byte $00,$1C,$81,$40,$FF,$00,$00,$0C
$00A8            .byte $00,$00,$00,$00,$00,$00,$02,$08
$00B0            .byte $00,$00,$3C,$03,$00,$00,$00,$01
$00B8            .byte $01,$60,$08,$FF,$9F,$00,$00,$00
$00C0            .byte $00,$00,$A0,$01,$08,$27,$00,$00
$00C8            .byte $03,$05,$03,$27,$0C,$0C,$20,$00
$00D0            .byte $00,$00,$04,$00,$00,$27,$00,$0D
$00D8            .byte $00,$84,$84,$84,$84,$84,$84,$84
$00E0            .byte $85,$85,$85,$85,$85,$85,$86,$86
$00E8            .byte $86,$86,$86,$86,$86,$87,$87,$87
$00F0            .byte $87,$87,$87,$00,$D8,$81,$EB,$80
$00F8            .byte $1A,$8D,$1C,$00,$01,$01,$01,$08
$0100            .byte $E8,$A9,$00,$85,$FC,$85,$FB,$E0
$0108            .byte $01,$90,$21,$A5,$FD,$4A,$D0,$11
$0110            .byte $AD,$1C,$01,$D0,$03,$CE,$1D,$01
$0118            .byte $CE,$1C,$01,$AD,$E9,$07,$90,$1B
$0120            .byte $6A,$26,$FC,$26,$FB,$CA,$D0,$E5
$0128            .byte $85,$FD,$A5,$FC,$60,$C6,$01,$58
$0130            .byte $4C,$00,$C2,$CA,$C6,$FF,$C6,$AF
$0138            .byte $88,$B1,$AE,$91,$FE,$98,$D0,$F8
$0140            .byte $8A,$D0,$F0,$20,$00,$01,$F0,$0A
$0148            .byte $A5,$FE,$D0,$02,$C6,$FF,$C6,$FE
$0150            .byte $90,$BE,$C8,$20,$00,$01,$F0,$FA
$0158            .byte $C0,$11,$B0,$D1,$BE,$33,$03,$20
$0160            .byte $01,$01,$79,$67,$03,$85,$A7,$A5
$0168            .byte $FB,$79,$9B,$03,$48,$D0,$06,$A4
$0170            .byte $A7,$C0,$04,$90,$02,$A0,$03,$BE
$0178            .byte $AC,$01,$20,$01,$01,$79,$AF,$01
$0180            .byte $A8,$38,$A5,$FE,$E5,$A7,$85,$FE
$0188            .byte $B0,$02,$C6,$FF,$BE,$34,$03,$20
$0190            .byte $01,$01,$79,$68,$03,$90,$03,$E6
$0198            .byte $FB,$18,$65,$FE,$85,$AE,$A5,$FB
$01A0            .byte $79,$9C,$03,$65,$FF,$85,$AF,$A4
$01A8            .byte $A7,$68,$AA,$90,$90,$02,$04,$04
$01B0            .byte $30,$20,$10,$E8,$98,$29,$0F,$F0
$01B8            .byte $13,$8A,$4A,$A6,$FC,$2A,$26,$FB
$01C0            .byte $CA,$10,$FA,$79,$67,$03,$AA,$A5
$01C8            .byte $FB,$79,$9B,$03,$99,$9C,$03,$8A
$01D0            .byte $99,$68,$03,$A2,$04,$20,$01,$01
$01D8            .byte $99,$34,$03,$C8,$C0,$34,$D0,$D3
$01E0            .byte $A0,$34,$B9,$2F,$91,$99,$E8,$07
$01E8            .byte $88,$7D,$EA,$0D,$09,$00,$23,$DD
$01F0            .byte $E4,$09,$7D,$EA,$00,$FF,$7D,$EA
$01F8            .byte $4E,$FF,$00,$A0,$E4,$FF,$8A,$C1
$0200            .byte $48,$AD,$C6,$B6,$2A,$85,$F7,$EE
$0208            .byte $02,$02,$D0,$03,$EE,$03,$02,$68
$0210            .byte $60,$E8,$8A,$06,$F7,$D0,$03,$20
$0218            .byte $00,$02,$90,$12,$E8,$E0,$08,$D0
$0220            .byte $F2,$F0,$0B,$A2,$07,$E8,$06,$F7
$0228            .byte $D0,$03,$20,$00,$02,$2A,$CA,$D0
$0230            .byte $F5,$18,$60,$80,$00,$00,$00,$00
$0238            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0240            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0248            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0250            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0258            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0260            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0268            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0270            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0278            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0280            .byte $00,$00,$08,$00,$A0,$00,$00,$0E
$0288            .byte $04,$0A,$00,$04,$10,$00,$00,$48
$0290            .byte $EB,$80,$00,$00,$00,$00,$00,$00
$0298            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02A0            .byte $00,$00,$00,$00,$00,$00,$01,$00
$02A8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02B0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02B8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02C0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02C8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02D0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02D8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02E0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02E8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02F0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02F8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0300            .byte $8B,$E3,$83,$A4,$7C,$A5,$1A,$A7
$0308            .byte $E4,$A7,$86,$AE,$00,$00,$00,$00
$0310            .byte $4C,$48,$B2,$00,$31,$EA,$66,$FE
$0318            .byte $47,$FE,$4A,$F3,$91,$F2,$0E,$F2
$0320            .byte $50,$F2,$33,$F3,$57,$F1,$CA,$F1
$0328            .byte $EA,$F6,$3E,$F1,$2F,$F3,$66,$FE
$0330            .byte $A5,$F4,$ED,$F5,$01,$00,$00,$01
$0338            .byte $01,$02,$03,$04,$04,$02,$04,$03
$0340            .byte $05,$07,$0B,$07,$03,$04,$04,$05
$0348            .byte $05,$05,$06,$06,$07,$07,$09,$09
$0350            .byte $0A,$0B,$0C,$0F,$01,$02,$03,$04
$0358            .byte $05,$05,$05,$06,$06,$07,$07,$02
$0360            .byte $07,$08,$08,$09,$01,$01,$02,$02
$0368            .byte $01,$03,$04,$05,$07,$09,$0D,$15
$0370            .byte $25,$35,$39,$49,$51,$71,$F1,$F1
$0378            .byte $01,$09,$19,$29,$49,$69,$89,$C9
$0380            .byte $09,$89,$09,$09,$09,$09,$09,$09
$0388            .byte $01,$03,$07,$0F,$1F,$3F,$5F,$7F
$0390            .byte $BF,$FF,$7F,$FF,$03,$83,$83,$83
$0398            .byte $01,$03,$05,$09,$00,$00,$00,$00
$03A0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$03A8            .byte $00,$00,$00,$08,$00,$00,$00,$00
$03B0            .byte $00,$00,$00,$00,$01,$01,$02,$04
$03B8            .byte $06,$0A,$12,$22,$00,$00,$00,$00
$03C0            .byte $00,$00,$00,$00,$00,$00,$01,$01
$03C8            .byte $02,$02,$03,$04,$00,$00,$00,$00
$03D0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$03D8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$03E0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$03E8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$03F0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$03F8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0400            .byte $53,$4B,$4F,$4F,$4C,$20,$44,$41
$0408            .byte $5A,$45,$2B,$36,$20,$20,$54,$12
$0410            .byte $01,$09,$0E,$05,$04,$20,$02,$19
$0418            .byte $20,$54,$43,$45,$2F,$48,$46,$20
$0420            .byte $0F,$0E,$20,$44,$05,$03,$30,$33
$0428            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0430            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0438            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0440            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0448            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0450            .byte $57,$41,$4E,$4E,$41,$20,$41,$56
$0458            .byte $4F,$49,$44,$20,$47,$45,$54,$54
$0460            .byte $49,$4E,$47,$20,$4C,$49,$4E,$45
$0468            .byte $53,$20,$28,$59,$2F,$4E,$29,$3F
$0470            .byte $20,$4E,$20,$20,$20,$20,$20,$20
$0478            .byte $54,$45,$41,$43,$48,$45,$52,$53
$0480            .byte $20,$53,$54,$4F,$50,$20,$41,$4E
$0488            .byte $4E,$4F,$59,$49,$4E,$47,$20,$59
$0490            .byte $41,$20,$28,$59,$2F,$4E,$29,$3F
$0498            .byte $20,$4E,$20,$20,$20,$20,$20,$20
$04A0            .byte $57,$41,$4E,$4E,$41,$20,$53,$45
$04A8            .byte $54,$20,$4D,$12,$2E,$43,$52,$45
$04B0            .byte $41,$4B,$27,$53,$20,$42,$49,$52
$04B8            .byte $54,$48,$44,$41,$54,$45,$20,$28
$04C0            .byte $59,$2F,$4E,$29,$3F,$20,$4E,$20
$04C8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04D0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04D8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04E0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04E8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04F0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04F8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0500            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0508            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0510            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0518            .byte $53,$45,$54,$20,$48,$46,$48,$46
$0520            .byte $20,$41,$53,$20,$53,$41,$46,$45
$0528            .byte $27,$53,$20,$43,$4F,$4D,$42,$49
$0530            .byte $4E,$41,$54,$49,$4F,$4E,$20,$28
$0538            .byte $59,$2F,$4E,$29,$3F,$20,$4E,$20
$0540            .byte $43,$4F,$4D,$42,$49,$4E,$41,$54
$0548            .byte $49,$4F,$4E,$27,$53,$20,$4C,$45
$0550            .byte $54,$54,$45,$52,$53,$20,$4E,$4F
$0558            .byte $54,$20,$4D,$49,$58,$45,$44,$20
$0560            .byte $1B,$57,$41,$43,$4B,$45,$52,$2C
$0568            .byte $52,$4F,$43,$4B,$49,$54,$54,$2C
$0570            .byte $20,$57,$49,$54,$48,$49,$54,$2C
$0578            .byte $20,$43,$52,$45,$41,$4B,$1D,$20
$0580            .byte $28,$59,$2F,$4E,$29,$3F,$20,$4E
$0588            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0590            .byte $41,$4C,$4C,$20,$53,$48,$49,$45
$0598            .byte $4C,$44,$53,$20,$41,$43,$54,$49
$05A0            .byte $56,$41,$54,$45,$44,$2F,$44,$45
$05A8            .byte $41,$43,$54,$49,$56,$41,$54,$45
$05B0            .byte $44,$20,$41,$54,$20,$54,$48,$45
$05B8            .byte $53,$41,$4D,$45,$20,$54,$49,$4D
$05C0            .byte $45,$20,$28,$59,$2F,$4E,$29,$3F
$05C8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05D0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05D8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05E0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05E8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05F0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05F8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0600            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0608            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0610            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0618            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0620            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0628            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0630            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0638            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0640            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0648            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0650            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0658            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0660            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0668            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0670            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0678            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0680            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0688            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0690            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0698            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06A0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06A8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06B0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06B8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06C0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06C8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06D0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06D8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06E0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06E8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06F0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06F8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0700            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0708            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0710            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0718            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0720            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0728            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0730            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0738            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0740            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0748            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0750            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0758            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0760            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0768            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0770            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0778            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0780            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0788            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0790            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0798            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07A0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07A8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07B0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07B8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07C0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07C8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07D0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07D8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07E0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07E8            .byte $FF,$80,$00,$00,$70,$78,$29,$FF
$07F0            .byte $9A,$A2,$49,$BD,$1E,$08,$7F,$95
$07F8            .byte $EA,$F1,$F8,$A0,$7E,$6F,$2E,$00
//------------------------------
L_JMP_($0800)_($C1D2) OK
L_JMP_($0800)_($FDEE) OK
//------------------------------
$0800  20 D9 2C  JSR L_JSR_($2CD9)_($0800) OK	; Startup
//------------------------------
L_JMP_($0803)_($086A) OK
L_JMP_($0803)_($2779) OK
//------------------------------
$0803  A5 46     LDA $46 
$0805  F0 03     BEQ L_BRS_($080A)_($0805) OK
$0807  20 09 BE  JSR L_JSR_($BE09)_($0807) OK
//------------------------------
L_BRS_($080A)_($0805) OK
//------------------------------
$080A  20 D5 3A  JSR L_JSR_($3AD5)_($080A) OK
$080D  20 00 BA  JSR L_JSR_($BA00)_($080D) OK	; Play startup music
$0810  20 12 30  JSR L_JSR_($3012)_($0810) OK
//------------------------------
L_JMP_($0813)_($091D) OK
//------------------------------
$0813  A9 01     LDA #$01
$0815  85 2E     STA $2E 
$0817  C6 FD     DEC $FD 
$0819  D0 07     BNE L_BRS_($0822)_($0819) OK
$081B  C6 40     DEC $40 
$081D  D0 03     BNE L_BRS_($0822)_($081D) OK
$081F  20 D5 3A  JSR L_JSR_($3AD5)_($081F) OK
//------------------------------
L_BRS_($0822)_($0819) OK
L_BRS_($0822)_($081D) OK
L_JSR_($0824)_($B348) BAD
L_JSR_($0824)_($EFC3) BAD
//------------------------------
$0822  20 9F 14  JSR L_JSR_($149F)_($0822) OK
$0825  20 00 BD  JSR L_JSR_($BD00)_($0825) OK
$0828  A5 2B     LDA $2B 
$082A  F0 12     BEQ L_BRS_($083E)_($082A) OK
$082C  20 B3 15  JSR L_JSR_($15B3)_($082C) OK
$082F  20 B4 3A  JSR L_JSR_($3AB4)_($082F) OK
$0832  20 B4 3A  JSR L_JSR_($3AB4)_($0832) OK
$0835  20 B4 3A  JSR L_JSR_($3AB4)_($0835) OK
$0838  20 B4 3A  JSR L_JSR_($3AB4)_($0838) OK
$083B  4C 16 09  JMP L_JMP_($0916)_($083B) OK
//------------------------------
L_BRS_($083E)_($082A) OK
//------------------------------
$083E  20 B4 3A  JSR L_JSR_($3AB4)_($083E) OK
$0841  20 B4 3A  JSR L_JSR_($3AB4)_($0841) OK
$0844  20 B4 3A  JSR L_JSR_($3AB4)_($0844) OK
$0847  20 B4 3A  JSR L_JSR_($3AB4)_($0847) OK
$084A  A9 80     LDA #$80
$084C  8D 12 D4  STA $D412                          // Voice 3: Control Register ; Noise enabled
$084F  C6 E5     DEC $E5 
$0851  F0 03     BEQ L_BRS_($0856)_($0851) OK
$0853  4C 16 09  JMP L_JMP_($0916)_($0853) OK
//------------------------------
L_BRS_($0856)_($0851) OK
//------------------------------
$0856  A5 46     LDA $46 
$0858  D0 16     BNE L_BRS_($0870)_($0858) OK
$085A  A5 4C     LDA $4C 
$085C  85 C5     STA $C5 
$085E  A0 00     LDY #$00
$0860  84 4C     STY $4C 
$0862  A5 C5     LDA $C5 
$0864  F0 07     BEQ L_BRS_($086D)_($0864) OK
$0866  A9 01     LDA #$01
$0868  85 46     STA $46 
$086A  4C 03 08  JMP L_JMP_($0803)_($086A) OK
//------------------------------
L_BRS_($086D)_($0864) OK
//------------------------------
$086D  4C 20 09  JMP L_JMP_($0920)_($086D) OK
//------------------------------
L_BRS_($0870)_($0858) OK
//------------------------------
$0870  A5 60     LDA $60 
$0872  48        PHA 
$0873  A9 14     LDA #$14
$0875  85 60     STA $60 
$0877  20 79 32  JSR L_JSR_($3279)_($0877) OK
$087A  A5 4B     LDA $4B 
$087C  F0 03     BEQ L_BRS_($0881)_($087C) OK
$087E  4C FF 08  JMP L_JMP_($08FF)_($087E) OK
//------------------------------
L_BRS_($0881)_($087C) OK
//------------------------------
$0881  A5 4C     LDA $4C 
$0883  85 C5     STA $C5 
$0885  A0 00     LDY #$00
$0887  84 4C     STY $4C 
$0889  A5 C5     LDA $C5 
$088B  D0 03     BNE L_BRS_($0890)_($088B) OK
$088D  4C FA 08  JMP L_JMP_($08FA)_($088D) OK
//------------------------------
L_BRS_($0890)_($088B) OK
L_JMP_($0890)_($09DB) OK
//------------------------------
$0890  A9 04     LDA #$04
$0892  85 E5     STA $E5 
$0894  A5 C5     LDA $C5 
$0896  29 7F     AND #$7F
$0898  C9 4F     CMP #$4F
$089A  D0 06     BNE L_BRS_($08A2)_($089A) OK
$089C  20 58 35  JSR L_JSR_($3558)_($089C) OK
$089F  4C 10 09  JMP L_JMP_($0910)_($089F) OK
//------------------------------
L_BRS_($08A2)_($089A) OK
//------------------------------
$08A2  C9 50     CMP #$50
$08A4  D0 06     BNE L_BRS_($08AC)_($08A4) OK
$08A6  20 9E 35  JSR L_JSR_($359E)_($08A6) OK
$08A9  4C 10 09  JMP L_JMP_($0910)_($08A9) OK
//------------------------------
L_BRS_($08AC)_($08A4) OK
//------------------------------
$08AC  C9 51     CMP #$51
$08AE  D0 06     BNE L_BRS_($08B6)_($08AE) OK
$08B0  20 0B 35  JSR L_JSR_($350B)_($08B0) OK
$08B3  4C 10 09  JMP L_JMP_($0910)_($08B3) OK
//------------------------------
L_BRS_($08B6)_($08AE) OK
//------------------------------
$08B6  C9 41     CMP #$41
$08B8  D0 06     BNE L_BRS_($08C0)_($08B8) OK
$08BA  20 B5 34  JSR L_JSR_($34B5)_($08BA) OK
$08BD  4C 10 09  JMP L_JMP_($0910)_($08BD) OK
//------------------------------
L_BRS_($08C0)_($08B8) OK
//------------------------------
$08C0  C9 53     CMP #$53
$08C2  D0 06     BNE L_BRS_($08CA)_($08C2) OK
$08C4  20 87 36  JSR L_JSR_($3687)_($08C4) OK
$08C7  4C 10 09  JMP L_JMP_($0910)_($08C7) OK
//------------------------------
L_BRS_($08CA)_($08C2) OK
//------------------------------
$08CA  C9 48     CMP #$48
$08CC  D0 06     BNE L_BRS_($08D4)_($08CC) OK
$08CE  20 DF 16  JSR L_JSR_($16DF)_($08CE) OK
$08D1  4C 10 09  JMP L_JMP_($0910)_($08D1) OK
//------------------------------
L_BRS_($08D4)_($08CC) OK
//------------------------------
$08D4  C9 57     CMP #$57
$08D6  D0 06     BNE L_BRS_($08DE)_($08D6) OK
$08D8  20 A5 19  JSR L_JSR_($19A5)_($08D8) OK
$08DB  4C 10 09  JMP L_JMP_($0910)_($08DB) OK
//------------------------------
L_BRS_($08DE)_($08D6) OK
//------------------------------
$08DE  C9 4A     CMP #$4A
$08E0  F0 04     BEQ L_BRS_($08E6)_($08E0) OK
$08E2  C9 4C     CMP #$4C
$08E4  D0 06     BNE L_BRS_($08EC)_($08E4) OK
//------------------------------
L_BRS_($08E6)_($08E0) OK
//------------------------------
$08E6  20 D0 16  JSR L_JSR_($16D0)_($08E6) OK
$08E9  4C 10 09  JMP L_JMP_($0910)_($08E9) OK
//------------------------------
L_BRS_($08EC)_($08E4) OK
//------------------------------
$08EC  C9 46     CMP #$46
$08EE  F0 04     BEQ L_BRS_($08F4)_($08EE) OK
$08F0  C9 20     CMP #$20
$08F2  D0 03     BNE L_BRS_($08F7)_($08F2) OK
//------------------------------
L_BRS_($08F4)_($08EE) OK
//------------------------------
$08F4  20 9B 16  JSR L_JSR_($169B)_($08F4) OK
//------------------------------
L_BRS_($08F7)_($08F2) OK
//------------------------------
$08F7  4C 10 09  JMP L_JMP_($0910)_($08F7) OK
//------------------------------
L_JMP_($08FA)_($088D) OK
L_JMP_($08FA)_($09E5) OK
//------------------------------
$08FA  E6 E5     INC $E5 
$08FC  4C 10 09  JMP L_JMP_($0910)_($08FC) OK
//------------------------------
L_JMP_($08FF)_($087E) OK
L_BRS_($08FF)_($0938) OK
//------------------------------
$08FF  A9 04     LDA #$04
$0901  85 E5     STA $E5 
$0903  A9 00     LDA #$00
$0905  85 4B     STA $4B 
$0907  20 EF 35  JSR L_JSR_($35EF)_($0907) OK
$090A  68        PLA 
$090B  85 60     STA $60 
$090D  4C 19 09  JMP L_JMP_($0919)_($090D) OK
//------------------------------
L_JMP_($0910)_($089F) OK
L_JMP_($0910)_($08A9) OK
L_JMP_($0910)_($08B3) OK
L_JMP_($0910)_($08BD) OK
L_JMP_($0910)_($08C7) OK
L_JMP_($0910)_($08D1) OK
L_JMP_($0910)_($08DB) OK
L_JMP_($0910)_($08E9) OK
L_JMP_($0910)_($08F7) OK
L_JMP_($0910)_($08FC) OK
//------------------------------
$0910  20 BF 33  JSR L_JSR_($33BF)_($0910) OK
$0913  68        PLA 
$0914  85 60     STA $60 
//------------------------------
L_JMP_($0916)_($083B) OK
L_JMP_($0916)_($0853) OK
//------------------------------
$0916  20 EA 31  JSR L_JSR_($31EA)_($0916) OK
//------------------------------
L_JMP_($0919)_($090D) OK
L_BRS_($0919)_($091B) OK
//------------------------------
$0919  A5 2E     LDA $2E 
$091B  10 FC     BPL L_BRS_($0919)_($091B) OK
$091D  4C 13 08  JMP L_JMP_($0813)_($091D) OK
//------------------------------
L_JMP_($0920)_($086D) OK
//------------------------------
$0920  A9 00     LDA #$00
$0922  85 7D     STA $7D 
$0924  85 7C     STA $7C 
$0926  85 7F     STA $7F 
$0928  85 7E     STA $7E 
$092A  A5 60     LDA $60 
$092C  48        PHA 
$092D  A9 14     LDA #$14
$092F  85 60     STA $60 
$0931  20 79 32  JSR L_JSR_($3279)_($0931) OK
$0934  A5 4B     LDA $4B 
$0936  F0 02     BEQ L_BRS_($093A)_($0936) OK
$0938  D0 C5     BNE L_BRS_($08FF)_($0938) OK
//------------------------------
L_BRS_($093A)_($0936) OK
//------------------------------
$093A  A5 26     LDA $26 
$093C  C9 05     CMP #$05
$093E  F0 0C     BEQ L_BRS_($094C)_($093E) OK
$0940  A5 14     LDA $14 
$0942  F0 18     BEQ L_BRS_($095C)_($0942) OK
$0944  A5 2B     LDA $2B 
$0946  29 10     AND #$10
$0948  D0 12     BNE L_BRS_($095C)_($0948) OK
$094A  F0 26     BEQ L_BRS_($0972)_($094A) OK
//------------------------------
L_BRS_($094C)_($093E) OK
//------------------------------
$094C  A9 0A     LDA #$0A
$094E  85 60     STA $60 
$0950  20 79 32  JSR L_JSR_($3279)_($0950) OK
$0953  A5 26     LDA $26 
$0955  C9 45     CMP #$45
$0957  D0 03     BNE L_BRS_($095C)_($0957) OK
//------------------------------
L_BRS_($0959)_($0969) OK
//------------------------------
$0959  4C DE 09  JMP L_JMP_($09DE)_($0959) OK
//------------------------------
L_BRS_($095C)_($0942) OK
L_BRS_($095C)_($0948) OK
L_BRS_($095C)_($0957) OK
//------------------------------
$095C  A5 81     LDA $81 
$095E  D0 07     BNE L_BRS_($0967)_($095E) OK
$0960  A9 40     LDA #$40
$0962  85 81     STA $81 
$0964  4C DE 09  JMP L_JMP_($09DE)_($0964) OK
//------------------------------
L_BRS_($0967)_($095E) OK
//------------------------------
$0967  C6 81     DEC $81 
$0969  D0 EE     BNE L_BRS_($0959)_($0969) OK
$096B  A9 53     LDA #$53
$096D  85 C5     STA $C5 
$096F  4C D4 09  JMP L_JMP_($09D4)_($096F) OK
//------------------------------
L_BRS_($0972)_($094A) OK
//------------------------------
$0972  A9 0A     LDA #$0A
$0974  85 4D     STA $4D 
$0976  20 2E 1B  JSR L_JSR_($1B2E)_($0976) OK
$0979  F0 32     BEQ L_BRS_($09AD)_($0979) OK
$097B  C9 01     CMP #$01
$097D  D0 05     BNE L_BRS_($0984)_($097D) OK
$097F  A9 51     LDA #$51
$0981  4C 98 09  JMP L_JMP_($0998)_($0981) OK
//------------------------------
L_BRS_($0984)_($097D) OK
//------------------------------
$0984  C9 02     CMP #$02
$0986  D0 05     BNE L_BRS_($098D)_($0986) OK
$0988  A9 41     LDA #$41
//------------------------------
L_JSR_($098A)_($CB5F) OK
//------------------------------
$098A  4C 98 09  JMP L_JMP_($0998)_($098A) OK
//------------------------------
L_BRS_($098D)_($0986) OK
//------------------------------
$098D  C9 03     CMP #$03
$098F  D0 05     BNE L_BRS_($0996)_($098F) OK
$0991  A9 4F     LDA #$4F
$0993  4C 98 09  JMP L_JMP_($0998)_($0993) OK
//------------------------------
L_BRS_($0996)_($098F) OK
//------------------------------
$0996  A9 50     LDA #$50
//------------------------------
L_JMP_($0998)_($0981) OK
L_JMP_($0998)_($098A) OK
L_JMP_($0998)_($0993) OK
//------------------------------
$0998  85 C5     STA $C5 
$099A  A5 82     LDA $82 
$099C  C9 81     CMP #$81
$099E  B0 03     BCS L_BRS_($09A3)_($099E) OK
$09A0  4C D4 09  JMP L_JMP_($09D4)_($09A0) OK
//------------------------------
L_BRS_($09A3)_($099E) OK
//------------------------------
$09A3  A9 80     LDA #$80
$09A5  18        CLC 
$09A6  65 C5     ADC $C5 
$09A8  85 C5     STA $C5 
$09AA  4C D4 09  JMP L_JMP_($09D4)_($09AA) OK
//------------------------------
L_BRS_($09AD)_($0979) OK
//------------------------------
$09AD  A9 0A     LDA #$0A
$09AF  85 60     STA $60 
$09B1  20 79 32  JSR L_JSR_($3279)_($09B1) OK
$09B4  A5 26     LDA $26 
$09B6  C9 45     CMP #$45
$09B8  F0 03     BEQ L_BRS_($09BD)_($09B8) OK
$09BA  4C DE 09  JMP L_JMP_($09DE)_($09BA) OK
//------------------------------
L_BRS_($09BD)_($09B8) OK
//------------------------------
$09BD  A9 14     LDA #$14
$09BF  85 60     STA $60 
$09C1  20 79 32  JSR L_JSR_($3279)_($09C1) OK
$09C4  A5 26     LDA $26 
$09C6  0A        ASL A 
$09C7  90 07     BCC L_BRS_($09D0)_($09C7) OK
$09C9  A9 4F     LDA #$4F
$09CB  85 C5     STA $C5 
$09CD  4C D4 09  JMP L_JMP_($09D4)_($09CD) OK
//------------------------------
L_BRS_($09D0)_($09C7) OK
//------------------------------
$09D0  A9 53     LDA #$53
$09D2  85 C5     STA $C5 
//------------------------------
L_JMP_($09D4)_($096F) OK
L_JMP_($09D4)_($09A0) OK
L_JMP_($09D4)_($09AA) OK
L_JMP_($09D4)_($09CD) OK
//------------------------------
$09D4  A9 14     LDA #$14
$09D6  85 60     STA $60 
$09D8  20 79 32  JSR L_JSR_($3279)_($09D8) OK
$09DB  4C 90 08  JMP L_JMP_($0890)_($09DB) OK
//------------------------------
L_JMP_($09DE)_($0959) OK
L_JMP_($09DE)_($0964) OK
L_JMP_($09DE)_($09BA) OK
//------------------------------
$09DE  A9 14     LDA #$14
$09E0  85 60     STA $60 
$09E2  20 79 32  JSR L_JSR_($3279)_($09E2) OK
$09E5  4C FA 08  JMP L_JMP_($08FA)_($09E5) OK
$09E8  4D A5 70  EOR $70A5 
$09EB  29 F0     AND #$F0
$09ED  85 57     STA $57 
$09EF  A5 60     LDA $60 
$09F1  38        SEC 
$09F2  E9 0B     SBC #$0B
$09F4  0A        ASL A 
$09F5  0A        ASL A 
$09F6  0A        ASL A 
$09F7  0A        ASL A 
$09F8  C5 57     CMP $57 
$09FA  D0 03     BNE L_BRS_($09FF)_($09FA) OK
$09FC  4C 58 0A  JMP L_JMP_($0A58)_($09FC) OK
//------------------------------
L_BRS_($09FF)_($09FA) OK
//------------------------------
$09FF  A5 FB     LDA $FB 
$0A01  C9 03     CMP #$03
$0A03  F0 03     BEQ L_BRS_($0A08)_($0A03) OK
$0A05  4C 0E 0A  JMP L_JMP_($0A0E)_($0A05) OK
//------------------------------
L_BRS_($0A08)_($0A03) OK
//------------------------------
$0A08  A5 FC     LDA $FC 
$0A0A  C9 3B     CMP #$3B
$0A0C  B0 31     BCS L_BRS_($0A3F)_($0A0C) OK
//------------------------------
L_JMP_($0A0E)_($0A05) OK
//------------------------------
$0A0E  20 77 1F  JSR L_JSR_($1F77)_($0A0E) OK	; Jump to embedded address 16E9
$0A11  E9 16     SBC #$16
$0A13  A5 FC     LDA $FC 
$0A15  18        CLC 
$0A16  69 03     ADC #$03
$0A18  85 AC     STA $AC 
$0A1A  85 AD     STA $AD 
$0A1C  20 77 1F  JSR L_JSR_($1F77)_($0A1C) OK	; Jump to embedded address 136F
$0A1F            .byte $6F,$13
$0A21  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$0A24  C9 AB     CMP #$AB
$0A26  90 17     BCC L_BRS_($0A3F)_($0A26) OK
$0A28  20 77 1F  JSR L_JSR_($1F77)_($0A28) OK	; Jump to embedded address 1129
$0A2B  29 11     AND #$11
$0A2D  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$0A30  C9 A1     CMP #$A1
$0A32  90 0B     BCC L_BRS_($0A3F)_($0A32) OK
$0A34  A9 5C     LDA #$5C
$0A36  85 AD     STA $AD 
$0A38  A9 D6     LDA #$D6
$0A3A  85 AC     STA $AC 
$0A3C  4C 42 0A  JMP L_JMP_($0A42)_($0A3C) OK
//------------------------------
L_BRS_($0A3F)_($0A0C) OK
L_BRS_($0A3F)_($0A26) OK
L_BRS_($0A3F)_($0A32) OK
//------------------------------
$0A3F  20 00 25  JSR L_JSR_($2500)_($0A3F) OK
//------------------------------
L_JMP_($0A42)_($0A3C) OK
//------------------------------
$0A42  20 77 1F  JSR L_JSR_($1F77)_($0A42) OK	; Jump to embedded address 2387
$0A45            .byte $87,$23
//------------------------------
L_JMP_($0A47)_($0A54) OK
//------------------------------
$0A47  A5 FC     LDA $FC 
$0A49  49 03     EOR #$03
$0A4B  85 AC     STA $AC 
$0A4D  85 AD     STA $AD 
$0A4F  20 77 1F  JSR L_JSR_($1F77)_($0A4F) OK	; Jump to embedded address 136F
$0A52            .byte $6F,$13
$0A54  4C 47 0A  JMP L_JMP_($0A47)_($0A54) OK
$0A57  60        RTS 
//------------------------------
L_JMP_($0A58)_($09FC) OK
//------------------------------
$0A58  20 3B 0B  JSR L_JSR_($0B3B)_($0A58) OK
//------------------------------
L_JMP_($0A5B)_($0BA8) OK
//------------------------------
$0A5B  A9 01     LDA #$01
$0A5D  20 B6 31  JSR L_JSR_($31B6)_($0A5D) OK
$0A60  A9 02     LDA #$02
$0A62  20 B6 31  JSR L_JSR_($31B6)_($0A62) OK
$0A65  20 3B 0B  JSR L_JSR_($0B3B)_($0A65) OK
$0A68  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$0A6B  C9 E3     CMP #$E3
$0A6D  90 11     BCC L_BRS_($0A80)_($0A6D) OK
$0A6F  A2 F9     LDX #$F9
$0A71  A0 5A     LDY #$5A
$0A73  20 E3 1E  JSR L_JSR_($1EE3)_($0A73) OK
$0A76  A9 14     LDA #$14
$0A78  A0 08     LDY #$08
$0A7A  20 52 25  JSR L_JSR_($2552)_($0A7A) OK
$0A7D  20 3B 0B  JSR L_JSR_($0B3B)_($0A7D) OK
//------------------------------
L_BRS_($0A80)_($0A6D) OK
//------------------------------
$0A80  A5 FB     LDA $FB 
$0A82  C9 03     CMP #$03
$0A84  D0 09     BNE L_BRS_($0A8F)_($0A84) OK
$0A86  A5 FC     LDA $FC 
$0A88  C9 3B     CMP #$3B
$0A8A  90 03     BCC L_BRS_($0A8F)_($0A8A) OK
$0A8C  4C 1C 0B  JMP L_JMP_($0B1C)_($0A8C) OK
//------------------------------
L_BRS_($0A8F)_($0A84) OK
L_BRS_($0A8F)_($0A8A) OK
//------------------------------
$0A8F  20 68 14  JSR L_JSR_($1468)_($0A8F) OK
$0A92  A5 1A     LDA $1A 
$0A94  C9 14     CMP #$14
$0A96  F0 13     BEQ L_BRS_($0AAB)_($0A96) OK
$0A98  C9 10     CMP #$10
$0A9A  F0 03     BEQ L_BRS_($0A9F)_($0A9A) OK
$0A9C  4C D6 0A  JMP L_JMP_($0AD6)_($0A9C) OK
//------------------------------
L_BRS_($0A9F)_($0A9A) OK
//------------------------------
$0A9F  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$0AA2  C9 C9     CMP #$C9
$0AA4  B0 05     BCS L_BRS_($0AAB)_($0AA4) OK
$0AA6  A9 10     LDA #$10
$0AA8  4C AD 0A  JMP L_JMP_($0AAD)_($0AA8) OK
//------------------------------
L_BRS_($0AAB)_($0A96) OK
L_BRS_($0AAB)_($0AA4) OK
//------------------------------
$0AAB  A9 14     LDA #$14
//------------------------------
L_JMP_($0AAD)_($0AA8) OK
//------------------------------
$0AAD  48        PHA 
$0AAE  A9 5B     LDA #$5B
$0AB0  85 87     STA $87 
$0AB2  A9 12     LDA #$12
$0AB4  85 86     STA $86 
$0AB6  A0 01     LDY #$01
$0AB8  68        PLA 
$0AB9  85 C0     STA $C0 
$0ABB  C9 10     CMP #$10
$0ABD  F0 05     BEQ L_BRS_($0AC4)_($0ABD) OK
$0ABF  A9 10     LDA #$10
$0AC1  4C C6 0A  JMP L_JMP_($0AC6)_($0AC1) OK
//------------------------------
L_BRS_($0AC4)_($0ABD) OK
//------------------------------
$0AC4  A9 11     LDA #$11
//------------------------------
L_JMP_($0AC6)_($0AC1) OK
//------------------------------
$0AC6  91 86     STA ($86),Y 
$0AC8  A6 86     LDX $86 
$0ACA  A4 87     LDY $87 
$0ACC  20 E3 1E  JSR L_JSR_($1EE3)_($0ACC) OK
$0ACF  A5 C0     LDA $C0 
$0AD1  A0 0C     LDY #$0C
$0AD3  20 52 25  JSR L_JSR_($2552)_($0AD3) OK
//------------------------------
L_JMP_($0AD6)_($0A9C) OK
//------------------------------
$0AD6  20 77 1F  JSR L_JSR_($1F77)_($0AD6) OK	; Jump to embedded address 16E9
$0AD9  E9 16     SBC #$16
$0ADB  A5 FC     LDA $FC 
$0ADD  18        CLC 
$0ADE  69 03     ADC #$03
$0AE0  85 AC     STA $AC 
$0AE2  85 AD     STA $AD 
$0AE4  20 77 1F  JSR L_JSR_($1F77)_($0AE4) OK	; Jump to embedded address 136F
$0AE7            .byte $6F,$13
$0AE9  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$0AEC  C9 B5     CMP #$B5
$0AEE  90 2C     BCC L_BRS_($0B1C)_($0AEE) OK
$0AF0  20 77 1F  JSR L_JSR_($1F77)_($0AF0) OK	; Jump to embedded address 1129
$0AF3  29 11     AND #$11
$0AF5  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$0AF8  C9 A1     CMP #$A1
$0AFA  90 20     BCC L_BRS_($0B1C)_($0AFA) OK
$0AFC  A9 D6     LDA #$D6
$0AFE  85 AC     STA $AC 
$0B00  A9 5C     LDA #$5C
$0B02  85 AD     STA $AD 
//------------------------------
L_JMP_($0B04)_($0B26) OK
//------------------------------
$0B04  20 77 1F  JSR L_JSR_($1F77)_($0B04) OK	; Jump to embedded address 2387
$0B07            .byte $87,$23
//------------------------------
L_JMP_($0B09)_($0B19) OK
//------------------------------
$0B09  20 3B 0B  JSR L_JSR_($0B3B)_($0B09) OK
$0B0C  A5 FC     LDA $FC 
$0B0E  49 03     EOR #$03
$0B10  85 AC     STA $AC 
$0B12  85 AD     STA $AD 
$0B14  20 77 1F  JSR L_JSR_($1F77)_($0B14) OK	; Jump to embedded address 136F
$0B17            .byte $6F,$13
$0B19  4C 09 0B  JMP L_JMP_($0B09)_($0B19) OK
//------------------------------
L_JMP_($0B1C)_($0A8C) OK
L_BRS_($0B1C)_($0AEE) OK
L_BRS_($0B1C)_($0AFA) OK
//------------------------------
$0B1C  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$0B1F  C9 E1     CMP #$E1
$0B21  90 06     BCC L_BRS_($0B29)_($0B21) OK
$0B23  20 00 25  JSR L_JSR_($2500)_($0B23) OK
$0B26  4C 04 0B  JMP L_JMP_($0B04)_($0B26) OK
//------------------------------
L_BRS_($0B29)_($0B21) OK
L_JMP_($0B29)_($0B37) OK
//------------------------------
$0B29  20 3B 0B  JSR L_JSR_($0B3B)_($0B29) OK
$0B2C  20 41 22  JSR L_JSR_($2241)_($0B2C) OK
$0B2F  20 77 1F  JSR L_JSR_($1F77)_($0B2F) OK	; Jump to embedded address 2387
$0B32            .byte $87,$23
$0B34  20 05 1F  JSR L_JSR_($1F05)_($0B34) OK
$0B37  4C 29 0B  JMP L_JMP_($0B29)_($0B37) OK
$0B3A  60        RTS 
//------------------------------
L_JSR_($0B3B)_($0A58) OK
L_JSR_($0B3B)_($0A65) OK
L_JSR_($0B3B)_($0A7D) OK
L_JSR_($0B3B)_($0B09) OK
L_JSR_($0B3B)_($0B29) OK
//------------------------------
$0B3B  A9 89     LDA #$89
$0B3D  85 4F     STA $4F 
$0B3F  A9 60     LDA #$60
$0B41  85 4E     STA $4E 
$0B43  A0 00     LDY #$00
$0B45  B1 4E     LDA ($4E),Y 
$0B47  C9 15     CMP #$15
$0B49  F0 14     BEQ L_BRS_($0B5F)_($0B49) OK
$0B4B  68        PLA 
$0B4C  85 29     STA $29 
$0B4E  68        PLA 
$0B4F  85 2A     STA $2A 
$0B51  A5 29     LDA $29 
$0B53  38        SEC 
$0B54  E9 02     SBC #$02
$0B56  B0 02     BCS L_BRS_($0B5A)_($0B56) OK
$0B58  C6 2A     DEC $2A 
//------------------------------
L_BRS_($0B5A)_($0B56) OK
//------------------------------
$0B5A  85 29     STA $29 
$0B5C  4C AB 0B  JMP L_JMP_($0BAB)_($0B5C) OK
//------------------------------
L_BRS_($0B5F)_($0B49) OK
//------------------------------
$0B5F  20 91 0D  JSR L_JSR_($0D91)_($0B5F) OK
$0B62  F0 47     BEQ L_BRS_($0BAB)_($0B62) OK
$0B64  68        PLA 
$0B65  68        PLA 
$0B66  A0 5B     LDY #$5B
$0B68  A2 03     LDX #$03
$0B6A  20 E3 1E  JSR L_JSR_($1EE3)_($0B6A) OK
$0B6D  A9 11     LDA #$11
$0B6F  20 52 25  JSR L_JSR_($2552)_($0B6F) OK
$0B72  20 00 25  JSR L_JSR_($2500)_($0B72) OK
$0B75  20 77 1F  JSR L_JSR_($1F77)_($0B75) OK	; Jump to embedded address 2387
$0B78            .byte $87,$23
$0B7A  20 91 0D  JSR L_JSR_($0D91)_($0B7A) OK
//------------------------------
L_JSR_($0B7E)_($9B0C) BAD
L_JSR_($0B7E)_($D789) BAD
//------------------------------
$0B7D  F0 12     BEQ L_BRS_($0B91)_($0B7D) OK
$0B7F  A9 01     LDA #$01
$0B81  20 B6 31  JSR L_JSR_($31B6)_($0B81) OK
//------------------------------
L_JMP_($0B84)_($0E43) OK
//------------------------------
$0B84  A9 27     LDA #$27
$0B86  85 AF     STA $AF 
$0B88  A9 45     LDA #$45
$0B8A  85 AE     STA $AE 
$0B8C  20 77 1F  JSR L_JSR_($1F77)_($0B8C) OK	; Jump to embedded address 0C3F
$0B8F            .byte $3F,$0C
//------------------------------
L_BRS_($0B91)_($0B7D) OK
//------------------------------
$0B91  A9 01     LDA #$01
$0B93  20 D2 31  JSR L_JSR_($31D2)_($0B93) OK
$0B96  90 05     BCC L_BRS_($0B9D)_($0B96) OK
$0B98  A9 0B     LDA #$0B
$0B9A  4C 9F 0B  JMP L_JMP_($0B9F)_($0B9A) OK
//------------------------------
L_BRS_($0B9D)_($0B96) OK
//------------------------------
$0B9D  A9 0A     LDA #$0A
//------------------------------
L_JMP_($0B9F)_($0B9A) OK
//------------------------------
$0B9F  85 D8     STA $D8 
$0BA1  A9 14     LDA #$14
$0BA3  85 72     STA $72 
$0BA5  20 B7 1D  JSR L_JSR_($1DB7)_($0BA5) OK
$0BA8  4C 5B 0A  JMP L_JMP_($0A5B)_($0BA8) OK
//------------------------------
L_JMP_($0BAB)_($0B5C) OK
L_BRS_($0BAB)_($0B62) OK
//------------------------------
$0BAB  60        RTS 
//------------------------------
L_JSR_($0BAC)_($0E5D) OK
L_JSR_($0BAC)_($0ECF) OK
//------------------------------
$0BAC  A5 FB     LDA $FB 
$0BAE  38        SEC 
$0BAF  E9 03     SBC #$03
$0BB1  10 02     BPL L_BRS_($0BB5)_($0BB1) OK
$0BB3  A9 00     LDA #$00
//------------------------------
L_BRS_($0BB5)_($0BB1) OK
//------------------------------
$0BB5  85 73     STA $73 
$0BB7  A5 FB     LDA $FB 
$0BB9  18        CLC 
$0BBA  69 03     ADC #$03
$0BBC  85 74     STA $74 
$0BBE  A5 FB     LDA $FB 
$0BC0  C9 04     CMP #$04
$0BC2  90 41     BCC L_BRS_($0C05)_($0BC2) OK
$0BC4  C9 0B     CMP #$0B
$0BC6  90 1A     BCC L_BRS_($0BE2)_($0BC6) OK
$0BC8  A5 FC     LDA $FC 
$0BCA  18        CLC 
$0BCB  69 0A     ADC #$0A
$0BCD  85 76     STA $76 
$0BCF  A5 FC     LDA $FC 
//------------------------------
L_BRS_($0BD1)_($0BF1) OK
L_JMP_($0BD1)_($0C02) OK
L_BRS_($0BD1)_($0C14) OK
L_JMP_($0BD1)_($0C25) OK
L_JMP_($0BD1)_($0C2D) OK
//------------------------------
$0BD1  38        SEC 
$0BD2  E9 0A     SBC #$0A
$0BD4  85 75     STA $75 
$0BD6  30 03     BMI L_BRS_($0BDB)_($0BD6) OK
$0BD8  4C 30 0C  JMP L_JMP_($0C30)_($0BD8) OK
//------------------------------
L_BRS_($0BDB)_($0BD6) OK
//------------------------------
$0BDB  A9 00     LDA #$00
$0BDD  85 75     STA $75 
$0BDF  4C 30 0C  JMP L_JMP_($0C30)_($0BDF) OK
//------------------------------
L_BRS_($0BE2)_($0BC6) OK
//------------------------------
$0BE2  A5 FC     LDA $FC 
$0BE4  C9 26     CMP #$26
$0BE6  90 12     BCC L_BRS_($0BFA)_($0BE6) OK
$0BE8  18        CLC 
$0BE9  69 0A     ADC #$0A
$0BEB  85 76     STA $76 
$0BED  A5 FC     LDA $FC 
$0BEF  C9 30     CMP #$30
$0BF1  B0 DE     BCS L_BRS_($0BD1)_($0BF1) OK
$0BF3  A9 26     LDA #$26
$0BF5  85 75     STA $75 
$0BF7  4C 30 0C  JMP L_JMP_($0C30)_($0BF7) OK
//------------------------------
L_BRS_($0BFA)_($0BE6) OK
//------------------------------
$0BFA  C9 1C     CMP #$1C
$0BFC  90 2A     BCC L_BRS_($0C28)_($0BFC) OK
$0BFE  A9 25     LDA #$25
$0C00  85 76     STA $76 
$0C02  4C D1 0B  JMP L_JMP_($0BD1)_($0C02) OK
//------------------------------
L_BRS_($0C05)_($0BC2) OK
//------------------------------
$0C05  A5 FC     LDA $FC 
$0C07  C9 39     CMP #$39
$0C09  90 12     BCC L_BRS_($0C1D)_($0C09) OK
$0C0B  18        CLC 
$0C0C  69 0A     ADC #$0A
$0C0E  85 76     STA $76 
$0C10  A5 FC     LDA $FC 
$0C12  C9 43     CMP #$43
$0C14  B0 BB     BCS L_BRS_($0BD1)_($0C14) OK
$0C16  A9 39     LDA #$39
$0C18  85 75     STA $75 
$0C1A  4C 30 0C  JMP L_JMP_($0C30)_($0C1A) OK
//------------------------------
L_BRS_($0C1D)_($0C09) OK
//------------------------------
$0C1D  C9 2F     CMP #$2F
$0C1F  90 07     BCC L_BRS_($0C28)_($0C1F) OK
$0C21  A9 38     LDA #$38
$0C23  85 76     STA $76 
$0C25  4C D1 0B  JMP L_JMP_($0BD1)_($0C25) OK
//------------------------------
L_BRS_($0C28)_($0BFC) OK
L_BRS_($0C28)_($0C1F) OK
//------------------------------
$0C28  18        CLC 
$0C29  69 0A     ADC #$0A
$0C2B  85 76     STA $76 
$0C2D  4C D1 0B  JMP L_JMP_($0BD1)_($0C2D) OK
//------------------------------
L_JMP_($0C30)_($0BD8) OK
L_JMP_($0C30)_($0BDF) OK
L_JMP_($0C30)_($0BF7) OK
L_JMP_($0C30)_($0C1A) OK
//------------------------------
$0C30  60        RTS 
//------------------------------
$0C31  90 07     BCC L_BRS_($0C3A)_($0C31) OK
$0C33  A9 0F     LDA #$0F
$0C35  85 40     STA $40 
$0C37  4C 28 1D  JMP L_JMP_($1D28)_($0C37) OK
//------------------------------
L_BRS_($0C3A)_($0C31) OK
//------------------------------
$0C3A  A9 FF     LDA #$FF
$0C3C  85 40     STA $40 
$0C3E  60        RTS 
//------------------------------
$0C3F  A5 3F     LDA $3F 
$0C41  09 40     ORA #$40
$0C43  85 3F     STA $3F 
$0C45  20 C2 1E  JSR L_JSR_($1EC2)_($0C45) OK
$0C48  86 08     STX $08 
$0C4A  84 09     STY $09 
$0C4C  20 8E 1C  JSR L_JSR_($1C8E)_($0C4C) OK
$0C4F  B0 43     BCS L_BRS_($0C94)_($0C4F) OK
$0C51  A5 FB     LDA $FB 
$0C53  C5 09     CMP $09 
$0C55  B0 0C     BCS L_BRS_($0C63)_($0C55) OK
$0C57  A5 09     LDA $09 
$0C59  38        SEC 
$0C5A  E5 FB     SBC $FB 
$0C5C  C9 04     CMP #$04
$0C5E  B0 34     BCS L_BRS_($0C94)_($0C5E) OK
$0C60  4C 6A 0C  JMP L_JMP_($0C6A)_($0C60) OK
//------------------------------
L_BRS_($0C63)_($0C55) OK
//------------------------------
$0C63  38        SEC 
$0C64  E5 09     SBC $09 
$0C66  C9 04     CMP #$04
$0C68  B0 2A     BCS L_BRS_($0C94)_($0C68) OK
//------------------------------
L_JMP_($0C6A)_($0C60) OK
//------------------------------
$0C6A  A5 26     LDA $26 
$0C6C  0A        ASL A 
$0C6D  B0 12     BCS L_BRS_($0C81)_($0C6D) OK
$0C6F  A5 FC     LDA $FC 
$0C71  C5 08     CMP $08 
$0C73  90 1F     BCC L_BRS_($0C94)_($0C73) OK
$0C75  A5 08     LDA $08 
$0C77  18        CLC 
$0C78  69 03     ADC #$03
$0C7A  C5 FC     CMP $FC 
$0C7C  90 16     BCC L_BRS_($0C94)_($0C7C) OK
$0C7E  4C 90 0C  JMP L_JMP_($0C90)_($0C7E) OK
//------------------------------
L_BRS_($0C81)_($0C6D) OK
//------------------------------
$0C81  A5 FC     LDA $FC 
$0C83  C5 08     CMP $08 
$0C85  B0 0D     BCS L_BRS_($0C94)_($0C85) OK
$0C87  A5 08     LDA $08 
$0C89  38        SEC 
//------------------------------
L_JSR_($0C8A)_($CBC6) OK
//------------------------------
$0C8A  E9 04     SBC #$04
$0C8C  C5 FC     CMP $FC 
$0C8E  B0 04     BCS L_BRS_($0C94)_($0C8E) OK
//------------------------------
L_JMP_($0C90)_($0C7E) OK
//------------------------------
$0C90  38        SEC 
$0C91  6C AE 00  JMP ($00AE) 
//------------------------------
L_BRS_($0C94)_($0C4F) OK
L_BRS_($0C94)_($0C5E) OK
L_BRS_($0C94)_($0C68) OK
L_BRS_($0C94)_($0C73) OK
L_BRS_($0C94)_($0C7C) OK
L_BRS_($0C94)_($0C85) OK
L_BRS_($0C94)_($0C8E) OK
//------------------------------
$0C94  A9 14     LDA #$14
$0C96  85 4D     STA $4D 
$0C98  20 2E 1B  JSR L_JSR_($1B2E)_($0C98) OK
$0C9B  85 77     STA $77 
$0C9D  20 2E 32  JSR L_JSR_($322E)_($0C9D) OK
$0CA0  A5 77     LDA $77 
$0CA2  D0 03     BNE L_BRS_($0CA7)_($0CA2) OK
$0CA4  4C 66 0D  JMP L_JMP_($0D66)_($0CA4) OK
//------------------------------
L_BRS_($0CA7)_($0CA2) OK
//------------------------------
$0CA7  C9 03     CMP #$03
$0CA9  D0 33     BNE L_BRS_($0CDE)_($0CA9) OK
$0CAB  A5 26     LDA $26 
$0CAD  0A        ASL A 
$0CAE  90 14     BCC L_BRS_($0CC4)_($0CAE) OK
//------------------------------
L_BRS_($0CB0)_($0CE5) OK
//------------------------------
$0CB0  A5 26     LDA $26 
$0CB2  49 80     EOR #$80
$0CB4  85 26     STA $26 
//------------------------------
L_JMP_($0CB6)_($0D63) OK
//------------------------------
$0CB6  20 2E 32  JSR L_JSR_($322E)_($0CB6) OK
$0CB9  20 8E 1C  JSR L_JSR_($1C8E)_($0CB9) OK
$0CBC  90 03     BCC L_BRS_($0CC1)_($0CBC) OK
$0CBE  4C 66 0D  JMP L_JMP_($0D66)_($0CBE) OK
//------------------------------
L_BRS_($0CC1)_($0CBC) OK
//------------------------------
$0CC1  6C AE 00  JMP ($00AE) 
//------------------------------
L_BRS_($0CC4)_($0CAE) OK
//------------------------------
$0CC4  A5 FC     LDA $FC 
$0CC6  85 AC     STA $AC 
$0CC8  C6 AC     DEC $AC 
//------------------------------
L_JMP_($0CCA)_($0CED) OK
//------------------------------
$0CCA  A5 FB     LDA $FB 
$0CCC  85 AD     STA $AD 
//------------------------------
L_JMP_($0CCE)_($0D1A) OK
L_JMP_($0CCE)_($0D1F) OK
//------------------------------
$0CCE  E6 26     INC $26 
$0CD0  A9 0D     LDA #$0D
$0CD2  85 AB     STA $AB 
$0CD4  A9 40     LDA #$40
$0CD6  85 AA     STA $AA 
$0CD8  20 2E 32  JSR L_JSR_($322E)_($0CD8) OK
$0CDB  4C 66 0D  JMP L_JMP_($0D66)_($0CDB) OK
//------------------------------
L_BRS_($0CDE)_($0CA9) OK
//------------------------------
$0CDE  C9 04     CMP #$04
$0CE0  D0 0E     BNE L_BRS_($0CF0)_($0CE0) OK
$0CE2  A5 26     LDA $26 
$0CE4  0A        ASL A 
$0CE5  90 C9     BCC L_BRS_($0CB0)_($0CE5) OK
$0CE7  A5 FC     LDA $FC 
$0CE9  85 AC     STA $AC 
$0CEB  E6 AC     INC $AC 
$0CED  4C CA 0C  JMP L_JMP_($0CCA)_($0CED) OK
//------------------------------
L_BRS_($0CF0)_($0CE0) OK
//------------------------------
$0CF0  C9 01     CMP #$01
$0CF2  D0 2E     BNE L_BRS_($0D22)_($0CF2) OK
$0CF4  A5 FC     LDA $FC 
$0CF6  C9 30     CMP #$30
$0CF8  B0 09     BCS L_BRS_($0D03)_($0CF8) OK
$0CFA  A5 26     LDA $26 
$0CFC  29 7F     AND #$7F
$0CFE  85 26     STA $26 
$0D00  4C 09 0D  JMP L_JMP_($0D09)_($0D00) OK
//------------------------------
L_BRS_($0D03)_($0CF8) OK
//------------------------------
$0D03  A5 26     LDA $26 
$0D05  09 80     ORA #$80
$0D07  85 26     STA $26 
//------------------------------
L_JMP_($0D09)_($0D00) OK
//------------------------------
$0D09  C6 FB     DEC $FB 
$0D0B  A5 FB     LDA $FB 
$0D0D  85 AD     STA $AD 
//------------------------------
L_JMP_($0D0F)_($0D3D) OK
//------------------------------
$0D0F  A5 FC     LDA $FC 
$0D11  85 AC     STA $AC 
$0D13  A5 26     LDA $26 
$0D15  0A        ASL A 
$0D16  90 05     BCC L_BRS_($0D1D)_($0D16) OK
$0D18  E6 AC     INC $AC 
$0D1A  4C CE 0C  JMP L_JMP_($0CCE)_($0D1A) OK
//------------------------------
L_BRS_($0D1D)_($0D16) OK
//------------------------------
$0D1D  C6 AC     DEC $AC 
$0D1F  4C CE 0C  JMP L_JMP_($0CCE)_($0D1F) OK
//------------------------------
L_BRS_($0D22)_($0CF2) OK
//------------------------------
$0D22  A5 FC     LDA $FC 
$0D24  C9 30     CMP #$30
$0D26  B0 09     BCS L_BRS_($0D31)_($0D26) OK
$0D28  A5 26     LDA $26 
$0D2A  09 80     ORA #$80
$0D2C  85 26     STA $26 
$0D2E  4C 37 0D  JMP L_JMP_($0D37)_($0D2E) OK
//------------------------------
L_BRS_($0D31)_($0D26) OK
//------------------------------
$0D31  A5 26     LDA $26 
$0D33  29 7F     AND #$7F
$0D35  85 26     STA $26 
//------------------------------
L_JMP_($0D37)_($0D2E) OK
//------------------------------
$0D37  E6 FB     INC $FB 
$0D39  A5 FB     LDA $FB 
$0D3B  85 AD     STA $AD 
$0D3D  4C 0F 0D  JMP L_JMP_($0D0F)_($0D3D) OK
$0D40  A9 0C     LDA #$0C
$0D42  85 AB     STA $AB 
$0D44  A9 3F     LDA #$3F
$0D46  85 AA     STA $AA 
$0D48  20 2E 32  JSR L_JSR_($322E)_($0D48) OK
$0D4B  A5 AC     LDA $AC 
$0D4D  85 FC     STA $FC 
$0D4F  A5 AD     LDA $AD 
$0D51  85 FB     STA $FB 
$0D53  A5 26     LDA $26 
$0D55  29 F8     AND #$F8
$0D57  85 57     STA $57 
$0D59  A5 FC     LDA $FC 
$0D5B  29 01     AND #$01
$0D5D  0A        ASL A 
$0D5E  18        CLC 
$0D5F  65 57     ADC $57 
$0D61  85 26     STA $26 
$0D63  4C B6 0C  JMP L_JMP_($0CB6)_($0D63) OK
//------------------------------
L_JMP_($0D66)_($0CA4) OK
L_JMP_($0D66)_($0CBE) OK
L_JMP_($0D66)_($0CDB) OK
//------------------------------
$0D66  60        RTS 
//------------------------------
L_JSR_($0D67)_($0E68) OK
L_JSR_($0D67)_($0EDA) OK
L_JSR_($0D67)_($0F0F) OK
L_JSR_($0D67)_($0F44) OK
L_JSR_($0D67)_($0F79) OK
//------------------------------
$0D67  18        CLC 
$0D68  69 78     ADC #$78
$0D6A  85 4F     STA $4F 
$0D6C  A9 60     LDA #$60
$0D6E  85 4E     STA $4E 
$0D70  A0 01     LDY #$01
$0D72  B1 4E     LDA ($4E),Y 
$0D74  C5 75     CMP $75 
$0D76  90 17     BCC L_BRS_($0D8F)_($0D76) OK
$0D78  E6 76     INC $76 
$0D7A  C5 76     CMP $76 
$0D7C  B0 11     BCS L_BRS_($0D8F)_($0D7C) OK
$0D7E  C8        INY 
$0D7F  B1 4E     LDA ($4E),Y 
$0D81  C5 73     CMP $73 
$0D83  90 0A     BCC L_BRS_($0D8F)_($0D83) OK
$0D85  E6 74     INC $74 
$0D87  C5 74     CMP $74 
$0D89  B0 04     BCS L_BRS_($0D8F)_($0D89) OK
$0D8B  38        SEC 
$0D8C  4C 90 0D  JMP L_JMP_($0D90)_($0D8C) OK
//------------------------------
L_BRS_($0D8F)_($0D76) OK
L_BRS_($0D8F)_($0D7C) OK
L_BRS_($0D8F)_($0D83) OK
L_BRS_($0D8F)_($0D89) OK
//------------------------------
$0D8F  18        CLC 
//------------------------------
L_JMP_($0D90)_($0D8C) OK
//------------------------------
$0D90  60        RTS 
//------------------------------
L_JSR_($0D91)_($0B5F) OK
L_JSR_($0D91)_($0B7A) OK
L_JSR_($0D91)_($0E3E) OK
L_JSR_($0D91)_($14E1) OK
L_JSR_($0D91)_($274E) OK
//------------------------------
$0D91  AD 62 8C  LDA $8C62 
$0D94  C9 07     CMP #$07
$0D96  90 1A     BCC L_BRS_($0DB2)_($0D96) OK
$0D98  C9 0E     CMP #$0E
$0D9A  90 0B     BCC L_BRS_($0DA7)_($0D9A) OK
$0D9C  A9 46     LDA #$46
$0D9E  85 4F     STA $4F 
$0DA0  A9 B6     LDA #$B6
$0DA2  85 4E     STA $4E 
$0DA4  4C BA 0D  JMP L_JMP_($0DBA)_($0DA4) OK
//------------------------------
L_BRS_($0DA7)_($0D9A) OK
//------------------------------
$0DA7  A9 46     LDA #$46
$0DA9  85 4F     STA $4F 
$0DAB  A9 AC     LDA #$AC
$0DAD  85 4E     STA $4E 
$0DAF  4C BA 0D  JMP L_JMP_($0DBA)_($0DAF) OK
//------------------------------
L_BRS_($0DB2)_($0D96) OK
//------------------------------
$0DB2  A9 46     LDA #$46
$0DB4  85 4F     STA $4F 
$0DB6  A9 A0     LDA #$A0
$0DB8  85 4E     STA $4E 
//------------------------------
L_JMP_($0DBA)_($0DA4) OK
L_JMP_($0DBA)_($0DAF) OK
//------------------------------
$0DBA  A0 00     LDY #$00
//------------------------------
L_JMP_($0DBC)_($0DC5) OK
//------------------------------
$0DBC  B1 4E     LDA ($4E),Y 
$0DBE  CD 61 8C  CMP $8C61 
$0DC1  B0 05     BCS L_BRS_($0DC8)_($0DC1) OK
$0DC3  C8        INY 
$0DC4  C8        INY 
$0DC5  4C BC 0D  JMP L_JMP_($0DBC)_($0DC5) OK
//------------------------------
L_BRS_($0DC8)_($0DC1) OK
//------------------------------
$0DC8  C8        INY 
$0DC9  B1 4E     LDA ($4E),Y 
$0DCB  85 C7     STA $C7 
$0DCD  A5 70     LDA $70 
$0DCF  29 07     AND #$07
$0DD1  C5 C7     CMP $C7 
$0DD3  60        RTS 
//------------------------------
L_JSR_($0DD4)_($20C0) OK
L_JSR_($0DD4)_($20D5) OK
//------------------------------
$0DD4  A9 45     LDA #$45
$0DD6  85 4F     STA $4F 
$0DD8  A9 C0     LDA #$C0
$0DDA  85 4E     STA $4E 
$0DDC  A9 CA     LDA #$CA	; TODO: Sprite data pointer ($CAxx)
$0DDE  85 51     STA $51 
$0DE0  A9 C0     LDA #$C0
$0DE2  18        CLC 
$0DE3  65 57     ADC $57 
$0DE5  85 50     STA $50 
$0DE7  A0 00     LDY #$00
$0DE9  A9 08     LDA #$08
$0DEB  85 57     STA $57 
//------------------------------
L_JMP_($0DED)_($0E23) OK
L_JMP_($0DED)_($0E31) OK
//------------------------------
$0DED  A9 08     LDA #$08
$0DEF  85 56     STA $56 
//------------------------------
L_BRS_($0DF1)_($0E08) OK
//------------------------------
$0DF1  B1 4E     LDA ($4E),Y 
$0DF3  91 50     STA ($50),Y 
$0DF5  E6 4E     INC $4E 
$0DF7  D0 02     BNE L_BRS_($0DFB)_($0DF7) OK
$0DF9  E6 4F     INC $4F 
//------------------------------
L_BRS_($0DFB)_($0DF7) OK
//------------------------------
$0DFB  A5 50     LDA $50 
$0DFD  18        CLC 
$0DFE  69 03     ADC #$03
$0E00  90 02     BCC L_BRS_($0E04)_($0E00) OK
$0E02  E6 51     INC $51 
//------------------------------
L_BRS_($0E04)_($0E00) OK
//------------------------------
$0E04  85 50     STA $50 
$0E06  C6 56     DEC $56 
$0E08  D0 E7     BNE L_BRS_($0DF1)_($0E08) OK
$0E0A  A5 50     LDA $50 
$0E0C  38        SEC 
$0E0D  E9 17     SBC #$17
$0E0F  B0 02     BCS L_BRS_($0E13)_($0E0F) OK
$0E11  C6 51     DEC $51 
//------------------------------
L_BRS_($0E13)_($0E0F) OK
//------------------------------
$0E13  85 50     STA $50 
$0E15  C6 57     DEC $57 
$0E17  F0 1B     BEQ L_BRS_($0E34)_($0E17) OK
$0E19  A5 57     LDA $57 
$0E1B  C9 05     CMP #$05
$0E1D  F0 07     BEQ L_BRS_($0E26)_($0E1D) OK
$0E1F  C9 02     CMP #$02
$0E21  F0 03     BEQ L_BRS_($0E26)_($0E21) OK
$0E23  4C ED 0D  JMP L_JMP_($0DED)_($0E23) OK
//------------------------------
L_BRS_($0E26)_($0E1D) OK
L_BRS_($0E26)_($0E21) OK
//------------------------------
$0E26  A5 50     LDA $50 
$0E28  18        CLC 
$0E29  69 3D     ADC #$3D
$0E2B  90 02     BCC L_BRS_($0E2F)_($0E2B) OK
$0E2D  E6 51     INC $51 
//------------------------------
L_BRS_($0E2F)_($0E2B) OK
//------------------------------
$0E2F  85 50     STA $50 
$0E31  4C ED 0D  JMP L_JMP_($0DED)_($0E31) OK
//------------------------------
L_BRS_($0E34)_($0E17) OK
//------------------------------
$0E34  60        RTS 
//------------------------------
$0E35  A9 01     LDA #$01
$0E37  20 B6 31  JSR L_JSR_($31B6)_($0E37) OK
$0E3A  A9 3E     LDA #$3E
$0E3C  85 AC     STA $AC 
//------------------------------
L_JMP_($0E3E)_($0E55) OK
//------------------------------
$0E3E  20 91 0D  JSR L_JSR_($0D91)_($0E3E) OK
$0E41  F0 03     BEQ L_BRS_($0E46)_($0E41) OK
$0E43  4C 84 0B  JMP L_JMP_($0B84)_($0E43) OK
//------------------------------
L_BRS_($0E46)_($0E41) OK
//------------------------------
$0E46  A5 AC     LDA $AC 
$0E48  49 0F     EOR #$0F
$0E4A  85 AC     STA $AC 
$0E4C  A9 00     LDA #$00
$0E4E  85 AD     STA $AD 
$0E50  20 77 1F  JSR L_JSR_($1F77)_($0E50) OK	; Jump to embedded address 136F
$0E53            .byte $6F,$13
$0E55  4C 3E 0E  JMP L_JMP_($0E3E)_($0E55) OK
$0E58  60        RTS 
//------------------------------
L_JSR_($0E59)_($1548) OK
L_JSR_($0E59)_($1974) OK
L_JSR_($0E59)_($271D) OK
L_JSR_($0E59)_($2CBB) OK
//------------------------------
$0E59  A9 FF     LDA #$FF
//------------------------------
L_JSR_($0E5B)_($1542) OK
//------------------------------
$0E5B  85 78     STA $78 
$0E5D  20 AC 0B  JSR L_JSR_($0BAC)_($0E5D) OK
$0E60  A9 0B     LDA #$0B
$0E62  85 07     STA $07 
//------------------------------
L_JMP_($0E64)_($0EAD) OK
//------------------------------
$0E64  C5 78     CMP $78 
$0E66  F0 3B     BEQ L_BRS_($0EA3)_($0E66) OK
$0E68  20 67 0D  JSR L_JSR_($0D67)_($0E68) OK
$0E6B  90 36     BCC L_BRS_($0EA3)_($0E6B) OK
$0E6D  A9 78     LDA #$78
$0E6F  18        CLC 
$0E70  65 07     ADC $07 
$0E72  85 4F     STA $4F 
$0E74  A9 60     LDA #$60
$0E76  85 4E     STA $4E 
$0E78  A0 00     LDY #$00
$0E7A  B1 4E     LDA ($4E),Y 
$0E7C  85 0A     STA $0A 
$0E7E  C8        INY 
$0E7F  B1 4E     LDA ($4E),Y 
$0E81  85 0B     STA $0B 
$0E83  A0 10     LDY #$10
$0E85  B1 4E     LDA ($4E),Y 
$0E87  D0 1A     BNE L_BRS_($0EA3)_($0E87) OK
$0E89  A5 FC     LDA $FC 
$0E8B  E6 0B     INC $0B 
$0E8D  C5 0B     CMP $0B 
$0E8F  B0 09     BCS L_BRS_($0E9A)_($0E8F) OK
$0E91  A5 0A     LDA $0A 
$0E93  0A        ASL A 
$0E94  B0 0D     BCS L_BRS_($0EA3)_($0E94) OK
$0E96  38        SEC 
$0E97  4C B1 0E  JMP L_JMP_($0EB1)_($0E97) OK
//------------------------------
L_BRS_($0E9A)_($0E8F) OK
//------------------------------
$0E9A  A5 0A     LDA $0A 
$0E9C  0A        ASL A 
$0E9D  90 04     BCC L_BRS_($0EA3)_($0E9D) OK
$0E9F  38        SEC 
$0EA0  4C B1 0E  JMP L_JMP_($0EB1)_($0EA0) OK
//------------------------------
L_BRS_($0EA3)_($0E66) OK
L_BRS_($0EA3)_($0E6B) OK
L_BRS_($0EA3)_($0E87) OK
L_BRS_($0EA3)_($0E94) OK
L_BRS_($0EA3)_($0E9D) OK
//------------------------------
$0EA3  A5 07     LDA $07 
$0EA5  C9 0E     CMP #$0E
$0EA7  F0 07     BEQ L_BRS_($0EB0)_($0EA7) OK
$0EA9  E6 07     INC $07 
$0EAB  A5 07     LDA $07 
$0EAD  4C 64 0E  JMP L_JMP_($0E64)_($0EAD) OK
//------------------------------
L_BRS_($0EB0)_($0EA7) OK
//------------------------------
$0EB0  18        CLC 
//------------------------------
L_JMP_($0EB1)_($0E97) OK
L_JMP_($0EB1)_($0EA0) OK
//------------------------------
$0EB1  A5 07     LDA $07 
$0EB3  60        RTS 
//------------------------------
L_JMP_($0EB4)_($0ECB) OK
L_JMP_($0EB4)_($2753) OK
//------------------------------
$0EB4  A5 3F     LDA $3F 
$0EB6  09 80     ORA #$80
$0EB8  85 3F     STA $3F 
$0EBA  A9 00     LDA #$00
$0EBC  85 AB     STA $AB 
$0EBE  4C 2D 1D  JMP L_JMP_($1D2D)_($0EBE) OK
$0EC1  60        RTS 
//------------------------------
$0EC2  A5 40     LDA $40 
$0EC4  C9 0B     CMP #$0B
$0EC6  B0 03     BCS L_BRS_($0ECB)_($0EC6) OK
$0EC8  4C 2D 1D  JMP L_JMP_($1D2D)_($0EC8) OK
//------------------------------
L_BRS_($0ECB)_($0EC6) OK
//------------------------------
$0ECB  4C B4 0E  JMP L_JMP_($0EB4)_($0ECB) OK
$0ECE  60        RTS 
//------------------------------
L_JMP_($0ECF)_($2A95) OK
//------------------------------
$0ECF  20 AC 0B  JSR L_JSR_($0BAC)_($0ECF) OK
$0ED2  A9 FF     LDA #$FF
$0ED4  85 79     STA $79 
$0ED6  A9 14     LDA #$14
$0ED8  85 07     STA $07 
$0EDA  20 67 0D  JSR L_JSR_($0D67)_($0EDA) OK
$0EDD  90 2C     BCC L_BRS_($0F0B)_($0EDD) OK
$0EDF  A9 78     LDA #$78
$0EE1  18        CLC 
$0EE2  65 07     ADC $07 
$0EE4  85 4F     STA $4F 
$0EE6  A9 60     LDA #$60
$0EE8  85 4E     STA $4E 
$0EEA  A0 01     LDY #$01
$0EEC  B1 4E     LDA ($4E),Y 
$0EEE  85 0B     STA $0B 
$0EF0  C5 FC     CMP $FC 
$0EF2  90 06     BCC L_BRS_($0EFA)_($0EF2) OK
$0EF4  38        SEC 
$0EF5  E5 FC     SBC $FC 
$0EF7  4C FF 0E  JMP L_JMP_($0EFF)_($0EF7) OK
//------------------------------
L_BRS_($0EFA)_($0EF2) OK
//------------------------------
$0EFA  A5 FC     LDA $FC 
$0EFC  38        SEC 
$0EFD  E5 0B     SBC $0B 
//------------------------------
L_JMP_($0EFF)_($0EF7) OK
L_JSR_($0F00)_($7744) BAD
//------------------------------
$0EFF  85 7A     STA $7A 
$0F01  C5 79     CMP $79 
$0F03  B0 06     BCS L_BRS_($0F0B)_($0F03) OK
$0F05  85 79     STA $79 
$0F07  A5 07     LDA $07 
$0F09  85 7B     STA $7B 
//------------------------------
L_BRS_($0F0B)_($0EDD) OK
L_BRS_($0F0B)_($0F03) OK
//------------------------------
$0F0B  A9 11     LDA #$11
$0F0D  85 07     STA $07 
$0F0F  20 67 0D  JSR L_JSR_($0D67)_($0F0F) OK
$0F12  90 2C     BCC L_BRS_($0F40)_($0F12) OK
$0F14  A9 78     LDA #$78
$0F16  18        CLC 
$0F17  65 07     ADC $07 
$0F19  85 4F     STA $4F 
$0F1B  A9 60     LDA #$60
$0F1D  85 4E     STA $4E 
$0F1F  A0 01     LDY #$01
$0F21  B1 4E     LDA ($4E),Y 
$0F23  85 0B     STA $0B 
$0F25  C5 FC     CMP $FC 
$0F27  90 06     BCC L_BRS_($0F2F)_($0F27) OK
$0F29  38        SEC 
$0F2A  E5 FC     SBC $FC 
$0F2C  4C 34 0F  JMP L_JMP_($0F34)_($0F2C) OK
//------------------------------
L_BRS_($0F2F)_($0F27) OK
//------------------------------
$0F2F  A5 FC     LDA $FC 
$0F31  38        SEC 
$0F32  E5 0B     SBC $0B 
//------------------------------
L_JMP_($0F34)_($0F2C) OK
//------------------------------
$0F34  85 7A     STA $7A 
$0F36  C5 79     CMP $79 
$0F38  B0 06     BCS L_BRS_($0F40)_($0F38) OK
$0F3A  85 79     STA $79 
$0F3C  A5 07     LDA $07 
$0F3E  85 7B     STA $7B 
//------------------------------
L_BRS_($0F40)_($0F12) OK
L_BRS_($0F40)_($0F38) OK
//------------------------------
$0F40  A9 10     LDA #$10
$0F42  85 07     STA $07 
$0F44  20 67 0D  JSR L_JSR_($0D67)_($0F44) OK
$0F47  90 2C     BCC L_BRS_($0F75)_($0F47) OK
$0F49  A9 78     LDA #$78
$0F4B  18        CLC 
$0F4C  65 07     ADC $07 
$0F4E  85 4F     STA $4F 
$0F50  A9 60     LDA #$60
$0F52  85 4E     STA $4E 
$0F54  A0 01     LDY #$01
$0F56  B1 4E     LDA ($4E),Y 
$0F58  85 0B     STA $0B 
$0F5A  C5 FC     CMP $FC 
$0F5C  90 06     BCC L_BRS_($0F64)_($0F5C) OK
$0F5E  38        SEC 
$0F5F  E5 FC     SBC $FC 
$0F61  4C 69 0F  JMP L_JMP_($0F69)_($0F61) OK
//------------------------------
L_BRS_($0F64)_($0F5C) OK
//------------------------------
$0F64  A5 FC     LDA $FC 
$0F66  38        SEC 
$0F67  E5 0B     SBC $0B 
//------------------------------
L_JMP_($0F69)_($0F61) OK
//------------------------------
$0F69  85 7A     STA $7A 
$0F6B  C5 79     CMP $79 
$0F6D  B0 06     BCS L_BRS_($0F75)_($0F6D) OK
$0F6F  85 79     STA $79 
$0F71  A5 07     LDA $07 
$0F73  85 7B     STA $7B 
//------------------------------
L_BRS_($0F75)_($0F47) OK
L_BRS_($0F75)_($0F6D) OK
//------------------------------
$0F75  A9 0F     LDA #$0F
$0F77  85 07     STA $07 
$0F79  20 67 0D  JSR L_JSR_($0D67)_($0F79) OK
$0F7C  90 2C     BCC L_BRS_($0FAA)_($0F7C) OK
$0F7E  A9 78     LDA #$78
$0F80  18        CLC 
$0F81  65 07     ADC $07 
$0F83  85 4F     STA $4F 
$0F85  A9 60     LDA #$60
$0F87  85 4E     STA $4E 
$0F89  A0 01     LDY #$01
$0F8B  B1 4E     LDA ($4E),Y 
$0F8D  85 0B     STA $0B 
$0F8F  C5 FC     CMP $FC 
$0F91  90 06     BCC L_BRS_($0F99)_($0F91) OK
$0F93  38        SEC 
$0F94  E5 FC     SBC $FC 
$0F96  4C 9E 0F  JMP L_JMP_($0F9E)_($0F96) OK
//------------------------------
L_BRS_($0F99)_($0F91) OK
//------------------------------
$0F99  A5 FC     LDA $FC 
$0F9B  38        SEC 
$0F9C  E5 0B     SBC $0B 
//------------------------------
L_JMP_($0F9E)_($0F96) OK
//------------------------------
$0F9E  85 7A     STA $7A 
$0FA0  C5 79     CMP $79 
$0FA2  B0 06     BCS L_BRS_($0FAA)_($0FA2) OK
$0FA4  85 79     STA $79 
$0FA6  A5 07     LDA $07 
$0FA8  85 7B     STA $7B 
//------------------------------
L_BRS_($0FAA)_($0F7C) OK
L_BRS_($0FAA)_($0FA2) OK
//------------------------------
$0FAA  E6 79     INC $79 
$0FAC  F0 0B     BEQ L_BRS_($0FB9)_($0FAC) OK
$0FAE  A5 7B     LDA $7B 
$0FB0  85 72     STA $72 
$0FB2  A9 08     LDA #$08
$0FB4  85 D8     STA $D8 
$0FB6  4C B7 1D  JMP L_JMP_($1DB7)_($0FB6) OK
//------------------------------
L_BRS_($0FB9)_($0FAC) OK
//------------------------------
$0FB9  60        RTS 
//------------------------------
$0FBA  20 2E 32  JSR L_JSR_($322E)_($0FBA) OK
$0FBD  C6 B2     DEC $B2 
$0FBF  D0 0B     BNE L_BRS_($0FCC)_($0FBF) OK
//------------------------------
L_BRS_($0FC1)_($0FDC) OK
L_JMP_($0FC1)_($0FF8) OK
L_JMP_($0FC1)_($1001) OK
L_JMP_($0FC1)_($1049) OK
//------------------------------
$0FC1  A9 96     LDA #$96
$0FC3  85 FC     STA $FC 
$0FC5  A9 00     LDA #$00
$0FC7  85 B1     STA $B1 
$0FC9  4C 41 10  JMP L_JMP_($1041)_($0FC9) OK
//------------------------------
L_BRS_($0FCC)_($0FBF) OK
//------------------------------
$0FCC  A5 26     LDA $26 
$0FCE  0A        ASL A 
$0FCF  B0 05     BCS L_BRS_($0FD6)_($0FCF) OK
$0FD1  C6 FC     DEC $FC 
$0FD3  4C D8 0F  JMP L_JMP_($0FD8)_($0FD3) OK
//------------------------------
L_BRS_($0FD6)_($0FCF) OK
//------------------------------
$0FD6  E6 FC     INC $FC 
//------------------------------
L_JMP_($0FD8)_($0FD3) OK
//------------------------------
$0FD8  A5 FC     LDA $FC 
$0FDA  C9 60     CMP #$60
$0FDC  B0 E3     BCS L_BRS_($0FC1)_($0FDC) OK
$0FDE  A5 FB     LDA $FB 
$0FE0  C9 03     CMP #$03
$0FE2  F0 17     BEQ L_BRS_($0FFB)_($0FE2) OK
$0FE4  C9 0A     CMP #$0A
$0FE6  F0 0A     BEQ L_BRS_($0FF2)_($0FE6) OK
$0FE8  C9 11     CMP #$11
$0FEA  F0 18     BEQ L_BRS_($1004)_($0FEA) OK
$0FEC  20 2E 32  JSR L_JSR_($322E)_($0FEC) OK
$0FEF  4C 51 10  JMP L_JMP_($1051)_($0FEF) OK
//------------------------------
L_BRS_($0FF2)_($0FE6) OK
//------------------------------
$0FF2  A5 FC     LDA $FC 
$0FF4  C9 26     CMP #$26
$0FF6  D0 0C     BNE L_BRS_($1004)_($0FF6) OK
$0FF8  4C C1 0F  JMP L_JMP_($0FC1)_($0FF8) OK
//------------------------------
L_BRS_($0FFB)_($0FE2) OK
//------------------------------
$0FFB  A5 FC     LDA $FC 
$0FFD  C9 39     CMP #$39
$0FFF  D0 03     BNE L_BRS_($1004)_($0FFF) OK
$1001  4C C1 0F  JMP L_JMP_($0FC1)_($1001) OK
//------------------------------
L_BRS_($1004)_($0FEA) OK
L_BRS_($1004)_($0FF6) OK
L_BRS_($1004)_($0FFF) OK
//------------------------------
$1004  20 2E 32  JSR L_JSR_($322E)_($1004) OK
$1007  A5 B2     LDA $B2 
$1009  C9 08     CMP #$08
$100B  B0 34     BCS L_BRS_($1041)_($100B) OK
$100D  A4 FB     LDY $FB 
$100F  A6 FC     LDX $FC 
$1011  20 C8 29  JSR L_JSR_($29C8)_($1011) OK
$1014  48        PHA 
$1015  B0 1C     BCS L_BRS_($1033)_($1015) OK
$1017  68        PLA 
$1018  C9 00     CMP #$00
$101A  F0 25     BEQ L_BRS_($1041)_($101A) OK
$101C  A9 10     LDA #$10
$101E  85 B1     STA $B1 
$1020  A9 42     LDA #$42
$1022  85 B0     STA $B0 
$1024  A9 05     LDA #$05
$1026  85 B2     STA $B2 
$1028  A4 FB     LDY $FB 
//------------------------------
L_JSR_($102A)_($4A72) OK
//------------------------------
$102A  C0 03     CPY #$03
$102C  D0 13     BNE L_BRS_($1041)_($102C) OK
$102E  84 B2     STY $B2 
//------------------------------
L_JSR_($1030)_($490F) OK
//------------------------------
$1030  4C 41 10  JMP L_JMP_($1041)_($1030) OK
//------------------------------
L_BRS_($1033)_($1015) OK
//------------------------------
$1033  A9 01     LDA #$01
$1035  85 B2     STA $B2 
$1037  68        PLA 
$1038  C9 11     CMP #$11
$103A  D0 05     BNE L_BRS_($1041)_($103A) OK
$103C  A9 03     LDA #$03
$103E  4C 37 1D  JMP L_JMP_($1D37)_($103E) OK
//------------------------------
L_JMP_($1041)_($0FC9) OK
L_BRS_($1041)_($100B) OK
L_BRS_($1041)_($101A) OK
L_BRS_($1041)_($102C) OK
L_JMP_($1041)_($1030) OK
L_BRS_($1041)_($103A) OK
//------------------------------
$1041  60        RTS 
//------------------------------
$1042  20 2E 32  JSR L_JSR_($322E)_($1042) OK
$1045  C6 B2     DEC $B2 
$1047  D0 03     BNE L_BRS_($104C)_($1047) OK
$1049  4C C1 0F  JMP L_JMP_($0FC1)_($1049) OK
//------------------------------
L_BRS_($104C)_($1047) OK
//------------------------------
$104C  C6 FB     DEC $FB 
$104E  20 2E 32  JSR L_JSR_($322E)_($104E) OK
//------------------------------
L_JMP_($1051)_($0FEF) OK
//------------------------------
$1051  A6 FC     LDX $FC 
$1053  E8        INX 
$1054  A4 FB     LDY $FB 
$1056  C8        INY 
$1057  4C B0 2B  JMP L_JMP_($2BB0)_($1057) OK
$105A  60        RTS 
//------------------------------
L_JMP_($105B)_($27A7) OK
//------------------------------
$105B  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$105E  29 03     AND #$03
$1060  D0 07     BNE L_BRS_($1069)_($1060) OK
$1062  A2 24     LDX #$24
$1064  A0 03     LDY #$03
$1066  4C 83 10  JMP L_JMP_($1083)_($1066) OK
//------------------------------
L_BRS_($1069)_($1060) OK
//------------------------------
$1069  C9 01     CMP #$01
$106B  D0 07     BNE L_BRS_($1074)_($106B) OK
$106D  A2 5D     LDX #$5D
$106F  A0 03     LDY #$03
$1071  4C 83 10  JMP L_JMP_($1083)_($1071) OK
//------------------------------
L_BRS_($1074)_($106B) OK
//------------------------------
$1074  C9 02     CMP #$02
$1076  D0 07     BNE L_BRS_($107F)_($1076) OK
$1078  A2 08     LDX #$08
$107A  A0 11     LDY #$11
$107C  4C 83 10  JMP L_JMP_($1083)_($107C) OK
//------------------------------
L_BRS_($107F)_($1076) OK
//------------------------------
$107F  A2 5D     LDX #$5D
$1081  A0 11     LDY #$11
//------------------------------
L_JMP_($1083)_($1066) OK
L_JMP_($1083)_($1071) OK
L_JMP_($1083)_($107C) OK
L_JMP_($1083)_($28A7) OK
//------------------------------
$1083  86 A6     STX $A6 
$1085  84 A7     STY $A7 
$1087  4C C1 12  JMP L_JMP_($12C1)_($1087) OK
$108A  60        RTS 
//------------------------------
L_JSR_($108B)_($116A) OK
L_JSR_($108B)_($246B) OK
//------------------------------
$108B  A0 00     LDY #$00
$108D  A5 AF     LDA $AF 
$108F  F0 11     BEQ L_BRS_($10A2)_($108F) OK
//------------------------------
L_JMP_($1091)_($1125) OK
//------------------------------
$1091  B1 AE     LDA ($AE),Y 
$1093  E6 AE     INC $AE 
$1095  D0 02     BNE L_BRS_($1099)_($1095) OK
$1097  E6 AF     INC $AF 
//------------------------------
L_BRS_($1099)_($1095) OK
//------------------------------
$1099  C9 00     CMP #$00
$109B  F0 03     BEQ L_BRS_($10A0)_($109B) OK
$109D  4C 28 11  JMP L_JMP_($1128)_($109D) OK
//------------------------------
L_BRS_($10A0)_($109B) OK
//------------------------------
$10A0  84 AF     STY $AF 
//------------------------------
L_BRS_($10A2)_($108F) OK
//------------------------------
$10A2  B1 AC     LDA ($AC),Y 
$10A4  E6 AC     INC $AC 
$10A6  D0 02     BNE L_BRS_($10AA)_($10A6) OK
$10A8  E6 AD     INC $AD 
//------------------------------
L_BRS_($10AA)_($10A6) OK
//------------------------------
$10AA  C9 80     CMP #$80
$10AC  B0 04     BCS L_BRS_($10B2)_($10AC) OK
$10AE  C9 20     CMP #$20
$10B0  B0 76     BCS L_BRS_($1128)_($10B0) OK
//------------------------------
L_BRS_($10B2)_($10AC) OK
//------------------------------
$10B2  C9 10     CMP #$10
$10B4  90 72     BCC L_BRS_($1128)_($10B4) OK
$10B6  48        PHA 
$10B7  C9 80     CMP #$80
$10B9  B0 33     BCS L_BRS_($10EE)_($10B9) OK
$10BB  C9 18     CMP #$18
$10BD  B0 0B     BCS L_BRS_($10CA)_($10BD) OK
$10BF  A9 47     LDA #$47
$10C1  85 1E     STA $1E 
$10C3  A9 80     LDA #$80
$10C5  85 1D     STA $1D 
$10C7  4C D6 10  JMP L_JMP_($10D6)_($10C7) OK
//------------------------------
L_BRS_($10CA)_($10BD) OK
//------------------------------
$10CA  A9 47     LDA #$47
$10CC  85 1E     STA $1E 
$10CE  A9 F0     LDA #$F0
$10D0  85 1D     STA $1D 
$10D2  68        PLA 
$10D3  4C 1D 11  JMP L_JMP_($111D)_($10D3) OK
//------------------------------
L_JMP_($10D6)_($10C7) OK
//------------------------------
$10D6  68        PLA 
$10D7  29 EF     AND #$EF
$10D9  0A        ASL A 
$10DA  85 57     STA $57 
$10DC  0A        ASL A 
$10DD  85 56     STA $56 
$10DF  0A        ASL A 
$10E0  18        CLC 
$10E1  65 56     ADC $56 
$10E3  18        CLC 
$10E4  65 57     ADC $57 
$10E6  18        CLC 
$10E7  65 1D     ADC $1D 
$10E9  85 1D     STA $1D 
$10EB  4C 1D 11  JMP L_JMP_($111D)_($10EB) OK
//------------------------------
L_BRS_($10EE)_($10B9) OK
//------------------------------
$10EE  A9 4D     LDA #$4D
$10F0  85 1E     STA $1E 
$10F2  68        PLA 
$10F3  29 7F     AND #$7F
$10F5  C9 16     CMP #$16
$10F7  90 1A     BCC L_BRS_($1113)_($10F7) OK
$10F9  E6 1E     INC $1E 
$10FB  C9 2B     CMP #$2B
$10FD  90 14     BCC L_BRS_($1113)_($10FD) OK
$10FF  E6 1E     INC $1E 
$1101  C9 40     CMP #$40
$1103  90 0E     BCC L_BRS_($1113)_($1103) OK
$1105  E6 1E     INC $1E 
$1107  C9 56     CMP #$56
$1109  90 08     BCC L_BRS_($1113)_($1109) OK
$110B  E6 1E     INC $1E 
$110D  C9 6B     CMP #$6B
$110F  90 02     BCC L_BRS_($1113)_($110F) OK
$1111  E6 1E     INC $1E 
//------------------------------
L_BRS_($1113)_($10F7) OK
L_BRS_($1113)_($10FD) OK
L_BRS_($1113)_($1103) OK
L_BRS_($1113)_($1109) OK
L_BRS_($1113)_($110F) OK
//------------------------------
$1113  0A        ASL A 
$1114  0A        ASL A 
$1115  85 57     STA $57 
$1117  0A        ASL A 
$1118  18        CLC 
$1119  65 57     ADC $57 
$111B  85 1D     STA $1D 
//------------------------------
L_JMP_($111D)_($10D3) OK
L_JMP_($111D)_($10EB) OK
//------------------------------
$111D  A5 1D     LDA $1D 
$111F  85 AE     STA $AE 
$1121  A5 1E     LDA $1E 
$1123  85 AF     STA $AF 
$1125  4C 91 10  JMP L_JMP_($1091)_($1125) OK
//------------------------------
L_JMP_($1128)_($109D) OK
L_BRS_($1128)_($10B0) OK
L_BRS_($1128)_($10B4) OK
//------------------------------
$1128  60        RTS 
//------------------------------
$1129  20 68 14  JSR L_JSR_($1468)_($1129) OK
$112C  A5 19     LDA $19 
$112E  F0 03     BEQ L_BRS_($1133)_($112E) OK
$1130  4C 28 1D  JMP L_JMP_($1D28)_($1130) OK
//------------------------------
L_BRS_($1133)_($112E) OK
//------------------------------
$1133  A5 60     LDA $60 
$1135  85 1A     STA $1A 
$1137  A9 00     LDA #$00
$1139  85 AE     STA $AE 
$113B  85 AF     STA $AF 
$113D  A5 60     LDA $60 
$113F  38        SEC 
$1140  E9 0B     SBC #$0B
$1142  C9 05     CMP #$05
//------------------------------
L_JSR_($1144)_($8760) OK
L_JSR_($1144)_($C9BD) OK
//------------------------------
$1144  D0 03     BNE L_BRS_($1149)_($1144) OK
$1146  38        SEC 
$1147  E9 01     SBC #$01
//------------------------------
L_BRS_($1149)_($1144) OK
//------------------------------
$1149  18        CLC 
$114A  69 53     ADC #$53
$114C  85 AD     STA $AD 
$114E  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$1151  29 07     AND #$07
$1153  0A        ASL A 
$1154  0A        ASL A 
$1155  0A        ASL A 
$1156  0A        ASL A 
$1157  0A        ASL A 
$1158  85 AC     STA $AC 
$115A  A9 11     LDA #$11
$115C  85 AB     STA $AB 
$115E  A9 67     LDA #$67
$1160  85 AA     STA $AA 
$1162  A4 DA     LDY $DA 
$1164  20 45 14  JSR L_JSR_($1445)_($1164) OK
$1167  20 68 14  JSR L_JSR_($1468)_($1167) OK
$116A  20 8B 10  JSR L_JSR_($108B)_($116A) OK
$116D  C9 00     CMP #$00
$116F  D0 1C     BNE L_BRS_($118D)_($116F) OK
$1171  20 2E 32  JSR L_JSR_($322E)_($1171) OK
$1174  A5 26     LDA $26 
$1176  0A        ASL A 
$1177  0A        ASL A 
$1178  B0 07     BCS L_BRS_($1181)_($1178) OK
$117A  A5 26     LDA $26 
$117C  29 F0     AND #$F0
//------------------------------
L_JSR_($1180)_($758D) BAD
L_JSR_($1180)_($768D) BAD
L_JSR_($1180)_($778D) BAD
//------------------------------
$117E  4C 85 11  JMP L_JMP_($1185)_($117E) OK
//------------------------------
L_BRS_($1181)_($1178) OK
//------------------------------
$1181  A5 26     LDA $26 
$1183  29 F8     AND #$F8
//------------------------------
L_JMP_($1185)_($117E) OK
//------------------------------
$1185  85 26     STA $26 
$1187  20 2E 32  JSR L_JSR_($322E)_($1187) OK
$118A  4C 28 1D  JMP L_JMP_($1D28)_($118A) OK
//------------------------------
L_BRS_($118D)_($116F) OK
//------------------------------
$118D  C9 02     CMP #$02
$118F  D0 07     BNE L_BRS_($1198)_($118F) OK
$1191  A9 40     LDA #$40
$1193  85 19     STA $19 
$1195  4C C9 11  JMP L_JMP_($11C9)_($1195) OK
//------------------------------
L_BRS_($1198)_($118F) OK
//------------------------------
$1198  20 CF 11  JSR L_JSR_($11CF)_($1198) OK
$119B  20 2E 32  JSR L_JSR_($322E)_($119B) OK
$119E  A5 26     LDA $26 
$11A0  0A        ASL A 
$11A1  0A        ASL A 
$11A2  90 10     BCC L_BRS_($11B4)_($11A2) OK
$11A4  A5 26     LDA $26 
$11A6  29 F8     AND #$F8
$11A8  C5 26     CMP $26 
$11AA  D0 03     BNE L_BRS_($11AF)_($11AA) OK
$11AC  18        CLC 
$11AD  69 05     ADC #$05
//------------------------------
L_BRS_($11AF)_($11AA) OK
//------------------------------
$11AF  85 26     STA $26 
$11B1  4C C6 11  JMP L_JMP_($11C6)_($11B1) OK
//------------------------------
L_BRS_($11B4)_($11A2) OK
//------------------------------
$11B4  A5 26     LDA $26 
$11B6  29 80     AND #$80
$11B8  18        CLC 
$11B9  69 3C     ADC #$3C
$11BB  C5 26     CMP $26 
$11BD  F0 05     BEQ L_BRS_($11C4)_($11BD) OK
$11BF  85 26     STA $26 
$11C1  4C C6 11  JMP L_JMP_($11C6)_($11C1) OK
//------------------------------
L_BRS_($11C4)_($11BD) OK
//------------------------------
$11C4  E6 26     INC $26 
//------------------------------
L_JMP_($11C6)_($11B1) OK
L_JMP_($11C6)_($11C1) OK
//------------------------------
$11C6  20 2E 32  JSR L_JSR_($322E)_($11C6) OK
//------------------------------
L_JMP_($11C9)_($1195) OK
//------------------------------
$11C9  A4 DA     LDY $DA 
$11CB  20 45 14  JSR L_JSR_($1445)_($11CB) OK
$11CE  60        RTS 
//------------------------------
L_JSR_($11CF)_($1198) OK
L_JSR_($11CF)_($1896) OK
//------------------------------
$11CF  85 21     STA $21 
$11D1  A9 47     LDA #$47
$11D3  85 22     STA $22 
$11D5  A5 19     LDA $19 
$11D7  09 C0     ORA #$C0
$11D9  18        CLC 
$11DA  69 01     ADC #$01
$11DC  B0 07     BCS L_BRS_($11E5)_($11DC) OK
$11DE  A0 00     LDY #$00
$11E0  18        CLC 
$11E1  71 21     ADC ($21),Y 
$11E3  90 08     BCC L_BRS_($11ED)_($11E3) OK
//------------------------------
L_BRS_($11E5)_($11DC) OK
//------------------------------
$11E5  A5 19     LDA $19 
$11E7  29 40     AND #$40
$11E9  49 40     EOR #$40
$11EB  85 19     STA $19 
//------------------------------
L_BRS_($11ED)_($11E3) OK
//------------------------------
$11ED  A5 19     LDA $19 
$11EF  29 3F     AND #$3F
$11F1  4A        LSR A 
$11F2  4A        LSR A 
$11F3  4A        LSR A 
$11F4  18        CLC 
$11F5  65 15     ADC $15 
$11F7  85 15     STA $15 
$11F9  A5 19     LDA $19 
$11FB  C9 40     CMP #$40
$11FD  90 02     BCC L_BRS_($1201)_($11FD) OK
$11FF  E6 16     INC $16 
//------------------------------
L_BRS_($1201)_($11FD) OK
//------------------------------
$1201  A5 15     LDA $15 
$1203  38        SEC 
$1204  E5 58     SBC $58 
$1206  85 49     STA $49 
$1208  A5 16     LDA $16 
$120A  85 4A     STA $4A 
$120C  20 E3 36  JSR L_JSR_($36E3)_($120C) OK
$120F  E6 49     INC $49 
$1211  20 E3 36  JSR L_JSR_($36E3)_($1211) OK
$1214  A5 19     LDA $19 
$1216  29 07     AND #$07
$1218  AA        TAX 
$1219  E8        INX 
$121A  A9 FF     LDA #$FF
$121C  18        CLC 
//------------------------------
L_BRS_($121D)_($121F) OK
//------------------------------
$121D  6A        ROR A 
$121E  CA        DEX 
$121F  D0 FC     BNE L_BRS_($121D)_($121F) OK
$1221  85 23     STA $23 
$1223  20 94 12  JSR L_JSR_($1294)_($1223) OK
$1226  A0 00     LDY #$00
$1228  B1 21     LDA ($21),Y 
$122A  85 4E     STA $4E 
//------------------------------
L_BRS_($122C)_($1263) OK
L_JMP_($122C)_($1267) OK
//------------------------------
$122C  E6 22     INC $22 
$122E  A9 08     LDA #$08
$1230  85 4F     STA $4F 
$1232  B1 21     LDA ($21),Y 
//------------------------------
L_BRS_($1234)_($1243) OK
//------------------------------
$1234  2A        ROL A 
$1235  48        PHA 
$1236  90 06     BCC L_BRS_($123E)_($1236) OK
$1238  A5 23     LDA $23 
$123A  31 1B     AND ($1B),Y 
$123C  91 1B     STA ($1B),Y 
//------------------------------
L_BRS_($123E)_($1236) OK
//------------------------------
$123E  E6 1C     INC $1C 
$1240  68        PLA 
$1241  C6 4F     DEC $4F 
$1243  D0 EF     BNE L_BRS_($1234)_($1243) OK
$1245  E6 19     INC $19 
$1247  A5 19     LDA $19 
$1249  29 07     AND #$07
$124B  F0 0A     BEQ L_BRS_($1257)_($124B) OK
//------------------------------
L_JSR_($124D)_($C471) OK
L_JSR_($124D)_($FE6B) OK
//------------------------------
$124D  A5 1C     LDA $1C 
$124F  38        SEC 
$1250  E9 08     SBC #$08
$1252  85 1C     STA $1C 
//------------------------------
L_JSR_($1254)_($C40D) OK
L_JSR_($1254)_($FE07) OK
//------------------------------
$1254  4C 5C 12  JMP L_JMP_($125C)_($1254) OK
//------------------------------
L_BRS_($1257)_($124B) OK
//------------------------------
$1257  E6 15     INC $15 
$1259  20 94 12  JSR L_JSR_($1294)_($1259) OK
//------------------------------
L_JMP_($125C)_($1254) OK
//------------------------------
$125C  C6 4E     DEC $4E 
$125E  F0 0A     BEQ L_BRS_($126A)_($125E) OK
$1260  38        SEC 
$1261  66 23     ROR $23 
$1263  B0 C7     BCS L_BRS_($122C)_($1263) OK
$1265  66 23     ROR $23 
$1267  4C 2C 12  JMP L_JMP_($122C)_($1267) OK
//------------------------------
L_BRS_($126A)_($125E) OK
//------------------------------
$126A  E6 19     INC $19 
$126C  60        RTS 
//------------------------------
L_JSR_($126D)_($12C7) OK
L_JSR_($126D)_($12F4) OK
L_JSR_($126D)_($1A5D) OK
L_JSR_($126D)_($1AE1) OK
L_JSR_($126D)_($1BA1) OK
L_JSR_($126D)_($1BAA) OK
//------------------------------
$126D  C0 0E     CPY #$0E
$126F  90 05     BCC L_BRS_($1276)_($126F) OK
$1271  A9 02     LDA #$02
$1273  4C 93 12  JMP L_JMP_($1293)_($1273) OK
//------------------------------
L_BRS_($1276)_($126F) OK
//------------------------------
$1276  C0 07     CPY #$07
$1278  90 0E     BCC L_BRS_($1288)_($1278) OK
$127A  E0 27     CPX #$27
$127C  90 05     BCC L_BRS_($1283)_($127C) OK
$127E  A9 03     LDA #$03
$1280  4C 93 12  JMP L_JMP_($1293)_($1280) OK
//------------------------------
L_BRS_($1283)_($127C) OK
//------------------------------
$1283  A9 01     LDA #$01
$1285  4C 93 12  JMP L_JMP_($1293)_($1285) OK
//------------------------------
L_BRS_($1288)_($1278) OK
//------------------------------
$1288  E0 3A     CPX #$3A
$128A  90 05     BCC L_BRS_($1291)_($128A) OK
$128C  A9 04     LDA #$04
$128E  4C 93 12  JMP L_JMP_($1293)_($128E) OK
//------------------------------
L_BRS_($1291)_($128A) OK
//------------------------------
$1291  A9 00     LDA #$00
//------------------------------
L_JMP_($1293)_($1273) OK
L_JMP_($1293)_($1280) OK
L_JMP_($1293)_($1285) OK
L_JMP_($1293)_($128E) OK
//------------------------------
$1293  60        RTS 
//------------------------------
L_JSR_($1294)_($1223) OK
L_JSR_($1294)_($1259) OK
L_JSR_($1294)_($1994) OK
//------------------------------
$1294  A9 78     LDA #$78
$1296  18        CLC 
$1297  65 16     ADC $16 
$1299  85 57     STA $57 
$129B  A5 15     LDA $15 
$129D  85 56     STA $56 
$129F  A0 00     LDY #$00
$12A1  B1 56     LDA ($56),Y 
$12A3  85 1B     STA $1B 
$12A5  A6 15     LDX $15 
$12A7  E0 20     CPX #$20
$12A9  B0 05     BCS L_BRS_($12B0)_($12A9) OK
$12AB  A9 60     LDA #$60
$12AD  4C B2 12  JMP L_JMP_($12B2)_($12AD) OK
//------------------------------
L_BRS_($12B0)_($12A9) OK
//------------------------------
$12B0  A9 68     LDA #$68
//------------------------------
L_JMP_($12B2)_($12AD) OK
//------------------------------
$12B2  85 1C     STA $1C 
$12B4  60        RTS 
//------------------------------
$12B5  20 E7 3B  JSR L_JSR_($3BE7)_($12B5) OK
$12B8  85 A6     STA $A6 
$12BA  AA        TAX 
$12BB  20 E7 3B  JSR L_JSR_($3BE7)_($12BB) OK
$12BE  85 A7     STA $A7 
$12C0  A8        TAY 
//------------------------------
L_JMP_($12C1)_($1087) OK
//------------------------------
$12C1  A5 3F     LDA $3F 
$12C3  29 FC     AND #$FC
$12C5  85 3F     STA $3F 
//------------------------------
L_JMP_($12C7)_($2861) OK
//------------------------------
$12C7  20 6D 12  JSR L_JSR_($126D)_($12C7) OK
$12CA  85 A8     STA $A8 
$12CC  A9 12     LDA #$12
$12CE  85 2A     STA $2A 
$12D0  A9 E8     LDA #$E8
$12D2  85 29     STA $29 
$12D4  A5 26     LDA $26 
$12D6  29 07     AND #$07
$12D8  C9 05     CMP #$05
$12DA  D0 0C     BNE L_BRS_($12E8)_($12DA) OK
$12DC  20 2E 32  JSR L_JSR_($322E)_($12DC) OK
$12DF  A5 26     LDA $26 
$12E1  29 F8     AND #$F8
$12E3  85 26     STA $26 
$12E5  4C 2E 32  JMP L_JMP_($322E)_($12E5) OK
//------------------------------
L_BRS_($12E8)_($12DA) OK
//------------------------------
$12E8  A5 26     LDA $26 
$12EA  4A        LSR A 
$12EB  90 03     BCC L_BRS_($12F0)_($12EB) OK
$12ED  4C 90 13  JMP L_JMP_($1390)_($12ED) OK
//------------------------------
L_BRS_($12F0)_($12EB) OK
//------------------------------
$12F0  A6 FC     LDX $FC 
$12F2  A4 FB     LDY $FB 
$12F4  20 6D 12  JSR L_JSR_($126D)_($12F4) OK
$12F7  85 48     STA $48 
$12F9  C5 A8     CMP $A8 
$12FB  D0 16     BNE L_BRS_($1313)_($12FB) OK
$12FD  A5 A6     LDA $A6 
$12FF  C5 FC     CMP $FC 
$1301  D0 03     BNE L_BRS_($1306)_($1301) OK
$1303  4C 2D 1D  JMP L_JMP_($1D2D)_($1303) OK
//------------------------------
L_BRS_($1306)_($1301) OK
//------------------------------
$1306  85 AC     STA $AC 
$1308  A9 13     LDA #$13
$130A  85 AB     STA $AB 
$130C  A9 6F     LDA #$6F
$130E  85 AA     STA $AA 
$1310  6C AA 00  JMP ($00AA) 
//------------------------------
L_BRS_($1313)_($12FB) OK
//------------------------------
$1313  90 0B     BCC L_BRS_($1320)_($1313) OK
$1315  A9 54     LDA #$54
$1317  85 4E     STA $4E 
$1319  A9 44     LDA #$44
$131B  85 4F     STA $4F 
$131D  4C 28 13  JMP L_JMP_($1328)_($131D) OK
//------------------------------
L_BRS_($1320)_($1313) OK
//------------------------------
$1320  A9 40     LDA #$40
$1322  85 4E     STA $4E 
$1324  A9 44     LDA #$44
$1326  85 4F     STA $4F 
//------------------------------
L_JMP_($1328)_($131D) OK
//------------------------------
$1328  A9 00     LDA #$00
$132A  A6 48     LDX $48 
$132C  F0 06     BEQ L_BRS_($1334)_($132C) OK
//------------------------------
L_BRS_($132E)_($1332) OK
//------------------------------
$132E  18        CLC 
$132F  69 04     ADC #$04
$1331  CA        DEX 
$1332  D0 FA     BNE L_BRS_($132E)_($1332) OK
//------------------------------
L_BRS_($1334)_($132C) OK
//------------------------------
$1334  A8        TAY 
$1335  B1 4E     LDA ($4E),Y 
$1337  C5 FC     CMP $FC 
$1339  F0 0D     BEQ L_BRS_($1348)_($1339) OK
$133B  85 AC     STA $AC 
$133D  A9 13     LDA #$13
$133F  85 AB     STA $AB 
$1341  A9 6F     LDA #$6F
$1343  85 AA     STA $AA 
$1345  6C AA 00  JMP ($00AA) 
//------------------------------
L_BRS_($1348)_($1339) OK
//------------------------------
$1348  C8        INY 
$1349  B1 4E     LDA ($4E),Y 
$134B  48        PHA 
$134C  A5 26     LDA $26 
$134E  29 80     AND #$80
$1350  85 57     STA $57 
$1352  68        PLA 
$1353  C5 57     CMP $57 
$1355  F0 06     BEQ L_BRS_($135D)_($1355) OK
$1357  20 2E 32  JSR L_JSR_($322E)_($1357) OK
$135A  4C C6 13  JMP L_JMP_($13C6)_($135A) OK
//------------------------------
L_BRS_($135D)_($1355) OK
//------------------------------
$135D  A9 0F     LDA #$0F
$135F  85 AC     STA $AC 
$1361  C8        INY 
$1362  B1 4E     LDA ($4E),Y 
$1364  85 AA     STA $AA 
$1366  C8        INY 
$1367  B1 4E     LDA ($4E),Y 
$1369  85 AB     STA $AB 
$136B  6C AA 00  JMP ($00AA) 
$136E  60        RTS 
//------------------------------
$136F  A9 11     LDA #$11
$1371  85 AD     STA $AD 
$1373  A9 13     LDA #$13
$1375  85 AB     STA $AB 
$1377  A9 7B     LDA #$7B
$1379  85 AA     STA $AA 
//------------------------------
L_JSR_($137B)_($BEE7) OK
L_JSR_($137B)_($BFAF) OK
L_JSR_($137B)_($FB03) OK
L_JSR_($137B)_($FBCB) OK
//------------------------------
$137B  C6 AD     DEC $AD 
$137D  D0 03     BNE L_BRS_($1382)_($137D) OK
$137F  4C 28 1D  JMP L_JMP_($1D28)_($137F) OK
//------------------------------
L_BRS_($1382)_($137D) OK
//------------------------------
$1382  A5 FC     LDA $FC 
$1384  C5 AC     CMP $AC 
$1386  D0 08     BNE L_BRS_($1390)_($1386) OK
$1388  A5 26     LDA $26 
$138A  4A        LSR A 
$138B  B0 03     BCS L_BRS_($1390)_($138B) OK
$138D  4C 28 1D  JMP L_JMP_($1D28)_($138D) OK
//------------------------------
L_JMP_($1390)_($12ED) OK
L_BRS_($1390)_($1386) OK
L_BRS_($1390)_($138B) OK
//------------------------------
$1390  20 2E 32  JSR L_JSR_($322E)_($1390) OK
$1393  A5 26     LDA $26 
$1395  4A        LSR A 
$1396  90 1D     BCC L_BRS_($13B5)_($1396) OK
//------------------------------
L_JMP_($1398)_($140D) OK
L_JMP_($1398)_($1CF4) OK
//------------------------------
$1398  0A        ASL A 
$1399  0A        ASL A 
$139A  90 05     BCC L_BRS_($13A1)_($139A) OK
$139C  E6 FC     INC $FC 
$139E  4C A3 13  JMP L_JMP_($13A3)_($139E) OK
//------------------------------
L_BRS_($13A1)_($139A) OK
//------------------------------
$13A1  C6 FC     DEC $FC 
//------------------------------
L_JMP_($13A3)_($139E) OK
//------------------------------
$13A3  A5 26     LDA $26 
$13A5  29 F8     AND #$F8
$13A7  85 57     STA $57 
$13A9  A5 FC     LDA $FC 
$13AB  29 01     AND #$01
$13AD  0A        ASL A 
$13AE  65 57     ADC $57 
$13B0  85 26     STA $26 
$13B2  4C D1 13  JMP L_JMP_($13D1)_($13B2) OK
//------------------------------
L_BRS_($13B5)_($1396) OK
//------------------------------
$13B5  A5 26     LDA $26 
$13B7  29 80     AND #$80
$13B9  85 57     STA $57 
$13BB  A5 FC     LDA $FC 
$13BD  38        SEC 
$13BE  E5 AC     SBC $AC 
$13C0  29 80     AND #$80
$13C2  C5 57     CMP $57 
$13C4  F0 09     BEQ L_BRS_($13CF)_($13C4) OK
//------------------------------
L_JMP_($13C6)_($135A) OK
//------------------------------
$13C6  A5 26     LDA $26 
$13C8  49 80     EOR #$80
$13CA  85 26     STA $26 
$13CC  4C D1 13  JMP L_JMP_($13D1)_($13CC) OK
//------------------------------
L_BRS_($13CF)_($13C4) OK
//------------------------------
$13CF  E6 26     INC $26 
//------------------------------
L_JMP_($13D1)_($13B2) OK
L_JMP_($13D1)_($13CC) OK
//------------------------------
$13D1  20 2E 32  JSR L_JSR_($322E)_($13D1) OK
$13D4  60        RTS 
//------------------------------
L_JSR_($13D5)_($1421) OK
L_JSR_($13D5)_($1445) OK
//------------------------------
$13D5  A9 44     LDA #$44
$13D7  85 18     STA $18 
//------------------------------
L_JSR_($13DA)_($FFCA) BAD
//------------------------------
$13D9  A9 20     LDA #$20
$13DB  85 17     STA $17 
$13DD  98        TYA 
$13DE  F0 12     BEQ L_BRS_($13F2)_($13DE) OK
$13E0  A5 17     LDA $17 
$13E2  18        CLC 
$13E3  69 06     ADC #$06
$13E5  85 17     STA $17 
$13E7  C0 02     CPY #$02
$13E9  D0 07     BNE L_BRS_($13F2)_($13E9) OK
$13EB  A5 17     LDA $17 
$13ED  18        CLC 
$13EE  69 06     ADC #$06
$13F0  85 17     STA $17 
//------------------------------
L_BRS_($13F2)_($13DE) OK
L_BRS_($13F2)_($13E9) OK
//------------------------------
$13F2  60        RTS 
//------------------------------
$13F3  A9 00     LDA #$00
$13F5  85 47     STA $47 
$13F7  4C FE 13  JMP L_JMP_($13FE)_($13F7) OK
$13FA  A9 FF     LDA #$FF
$13FC  85 47     STA $47 
//------------------------------
L_JMP_($13FE)_($13F7) OK
//------------------------------
$13FE  C6 AC     DEC $AC 
$1400  D0 03     BNE L_BRS_($1405)_($1400) OK
$1402  4C 28 1D  JMP L_JMP_($1D28)_($1402) OK
//------------------------------
L_BRS_($1405)_($1400) OK
//------------------------------
$1405  20 2E 32  JSR L_JSR_($322E)_($1405) OK
$1408  A5 26     LDA $26 
$140A  4A        LSR A 
$140B  90 03     BCC L_BRS_($1410)_($140B) OK
$140D  4C 98 13  JMP L_JMP_($1398)_($140D) OK
//------------------------------
L_BRS_($1410)_($140B) OK
//------------------------------
$1410  E6 26     INC $26 
$1412  A5 47     LDA $47 
$1414  F0 05     BEQ L_BRS_($141B)_($1414) OK
$1416  C6 FB     DEC $FB 
$1418  4C 1D 14  JMP L_JMP_($141D)_($1418) OK
//------------------------------
L_BRS_($141B)_($1414) OK
//------------------------------
$141B  E6 FB     INC $FB 
//------------------------------
L_JMP_($141D)_($1418) OK
//------------------------------
$141D  20 2E 32  JSR L_JSR_($322E)_($141D) OK
$1420  60        RTS 
//------------------------------
L_JSR_($1421)_($149B) OK
L_JSR_($1421)_($17A8) OK
//------------------------------
$1421  20 D5 13  JSR L_JSR_($13D5)_($1421) OK
$1424  A0 00     LDY #$00
$1426  B1 17     LDA ($17),Y 
$1428  85 19     STA $19 
$142A  C8        INY 
$142B  B1 17     LDA ($17),Y 
$142D  85 1A     STA $1A 
$142F  C8        INY 
$1430  B1 17     LDA ($17),Y 
$1432  85 DF     STA $DF 
$1434  C8        INY 
$1435  B1 17     LDA ($17),Y 
$1437  85 E0     STA $E0 
$1439  C8        INY 
$143A  B1 17     LDA ($17),Y 
$143C  85 E1     STA $E1 
$143E  C8        INY 
$143F  B1 17     LDA ($17),Y 
$1441  85 E2     STA $E2 
$1443  C8        INY 
$1444  60        RTS 
//------------------------------
L_JSR_($1445)_($1164) OK
L_JSR_($1445)_($11CB) OK
L_JSR_($1445)_($170B) OK
L_JSR_($1445)_($19F7) OK
//------------------------------
$1445  20 D5 13  JSR L_JSR_($13D5)_($1445) OK
$1448  A0 00     LDY #$00
$144A  A5 19     LDA $19 
$144C  91 17     STA ($17),Y 
$144E  C8        INY 
$144F  A5 1A     LDA $1A 
$1451  91 17     STA ($17),Y 
$1453  C8        INY 
$1454  A5 DF     LDA $DF 
$1456  91 17     STA ($17),Y 
$1458  C8        INY 
$1459  A5 E0     LDA $E0 
$145B  91 17     STA ($17),Y 
$145D  C8        INY 
$145E  A5 E1     LDA $E1 
$1460  91 17     STA ($17),Y 
$1462  C8        INY 
$1463  A5 E2     LDA $E2 
$1465  91 17     STA ($17),Y 
$1467  60        RTS 
//------------------------------
L_JSR_($1468)_($0A8F) OK
L_JSR_($1468)_($1129) OK
L_JSR_($1468)_($1167) OK
L_JSR_($1468)_($16F1) OK
L_JSR_($1468)_($187F) OK
L_JSR_($1468)_($19DB) OK
L_JSR_($1468)_($1FAC) OK
//------------------------------
$1468  20 8E 1C  JSR L_JSR_($1C8E)_($1468) OK
$146B  C9 02     CMP #$02
$146D  D0 0D     BNE L_BRS_($147C)_($146D) OK
$146F  A9 2A     LDA #$2A
$1471  85 15     STA $15 
$1473  A9 03     LDA #$03
$1475  85 16     STA $16 
$1477  A0 00     LDY #$00
$1479  4C 99 14  JMP L_JMP_($1499)_($1479) OK
//------------------------------
L_BRS_($147C)_($146D) OK
//------------------------------
$147C  A5 FC     LDA $FC 
$147E  C9 25     CMP #$25
$1480  B0 0D     BCS L_BRS_($148F)_($1480) OK
$1482  A9 1A     LDA #$1A
$1484  85 15     STA $15 
$1486  A9 09     LDA #$09
$1488  85 16     STA $16 
$148A  A0 01     LDY #$01
$148C  4C 99 14  JMP L_JMP_($1499)_($148C) OK
//------------------------------
L_BRS_($148F)_($1480) OK
//------------------------------
$148F  A9 29     LDA #$29
$1491  85 15     STA $15 
$1493  A9 09     LDA #$09
$1495  85 16     STA $16 
$1497  A0 02     LDY #$02
//------------------------------
L_JMP_($1499)_($1479) OK
L_JMP_($1499)_($148C) OK
//------------------------------
$1499  84 DA     STY $DA 
$149B  20 21 14  JSR L_JSR_($1421)_($149B) OK
$149E  60        RTS 
//------------------------------
L_JSR_($149F)_($0822) OK
//------------------------------
$149F  A5 60     LDA $60 
$14A1  48        PHA 
$14A2  A9 14     LDA #$14
$14A4  85 60     STA $60 
$14A6  20 79 32  JSR L_JSR_($3279)_($14A6) OK
$14A9  C6 C6     DEC $C6 
$14AB  A5 C6     LDA $C6 
$14AD  29 0F     AND #$0F
$14AF  F0 03     BEQ L_BRS_($14B4)_($14AF) OK
$14B1  4C AC 15  JMP L_JMP_($15AC)_($14B1) OK
//------------------------------
L_BRS_($14B4)_($14AF) OK
//------------------------------
$14B4  A5 C6     LDA $C6 
$14B6  29 F0     AND #$F0
$14B8  C9 51     CMP #$51
$14BA  90 03     BCC L_BRS_($14BF)_($14BA) OK
$14BC  4C AC 15  JMP L_JMP_($15AC)_($14BC) OK
//------------------------------
L_BRS_($14BF)_($14BA) OK
//------------------------------
$14BF  A5 C6     LDA $C6 
$14C1  29 F0     AND #$F0
$14C3  D0 02     BNE L_BRS_($14C7)_($14C3) OK
$14C5  A9 10     LDA #$10
//------------------------------
L_BRS_($14C7)_($14C3) OK
//------------------------------
$14C7  85 C6     STA $C6 
$14C9  20 C2 1E  JSR L_JSR_($1EC2)_($14C9) OK
$14CC  C0 03     CPY #$03
$14CE  F0 11     BEQ L_BRS_($14E1)_($14CE) OK
$14D0  C0 0A     CPY #$0A
$14D2  F0 0D     BEQ L_BRS_($14E1)_($14D2) OK
$14D4  C0 11     CPY #$11
$14D6  F0 09     BEQ L_BRS_($14E1)_($14D6) OK
$14D8  A5 14     LDA $14 
$14DA  D0 05     BNE L_BRS_($14E1)_($14DA) OK
$14DC  A9 00     LDA #$00
$14DE  4C 38 15  JMP L_JMP_($1538)_($14DE) OK
//------------------------------
L_BRS_($14E1)_($14CE) OK
L_BRS_($14E1)_($14D2) OK
L_BRS_($14E1)_($14D6) OK
L_BRS_($14E1)_($14DA) OK
//------------------------------
$14E1  20 91 0D  JSR L_JSR_($0D91)_($14E1) OK
$14E4  D0 05     BNE L_BRS_($14EB)_($14E4) OK
$14E6  A9 00     LDA #$00
$14E8  4C ED 14  JMP L_JMP_($14ED)_($14E8) OK
//------------------------------
L_BRS_($14EB)_($14E4) OK
//------------------------------
$14EB  A9 FF     LDA #$FF
//------------------------------
L_JMP_($14ED)_($14E8) OK
//------------------------------
$14ED  85 EC     STA $EC 
$14EF  A5 C7     LDA $C7 
$14F1  D0 05     BNE L_BRS_($14F8)_($14F1) OK
$14F3  A9 01     LDA #$01
$14F5  4C 38 15  JMP L_JMP_($1538)_($14F5) OK
//------------------------------
L_BRS_($14F8)_($14F1) OK
//------------------------------
$14F8  A9 01     LDA #$01
$14FA  20 D2 31  JSR L_JSR_($31D2)_($14FA) OK
$14FD  B0 20     BCS L_BRS_($151F)_($14FD) OK
$14FF  A5 C7     LDA $C7 
$1501  C9 05     CMP #$05
$1503  90 14     BCC L_BRS_($1519)_($1503) OK
//------------------------------
L_BRS_($1505)_($151D) OK
L_BRS_($1505)_($152D) OK
//------------------------------
$1505  A5 26     LDA $26 
$1507  29 07     AND #$07
$1509  C9 06     CMP #$06
$150B  F0 07     BEQ L_BRS_($1514)_($150B) OK
$150D  C9 07     CMP #$07
$150F  F0 03     BEQ L_BRS_($1514)_($150F) OK
$1511  4C AC 15  JMP L_JMP_($15AC)_($1511) OK
//------------------------------
L_BRS_($1514)_($150B) OK
L_BRS_($1514)_($150F) OK
//------------------------------
$1514  A9 04     LDA #$04
$1516  4C 38 15  JMP L_JMP_($1538)_($1516) OK
//------------------------------
L_BRS_($1519)_($1503) OK
//------------------------------
$1519  A5 40     LDA $40 
$151B  C9 08     CMP #$08
$151D  B0 E6     BCS L_BRS_($1505)_($151D) OK
//------------------------------
L_BRS_($151F)_($14FD) OK
//------------------------------
$151F  A5 EC     LDA $EC 
$1521  F0 05     BEQ L_BRS_($1528)_($1521) OK
$1523  A9 02     LDA #$02
$1525  4C 38 15  JMP L_JMP_($1538)_($1525) OK
//------------------------------
L_BRS_($1528)_($1521) OK
//------------------------------
$1528  A9 02     LDA #$02
$152A  20 D2 31  JSR L_JSR_($31D2)_($152A) OK
$152D  90 D6     BCC L_BRS_($1505)_($152D) OK
$152F  A5 14     LDA $14 
$1531  D0 03     BNE L_BRS_($1536)_($1531) OK
$1533  4C AC 15  JMP L_JMP_($15AC)_($1533) OK
//------------------------------
L_BRS_($1536)_($1531) OK
//------------------------------
$1536  A9 03     LDA #$03
//------------------------------
L_JMP_($1538)_($14DE) OK
L_JMP_($1538)_($14F5) OK
L_JMP_($1538)_($1516) OK
L_JMP_($1538)_($1525) OK
//------------------------------
$1538  85 D8     STA $D8 
$153A  A5 C6     LDA $C6 
$153C  C9 10     CMP #$10
$153E  F0 08     BEQ L_BRS_($1548)_($153E) OK
$1540  A5 71     LDA $71 
$1542  20 5B 0E  JSR L_JSR_($0E5B)_($1542) OK
$1545  4C 4B 15  JMP L_JMP_($154B)_($1545) OK
//------------------------------
L_BRS_($1548)_($153E) OK
//------------------------------
$1548  20 59 0E  JSR L_JSR_($0E59)_($1548) OK
//------------------------------
L_JMP_($154B)_($1545) OK
//------------------------------
$154B  B0 03     BCS L_BRS_($1550)_($154B) OK
$154D  4C AC 15  JMP L_JMP_($15AC)_($154D) OK
//------------------------------
L_BRS_($1550)_($154B) OK
//------------------------------
$1550  85 71     STA $71 
$1552  A9 A0     LDA #$A0
$1554  85 C6     STA $C6 
$1556  A5 D8     LDA $D8 
$1558  C9 02     CMP #$02
$155A  D0 42     BNE L_BRS_($159E)_($155A) OK
$155C  A5 70     LDA $70 
$155E  29 F0     AND #$F0
$1560  A8        TAY 
$1561  C0 00     CPY #$00
$1563  D0 05     BNE L_BRS_($156A)_($1563) OK
$1565  A9 0B     LDA #$0B
$1567  4C 87 15  JMP L_JMP_($1587)_($1567) OK
//------------------------------
L_BRS_($156A)_($1563) OK
//------------------------------
$156A  C0 10     CPY #$10
$156C  D0 05     BNE L_BRS_($1573)_($156C) OK
$156E  A9 0C     LDA #$0C
$1570  4C 87 15  JMP L_JMP_($1587)_($1570) OK
//------------------------------
L_BRS_($1573)_($156C) OK
//------------------------------
$1573  C0 20     CPY #$20
$1575  D0 05     BNE L_BRS_($157C)_($1575) OK
$1577  A9 0D     LDA #$0D
$1579  4C 87 15  JMP L_JMP_($1587)_($1579) OK
//------------------------------
L_BRS_($157C)_($1575) OK
//------------------------------
$157C  C0 30     CPY #$30
$157E  D0 05     BNE L_BRS_($1585)_($157E) OK
$1580  A9 0E     LDA #$0E
$1582  4C 87 15  JMP L_JMP_($1587)_($1582) OK
//------------------------------
L_BRS_($1585)_($157E) OK
//------------------------------
$1585  A9 FF     LDA #$FF
//------------------------------
L_JMP_($1587)_($1567) OK
L_JMP_($1587)_($1570) OK
L_JMP_($1587)_($1579) OK
L_JMP_($1587)_($1582) OK
//------------------------------
$1587  C5 71     CMP $71 
$1589  D0 13     BNE L_BRS_($159E)_($1589) OK
$158B  A9 05     LDA #$05
$158D  85 D8     STA $D8 
$158F  E6 C8     INC $C8 
$1591  A5 C8     LDA $C8 
$1593  C9 01     CMP #$01
$1595  F0 07     BEQ L_BRS_($159E)_($1595) OK
$1597  29 01     AND #$01
$1599  18        CLC 
$159A  69 06     ADC #$06
$159C  85 D8     STA $D8 
//------------------------------
L_BRS_($159E)_($155A) OK
L_BRS_($159E)_($1589) OK
L_BRS_($159E)_($1595) OK
//------------------------------
$159E  A9 14     LDA #$14
$15A0  85 72     STA $72 
$15A2  A5 71     LDA $71 
$15A4  85 60     STA $60 
$15A6  20 79 32  JSR L_JSR_($3279)_($15A6) OK
$15A9  20 B7 1D  JSR L_JSR_($1DB7)_($15A9) OK
//------------------------------
L_JMP_($15AC)_($14B1) OK
L_JMP_($15AC)_($14BC) OK
L_JMP_($15AC)_($1511) OK
L_JMP_($15AC)_($1533) OK
L_JMP_($15AC)_($154D) OK
//------------------------------
$15AC  68        PLA 
$15AD  85 60     STA $60 
$15AF  20 79 32  JSR L_JSR_($3279)_($15AF) OK
$15B2  60        RTS 
//------------------------------
L_JSR_($15B3)_($082C) OK
//------------------------------
$15B3  A5 60     LDA $60 
$15B5  48        PHA 
$15B6  A9 14     LDA #$14
$15B8  85 60     STA $60 
$15BA  20 79 32  JSR L_JSR_($3279)_($15BA) OK
$15BD  A5 2B     LDA $2B 
$15BF  0A        ASL A 
$15C0  0A        ASL A 
$15C1  90 06     BCC L_BRS_($15C9)_($15C1) OK
$15C3  20 0F 29  JSR L_JSR_($290F)_($15C3) OK
$15C6  4C 36 16  JMP L_JMP_($1636)_($15C6) OK
//------------------------------
L_BRS_($15C9)_($15C1) OK
//------------------------------
$15C9  0A        ASL A 
$15CA  0A        ASL A 
$15CB  90 48     BCC L_BRS_($1615)_($15CB) OK
$15CD  A9 00     LDA #$00
$15CF  85 4B     STA $4B 
$15D1  A5 30     LDA $30 
$15D3  F0 04     BEQ L_BRS_($15D9)_($15D3) OK
$15D5  C9 0B     CMP #$0B
$15D7  90 2F     BCC L_BRS_($1608)_($15D7) OK
//------------------------------
L_BRS_($15D9)_($15D3) OK
//------------------------------
$15D9  A9 1A     LDA #$1A
$15DB  8D 13 D4  STA $D413                          // Voice 3: Attack / Decay Cycle Control ; 1 Attack cycle, A Decay cycle
$15DE  A9 81     LDA #$81
$15E0  8D 12 D4  STA $D412                          // Voice 3: Control Register ; Noise on, Start attack/decay/sustain
$15E3  A9 0A     LDA #$0A
$15E5  85 30     STA $30 
$15E7  20 2E 32  JSR L_JSR_($322E)_($15E7) OK
$15EA  A5 26     LDA $26 
$15EC  29 06     AND #$06
$15EE  C9 05     CMP #$05
$15F0  F0 0A     BEQ L_BRS_($15FC)_($15F0) OK
$15F2  A5 26     LDA $26 
$15F4  29 80     AND #$80
$15F6  18        CLC 
$15F7  69 07     ADC #$07
$15F9  4C 03 16  JMP L_JMP_($1603)_($15F9) OK
//------------------------------
L_BRS_($15FC)_($15F0) OK
//------------------------------
$15FC  A5 26     LDA $26 
$15FE  29 80     AND #$80
$1600  18        CLC 
$1601  69 06     ADC #$06
//------------------------------
L_JMP_($1603)_($15F9) OK
//------------------------------
$1603  85 26     STA $26 
$1605  20 2E 32  JSR L_JSR_($322E)_($1605) OK
//------------------------------
L_BRS_($1608)_($15D7) OK
//------------------------------
$1608  C6 30     DEC $30 
$160A  D0 2A     BNE L_BRS_($1636)_($160A) OK
$160C  A9 00     LDA #$00
$160E  85 2B     STA $2B 
$1610  85 14     STA $14 
$1612  4C 36 16  JMP L_JMP_($1636)_($1612) OK
//------------------------------
L_BRS_($1615)_($15CB) OK
//------------------------------
$1615  0A        ASL A 
$1616  90 06     BCC L_BRS_($161E)_($1616) OK
$1618  20 4E 18  JSR L_JSR_($184E)_($1618) OK
$161B  4C 36 16  JMP L_JMP_($1636)_($161B) OK
//------------------------------
L_BRS_($161E)_($1616) OK
//------------------------------
$161E  0A        ASL A 
$161F  90 06     BCC L_BRS_($1627)_($161F) OK
$1621  20 E5 17  JSR L_JSR_($17E5)_($1621) OK
$1624  4C 36 16  JMP L_JMP_($1636)_($1624) OK
//------------------------------
L_BRS_($1627)_($161F) OK
//------------------------------
$1627  0A        ASL A 
$1628  90 06     BCC L_BRS_($1630)_($1628) OK
$162A  20 9D 18  JSR L_JSR_($189D)_($162A) OK
$162D  4C 36 16  JMP L_JMP_($1636)_($162D) OK
//------------------------------
L_BRS_($1630)_($1628) OK
//------------------------------
$1630  0A        ASL A 
$1631  90 03     BCC L_BRS_($1636)_($1631) OK
$1633  20 1B 19  JSR L_JSR_($191B)_($1633) OK
//------------------------------
L_JMP_($1636)_($15C6) OK
L_BRS_($1636)_($160A) OK
L_JMP_($1636)_($1612) OK
L_JMP_($1636)_($161B) OK
L_JMP_($1636)_($1624) OK
L_JMP_($1636)_($162D) OK
L_BRS_($1636)_($1631) OK
//------------------------------
$1636  20 BF 33  JSR L_JSR_($33BF)_($1636) OK
$1639  68        PLA 
$163A  85 60     STA $60 
$163C  20 79 32  JSR L_JSR_($3279)_($163C) OK
$163F  60        RTS 
//------------------------------
L_JSR_($1640)_($1911) OK
//------------------------------
$1640  A9 0B     LDA #$0B
$1642  85 57     STA $57 
$1644  A5 FB     LDA $FB 
$1646  85 D4     STA $D4 
$1648  E6 D4     INC $D4 
$164A  A5 FC     LDA $FC 
$164C  85 D3     STA $D3 
$164E  A9 00     LDA #$00
$1650  85 60     STA $60 
$1652  20 62 16  JSR L_JSR_($1662)_($1652) OK
$1655  90 03     BCC L_BRS_($165A)_($1655) OK
$1657  4C 9A 16  JMP L_JMP_($169A)_($1657) OK
//------------------------------
L_BRS_($165A)_($1655) OK
//------------------------------
$165A  A9 03     LDA #$03
$165C  85 57     STA $57 
$165E  A9 0F     LDA #$0F
$1660  85 60     STA $60 
//------------------------------
L_JSR_($1662)_($1652) OK
L_BRS_($1662)_($1692) OK
//------------------------------
$1662  20 79 32  JSR L_JSR_($3279)_($1662) OK
$1665  A5 D4     LDA $D4 
$1667  C5 FB     CMP $FB 
$1669  D0 23     BNE L_BRS_($168E)_($1669) OK
$166B  C6 D3     DEC $D3 
$166D  A5 FC     LDA $FC 
$166F  C5 D3     CMP $D3 
$1671  90 1B     BCC L_BRS_($168E)_($1671) OK
$1673  E6 D3     INC $D3 
$1675  E6 D3     INC $D3 
$1677  A5 D3     LDA $D3 
$1679  C5 FC     CMP $FC 
$167B  90 11     BCC L_BRS_($168E)_($167B) OK
$167D  A5 26     LDA $26 
$167F  29 0F     AND #$0F
$1681  C9 07     CMP #$07
$1683  D0 09     BNE L_BRS_($168E)_($1683) OK
$1685  A9 14     LDA #$14
$1687  20 79 32  JSR L_JSR_($3279)_($1687) OK
$168A  38        SEC 
$168B  4C 9A 16  JMP L_JMP_($169A)_($168B) OK
//------------------------------
L_BRS_($168E)_($1669) OK
L_BRS_($168E)_($1671) OK
L_BRS_($168E)_($167B) OK
L_BRS_($168E)_($1683) OK
//------------------------------
$168E  E6 60     INC $60 
$1690  C6 57     DEC $57 
$1692  D0 CE     BNE L_BRS_($1662)_($1692) OK
$1694  A9 14     LDA #$14
$1696  20 79 32  JSR L_JSR_($3279)_($1696) OK
$1699  18        CLC 
//------------------------------
L_JMP_($169A)_($1657) OK
L_JMP_($169A)_($168B) OK
//------------------------------
$169A  60        RTS 
//------------------------------
L_JSR_($169B)_($08F4) OK
//------------------------------
$169B  A9 8B     LDA #$8B
$169D  85 4F     STA $4F 
$169F  A9 60     LDA #$60
$16A1  85 4E     STA $4E 
$16A3  A0 01     LDY #$01
$16A5  B1 4E     LDA ($4E),Y 
$16A7  C9 80     CMP #$80
$16A9  90 24     BCC L_BRS_($16CF)_($16A9) OK
$16AB  A2 01     LDX #$01
$16AD  A0 08     LDY #$08
$16AF  A9 18     LDA #$18
//------------------------------
L_JMP_($16B1)_($16DB) OK
L_JMP_($16B1)_($16E5) OK
L_JMP_($16B1)_($1A00) OK
//------------------------------
$16B1  85 FE     STA $FE 
$16B3  A5 14     LDA $14 
$16B5  F0 18     BEQ L_BRS_($16CF)_($16B5) OK
$16B7  86 2B     STX $2B 
$16B9  98        TYA 
$16BA  48        PHA 
$16BB  20 2E 32  JSR L_JSR_($322E)_($16BB) OK
$16BE  A5 26     LDA $26 
$16C0  85 D2     STA $D2 
$16C2  29 80     AND #$80
$16C4  85 26     STA $26 
$16C6  68        PLA 
$16C7  18        CLC 
$16C8  65 26     ADC $26 
$16CA  85 26     STA $26 
$16CC  20 2E 32  JSR L_JSR_($322E)_($16CC) OK
//------------------------------
L_BRS_($16CF)_($16A9) OK
L_BRS_($16CF)_($16B5) OK
//------------------------------
$16CF  60        RTS 
//------------------------------
L_JSR_($16D0)_($08E6) OK
//------------------------------
$16D0  20 8E 1C  JSR L_JSR_($1C8E)_($16D0) OK
$16D3  B0 09     BCS L_BRS_($16DE)_($16D3) OK
$16D5  A2 02     LDX #$02
$16D7  A0 0C     LDY #$0C
$16D9  A9 10     LDA #$10
$16DB  4C B1 16  JMP L_JMP_($16B1)_($16DB) OK
//------------------------------
L_BRS_($16DE)_($16D3) OK
//------------------------------
$16DE  60        RTS 
//------------------------------
L_JSR_($16DF)_($08CE) OK
//------------------------------
$16DF  A2 04     LDX #$04
$16E1  A0 0A     LDY #$0A
$16E3  A9 12     LDA #$12
$16E5  4C B1 16  JMP L_JMP_($16B1)_($16E5) OK
$16E8  60        RTS 
//------------------------------
$16E9  A9 17     LDA #$17
$16EB  85 AB     STA $AB 
$16ED  A9 0E     LDA #$0E
$16EF  85 AA     STA $AA 
$16F1  20 68 14  JSR L_JSR_($1468)_($16F1) OK
$16F4  A9 20     LDA #$20
$16F6  85 AC     STA $AC 
$16F8  A5 15     LDA $15 
$16FA  18        CLC 
$16FB  69 07     ADC #$07
$16FD  85 AD     STA $AD 
$16FF  A5 16     LDA $16 
$1701  85 AE     STA $AE 
$1703  A9 00     LDA #$00
$1705  85 19     STA $19 
$1707  85 1A     STA $1A 
$1709  A4 DA     LDY $DA 
$170B  20 45 14  JSR L_JSR_($1445)_($170B) OK
$170E  A5 AC     LDA $AC 
$1710  D0 03     BNE L_BRS_($1715)_($1710) OK
$1712  4C 28 1D  JMP L_JMP_($1D28)_($1712) OK
//------------------------------
L_BRS_($1715)_($1710) OK
//------------------------------
$1715  20 2E 32  JSR L_JSR_($322E)_($1715) OK
$1718  C6 AC     DEC $AC 
$171A  A5 AC     LDA $AC 
$171C  4A        LSR A 
$171D  B0 13     BCS L_BRS_($1732)_($171D) OK
$171F  48        PHA 
$1720  A5 26     LDA $26 
$1722  29 F8     AND #$F8
$1724  85 26     STA $26 
$1726  68        PLA 
$1727  4A        LSR A 
$1728  90 02     BCC L_BRS_($172C)_($1728) OK
$172A  C6 FC     DEC $FC 
//------------------------------
L_BRS_($172C)_($1728) OK
L_JMP_($172C)_($1737) OK
//------------------------------
$172C  20 2E 32  JSR L_JSR_($322E)_($172C) OK
$172F  4C 69 17  JMP L_JMP_($1769)_($172F) OK
//------------------------------
L_BRS_($1732)_($171D) OK
//------------------------------
$1732  4A        LSR A 
$1733  90 05     BCC L_BRS_($173A)_($1733) OK
$1735  E6 26     INC $26 
$1737  4C 2C 17  JMP L_JMP_($172C)_($1737) OK
//------------------------------
L_BRS_($173A)_($1733) OK
//------------------------------
$173A  A5 26     LDA $26 
$173C  18        CLC 
$173D  69 05     ADC #$05
$173F  85 26     STA $26 
$1741  20 2E 32  JSR L_JSR_($322E)_($1741) OK
$1744  A5 AD     LDA $AD 
$1746  38        SEC 
$1747  E5 58     SBC $58 
$1749  85 49     STA $49 
$174B  A5 AE     LDA $AE 
$174D  85 4A     STA $4A 
$174F  20 E3 36  JSR L_JSR_($36E3)_($174F) OK
$1752  E6 4A     INC $4A 
$1754  20 E3 36  JSR L_JSR_($36E3)_($1754) OK
$1757  A6 AD     LDX $AD 
$1759  86 15     STX $15 
$175B  A4 AE     LDY $AE 
$175D  84 16     STY $16 
$175F  20 94 19  JSR L_JSR_($1994)_($175F) OK
$1762  E6 16     INC $16 
$1764  20 94 19  JSR L_JSR_($1994)_($1764) OK
$1767  C6 AD     DEC $AD 
//------------------------------
L_JMP_($1769)_($172F) OK
//------------------------------
$1769  EA        NOP 
$176A  EA        NOP 
$176B  EA        NOP 
$176C  EA        NOP 
$176D  EA        NOP 
$176E  60        RTS 
//------------------------------
L_JMP_($176F)_($18AA) OK
//------------------------------
$176F  20 2E 32  JSR L_JSR_($322E)_($176F) OK
$1772  E6 26     INC $26 
$1774  C6 FB     DEC $FB 
$1776  20 2E 32  JSR L_JSR_($322E)_($1776) OK
$1779  A5 FC     LDA $FC 
$177B  85 E9     STA $E9 
$177D  A5 FB     LDA $FB 
$177F  85 EA     STA $EA 
$1781  A5 26     LDA $26 
$1783  0A        ASL A 
$1784  90 04     BCC L_BRS_($178A)_($1784) OK
$1786  E6 E9     INC $E9 
$1788  E6 E9     INC $E9 
//------------------------------
L_BRS_($178A)_($1784) OK
//------------------------------
$178A  A9 0A     LDA #$0A
$178C  C5 E9     CMP $E9 
$178E  F0 07     BEQ L_BRS_($1797)_($178E) OK
//------------------------------
L_BRS_($1790)_($179B) OK
//------------------------------
$1790  A6 E9     LDX $E9 
$1792  A4 EA     LDY $EA 
$1794  4C B0 2B  JMP L_JMP_($2BB0)_($1794) OK
//------------------------------
L_BRS_($1797)_($178E) OK
//------------------------------
$1797  A9 09     LDA #$09
$1799  C5 EA     CMP $EA 
$179B  D0 F3     BNE L_BRS_($1790)_($179B) OK
$179D  A5 46     LDA $46 
$179F  C9 02     CMP #$02
$17A1  D0 41     BNE L_BRS_($17E4)_($17A1) OK
$17A3  A9 02     LDA #$02
$17A5  85 57     STA $57 
//------------------------------
L_JMP_($17A7)_($17DA) OK
//------------------------------
$17A7  A8        TAY 
$17A8  20 21 14  JSR L_JSR_($1421)_($17A8) OK
$17AB  A9 14     LDA #$14
$17AD  C5 1A     CMP $1A 
$17AF  D0 23     BNE L_BRS_($17D4)_($17AF) OK
$17B1  A5 E2     LDA $E2 
$17B3  29 5F     AND #$5F
$17B5  C5 90     CMP $90 
$17B7  D0 1B     BNE L_BRS_($17D4)_($17B7) OK
$17B9  A5 E1     LDA $E1 
$17BB  29 5F     AND #$5F
$17BD  C5 91     CMP $91 
$17BF  D0 13     BNE L_BRS_($17D4)_($17BF) OK
$17C1  A5 E0     LDA $E0 
$17C3  29 5F     AND #$5F
$17C5  C5 92     CMP $92 
$17C7  D0 0B     BNE L_BRS_($17D4)_($17C7) OK
$17C9  A5 DF     LDA $DF 
$17CB  29 5F     AND #$5F
$17CD  C5 93     CMP $93 
$17CF  D0 03     BNE L_BRS_($17D4)_($17CF) OK
$17D1  4C DD 17  JMP L_JMP_($17DD)_($17D1) OK
//------------------------------
L_BRS_($17D4)_($17AF) OK
L_BRS_($17D4)_($17B7) OK
L_BRS_($17D4)_($17BF) OK
L_BRS_($17D4)_($17C7) OK
L_BRS_($17D4)_($17CF) OK
//------------------------------
$17D4  C6 57     DEC $57 
$17D6  A5 57     LDA $57 
$17D8  30 0A     BMI L_BRS_($17E4)_($17D8) OK
$17DA  4C A7 17  JMP L_JMP_($17A7)_($17DA) OK
//------------------------------
L_JMP_($17DD)_($17D1) OK
//------------------------------
$17DD  A9 FF     LDA #$FF
$17DF  85 D5     STA $D5 
$17E1  4C 37 2C  JMP L_JMP_($2C37)_($17E1) OK
//------------------------------
L_BRS_($17E4)_($17A1) OK
L_BRS_($17E4)_($17D8) OK
//------------------------------
$17E4  60        RTS 
//------------------------------
L_JSR_($17E5)_($1621) OK
//------------------------------
$17E5  C6 FE     DEC $FE 
$17E7  D0 03     BNE L_BRS_($17EC)_($17E7) OK
$17E9  4C 1F 19  JMP L_JMP_($191F)_($17E9) OK
//------------------------------
L_BRS_($17EC)_($17E7) OK
//------------------------------
$17EC  A5 FE     LDA $FE 
$17EE  C9 0C     CMP #$0C
$17F0  D0 03     BNE L_BRS_($17F5)_($17F0) OK
$17F2  4C 47 2B  JMP L_JMP_($2B47)_($17F2) OK
//------------------------------
L_BRS_($17F5)_($17F0) OK
//------------------------------
$17F5  C9 0B     CMP #$0B
$17F7  D0 54     BNE L_BRS_($184D)_($17F7) OK
$17F9  A4 FB     LDY $FB 
$17FB  A5 26     LDA $26 
$17FD  0A        ASL A 
$17FE  B0 08     BCS L_BRS_($1808)_($17FE) OK
$1800  A5 FC     LDA $FC 
$1802  38        SEC 
$1803  E9 02     SBC #$02
$1805  4C 0D 18  JMP L_JMP_($180D)_($1805) OK
//------------------------------
L_BRS_($1808)_($17FE) OK
//------------------------------
$1808  A5 FC     LDA $FC 
$180A  18        CLC 
$180B  69 02     ADC #$02
//------------------------------
L_JMP_($180D)_($1805) OK
//------------------------------
$180D  AA        TAX 
$180E  20 D2 27  JSR L_JSR_($27D2)_($180E) OK
$1811  90 1C     BCC L_BRS_($182F)_($1811) OK
$1813  C9 0F     CMP #$0F
$1815  85 C1     STA $C1 
$1817  D0 05     BNE L_BRS_($181E)_($1817) OK
$1819  A9 03     LDA #$03
$181B  20 37 1D  JSR L_JSR_($1D37)_($181B) OK
//------------------------------
L_BRS_($181E)_($1817) OK
//------------------------------
$181E  20 BF 33  JSR L_JSR_($33BF)_($181E) OK
$1821  A5 60     LDA $60 
$1823  85 2F     STA $2F 
$1825  A5 C1     LDA $C1 
$1827  85 60     STA $60 
$1829  20 79 32  JSR L_JSR_($3279)_($1829) OK
$182C  20 19 2A  JSR L_JSR_($2A19)_($182C) OK
//------------------------------
L_BRS_($182F)_($1811) OK
//------------------------------
$182F  A9 10     LDA #$10
$1831  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte
$1834  A9 00     LDA #$00
$1836  8D 07 D4  STA $D407                          // Voice 2: Frequency Control - Low-Byte ; Frequency = 240,53955078125 Hz
$1839  A9 34     LDA #$34
$183B  8D 0C D4  STA $D40C                          // Voice 2: Attack / Decay Cycle Control ; Attack = 3, Decay = 4
$183E  A9 00     LDA #$00
$1840  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control ; Sustain = 0, Release = 0
$1843  A9 81     LDA #$81
$1845  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Noise on, start attack/decay
$1848  A9 0E     LDA #$0E
$184A  4C 72 19  JMP L_JMP_($1972)_($184A) OK
//------------------------------
L_BRS_($184D)_($17F7) OK
//------------------------------
$184D  60        RTS 
//------------------------------
L_JSR_($184E)_($1618) OK
//------------------------------
$184E  C6 FE     DEC $FE 
$1850  A5 FE     LDA $FE 
$1852  C9 04     CMP #$04
$1854  D0 03     BNE L_BRS_($1859)_($1854) OK
$1856  4C 28 19  JMP L_JMP_($1928)_($1856) OK
//------------------------------
L_BRS_($1859)_($1854) OK
//------------------------------
$1859  C9 00     CMP #$00
$185B  F0 03     BEQ L_BRS_($1860)_($185B) OK
$185D  4C 9C 18  JMP L_JMP_($189C)_($185D) OK
//------------------------------
L_BRS_($1860)_($185B) OK
//------------------------------
$1860  A9 01     LDA #$01
$1862  85 FE     STA $FE 
$1864  A5 4C     LDA $4C 
$1866  85 57     STA $57 
$1868  A9 00     LDA #$00
$186A  85 4C     STA $4C 
$186C  A5 57     LDA $57 
$186E  F0 2C     BEQ L_BRS_($189C)_($186E) OK
$1870  C9 0D     CMP #$0D
$1872  D0 03     BNE L_BRS_($1877)_($1872) OK
$1874  4C 1F 19  JMP L_JMP_($191F)_($1874) OK
//------------------------------
L_BRS_($1877)_($1872) OK
//------------------------------
$1877  C9 20     CMP #$20
$1879  90 21     BCC L_BRS_($189C)_($1879) OK
$187B  C9 80     CMP #$80
$187D  B0 1D     BCS L_BRS_($189C)_($187D) OK
$187F  20 68 14  JSR L_JSR_($1468)_($187F) OK
$1882  A2 03     LDX #$03
//------------------------------
L_BRS_($1884)_($1892) OK
//------------------------------
$1884  B5 DF     LDA $DF,X 
$1886  C9 80     CMP #$80
$1888  D0 07     BNE L_BRS_($1891)_($1888) OK
$188A  A5 57     LDA $57 
$188C  95 DF     STA $DF,X 
$188E  4C 94 18  JMP L_JMP_($1894)_($188E) OK
//------------------------------
L_BRS_($1891)_($1888) OK
//------------------------------
$1891  CA        DEX 
$1892  10 F0     BPL L_BRS_($1884)_($1892) OK
//------------------------------
L_JMP_($1894)_($188E) OK
//------------------------------
$1894  A5 57     LDA $57 
$1896  20 CF 11  JSR L_JSR_($11CF)_($1896) OK
$1899  4C F5 19  JMP L_JMP_($19F5)_($1899) OK
//------------------------------
L_JMP_($189C)_($185D) OK
L_BRS_($189C)_($186E) OK
L_BRS_($189C)_($1879) OK
L_BRS_($189C)_($187D) OK
//------------------------------
$189C  60        RTS 
//------------------------------
L_JSR_($189D)_($162A) OK
//------------------------------
$189D  C6 FE     DEC $FE 
$189F  D0 03     BNE L_BRS_($18A4)_($189F) OK
$18A1  4C 1F 19  JMP L_JMP_($191F)_($18A1) OK
//------------------------------
L_BRS_($18A4)_($189F) OK
//------------------------------
$18A4  A5 FE     LDA $FE 
//------------------------------
L_JMP_($18A6)_($18F4) OK
//------------------------------
$18A6  C9 0D     CMP #$0D
$18A8  D0 03     BNE L_BRS_($18AD)_($18A8) OK
$18AA  4C 6F 17  JMP L_JMP_($176F)_($18AA) OK
//------------------------------
L_BRS_($18AD)_($18A8) OK
//------------------------------
$18AD  C9 0C     CMP #$0C
$18AF  D0 05     BNE L_BRS_($18B6)_($18AF) OK
$18B1  A9 0F     LDA #$0F
$18B3  4C 72 19  JMP L_JMP_($1972)_($18B3) OK
//------------------------------
L_BRS_($18B6)_($18AF) OK
//------------------------------
$18B6  C9 0E     CMP #$0E
$18B8  D0 0B     BNE L_BRS_($18C5)_($18B8) OK
$18BA  A9 02     LDA #$02
$18BC  85 2C     STA $2C 
$18BE  A9 21     LDA #$21
$18C0  85 2D     STA $2D 
$18C2  4C 1A 19  JMP L_JMP_($191A)_($18C2) OK
//------------------------------
L_BRS_($18C5)_($18B8) OK
//------------------------------
$18C5  C9 09     CMP #$09
$18C7  D0 03     BNE L_BRS_($18CC)_($18C7) OK
$18C9  4C A7 2B  JMP L_JMP_($2BA7)_($18C9) OK
//------------------------------
L_BRS_($18CC)_($18C7) OK
//------------------------------
$18CC  C9 03     CMP #$03
$18CE  D0 0B     BNE L_BRS_($18DB)_($18CE) OK
$18D0  20 2E 32  JSR L_JSR_($322E)_($18D0) OK
$18D3  E6 FB     INC $FB 
$18D5  20 2E 32  JSR L_JSR_($322E)_($18D5) OK
$18D8  4C 1A 19  JMP L_JMP_($191A)_($18D8) OK
//------------------------------
L_BRS_($18DB)_($18CE) OK
//------------------------------
$18DB  C9 86     CMP #$86
$18DD  D0 03     BNE L_BRS_($18E2)_($18DD) OK
$18DF  4C 1A 19  JMP L_JMP_($191A)_($18DF) OK
//------------------------------
L_BRS_($18E2)_($18DD) OK
//------------------------------
$18E2  C9 80     CMP #$80
$18E4  D0 07     BNE L_BRS_($18ED)_($18E4) OK
$18E6  A9 07     LDA #$07
$18E8  85 FE     STA $FE 
$18EA  4C 1A 19  JMP L_JMP_($191A)_($18EA) OK
//------------------------------
L_BRS_($18ED)_($18E4) OK
//------------------------------
$18ED  C9 81     CMP #$81
$18EF  90 06     BCC L_BRS_($18F7)_($18EF) OK
$18F1  38        SEC 
$18F2  E9 80     SBC #$80
$18F4  4C A6 18  JMP L_JMP_($18A6)_($18F4) OK
//------------------------------
L_BRS_($18F7)_($18EF) OK
//------------------------------
$18F7  C9 06     CMP #$06
$18F9  F0 03     BEQ L_BRS_($18FE)_($18F9) OK
$18FB  4C 1A 19  JMP L_JMP_($191A)_($18FB) OK
//------------------------------
L_BRS_($18FE)_($18F9) OK
//------------------------------
$18FE  A5 4C     LDA $4C 
$1900  48        PHA 
//------------------------------
L_JSR_($1902)_($C415) BAD
L_JSR_($1902)_($FE0F) BAD
//------------------------------
$1901  A9 00     LDA #$00
$1903  85 4C     STA $4C 
$1905  68        PLA 
$1906  C9 4A     CMP #$4A
$1908  F0 07     BEQ L_BRS_($1911)_($1908) OK
$190A  C9 4C     CMP #$4C
$190C  F0 03     BEQ L_BRS_($1911)_($190C) OK
$190E  4C 1A 19  JMP L_JMP_($191A)_($190E) OK
//------------------------------
L_BRS_($1911)_($1908) OK
L_BRS_($1911)_($190C) OK
//------------------------------
$1911  20 40 16  JSR L_JSR_($1640)_($1911) OK
$1914  90 04     BCC L_BRS_($191A)_($1914) OK
$1916  A9 90     LDA #$90
$1918  85 FE     STA $FE 
//------------------------------
L_JMP_($191A)_($18C2) OK
L_JMP_($191A)_($18D8) OK
L_JMP_($191A)_($18DF) OK
L_JMP_($191A)_($18EA) OK
L_JMP_($191A)_($18FB) OK
L_JMP_($191A)_($190E) OK
L_BRS_($191A)_($1914) OK
//------------------------------
$191A  60        RTS 
//------------------------------
L_JSR_($191B)_($1633) OK
//------------------------------
$191B  C6 FE     DEC $FE 
$191D  D0 16     BNE L_BRS_($1935)_($191D) OK
//------------------------------
L_JMP_($191F)_($17E9) OK
L_JMP_($191F)_($1874) OK
L_JMP_($191F)_($18A1) OK
//------------------------------
$191F  A9 00     LDA #$00
$1921  85 2B     STA $2B 
$1923  A9 10     LDA #$10
$1925  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Select Triangle Waveform On
//------------------------------
L_JMP_($1928)_($1856) OK
//------------------------------
$1928  20 2E 32  JSR L_JSR_($322E)_($1928) OK
$192B  A5 D2     LDA $D2 
$192D  85 26     STA $26 
$192F  20 2E 32  JSR L_JSR_($322E)_($192F) OK
$1932  4C 93 19  JMP L_JMP_($1993)_($1932) OK
//------------------------------
L_BRS_($1935)_($191D) OK
//------------------------------
$1935  A5 FE     LDA $FE 
$1937  C9 12     CMP #$12
$1939  D0 03     BNE L_BRS_($193E)_($1939) OK
$193B  4C 47 2B  JMP L_JMP_($2B47)_($193B) OK
//------------------------------
L_BRS_($193E)_($1939) OK
//------------------------------
$193E  C9 06     CMP #$06
$1940  D0 03     BNE L_BRS_($1945)_($1940) OK
$1942  4C A7 2B  JMP L_JMP_($2BA7)_($1942) OK
//------------------------------
L_BRS_($1945)_($1940) OK
//------------------------------
$1945  C9 0C     CMP #$0C
$1947  F0 03     BEQ L_BRS_($194C)_($1947) OK
$1949  4C 93 19  JMP L_JMP_($1993)_($1949) OK
//------------------------------
L_BRS_($194C)_($1947) OK
//------------------------------
$194C  A5 60     LDA $60 
$194E  85 DB     STA $DB 
$1950  A9 13     LDA #$13
$1952  85 DC     STA $DC 
$1954  20 62 2B  JSR L_JSR_($2B62)_($1954) OK
$1957  A9 30     LDA #$30
$1959  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte
$195C  A9 00     LDA #$00
$195E  8D 07 D4  STA $D407                          // Voice 2: Frequency Control - Low-Byte ; sound frequency = 721,61865234375 Hz
$1961  A9 1B     LDA #$1B
$1963  8D 0C D4  STA $D40C                          // Voice 2: Attack / Decay Cycle Control ; Attack 01, Decay 0B
$1966  A9 00     LDA #$00
$1968  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control ; Sustain 00, Release 00
$196B  A9 11     LDA #$11
$196D  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Select Triangle Waveform, Gate Bit: 1 = Start Att,Dec,Sus
$1970  A9 0D     LDA #$0D
//------------------------------
L_JMP_($1972)_($184A) OK
L_JMP_($1972)_($18B3) OK
//------------------------------
$1972  85 D8     STA $D8 
$1974  20 59 0E  JSR L_JSR_($0E59)_($1974) OK
$1977  90 1A     BCC L_BRS_($1993)_($1977) OK
$1979  85 C0     STA $C0 
$197B  A9 14     LDA #$14
$197D  85 72     STA $72 
$197F  20 BF 33  JSR L_JSR_($33BF)_($197F) OK
$1982  A5 C0     LDA $C0 
$1984  85 60     STA $60 
$1986  20 79 32  JSR L_JSR_($3279)_($1986) OK
$1989  20 B7 1D  JSR L_JSR_($1DB7)_($1989) OK
$198C  A9 14     LDA #$14
$198E  85 60     STA $60 
$1990  20 79 32  JSR L_JSR_($3279)_($1990) OK
//------------------------------
L_JMP_($1993)_($1932) OK
L_JMP_($1993)_($1949) OK
L_BRS_($1993)_($1977) OK
//------------------------------
$1993  60        RTS 
//------------------------------
L_JSR_($1994)_($175F) OK
L_JSR_($1994)_($1764) OK
//------------------------------
$1994  20 94 12  JSR L_JSR_($1294)_($1994) OK
$1997  A2 08     LDX #$08
$1999  A0 00     LDY #$00
$199B  A9 FF     LDA #$FF
//------------------------------
L_BRS_($199D)_($19A2) OK
//------------------------------
$199D  91 1B     STA ($1B),Y 
$199F  E6 1C     INC $1C 
$19A1  CA        DEX 
$19A2  D0 F9     BNE L_BRS_($199D)_($19A2) OK
$19A4  60        RTS 
//------------------------------
L_JSR_($19A5)_($08D8) OK
//------------------------------
$19A5  A5 14     LDA $14 
$19A7  D0 03     BNE L_BRS_($19AC)_($19A7) OK
$19A9  4C 03 1A  JMP L_JMP_($1A03)_($19A9) OK
//------------------------------
L_BRS_($19AC)_($19A7) OK
//------------------------------
$19AC  A5 FB     LDA $FB 
$19AE  C9 03     CMP #$03
$19B0  F0 1F     BEQ L_BRS_($19D1)_($19B0) OK
$19B2  C9 0A     CMP #$0A
$19B4  F0 03     BEQ L_BRS_($19B9)_($19B4) OK
$19B6  4C 03 1A  JMP L_JMP_($1A03)_($19B6) OK
//------------------------------
L_BRS_($19B9)_($19B4) OK
//------------------------------
$19B9  A5 FC     LDA $FC 
$19BB  C9 2B     CMP #$2B
$19BD  90 07     BCC L_BRS_($19C6)_($19BD) OK
$19BF  C9 2F     CMP #$2F
$19C1  B0 03     BCS L_BRS_($19C6)_($19C1) OK
$19C3  4C DB 19  JMP L_JMP_($19DB)_($19C3) OK
//------------------------------
L_BRS_($19C6)_($19BD) OK
L_BRS_($19C6)_($19C1) OK
//------------------------------
$19C6  C9 1C     CMP #$1C
$19C8  90 39     BCC L_BRS_($1A03)_($19C8) OK
$19CA  C9 20     CMP #$20
$19CC  B0 35     BCS L_BRS_($1A03)_($19CC) OK
$19CE  4C DB 19  JMP L_JMP_($19DB)_($19CE) OK
//------------------------------
L_BRS_($19D1)_($19B0) OK
//------------------------------
$19D1  A5 FC     LDA $FC 
$19D3  C9 2C     CMP #$2C
$19D5  90 2C     BCC L_BRS_($1A03)_($19D5) OK
$19D7  C9 30     CMP #$30
$19D9  B0 28     BCS L_BRS_($1A03)_($19D9) OK
//------------------------------
L_JMP_($19DB)_($19C3) OK
L_JMP_($19DB)_($19CE) OK
//------------------------------
$19DB  20 68 14  JSR L_JSR_($1468)_($19DB) OK
$19DE  A5 1A     LDA $1A 
$19E0  F0 05     BEQ L_BRS_($19E7)_($19E0) OK
$19E2  A9 00     LDA #$00
$19E4  4C E9 19  JMP L_JMP_($19E9)_($19E4) OK
//------------------------------
L_BRS_($19E7)_($19E0) OK
//------------------------------
$19E7  A9 80     LDA #$80
//------------------------------
L_JMP_($19E9)_($19E4) OK
//------------------------------
$19E9  85 DF     STA $DF 
$19EB  85 E0     STA $E0 
$19ED  85 E1     STA $E1 
$19EF  85 E2     STA $E2 
$19F1  A9 14     LDA #$14
$19F3  85 1A     STA $1A 
//------------------------------
L_JMP_($19F5)_($1899) OK
//------------------------------
$19F5  A4 DA     LDY $DA 
$19F7  20 45 14  JSR L_JSR_($1445)_($19F7) OK
$19FA  A2 08     LDX #$08
$19FC  A0 0D     LDY #$0D
$19FE  A9 0A     LDA #$0A
$1A00  4C B1 16  JMP L_JMP_($16B1)_($1A00) OK
//------------------------------
L_JMP_($1A03)_($19A9) OK
L_JMP_($1A03)_($19B6) OK
L_BRS_($1A03)_($19C8) OK
L_BRS_($1A03)_($19CC) OK
L_BRS_($1A03)_($19D5) OK
L_BRS_($1A03)_($19D9) OK
//------------------------------
$1A03  60        RTS 
//------------------------------
$1A04  A5 3F     LDA $3F 
$1A06  29 FC     AND #$FC
$1A08  85 3F     STA $3F 
$1A0A  20 E7 3B  JSR L_JSR_($3BE7)_($1A0A) OK
$1A0D  85 A6     STA $A6 
$1A0F  A5 FC     LDA $FC 
$1A11  85 A7     STA $A7 
$1A13  A9 1A     LDA #$1A
$1A15  85 2A     STA $2A 
$1A17  A9 1B     LDA #$1B
$1A19  85 29     STA $29 
//------------------------------
L_JMP_($1A1B)_($27CE) OK
//------------------------------
$1A1B  A5 A6     LDA $A6 
$1A1D  20 D2 31  JSR L_JSR_($31D2)_($1A1D) OK
$1A20  90 15     BCC L_BRS_($1A37)_($1A20) OK
$1A22  A5 FC     LDA $FC 
$1A24  C5 A7     CMP $A7 
$1A26  D0 08     BNE L_BRS_($1A30)_($1A26) OK
$1A28  A5 26     LDA $26 
$1A2A  4A        LSR A 
$1A2B  B0 03     BCS L_BRS_($1A30)_($1A2B) OK
$1A2D  4C 2D 1D  JMP L_JMP_($1D2D)_($1A2D) OK
//------------------------------
L_BRS_($1A30)_($1A26) OK
L_BRS_($1A30)_($1A2B) OK
//------------------------------
$1A30  A5 A7     LDA $A7 
$1A32  85 AC     STA $AC 
$1A34  4C 45 1A  JMP L_JMP_($1A45)_($1A34) OK
//------------------------------
L_BRS_($1A37)_($1A20) OK
//------------------------------
$1A37  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$1A3A  29 07     AND #$07
$1A3C  85 57     STA $57 
$1A3E  A5 A7     LDA $A7 
$1A40  38        SEC 
$1A41  E5 57     SBC $57 
$1A43  85 AC     STA $AC 
//------------------------------
L_JMP_($1A45)_($1A34) OK
//------------------------------
$1A45  A9 13     LDA #$13
$1A47  85 AB     STA $AB 
$1A49  A9 6F     LDA #$6F
$1A4B  85 AA     STA $AA 
$1A4D  6C AA 00  JMP ($00AA) 
$1A50  60        RTS 
//------------------------------
L_JSR_($1A51)_($1CF7) OK
L_JSR_($1A51)_($36BF) OK
//------------------------------
$1A51  A5 26     LDA $26 
$1A53  0A        ASL A 
$1A54  90 03     BCC L_BRS_($1A59)_($1A54) OK
$1A56  4C DD 1A  JMP L_JMP_($1ADD)_($1A56) OK
//------------------------------
L_BRS_($1A59)_($1A54) OK
//------------------------------
$1A59  A6 FC     LDX $FC 
$1A5B  A4 FB     LDY $FB 
$1A5D  20 6D 12  JSR L_JSR_($126D)_($1A5D) OK
$1A60  F0 49     BEQ L_BRS_($1AAB)_($1A60) OK
$1A62  C9 04     CMP #$04
$1A64  F0 45     BEQ L_BRS_($1AAB)_($1A64) OK
$1A66  A5 FC     LDA $FC 
$1A68  C9 27     CMP #$27
$1A6A  B0 16     BCS L_BRS_($1A82)_($1A6A) OK
$1A6C  C9 1D     CMP #$1D
$1A6E  B0 03     BCS L_BRS_($1A73)_($1A6E) OK
$1A70  4C 1E 1B  JMP L_JMP_($1B1E)_($1A70) OK
//------------------------------
L_BRS_($1A73)_($1A6E) OK
//------------------------------
$1A73  C9 26     CMP #$26
$1A75  B0 08     BCS L_BRS_($1A7F)_($1A75) OK
$1A77  85 57     STA $57 
$1A79  4A        LSR A 
$1A7A  90 03     BCC L_BRS_($1A7F)_($1A7A) OK
$1A7C  4C 2A 1B  JMP L_JMP_($1B2A)_($1A7C) OK
//------------------------------
L_BRS_($1A7F)_($1A75) OK
L_BRS_($1A7F)_($1A7A) OK
//------------------------------
$1A7F  4C 24 1B  JMP L_JMP_($1B24)_($1A7F) OK
//------------------------------
L_BRS_($1A82)_($1A6A) OK
//------------------------------
$1A82  C9 2B     CMP #$2B
$1A84  B0 03     BCS L_BRS_($1A89)_($1A84) OK
$1A86  4C 1E 1B  JMP L_JMP_($1B1E)_($1A86) OK
//------------------------------
L_BRS_($1A89)_($1A84) OK
//------------------------------
$1A89  C9 45     CMP #$45
$1A8B  B0 1B     BCS L_BRS_($1AA8)_($1A8B) OK
$1A8D  C9 3C     CMP #$3C
$1A8F  B0 0F     BCS L_BRS_($1AA0)_($1A8F) OK
$1A91  C9 36     CMP #$36
$1A93  B0 08     BCS L_BRS_($1A9D)_($1A93) OK
$1A95  85 57     STA $57 
$1A97  4A        LSR A 
$1A98  90 03     BCC L_BRS_($1A9D)_($1A98) OK
$1A9A  4C 2A 1B  JMP L_JMP_($1B2A)_($1A9A) OK
//------------------------------
L_BRS_($1A9D)_($1A93) OK
L_BRS_($1A9D)_($1A98) OK
//------------------------------
$1A9D  4C 24 1B  JMP L_JMP_($1B24)_($1A9D) OK
//------------------------------
L_BRS_($1AA0)_($1A8F) OK
//------------------------------
$1AA0  85 57     STA $57 
$1AA2  4A        LSR A 
$1AA3  B0 03     BCS L_BRS_($1AA8)_($1AA3) OK
$1AA5  4C 2A 1B  JMP L_JMP_($1B2A)_($1AA5) OK
//------------------------------
L_BRS_($1AA8)_($1A8B) OK
L_BRS_($1AA8)_($1AA3) OK
//------------------------------
$1AA8  4C 24 1B  JMP L_JMP_($1B24)_($1AA8) OK
//------------------------------
L_BRS_($1AAB)_($1A60) OK
L_BRS_($1AAB)_($1A64) OK
//------------------------------
$1AAB  A5 FC     LDA $FC 
$1AAD  C9 3A     CMP #$3A
$1AAF  B0 16     BCS L_BRS_($1AC7)_($1AAF) OK
$1AB1  C9 30     CMP #$30
$1AB3  B0 03     BCS L_BRS_($1AB8)_($1AB3) OK
$1AB5  4C 1E 1B  JMP L_JMP_($1B1E)_($1AB5) OK
//------------------------------
L_BRS_($1AB8)_($1AB3) OK
//------------------------------
$1AB8  C9 39     CMP #$39
$1ABA  B0 08     BCS L_BRS_($1AC4)_($1ABA) OK
$1ABC  85 57     STA $57 
$1ABE  4A        LSR A 
$1ABF  B0 03     BCS L_BRS_($1AC4)_($1ABF) OK
$1AC1  4C 2A 1B  JMP L_JMP_($1B2A)_($1AC1) OK
//------------------------------
L_BRS_($1AC4)_($1ABA) OK
L_BRS_($1AC4)_($1ABF) OK
//------------------------------
$1AC4  4C 24 1B  JMP L_JMP_($1B24)_($1AC4) OK
//------------------------------
L_BRS_($1AC7)_($1AAF) OK
//------------------------------
$1AC7  C9 40     CMP #$40
$1AC9  B0 03     BCS L_BRS_($1ACE)_($1AC9) OK
$1ACB  4C 1E 1B  JMP L_JMP_($1B1E)_($1ACB) OK
//------------------------------
L_BRS_($1ACE)_($1AC9) OK
//------------------------------
$1ACE  C9 49     CMP #$49
$1AD0  B0 08     BCS L_BRS_($1ADA)_($1AD0) OK
$1AD2  85 57     STA $57 
$1AD4  4A        LSR A 
$1AD5  B0 03     BCS L_BRS_($1ADA)_($1AD5) OK
$1AD7  4C 2A 1B  JMP L_JMP_($1B2A)_($1AD7) OK
//------------------------------
L_BRS_($1ADA)_($1AD0) OK
L_BRS_($1ADA)_($1AD5) OK
//------------------------------
$1ADA  4C 24 1B  JMP L_JMP_($1B24)_($1ADA) OK
//------------------------------
L_JMP_($1ADD)_($1A56) OK
//------------------------------
$1ADD  A6 FC     LDX $FC 
$1ADF  A4 FB     LDY $FB 
$1AE1  20 6D 12  JSR L_JSR_($126D)_($1AE1) OK
$1AE4  F0 1E     BEQ L_BRS_($1B04)_($1AE4) OK
$1AE6  C9 04     CMP #$04
$1AE8  F0 1A     BEQ L_BRS_($1B04)_($1AE8) OK
$1AEA  A5 FC     LDA $FC 
$1AEC  C9 27     CMP #$27
$1AEE  B0 0A     BCS L_BRS_($1AFA)_($1AEE) OK
$1AF0  C9 25     CMP #$25
$1AF2  B0 03     BCS L_BRS_($1AF7)_($1AF2) OK
$1AF4  4C 24 1B  JMP L_JMP_($1B24)_($1AF4) OK
//------------------------------
L_BRS_($1AF7)_($1AF2) OK
//------------------------------
$1AF7  4C 1E 1B  JMP L_JMP_($1B1E)_($1AF7) OK
//------------------------------
L_BRS_($1AFA)_($1AEE) OK
//------------------------------
$1AFA  C9 44     CMP #$44
$1AFC  B0 03     BCS L_BRS_($1B01)_($1AFC) OK
$1AFE  4C 24 1B  JMP L_JMP_($1B24)_($1AFE) OK
//------------------------------
L_BRS_($1B01)_($1AFC) OK
//------------------------------
$1B01  4C 1E 1B  JMP L_JMP_($1B1E)_($1B01) OK
//------------------------------
L_BRS_($1B04)_($1AE4) OK
L_BRS_($1B04)_($1AE8) OK
//------------------------------
$1B04  A5 FC     LDA $FC 
$1B06  C9 3A     CMP #$3A
$1B08  B0 0A     BCS L_BRS_($1B14)_($1B08) OK
$1B0A  C9 38     CMP #$38
$1B0C  B0 03     BCS L_BRS_($1B11)_($1B0C) OK
$1B0E  4C 24 1B  JMP L_JMP_($1B24)_($1B0E) OK
//------------------------------
L_BRS_($1B11)_($1B0C) OK
//------------------------------
$1B11  4C 1E 1B  JMP L_JMP_($1B1E)_($1B11) OK
//------------------------------
L_BRS_($1B14)_($1B08) OK
//------------------------------
$1B14  C9 48     CMP #$48
$1B16  B0 03     BCS L_BRS_($1B1B)_($1B16) OK
$1B18  4C 24 1B  JMP L_JMP_($1B24)_($1B18) OK
//------------------------------
L_BRS_($1B1B)_($1B16) OK
//------------------------------
$1B1B  4C 1E 1B  JMP L_JMP_($1B1E)_($1B1B) OK
//------------------------------
L_JMP_($1B1E)_($1A70) OK
L_JMP_($1B1E)_($1A86) OK
L_JMP_($1B1E)_($1AB5) OK
L_JMP_($1B1E)_($1ACB) OK
L_JMP_($1B1E)_($1AF7) OK
L_JMP_($1B1E)_($1B01) OK
L_JMP_($1B1E)_($1B11) OK
L_JMP_($1B1E)_($1B1B) OK
//------------------------------
$1B1E  38        SEC 
$1B1F  A9 FF     LDA #$FF
$1B21  4C 2D 1B  JMP L_JMP_($1B2D)_($1B21) OK
//------------------------------
L_JMP_($1B24)_($1A7F) OK
L_JMP_($1B24)_($1A9D) OK
L_JMP_($1B24)_($1AA8) OK
L_JMP_($1B24)_($1AC4) OK
L_JMP_($1B24)_($1ADA) OK
L_JMP_($1B24)_($1AF4) OK
L_JMP_($1B24)_($1AFE) OK
L_JMP_($1B24)_($1B0E) OK
L_JMP_($1B24)_($1B18) OK
//------------------------------
$1B24  18        CLC 
$1B25  A9 FF     LDA #$FF
$1B27  4C 2D 1B  JMP L_JMP_($1B2D)_($1B27) OK
//------------------------------
L_JMP_($1B2A)_($1A7C) OK
L_JMP_($1B2A)_($1A9A) OK
L_JMP_($1B2A)_($1AA5) OK
L_JMP_($1B2A)_($1AC1) OK
L_JMP_($1B2A)_($1AD7) OK
//------------------------------
$1B2A  18        CLC 
$1B2B  A9 00     LDA #$00
//------------------------------
L_JMP_($1B2D)_($1B21) OK
L_JMP_($1B2D)_($1B27) OK
//------------------------------
$1B2D  60        RTS 
//------------------------------
L_JSR_($1B2E)_($0976) OK
L_JSR_($1B2E)_($0C98) OK
//------------------------------
$1B2E  A9 60     LDA #$60
$1B30  85 4E     STA $4E 
$1B32  A9 78     LDA #$78
$1B34  18        CLC 
$1B35  65 4D     ADC $4D 
$1B37  85 4F     STA $4F 
$1B39  A0 00     LDY #$00
$1B3B  C8        INY 
$1B3C  B1 4E     LDA ($4E),Y 
$1B3E  85 08     STA $08 
$1B40  C8        INY 
$1B41  B1 4E     LDA ($4E),Y 
$1B43  85 09     STA $09 
$1B45  20 8E 1C  JSR L_JSR_($1C8E)_($1B45) OK
$1B48  90 24     BCC L_BRS_($1B6E)_($1B48) OK
$1B4A  A5 FC     LDA $FC 
$1B4C  C9 30     CMP #$30
$1B4E  B0 0F     BCS L_BRS_($1B5F)_($1B4E) OK
$1B50  A5 26     LDA $26 
$1B52  0A        ASL A 
$1B53  B0 05     BCS L_BRS_($1B5A)_($1B53) OK
$1B55  A9 01     LDA #$01
$1B57  4C F9 1B  JMP L_JMP_($1BF9)_($1B57) OK
//------------------------------
L_BRS_($1B5A)_($1B53) OK
//------------------------------
$1B5A  A9 02     LDA #$02
$1B5C  4C F9 1B  JMP L_JMP_($1BF9)_($1B5C) OK
//------------------------------
L_BRS_($1B5F)_($1B4E) OK
//------------------------------
$1B5F  A5 26     LDA $26 
$1B61  0A        ASL A 
$1B62  B0 05     BCS L_BRS_($1B69)_($1B62) OK
$1B64  A9 02     LDA #$02
$1B66  4C F9 1B  JMP L_JMP_($1BF9)_($1B66) OK
//------------------------------
L_BRS_($1B69)_($1B62) OK
//------------------------------
$1B69  A9 01     LDA #$01
$1B6B  4C F9 1B  JMP L_JMP_($1BF9)_($1B6B) OK
//------------------------------
L_BRS_($1B6E)_($1B48) OK
//------------------------------
$1B6E  A5 FB     LDA $FB 
$1B70  C5 09     CMP $09 
$1B72  D0 0B     BNE L_BRS_($1B7F)_($1B72) OK
$1B74  A5 FC     LDA $FC 
$1B76  C5 08     CMP $08 
$1B78  D0 05     BNE L_BRS_($1B7F)_($1B78) OK
$1B7A  A9 00     LDA #$00
$1B7C  4C F9 1B  JMP L_JMP_($1BF9)_($1B7C) OK
//------------------------------
L_BRS_($1B7F)_($1B72) OK
L_BRS_($1B7F)_($1B78) OK
//------------------------------
$1B7F  A5 FB     LDA $FB 
$1B81  48        PHA 
$1B82  A5 09     LDA $09 
$1B84  85 FB     STA $FB 
$1B86  20 8E 1C  JSR L_JSR_($1C8E)_($1B86) OK
$1B89  68        PLA 
$1B8A  85 FB     STA $FB 
$1B8C  90 0F     BCC L_BRS_($1B9D)_($1B8C) OK
$1B8E  C5 09     CMP $09 
$1B90  B0 07     BCS L_BRS_($1B99)_($1B90) OK
$1B92  A9 11     LDA #$11
$1B94  85 09     STA $09 
$1B96  4C 9D 1B  JMP L_JMP_($1B9D)_($1B96) OK
//------------------------------
L_BRS_($1B99)_($1B90) OK
//------------------------------
$1B99  A9 03     LDA #$03
$1B9B  85 09     STA $09 
//------------------------------
L_BRS_($1B9D)_($1B8C) OK
L_JMP_($1B9D)_($1B96) OK
//------------------------------
$1B9D  A4 FB     LDY $FB 
$1B9F  A6 FC     LDX $FC 
$1BA1  20 6D 12  JSR L_JSR_($126D)_($1BA1) OK
$1BA4  85 57     STA $57 
$1BA6  A4 09     LDY $09 
$1BA8  A6 08     LDX $08 
$1BAA  20 6D 12  JSR L_JSR_($126D)_($1BAA) OK
$1BAD  85 56     STA $56 
$1BAF  C5 57     CMP $57 
$1BB1  D0 10     BNE L_BRS_($1BC3)_($1BB1) OK
//------------------------------
L_BRS_($1BB3)_($1BE6) OK
//------------------------------
$1BB3  A5 FC     LDA $FC 
$1BB5  C5 08     CMP $08 
$1BB7  90 05     BCC L_BRS_($1BBE)_($1BB7) OK
$1BB9  A9 03     LDA #$03
$1BBB  4C F9 1B  JMP L_JMP_($1BF9)_($1BBB) OK
//------------------------------
L_BRS_($1BBE)_($1BB7) OK
//------------------------------
$1BBE  A9 04     LDA #$04
$1BC0  4C F9 1B  JMP L_JMP_($1BF9)_($1BC0) OK
//------------------------------
L_BRS_($1BC3)_($1BB1) OK
//------------------------------
$1BC3  90 10     BCC L_BRS_($1BD5)_($1BC3) OK
$1BC5  A5 57     LDA $57 
$1BC7  C9 02     CMP #$02
$1BC9  B0 05     BCS L_BRS_($1BD0)_($1BC9) OK
$1BCB  A9 0C     LDA #$0C
$1BCD  4C E2 1B  JMP L_JMP_($1BE2)_($1BCD) OK
//------------------------------
L_BRS_($1BD0)_($1BC9) OK
//------------------------------
$1BD0  A9 46     LDA #$46
$1BD2  4C E2 1B  JMP L_JMP_($1BE2)_($1BD2) OK
//------------------------------
L_BRS_($1BD5)_($1BC3) OK
//------------------------------
$1BD5  A5 57     LDA $57 
$1BD7  C9 03     CMP #$03
$1BD9  B0 05     BCS L_BRS_($1BE0)_($1BD9) OK
$1BDB  A9 13     LDA #$13
$1BDD  4C E2 1B  JMP L_JMP_($1BE2)_($1BDD) OK
//------------------------------
L_BRS_($1BE0)_($1BD9) OK
//------------------------------
$1BE0  A9 4D     LDA #$4D
//------------------------------
L_JMP_($1BE2)_($1BCD) OK
L_JMP_($1BE2)_($1BD2) OK
L_JMP_($1BE2)_($1BDD) OK
//------------------------------
$1BE2  85 08     STA $08 
$1BE4  C5 FC     CMP $FC 
$1BE6  D0 CB     BNE L_BRS_($1BB3)_($1BE6) OK
$1BE8  A5 FC     LDA $FC 
$1BEA  C9 13     CMP #$13
$1BEC  F0 09     BEQ L_BRS_($1BF7)_($1BEC) OK
$1BEE  C9 46     CMP #$46
$1BF0  F0 05     BEQ L_BRS_($1BF7)_($1BF0) OK
$1BF2  A9 02     LDA #$02
$1BF4  4C F9 1B  JMP L_JMP_($1BF9)_($1BF4) OK
//------------------------------
L_BRS_($1BF7)_($1BEC) OK
L_BRS_($1BF7)_($1BF0) OK
//------------------------------
$1BF7  A9 01     LDA #$01
//------------------------------
L_JMP_($1BF9)_($1B57) OK
L_JMP_($1BF9)_($1B5C) OK
L_JMP_($1BF9)_($1B66) OK
L_JMP_($1BF9)_($1B6B) OK
L_JMP_($1BF9)_($1B7C) OK
L_JMP_($1BF9)_($1BBB) OK
L_JMP_($1BF9)_($1BC0) OK
L_JMP_($1BF9)_($1BF4) OK
//------------------------------
$1BF9  60        RTS 
//------------------------------
L_JSR_($1BFA)_($1C5F) OK
L_JSR_($1BFA)_($1C6E) OK
L_JSR_($1BFA)_($1C7B) OK
//------------------------------
$1BFA  A9 60     LDA #$60
$1BFC  85 4E     STA $4E 
$1BFE  A9 78     LDA #$78
$1C00  85 4F     STA $4F 
$1C02  A6 57     LDX $57 
$1C04  F0 05     BEQ L_BRS_($1C0B)_($1C04) OK
//------------------------------
L_BRS_($1C06)_($1C09) OK
//------------------------------
$1C06  E6 4F     INC $4F 
$1C08  CA        DEX 
$1C09  D0 FB     BNE L_BRS_($1C06)_($1C09) OK
//------------------------------
L_BRS_($1C0B)_($1C04) OK
//------------------------------
$1C0B  A0 00     LDY #$00
$1C0D  B1 4E     LDA ($4E),Y 
$1C0F  85 0A     STA $0A 
$1C11  C8        INY 
$1C12  B1 4E     LDA ($4E),Y 
$1C14  85 0B     STA $0B 
$1C16  C8        INY 
$1C17  B1 4E     LDA ($4E),Y 
$1C19  85 0C     STA $0C 
$1C1B  A0 0F     LDY #$0F
//------------------------------
L_JSR_($1C1E)_($4B6D) BAD
//------------------------------
$1C1D  B1 4E     LDA ($4E),Y 
$1C1F  85 0D     STA $0D 
$1C21  C8        INY 
$1C22  B1 4E     LDA ($4E),Y 
$1C24  85 0E     STA $0E 
$1C26  A5 FC     LDA $FC 
$1C28  C5 0B     CMP $0B 
$1C2A  D0 2C     BNE L_BRS_($1C58)_($1C2A) OK
$1C2C  A5 FB     LDA $FB 
$1C2E  C5 0C     CMP $0C 
//------------------------------
L_JSR_($1C30)_($A5F9) OK
L_JSR_($1C30)_($E278) OK
//------------------------------
$1C30  D0 26     BNE L_BRS_($1C58)_($1C30) OK
$1C32  A5 0A     LDA $0A 
$1C34  29 07     AND #$07
$1C36  C9 05     CMP #$05
$1C38  D0 1E     BNE L_BRS_($1C58)_($1C38) OK
$1C3A  A5 57     LDA $57 
$1C3C  C9 14     CMP #$14
$1C3E  D0 09     BNE L_BRS_($1C49)_($1C3E) OK
$1C40  A5 2B     LDA $2B 
$1C42  09 10     ORA #$10
$1C44  85 2B     STA $2B 
$1C46  4C 58 1C  JMP L_JMP_($1C58)_($1C46) OK
//------------------------------
L_BRS_($1C49)_($1C3E) OK
//------------------------------
$1C49  A5 0E     LDA $0E 
$1C4B  D0 0B     BNE L_BRS_($1C58)_($1C4B) OK
$1C4D  A0 0F     LDY #$0F
$1C4F  A9 B4     LDA #$B4
$1C51  91 4E     STA ($4E),Y 
$1C53  C8        INY 
$1C54  A9 1C     LDA #$1C
$1C56  91 4E     STA ($4E),Y 
//------------------------------
L_BRS_($1C58)_($1C2A) OK
L_BRS_($1C58)_($1C30) OK
L_BRS_($1C58)_($1C38) OK
L_JMP_($1C58)_($1C46) OK
L_BRS_($1C58)_($1C4B) OK
//------------------------------
$1C58  60        RTS 
//------------------------------
L_JMP_($1C59)_($1CFC) OK
L_JMP_($1C59)_($36C4) OK
//------------------------------
$1C59  A9 FF     LDA #$FF
$1C5B  85 57     STA $57 
//------------------------------
L_BRS_($1C5D)_($1C66) OK
//------------------------------
$1C5D  E6 57     INC $57 
$1C5F  20 FA 1B  JSR L_JSR_($1BFA)_($1C5F) OK
$1C62  A5 57     LDA $57 
$1C64  C9 0A     CMP #$0A
$1C66  D0 F5     BNE L_BRS_($1C5D)_($1C66) OK
$1C68  A9 0E     LDA #$0E
$1C6A  85 57     STA $57 
//------------------------------
L_BRS_($1C6C)_($1C75) OK
//------------------------------
$1C6C  E6 57     INC $57 
$1C6E  20 FA 1B  JSR L_JSR_($1BFA)_($1C6E) OK
$1C71  A5 57     LDA $57 
$1C73  C9 11     CMP #$11
$1C75  D0 F5     BNE L_BRS_($1C6C)_($1C75) OK
$1C77  A9 14     LDA #$14
$1C79  85 57     STA $57 
$1C7B  20 FA 1B  JSR L_JSR_($1BFA)_($1C7B) OK
$1C7E  A5 26     LDA $26 
$1C80  29 F8     AND #$F8
$1C82  18        CLC 
$1C83  69 05     ADC #$05
$1C85  85 26     STA $26 
$1C87  20 2E 32  JSR L_JSR_($322E)_($1C87) OK
$1C8A  4C 32 1D  JMP L_JMP_($1D32)_($1C8A) OK
$1C8D  60        RTS 
//------------------------------
L_JSR_($1C8E)_($0C4C) OK
L_JSR_($1C8E)_($0CB9) OK
L_JSR_($1C8E)_($1468) OK
L_JSR_($1C8E)_($16D0) OK
L_JSR_($1C8E)_($1B45) OK
L_JSR_($1C8E)_($1B86) OK
L_JSR_($1C8E)_($2718) OK
L_JSR_($1C8E)_($2878) OK
L_JSR_($1C8E)_($2CB0) OK
L_JSR_($1C8E)_($34BB) OK
L_JSR_($1C8E)_($3511) OK
L_JSR_($1C8E)_($3566) OK
L_JSR_($1C8E)_($35AC) OK
L_JSR_($1C8E)_($369C) OK
//------------------------------
$1C8E  A5 FB     LDA $FB 
$1C90  C9 03     CMP #$03
$1C92  D0 06     BNE L_BRS_($1C9A)_($1C92) OK
$1C94  18        CLC 
$1C95  A9 02     LDA #$02
$1C97  4C B1 1C  JMP L_JMP_($1CB1)_($1C97) OK
//------------------------------
L_BRS_($1C9A)_($1C92) OK
//------------------------------
$1C9A  C9 0A     CMP #$0A
$1C9C  D0 06     BNE L_BRS_($1CA4)_($1C9C) OK
$1C9E  18        CLC 
$1C9F  A9 01     LDA #$01
$1CA1  4C B1 1C  JMP L_JMP_($1CB1)_($1CA1) OK
//------------------------------
L_BRS_($1CA4)_($1C9C) OK
//------------------------------
$1CA4  C9 11     CMP #$11
$1CA6  D0 06     BNE L_BRS_($1CAE)_($1CA6) OK
$1CA8  18        CLC 
$1CA9  A9 00     LDA #$00
$1CAB  4C B1 1C  JMP L_JMP_($1CB1)_($1CAB) OK
//------------------------------
L_BRS_($1CAE)_($1CA6) OK
//------------------------------
$1CAE  38        SEC 
$1CAF  A9 FF     LDA #$FF
//------------------------------
L_JMP_($1CB1)_($1C97) OK
L_JMP_($1CB1)_($1CA1) OK
L_JMP_($1CB1)_($1CAB) OK
//------------------------------
$1CB1  85 12     STA $12 
$1CB3  60        RTS 
//------------------------------
$1CB4  A9 04     LDA #$04
$1CB6  85 B5     STA $B5 
$1CB8  A9 1C     LDA #$1C
$1CBA  85 B1     STA $B1 
$1CBC  A9 CB     LDA #$CB
$1CBE  85 B0     STA $B0 
$1CC0  20 2E 32  JSR L_JSR_($322E)_($1CC0) OK
$1CC3  E6 26     INC $26 
$1CC5  20 2E 32  JSR L_JSR_($322E)_($1CC5) OK
$1CC8  4C 15 1D  JMP L_JMP_($1D15)_($1CC8) OK
$1CCB  C6 B5     DEC $B5 
$1CCD  D0 46     BNE L_BRS_($1D15)_($1CCD) OK
$1CCF  A9 1C     LDA #$1C
$1CD1  85 B1     STA $B1 
$1CD3  A9 EC     LDA #$EC
$1CD5  85 B0     STA $B0 
$1CD7  20 2E 32  JSR L_JSR_($322E)_($1CD7) OK
$1CDA  A5 26     LDA $26 
$1CDC  29 F8     AND #$F8
$1CDE  85 26     STA $26 
$1CE0  C9 10     CMP #$10
$1CE2  F0 02     BEQ L_BRS_($1CE6)_($1CE2) OK
$1CE4  C6 FC     DEC $FC 
//------------------------------
L_BRS_($1CE6)_($1CE2) OK
//------------------------------
$1CE6  20 2E 32  JSR L_JSR_($322E)_($1CE6) OK
$1CE9  4C 15 1D  JMP L_JMP_($1D15)_($1CE9) OK
//------------------------------
L_JMP_($1CEC)_($1D24) OK
//------------------------------
$1CEC  20 2E 32  JSR L_JSR_($322E)_($1CEC) OK
$1CEF  A5 26     LDA $26 
$1CF1  4A        LSR A 
$1CF2  90 03     BCC L_BRS_($1CF7)_($1CF2) OK
$1CF4  4C 98 13  JMP L_JMP_($1398)_($1CF4) OK
//------------------------------
L_BRS_($1CF7)_($1CF2) OK
//------------------------------
$1CF7  20 51 1A  JSR L_JSR_($1A51)_($1CF7) OK
$1CFA  D0 03     BNE L_BRS_($1CFF)_($1CFA) OK
$1CFC  4C 59 1C  JMP L_JMP_($1C59)_($1CFC) OK
//------------------------------
L_BRS_($1CFF)_($1CFA) OK
//------------------------------
$1CFF  90 0C     BCC L_BRS_($1D0D)_($1CFF) OK
$1D01  A5 26     LDA $26 
$1D03  49 80     EOR #$80
$1D05  85 26     STA $26 
$1D07  20 2E 32  JSR L_JSR_($322E)_($1D07) OK
$1D0A  4C 15 1D  JMP L_JMP_($1D15)_($1D0A) OK
//------------------------------
L_BRS_($1D0D)_($1CFF) OK
//------------------------------
$1D0D  E6 26     INC $26 
$1D0F  20 2E 32  JSR L_JSR_($322E)_($1D0F) OK
$1D12  4C 15 1D  JMP L_JMP_($1D15)_($1D12) OK
//------------------------------
L_JMP_($1D15)_($1CC8) OK
L_BRS_($1D15)_($1CCD) OK
L_JMP_($1D15)_($1CE9) OK
L_JMP_($1D15)_($1D0A) OK
L_JMP_($1D15)_($1D12) OK
//------------------------------
$1D15  60        RTS 
//------------------------------
$1D16  A9 1C     LDA #$1C
$1D18  85 B1     STA $B1 
$1D1A  A9 EC     LDA #$EC
$1D1C  85 B0     STA $B0 
$1D1E  A9 00     LDA #$00
$1D20  85 2A     STA $2A 
$1D22  85 29     STA $29 
$1D24  4C EC 1C  JMP L_JMP_($1CEC)_($1D24) OK
$1D27  60        RTS 
//------------------------------
L_JMP_($1D28)_($0C37) OK
L_JMP_($1D28)_($1130) OK
L_JMP_($1D28)_($118A) OK
L_JMP_($1D28)_($137F) OK
L_JMP_($1D28)_($138D) OK
L_JMP_($1D28)_($1402) OK
L_JMP_($1D28)_($1712) OK
L_JMP_($1D28)_($1F25) OK
L_JMP_($1D28)_($2399) OK
L_JMP_($1D28)_($23A4) OK
L_JMP_($1D28)_($2462) OK
L_JMP_($1D28)_($274B) OK
//------------------------------
$1D28  A9 00     LDA #$00
$1D2A  85 AB     STA $AB 
$1D2C  60        RTS 
//------------------------------
L_JMP_($1D2D)_($0EBE) OK
L_JMP_($1D2D)_($0EC8) OK
L_JMP_($1D2D)_($1303) OK
L_JMP_($1D2D)_($1A2D) OK
L_JMP_($1D2D)_($2793) OK
L_JMP_($1D2D)_($27CB) OK
L_JMP_($1D2D)_($28B8) OK
L_JMP_($1D2D)_($28FE) OK
L_JMP_($1D2D)_($2AA6) OK
L_JMP_($1D2D)_($2B09) OK
L_JMP_($1D2D)_($2B1D) OK
//------------------------------
$1D2D  A9 00     LDA #$00
$1D2F  85 2A     STA $2A 
$1D31  60        RTS 
//------------------------------
L_JMP_($1D32)_($1C8A) OK
L_JMP_($1D32)_($2A47) OK
//------------------------------
$1D32  A9 00     LDA #$00
$1D34  85 B1     STA $B1 
$1D36  60        RTS 
//------------------------------
L_JMP_($1D37)_($103E) OK
L_JSR_($1D37)_($181B) OK
L_JSR_($1D37)_($1E3D) OK
L_JSR_($1D37)_($2C21) OK
L_JSR_($1D37)_($2C4E) OK
L_JSR_($1D37)_($2C5F) OK
//------------------------------
$1D37  18        CLC 
$1D38  65 7C     ADC $7C 
$1D3A  90 02     BCC L_BRS_($1D3E)_($1D3A) OK
$1D3C  E6 7D     INC $7D 
//------------------------------
L_BRS_($1D3E)_($1D3A) OK
//------------------------------
$1D3E  85 7C     STA $7C 
$1D40  A9 7C     LDA #$7C
$1D42  85 4E     STA $4E 
$1D44  A9 00     LDA #$00
$1D46  4C 20 26  JMP L_JMP_($2620)_($1D46) OK
$1D49  60        RTS 
//------------------------------
L_JSR_($1D4A)_($1E45) OK
L_JSR_($1D4A)_($2790) OK
//------------------------------
$1D4A  85 57     STA $57 
$1D4C  A5 7F     LDA $7F 
$1D4E  C9 04     CMP #$04
$1D50  B0 50     BCS L_BRS_($1DA2)_($1D50) OK
$1D52  C9 03     CMP #$03
$1D54  D0 06     BNE L_BRS_($1D5C)_($1D54) OK
$1D56  A5 7E     LDA $7E 
$1D58  C9 E8     CMP #$E8
$1D5A  B0 46     BCS L_BRS_($1DA2)_($1D5A) OK
//------------------------------
L_BRS_($1D5C)_($1D54) OK
//------------------------------
$1D5C  A5 7E     LDA $7E 
$1D5E  18        CLC 
$1D5F  65 57     ADC $57 
$1D61  90 02     BCC L_BRS_($1D65)_($1D61) OK
$1D63  E6 7F     INC $7F 
//------------------------------
L_BRS_($1D65)_($1D61) OK
//------------------------------
$1D65  85 7E     STA $7E 
$1D67  A5 7F     LDA $7F 
$1D69  C9 03     CMP #$03
$1D6B  90 40     BCC L_BRS_($1DAD)_($1D6B) OK
$1D6D  D0 06     BNE L_BRS_($1D75)_($1D6D) OK
$1D6F  A5 7E     LDA $7E 
$1D71  C9 E8     CMP #$E8
$1D73  90 38     BCC L_BRS_($1DAD)_($1D73) OK
//------------------------------
L_BRS_($1D75)_($1D6D) OK
//------------------------------
$1D75  A9 43     LDA #$43
$1D77  8D 78 83  STA $8378 
$1D7A  A9 A2     LDA #$A2
$1D7C  8D 77 83  STA $8377 
$1D7F  AD 7A 83  LDA $837A 
$1D82  09 80     ORA #$80
$1D84  8D 7A 83  STA $837A 
$1D87  A5 60     LDA $60 
$1D89  C9 0B     CMP #$0B
$1D8B  D0 0E     BNE L_BRS_($1D9B)_($1D8B) OK
$1D8D  A9 43     LDA #$43
$1D8F  85 3E     STA $3E 
$1D91  A9 A2     LDA #$A2
$1D93  85 3D     STA $3D 
$1D95  A5 3F     LDA $3F 
$1D97  09 80     ORA #$80
$1D99  85 3F     STA $3F 
//------------------------------
L_BRS_($1D9B)_($1D8B) OK
//------------------------------
$1D9B  A9 FF     LDA #$FF
$1D9D  85 40     STA $40 
$1D9F  4C AD 1D  JMP L_JMP_($1DAD)_($1D9F) OK
//------------------------------
L_BRS_($1DA2)_($1D50) OK
L_BRS_($1DA2)_($1D5A) OK
//------------------------------
$1DA2  A5 7E     LDA $7E 
$1DA4  18        CLC 
$1DA5  65 57     ADC $57 
$1DA7  90 02     BCC L_BRS_($1DAB)_($1DA7) OK
$1DA9  E6 7F     INC $7F 
//------------------------------
L_BRS_($1DAB)_($1DA7) OK
//------------------------------
$1DAB  85 7E     STA $7E 
//------------------------------
L_BRS_($1DAD)_($1D6B) OK
L_BRS_($1DAD)_($1D73) OK
L_JMP_($1DAD)_($1D9F) OK
//------------------------------
$1DAD  A9 7E     LDA #$7E
$1DAF  85 4E     STA $4E 
$1DB1  A9 01     LDA #$01
$1DB3  4C 20 26  JMP L_JMP_($2620)_($1DB3) OK
$1DB6  60        RTS 
//------------------------------
L_JSR_($1DB7)_($0BA5) OK
L_JMP_($1DB7)_($0FB6) OK
L_JSR_($1DB7)_($15A9) OK
L_JSR_($1DB7)_($1989) OK
L_JMP_($1DB7)_($2563) OK
L_JMP_($1DB7)_($256F) OK
//------------------------------
$1DB7  AD 15 D0  LDA $D015                          // Sprite display Enable
$1DBA  85 F6     STA $F6 
$1DBC  F0 03     BEQ L_BRS_($1DC1)_($1DBC) OK
$1DBE  20 AC 38  JSR L_JSR_($38AC)_($1DBE) OK	; Restore sprites
//------------------------------
L_BRS_($1DC1)_($1DBC) OK
//------------------------------
$1DC1  A9 46     LDA #$46
$1DC3  85 87     STA $87 
$1DC5  A9 C0     LDA #$C0
$1DC7  85 86     STA $86 
$1DC9  A9 46     LDA #$46
$1DCB  85 89     STA $89 
$1DCD  A9 D0     LDA #$D0
$1DCF  85 88     STA $88 
$1DD1  A5 72     LDA $72 
$1DD3  C9 14     CMP #$14
$1DD5  D0 05     BNE L_BRS_($1DDC)_($1DD5) OK
$1DD7  A9 03     LDA #$03
$1DD9  4C E7 1D  JMP L_JMP_($1DE7)_($1DD9) OK
//------------------------------
L_BRS_($1DDC)_($1DD5) OK
//------------------------------
$1DDC  C9 10     CMP #$10
$1DDE  D0 05     BNE L_BRS_($1DE5)_($1DDE) OK
$1DE0  A9 05     LDA #$05
$1DE2  4C E7 1D  JMP L_JMP_($1DE7)_($1DE2) OK
//------------------------------
L_BRS_($1DE5)_($1DDE) OK
//------------------------------
$1DE5  A9 07     LDA #$07
//------------------------------
L_JMP_($1DE7)_($1DD9) OK
L_JMP_($1DE7)_($1DE2) OK
//------------------------------
$1DE7  85 84     STA $84 
$1DE9  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$1DEC  29 0F     AND #$0F
$1DEE  18        CLC 
$1DEF  69 03     ADC #$03
$1DF1  85 57     STA $57 
$1DF3  0A        ASL A 
$1DF4  0A        ASL A 
$1DF5  18        CLC 
$1DF6  65 57     ADC $57 
$1DF8  85 85     STA $85 
$1DFA  A5 72     LDA $72 
$1DFC  C9 14     CMP #$14
$1DFE  D0 05     BNE L_BRS_($1E05)_($1DFE) OK
//------------------------------
L_JSR_($1E00)_($F7FF) OK
//------------------------------
$1E00  A9 10     LDA #$10
$1E02  4C 19 1E  JMP L_JMP_($1E19)_($1E02) OK
//------------------------------
L_BRS_($1E05)_($1DFE) OK
//------------------------------
$1E05  C9 11     CMP #$11
$1E07  D0 05     BNE L_BRS_($1E0E)_($1E07) OK
$1E09  A9 13     LDA #$13
$1E0B  4C 19 1E  JMP L_JMP_($1E19)_($1E0B) OK
//------------------------------
L_BRS_($1E0E)_($1E07) OK
//------------------------------
$1E0E  C9 10     CMP #$10
$1E10  D0 05     BNE L_BRS_($1E17)_($1E10) OK
$1E12  A9 11     LDA #$11
$1E14  4C 19 1E  JMP L_JMP_($1E19)_($1E14) OK
//------------------------------
L_BRS_($1E17)_($1E10) OK
//------------------------------
$1E17  A9 12     LDA #$12
//------------------------------
L_JMP_($1E19)_($1E02) OK
L_JMP_($1E19)_($1E0B) OK
L_JMP_($1E19)_($1E14) OK
//------------------------------
$1E19  85 D0     STA $D0 
$1E1B  A0 00     LDY #$00
$1E1D  91 88     STA ($88),Y 
$1E1F  A5 85     LDA $85 
$1E21  85 A3     STA $A3 
$1E23  20 1C 22  JSR L_JSR_($221C)_($1E23) OK
$1E26  A0 00     LDY #$00
$1E28  A5 8D     LDA $8D 
$1E2A  91 86     STA ($86),Y 
$1E2C  C8        INY 
$1E2D  A5 8E     LDA $8E 
$1E2F  91 86     STA ($86),Y 
$1E31  A5 72     LDA $72 
$1E33  C9 10     CMP #$10
$1E35  F0 11     BEQ L_BRS_($1E48)_($1E35) OK
$1E37  C9 14     CMP #$14
$1E39  F0 08     BEQ L_BRS_($1E43)_($1E39) OK
$1E3B  A5 85     LDA $85 
$1E3D  20 37 1D  JSR L_JSR_($1D37)_($1E3D) OK
$1E40  4C 48 1E  JMP L_JMP_($1E48)_($1E40) OK
//------------------------------
L_BRS_($1E43)_($1E39) OK
//------------------------------
$1E43  A5 85     LDA $85 
$1E45  20 4A 1D  JSR L_JSR_($1D4A)_($1E45) OK
//------------------------------
L_BRS_($1E48)_($1E35) OK
L_JMP_($1E48)_($1E40) OK
//------------------------------
$1E48  A9 00     LDA #$00							; sound effect for speech rectangle (lines)
$1E4A  8D 05 D4  STA $D405                          // Voice 1: Attack / Decay Cycle Control ; Attack = 0; Decay = 0
$1E4D  8D 00 D4  STA $D400                          // Voice 1: Frequency Control - Low-Byte
$1E50  A9 F8     LDA #$F8
$1E52  8D 06 D4  STA $D406                          // Voice 1: Sustain / Release Cycle Control ; Sustain = F, release = 8 (300ms)
$1E55  A9 31     LDA #$31
$1E57  8D 01 D4  STA $D401                          // Voice 1: Frequency Control - High-Byte ; sound frequency = 736,652374267578125 Hz
$1E5A  A9 21     LDA #$21
$1E5C  8D 04 D4  STA $D404                          // Voice 1: Control Register ; Select Sawtooth Waveform, Gate Bit: 1 = Start Att,Dec,Sus
$1E5F  20 43 20  JSR L_JSR_($2043)_($1E5F) OK
$1E62  A9 49     LDA #$49
$1E64  85 87     STA $87 
$1E66  85 89     STA $89 
$1E68  A9 80     LDA #$80
$1E6A  85 86     STA $86 
$1E6C  A9 90     LDA #$90
$1E6E  85 88     STA $88 
$1E70  A5 D8     LDA $D8 
$1E72  29 0C     AND #$0C
$1E74  0A        ASL A 
$1E75  0A        ASL A 
$1E76  0A        ASL A 
$1E77  0A        ASL A 
$1E78  0A        ASL A 
$1E79  90 08     BCC L_BRS_($1E83)_($1E79) OK
$1E7B  E6 87     INC $87 
$1E7D  E6 87     INC $87 
$1E7F  E6 89     INC $89 
$1E81  E6 89     INC $89 
//------------------------------
L_BRS_($1E83)_($1E79) OK
//------------------------------
$1E83  0A        ASL A 
$1E84  90 04     BCC L_BRS_($1E8A)_($1E84) OK
$1E86  E6 87     INC $87 
$1E88  E6 89     INC $89 
//------------------------------
L_BRS_($1E8A)_($1E84) OK
//------------------------------
$1E8A  A5 D8     LDA $D8 
$1E8C  4A        LSR A 
$1E8D  4A        LSR A 
$1E8E  90 0C     BCC L_BRS_($1E9C)_($1E8E) OK
$1E90  A9 40     LDA #$40
$1E92  18        CLC 
$1E93  65 86     ADC $86 
$1E95  85 86     STA $86 
$1E97  18        CLC 
$1E98  69 10     ADC #$10
$1E9A  85 88     STA $88 
//------------------------------
L_BRS_($1E9C)_($1E8E) OK
//------------------------------
$1E9C  A5 D8     LDA $D8 
$1E9E  4A        LSR A 
$1E9F  90 0C     BCC L_BRS_($1EAD)_($1E9F) OK
$1EA1  A9 20     LDA #$20
$1EA3  18        CLC 
$1EA4  65 86     ADC $86 
$1EA6  85 86     STA $86 
$1EA8  18        CLC 
$1EA9  69 10     ADC #$10
$1EAB  85 88     STA $88 
//------------------------------
L_BRS_($1EAD)_($1E9F) OK
//------------------------------
$1EAD  A9 29     LDA #$29
$1EAF  8D 01 D4  STA $D401                          // Voice 1: Frequency Control - High-Byte ; lobyte is likely 0, sound frequency = 616,382598876953125 Hz
$1EB2  20 43 20  JSR L_JSR_($2043)_($1EB2) OK
$1EB5  A9 20     LDA #$20
$1EB7  8D 04 D4  STA $D404                          // Voice 1: Control Register ; Select Sawtooth Waveform, Gate Bit: 0 = Start Release
$1EBA  A5 F6     LDA $F6 
$1EBC  F0 03     BEQ L_BRS_($1EC1)_($1EBC) OK
$1EBE  20 EF 38  JSR L_JSR_($38EF)_($1EBE) OK
//------------------------------
L_BRS_($1EC1)_($1EBC) OK
//------------------------------
$1EC1  60        RTS 
//------------------------------
L_JSR_($1EC2)_($0C45) OK
L_JSR_($1EC2)_($14C9) OK
//------------------------------
$1EC2  A5 2B     LDA $2B 
$1EC4  AE 61 8C  LDX $8C61 
$1EC7  AC 62 8C  LDY $8C62 
$1ECA  29 02     AND #$02
$1ECC  F0 14     BEQ L_BRS_($1EE2)_($1ECC) OK
$1ECE  C0 03     CPY #$03
$1ED0  B0 05     BCS L_BRS_($1ED7)_($1ED0) OK
$1ED2  A0 03     LDY #$03
$1ED4  4C E2 1E  JMP L_JMP_($1EE2)_($1ED4) OK
//------------------------------
L_BRS_($1ED7)_($1ED0) OK
//------------------------------
$1ED7  C0 0A     CPY #$0A
$1ED9  B0 05     BCS L_BRS_($1EE0)_($1ED9) OK
$1EDB  A0 0A     LDY #$0A
$1EDD  4C E2 1E  JMP L_JMP_($1EE2)_($1EDD) OK
//------------------------------
L_BRS_($1EE0)_($1ED9) OK
//------------------------------
$1EE0  A0 11     LDY #$11
//------------------------------
L_BRS_($1EE2)_($1ECC) OK
L_JMP_($1EE2)_($1ED4) OK
L_JMP_($1EE2)_($1EDD) OK
//------------------------------
$1EE2  60        RTS 
//------------------------------
L_JSR_($1EE3)_($0A73) OK
L_JSR_($1EE3)_($0ACC) OK
L_JSR_($1EE3)_($0B6A) OK
//------------------------------
$1EE3  8A        TXA 
$1EE4  48        PHA 
$1EE5  98        TYA 
$1EE6  48        PHA 
$1EE7  20 BF 33  JSR L_JSR_($33BF)_($1EE7) OK
$1EEA  A5 60     LDA $60 
$1EEC  85 57     STA $57 
$1EEE  A9 11     LDA #$11
$1EF0  85 60     STA $60 
$1EF2  20 79 32  JSR L_JSR_($3279)_($1EF2) OK
$1EF5  68        PLA 
$1EF6  85 AD     STA $AD 
$1EF8  68        PLA 
$1EF9  85 AC     STA $AC 
$1EFB  20 BF 33  JSR L_JSR_($33BF)_($1EFB) OK
$1EFE  A5 57     LDA $57 
$1F00  85 60     STA $60 
$1F02  20 79 32  JSR L_JSR_($3279)_($1F02) OK
//------------------------------
L_JSR_($1F05)_($0B34) OK
//------------------------------
$1F05  A9 03     LDA #$03
$1F07  20 B6 31  JSR L_JSR_($31B6)_($1F07) OK
$1F0A  68        PLA 
$1F0B  85 29     STA $29 
$1F0D  68        PLA 
$1F0E  85 2A     STA $2A 
$1F10  E6 29     INC $29 
$1F12  D0 02     BNE L_BRS_($1F16)_($1F12) OK
$1F14  E6 2A     INC $2A 
//------------------------------
L_BRS_($1F16)_($1F12) OK
//------------------------------
$1F16  A9 1F     LDA #$1F
$1F18  85 AB     STA $AB 
$1F1A  A9 1E     LDA #$1E
$1F1C  85 AA     STA $AA 
$1F1E  A9 03     LDA #$03
$1F20  20 D2 31  JSR L_JSR_($31D2)_($1F20) OK
$1F23  B0 03     BCS L_BRS_($1F28)_($1F23) OK
$1F25  4C 28 1D  JMP L_JMP_($1D28)_($1F25) OK
//------------------------------
L_BRS_($1F28)_($1F23) OK
//------------------------------
$1F28  60        RTS 
//------------------------------
L_JSR_($1F29)_($1FCD) OK
//------------------------------
$1F29  A9 03     LDA #$03
$1F2B  85 84     STA $84 
$1F2D  A9 46     LDA #$46
$1F2F  85 87     STA $87 
$1F31  A9 40     LDA #$40
$1F33  85 86     STA $86 
$1F35  A5 60     LDA $60 
$1F37  4C 95 29  JMP L_JMP_($2995)_($1F37) OK
$1F3A  AA        TAX 
$1F3B  B5 90     LDA $90,X 
$1F3D  A0 00     LDY #$00
$1F3F  91 86     STA ($86),Y 
$1F41  A9 46     LDA #$46
$1F43  85 89     STA $89 
$1F45  A9 42     LDA #$42
$1F47  85 88     STA $88 
$1F49  4C 43 20  JMP L_JMP_($2043)_($1F49) OK
$1F4C  60        RTS 
//------------------------------
$1F4D  A9 03     LDA #$03
$1F4F  20 D2 31  JSR L_JSR_($31D2)_($1F4F) OK
$1F52  90 1A     BCC L_BRS_($1F6E)_($1F52) OK
$1F54  A5 3F     LDA $3F 
$1F56  29 80     AND #$80
$1F58  09 44     ORA #$44
$1F5A  85 3F     STA $3F 
$1F5C  20 77 1F  JSR L_JSR_($1F77)_($1F5C) OK	; Jump to embedded address 2387
$1F5F            .byte $87,$23
$1F61  A9 03     LDA #$03
$1F63  20 C4 31  JSR L_JSR_($31C4)_($1F63) OK
$1F66  A9 4D     LDA #$4D
$1F68  85 29     STA $29 
$1F6A  A9 1F     LDA #$1F
$1F6C  85 2A     STA $2A 
//------------------------------
L_BRS_($1F6E)_($1F52) OK
//------------------------------
$1F6E  A5 3F     LDA $3F 
$1F70  29 80     AND #$80
$1F72  09 48     ORA #$48
$1F74  85 3F     STA $3F 
$1F76  60        RTS 
//------------------------------
L_JSR_($1F77)_($0A0E) OK
L_JSR_($1F77)_($0A1C) OK
L_JSR_($1F77)_($0A28) OK
L_JSR_($1F77)_($0A42) OK
L_JSR_($1F77)_($0A4F) OK
L_JSR_($1F77)_($0AD6) OK
L_JSR_($1F77)_($0AE4) OK
L_JSR_($1F77)_($0AF0) OK
L_JSR_($1F77)_($0B04) OK
L_JSR_($1F77)_($0B14) OK
L_JSR_($1F77)_($0B2F) OK
L_JSR_($1F77)_($0B75) OK
L_JSR_($1F77)_($0B8C) OK
L_JSR_($1F77)_($0E50) OK
L_JSR_($1F77)_($1F5C) OK
L_JSR_($1F77)_($276C) OK
L_JSR_($1F77)_($2785) OK
L_JSR_($1F77)_($28B3) OK
L_JSR_($1F77)_($28D8) OK
L_JSR_($1F77)_($28EF) OK
L_JSR_($1F77)_($2AA1) OK
//------------------------------
$1F77  68        PLA 			; Jump to embedded address
$1F78  85 4E     STA $4E 
$1F7A  68        PLA 
$1F7B  85 4F     STA $4F 
$1F7D  A0 01     LDY #$01
$1F7F  B1 4E     LDA ($4E),Y 
$1F81  85 AA     STA $AA 
$1F83  E6 4E     INC $4E 
$1F85  D0 02     BNE L_BRS_($1F89)_($1F85) OK
$1F87  E6 4F     INC $4F 
//------------------------------
L_BRS_($1F89)_($1F85) OK
//------------------------------
$1F89  B1 4E     LDA ($4E),Y 
$1F8B  85 AB     STA $AB 
$1F8D  A5 4E     LDA $4E 
$1F8F  18        CLC 
$1F90  69 02     ADC #$02
$1F92  90 02     BCC L_BRS_($1F96)_($1F92) OK
$1F94  E6 4F     INC $4F 
//------------------------------
L_BRS_($1F96)_($1F92) OK
//------------------------------
$1F96  85 29     STA $29 
$1F98  A5 4F     LDA $4F 
$1F9A  85 2A     STA $2A 
$1F9C  6C AA 00  JMP ($00AA) 
$1F9F  60        RTS 
//------------------------------
$1FA0  A5 60     LDA $60 
$1FA2  C9 0E     CMP #$0E
$1FA4  D0 2A     BNE L_BRS_($1FD0)_($1FA4) OK
$1FA6  A5 46     LDA $46 
$1FA8  C9 03     CMP #$03
$1FAA  B0 24     BCS L_BRS_($1FD0)_($1FAA) OK
$1FAC  20 68 14  JSR L_JSR_($1468)_($1FAC) OK
$1FAF  A5 1A     LDA $1A 
$1FB1  C9 14     CMP #$14
$1FB3  D0 1B     BNE L_BRS_($1FD0)_($1FB3) OK
$1FB5  A5 E2     LDA $E2 
$1FB7  C5 94     CMP $94 
$1FB9  D0 15     BNE L_BRS_($1FD0)_($1FB9) OK
$1FBB  A5 E1     LDA $E1 
$1FBD  C5 95     CMP $95 
$1FBF  D0 0F     BNE L_BRS_($1FD0)_($1FBF) OK
$1FC1  A5 E0     LDA $E0 
$1FC3  C5 96     CMP $96 
$1FC5  D0 09     BNE L_BRS_($1FD0)_($1FC5) OK
$1FC7  A5 DF     LDA $DF 
$1FC9  C5 97     CMP $97 
$1FCB  D0 03     BNE L_BRS_($1FD0)_($1FCB) OK
$1FCD  20 29 1F  JSR L_JSR_($1F29)_($1FCD) OK
//------------------------------
L_BRS_($1FD0)_($1FA4) OK
L_BRS_($1FD0)_($1FAA) OK
L_BRS_($1FD0)_($1FB3) OK
L_BRS_($1FD0)_($1FB9) OK
L_BRS_($1FD0)_($1FBF) OK
L_BRS_($1FD0)_($1FC5) OK
L_BRS_($1FD0)_($1FCB) OK
//------------------------------
$1FD0  A9 00     LDA #$00
$1FD2  85 2A     STA $2A 
$1FD4  A9 5B     LDA #$5B
$1FD6  85 AD     STA $AD 
$1FD8  A5 60     LDA $60 
$1FDA  C9 0C     CMP #$0C
$1FDC  D0 05     BNE L_BRS_($1FE3)_($1FDC) OK
$1FDE  A9 59     LDA #$59
$1FE0  4C F7 1F  JMP L_JMP_($1FF7)_($1FE0) OK
//------------------------------
L_BRS_($1FE3)_($1FDC) OK
//------------------------------
$1FE3  C9 0D     CMP #$0D
$1FE5  D0 05     BNE L_BRS_($1FEC)_($1FE5) OK
$1FE7  A9 7B     LDA #$7B
$1FE9  4C F7 1F  JMP L_JMP_($1FF7)_($1FE9) OK
//------------------------------
L_BRS_($1FEC)_($1FE5) OK
//------------------------------
$1FEC  C9 0E     CMP #$0E
$1FEE  D0 05     BNE L_BRS_($1FF5)_($1FEE) OK
$1FF0  A9 97     LDA #$97
$1FF2  4C F7 1F  JMP L_JMP_($1FF7)_($1FF2) OK
//------------------------------
L_BRS_($1FF5)_($1FEE) OK
//------------------------------
$1FF5  A9 C1     LDA #$C1
//------------------------------
L_JMP_($1FF7)_($1FE0) OK
L_JMP_($1FF7)_($1FE9) OK
L_JMP_($1FF7)_($1FF2) OK
//------------------------------
$1FF7  85 AC     STA $AC 
$1FF9  A9 87     LDA #$87
$1FFB  85 AA     STA $AA 
$1FFD  A9 23     LDA #$23
//------------------------------
L_JSR_($2000)_($FFBB) BAD
//------------------------------
$1FFF  85 AB     STA $AB 
$2001  6C AA 00  JMP ($00AA) 
$2004  60        RTS 
//------------------------------
L_JSR_($2005)_($20B6) OK
L_JSR_($2005)_($20CB) OK
L_JSR_($2005)_($2587) OK
L_JSR_($2005)_($259F) OK
L_JSR_($2005)_($25F4) OK
L_JSR_($2005)_($2612) OK
L_JSR_($2005)_($263F) OK
L_JSR_($2005)_($2C74) OK
L_JSR_($2005)_($2C85) OK
L_JSR_($2005)_($BFF5) OK
L_JSR_($2005)_($FC11) OK
//------------------------------
$2005  20 2A 21  JSR L_JSR_($212A)_($2005) OK
$2008  A0 00     LDY #$00
//------------------------------
L_JMP_($200A)_($2034) OK
L_JMP_($200A)_($203F) OK
//------------------------------
$200A  B1 D6     LDA ($D6),Y 
$200C  85 57     STA $57 
$200E  F0 32     BEQ L_BRS_($2042)_($200E) OK
$2010  C9 20     CMP #$20
//------------------------------
L_JSR_($2012)_($5E09) OK
//------------------------------
$2012  B0 23     BCS L_BRS_($2037)_($2012) OK
//------------------------------
L_JSR_($2014)_($5ED5) OK
//------------------------------
$2014  A9 47     LDA #$47
$2016  85 D7     STA $D7 
$2018  A9 80     LDA #$80
$201A  85 D6     STA $D6 
$201C  A5 57     LDA $57 
$201E  29 EF     AND #$EF
$2020  0A        ASL A 
//------------------------------
L_JSR_($2022)_($9210) BAD
L_JSR_($2022)_($CFB7) BAD
//------------------------------
$2021  85 57     STA $57 
$2023  0A        ASL A 
$2024  85 56     STA $56 
$2026  0A        ASL A 
$2027  18        CLC 
$2028  65 56     ADC $56 
$202A  18        CLC 
//------------------------------
L_JSR_($202B)_($9260) OK
L_JSR_($202B)_($D003) OK
//------------------------------
$202B  65 57     ADC $57 
//------------------------------
L_JSR_($202D)_($47FA) OK
L_JSR_($202D)_($5B88) OK
//------------------------------
$202D  18        CLC 
//------------------------------
L_JSR_($202E)_($43E1) OK
L_JSR_($202E)_($4810) OK
L_JMP_($202E)_($5C40) OK
//------------------------------
$202E  65 D6     ADC $D6 
$2030  85 D6     STA $D6 
$2032  A0 00     LDY #$00
$2034  4C 0A 20  JMP L_JMP_($200A)_($2034) OK
//------------------------------
L_BRS_($2037)_($2012) OK
//------------------------------
$2037  C8        INY 
$2038  98        TYA 
$2039  48        PHA 
$203A  20 56 21  JSR L_JSR_($2156)_($203A) OK
$203D  68        PLA 
$203E  A8        TAY 
//------------------------------
L_JSR_($2041)_($43EA) BAD
L_JSR_($2041)_($4692) BAD
L_JSR_($2041)_($5C4D) BAD
L_JSR_($2041)_($5DF2) BAD
//------------------------------
$203F  4C 0A 20  JMP L_JMP_($200A)_($203F) OK
//------------------------------
L_BRS_($2042)_($200E) OK
//------------------------------
$2042  60        RTS 
//------------------------------
L_JSR_($2043)_($1E5F) OK
L_JSR_($2043)_($1EB2) OK
L_JMP_($2043)_($1F49) OK
L_JSR_($2043)_($29BD) OK
//------------------------------
$2043  A5 FC     LDA $FC 
//------------------------------
L_JMP_($2045)_($5AAF) OK
L_JMP_($2045)_($5AC2) OK
L_JMP_($2045)_($5AF1) OK
L_JMP_($2045)_($5B70) OK
L_JMP_($2045)_($5B8F) OK
//------------------------------
$2045  C5 59     CMP $59 
$2047  90 03     BCC L_BRS_($204C)_($2047) OK
//------------------------------
L_JSR_($2049)_($5B4B) OK
//------------------------------
$2049  4C F4 20  JMP L_JMP_($20F4)_($2049) OK
//------------------------------
L_BRS_($204C)_($2047) OK
L_JMP_($204C)_($5BCF) OK
//------------------------------
$204C  C5 58     CMP $58 
$204E  B0 03     BCS L_BRS_($2053)_($204E) OK
$2050  4C F4 20  JMP L_JMP_($20F4)_($2050) OK
//------------------------------
L_BRS_($2053)_($204E) OK
//------------------------------
$2053  A5 FC     LDA $FC 
$2055  38        SEC 
$2056  E9 04     SBC #$04
//------------------------------
L_JMP_($2059)_($5CCA) BAD
//------------------------------
$2058  C5 58     CMP $58 
$205A  90 14     BCC L_BRS_($2070)_($205A) OK
$205C  A5 FC     LDA $FC 
$205E  18        CLC 
$205F  69 05     ADC #$05
//------------------------------
L_JMP_($2061)_($5078) OK
L_JSR_($2061)_($5E9B) OK
//------------------------------
$2061  C5 59     CMP $59 
$2063  B0 10     BCS L_BRS_($2075)_($2063) OK
$2065  A5 FC     LDA $FC 
$2067  38        SEC 
$2068  E9 03     SBC #$03
$206A  38        SEC 
$206B  E5 58     SBC $58 
$206D  4C 77 20  JMP L_JMP_($2077)_($206D) OK
//------------------------------
L_BRS_($2070)_($205A) OK
//------------------------------
$2070  A9 04     LDA #$04
$2072  4C 77 20  JMP L_JMP_($2077)_($2072) OK
//------------------------------
L_BRS_($2075)_($2063) OK
//------------------------------
$2075  A9 20     LDA #$20
//------------------------------
L_JMP_($2077)_($206D) OK
L_JMP_($2077)_($2072) OK
L_JSR_($2078)_($5A0A) BAD
//------------------------------
$2077  85 9A     STA $9A 
$2079  0A        ASL A 
$207A  0A        ASL A 
$207B  0A        ASL A 
$207C  90 08     BCC L_BRS_($2086)_($207C) OK
$207E  A2 FF     LDX #$FF
$2080  8E 10 D0  STX $D010                          // Sprites 0-7 MSB of X coordinate
$2083  4C 8B 20  JMP L_JMP_($208B)_($2083) OK
//------------------------------
L_BRS_($2086)_($207C) OK
//------------------------------
$2086  A2 00     LDX #$00
$2088  8E 10 D0  STX $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_JMP_($208B)_($2083) OK
//------------------------------
$208B  85 9B     STA $9B 
$208D  A5 FB     LDA $FB 
$208F  38        SEC 
$2090  E9 03     SBC #$03
$2092  0A        ASL A 
$2093  0A        ASL A 
$2094  0A        ASL A 
$2095  85 9C     STA $9C 
$2097  A5 84     LDA $84 
$2099  8D 2B D0  STA $D02B                          // Sprite 4 Color
$209C  8D 2C D0  STA $D02C                          // Sprite 5 Color
$209F  A9 00     LDA #$00
$20A1  8D 28 D0  STA $D028                          // Sprite 1 Color
$20A4  8D 29 D0  STA $D029                          // Sprite 2 Color
$20A7  8D 2A D0  STA $D02A                          // Sprite 3 Color
$20AA  A9 08     LDA #$08
$20AC  85 9D     STA $9D 
$20AE  A5 86     LDA $86 
$20B0  85 D6     STA $D6 
$20B2  A5 87     LDA $87 
$20B4  85 D7     STA $D7 
$20B6  20 05 20  JSR L_JSR_($2005)_($20B6) OK
$20B9  20 3B 21  JSR L_JSR_($213B)_($20B9) OK
$20BC  A9 06     LDA #$06
$20BE  85 57     STA $57 
$20C0  20 D4 0D  JSR L_JSR_($0DD4)_($20C0) OK
$20C3  A5 88     LDA $88 
$20C5  85 D6     STA $D6 
$20C7  A5 89     LDA $89 
$20C9  85 D7     STA $D7 
$20CB  20 05 20  JSR L_JSR_($2005)_($20CB) OK
$20CE  20 3B 21  JSR L_JSR_($213B)_($20CE) OK
$20D1  A9 21     LDA #$21
$20D3  85 57     STA $57 
$20D5  20 D4 0D  JSR L_JSR_($0DD4)_($20D5) OK
$20D8  20 24 37  JSR L_JSR_($3724)_($20D8) OK
$20DB  A9 3E     LDA #$3E
$20DD  8D 15 D0  STA $D015                          // Sprite display Enable
$20E0  20 DF 31  JSR L_JSR_($31DF)_($20E0) OK	; Delay
$20E3  20 DF 31  JSR L_JSR_($31DF)_($20E3) OK	; Delay
$20E6  20 DF 31  JSR L_JSR_($31DF)_($20E6) OK	; Delay
$20E9  20 DF 31  JSR L_JSR_($31DF)_($20E9) OK	; Delay
$20EC  20 DF 31  JSR L_JSR_($31DF)_($20EC) OK	; Delay
$20EF  A9 00     LDA #$00
$20F1  8D 15 D0  STA $D015                          // Sprite display Enable
//------------------------------
L_JMP_($20F4)_($2049) OK
L_JMP_($20F4)_($2050) OK
//------------------------------
$20F4  60        RTS 
//------------------------------
L_JSR_($20F5)_($214E) OK
L_JSR_($20F5)_($2171) OK
L_JMP_($20F5)_($217A) OK
//------------------------------
$20F5  A2 F8     LDX #$F8	
$20F7  86 56     STX $56 
$20F9  A0 00     LDY #$00
$20FB  A2 45     LDX #$45
$20FD  86 9F     STX $9F 
//------------------------------
L_BRS_($20FF)_($2127) OK
L_JSR_($20FF)_($7542) OK
//------------------------------
$20FF  A6 9D     LDX $9D 
$2101  86 55     STX $55 
$2103  A6 56     LDX $56 
$2105  86 9E     STX $9E 
$2107  2A        ROL A 
$2108  48        PHA 
//------------------------------
L_JMP_($2109)_($2121) OK
//------------------------------
$2109  B1 9E     LDA ($9E),Y 
$210B  2A        ROL A 
$210C  91 9E     STA ($9E),Y 
$210E  A9 00     LDA #$00
$2110  2A        ROL A 
$2111  85 54     STA $54 
$2113  A5 9E     LDA $9E 
$2115  38        SEC 
$2116  E9 08     SBC #$08
$2118  85 9E     STA $9E 
$211A  C6 55     DEC $55 
$211C  F0 06     BEQ L_BRS_($2124)_($211C) OK
$211E  A5 54     LDA $54 
$2120  6A        ROR A 
$2121  4C 09 21  JMP L_JMP_($2109)_($2121) OK
//------------------------------
L_BRS_($2124)_($211C) OK
//------------------------------
$2124  68        PLA 
$2125  E6 56     INC $56 
$2127  D0 D6     BNE L_BRS_($20FF)_($2127) OK
$2129  60        RTS 
//------------------------------
L_JSR_($212A)_($2005) OK
L_JSR_($212A)_($2594) OK
L_JSR_($212A)_($25B7) OK
//------------------------------
$212A  A9 45     LDA #$45
$212C  85 4F     STA $4F 
$212E  A9 00     LDA #$00
$2130  85 4E     STA $4E 
$2132  A8        TAY 
//------------------------------
L_BRS_($2133)_($2136) OK
//------------------------------
$2133  91 4E     STA ($4E),Y 
$2135  C8        INY 
$2136  D0 FB     BNE L_BRS_($2133)_($2136) OK
$2138  85 A2     STA $A2 
$213A  60        RTS 
//------------------------------
L_JSR_($213B)_($20B9) OK
L_JSR_($213B)_($20CE) OK
L_JSR_($213B)_($258A) OK
L_JSR_($213B)_($25A2) OK
L_JSR_($213B)_($25F7) OK
L_JSR_($213B)_($2615) OK
L_JSR_($213B)_($2C77) OK
L_JSR_($213B)_($2C88) OK
L_JSR_($213B)_($BFF8) OK
L_JSR_($213B)_($FC14) OK
//------------------------------
$213B  A5 9D     LDA $9D 
$213D  0A        ASL A 
$213E  0A        ASL A 
$213F  0A        ASL A 
$2140  38        SEC 
$2141  E5 A2     SBC $A2 
$2143  30 10     BMI L_BRS_($2155)_($2143) OK
$2145  C9 02     CMP #$02
$2147  90 0C     BCC L_BRS_($2155)_($2147) OK
$2149  4A        LSR A 
$214A  85 57     STA $57 
//------------------------------
L_BRS_($214C)_($2153) OK
//------------------------------
$214C  A9 00     LDA #$00
$214E  20 F5 20  JSR L_JSR_($20F5)_($214E) OK
$2151  C6 57     DEC $57 
$2153  D0 F7     BNE L_BRS_($214C)_($2153) OK
//------------------------------
L_BRS_($2155)_($2143) OK
L_BRS_($2155)_($2147) OK
//------------------------------
$2155  60        RTS 
//------------------------------
L_JSR_($2156)_($203A) OK
//------------------------------
$2156  A5 57     LDA $57 
$2158  85 4E     STA $4E 
$215A  A9 47     LDA #$47
$215C  85 4F     STA $4F 
$215E  A0 00     LDY #$00
$2160  B1 4E     LDA ($4E),Y 
$2162  85 57     STA $57 
$2164  E6 A2     INC $A2 
$2166  A5 A2     LDA $A2 
$2168  18        CLC 
$2169  65 57     ADC $57 
$216B  85 A2     STA $A2 
//------------------------------
L_BRS_($216D)_($2176) OK
//------------------------------
$216D  E6 4F     INC $4F 
$216F  B1 4E     LDA ($4E),Y 
$2171  20 F5 20  JSR L_JSR_($20F5)_($2171) OK
$2174  C6 57     DEC $57 
$2176  D0 F5     BNE L_BRS_($216D)_($2176) OK
$2178  A9 00     LDA #$00
$217A  4C F5 20  JMP L_JMP_($20F5)_($217A) OK
$217D  60        RTS 
//------------------------------
L_JSR_($217E)_($22A5) OK
L_JSR_($217E)_($250B) OK
L_JSR_($217E)_($2630) OK
//------------------------------
$217E  A9 20     LDA #$20
$2180  85 8A     STA $8A 
$2182  85 8B     STA $8B 
$2184  85 8C     STA $8C 
$2186  85 8D     STA $8D 
$2188  85 8E     STA $8E 
$218A  A5 A4     LDA $A4 
//------------------------------
L_JMP_($218C)_($21B3) OK
//------------------------------
$218C  C9 28     CMP #$28
$218E  90 26     BCC L_BRS_($21B6)_($218E) OK
//------------------------------
L_BRS_($2190)_($21BE) OK
//------------------------------
$2190  A5 8A     LDA $8A 
$2192  18        CLC 
$2193  69 01     ADC #$01
$2195  09 10     ORA #$10
$2197  85 8A     STA $8A 
$2199  A9 30     LDA #$30
$219B  85 8B     STA $8B 
$219D  85 8C     STA $8C 
$219F  85 8D     STA $8D 
$21A1  A5 A3     LDA $A3 
$21A3  38        SEC 
$21A4  E9 74     SBC #$74
$21A6  85 A3     STA $A3 
$21A8  B0 02     BCS L_BRS_($21AC)_($21A8) OK
$21AA  C6 A4     DEC $A4 
//------------------------------
L_BRS_($21AC)_($21A8) OK
//------------------------------
$21AC  A5 A4     LDA $A4 
$21AE  38        SEC 
$21AF  E9 27     SBC #$27
$21B1  85 A4     STA $A4 
$21B3  4C 8C 21  JMP L_JMP_($218C)_($21B3) OK
//------------------------------
L_BRS_($21B6)_($218E) OK
//------------------------------
$21B6  C9 27     CMP #$27
$21B8  D0 06     BNE L_BRS_($21C0)_($21B8) OK
$21BA  A5 A3     LDA $A3 
$21BC  C9 74     CMP #$74
$21BE  B0 D0     BCS L_BRS_($2190)_($21BE) OK
//------------------------------
L_BRS_($21C0)_($21B8) OK
//------------------------------
$21C0  A5 A4     LDA $A4 
//------------------------------
L_JMP_($21C2)_($21E7) OK
//------------------------------
$21C2  C9 04     CMP #$04
$21C4  90 24     BCC L_BRS_($21EA)_($21C4) OK
//------------------------------
L_BRS_($21C6)_($21F2) OK
//------------------------------
$21C6  A5 8B     LDA $8B 
$21C8  18        CLC 
$21C9  69 01     ADC #$01
$21CB  09 10     ORA #$10
$21CD  85 8B     STA $8B 
$21CF  A9 30     LDA #$30
$21D1  85 8C     STA $8C 
$21D3  85 8D     STA $8D 
$21D5  A5 A3     LDA $A3 
$21D7  38        SEC 
$21D8  E9 E8     SBC #$E8
$21DA  85 A3     STA $A3 
$21DC  B0 02     BCS L_BRS_($21E0)_($21DC) OK
$21DE  C6 A4     DEC $A4 
//------------------------------
L_BRS_($21E0)_($21DC) OK
//------------------------------
$21E0  A5 A4     LDA $A4 
$21E2  38        SEC 
$21E3  E9 03     SBC #$03
$21E5  85 A4     STA $A4 
$21E7  4C C2 21  JMP L_JMP_($21C2)_($21E7) OK
//------------------------------
L_BRS_($21EA)_($21C4) OK
//------------------------------
$21EA  C9 03     CMP #$03
$21EC  D0 06     BNE L_BRS_($21F4)_($21EC) OK
$21EE  A5 A3     LDA $A3 
$21F0  C9 E8     CMP #$E8
$21F2  B0 D2     BCS L_BRS_($21C6)_($21F2) OK
//------------------------------
L_BRS_($21F4)_($21EC) OK
L_JMP_($21F4)_($2210) OK
//------------------------------
$21F4  A5 A4     LDA $A4 
$21F6  F0 1B     BEQ L_BRS_($2213)_($21F6) OK
//------------------------------
L_BRS_($21F8)_($2217) OK
//------------------------------
$21F8  A5 8C     LDA $8C 
$21FA  18        CLC 
$21FB  69 01     ADC #$01
$21FD  09 10     ORA #$10
$21FF  85 8C     STA $8C 
$2201  A5 A3     LDA $A3 
$2203  38        SEC 
$2204  E9 64     SBC #$64
$2206  85 A3     STA $A3 
$2208  B0 02     BCS L_BRS_($220C)_($2208) OK
$220A  C6 A4     DEC $A4 
//------------------------------
L_BRS_($220C)_($2208) OK
//------------------------------
$220C  A9 30     LDA #$30
$220E  85 8D     STA $8D 
//------------------------------
L_JSR_($2210)_($496D) OK
//------------------------------
$2210  4C F4 21  JMP L_JMP_($21F4)_($2210) OK
//------------------------------
L_BRS_($2213)_($21F6) OK
//------------------------------
$2213  A5 A3     LDA $A3 
$2215  C9 64     CMP #$64
$2217  B0 DF     BCS L_BRS_($21F8)_($2217) OK
$2219  4C 22 22  JMP L_JMP_($2222)_($2219) OK
//------------------------------
L_JSR_($221C)_($1E23) OK
L_JSR_($221C)_($2259) OK
L_JSR_($221C)_($227E) OK
//------------------------------
$221C  A9 20     LDA #$20
$221E  85 8D     STA $8D 
$2220  85 8E     STA $8E 
//------------------------------
L_JMP_($2222)_($2219) OK
L_JMP_($2222)_($2238) OK
//------------------------------
$2222  A5 A3     LDA $A3 
$2224  C9 0A     CMP #$0A
$2226  90 13     BCC L_BRS_($223B)_($2226) OK
$2228  A5 8D     LDA $8D 
$222A  18        CLC 
$222B  69 01     ADC #$01
$222D  09 10     ORA #$10
$222F  85 8D     STA $8D 
$2231  A5 A3     LDA $A3 
$2233  38        SEC 
$2234  E9 0A     SBC #$0A
$2236  85 A3     STA $A3 
$2238  4C 22 22  JMP L_JMP_($2222)_($2238) OK
//------------------------------
L_BRS_($223B)_($2226) OK
//------------------------------
$223B  18        CLC 
$223C  69 30     ADC #$30
$223E  85 8E     STA $8E 
$2240  60        RTS 
//------------------------------
L_JSR_($2241)_($0B2C) OK
//------------------------------
$2241  A5 60     LDA $60 
$2243  C9 0B     CMP #$0B
$2245  F0 03     BEQ L_BRS_($224A)_($2245) OK
$2247  4C F3 22  JMP L_JMP_($22F3)_($2247) OK
//------------------------------
L_BRS_($224A)_($2245) OK
//------------------------------
$224A  A2 20     LDX #$20
$224C  A0 63     LDY #$63
$224E  20 3E 25  JSR L_JSR_($253E)_($224E) OK
$2251  85 A3     STA $A3 
$2253  85 C0     STA $C0 
$2255  A9 30     LDA #$30
$2257  85 8B     STA $8B 
$2259  20 1C 22  JSR L_JSR_($221C)_($2259) OK
$225C  A9 00     LDA #$00
$225E  85 50     STA $50 
$2260  A9 5A     LDA #$5A
$2262  85 51     STA $51 
$2264  A0 08     LDY #$08
$2266  A5 8D     LDA $8D 
$2268  91 50     STA ($50),Y 
$226A  C8        INY 
$226B  A5 8E     LDA $8E 
$226D  91 50     STA ($50),Y 
$226F  A2 20     LDX #$20
$2271  A0 63     LDY #$63
$2273  20 3E 25  JSR L_JSR_($253E)_($2273) OK
$2276  85 A3     STA $A3 
$2278  85 C1     STA $C1 
$227A  A9 30     LDA #$30
$227C  85 8B     STA $8B 
$227E  20 1C 22  JSR L_JSR_($221C)_($227E) OK
$2281  A0 0D     LDY #$0D
$2283  A5 8D     LDA $8D 
$2285  91 50     STA ($50),Y 
$2287  C8        INY 
$2288  A5 8E     LDA $8E 
$228A  91 50     STA ($50),Y 
$228C  A0 08     LDY #$08
$228E  A9 00     LDA #$00
//------------------------------
L_BRS_($2290)_($229D) OK
//------------------------------
$2290  0A        ASL A 
$2291  26 C0     ROL $C0 
$2293  90 07     BCC L_BRS_($229C)_($2293) OK
$2295  18        CLC 
$2296  65 C1     ADC $C1 
$2298  90 02     BCC L_BRS_($229C)_($2298) OK
$229A  E6 C0     INC $C0 
//------------------------------
L_BRS_($229C)_($2293) OK
L_BRS_($229C)_($2298) OK
//------------------------------
$229C  88        DEY 
$229D  D0 F1     BNE L_BRS_($2290)_($229D) OK
$229F  85 A3     STA $A3 
$22A1  A5 C0     LDA $C0 
$22A3  85 A4     STA $A4 
$22A5  20 7E 21  JSR L_JSR_($217E)_($22A5) OK
$22A8  A9 11     LDA #$11
$22AA  85 52     STA $52 
$22AC  A9 5A     LDA #$5A
$22AE  85 53     STA $53 
$22B0  A0 06     LDY #$06
$22B2  A5 8B     LDA $8B 
$22B4  91 52     STA ($52),Y 
$22B6  C8        INY 
$22B7  A5 8C     LDA $8C 
$22B9  91 52     STA ($52),Y 
$22BB  C8        INY 
$22BC  A5 8D     LDA $8D 
$22BE  91 52     STA ($52),Y 
$22C0  C8        INY 
$22C1  A5 8E     LDA $8E 
$22C3  91 52     STA ($52),Y 
//------------------------------
L_JMP_($22C5)_($231D) OK
L_JMP_($22C5)_($2383) OK
//------------------------------
$22C5  A5 60     LDA $60 
$22C7  48        PHA 
$22C8  A9 11     LDA #$11
$22CA  85 60     STA $60 
$22CC  20 79 32  JSR L_JSR_($3279)_($22CC) OK
$22CF  A5 52     LDA $52 
$22D1  85 AC     STA $AC 
$22D3  A5 53     LDA $53 
$22D5  85 AD     STA $AD 
$22D7  20 BF 33  JSR L_JSR_($33BF)_($22D7) OK
$22DA  68        PLA 
$22DB  85 60     STA $60 
$22DD  20 79 32  JSR L_JSR_($3279)_($22DD) OK
$22E0  A5 50     LDA $50 
$22E2  85 AC     STA $AC 
$22E4  A5 51     LDA $51 
$22E6  85 AD     STA $AD 
$22E8  A9 87     LDA #$87
$22EA  85 AA     STA $AA 
$22EC  A9 23     LDA #$23
$22EE  85 AB     STA $AB 
$22F0  4C 86 23  JMP L_JMP_($2386)_($22F0) OK
//------------------------------
L_JMP_($22F3)_($2247) OK
//------------------------------
$22F3  C9 0E     CMP #$0E
$22F5  D0 29     BNE L_BRS_($2320)_($22F5) OK
$22F7  A5 46     LDA $46 
$22F9  F0 25     BEQ L_BRS_($2320)_($22F9) OK
$22FB  C9 03     CMP #$03
$22FD  B0 21     BCS L_BRS_($2320)_($22FD) OK
$22FF  A5 C2     LDA $C2 
$2301  D0 1D     BNE L_BRS_($2320)_($2301) OK
$2303  A9 01     LDA #$01
$2305  85 C2     STA $C2 
$2307  A9 2D     LDA #$2D
$2309  85 50     STA $50 
$230B  A9 5B     LDA #$5B
$230D  85 51     STA $51 
$230F  A9 E1     LDA #$E1
$2311  85 52     STA $52 
$2313  A9 5A     LDA #$5A
$2315  85 53     STA $53 
$2317  A0 16     LDY #$16
$2319  A5 A5     LDA $A5 
$231B  91 52     STA ($52),Y 
$231D  4C C5 22  JMP L_JMP_($22C5)_($231D) OK
//------------------------------
L_BRS_($2320)_($22F5) OK
L_BRS_($2320)_($22F9) OK
L_BRS_($2320)_($22FD) OK
L_BRS_($2320)_($2301) OK
//------------------------------
$2320  A2 00     LDX #$00
$2322  A0 29     LDY #$29
$2324  20 3E 25  JSR L_JSR_($253E)_($2324) OK
$2327  85 57     STA $57 
$2329  A5 60     LDA $60 
$232B  C9 0C     CMP #$0C
$232D  F0 09     BEQ L_BRS_($2338)_($232D) OK
$232F  C9 0D     CMP #$0D
$2331  F0 0A     BEQ L_BRS_($233D)_($2331) OK
$2333  A9 D4     LDA #$D4
$2335  4C 3F 23  JMP L_JMP_($233F)_($2335) OK
//------------------------------
L_BRS_($2338)_($232D) OK
//------------------------------
$2338  A9 80     LDA #$80
$233A  4C 3F 23  JMP L_JMP_($233F)_($233A) OK
//------------------------------
L_BRS_($233D)_($2331) OK
//------------------------------
$233D  A9 AA     LDA #$AA
//------------------------------
L_JMP_($233F)_($2335) OK
L_JMP_($233F)_($233A) OK
//------------------------------
$233F  18        CLC 
$2340  65 57     ADC $57 
$2342  85 C3     STA $C3 
$2344  A5 60     LDA $60 
$2346  38        SEC 
$2347  E9 0C     SBC #$0C
$2349  0A        ASL A 
$234A  0A        ASL A 
$234B  85 57     STA $57 
$234D  A5 C3     LDA $C3 
$234F  4A        LSR A 
$2350  90 07     BCC L_BRS_($2359)_($2350) OK
$2352  A5 57     LDA $57 
$2354  18        CLC 
$2355  69 0C     ADC #$0C
$2357  85 57     STA $57 
//------------------------------
L_BRS_($2359)_($2350) OK
//------------------------------
$2359  A5 57     LDA $57 
$235B  AA        TAX 
$235C  BD E0 46  LDA $46E0,X 
$235F  85 50     STA $50 
$2361  A9 5A     LDA #$5A
$2363  85 51     STA $51 
$2365  E8        INX 
$2366  BD E0 46  LDA $46E0,X 
$2369  A8        TAY 
$236A  A5 C3     LDA $C3 
$236C  91 50     STA ($50),Y 
$236E  E8        INX 
$236F  BD E0 46  LDA $46E0,X 
$2372  85 52     STA $52 
$2374  A9 5A     LDA #$5A
$2376  85 53     STA $53 
$2378  E8        INX 
$2379  BD E0 46  LDA $46E0,X 
$237C  A8        TAY 
$237D  A5 C3     LDA $C3 
$237F  49 01     EOR #$01
$2381  91 52     STA ($52),Y 
$2383  4C C5 22  JMP L_JMP_($22C5)_($2383) OK
//------------------------------
L_JMP_($2386)_($22F0) OK
//------------------------------
$2386  60        RTS 
//------------------------------
$2387  A9 00     LDA #$00
$2389  85 AE     STA $AE 
$238B  85 AF     STA $AF 
$238D  A5 FC     LDA $FC 
$238F  85 57     STA $57 
$2391  E6 57     INC $57 
$2393  A5 58     LDA $58 
$2395  C5 57     CMP $57 
$2397  90 03     BCC L_BRS_($239C)_($2397) OK
$2399  4C 28 1D  JMP L_JMP_($1D28)_($2399) OK
//------------------------------
L_BRS_($239C)_($2397) OK
//------------------------------
$239C  A5 59     LDA $59 
$239E  E6 57     INC $57 
$23A0  C5 57     CMP $57 
$23A2  B0 03     BCS L_BRS_($23A7)_($23A2) OK
$23A4  4C 28 1D  JMP L_JMP_($1D28)_($23A4) OK
//------------------------------
L_BRS_($23A7)_($23A2) OK
//------------------------------
$23A7  AD 15 D0  LDA $D015                          // Sprite display Enable
$23AA  F0 03     BEQ L_BRS_($23AF)_($23AA) OK
$23AC  4C 6A 24  JMP L_JMP_($246A)_($23AC) OK
//------------------------------
L_BRS_($23AF)_($23AA) OK
//------------------------------
$23AF  A9 58     LDA #$58
$23B1  85 AA     STA $AA 
$23B3  A9 24     LDA #$24
$23B5  85 AB     STA $AB 
$23B7  A9 CA     LDA #$CA	; TODO: Sprite data pointer ($CAxx)
$23B9  85 4F     STA $4F 
$23BB  A9 40     LDA #$40
$23BD  85 4E     STA $4E 
$23BF  A9 00     LDA #$00
$23C1  A0 24     LDY #$24
//------------------------------
L_BRS_($23C3)_($23C8) OK
//------------------------------
$23C3  91 4E     STA ($4E),Y 
$23C5  88        DEY 
$23C6  C0 0B     CPY #$0B
$23C8  D0 F9     BNE L_BRS_($23C3)_($23C8) OK
$23CA  A9 80     LDA #$80
$23CC  85 4E     STA $4E 
$23CE  A9 00     LDA #$00
$23D0  A0 24     LDY #$24
//------------------------------
L_BRS_($23D2)_($23D7) OK
//------------------------------
$23D2  91 4E     STA ($4E),Y 
$23D4  88        DEY 
$23D5  C0 0B     CPY #$0B
$23D7  D0 F9     BNE L_BRS_($23D2)_($23D7) OK
$23D9  A5 60     LDA $60 
$23DB  C9 0B     CMP #$0B
$23DD  B0 03     BCS L_BRS_($23E2)_($23DD) OK
$23DF  4C EE 23  JMP L_JMP_($23EE)_($23DF) OK
//------------------------------
L_BRS_($23E2)_($23DD) OK
//------------------------------
$23E2  C9 0F     CMP #$0F
$23E4  B0 08     BCS L_BRS_($23EE)_($23E4) OK
$23E6  A5 FB     LDA $FB 
$23E8  38        SEC 
$23E9  E9 03     SBC #$03
$23EB  4C F3 23  JMP L_JMP_($23F3)_($23EB) OK
//------------------------------
L_JMP_($23EE)_($23DF) OK
L_BRS_($23EE)_($23E4) OK
//------------------------------
$23EE  A5 FB     LDA $FB 
$23F0  38        SEC 
$23F1  E9 02     SBC #$02
//------------------------------
L_JMP_($23F3)_($23EB) OK
//------------------------------
$23F3  0A        ASL A 
$23F4  0A        ASL A 
$23F5  0A        ASL A 
$23F6  18        CLC 
$23F7  69 34     ADC #$34
$23F9  85 D1     STA $D1 
$23FB  A9 00     LDA #$00
$23FD  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
$2400  A5 FC     LDA $FC 
$2402  18        CLC 
$2403  69 04     ADC #$04
$2405  38        SEC 
$2406  E5 58     SBC $58 
$2408  0A        ASL A 
$2409  0A        ASL A 
$240A  0A        ASL A 
$240B  90 08     BCC L_BRS_($2415)_($240B) OK
$240D  A2 28     LDX #$28
$240F  8E 10 D0  STX $D010                          // Sprites 0-7 MSB of X coordinate
$2412  4C 1B 24  JMP L_JMP_($241B)_($2412) OK
//------------------------------
L_BRS_($2415)_($240B) OK
//------------------------------
$2415  20 9F 37  JSR L_JSR_($379F)_($2415) OK
$2418  4C 1E 24  JMP L_JMP_($241E)_($2418) OK
//------------------------------
L_JMP_($241B)_($2412) OK
//------------------------------
$241B  20 05 38  JSR L_JSR_($3805)_($241B) OK
//------------------------------
L_JMP_($241E)_($2418) OK
//------------------------------
$241E  A9 40     LDA #$40
$2420  8D 1D D0  STA $D01D                          // Sprites Expand 2x Horizontal (X)
$2423  A9 00     LDA #$00
$2425  8D 27 D0  STA $D027                          // Sprite 0 Color
$2428  8D 28 D0  STA $D028                          // Sprite 1 Color
$242B  8D 29 D0  STA $D029                          // Sprite 2 Color
$242E  8D 2A D0  STA $D02A                          // Sprite 3 Color
$2431  A9 01     LDA #$01
$2433  8D 2B D0  STA $D02B                          // Sprite 4 Color
$2436  8D 2C D0  STA $D02C                          // Sprite 5 Color
$2439  8D 2D D0  STA $D02D                          // Sprite 6 Color
$243C  A5 D1     LDA $D1 
$243E  8D 01 D0  STA $D001                          // Sprite 0 Y Pos
$2441  8D 03 D0  STA $D003                          // Sprite 1 Y Pos
$2444  8D 05 D0  STA $D005                          // Sprite 2 Y Pos
$2447  8D 07 D0  STA $D007                          // Sprite 3 Y Pos
$244A  8D 09 D0  STA $D009                          // Sprite 4 Y Pos
$244D  8D 0B D0  STA $D00B                          // Sprite 5 Y Pos
$2450  8D 0D D0  STA $D00D                          // Sprite 6 Y Pos
$2453  A9 7F     LDA #$7F
$2455  8D 15 D0  STA $D015                          // Sprite display Enable
$2458  20 6B 24  JSR L_JSR_($246B)_($2458) OK
$245B  90 08     BCC L_BRS_($2465)_($245B) OK
//------------------------------
L_BRS_($245D)_($2468) OK
//------------------------------
$245D  A9 00     LDA #$00
$245F  8D 15 D0  STA $D015                          // Sprite display Enable
$2462  4C 28 1D  JMP L_JMP_($1D28)_($2462) OK
//------------------------------
L_BRS_($2465)_($245B) OK
//------------------------------
$2465  20 6B 24  JSR L_JSR_($246B)_($2465) OK
$2468  B0 F3     BCS L_BRS_($245D)_($2468) OK
//------------------------------
L_JMP_($246A)_($23AC) OK
//------------------------------
$246A  60        RTS 
//------------------------------
L_JSR_($246B)_($2458) OK
L_JSR_($246B)_($2465) OK
//------------------------------
$246B  20 8B 10  JSR L_JSR_($108B)_($246B) OK
$246E  C9 00     CMP #$00
$2470  D0 04     BNE L_BRS_($2476)_($2470) OK
$2472  38        SEC 
$2473  4C A6 24  JMP L_JMP_($24A6)_($2473) OK
//------------------------------
L_BRS_($2476)_($2470) OK
//------------------------------
$2476  C9 02     CMP #$02
$2478  F0 0C     BEQ L_BRS_($2486)_($2478) OK
$247A  C9 03     CMP #$03
$247C  D0 0A     BNE L_BRS_($2488)_($247C) OK
$247E  A9 48     LDA #$48
$2480  85 AD     STA $AD 
$2482  A9 16     LDA #$16
$2484  85 AC     STA $AC 
//------------------------------
L_BRS_($2486)_($2478) OK
//------------------------------
$2486  A9 20     LDA #$20
//------------------------------
L_BRS_($2488)_($247C) OK
//------------------------------
$2488  85 4E     STA $4E 
$248A  A9 47     LDA #$47
$248C  85 4F     STA $4F 
$248E  A0 00     LDY #$00
$2490  B1 4E     LDA ($4E),Y 
$2492  AA        TAX 
//------------------------------
L_BRS_($2493)_($249F) OK
//------------------------------
$2493  8A        TXA 
$2494  48        PHA 
$2495  E6 4F     INC $4F 
$2497  B1 4E     LDA ($4E),Y 
$2499  20 A7 24  JSR L_JSR_($24A7)_($2499) OK
$249C  68        PLA 
$249D  AA        TAX 
$249E  CA        DEX 
$249F  D0 F2     BNE L_BRS_($2493)_($249F) OK
$24A1  8A        TXA 
$24A2  20 A7 24  JSR L_JSR_($24A7)_($24A2) OK
$24A5  18        CLC 
//------------------------------
L_JMP_($24A6)_($2473) OK
//------------------------------
$24A6  60        RTS 
//------------------------------
L_JSR_($24A7)_($2499) OK
L_JSR_($24A7)_($24A2) OK
//------------------------------
$24A7  A2 08     LDX #$08
$24A9  48        PHA 
$24AA  A9 CA     LDA #$CA	; TODO: Sprite data pointer ($CAxx)
$24AC  85 53     STA $53 
$24AE  A9 8E     LDA #$8E
$24B0  85 52     STA $52 
$24B2  68        PLA 
$24B3  A0 00     LDY #$00
//------------------------------
L_JMP_($24B5)_($24FB) OK
//------------------------------
$24B5  2A        ROL A 
$24B6  48        PHA 
$24B7  B1 52     LDA ($52),Y 
$24B9  2A        ROL A 
$24BA  91 52     STA ($52),Y 
$24BC  C6 52     DEC $52 
$24BE  B1 52     LDA ($52),Y 
$24C0  2A        ROL A 
$24C1  91 52     STA ($52),Y 
$24C3  C6 52     DEC $52 
$24C5  B1 52     LDA ($52),Y 
$24C7  2A        ROL A 
$24C8  91 52     STA ($52),Y 
$24CA  2A        ROL A 
$24CB  48        PHA 
$24CC  A5 52     LDA $52 
$24CE  38        SEC 
$24CF  E9 3E     SBC #$3E
$24D1  B0 02     BCS L_BRS_($24D5)_($24D1) OK
$24D3  C6 53     DEC $53 
//------------------------------
L_BRS_($24D5)_($24D1) OK
//------------------------------
$24D5  85 52     STA $52 
$24D7  68        PLA 
$24D8  6A        ROR A 
$24D9  B1 52     LDA ($52),Y 
$24DB  2A        ROL A 
$24DC  91 52     STA ($52),Y 
$24DE  C6 52     DEC $52 
$24E0  B1 52     LDA ($52),Y 
$24E2  2A        ROL A 
$24E3  91 52     STA ($52),Y 
$24E5  C6 52     DEC $52 
$24E7  B1 52     LDA ($52),Y 
$24E9  2A        ROL A 
$24EA  91 52     STA ($52),Y 
$24EC  CA        DEX 
$24ED  F0 0F     BEQ L_BRS_($24FE)_($24ED) OK
$24EF  A5 52     LDA $52 
$24F1  18        CLC 
$24F2  69 45     ADC #$45
$24F4  90 02     BCC L_BRS_($24F8)_($24F4) OK
$24F6  E6 53     INC $53 
//------------------------------
L_BRS_($24F8)_($24F4) OK
//------------------------------
$24F8  85 52     STA $52 
$24FA  68        PLA 
$24FB  4C B5 24  JMP L_JMP_($24B5)_($24FB) OK
//------------------------------
L_BRS_($24FE)_($24ED) OK
//------------------------------
$24FE  68        PLA 
$24FF  60        RTS 
//------------------------------
L_JSR_($2500)_($0A3F) OK
L_JSR_($2500)_($0B23) OK
L_JSR_($2500)_($0B72) OK
L_JSR_($2502)_($B718) BAD
L_JSR_($2502)_($F393) BAD
//------------------------------
$2500  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$2503  09 80     ORA #$80
$2505  85 A3     STA $A3 
$2507  A9 00     LDA #$00
$2509  85 A4     STA $A4 
$250B  20 7E 21  JSR L_JSR_($217E)_($250B) OK
$250E  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$2511  0A        ASL A 
$2512  B0 0B     BCS L_BRS_($251F)_($2512) OK
$2514  A9 9D     LDA #$9D
$2516  85 AC     STA $AC 
$2518  A9 BA     LDA #$BA
$251A  85 4E     STA $4E 
$251C  4C 27 25  JMP L_JMP_($2527)_($251C) OK
//------------------------------
L_BRS_($251F)_($2512) OK
//------------------------------
$251F  A9 62     LDA #$62
$2521  85 AC     STA $AC 
$2523  A9 6F     LDA #$6F
$2525  85 4E     STA $4E 
//------------------------------
L_JMP_($2527)_($251C) OK
//------------------------------
$2527  A9 5C     LDA #$5C
$2529  85 AD     STA $AD 
$252B  85 4F     STA $4F 
$252D  A0 00     LDY #$00
$252F  A5 8C     LDA $8C 
$2531  91 4E     STA ($4E),Y 
$2533  C8        INY 
$2534  A5 8D     LDA $8D 
$2536  91 4E     STA ($4E),Y 
$2538  C8        INY 
$2539  A5 8E     LDA $8E 
$253B  91 4E     STA ($4E),Y 
$253D  60        RTS 
//------------------------------
L_JSR_($253E)_($224E) OK
L_JSR_($253E)_($2273) OK
L_JSR_($253E)_($2324) OK
//------------------------------
$253E  86 E3     STX $E3 
$2540  C8        INY 
$2541  98        TYA 
$2542  38        SEC 
$2543  E5 E3     SBC $E3 
$2545  85 E4     STA $E4 
//------------------------------
L_BRS_($2547)_($254F) OK
//------------------------------
$2547  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$254A  38        SEC 
$254B  E5 E3     SBC $E3 
$254D  C5 E4     CMP $E4 
$254F  B0 F6     BCS L_BRS_($2547)_($254F) OK
$2551  60        RTS 
//------------------------------
L_JSR_($2552)_($0A7A) OK
L_JSR_($2552)_($0AD3) OK
L_JSR_($2552)_($0B6F) OK
//------------------------------
$2552  48        PHA 
$2553  85 72     STA $72 
$2555  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$2558  C9 B5     CMP #$B5
$255A  B0 0A     BCS L_BRS_($2566)_($255A) OK
$255C  68        PLA 
$255D  C9 11     CMP #$11
$255F  F0 11     BEQ L_BRS_($2572)_($255F) OK
$2561  84 D8     STY $D8 
$2563  4C B7 1D  JMP L_JMP_($1DB7)_($2563) OK
//------------------------------
L_BRS_($2566)_($255A) OK
//------------------------------
$2566  68        PLA 
$2567  A9 09     LDA #$09
$2569  85 D8     STA $D8 
$256B  A9 11     LDA #$11
$256D  85 72     STA $72 
$256F  4C B7 1D  JMP L_JMP_($1DB7)_($256F) OK
//------------------------------
L_BRS_($2572)_($255F) OK
//------------------------------
$2572  60        RTS 
//------------------------------
L_JSR_($2573)_($3AFC) OK
//------------------------------
$2573  A5 46     LDA $46 
$2575  D0 38     BNE L_BRS_($25AF)_($2575) OK
$2577  A9 46     LDA #$46
$2579  85 D7     STA $D7 
$257B  A9 00     LDA #$00
$257D  85 D6     STA $D6 
$257F  A9 08     LDA #$08
$2581  85 9D     STA $9D 
$2583  A9 40     LDA #$40
$2585  85 31     STA $31 
$2587  20 05 20  JSR L_JSR_($2005)_($2587) OK
$258A  20 3B 21  JSR L_JSR_($213B)_($258A) OK
$258D  A2 10     LDX #$10
$258F  A0 15     LDY #$15
$2591  20 68 38  JSR L_JSR_($3868)_($2591) OK
$2594  20 2A 21  JSR L_JSR_($212A)_($2594) OK
$2597  A9 46     LDA #$46
$2599  85 D7     STA $D7 
$259B  A9 10     LDA #$10
$259D  85 D6     STA $D6 
$259F  20 05 20  JSR L_JSR_($2005)_($259F) OK
$25A2  20 3B 21  JSR L_JSR_($213B)_($25A2) OK
$25A5  A2 10     LDX #$10
$25A7  A0 17     LDY #$17
$25A9  20 68 38  JSR L_JSR_($3868)_($25A9) OK
$25AC  4C 1F 26  JMP L_JMP_($261F)_($25AC) OK
//------------------------------
L_BRS_($25AF)_($2575) OK
//------------------------------
$25AF  A9 08     LDA #$08
$25B1  85 9D     STA $9D 
$25B3  A9 40     LDA #$40
$25B5  85 31     STA $31 
$25B7  20 2A 21  JSR L_JSR_($212A)_($25B7) OK
$25BA  A5 70     LDA $70 
$25BC  29 07     AND #$07
$25BE  C9 05     CMP #$05
$25C0  B0 28     BCS L_BRS_($25EA)_($25C0) OK
$25C2  A5 70     LDA $70 
$25C4  29 F0     AND #$F0
$25C6  D0 05     BNE L_BRS_($25CD)_($25C6) OK
$25C8  A9 B8     LDA #$B8
$25CA  4C E1 25  JMP L_JMP_($25E1)_($25CA) OK
//------------------------------
L_BRS_($25CD)_($25C6) OK
//------------------------------
$25CD  C9 10     CMP #$10
$25CF  D0 05     BNE L_BRS_($25D6)_($25CF) OK
$25D1  A9 C6     LDA #$C6
$25D3  4C E1 25  JMP L_JMP_($25E1)_($25D3) OK
//------------------------------
L_BRS_($25D6)_($25CF) OK
//------------------------------
$25D6  C9 20     CMP #$20
$25D8  D0 05     BNE L_BRS_($25DF)_($25D8) OK
$25DA  A9 D4     LDA #$D4
$25DC  4C E1 25  JMP L_JMP_($25E1)_($25DC) OK
//------------------------------
L_BRS_($25DF)_($25D8) OK
//------------------------------
$25DF  A9 E2     LDA #$E2
//------------------------------
L_JMP_($25E1)_($25CA) OK
L_JMP_($25E1)_($25D3) OK
L_JMP_($25E1)_($25DC) OK
//------------------------------
$25E1  85 D6     STA $D6 
$25E3  A9 47     LDA #$47
$25E5  85 D7     STA $D7 
$25E7  4C F4 25  JMP L_JMP_($25F4)_($25E7) OK
//------------------------------
L_BRS_($25EA)_($25C0) OK
//------------------------------
$25EA  D0 0E     BNE L_BRS_($25FA)_($25EA) OK
$25EC  A9 80     LDA #$80
$25EE  85 D6     STA $D6 
$25F0  A9 48     LDA #$48
$25F2  85 D7     STA $D7 
//------------------------------
L_JMP_($25F4)_($25E7) OK
//------------------------------
$25F4  20 05 20  JSR L_JSR_($2005)_($25F4) OK
$25F7  20 3B 21  JSR L_JSR_($213B)_($25F7) OK
//------------------------------
L_BRS_($25FA)_($25EA) OK
//------------------------------
$25FA  A2 10     LDX #$10
$25FC  A0 15     LDY #$15
$25FE  20 68 38  JSR L_JSR_($3868)_($25FE) OK
$2601  A5 70     LDA $70 
$2603  29 07     AND #$07
$2605  0A        ASL A 
$2606  0A        ASL A 
$2607  0A        ASL A 
$2608  0A        ASL A 
$2609  18        CLC 
$260A  69 80     ADC #$80
$260C  85 D6     STA $D6 
$260E  A9 48     LDA #$48
$2610  85 D7     STA $D7 
$2612  20 05 20  JSR L_JSR_($2005)_($2612) OK
$2615  20 3B 21  JSR L_JSR_($213B)_($2615) OK
$2618  A2 10     LDX #$10
$261A  A0 17     LDY #$17
$261C  20 68 38  JSR L_JSR_($3868)_($261C) OK
//------------------------------
L_JMP_($261F)_($25AC) OK
//------------------------------
$261F  60        RTS 
//------------------------------
L_JMP_($2620)_($1D46) OK
L_JMP_($2620)_($1DB3) OK
L_JSR_($2620)_($2E92) OK
//------------------------------
$2620  85 E6     STA $E6 
$2622  A9 00     LDA #$00
$2624  85 4F     STA $4F 
$2626  A8        TAY 
$2627  B1 4E     LDA ($4E),Y 
$2629  85 A3     STA $A3 
$262B  C8        INY 
$262C  B1 4E     LDA ($4E),Y 
$262E  85 A4     STA $A4 
$2630  20 7E 21  JSR L_JSR_($217E)_($2630) OK
$2633  A9 03     LDA #$03
$2635  85 9D     STA $9D 
$2637  A9 8A     LDA #$8A
$2639  85 D6     STA $D6 
$263B  A9 00     LDA #$00
$263D  85 D7     STA $D7 
$263F  20 05 20  JSR L_JSR_($2005)_($263F) OK
$2642  A5 E6     LDA $E6 
$2644  D0 0B     BNE L_BRS_($2651)_($2644) OK
$2646  A9 FB     LDA #$FB	; TODO: screen pointer
$2648  85 51     STA $51 
$264A  A9 40     LDA #$40
$264C  85 50     STA $50 
$264E  4C 68 26  JMP L_JMP_($2668)_($264E) OK
//------------------------------
L_BRS_($2651)_($2644) OK
//------------------------------
$2651  C9 01     CMP #$01
$2653  D0 0B     BNE L_BRS_($2660)_($2653) OK
$2655  A9 FC     LDA #$FC	; TODO: screen pointer
$2657  85 51     STA $51 
$2659  A9 80     LDA #$80
$265B  85 50     STA $50 
$265D  4C 68 26  JMP L_JMP_($2668)_($265D) OK
//------------------------------
L_BRS_($2660)_($2653) OK
//------------------------------
$2660  A9 FD     LDA #$FD	; TODO: Screen pointer
$2662  85 51     STA $51 
$2664  A9 C0     LDA #$C0
$2666  85 50     STA $50 
//------------------------------
L_JMP_($2668)_($264E) OK
L_JMP_($2668)_($265D) OK
//------------------------------
$2668  A0 17     LDY #$17
$266A  A9 45     LDA #$45
$266C  85 4F     STA $4F 
$266E  A9 E8     LDA #$E8
$2670  85 4E     STA $4E 
//------------------------------
L_BRS_($2672)_($2677) OK
//------------------------------
$2672  B1 4E     LDA ($4E),Y 
$2674  91 50     STA ($50),Y 
$2676  88        DEY 
$2677  10 F9     BPL L_BRS_($2672)_($2677) OK
$2679  60        RTS 
//------------------------------
$267A  A9 26     LDA #$26
$267C  85 B1     STA $B1 
$267E  A9 96     LDA #$96
$2680  85 B0     STA $B0 
$2682  20 2E 32  JSR L_JSR_($322E)_($2682) OK
$2685  A5 26     LDA $26 
$2687  85 B3     STA $B3 
$2689  29 80     AND #$80
$268B  18        CLC 
$268C  69 2A     ADC #$2A
$268E  85 26     STA $26 
$2690  20 2E 32  JSR L_JSR_($322E)_($2690) OK
$2693  4C EE 26  JMP L_JMP_($26EE)_($2693) OK
$2696  A9 26     LDA #$26
$2698  85 B1     STA $B1 
$269A  A9 E0     LDA #$E0
$269C  85 B0     STA $B0 
$269E  20 2E 32  JSR L_JSR_($322E)_($269E) OK
$26A1  E6 26     INC $26 
$26A3  20 2E 32  JSR L_JSR_($322E)_($26A3) OK
$26A6  A4 FB     LDY $FB 
$26A8  A5 26     LDA $26 
$26AA  0A        ASL A 
$26AB  B0 08     BCS L_BRS_($26B5)_($26AB) OK
$26AD  A5 FC     LDA $FC 
$26AF  38        SEC 
$26B0  E9 02     SBC #$02
$26B2  4C BA 26  JMP L_JMP_($26BA)_($26B2) OK
//------------------------------
L_BRS_($26B5)_($26AB) OK
//------------------------------
$26B5  A5 FC     LDA $FC 
$26B7  18        CLC 
$26B8  69 02     ADC #$02
//------------------------------
L_JMP_($26BA)_($26B2) OK
//------------------------------
$26BA  AA        TAX 
$26BB  20 D2 27  JSR L_JSR_($27D2)_($26BB) OK
$26BE  90 2E     BCC L_BRS_($26EE)_($26BE) OK
$26C0  C9 14     CMP #$14
$26C2  F0 13     BEQ L_BRS_($26D7)_($26C2) OK
$26C4  85 57     STA $57 
$26C6  20 BF 33  JSR L_JSR_($33BF)_($26C6) OK
$26C9  A5 60     LDA $60 
$26CB  85 2F     STA $2F 
$26CD  A5 57     LDA $57 
$26CF  85 60     STA $60 
$26D1  20 79 32  JSR L_JSR_($3279)_($26D1) OK
$26D4  4C 19 2A  JMP L_JMP_($2A19)_($26D4) OK
//------------------------------
L_BRS_($26D7)_($26C2) OK
//------------------------------
$26D7  A5 2B     LDA $2B 
$26D9  09 10     ORA #$10
$26DB  85 2B     STA $2B 
$26DD  4C EE 26  JMP L_JMP_($26EE)_($26DD) OK
$26E0  20 2E 32  JSR L_JSR_($322E)_($26E0) OK
$26E3  A5 B3     LDA $B3 
$26E5  85 26     STA $26 
$26E7  A9 00     LDA #$00
$26E9  85 B1     STA $B1 
$26EB  20 2E 32  JSR L_JSR_($322E)_($26EB) OK
//------------------------------
L_JMP_($26EE)_($2693) OK
L_BRS_($26EE)_($26BE) OK
L_JMP_($26EE)_($26DD) OK
//------------------------------
$26EE  60        RTS 
//------------------------------
$26EF  AD 7A 87  LDA $877A 
$26F2  09 02     ORA #$02
$26F4  8D 7A 87  STA $877A 
$26F7  AD 61 87  LDA $8761 
$26FA  CD 61 8C  CMP $8C61 
$26FD  D0 0D     BNE L_BRS_($270C)_($26FD) OK
$26FF  AD 62 87  LDA $8762 
$2702  CD 62 8C  CMP $8C62 
$2705  D0 05     BNE L_BRS_($270C)_($2705) OK
$2707  A9 0C     LDA #$0C
$2709  20 B6 31  JSR L_JSR_($31B6)_($2709) OK
//------------------------------
L_BRS_($270C)_($26FD) OK
L_BRS_($270C)_($2705) OK
//------------------------------
$270C  60        RTS 
//------------------------------
L_JSR_($270E)_($9DDA) BAD
L_JSR_($270E)_($ADDA) BAD
L_JSR_($270E)_($DA51) BAD
L_JSR_($270E)_($EA53) BAD
//------------------------------
$270D  A5 26     LDA $26 
$270F  4A        LSR A 
$2710  B0 32     BCS L_BRS_($2744)_($2710) OK
$2712  A5 FD     LDA $FD 
$2714  4A        LSR A 
$2715  4A        LSR A 
$2716  B0 2C     BCS L_BRS_($2744)_($2716) OK
$2718  20 8E 1C  JSR L_JSR_($1C8E)_($2718) OK
$271B  B0 27     BCS L_BRS_($2744)_($271B) OK
$271D  20 59 0E  JSR L_JSR_($0E59)_($271D) OK
$2720  B0 22     BCS L_BRS_($2744)_($2720) OK
$2722  A4 FB     LDY $FB 
$2724  A5 26     LDA $26 
$2726  0A        ASL A 
$2727  B0 08     BCS L_BRS_($2731)_($2727) OK
$2729  A5 FC     LDA $FC 
$272B  38        SEC 
$272C  E9 03     SBC #$03
$272E  4C 36 27  JMP L_JMP_($2736)_($272E) OK
//------------------------------
L_BRS_($2731)_($2727) OK
//------------------------------
$2731  A5 FC     LDA $FC 
$2733  18        CLC 
$2734  69 03     ADC #$03
//------------------------------
L_JMP_($2736)_($272E) OK
//------------------------------
$2736  AA        TAX 
$2737  20 D2 27  JSR L_JSR_($27D2)_($2737) OK
$273A  90 08     BCC L_BRS_($2744)_($273A) OK
$273C  A9 26     LDA #$26
$273E  85 B1     STA $B1 
$2740  A9 7A     LDA #$7A
$2742  85 B0     STA $B0 
//------------------------------
L_BRS_($2744)_($2710) OK
L_BRS_($2744)_($2716) OK
L_BRS_($2744)_($271B) OK
L_BRS_($2744)_($2720) OK
L_BRS_($2744)_($273A) OK
//------------------------------
$2744  60        RTS 
//------------------------------
$2745  A5 3F     LDA $3F 
$2747  29 80     AND #$80
//------------------------------
L_JSR_($2749)_($5BCC) OK
//------------------------------
$2749  F0 03     BEQ L_BRS_($274E)_($2749) OK
$274B  4C 28 1D  JMP L_JMP_($1D28)_($274B) OK
//------------------------------
L_BRS_($274E)_($2749) OK
//------------------------------
$274E  20 91 0D  JSR L_JSR_($0D91)_($274E) OK
$2751  D0 03     BNE L_BRS_($2756)_($2751) OK
$2753  4C B4 0E  JMP L_JMP_($0EB4)_($2753) OK
//------------------------------
L_BRS_($2756)_($2751) OK
//------------------------------
$2756  60        RTS 
//------------------------------
$2757  A5 2B     LDA $2B 
$2759  09 40     ORA #$40
$275B  85 2B     STA $2B 
$275D  A9 60     LDA #$60
$275F  8D B7 1D  STA $1DB7 
$2762  20 E7 3B  JSR L_JSR_($3BE7)_($2762) OK
$2765  85 AC     STA $AC 
$2767  20 E7 3B  JSR L_JSR_($3BE7)_($2767) OK
$276A  85 AD     STA $AD 
$276C  20 77 1F  JSR L_JSR_($1F77)_($276C) OK	; Jump to embedded address 2387
$276F            .byte $87,$23
$2771  A9 AD     LDA #$AD
$2773  8D B7 1D  STA $1DB7 
$2776  20 13 2E  JSR L_JSR_($2E13)_($2776) OK
$2779  4C 03 08  JMP L_JMP_($0803)_($2779) OK
$277C  60        RTS 
//------------------------------
$277D  A9 4C     LDA #$4C
$277F  85 AD     STA $AD 
$2781  A9 00     LDA #$00
$2783  85 AC     STA $AC 
$2785  20 77 1F  JSR L_JSR_($1F77)_($2785) OK	; Jump to embedded address 2387
$2788            .byte $87,$23
$278A  A9 01     LDA #$01
$278C  85 40     STA $40 
$278E  A9 C8     LDA #$C8
$2790  20 4A 1D  JSR L_JSR_($1D4A)_($2790) OK
$2793  4C 2D 1D  JMP L_JMP_($1D2D)_($2793) OK
$2796  60        RTS 
//------------------------------
$2797  A9 00     LDA #$00
$2799  A5 3F     LDA $3F 
$279B  09 02     ORA #$02
$279D  85 3F     STA $3F 
$279F  A9 28     LDA #$28
$27A1  85 3A     STA $3A 
$27A3  A9 73     LDA #$73
$27A5  85 39     STA $39 
$27A7  4C 5B 10  JMP L_JMP_($105B)_($27A7) OK
$27AA  60        RTS 
//------------------------------
$27AB  A5 3F     LDA $3F 
$27AD  29 FC     AND #$FC
$27AF  85 3F     STA $3F 
$27B1  20 E7 3B  JSR L_JSR_($3BE7)_($27B1) OK
$27B4  85 A8     STA $A8 
$27B6  20 E7 3B  JSR L_JSR_($3BE7)_($27B6) OK
$27B9  85 A6     STA $A6 
$27BB  A5 FC     LDA $FC 
$27BD  85 A7     STA $A7 
$27BF  A9 27     LDA #$27
$27C1  85 2A     STA $2A 
$27C3  A9 C7     LDA #$C7
$27C5  85 29     STA $29 
$27C7  C6 A8     DEC $A8 
$27C9  D0 03     BNE L_BRS_($27CE)_($27C9) OK
$27CB  4C 2D 1D  JMP L_JMP_($1D2D)_($27CB) OK
//------------------------------
L_BRS_($27CE)_($27C9) OK
//------------------------------
$27CE  4C 1B 1A  JMP L_JMP_($1A1B)_($27CE) OK
$27D1  60        RTS 
//------------------------------
L_JSR_($27D2)_($180E) OK
L_JSR_($27D2)_($26BB) OK
L_JSR_($27D2)_($2737) OK
//------------------------------
$27D2  A5 26     LDA $26 
$27D4  85 0A     STA $0A 
$27D6  86 0B     STX $0B 
$27D8  84 0C     STY $0C 
$27DA  20 BF 33  JSR L_JSR_($33BF)_($27DA) OK
$27DD  A5 60     LDA $60 
$27DF  48        PHA 
$27E0  A9 14     LDA #$14
$27E2  85 60     STA $60 
$27E4  20 79 32  JSR L_JSR_($3279)_($27E4) OK
$27E7  A5 FB     LDA $FB 
$27E9  C5 0C     CMP $0C 
$27EB  D0 13     BNE L_BRS_($2800)_($27EB) OK
$27ED  A5 FC     LDA $FC 
$27EF  C5 0B     CMP $0B 
$27F1  D0 0D     BNE L_BRS_($2800)_($27F1) OK
$27F3  A5 26     LDA $26 
$27F5  45 0A     EOR $0A 
$27F7  0A        ASL A 
$27F8  90 06     BCC L_BRS_($2800)_($27F8) OK
$27FA  A5 60     LDA $60 
$27FC  38        SEC 
$27FD  4C 3E 28  JMP L_JMP_($283E)_($27FD) OK
//------------------------------
L_BRS_($2800)_($27EB) OK
L_BRS_($2800)_($27F1) OK
L_BRS_($2800)_($27F8) OK
//------------------------------
$2800  A9 0F     LDA #$0F
$2802  85 60     STA $60 
//------------------------------
L_JMP_($2804)_($282E) OK
L_JMP_($2804)_($283B) OK
//------------------------------
$2804  20 79 32  JSR L_JSR_($3279)_($2804) OK
$2807  A5 FB     LDA $FB 
$2809  C5 0C     CMP $0C 
$280B  D0 17     BNE L_BRS_($2824)_($280B) OK
$280D  A5 FC     LDA $FC 
$280F  C5 0B     CMP $0B 
$2811  D0 11     BNE L_BRS_($2824)_($2811) OK
$2813  A5 B1     LDA $B1 
$2815  D0 0D     BNE L_BRS_($2824)_($2815) OK
$2817  A5 26     LDA $26 
$2819  45 0A     EOR $0A 
$281B  0A        ASL A 
$281C  90 06     BCC L_BRS_($2824)_($281C) OK
$281E  A5 60     LDA $60 
$2820  38        SEC 
$2821  4C 3E 28  JMP L_JMP_($283E)_($2821) OK
//------------------------------
L_BRS_($2824)_($280B) OK
L_BRS_($2824)_($2811) OK
L_BRS_($2824)_($2815) OK
L_BRS_($2824)_($281C) OK
//------------------------------
$2824  A5 60     LDA $60 
$2826  C9 11     CMP #$11
$2828  D0 07     BNE L_BRS_($2831)_($2828) OK
$282A  A9 00     LDA #$00
$282C  85 60     STA $60 
$282E  4C 04 28  JMP L_JMP_($2804)_($282E) OK
//------------------------------
L_BRS_($2831)_($2828) OK
//------------------------------
$2831  C9 0A     CMP #$0A
$2833  D0 04     BNE L_BRS_($2839)_($2833) OK
$2835  18        CLC 
$2836  4C 3E 28  JMP L_JMP_($283E)_($2836) OK
//------------------------------
L_BRS_($2839)_($2833) OK
//------------------------------
$2839  E6 60     INC $60 
$283B  4C 04 28  JMP L_JMP_($2804)_($283B) OK
//------------------------------
L_JMP_($283E)_($27FD) OK
L_JMP_($283E)_($2821) OK
L_JMP_($283E)_($2836) OK
//------------------------------
$283E  85 57     STA $57 
$2840  2A        ROL A 
$2841  85 56     STA $56 
$2843  68        PLA 
$2844  85 60     STA $60 
$2846  20 79 32  JSR L_JSR_($3279)_($2846) OK
$2849  A5 56     LDA $56 
$284B  4A        LSR A 
$284C  A5 57     LDA $57 
$284E  60        RTS 
//------------------------------
$284F  A5 3F     LDA $3F 
$2851  09 02     ORA #$02
$2853  85 3F     STA $3F 
$2855  20 E7 3B  JSR L_JSR_($3BE7)_($2855) OK
$2858  85 A6     STA $A6 
$285A  AA        TAX 
$285B  20 E7 3B  JSR L_JSR_($3BE7)_($285B) OK
$285E  85 A7     STA $A7 
$2860  A8        TAY 
$2861  4C C7 12  JMP L_JMP_($12C7)_($2861) OK
$2864  60        RTS 
//------------------------------
$2865  20 E7 3B  JSR L_JSR_($3BE7)_($2865) OK
$2868  85 39     STA $39 
$286A  20 E7 3B  JSR L_JSR_($3BE7)_($286A) OK
$286D  85 3A     STA $3A 
$286F  4C D2 3B  JMP L_JMP_($3BD2)_($286F) OK
$2872  60        RTS 
//------------------------------
$2873  A5 26     LDA $26 
$2875  4A        LSR A 
$2876  B0 0C     BCS L_BRS_($2884)_($2876) OK
$2878  20 8E 1C  JSR L_JSR_($1C8E)_($2878) OK
$287B  B0 07     BCS L_BRS_($2884)_($287B) OK
$287D  A6 FC     LDX $FC 
$287F  A4 FB     LDY $FB 
$2881  4C C8 29  JMP L_JMP_($29C8)_($2881) OK
//------------------------------
L_BRS_($2884)_($2876) OK
L_BRS_($2884)_($287B) OK
//------------------------------
$2884  60        RTS 
//------------------------------
$2885  A5 3F     LDA $3F 
$2887  09 02     ORA #$02
$2889  85 3F     STA $3F 
$288B  AD 7C 78  LDA $787C 
$288E  C9 28     CMP #$28
$2890  D0 18     BNE L_BRS_($28AA)_($2890) OK
$2892  AD 7B 78  LDA $787B 
$2895  C9 73     CMP #$73
$2897  D0 11     BNE L_BRS_($28AA)_($2897) OK
$2899  A9 28     LDA #$28
$289B  85 3A     STA $3A 
$289D  A9 73     LDA #$73
$289F  85 39     STA $39 
$28A1  AE 65 78  LDX $7865 
$28A4  AC 66 78  LDY $7866 
$28A7  4C 83 10  JMP L_JMP_($1083)_($28A7) OK
//------------------------------
L_BRS_($28AA)_($2890) OK
L_BRS_($28AA)_($2897) OK
//------------------------------
$28AA  60        RTS 
//------------------------------
$28AB  20 E7 3B  JSR L_JSR_($3BE7)_($28AB) OK
$28AE  20 D2 31  JSR L_JSR_($31D2)_($28AE) OK
$28B1  B0 05     BCS L_BRS_($28B8)_($28B1) OK
$28B3  20 77 1F  JSR L_JSR_($1F77)_($28B3) OK	; Jump to embedded address 1129
$28B6  29 11     AND #$11
//------------------------------
L_BRS_($28B8)_($28B1) OK
//------------------------------
$28B8  4C 2D 1D  JMP L_JMP_($1D2D)_($28B8) OK
$28BB  60        RTS 
//------------------------------
$28BC  A5 2B     LDA $2B 
$28BE  09 40     ORA #$40
$28C0  85 2B     STA $2B 
$28C2  20 E7 3B  JSR L_JSR_($3BE7)_($28C2) OK
$28C5  85 A6     STA $A6 
$28C7  20 E7 3B  JSR L_JSR_($3BE7)_($28C7) OK
$28CA  85 A7     STA $A7 
//------------------------------
L_JMP_($28CC)_($290B) OK
//------------------------------
$28CC  A9 FF     LDA #$FF
$28CE  85 40     STA $40 
$28D0  A5 A6     LDA $A6 
$28D2  85 AC     STA $AC 
$28D4  A5 A7     LDA $A7 
$28D6  85 AD     STA $AD 
$28D8  20 77 1F  JSR L_JSR_($1F77)_($28D8) OK	; Jump to embedded address 2387
$28DB            .byte $87,$23
$28DD  A5 2B     LDA $2B 
$28DF  09 20     ORA #$20
$28E1  85 2B     STA $2B 
$28E3  A9 46     LDA #$46
$28E5  85 AD     STA $AD 
$28E7  A9 20     LDA #$20
$28E9  85 AC     STA $AC 
$28EB  A9 28     LDA #$28
$28ED  85 A9     STA $A9 
$28EF  20 77 1F  JSR L_JSR_($1F77)_($28EF) OK	; Jump to embedded address 2387
$28F2            .byte $87,$23
$28F4  A5 2B     LDA $2B 
$28F6  0A        ASL A 
$28F7  0A        ASL A 
$28F8  B0 07     BCS L_BRS_($2901)_($28F8) OK
$28FA  A9 0F     LDA #$0F
$28FC  85 40     STA $40 
$28FE  4C 2D 1D  JMP L_JMP_($1D2D)_($28FE) OK
//------------------------------
L_BRS_($2901)_($28F8) OK
//------------------------------
$2901  C6 A9     DEC $A9 
$2903  D0 09     BNE L_BRS_($290E)_($2903) OK
$2905  A5 2B     LDA $2B 
$2907  29 DF     AND #$DF
$2909  85 2B     STA $2B 
$290B  4C CC 28  JMP L_JMP_($28CC)_($290B) OK
//------------------------------
L_BRS_($290E)_($2903) OK
//------------------------------
$290E  60        RTS 
//------------------------------
L_JSR_($290F)_($15C3) OK
//------------------------------
$290F  A5 2B     LDA $2B 
$2911  0A        ASL A 
$2912  0A        ASL A 
$2913  0A        ASL A 
$2914  90 18     BCC L_BRS_($292E)_($2914) OK
$2916  A5 4C     LDA $4C 
$2918  85 C5     STA $C5 
$291A  A9 00     LDA #$00
$291C  85 4C     STA $4C 
$291E  A5 C5     LDA $C5 
$2920  F0 0C     BEQ L_BRS_($292E)_($2920) OK
$2922  29 5F     AND #$5F
$2924  C9 55     CMP #$55
$2926  D0 06     BNE L_BRS_($292E)_($2926) OK
$2928  A5 2B     LDA $2B 
$292A  29 8F     AND #$8F
$292C  85 2B     STA $2B 
//------------------------------
L_BRS_($292E)_($2914) OK
L_BRS_($292E)_($2920) OK
L_BRS_($292E)_($2926) OK
//------------------------------
$292E  60        RTS 
//------------------------------
L_JSR_($292F)_($2C62) OK
L_JSR_($292F)_($2E78) OK
//------------------------------
$292F  A2 04     LDX #$04
//------------------------------
L_BRS_($2931)_($293B) OK
L_BRS_($2931)_($293F) OK
L_BRS_($2931)_($2946) OK
//------------------------------
$2931  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$2934  29 1F     AND #$1F
$2936  18        CLC 
$2937  69 41     ADC #$41
$2939  C9 5B     CMP #$5B
$293B  B0 F4     BCS L_BRS_($2931)_($293B) OK
$293D  D5 90     CMP $90,X 
$293F  F0 F0     BEQ L_BRS_($2931)_($293F) OK
$2941  CA        DEX 
$2942  95 90     STA $90,X 
$2944  95 4E     STA $4E,X 
$2946  D0 E9     BNE L_BRS_($2931)_($2946) OK
$2948  A9 0A     LDA #$0A
$294A  85 55     STA $55 
//------------------------------
L_BRS_($294C)_($297D) OK
//------------------------------
$294C  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$294F  29 03     AND #$03
$2951  D0 02     BNE L_BRS_($2955)_($2951) OK
$2953  A9 01     LDA #$01
//------------------------------
L_BRS_($2955)_($2951) OK
//------------------------------
$2955  85 56     STA $56 
$2957  E8        INX 
$2958  85 FD     STA $FD 
$295A  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$295D  29 03     AND #$03
$295F  D0 02     BNE L_BRS_($2963)_($295F) OK
$2961  A9 01     LDA #$01
//------------------------------
L_BRS_($2963)_($295F) OK
//------------------------------
$2963  85 57     STA $57 
$2965  A6 57     LDX $57 
$2967  B5 4E     LDA $4E,X 
$2969  85 54     STA $54 
$296B  A6 56     LDX $56 
$296D  B5 4E     LDA $4E,X 
$296F  A6 57     LDX $57 
$2971  95 4E     STA $4E,X 
$2973  A6 56     LDX $56 
$2975  A5 54     LDA $54 
$2977  95 4E     STA $4E,X 
$2979  C6 55     DEC $55 
$297B  A5 55     LDA $55 
$297D  D0 CD     BNE L_BRS_($294C)_($297D) OK
$297F  A2 00     LDX #$00
//------------------------------
L_BRS_($2981)_($2988) OK
//------------------------------
$2981  B5 4E     LDA $4E,X 
$2983  95 03     STA $03,X 
$2985  E8        INX 
$2986  E0 04     CPX #$04
$2988  D0 F7     BNE L_BRS_($2981)_($2988) OK
$298A  60        RTS 
//------------------------------
L_JSR_($298B)_($2A70) OK
//------------------------------
$298B  A5 60     LDA $60 
$298D  C9 0B     CMP #$0B
$298F  90 36     BCC L_BRS_($29C7)_($298F) OK
$2991  C9 0E     CMP #$0E
$2993  B0 32     BCS L_BRS_($29C7)_($2993) OK
//------------------------------
L_JMP_($2995)_($1F37) OK
//------------------------------
$2995  38        SEC 
$2996  E9 0B     SBC #$0B
$2998  AA        TAX 
$2999  B5 03     LDA $03,X 
$299B  8D 40 46  STA $4640 
$299E  A9 46     LDA #$46
$29A0  85 87     STA $87 
$29A2  A9 46     LDA #$46
$29A4  85 89     STA $89 
$29A6  A9 20     LDA #$20
$29A8  8D 42 46  STA $4642 
$29AB  A9 40     LDA #$40
$29AD  85 86     STA $86 
$29AF  A9 42     LDA #$42
$29B1  85 88     STA $88 
$29B3  AD 15 D0  LDA $D015                          // Sprite display Enable
$29B6  85 F6     STA $F6 
$29B8  F0 03     BEQ L_BRS_($29BD)_($29B8) OK
$29BA  20 AC 38  JSR L_JSR_($38AC)_($29BA) OK
//------------------------------
L_BRS_($29BD)_($29B8) OK
//------------------------------
$29BD  20 43 20  JSR L_JSR_($2043)_($29BD) OK
$29C0  A5 F6     LDA $F6 
$29C2  F0 03     BEQ L_BRS_($29C7)_($29C2) OK
$29C4  20 EF 38  JSR L_JSR_($38EF)_($29C4) OK
//------------------------------
L_BRS_($29C7)_($298F) OK
L_BRS_($29C7)_($2993) OK
L_BRS_($29C7)_($29C2) OK
//------------------------------
$29C7  60        RTS 
//------------------------------
L_JSR_($29C8)_($1011) OK
L_JMP_($29C8)_($2881) OK
//------------------------------
$29C8  EC 61 8C  CPX $8C61 
$29CB  D0 15     BNE L_BRS_($29E2)_($29CB) OK
$29CD  CC 62 8C  CPY $8C62 
$29D0  D0 10     BNE L_BRS_($29E2)_($29D0) OK
$29D2  A5 2B     LDA $2B 
$29D4  09 10     ORA #$10
$29D6  85 2B     STA $2B 
$29D8  A9 00     LDA #$00
$29DA  85 14     STA $14 
$29DC  A9 14     LDA #$14
$29DE  38        SEC 
$29DF  4C 42 2A  JMP L_JMP_($2A42)_($29DF) OK
//------------------------------
L_BRS_($29E2)_($29CB) OK
L_BRS_($29E2)_($29D0) OK
//------------------------------
$29E2  86 0B     STX $0B 
$29E4  84 0C     STY $0C 
$29E6  20 BF 33  JSR L_JSR_($33BF)_($29E6) OK
$29E9  A5 60     LDA $60 
$29EB  85 2F     STA $2F 
$29ED  A9 0B     LDA #$0B
$29EF  85 60     STA $60 
//------------------------------
L_JMP_($29F1)_($2A08) OK
//------------------------------
$29F1  20 79 32  JSR L_JSR_($3279)_($29F1) OK
$29F4  A5 FC     LDA $FC 
$29F6  C5 0B     CMP $0B 
$29F8  D0 06     BNE L_BRS_($2A00)_($29F8) OK
$29FA  A5 FB     LDA $FB 
$29FC  C5 0C     CMP $0C 
$29FE  F0 0B     BEQ L_BRS_($2A0B)_($29FE) OK
//------------------------------
L_BRS_($2A00)_($29F8) OK
L_BRS_($2A00)_($2A13) OK
//------------------------------
$2A00  A5 60     LDA $60 
$2A02  C9 11     CMP #$11
$2A04  F0 28     BEQ L_BRS_($2A2E)_($2A04) OK
$2A06  E6 60     INC $60 
$2A08  4C F1 29  JMP L_JMP_($29F1)_($2A08) OK
//------------------------------
L_BRS_($2A0B)_($29FE) OK
//------------------------------
$2A0B  A5 B1     LDA $B1 
$2A0D  F0 0A     BEQ L_BRS_($2A19)_($2A0D) OK
$2A0F  A5 60     LDA $60 
$2A11  C9 0F     CMP #$0F
$2A13  B0 EB     BCS L_BRS_($2A00)_($2A13) OK
$2A15  18        CLC 
$2A16  4C 31 2A  JMP L_JMP_($2A31)_($2A16) OK
//------------------------------
L_JSR_($2A19)_($182C) OK
L_JMP_($2A19)_($26D4) OK
L_BRS_($2A19)_($2A0D) OK
//------------------------------
$2A19  A9 2A     LDA #$2A
$2A1B  85 B1     STA $B1 
$2A1D  A9 43     LDA #$43
$2A1F  85 B0     STA $B0 
$2A21  A9 14     LDA #$14
$2A23  85 B2     STA $B2 
$2A25  20 BF 33  JSR L_JSR_($33BF)_($2A25) OK
$2A28  A5 60     LDA $60 
$2A2A  38        SEC 
$2A2B  4C 31 2A  JMP L_JMP_($2A31)_($2A2B) OK
//------------------------------
L_BRS_($2A2E)_($2A04) OK
//------------------------------
$2A2E  A9 00     LDA #$00
$2A30  18        CLC 
//------------------------------
L_JMP_($2A31)_($2A16) OK
L_JMP_($2A31)_($2A2B) OK
//------------------------------
$2A31  85 57     STA $57 
$2A33  2A        ROL A 
$2A34  85 56     STA $56 
$2A36  A5 2F     LDA $2F 
$2A38  85 60     STA $60 
$2A3A  20 79 32  JSR L_JSR_($3279)_($2A3A) OK
$2A3D  A5 56     LDA $56 
$2A3F  6A        ROR A 
$2A40  A5 57     LDA $57 
//------------------------------
L_JMP_($2A42)_($29DF) OK
//------------------------------
$2A42  60        RTS 
//------------------------------
$2A43  C6 B2     DEC $B2 
$2A45  D0 03     BNE L_BRS_($2A4A)_($2A45) OK
$2A47  4C 32 1D  JMP L_JMP_($1D32)_($2A47) OK
//------------------------------
L_BRS_($2A4A)_($2A45) OK
//------------------------------
$2A4A  A5 B2     LDA $B2 
$2A4C  C9 13     CMP #$13
$2A4E  D0 16     BNE L_BRS_($2A66)_($2A4E) OK
$2A50  A5 26     LDA $26 
$2A52  85 B3     STA $B3 
$2A54  20 2E 32  JSR L_JSR_($322E)_($2A54) OK
$2A57  A5 26     LDA $26 
$2A59  29 F8     AND #$F8
$2A5B  18        CLC 
$2A5C  69 07     ADC #$07
$2A5E  85 26     STA $26 
$2A60  20 2E 32  JSR L_JSR_($322E)_($2A60) OK
$2A63  4C 98 2A  JMP L_JMP_($2A98)_($2A63) OK
//------------------------------
L_BRS_($2A66)_($2A4E) OK
//------------------------------
$2A66  C9 12     CMP #$12
$2A68  D0 0C     BNE L_BRS_($2A76)_($2A68) OK
$2A6A  A5 46     LDA $46 
$2A6C  C9 02     CMP #$02
$2A6E  D0 28     BNE L_BRS_($2A98)_($2A6E) OK
$2A70  20 8B 29  JSR L_JSR_($298B)_($2A70) OK
$2A73  4C 98 2A  JMP L_JMP_($2A98)_($2A73) OK
//------------------------------
L_BRS_($2A76)_($2A68) OK
//------------------------------
$2A76  C9 01     CMP #$01
$2A78  D0 0D     BNE L_BRS_($2A87)_($2A78) OK
$2A7A  20 2E 32  JSR L_JSR_($322E)_($2A7A) OK
$2A7D  A5 B3     LDA $B3 
$2A7F  85 26     STA $26 
$2A81  20 2E 32  JSR L_JSR_($322E)_($2A81) OK
$2A84  4C 98 2A  JMP L_JMP_($2A98)_($2A84) OK
//------------------------------
L_BRS_($2A87)_($2A78) OK
//------------------------------
$2A87  C9 09     CMP #$09
$2A89  D0 0D     BNE L_BRS_($2A98)_($2A89) OK
$2A8B  A5 60     LDA $60 
$2A8D  C9 0B     CMP #$0B
$2A8F  90 07     BCC L_BRS_($2A98)_($2A8F) OK
$2A91  C9 0F     CMP #$0F
$2A93  B0 03     BCS L_BRS_($2A98)_($2A93) OK
$2A95  4C CF 0E  JMP L_JMP_($0ECF)_($2A95) OK
//------------------------------
L_JMP_($2A98)_($2A63) OK
L_BRS_($2A98)_($2A6E) OK
L_JMP_($2A98)_($2A73) OK
L_JMP_($2A98)_($2A84) OK
L_BRS_($2A98)_($2A89) OK
L_BRS_($2A98)_($2A8F) OK
L_BRS_($2A98)_($2A93) OK
//------------------------------
$2A98  60        RTS 
//------------------------------
$2A99  A9 0C     LDA #$0C
$2A9B  85 AF     STA $AF 
$2A9D  A9 31     LDA #$31
$2A9F  85 AE     STA $AE 
$2AA1  20 77 1F  JSR L_JSR_($1F77)_($2AA1) OK	; Jump to embedded address 0C3F
$2AA4            .byte $3F,$0C
$2AA6  4C 2D 1D  JMP L_JMP_($1D2D)_($2AA6) OK
$2AA9  60        RTS 
//------------------------------
L_BRS_($2AAA)_($2AAF) OK
L_JSR_($2AAA)_($2C65) OK
L_JSR_($2AAA)_($2E75) OK
//------------------------------
$2AAA  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$2AAD  C9 15     CMP #$15
$2AAF  B0 F9     BCS L_BRS_($2AAA)_($2AAF) OK
$2AB1  0A        ASL A 
$2AB2  18        CLC 
$2AB3  69 D5     ADC #$D5
$2AB5  85 A5     STA $A5 
$2AB7  38        SEC 
$2AB8  E9 01     SBC #$01
$2ABA  48        PHA 
$2ABB  A9 4D     LDA #$4D
$2ABD  85 1E     STA $1E 
$2ABF  68        PLA 
$2AC0  29 7F     AND #$7F
$2AC2  C9 16     CMP #$16
$2AC4  90 1A     BCC L_BRS_($2AE0)_($2AC4) OK
$2AC6  E6 1E     INC $1E 
$2AC8  C9 2B     CMP #$2B
$2ACA  90 14     BCC L_BRS_($2AE0)_($2ACA) OK
$2ACC  E6 1E     INC $1E 
$2ACE  C9 40     CMP #$40
$2AD0  90 0E     BCC L_BRS_($2AE0)_($2AD0) OK
$2AD2  E6 1E     INC $1E 
$2AD4  C9 56     CMP #$56
$2AD6  90 08     BCC L_BRS_($2AE0)_($2AD6) OK
$2AD8  E6 1E     INC $1E 
$2ADA  C9 6B     CMP #$6B
$2ADC  90 02     BCC L_BRS_($2AE0)_($2ADC) OK
$2ADE  E6 1E     INC $1E 
//------------------------------
L_BRS_($2AE0)_($2AC4) OK
L_BRS_($2AE0)_($2ACA) OK
L_BRS_($2AE0)_($2AD0) OK
L_BRS_($2AE0)_($2AD6) OK
L_BRS_($2AE0)_($2ADC) OK
//------------------------------
$2AE0  0A        ASL A 
$2AE1  0A        ASL A 
$2AE2  85 57     STA $57 
$2AE4  0A        ASL A 
$2AE5  18        CLC 
$2AE6  65 57     ADC $57 
$2AE8  85 1D     STA $1D 
$2AEA  A0 00     LDY #$00
$2AEC  A2 00     LDX #$00
//------------------------------
L_BRS_($2AEE)_($2AF6) OK
//------------------------------
$2AEE  B1 1D     LDA ($1D),Y 
$2AF0  95 94     STA $94,X 
$2AF2  E8        INX 
$2AF3  C8        INY 
$2AF4  C0 04     CPY #$04
$2AF6  D0 F6     BNE L_BRS_($2AEE)_($2AF6) OK
$2AF8  60        RTS 
//------------------------------
$2AF9  20 E7 3B  JSR L_JSR_($3BE7)_($2AF9) OK
$2AFC  A8        TAY 
$2AFD  A9 44     LDA #$44
$2AFF  85 57     STA $57 
$2B01  A9 00     LDA #$00
$2B03  85 56     STA $56 
$2B05  A9 FF     LDA #$FF
$2B07  91 56     STA ($56),Y 
$2B09  4C 2D 1D  JMP L_JMP_($1D2D)_($2B09) OK
$2B0C  60        RTS 
//------------------------------
$2B0D  20 E7 3B  JSR L_JSR_($3BE7)_($2B0D) OK
$2B10  A8        TAY 
$2B11  A9 44     LDA #$44
$2B13  85 57     STA $57 
$2B15  A9 00     LDA #$00
$2B17  85 56     STA $56 
$2B19  A9 00     LDA #$00
$2B1B  91 56     STA ($56),Y 
$2B1D  4C 2D 1D  JMP L_JMP_($1D2D)_($2B1D) OK
$2B20  60        RTS 
//------------------------------
$2B21  A5 26     LDA $26 
$2B23  85 B3     STA $B3 
$2B25  A9 2B     LDA #$2B
$2B27  85 B1     STA $B1 
$2B29  A9 3F     LDA #$3F
$2B2B  85 B0     STA $B0 
$2B2D  20 2E 32  JSR L_JSR_($322E)_($2B2D) OK
$2B30  A5 26     LDA $26 
$2B32  29 80     AND #$80
$2B34  18        CLC 
$2B35  69 38     ADC #$38
$2B37  85 26     STA $26 
$2B39  20 2E 32  JSR L_JSR_($322E)_($2B39) OK
$2B3C  4C AF 2B  JMP L_JMP_($2BAF)_($2B3C) OK
$2B3F  A9 2B     LDA #$2B
$2B41  85 B1     STA $B1 
$2B43  A9 52     LDA #$52
$2B45  85 B0     STA $B0 
//------------------------------
L_JMP_($2B47)_($17F2) OK
L_JMP_($2B47)_($193B) OK
//------------------------------
$2B47  20 2E 32  JSR L_JSR_($322E)_($2B47) OK
$2B4A  E6 26     INC $26 
$2B4C  20 2E 32  JSR L_JSR_($322E)_($2B4C) OK
$2B4F  4C AF 2B  JMP L_JMP_($2BAF)_($2B4F) OK
$2B52  A9 2B     LDA #$2B
$2B54  85 B1     STA $B1 
$2B56  A9 9F     LDA #$9F
$2B58  85 B0     STA $B0 
$2B5A  A9 12     LDA #$12
$2B5C  85 DC     STA $DC 
$2B5E  A9 10     LDA #$10
$2B60  85 DB     STA $DB 
//------------------------------
L_JSR_($2B62)_($1954) OK
//------------------------------
$2B62  A5 26     LDA $26 
$2B64  85 0A     STA $0A 
$2B66  A5 FC     LDA $FC 
$2B68  85 0B     STA $0B 
$2B6A  A5 FB     LDA $FB 
$2B6C  85 0C     STA $0C 
$2B6E  20 BF 33  JSR L_JSR_($33BF)_($2B6E) OK
$2B71  A5 DC     LDA $DC 
$2B73  85 60     STA $60 
$2B75  20 79 32  JSR L_JSR_($3279)_($2B75) OK
$2B78  A9 0F     LDA #$0F
$2B7A  85 B1     STA $B1 
$2B7C  A9 BA     LDA #$BA
$2B7E  85 B0     STA $B0 
$2B80  A9 0D     LDA #$0D
$2B82  85 B2     STA $B2 
$2B84  A5 0B     LDA $0B 
$2B86  85 FC     STA $FC 
$2B88  A5 0C     LDA $0C 
$2B8A  85 FB     STA $FB 
$2B8C  A5 0A     LDA $0A 
$2B8E  09 7F     ORA #$7F
$2B90  85 26     STA $26 
$2B92  20 BF 33  JSR L_JSR_($33BF)_($2B92) OK
$2B95  A5 DB     LDA $DB 
$2B97  85 60     STA $60 
$2B99  20 79 32  JSR L_JSR_($3279)_($2B99) OK
$2B9C  4C AF 2B  JMP L_JMP_($2BAF)_($2B9C) OK
$2B9F  A9 26     LDA #$26
$2BA1  85 B1     STA $B1 
$2BA3  A9 E0     LDA #$E0
$2BA5  85 B0     STA $B0 
//------------------------------
L_JMP_($2BA7)_($18C9) OK
L_JMP_($2BA7)_($1942) OK
//------------------------------
$2BA7  20 2E 32  JSR L_JSR_($322E)_($2BA7) OK
$2BAA  C6 26     DEC $26 
$2BAC  20 2E 32  JSR L_JSR_($322E)_($2BAC) OK
//------------------------------
L_JMP_($2BAF)_($2B3C) OK
L_JMP_($2BAF)_($2B4F) OK
L_JMP_($2BAF)_($2B9C) OK
//------------------------------
$2BAF  60        RTS 
//------------------------------
L_JMP_($2BB0)_($1057) OK
L_JMP_($2BB0)_($1794) OK
//------------------------------
$2BB0  86 56     STX $56 
$2BB2  84 57     STY $57 
$2BB4  A9 58     LDA #$58
$2BB6  85 4F     STA $4F 
$2BB8  A9 E0     LDA #$E0
$2BBA  85 4E     STA $4E 
$2BBC  A0 2B     LDY #$2B
//------------------------------
L_JMP_($2BBE)_($2BCB) OK
L_JMP_($2BBE)_($2BDE) OK
//------------------------------
$2BBE  B1 4E     LDA ($4E),Y 
$2BC0  C5 57     CMP $57 
$2BC2  F0 0D     BEQ L_BRS_($2BD1)_($2BC2) OK
$2BC4  C0 01     CPY #$01
$2BC6  F0 06     BEQ L_BRS_($2BCE)_($2BC6) OK
$2BC8  88        DEY 
$2BC9  88        DEY 
$2BCA  88        DEY 
$2BCB  4C BE 2B  JMP L_JMP_($2BBE)_($2BCB) OK
//------------------------------
L_BRS_($2BCE)_($2BC6) OK
L_BRS_($2BCE)_($2BDA) OK
//------------------------------
$2BCE  4C A4 2C  JMP L_JMP_($2CA4)_($2BCE) OK
//------------------------------
L_BRS_($2BD1)_($2BC2) OK
//------------------------------
$2BD1  88        DEY 
$2BD2  B1 4E     LDA ($4E),Y 
$2BD4  C5 56     CMP $56 
$2BD6  F0 09     BEQ L_BRS_($2BE1)_($2BD6) OK
$2BD8  C0 00     CPY #$00
$2BDA  F0 F2     BEQ L_BRS_($2BCE)_($2BDA) OK
$2BDC  88        DEY 
$2BDD  88        DEY 
$2BDE  4C BE 2B  JMP L_JMP_($2BBE)_($2BDE) OK
//------------------------------
L_BRS_($2BE1)_($2BD6) OK
//------------------------------
$2BE1  A5 46     LDA $46 
$2BE3  C9 01     CMP #$01
$2BE5  F0 17     BEQ L_BRS_($2BFE)_($2BE5) OK
$2BE7  C9 03     CMP #$03
$2BE9  F0 03     BEQ L_BRS_($2BEE)_($2BE9) OK
$2BEB  4C A0 2C  JMP L_JMP_($2CA0)_($2BEB) OK
//------------------------------
L_BRS_($2BEE)_($2BE9) OK
//------------------------------
$2BEE  C8        INY 
$2BEF  C8        INY 
$2BF0  B1 4E     LDA ($4E),Y 
$2BF2  D0 03     BNE L_BRS_($2BF7)_($2BF2) OK
$2BF4  4C A0 2C  JMP L_JMP_($2CA0)_($2BF4) OK
//------------------------------
L_BRS_($2BF7)_($2BF2) OK
//------------------------------
$2BF7  A9 00     LDA #$00
$2BF9  91 4E     STA ($4E),Y 
$2BFB  4C 0B 2C  JMP L_JMP_($2C0B)_($2BFB) OK
//------------------------------
L_BRS_($2BFE)_($2BE5) OK
//------------------------------
$2BFE  C8        INY 
$2BFF  C8        INY 
$2C00  B1 4E     LDA ($4E),Y 
$2C02  F0 03     BEQ L_BRS_($2C07)_($2C02) OK
$2C04  4C A0 2C  JMP L_JMP_($2CA0)_($2C04) OK
//------------------------------
L_BRS_($2C07)_($2C02) OK
//------------------------------
$2C07  A9 01     LDA #$01
$2C09  91 4E     STA ($4E),Y 
//------------------------------
L_JMP_($2C0B)_($2BFB) OK
//------------------------------
$2C0B  A5 57     LDA $57 
$2C0D  C9 07     CMP #$07
$2C0F  90 0E     BCC L_BRS_($2C1F)_($2C0F) OK
$2C11  C9 0E     CMP #$0E
$2C13  90 05     BCC L_BRS_($2C1A)_($2C13) OK
$2C15  A9 28     LDA #$28
$2C17  4C 21 2C  JMP L_JMP_($2C21)_($2C17) OK
//------------------------------
L_BRS_($2C1A)_($2C13) OK
//------------------------------
$2C1A  A9 14     LDA #$14
$2C1C  4C 21 2C  JMP L_JMP_($2C21)_($2C1C) OK
//------------------------------
L_BRS_($2C1F)_($2C0F) OK
//------------------------------
$2C1F  A9 0A     LDA #$0A
//------------------------------
L_JMP_($2C21)_($2C17) OK
L_JMP_($2C21)_($2C1C) OK
//------------------------------
$2C21  20 37 1D  JSR L_JSR_($1D37)_($2C21) OK
$2C24  A9 01     LDA #$01
$2C26  85 2C     STA $2C 
$2C28  A9 11     LDA #$11
$2C2A  85 2D     STA $2D 
$2C2C  E6 D9     INC $D9 
$2C2E  A5 D9     LDA $D9 
$2C30  C9 0F     CMP #$0F
$2C32  F0 03     BEQ L_BRS_($2C37)_($2C32) OK
$2C34  4C A0 2C  JMP L_JMP_($2CA0)_($2C34) OK
//------------------------------
L_JMP_($2C37)_($17E1) OK
L_BRS_($2C37)_($2C32) OK
//------------------------------
$2C37  A9 00     LDA #$00
$2C39  85 D9     STA $D9 
$2C3B  E6 46     INC $46 
$2C3D  A5 46     LDA $46 
$2C3F  C9 04     CMP #$04
$2C41  F0 14     BEQ L_BRS_($2C57)_($2C41) OK
$2C43  C9 02     CMP #$02
$2C45  F0 05     BEQ L_BRS_($2C4C)_($2C45) OK
$2C47  A9 C8     LDA #$C8
$2C49  4C 4E 2C  JMP L_JMP_($2C4E)_($2C49) OK
//------------------------------
L_BRS_($2C4C)_($2C45) OK
//------------------------------
$2C4C  A9 64     LDA #$64
//------------------------------
L_JMP_($2C4E)_($2C49) OK
//------------------------------
$2C4E  20 37 1D  JSR L_JSR_($1D37)_($2C4E) OK
$2C51  20 48 BA  JSR L_JSR_($BA48)_($2C51) OK
$2C54  4C A0 2C  JMP L_JMP_($2CA0)_($2C54) OK
//------------------------------
L_BRS_($2C57)_($2C41) OK
//------------------------------
$2C57  A9 01     LDA #$01
$2C59  85 46     STA $46 
$2C5B  E6 7D     INC $7D 
$2C5D  A9 F4     LDA #$F4
$2C5F  20 37 1D  JSR L_JSR_($1D37)_($2C5F) OK
$2C62  20 2F 29  JSR L_JSR_($292F)_($2C62) OK
$2C65  20 AA 2A  JSR L_JSR_($2AAA)_($2C65) OK
$2C68  A9 08     LDA #$08
$2C6A  85 9D     STA $9D 
$2C6C  A9 46     LDA #$46
$2C6E  85 D7     STA $D7 
$2C70  A9 80     LDA #$80
$2C72  85 D6     STA $D6 
$2C74  20 05 20  JSR L_JSR_($2005)_($2C74) OK
$2C77  20 3B 21  JSR L_JSR_($213B)_($2C77) OK
$2C7A  A2 10     LDX #$10
$2C7C  A0 15     LDY #$15
$2C7E  20 68 38  JSR L_JSR_($3868)_($2C7E) OK
$2C81  A9 90     LDA #$90
$2C83  85 D6     STA $D6 
$2C85  20 05 20  JSR L_JSR_($2005)_($2C85) OK
$2C88  20 3B 21  JSR L_JSR_($213B)_($2C88) OK
$2C8B  A2 10     LDX #$10
$2C8D  A0 17     LDY #$17
$2C8F  20 68 38  JSR L_JSR_($3868)_($2C8F) OK
$2C92  A9 00     LDA #$00
$2C94  85 D5     STA $D5 
$2C96  A9 01     LDA #$01
$2C98  85 40     STA $40 
$2C9A  85 FD     STA $FD 
$2C9C  20 00 BA  JSR L_JSR_($BA00)_($2C9C) OK
$2C9F  60        RTS 
//------------------------------
L_JMP_($2CA0)_($2BEB) OK
L_JMP_($2CA0)_($2BF4) OK
L_JMP_($2CA0)_($2C04) OK
L_JMP_($2CA0)_($2C34) OK
L_JMP_($2CA0)_($2C54) OK
//------------------------------
$2CA0  A9 01     LDA #$01
$2CA2  85 B2     STA $B2 
//------------------------------
L_JMP_($2CA4)_($2BCE) OK
//------------------------------
$2CA4  60        RTS 
//------------------------------
$2CA5  A5 FC     LDA $FC 
$2CA7  29 03     AND #$03
$2CA9  D0 2C     BNE L_BRS_($2CD7)_($2CA9) OK
$2CAB  A5 26     LDA $26 
$2CAD  4A        LSR A 
$2CAE  B0 27     BCS L_BRS_($2CD7)_($2CAE) OK
$2CB0  20 8E 1C  JSR L_JSR_($1C8E)_($2CB0) OK
$2CB3  B0 22     BCS L_BRS_($2CD7)_($2CB3) OK
$2CB5  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$2CB8  4A        LSR A 
$2CB9  B0 1C     BCS L_BRS_($2CD7)_($2CB9) OK
$2CBB  20 59 0E  JSR L_JSR_($0E59)_($2CBB) OK
$2CBE  B0 17     BCS L_BRS_($2CD7)_($2CBE) OK
$2CC0  A9 8A     LDA #$8A
$2CC2  85 4F     STA $4F 
$2CC4  A9 60     LDA #$60
$2CC6  85 4E     STA $4E 
$2CC8  A0 01     LDY #$01
$2CCA  B1 4E     LDA ($4E),Y 
$2CCC  0A        ASL A 
$2CCD  90 08     BCC L_BRS_($2CD7)_($2CCD) OK
$2CCF  A9 2B     LDA #$2B
$2CD1  85 B1     STA $B1 
$2CD3  A9 21     LDA #$21
$2CD5  85 B0     STA $B0 
//------------------------------
L_BRS_($2CD7)_($2CA9) OK
L_BRS_($2CD7)_($2CAE) OK
L_BRS_($2CD7)_($2CB3) OK
L_BRS_($2CD7)_($2CB9) OK
L_BRS_($2CD7)_($2CBE) OK
L_BRS_($2CD7)_($2CCD) OK
//------------------------------
$2CD7  60        RTS 
//------------------------------
$2CD8            .byte $00
//------------------------------
L_JSR_($2CD9)_($0800) OK
L_JSR_($2CD9)_($C5E0) OK
//------------------------------
$2CD9  D8        CLD 	; Init graphics
$2CDA  78        SEI 
$2CDB  20 18 2D  JSR L_JSR_($2D18)_($2CDB) OK	; Init RAM configuration
$2CDE  A9 39     LDA #$39
$2CE0  8D FF FF  STA $FFFF 
$2CE3  A9 C7     LDA #$C7
$2CE5  8D FE FF  STA $FFFE                          // Vector: IRQ
$2CE8  A9 3A     LDA #$3A
$2CEA  8D FD FF  STA $FFFD 
$2CED  8D FB FF  STA $FFFB 
$2CF0  A9 8F     LDA #$8F
$2CF2  8D FC FF  STA $FFFC                          // Vector: RESET
$2CF5  8D FA FF  STA $FFFA                          // Vector: NMI
$2CF8  58        CLI 
$2CF9  20 AD 2D  JSR L_JSR_($2DAD)_($2CF9) OK	; Clear screen
$2CFC  20 CB 2D  JSR L_JSR_($2DCB)_($2CFC) OK	; set color RAM
$2CFF  20 05 2E  JSR L_JSR_($2E05)_($2CFF) OK	; clear zero page
$2D02  20 1F 2D  JSR L_JSR_($2D1F)_($2D02) OK	; setup VIC
$2D05  20 2A 30  JSR L_JSR_($302A)_($2D05) OK	; Init SID (for random number generator only?)
$2D08  20 47 2D  JSR L_JSR_($2D47)_($2D08) OK	; Init global pointers
$2D0B  20 3E 2D  JSR L_JSR_($2D3E)_($2D0B) OK	; VIC enable bitmap mode
$2D0E  20 47 30  JSR L_JSR_($3047)_($2D0E) OK	; Init sprites
$2D11  20 20 2F  JSR L_JSR_($2F20)_($2D11) OK	; Init bottom panel graphics
$2D14  20 56 2F  JSR L_JSR_($2F56)_($2D14) OK	; screen data for bottom panel (2)
$2D17  60        RTS 
//------------------------------
L_JSR_($2D18)_($2CDB) OK
//------------------------------
$2D18  A5 01     LDA $01 	; Init RAM mode: $D000 - $DFFF: I/O, other: RAM
$2D1A  29 FD     AND #$FD
$2D1C  85 01     STA $01 
$2D1E  60        RTS 
//------------------------------
L_JSR_($2D1F)_($2D02) OK	; setup VIC
//------------------------------
$2D1F  AD 02 DD  LDA $DD02                          // Data Direction Register A
$2D22  09 03     ORA #$03
$2D24  8D 02 DD  STA $DD02                          // Data Direction Register A
$2D27  AD 00 DD  LDA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$2D2A  29 FC     AND #$FC
$2D2C  09 00     ORA #$00
$2D2E  8D 00 DD  STA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)	// VIC mem at $C000
$2D31  AD 18 D0  LDA $D018                          // Memory Control Register
$2D34  29 0F     AND #$0F
$2D36  09 30     ORA #$30							// Video Matrix at $CC00
$2D38  09 08     ORA #$08							// Bitmap at $E000
$2D3A  8D 18 D0  STA $D018                          // Memory Control Register
$2D3D  60        RTS 
//------------------------------
L_JSR_($2D3E)_($2D0B) OK		; VIC enable bitmap mode
//------------------------------
$2D3E  AD 11 D0  LDA $D011                          // Control Register 1
$2D41  09 20     ORA #$20							// Enable bitmap mode
$2D43  8D 11 D0  STA $D011                          // Control Register 1
$2D46  60        RTS 
//------------------------------
L_JSR_($2D47)_($2D08) OK
L_JSR_($2D47)_($2EE2) OK
//------------------------------
$2D47  A9 20     LDA #$20		; Init global pointers
$2D49  85 58     STA $58 
$2D4B  A9 48     LDA #$48
$2D4D  85 59     STA $59 
$2D4F  A9 00     LDA #$00
$2D51  85 5E     STA $5E 
$2D53  A9 40     LDA #$40
$2D55  85 5F     STA $5F 
$2D57  A9 00     LDA #$00
$2D59  85 5A     STA $5A 
$2D5B  A9 E0     LDA #$E0		; TODO: Screen pointer
$2D5D  85 5B     STA $5B 
$2D5F  A9 00     LDA #$00
$2D61  85 5C     STA $5C 
$2D63  A9 CC     LDA #$CC		; TODO: Colorram pointer
$2D65  85 5D     STA $5D 
$2D67  A9 FF     LDA #$FF
$2D69  85 60     STA $60 
$2D6B  85 14     STA $14 
$2D6D  A9 0F     LDA #$0F
$2D6F  85 40     STA $40 
$2D71  A9 00     LDA #$00
$2D73  85 FD     STA $FD 
$2D75  85 D9     STA $D9 
$2D77  85 4B     STA $4B 
$2D79  85 2B     STA $2B 
$2D7B  85 46     STA $46 
$2D7D  85 2C     STA $2C 
$2D7F  85 2D     STA $2D 
$2D81  8D 15 D0  STA $D015                          // Sprite display Enable
$2D84  85 4C     STA $4C 
$2D86  A9 01     LDA #$01
$2D88  85 E5     STA $E5 
$2D8A  A9 04     LDA #$04
$2D8C  85 FE     STA $FE 
//------------------------------
L_BRS_($2D8E)_($2D93) OK
//------------------------------
$2D8E  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$2D91  C9 15     CMP #$15
$2D93  B0 F9     BCS L_BRS_($2D8E)_($2D93) OK
$2D95  A8        TAY 
$2D96  A9 46     LDA #$46
$2D98  85 4F     STA $4F 
$2D9A  A9 50     LDA #$50
$2D9C  85 4E     STA $4E 
$2D9E  B1 4E     LDA ($4E),Y 
$2DA0  85 41     STA $41 
$2DA2  C6 41     DEC $41 
$2DA4  A9 05     LDA #$05
$2DA6  85 EB     STA $EB 
$2DA8  A9 44     LDA #$44
$2DAA  85 44     STA $44 
$2DAC  60        RTS 
//------------------------------
L_JSR_($2DAD)_($2CF9) OK
//------------------------------
$2DAD  A9 E0     LDA #$E0		; Clear screen ($1F37 bytes at $E000)
$2DAF  85 4F     STA $4F 
$2DB1  A9 00     LDA #$00		; TODO: screen pointer
$2DB3  85 4E     STA $4E 
$2DB5  A2 1F     LDX #$1F
//------------------------------
L_BRS_($2DB7)_($2DC1) OK
//------------------------------
$2DB7  A0 00     LDY #$00
//------------------------------
L_BRS_($2DB9)_($2DBC) OK
//------------------------------
$2DB9  91 4E     STA ($4E),Y 
$2DBB  88        DEY 
$2DBC  D0 FB     BNE L_BRS_($2DB9)_($2DBC) OK
$2DBE  E6 4F     INC $4F 
$2DC0  CA        DEX 
$2DC1  D0 F4     BNE L_BRS_($2DB7)_($2DC1) OK
$2DC3  A0 37     LDY #$37
//------------------------------
L_BRS_($2DC5)_($2DC8) OK
//------------------------------
$2DC5  91 4E     STA ($4E),Y 
$2DC7  88        DEY 
$2DC8  10 FB     BPL L_BRS_($2DC5)_($2DC8) OK
$2DCA  60        RTS 
//------------------------------
L_JSR_($2DCB)_($2CFC) OK
//------------------------------
$2DCB  A9 00     LDA #$00		; set color RAM
$2DCD  85 4E     STA $4E 
$2DCF  A9 CC     LDA #$CC
$2DD1  85 4F     STA $4F 
$2DD3  A9 06     LDA #$06
$2DD5  8D 20 D0  STA $D020                          // Border Color
$2DD8  A9 66     LDA #$66
$2DDA  A2 03     LDX #$03
//------------------------------
L_BRS_($2DDC)_($2DE6) OK
//------------------------------
$2DDC  A0 00     LDY #$00
//------------------------------
L_BRS_($2DDE)_($2DE1) OK
//------------------------------
$2DDE  91 4E     STA ($4E),Y 
$2DE0  88        DEY 
$2DE1  D0 FB     BNE L_BRS_($2DDE)_($2DE1) OK
$2DE3  E6 4F     INC $4F 
$2DE5  CA        DEX 
$2DE6  D0 F4     BNE L_BRS_($2DDC)_($2DE6) OK
$2DE8  91 4E     STA ($4E),Y 
$2DEA  A0 47     LDY #$47
//------------------------------
L_BRS_($2DEC)_($2DEF) OK
//------------------------------
$2DEC  91 4E     STA ($4E),Y 
$2DEE  88        DEY 
$2DEF  D0 FB     BNE L_BRS_($2DEC)_($2DEF) OK
$2DF1  A9 5D     LDA #$5D
$2DF3  85 51     STA $51 
$2DF5  A9 00     LDA #$00
$2DF7  85 50     STA $50 
$2DF9  A0 48     LDY #$48
//------------------------------
L_BRS_($2DFB)_($2E02) OK
//------------------------------
$2DFB  B1 50     LDA ($50),Y 
$2DFD  91 4E     STA ($4E),Y 
$2DFF  C8        INY 
$2E00  C0 E8     CPY #$E8
$2E02  D0 F7     BNE L_BRS_($2DFB)_($2E02) OK
$2E04  60        RTS 
//------------------------------
L_JSR_($2E05)_($2CFF) OK
//------------------------------
$2E05  A9 00     LDA #$00	; clear zero page
$2E07  85 4E     STA $4E 
$2E09  85 4F     STA $4F 
$2E0B  A0 02     LDY #$02
//------------------------------
L_BRS_($2E0D)_($2E10) OK
//------------------------------
$2E0D  91 4E     STA ($4E),Y 
$2E0F  C8        INY 
$2E10  D0 FB     BNE L_BRS_($2E0D)_($2E10) OK
$2E12  60        RTS 
//------------------------------
L_JSR_($2E13)_($2776) OK
L_JSR_($2E13)_($BE09) OK
L_JSR_($2E13)_($BFED) OK
L_JSR_($2E13)_($FA27) OK
L_JSR_($2E13)_($FC09) OK
//------------------------------
$2E13  A9 78     LDA #$78
$2E15  85 51     STA $51 
$2E17  A9 60     LDA #$60
$2E19  85 50     STA $50 
$2E1B  A2 00     LDX #$00
$2E1D  A0 00     LDY #$00
//------------------------------
L_BRS_($2E1F)_($2E29) OK
//------------------------------
$2E1F  BD 00 49  LDA $4900,X 
$2E22  91 50     STA ($50),Y 
$2E24  E6 51     INC $51 
$2E26  E8        INX 
$2E27  E0 15     CPX #$15
$2E29  D0 F4     BNE L_BRS_($2E1F)_($2E29) OK
$2E2B  C8        INY 
//------------------------------
L_JMP_($2E2D)_($5F2A) BAD
//------------------------------
$2E2C  A2 00     LDX #$00
$2E2E  A9 78     LDA #$78
$2E30  85 51     STA $51 
//------------------------------
L_BRS_($2E32)_($2E3C) OK
//------------------------------
$2E32  BD 00 4A  LDA $4A00,X 
$2E35  91 50     STA ($50),Y 
$2E37  E6 51     INC $51 
$2E39  E8        INX 
$2E3A  E0 15     CPX #$15
$2E3C  D0 F4     BNE L_BRS_($2E32)_($2E3C) OK
$2E3E  A2 00     LDX #$00
$2E40  A0 02     LDY #$02
$2E42  A9 78     LDA #$78
$2E44  85 51     STA $51 
$2E46  A9 11     LDA #$11
//------------------------------
L_BRS_($2E48)_($2E4F) OK
//------------------------------
$2E48  91 50     STA ($50),Y 
$2E4A  E6 51     INC $51 
$2E4C  E8        INX 
$2E4D  E0 15     CPX #$15
$2E4F  D0 F7     BNE L_BRS_($2E48)_($2E4F) OK
$2E51  A5 7D     LDA $7D 
$2E53  C5 F8     CMP $F8 
$2E55  F0 04     BEQ L_BRS_($2E5B)_($2E55) OK
$2E57  B0 08     BCS L_BRS_($2E61)_($2E57) OK
$2E59  D0 0E     BNE L_BRS_($2E69)_($2E59) OK
//------------------------------
L_BRS_($2E5B)_($2E55) OK
//------------------------------
$2E5B  A5 7C     LDA $7C 
$2E5D  C5 F7     CMP $F7 
$2E5F  90 08     BCC L_BRS_($2E69)_($2E5F) OK
//------------------------------
L_BRS_($2E61)_($2E57) OK
//------------------------------
$2E61  A5 7D     LDA $7D 
$2E63  85 F8     STA $F8 
$2E65  A5 7C     LDA $7C 
$2E67  85 F7     STA $F7 
//------------------------------
L_BRS_($2E69)_($2E59) OK
L_BRS_($2E69)_($2E5F) OK
//------------------------------
$2E69  A9 00     LDA #$00
$2E6B  85 60     STA $60 
$2E6D  85 7C     STA $7C 
$2E6F  85 7D     STA $7D 
$2E71  85 7E     STA $7E 
$2E73  85 7F     STA $7F 
$2E75  20 AA 2A  JSR L_JSR_($2AAA)_($2E75) OK
$2E78  20 2F 29  JSR L_JSR_($292F)_($2E78) OK
$2E7B  20 20 2F  JSR L_JSR_($2F20)_($2E7B) OK
$2E7E  20 56 2F  JSR L_JSR_($2F56)_($2E7E) OK
$2E81  A5 F8     LDA $F8 
$2E83  D0 07     BNE L_BRS_($2E8C)_($2E83) OK
$2E85  A5 F7     LDA $F7 
$2E87  D0 03     BNE L_BRS_($2E8C)_($2E87) OK
$2E89  4C 95 2E  JMP L_JMP_($2E95)_($2E89) OK
//------------------------------
L_BRS_($2E8C)_($2E83) OK
L_BRS_($2E8C)_($2E87) OK
//------------------------------
$2E8C  A9 F7     LDA #$F7
$2E8E  85 4E     STA $4E 
$2E90  A9 02     LDA #$02
$2E92  20 20 26  JSR L_JSR_($2620)_($2E92) OK
//------------------------------
L_JMP_($2E95)_($2E89) OK
L_BRS_($2E95)_($2ECB) OK
//------------------------------
$2E95  20 79 32  JSR L_JSR_($3279)_($2E95) OK
$2E98  A9 00     LDA #$00
$2E9A  85 2A     STA $2A 
$2E9C  85 B1     STA $B1 
$2E9E  85 AB     STA $AB 
$2EA0  85 3A     STA $3A 
$2EA2  85 3B     STA $3B 
$2EA4  85 3C     STA $3C 
$2EA6  85 3D     STA $3D 
$2EA8  85 3E     STA $3E 
$2EAA  85 A6     STA $A6 
$2EAC  85 A7     STA $A7 
$2EAE  85 A8     STA $A8 
$2EB0  85 A9     STA $A9 
$2EB2  85 AC     STA $AC 
$2EB4  85 AD     STA $AD 
$2EB6  85 AE     STA $AE 
$2EB8  85 AF     STA $AF 
$2EBA  85 B2     STA $B2 
$2EBC  85 B3     STA $B3 
$2EBE  85 B4     STA $B4 
$2EC0  85 B5     STA $B5 
$2EC2  20 BF 33  JSR L_JSR_($33BF)_($2EC2) OK
$2EC5  E6 60     INC $60 
$2EC7  A5 60     LDA $60 
$2EC9  C9 12     CMP #$12
$2ECB  D0 C8     BNE L_BRS_($2E95)_($2ECB) OK
$2ECD  A9 58     LDA #$58
$2ECF  85 51     STA $51 
$2ED1  A9 E0     LDA #$E0
$2ED3  85 50     STA $50 
$2ED5  A0 02     LDY #$02
$2ED7  A9 00     LDA #$00
//------------------------------
L_BRS_($2ED9)_($2EE0) OK
//------------------------------
$2ED9  91 50     STA ($50),Y 
$2EDB  C8        INY 
$2EDC  C8        INY 
$2EDD  C8        INY 
$2EDE  C0 2D     CPY #$2D
$2EE0  90 F7     BCC L_BRS_($2ED9)_($2EE0) OK
$2EE2  20 47 2D  JSR L_JSR_($2D47)_($2EE2) OK
$2EE5  60        RTS 
//------------------------------
L_JSR_($2EE6)_($3326) OK
//------------------------------
$2EE6  A5 27     LDA $27 	; calculate screen address? ; $27 is X
$2EE8  38        SEC 
$2EE9  E5 58     SBC $58 
$2EEB  85 5A     STA $5A 
$2EED  A9 00     LDA #$00
$2EEF  85 5D     STA $5D 
$2EF1  A5 28     LDA $28 	; $28 is Y
$2EF3  0A        ASL A 		; Y*2
$2EF4  0A        ASL A 		; Y*4
$2EF5  65 28     ADC $28 	; Y*5
$2EF7  0A        ASL A 		; Y*10
$2EF8  0A        ASL A 		; Y*20
$2EF9  26 5D     ROL $5D 
$2EFB  0A        ASL A 		; Y*40
$2EFC  26 5D     ROL $5D 
$2EFE  65 5A     ADC $5A 	; Y*40+X
$2F00  85 5A     STA $5A 
$2F02  85 5C     STA $5C 
$2F04  90 02     BCC L_BRS_($2F08)_($2F04) OK
$2F06  E6 5D     INC $5D 
//------------------------------
L_BRS_($2F08)_($2F04) OK
//------------------------------
$2F08  A5 5D     LDA $5D 
$2F0A  06 5A     ASL $5A 
$2F0C  2A        ROL A 
$2F0D  06 5A     ASL $5A 
$2F0F  2A        ROL A 
$2F10  06 5A     ASL $5A 
$2F12  2A        ROL A 
$2F13  69 E0     ADC #$E0	; TODO: screen address?
$2F15  85 5B     STA $5B 
$2F17  A5 5D     LDA $5D 
$2F19  69 CC     ADC #$CC	; TODO: color ram adress?
$2F1B  85 5D     STA $5D 
$2F1D  69 28     ADC #$28
$2F1F  60        RTS 
//------------------------------
L_JSR_($2F20)_($2D11) OK
L_JSR_($2F20)_($2E7B) OK
//------------------------------
$2F20  A9 59     LDA #$59	; Init bottom panel graphics
$2F22  85 4F     STA $4F 
$2F24  A9 20     LDA #$20
$2F26  85 4E     STA $4E 
$2F28  A9 FA     LDA #$FA	; TODO: screen pointer
$2F2A  85 51     STA $51 
$2F2C  A9 60     LDA #$60
$2F2E  85 50     STA $50 
$2F30  A0 00     LDY #$00
//------------------------------
L_BRS_($2F32)_($2F39) OK
//------------------------------
$2F32  B1 4E     LDA ($4E),Y 
$2F34  91 50     STA ($50),Y 
$2F36  C8        INY 
$2F37  C0 40     CPY #$40
$2F39  D0 F7     BNE L_BRS_($2F32)_($2F39) OK
$2F3B  A9 FB     LDA #$FB
$2F3D  85 51     STA $51 
//------------------------------
L_BRS_($2F3F)_($2F46) OK
//------------------------------
$2F3F  B1 4E     LDA ($4E),Y 
$2F41  91 50     STA ($50),Y 
$2F43  C8        INY 
$2F44  C0 80     CPY #$80
$2F46  D0 F7     BNE L_BRS_($2F3F)_($2F46) OK
$2F48  A9 FC     LDA #$FC
$2F4A  85 51     STA $51 
//------------------------------
L_BRS_($2F4C)_($2F53) OK
//------------------------------
$2F4C  B1 4E     LDA ($4E),Y 
$2F4E  91 50     STA ($50),Y 
$2F50  C8        INY 
$2F51  C0 C0     CPY #$C0
$2F53  D0 F7     BNE L_BRS_($2F4C)_($2F53) OK
$2F55  60        RTS 
//------------------------------
L_JSR_($2F56)_($2D14) OK
L_JSR_($2F56)_($2E7E) OK
//------------------------------
$2F56  A9 58     LDA #$58	; Init bottom panel graphics (2)
//------------------------------
L_JSR_($2F59)_($8DF6) BAD
L_JSR_($2F59)_($CC81) BAD
//------------------------------
$2F58  85 4F     STA $4F 
$2F5A  A9 20     LDA #$20
$2F5C  85 4E     STA $4E 
$2F5E  A9 FB     LDA #$FB	; TODO: screen pointer
$2F60  85 51     STA $51 
$2F62  A9 20     LDA #$20
$2F64  85 50     STA $50 
$2F66  A0 00     LDY #$00
//------------------------------
L_BRS_($2F68)_($2F6F) OK
//------------------------------
$2F68  B1 4E     LDA ($4E),Y 
$2F6A  91 50     STA ($50),Y 
$2F6C  C8        INY 
$2F6D  C0 40     CPY #$40
$2F6F  D0 F7     BNE L_BRS_($2F68)_($2F6F) OK
$2F71  A9 FC     LDA #$FC
$2F73  85 51     STA $51 
//------------------------------
L_BRS_($2F75)_($2F7C) OK
//------------------------------
$2F75  B1 4E     LDA ($4E),Y 
$2F77  91 50     STA ($50),Y 
$2F79  C8        INY 
$2F7A  C0 80     CPY #$80
$2F7C  D0 F7     BNE L_BRS_($2F75)_($2F7C) OK
$2F7E  A9 FD     LDA #$FD
$2F80  85 51     STA $51 
//------------------------------
L_BRS_($2F82)_($2F89) OK
//------------------------------
$2F82  B1 4E     LDA ($4E),Y 
$2F84  91 50     STA ($50),Y 
$2F86  C8        INY 
$2F87  C0 C0     CPY #$C0
$2F89  D0 F7     BNE L_BRS_($2F82)_($2F89) OK
$2F8B  60        RTS 
//------------------------------
L_JSR_($2F8C)_($30F8) OK
L_JSR_($2F8C)_($319A) OK
//------------------------------
$2F8C  84 27     STY $27 
$2F8E  A9 00     LDA #$00
$2F90  85 28     STA $28 
//------------------------------
L_BRS_($2F92)_($2FB3) OK
//------------------------------
$2F92  20 29 33  JSR L_JSR_($3329)_($2F92) OK
$2F95  A5 5A     LDA $5A 		; next character line in video RAM
$2F97  E6 5B     INC $5B 
$2F99  18        CLC 
$2F9A  69 40     ADC #$40
$2F9C  90 02     BCC L_BRS_($2FA0)_($2F9C) OK
$2F9E  E6 5B     INC $5B 
//------------------------------
L_BRS_($2FA0)_($2F9C) OK
//------------------------------
$2FA0  85 5A     STA $5A 
$2FA2  A5 5C     LDA $5C 		; next line in color RAM
$2FA4  18        CLC 
$2FA5  69 28     ADC #$28
$2FA7  90 02     BCC L_BRS_($2FAB)_($2FA7) OK
$2FA9  E6 5D     INC $5D 
//------------------------------
L_BRS_($2FAB)_($2FA7) OK
//------------------------------
$2FAB  85 5C     STA $5C 
$2FAD  E6 28     INC $28 
$2FAF  A5 28     LDA $28 
$2FB1  C9 15     CMP #$15
$2FB3  D0 DD     BNE L_BRS_($2F92)_($2FB3) OK
$2FB5  60        RTS 
//------------------------------
L_JSR_($2FB6)_($30BC) OK
L_JSR_($2FB6)_($315D) OK
//------------------------------
$2FB6  A2 15     LDX #$15
//------------------------------
L_BRS_($2FB8)_($300F) OK
//------------------------------
$2FB8  A0 00     LDY #$00		; TODO: move tile?
$2FBA  B1 4E     LDA ($4E),Y 
$2FBC  91 52     STA ($52),Y 
$2FBE  C8        INY 
$2FBF  B1 4E     LDA ($4E),Y 
$2FC1  91 52     STA ($52),Y 
$2FC3  C8        INY 
$2FC4  B1 4E     LDA ($4E),Y 
$2FC6  91 52     STA ($52),Y 
$2FC8  C8        INY 
$2FC9  B1 4E     LDA ($4E),Y 
$2FCB  91 52     STA ($52),Y 
$2FCD  C8        INY 
$2FCE  B1 4E     LDA ($4E),Y 
$2FD0  91 52     STA ($52),Y 
$2FD2  C8        INY 
$2FD3  B1 4E     LDA ($4E),Y 
$2FD5  91 52     STA ($52),Y 
$2FD7  C8        INY 
$2FD8  B1 4E     LDA ($4E),Y 
$2FDA  91 52     STA ($52),Y 
$2FDC  C8        INY 
$2FDD  B1 4E     LDA ($4E),Y 
$2FDF  91 52     STA ($52),Y 
$2FE1  A4 54     LDY $54 		; Move colorram
$2FE3  B1 50     LDA ($50),Y 
$2FE5  A4 55     LDY $55 
$2FE7  91 50     STA ($50),Y 
$2FE9  A5 4E     LDA $4E 
$2FEB  E6 4F     INC $4F 
$2FED  18        CLC 
$2FEE  69 40     ADC #$40
$2FF0  90 02     BCC L_BRS_($2FF4)_($2FF0) OK
$2FF2  E6 4F     INC $4F 
//------------------------------
L_BRS_($2FF4)_($2FF0) OK
//------------------------------
$2FF4  85 4E     STA $4E 
$2FF6  A5 52     LDA $52 
$2FF8  E6 53     INC $53 
$2FFA  18        CLC 
$2FFB  69 40     ADC #$40
$2FFD  90 02     BCC L_BRS_($3001)_($2FFD) OK
$2FFF  E6 53     INC $53 
//------------------------------
L_BRS_($3001)_($2FFD) OK
//------------------------------
$3001  85 52     STA $52 
$3003  A5 50     LDA $50 
$3005  18        CLC 
$3006  69 28     ADC #$28
$3008  90 02     BCC L_BRS_($300C)_($3008) OK
$300A  E6 51     INC $51 
//------------------------------
L_BRS_($300C)_($3008) OK
//------------------------------
$300C  85 50     STA $50 
$300E  CA        DEX 
$300F  D0 A7     BNE L_BRS_($2FB8)_($300F) OK
$3011  60        RTS 
//------------------------------
L_JSR_($3012)_($0810) OK
L_JSR_($3012)_($BE39) OK
L_JSR_($3012)_($FA55) OK
//------------------------------
$3012  A9 F8     LDA #$F8
$3014  85 58     STA $58 
$3016  A9 20     LDA #$20
$3018  85 59     STA $59 
$301A  20 13 31  JSR L_JSR_($3113)_($301A) OK
$301D  20 13 31  JSR L_JSR_($3113)_($301D) OK
$3020  20 13 31  JSR L_JSR_($3113)_($3020) OK
$3023  20 13 31  JSR L_JSR_($3113)_($3023) OK
$3026  20 13 31  JSR L_JSR_($3113)_($3026) OK
$3029  60        RTS 
//------------------------------
L_JSR_($302A)_($2D05) OK
L_JSR_($302A)_($BA44) OK
L_JSR_($302A)_($BA8C) OK
L_JSR_($302A)_($F68F) OK
L_JSR_($302A)_($F6D7) OK
//------------------------------
$302A  A9 80     LDA #$80		; Init SID (for random number generator?)
$302C  8D 0E D4  STA $D40E                          // Voice 3: Frequency Control - Low-Byte
//------------------------------
L_JSR_($3031)_($5BF3) BAD
L_JSR_($3031)_($C4C8) BAD
L_JSR_($3031)_($FEC2) BAD
//------------------------------
$302F  8D 0F D4  STA $D40F                          // Voice 3: Frequency Control - High-Byte ; sound frequency = 1931,8332672119140625 Hz
$3032  8D 12 D4  STA $D412                          // Voice 3: Control Register ; Noise on, start release
$3035  A9 0F     LDA #$0F
$3037  8D 18 D4  STA $D418                          // Select Filter Mode and Volume ; volume 0F
$303A  A9 01     LDA #$01
$303C  8D 13 D4  STA $D413                          // Voice 3: Attack / Decay Cycle Control ; Attack 0, Decay 1
$303F  A9 00     LDA #$00
$3041  8D 14 D4  STA $D414                          // Voice 3: Sustain / Release Cycle Control ; Sustain 0, Release 0
$3044  A9 80     LDA #$80
$3046  60        RTS 
//------------------------------
L_JSR_($3047)_($2D0E) OK
//------------------------------
$3047  A9 00     LDA #$00		; Init sprites
$3049  8D 15 D0  STA $D015                          // Sprite display Enable
$304C  8D 1D D0  STA $D01D                          // Sprites Expand 2x Horizontal (X)
$304F  A9 3C     LDA #$3C
$3051  85 51     STA $51 
$3053  A9 00     LDA #$00
$3055  85 50     STA $50 
$3057  A9 C8     LDA #$C8
$3059  85 4F     STA $4F 
$305B  A9 00     LDA #$00
$305D  85 4E     STA $4E 
$305F  A2 04     LDX #$04
//------------------------------
L_BRS_($3061)_($306F) OK
//------------------------------
$3061  A0 00     LDY #$00
//------------------------------
L_BRS_($3063)_($3068) OK
//------------------------------
$3063  B1 50     LDA ($50),Y 
$3065  91 4E     STA ($4E),Y 
$3067  C8        INY 
$3068  D0 F9     BNE L_BRS_($3063)_($3068) OK
$306A  E6 4F     INC $4F 
$306C  E6 51     INC $51 
$306E  CA        DEX 
$306F  D0 F0     BNE L_BRS_($3061)_($306F) OK
$3071  60        RTS 
//------------------------------
L_JSR_($3072)_($3635) OK
//------------------------------
$3072  78        SEI 
$3073  A5 58     LDA $58 
$3075  C9 08     CMP #$08
$3077  B0 03     BCS L_BRS_($307C)_($3077) OK
$3079  4C 11 31  JMP L_JMP_($3111)_($3079) OK
//------------------------------
L_BRS_($307C)_($3077) OK
//------------------------------
$307C  A9 08     LDA #$08
$307E  85 55     STA $55 
$3080  A9 00     LDA #$00
$3082  85 54     STA $54 
$3084  A9 F8     LDA #$F8
$3086  85 5A     STA $5A 
$3088  A9 E0     LDA #$E0	; TODO: screen pointer?
$308A  85 5B     STA $5B 
$308C  A9 1F     LDA #$1F	; TODO: colorram pointer?
$308E  85 5C     STA $5C 
$3090  A9 CC     LDA #$CC
$3092  85 5D     STA $5D 
$3094  A2 20     LDX #$20
//------------------------------
L_BRS_($3096)_($30D0) OK
//------------------------------
$3096  CA        DEX 
$3097  8A        TXA 
$3098  48        PHA 
$3099  A5 5A     LDA $5A 
$309B  85 4E     STA $4E 
$309D  A5 5B     LDA $5B 
$309F  85 4F     STA $4F 
$30A1  A5 5C     LDA $5C 	; Colorram pointer here
$30A3  85 50     STA $50 
$30A5  A5 5D     LDA $5D 
$30A7  85 51     STA $51 
$30A9  A5 4E     LDA $4E 
$30AB  85 52     STA $52 
$30AD  A5 4F     LDA $4F 
$30AF  85 53     STA $53 
$30B1  A5 52     LDA $52 
$30B3  18        CLC 
$30B4  69 40     ADC #$40
$30B6  90 02     BCC L_BRS_($30BA)_($30B6) OK
$30B8  E6 53     INC $53 
//------------------------------
L_BRS_($30BA)_($30B6) OK
//------------------------------
$30BA  85 52     STA $52 
$30BC  20 B6 2F  JSR L_JSR_($2FB6)_($30BC) OK
$30BF  A5 5A     LDA $5A 
$30C1  18        CLC 
$30C2  69 F8     ADC #$F8
$30C4  C9 F8     CMP #$F8
$30C6  D0 02     BNE L_BRS_($30CA)_($30C6) OK
$30C8  C6 5B     DEC $5B 
//------------------------------
L_BRS_($30CA)_($30C6) OK
//------------------------------
$30CA  85 5A     STA $5A 
$30CC  C6 5C     DEC $5C 
$30CE  68        PLA 
$30CF  AA        TAX 
$30D0  D0 C4     BNE L_BRS_($3096)_($30D0) OK
$30D2  A9 38     LDA #$38
$30D4  85 5A     STA $5A 
$30D6  A9 E0     LDA #$E0	; TODO: screen address?
$30D8  85 5B     STA $5B 
$30DA  A9 07     LDA #$07
$30DC  85 5C     STA $5C 
$30DE  20 68 98  JSR L_JSR_($9868)_($30DE) OK
$30E1  EA        NOP 
$30E2  A2 08     LDX #$08
//------------------------------
L_BRS_($30E4)_($310F) OK
//------------------------------
$30E4  8A        TXA 
$30E5  48        PHA 
$30E6  C6 58     DEC $58 
$30E8  C6 59     DEC $59 
$30EA  A4 58     LDY $58 
$30EC  A5 5A     LDA $5A 
$30EE  48        PHA 
$30EF  A5 5B     LDA $5B 
$30F1  48        PHA 
$30F2  A5 5C     LDA $5C 
$30F4  48        PHA 
$30F5  A5 5D     LDA $5D 
$30F7  48        PHA 
$30F8  20 8C 2F  JSR L_JSR_($2F8C)_($30F8) OK
$30FB  68        PLA 
$30FC  85 5D     STA $5D 
$30FE  68        PLA 
$30FF  85 5C     STA $5C 
$3101  68        PLA 
$3102  85 5B     STA $5B 
$3104  68        PLA 
$3105  38        SEC 
$3106  E9 08     SBC #$08
$3108  85 5A     STA $5A 
$310A  C6 5C     DEC $5C 
$310C  68        PLA 
$310D  AA        TAX 
$310E  CA        DEX 
$310F  D0 D3     BNE L_BRS_($30E4)_($310F) OK
//------------------------------
L_JMP_($3111)_($3079) OK
//------------------------------
$3111  58        CLI 
$3112  60        RTS 
//------------------------------
L_JSR_($3113)_($301A) OK
L_JSR_($3113)_($301D) OK
L_JSR_($3113)_($3020) OK
L_JSR_($3113)_($3023) OK
L_JSR_($3113)_($3026) OK
L_JSR_($3113)_($364A) OK
//------------------------------
$3113  78        SEI 
$3114  A5 59     LDA $59 
$3116  C9 59     CMP #$59
$3118  90 03     BCC L_BRS_($311D)_($3118) OK
$311A  4C B4 31  JMP L_JMP_($31B4)_($311A) OK
//------------------------------
L_BRS_($311D)_($3118) OK
//------------------------------
$311D  A9 08     LDA #$08
$311F  85 54     STA $54 
$3121  A9 00     LDA #$00
$3123  85 55     STA $55 
$3125  A9 00     LDA #$00
$3127  85 5A     STA $5A 
$3129  A9 E0     LDA #$E0
$312B  85 5B     STA $5B 	; TODO: screen address?
$312D  A9 00     LDA #$00
$312F  85 5C     STA $5C 
$3131  A9 CC     LDA #$CC	; TODO: colorram address?
$3133  85 5D     STA $5D 
$3135  A2 00     LDX #$00
//------------------------------
L_BRS_($3137)_($3171) OK
//------------------------------
$3137  E8        INX 
$3138  8A        TXA 
$3139  48        PHA 
$313A  A5 5A     LDA $5A 
$313C  85 52     STA $52 
$313E  A5 5B     LDA $5B 
$3140  85 53     STA $53 
$3142  A5 5C     LDA $5C 	; Colorram pointer here
$3144  85 50     STA $50 
$3146  A5 5D     LDA $5D 
$3148  85 51     STA $51 
$314A  A5 52     LDA $52 
$314C  85 4E     STA $4E 
$314E  A5 53     LDA $53 
$3150  85 4F     STA $4F 
$3152  A5 4E     LDA $4E 
$3154  18        CLC 
$3155  69 40     ADC #$40
$3157  90 02     BCC L_BRS_($315B)_($3157) OK
$3159  E6 4F     INC $4F 
//------------------------------
L_BRS_($315B)_($3157) OK
//------------------------------
$315B  85 4E     STA $4E 
$315D  20 B6 2F  JSR L_JSR_($2FB6)_($315D) OK
$3160  A5 5A     LDA $5A 
$3162  18        CLC 
$3163  69 08     ADC #$08
$3165  D0 02     BNE L_BRS_($3169)_($3165) OK
$3167  E6 5B     INC $5B 
//------------------------------
L_BRS_($3169)_($3165) OK
//------------------------------
$3169  85 5A     STA $5A 
$316B  E6 5C     INC $5C 
$316D  68        PLA 
$316E  AA        TAX 
$316F  E0 20     CPX #$20
$3171  D0 C4     BNE L_BRS_($3137)_($3171) OK
$3173  A9 00     LDA #$00
$3175  85 5A     STA $5A 
$3177  A9 E1     LDA #$E1	; TODO: screen address?
$3179  85 5B     STA $5B 
$317B  A9 20     LDA #$20
$317D  85 5C     STA $5C 
$317F  EA        NOP 
$3180  20 E8 98  JSR L_JSR_($98E8)_($3180) OK
$3183  A2 08     LDX #$08
//------------------------------
L_BRS_($3185)_($31B2) OK
//------------------------------
$3185  8A        TXA 
$3186  48        PHA 
$3187  E6 58     INC $58 
$3189  E6 59     INC $59 
$318B  A4 59     LDY $59 
$318D  88        DEY 
$318E  A5 5A     LDA $5A 
$3190  48        PHA 
$3191  A5 5B     LDA $5B 
$3193  48        PHA 
$3194  A5 5C     LDA $5C 
$3196  48        PHA 
$3197  A5 5D     LDA $5D 
$3199  48        PHA 
$319A  20 8C 2F  JSR L_JSR_($2F8C)_($319A) OK
$319D  68        PLA 
$319E  85 5D     STA $5D 
$31A0  68        PLA 
$31A1  85 5C     STA $5C 
$31A3  68        PLA 
$31A4  85 5B     STA $5B 
$31A6  68        PLA 
$31A7  CA        DEX 
$31A8  18        CLC 
$31A9  69 08     ADC #$08
$31AB  85 5A     STA $5A 
$31AD  E6 5C     INC $5C 
$31AF  68        PLA 
$31B0  AA        TAX 
$31B1  CA        DEX 
$31B2  D0 D1     BNE L_BRS_($3185)_($31B2) OK
//------------------------------
L_JMP_($31B4)_($311A) OK
//------------------------------
$31B4  58        CLI 
$31B5  60        RTS 
//------------------------------
L_JSR_($31B6)_($0A5D) OK
L_JSR_($31B6)_($0A62) OK
L_JSR_($31B6)_($0B81) OK
L_JSR_($31B6)_($0E37) OK
L_JSR_($31B6)_($1F07) OK
L_JSR_($31B6)_($2709) OK
//------------------------------
$31B6  A8        TAY 
$31B7  A9 00     LDA #$00
$31B9  85 56     STA $56 
$31BB  A9 44     LDA #$44
$31BD  85 57     STA $57 
$31BF  A9 FF     LDA #$FF
$31C1  91 56     STA ($56),Y 
$31C3  60        RTS 
//------------------------------
L_JSR_($31C4)_($1F63) OK
//------------------------------
$31C4  A8        TAY 
$31C5  A9 00     LDA #$00
$31C7  85 56     STA $56 
$31C9  A9 44     LDA #$44
$31CB  85 57     STA $57 
$31CD  A9 00     LDA #$00
$31CF  91 56     STA ($56),Y 
$31D1  60        RTS 
//------------------------------
L_JSR_($31D2)_($0B93) OK
L_JSR_($31D2)_($14FA) OK
L_JSR_($31D2)_($152A) OK
L_JSR_($31D2)_($1A1D) OK
L_JSR_($31D2)_($1F20) OK
L_JSR_($31D2)_($1F4F) OK
L_JSR_($31D2)_($28AE) OK
//------------------------------
$31D2  A8        TAY 
$31D3  A9 00     LDA #$00
$31D5  85 56     STA $56 
$31D7  A9 44     LDA #$44
$31D9  85 57     STA $57 
$31DB  B1 56     LDA ($56),Y 
$31DD  4A        LSR A 
$31DE  60        RTS 
//------------------------------
L_JSR_($31DF)_($20E0) OK
L_JSR_($31DF)_($20E3) OK
L_JSR_($31DF)_($20E6) OK
L_JSR_($31DF)_($20E9) OK
L_JSR_($31DF)_($20EC) OK
//------------------------------
$31DF  A2 FF     LDX #$FF	; delay
//------------------------------
L_BRS_($31E1)_($31E7) OK
//------------------------------
$31E1  A0 FF     LDY #$FF
//------------------------------
L_BRS_($31E3)_($31E4) OK
//------------------------------
$31E3  88        DEY 
$31E4  D0 FD     BNE L_BRS_($31E3)_($31E4) OK
$31E6  CA        DEX 
$31E7  D0 F8     BNE L_BRS_($31E1)_($31E7) OK
$31E9  60        RTS 
//------------------------------
L_JSR_($31EA)_($0916) OK
L_JSR_($31EA)_($361B) OK
L_JSR_($31EA)_($BEF7) OK
L_JSR_($31EA)_($BFBF) OK
L_JSR_($31EA)_($FB13) OK
L_JSR_($31EA)_($FBDB) OK
//------------------------------
$31EA  A0 5E     LDY #$5E
$31EC  A9 12     LDA #$12
$31EE  85 4E     STA $4E 
$31F0  A9 40     LDA #$40
$31F2  85 4F     STA $4F 
//------------------------------
L_BRS_($31F4)_($322B) OK
//------------------------------
$31F4  B1 4E     LDA ($4E),Y 
$31F6  F0 32     BEQ L_BRS_($322A)_($31F6) OK
$31F8  85 57     STA $57 
$31FA  98        TYA 
$31FB  48        PHA 
$31FC  A2 01     LDX #$01
$31FE  C9 28     CMP #$28
$3200  90 04     BCC L_BRS_($3206)_($3200) OK
$3202  E9 28     SBC #$28
$3204  A2 09     LDX #$09
//------------------------------
L_BRS_($3206)_($3200) OK
L_BRS_($3206)_($320A) OK
//------------------------------
$3206  E8        INX 
$3207  38        SEC 
$3208  E9 05     SBC #$05
$320A  10 FA     BPL L_BRS_($3206)_($320A) OK
$320C  86 28     STX $28 
$320E  69 05     ADC #$05
$3210  0A        ASL A 
$3211  0A        ASL A 
$3212  0A        ASL A 
$3213  65 58     ADC $58 
$3215  85 27     STA $27 
//------------------------------
L_BRS_($3217)_($3222) OK
//------------------------------
$3217  06 57     ASL $57 
$3219  90 03     BCC L_BRS_($321E)_($3219) OK
$321B  20 26 33  JSR L_JSR_($3326)_($321B) OK
//------------------------------
L_BRS_($321E)_($3219) OK
//------------------------------
$321E  E6 27     INC $27 
$3220  A5 57     LDA $57 
$3222  D0 F3     BNE L_BRS_($3217)_($3222) OK
$3224  68        PLA 
$3225  A8        TAY 
$3226  A9 00     LDA #$00
$3228  91 4E     STA ($4E),Y 
//------------------------------
L_BRS_($322A)_($31F6) OK
//------------------------------
$322A  88        DEY 
$322B  10 C7     BPL L_BRS_($31F4)_($322B) OK
$322D  60        RTS 
//------------------------------
L_JSR_($322E)_($0C9D) OK
L_JSR_($322E)_($0CB6) OK
L_JSR_($322E)_($0CD8) OK
L_JSR_($322E)_($0D48) OK
L_JSR_($322E)_($0FBA) OK
L_JSR_($322E)_($0FEC) OK
L_JSR_($322E)_($1004) OK
L_JSR_($322E)_($1042) OK
L_JSR_($322E)_($104E) OK
L_JSR_($322E)_($1171) OK
L_JSR_($322E)_($1187) OK
L_JSR_($322E)_($119B) OK
L_JSR_($322E)_($11C6) OK
L_JSR_($322E)_($12DC) OK
L_JMP_($322E)_($12E5) OK
L_JSR_($322E)_($1357) OK
L_JSR_($322E)_($1390) OK
L_JSR_($322E)_($13D1) OK
L_JSR_($322E)_($1405) OK
L_JSR_($322E)_($141D) OK
L_JSR_($322E)_($15E7) OK
L_JSR_($322E)_($1605) OK
L_JSR_($322E)_($16BB) OK
L_JSR_($322E)_($16CC) OK
L_JSR_($322E)_($1715) OK
L_JSR_($322E)_($172C) OK
L_JSR_($322E)_($1741) OK
L_JSR_($322E)_($176F) OK
L_JSR_($322E)_($1776) OK
L_JSR_($322E)_($18D0) OK
L_JSR_($322E)_($18D5) OK
L_JSR_($322E)_($1928) OK
L_JSR_($322E)_($192F) OK
L_JSR_($322E)_($1C87) OK
L_JSR_($322E)_($1CC0) OK
L_JSR_($322E)_($1CC5) OK
L_JSR_($322E)_($1CD7) OK
L_JSR_($322E)_($1CE6) OK
L_JSR_($322E)_($1CEC) OK
L_JSR_($322E)_($1D07) OK
L_JSR_($322E)_($1D0F) OK
L_JSR_($322E)_($2682) OK
L_JSR_($322E)_($2690) OK
L_JSR_($322E)_($269E) OK
L_JSR_($322E)_($26A3) OK
L_JSR_($322E)_($26E0) OK
L_JSR_($322E)_($26EB) OK
L_JSR_($322E)_($2A54) OK
L_JSR_($322E)_($2A60) OK
L_JSR_($322E)_($2A7A) OK
L_JSR_($322E)_($2A81) OK
L_JSR_($322E)_($2B2D) OK
L_JSR_($322E)_($2B39) OK
L_JSR_($322E)_($2B47) OK
L_JSR_($322E)_($2B4C) OK
L_JSR_($322E)_($2BA7) OK
L_JSR_($322E)_($2BAC) OK
L_JSR_($322E)_($347E) OK
L_JSR_($322E)_($3493) OK
L_JSR_($322E)_($34A2) OK
L_JSR_($322E)_($35EF) OK
L_JSR_($322E)_($3615) OK
L_JSR_($322E)_($364E) OK
L_JSR_($322E)_($365C) OK
L_JSR_($322E)_($3668) OK
L_JSR_($322E)_($3699) OK
L_JSR_($322E)_($36B0) OK
L_JSR_($322E)_($36D0) OK
L_JSR_($322E)_($36D6) OK
L_JSR_($322E)_($36DF) OK
//------------------------------
$322E  A4 26     LDY $26 
//------------------------------
L_JSR_($3231)_($5A07) BAD
L_JSR_($3231)_($5A16) BAD
//------------------------------
$3230  A9 00     LDA #$00
$3232  85 50     STA $50 
$3234  A9 8D     LDA #$8D
$3236  85 51     STA $51 
$3238  A5 FC     LDA $FC 
$323A  85 57     STA $57 
//------------------------------
L_BRS_($323C)_($3276) OK
//------------------------------
$323C  A5 FB     LDA $FB 
$323E  85 4A     STA $4A 
$3240  A5 57     LDA $57 
$3242  C5 58     CMP $58 
$3244  B0 03     BCS L_BRS_($3249)_($3244) OK
$3246  4C 69 32  JMP L_JMP_($3269)_($3246) OK
//------------------------------
L_BRS_($3249)_($3244) OK
//------------------------------
$3249  C5 59     CMP $59 
$324B  B0 1C     BCS L_BRS_($3269)_($324B) OK
$324D  A2 04     LDX #$04
//------------------------------
L_BRS_($324F)_($3264) OK
//------------------------------
$324F  A4 26     LDY $26 
$3251  B1 50     LDA ($50),Y 
$3253  F0 0A     BEQ L_BRS_($325F)_($3253) OK
$3255  A5 57     LDA $57 
$3257  38        SEC 
$3258  E5 58     SBC $58 
$325A  85 49     STA $49 
$325C  20 E3 36  JSR L_JSR_($36E3)_($325C) OK
//------------------------------
L_BRS_($325F)_($3253) OK
//------------------------------
$325F  E6 51     INC $51 
$3261  E6 4A     INC $4A 
$3263  CA        DEX 
$3264  D0 E9     BNE L_BRS_($324F)_($3264) OK
$3266  4C 70 32  JMP L_JMP_($3270)_($3266) OK
//------------------------------
L_JMP_($3269)_($3246) OK
L_BRS_($3269)_($324B) OK
//------------------------------
$3269  A5 51     LDA $51 
$326B  18        CLC 
$326C  69 04     ADC #$04
$326E  85 51     STA $51 
//------------------------------
L_JMP_($3270)_($3266) OK
//------------------------------
$3270  E6 57     INC $57 
$3272  A5 51     LDA $51 
$3274  C9 99     CMP #$99
$3276  90 C4     BCC L_BRS_($323C)_($3276) OK
$3278  60        RTS 
//------------------------------
L_JSR_($3279)_($0877) OK
L_JSR_($3279)_($0931) OK
L_JSR_($3279)_($0950) OK
L_JSR_($3279)_($09B1) OK
L_JSR_($3279)_($09C1) OK
L_JSR_($3279)_($09D8) OK
L_JSR_($3279)_($09E2) OK
L_JSR_($3279)_($14A6) OK
L_JSR_($3279)_($15A6) OK
L_JSR_($3279)_($15AF) OK
L_JSR_($3279)_($15BA) OK
L_JSR_($3279)_($163C) OK
L_JSR_($3279)_($1662) OK
L_JSR_($3279)_($1687) OK
L_JSR_($3279)_($1696) OK
L_JSR_($3279)_($1829) OK
L_JSR_($3279)_($1986) OK
L_JSR_($3279)_($1990) OK
L_JSR_($3279)_($1EF2) OK
L_JSR_($3279)_($1F02) OK
L_JSR_($3279)_($22CC) OK
L_JSR_($3279)_($22DD) OK
L_JSR_($3279)_($26D1) OK
L_JSR_($3279)_($27E4) OK
L_JSR_($3279)_($2804) OK
L_JSR_($3279)_($2846) OK
L_JSR_($3279)_($29F1) OK
L_JSR_($3279)_($2A3A) OK
L_JSR_($3279)_($2B75) OK
L_JSR_($3279)_($2B99) OK
L_JSR_($3279)_($2E95) OK
L_JSR_($3279)_($3ACB) OK
L_JSR_($3279)_($3B1F) OK
L_JSR_($3279)_($BE90) OK
L_JSR_($3279)_($BEE4) OK
L_JSR_($3279)_($BFAC) OK
L_JSR_($3279)_($FAAC) OK
L_JSR_($3279)_($FB00) OK
L_JSR_($3279)_($FBC8) OK
//------------------------------
$3279  A9 60     LDA #$60
$327B  85 4E     STA $4E 
$327D  A9 78     LDA #$78
$327F  85 4F     STA $4F 
$3281  A6 60     LDX $60 
$3283  F0 05     BEQ L_BRS_($328A)_($3283) OK
//------------------------------
L_BRS_($3285)_($3288) OK
//------------------------------
$3285  E6 4F     INC $4F 
$3287  CA        DEX 
$3288  D0 FB     BNE L_BRS_($3285)_($3288) OK
//------------------------------
L_BRS_($328A)_($3283) OK
//------------------------------
$328A  A0 00     LDY #$00
$328C  B1 4E     LDA ($4E),Y 
$328E  85 26     STA $26 
$3290  C8        INY 
$3291  B1 4E     LDA ($4E),Y 
$3293  85 FC     STA $FC 
$3295  C8        INY 
$3296  B1 4E     LDA ($4E),Y 
$3298  85 FB     STA $FB 
$329A  C8        INY 
$329B  B1 4E     LDA ($4E),Y 
$329D  85 29     STA $29 
$329F  C8        INY 
$32A0  B1 4E     LDA ($4E),Y 
$32A2  85 2A     STA $2A 
$32A4  C8        INY 
$32A5  B1 4E     LDA ($4E),Y 
$32A7  85 A6     STA $A6 
$32A9  C8        INY 
$32AA  B1 4E     LDA ($4E),Y 
$32AC  85 A7     STA $A7 
$32AE  C8        INY 
$32AF  B1 4E     LDA ($4E),Y 
$32B1  85 A8     STA $A8 
$32B3  C8        INY 
$32B4  B1 4E     LDA ($4E),Y 
$32B6  85 A9     STA $A9 
$32B8  C8        INY 
$32B9  B1 4E     LDA ($4E),Y 
$32BB  85 AA     STA $AA 
$32BD  C8        INY 
$32BE  B1 4E     LDA ($4E),Y 
$32C0  85 AB     STA $AB 
$32C2  C8        INY 
$32C3  B1 4E     LDA ($4E),Y 
$32C5  85 AC     STA $AC 
$32C7  C8        INY 
$32C8  B1 4E     LDA ($4E),Y 
$32CA  85 AD     STA $AD 
$32CC  C8        INY 
$32CD  B1 4E     LDA ($4E),Y 
$32CF  85 AE     STA $AE 
$32D1  C8        INY 
$32D2  B1 4E     LDA ($4E),Y 
$32D4  85 AF     STA $AF 
$32D6  C8        INY 
$32D7  B1 4E     LDA ($4E),Y 
$32D9  85 B0     STA $B0 
$32DB  C8        INY 
$32DC  B1 4E     LDA ($4E),Y 
$32DE  85 B1     STA $B1 
$32E0  C8        INY 
$32E1  B1 4E     LDA ($4E),Y 
$32E3  85 B2     STA $B2 
$32E5  C8        INY 
$32E6  B1 4E     LDA ($4E),Y 
$32E8  85 B3     STA $B3 
$32EA  C8        INY 
$32EB  B1 4E     LDA ($4E),Y 
$32ED  85 B4     STA $B4 
$32EF  C8        INY 
$32F0  B1 4E     LDA ($4E),Y 
$32F2  85 B5     STA $B5 
$32F4  C8        INY 
$32F5  B1 4E     LDA ($4E),Y 
$32F7  85 3B     STA $3B 
$32F9  C8        INY 
$32FA  B1 4E     LDA ($4E),Y 
$32FC  85 3C     STA $3C 
$32FE  C8        INY 
$32FF  B1 4E     LDA ($4E),Y 
$3301  85 3D     STA $3D 
$3303  C8        INY 
$3304  B1 4E     LDA ($4E),Y 
$3306  85 3E     STA $3E 
$3308  C8        INY 
$3309  B1 4E     LDA ($4E),Y 
$330B  85 FF     STA $FF 
$330D  C8        INY 
$330E  B1 4E     LDA ($4E),Y 
$3310  85 3F     STA $3F 
$3312  C8        INY 
$3313  B1 4E     LDA ($4E),Y 
$3315  85 39     STA $39 
$3317  C8        INY 
$3318  B1 4E     LDA ($4E),Y 
$331A  85 3A     STA $3A 
$331C  C8        INY 
$331D  B1 4E     LDA ($4E),Y 
$331F  C8        INY 
$3320  B1 4E     LDA ($4E),Y 
$3322  C8        INY 
$3323  B1 4E     LDA ($4E),Y 
$3325  60        RTS 
//------------------------------
L_JSR_($3326)_($321B) OK
//------------------------------
$3326  20 E6 2E  JSR L_JSR_($2EE6)_($3326) OK ; update tile on screen
//------------------------------
L_JSR_($3329)_($2F92) OK
//------------------------------
$3329  A5 27     LDA $27 
$332B  85 52     STA $52 ; low byte of tilemap cell address
$332D  29 60     AND #$60
$332F  4A        LSR A 
$3330  4A        LSR A 
$3331  18        CLC 
$3332  69 67     ADC #$67 ; page with graphics data $67+(X&$60)>>2
$3334  85 55     STA $55 
$3336  A5 28     LDA $28 
$3338  18        CLC 
$3339  69 78     ADC #$78
$333B  85 53     STA $53 ; high byte of tilemap cell address
						 ; tilemap address = ($78+Y)*$100+X
$333D  A0 80     LDY #$80
$333F  B1 52     LDA ($52),Y 
$3341  A0 00     LDY #$00
$3343  91 5C     STA ($5C),Y ; set attribute
$3345  B1 52     LDA ($52),Y 
$3347  85 54     STA $54 
$3349  A2 07     LDX #$07
//------------------------------
L_BRS_($334B)_($3353) OK
//------------------------------
$334B  B1 54     LDA ($54),Y 
$334D  9D 00 40  STA $4000,X 
$3350  C6 55     DEC $55 
$3352  CA        DEX 
$3353  10 F6     BPL L_BRS_($334B)_($3353) OK
$3355  84 50     STY $50 
$3357  A9 60     LDA #$60
$3359  85 52     STA $52 
$335B  A9 78     LDA #$78
$335D  85 53     STA $53 
$335F  A2 EB     LDX #$EB
//------------------------------
L_BRS_($3361)_($33B3) OK
//------------------------------
$3361  A0 01     LDY #$01
$3363  A5 27     LDA $27 
$3365  38        SEC 
$3366  F1 52     SBC ($52),Y 
$3368  C9 03     CMP #$03
$336A  B0 44     BCS L_BRS_($33B0)_($336A) OK
$336C  0A        ASL A 
$336D  0A        ASL A 
$336E  85 55     STA $55 
$3370  A5 28     LDA $28 
$3372  C8        INY 
$3373  38        SEC 
$3374  F1 52     SBC ($52),Y 
$3376  C9 04     CMP #$04
$3378  B0 36     BCS L_BRS_($33B0)_($3378) OK
$337A  65 55     ADC $55 
$337C  69 8D     ADC #$8D
$337E  85 55     STA $55 
$3380  A0 00     LDY #$00
$3382  B1 52     LDA ($52),Y 
$3384  85 54     STA $54 
$3386  B1 54     LDA ($54),Y 
$3388  F0 26     BEQ L_BRS_($33B0)_($3388) OK
$338A  A8        TAY 
$338B  8A        TXA 
$338C  48        PHA 
$338D  A9 A8     LDA #$A8
$338F  E0 F6     CPX #$F6
$3391  90 06     BCC L_BRS_($3399)_($3391) OK
$3393  E0 FA     CPX #$FA
$3395  B0 02     BCS L_BRS_($3399)_($3395) OK
$3397  A9 B8     LDA #$B8
//------------------------------
L_BRS_($3399)_($3391) OK
L_BRS_($3399)_($3395) OK
//------------------------------
$3399  85 51     STA $51 
$339B  A2 07     LDX #$07
//------------------------------
L_BRS_($339D)_($33AC) OK
//------------------------------
$339D  B1 50     LDA ($50),Y 
$339F  3D 00 40  AND $4000,X 
$33A2  C6 51     DEC $51 
$33A4  11 50     ORA ($50),Y
$33A6  9D 00 40  STA $4000,X 
$33A9  C6 51     DEC $51 
$33AB  CA        DEX 
$33AC  10 EF     BPL L_BRS_($339D)_($33AC) OK
$33AE  68        PLA 
$33AF  AA        TAX 
//------------------------------
L_BRS_($33B0)_($336A) OK
L_BRS_($33B0)_($3378) OK
L_BRS_($33B0)_($3388) OK
//------------------------------
$33B0  E6 53     INC $53 
$33B2  E8        INX 
$33B3  D0 AC     BNE L_BRS_($3361)_($33B3) OK
$33B5  A0 07     LDY #$07		; TODO: draw tile on screen?
//------------------------------
L_BRS_($33B7)_($33BC) OK
//------------------------------
$33B7  B1 5E     LDA ($5E),Y 
$33B9  91 5A     STA ($5A),Y 
$33BB  88        DEY 
$33BC  10 F9     BPL L_BRS_($33B7)_($33BC) OK
$33BE  60        RTS 
//------------------------------
L_JSR_($33BF)_($0910) OK
L_JSR_($33BF)_($1636) OK
L_JSR_($33BF)_($181E) OK
L_JSR_($33BF)_($197F) OK
L_JSR_($33BF)_($1EE7) OK
L_JSR_($33BF)_($1EFB) OK
L_JSR_($33BF)_($22D7) OK
L_JSR_($33BF)_($26C6) OK
L_JSR_($33BF)_($27DA) OK
L_JSR_($33BF)_($29E6) OK
L_JSR_($33BF)_($2A25) OK
L_JSR_($33BF)_($2B6E) OK
L_JSR_($33BF)_($2B92) OK
L_JSR_($33BF)_($2EC2) OK
L_JSR_($33BF)_($3618) OK
L_JSR_($33BF)_($3AD1) OK
L_JSR_($33BF)_($3B39) OK
L_JSR_($33BF)_($BEE1) OK
L_JSR_($33BF)_($BEF4) OK
L_JSR_($33BF)_($BFA9) OK
L_JSR_($33BF)_($BFBC) OK
L_JSR_($33BF)_($FAFD) OK
L_JSR_($33BF)_($FB10) OK
L_JSR_($33BF)_($FBC5) OK
L_JSR_($33BF)_($FBD8) OK
//------------------------------
$33BF  A9 60     LDA #$60
$33C1  85 4E     STA $4E 
$33C3  A9 78     LDA #$78
$33C5  85 4F     STA $4F 
$33C7  A6 60     LDX $60 
$33C9  F0 05     BEQ L_BRS_($33D0)_($33C9) OK
//------------------------------
L_BRS_($33CB)_($33CE) OK
//------------------------------
$33CB  E6 4F     INC $4F 
$33CD  CA        DEX 
$33CE  D0 FB     BNE L_BRS_($33CB)_($33CE) OK
//------------------------------
L_BRS_($33D0)_($33C9) OK
//------------------------------
$33D0  A0 00     LDY #$00
$33D2  A5 26     LDA $26 
$33D4  91 4E     STA ($4E),Y 
$33D6  C8        INY 
$33D7  A5 FC     LDA $FC 
$33D9  91 4E     STA ($4E),Y 
$33DB  C8        INY 
$33DC  A5 FB     LDA $FB 
$33DE  91 4E     STA ($4E),Y 
$33E0  C8        INY 
$33E1  A5 29     LDA $29 
$33E3  91 4E     STA ($4E),Y 
$33E5  C8        INY 
$33E6  A5 2A     LDA $2A 
$33E8  91 4E     STA ($4E),Y 
$33EA  C8        INY 
$33EB  A5 A6     LDA $A6 
$33ED  91 4E     STA ($4E),Y 
$33EF  C8        INY 
$33F0  A5 A7     LDA $A7 
$33F2  91 4E     STA ($4E),Y 
$33F4  C8        INY 
$33F5  A5 A8     LDA $A8 
$33F7  91 4E     STA ($4E),Y 
$33F9  C8        INY 
$33FA  A5 A9     LDA $A9 
$33FC  91 4E     STA ($4E),Y 
$33FE  C8        INY 
$33FF  A5 AA     LDA $AA 
$3401  91 4E     STA ($4E),Y 
$3403  C8        INY 
$3404  A5 AB     LDA $AB 
$3406  91 4E     STA ($4E),Y 
$3408  C8        INY 
$3409  A5 AC     LDA $AC 
$340B  91 4E     STA ($4E),Y 
$340D  C8        INY 
$340E  A5 AD     LDA $AD 
$3410  91 4E     STA ($4E),Y 
$3412  C8        INY 
$3413  A5 AE     LDA $AE 
$3415  91 4E     STA ($4E),Y 
$3417  C8        INY 
$3418  A5 AF     LDA $AF 
$341A  91 4E     STA ($4E),Y 
$341C  C8        INY 
$341D  A5 B0     LDA $B0 
$341F  91 4E     STA ($4E),Y 
$3421  C8        INY 
$3422  A5 B1     LDA $B1 
$3424  91 4E     STA ($4E),Y 
$3426  C8        INY 
$3427  A5 B2     LDA $B2 
$3429  91 4E     STA ($4E),Y 
$342B  C8        INY 
$342C  A5 B3     LDA $B3 
$342E  91 4E     STA ($4E),Y 
$3430  C8        INY 
$3431  A5 B4     LDA $B4 
$3433  91 4E     STA ($4E),Y 
$3435  C8        INY 
$3436  A5 B5     LDA $B5 
$3438  91 4E     STA ($4E),Y 
$343A  C8        INY 
$343B  A5 3B     LDA $3B 
$343D  91 4E     STA ($4E),Y 
$343F  C8        INY 
$3440  A5 3C     LDA $3C 
$3442  91 4E     STA ($4E),Y 
$3444  C8        INY 
$3445  A5 3D     LDA $3D 
$3447  91 4E     STA ($4E),Y 
$3449  C8        INY 
$344A  A5 3E     LDA $3E 
$344C  91 4E     STA ($4E),Y 
$344E  C8        INY 
$344F  A5 FF     LDA $FF 
$3451  91 4E     STA ($4E),Y 
$3453  C8        INY 
$3454  A5 3F     LDA $3F 
$3456  91 4E     STA ($4E),Y 
$3458  C8        INY 
$3459  A5 39     LDA $39 
$345B  91 4E     STA ($4E),Y 
$345D  C8        INY 
$345E  A5 3A     LDA $3A 
$3460  91 4E     STA ($4E),Y 
$3462  C8        INY 
$3463  A5 4E     LDA $4E 
$3465  91 4E     STA ($4E),Y 
$3467  C8        INY 
$3468  A5 4E     LDA $4E 
$346A  91 4E     STA ($4E),Y 
$346C  C8        INY 
$346D  A5 4E     LDA $4E 
$346F  91 4E     STA ($4E),Y 
$3471  60        RTS 
//------------------------------
$3472  A5 2B     LDA $2B 
$3474  29 10     AND #$10
$3476  D0 30     BNE L_BRS_($34A8)_($3476) OK
$3478  85 4B     STA $4B 
$347A  A9 14     LDA #$14
$347C  85 0F     STA $0F 
$347E  20 2E 32  JSR L_JSR_($322E)_($347E) OK
$3481  A9 1A     LDA #$1A
$3483  8D 13 D4  STA $D413                          // Voice 3: Attack / Decay Cycle Control ; Attack = 01, Decay = 0A
$3486  A9 81     LDA #$81
$3488  8D 12 D4  STA $D412                          // Voice 3: Control Register ; Noise on, Gate Bit: 1 = Start Att,Dec,Sus
$348B  A5 26     LDA $26 
$348D  C9 05     CMP #$05
$348F  D0 08     BNE L_BRS_($3499)_($348F) OK
$3491  E6 26     INC $26 
$3493  20 2E 32  JSR L_JSR_($322E)_($3493) OK
$3496  4C B4 34  JMP L_JMP_($34B4)_($3496) OK
//------------------------------
L_BRS_($3499)_($348F) OK
//------------------------------
$3499  A5 26     LDA $26 
$349B  29 80     AND #$80
$349D  18        CLC 
$349E  69 07     ADC #$07
$34A0  85 26     STA $26 
$34A2  20 2E 32  JSR L_JSR_($322E)_($34A2) OK
$34A5  4C B4 34  JMP L_JMP_($34B4)_($34A5) OK
//------------------------------
L_BRS_($34A8)_($3476) OK
//------------------------------
$34A8  C6 0F     DEC $0F 
$34AA  D0 08     BNE L_BRS_($34B4)_($34AA) OK
$34AC  A9 00     LDA #$00
$34AE  85 2B     STA $2B 
$34B0  A9 FF     LDA #$FF
$34B2  85 14     STA $14 
//------------------------------
L_JMP_($34B4)_($3496) OK
L_JMP_($34B4)_($34A5) OK
L_BRS_($34B4)_($34AA) OK
//------------------------------
$34B4  60        RTS 
//------------------------------
L_JSR_($34B5)_($08BA) OK
L_JMP_($34B5)_($3574) OK
L_JMP_($34B5)_($35B7) OK
//------------------------------
$34B5  A5 26     LDA $26 
$34B7  29 04     AND #$04
$34B9  D0 4E     BNE L_BRS_($3509)_($34B9) OK
$34BB  20 8E 1C  JSR L_JSR_($1C8E)_($34BB) OK
$34BE  90 16     BCC L_BRS_($34D6)_($34BE) OK
$34C0  A5 FC     LDA $FC 
$34C2  C9 30     CMP #$30
$34C4  B0 08     BCS L_BRS_($34CE)_($34C4) OK
$34C6  A5 26     LDA $26 
$34C8  0A        ASL A 
$34C9  B0 28     BCS L_BRS_($34F3)_($34C9) OK
$34CB  4C 4E 36  JMP L_JMP_($364E)_($34CB) OK
//------------------------------
L_BRS_($34CE)_($34C4) OK
//------------------------------
$34CE  A5 26     LDA $26 
$34D0  0A        ASL A 
$34D1  90 20     BCC L_BRS_($34F3)_($34D1) OK
$34D3  4C 4E 36  JMP L_JMP_($364E)_($34D3) OK
//------------------------------
L_BRS_($34D6)_($34BE) OK
//------------------------------
$34D6  A5 FB     LDA $FB 
$34D8  C9 11     CMP #$11
$34DA  F0 22     BEQ L_BRS_($34FE)_($34DA) OK
$34DC  A5 26     LDA $26 
$34DE  0A        ASL A 
$34DF  B0 09     BCS L_BRS_($34EA)_($34DF) OK
$34E1  A5 FC     LDA $FC 
$34E3  C9 4D     CMP #$4D
$34E5  F0 0C     BEQ L_BRS_($34F3)_($34E5) OK
$34E7  4C 58 35  JMP L_JMP_($3558)_($34E7) OK
//------------------------------
L_BRS_($34EA)_($34DF) OK
//------------------------------
$34EA  A5 FC     LDA $FC 
$34EC  C9 0C     CMP #$0C
$34EE  F0 03     BEQ L_BRS_($34F3)_($34EE) OK
$34F0  4C 9E 35  JMP L_JMP_($359E)_($34F0) OK
//------------------------------
L_BRS_($34F3)_($34C9) OK
L_BRS_($34F3)_($34D1) OK
L_BRS_($34F3)_($34E5) OK
L_BRS_($34F3)_($34EE) OK
//------------------------------
$34F3  A9 01     LDA #$01
$34F5  85 11     STA $11 
$34F7  A9 00     LDA #$00
$34F9  85 10     STA $10 
$34FB  4C 5C 36  JMP L_JMP_($365C)_($34FB) OK
//------------------------------
L_BRS_($34FE)_($34DA) OK
L_JMP_($34FE)_($3554) OK
//------------------------------
$34FE  A5 26     LDA $26 
$3500  0A        ASL A 
$3501  B0 03     BCS L_BRS_($3506)_($3501) OK
$3503  4C 58 35  JMP L_JMP_($3558)_($3503) OK
//------------------------------
L_BRS_($3506)_($3501) OK
//------------------------------
$3506  4C 9E 35  JMP L_JMP_($359E)_($3506) OK
//------------------------------
L_BRS_($3509)_($34B9) OK
//------------------------------
$3509  60        RTS 
//------------------------------
L_JSR_($350A)_($AB2C) OK
L_JSR_($350A)_($E7A5) OK
//------------------------------
$350A  EA        NOP 
//------------------------------
L_JSR_($350B)_($08B0) OK
L_JMP_($350B)_($3571) OK
L_JMP_($350B)_($35BA) OK
//------------------------------
$350B  A5 26     LDA $26 
$350D  29 04     AND #$04
$350F  D0 46     BNE L_BRS_($3557)_($350F) OK
$3511  20 8E 1C  JSR L_JSR_($1C8E)_($3511) OK
$3514  90 16     BCC L_BRS_($352C)_($3514) OK
$3516  A5 FC     LDA $FC 
$3518  C9 30     CMP #$30
$351A  B0 08     BCS L_BRS_($3524)_($351A) OK
$351C  A5 26     LDA $26 
$351E  0A        ASL A 
$351F  90 28     BCC L_BRS_($3549)_($351F) OK
$3521  4C 4E 36  JMP L_JMP_($364E)_($3521) OK
//------------------------------
L_BRS_($3524)_($351A) OK
//------------------------------
$3524  A5 26     LDA $26 
$3526  0A        ASL A 
$3527  B0 20     BCS L_BRS_($3549)_($3527) OK
$3529  4C 4E 36  JMP L_JMP_($364E)_($3529) OK
//------------------------------
L_BRS_($352C)_($3514) OK
//------------------------------
$352C  A5 FB     LDA $FB 
$352E  C9 03     CMP #$03
$3530  F0 22     BEQ L_BRS_($3554)_($3530) OK
$3532  A5 26     LDA $26 
$3534  0A        ASL A 
$3535  B0 09     BCS L_BRS_($3540)_($3535) OK
$3537  A5 FC     LDA $FC 
$3539  C9 13     CMP #$13
$353B  F0 0C     BEQ L_BRS_($3549)_($353B) OK
$353D  4C 58 35  JMP L_JMP_($3558)_($353D) OK
//------------------------------
L_BRS_($3540)_($3535) OK
//------------------------------
$3540  A5 FC     LDA $FC 
$3542  C9 46     CMP #$46
$3544  F0 03     BEQ L_BRS_($3549)_($3544) OK
$3546  4C 9E 35  JMP L_JMP_($359E)_($3546) OK
//------------------------------
L_BRS_($3549)_($351F) OK
L_BRS_($3549)_($3527) OK
L_BRS_($3549)_($353B) OK
L_BRS_($3549)_($3544) OK
//------------------------------
$3549  A9 00     LDA #$00
$354B  85 11     STA $11 
$354D  A9 FF     LDA #$FF
$354F  85 10     STA $10 
$3551  4C 5C 36  JMP L_JMP_($365C)_($3551) OK
//------------------------------
L_BRS_($3554)_($3530) OK
//------------------------------
$3554  4C FE 34  JMP L_JMP_($34FE)_($3554) OK
//------------------------------
L_BRS_($3557)_($350F) OK
//------------------------------
$3557  60        RTS 
//------------------------------
L_JSR_($3558)_($089C) OK
L_JMP_($3558)_($34E7) OK
L_JMP_($3558)_($3503) OK
L_JMP_($3558)_($353D) OK
//------------------------------
$3558  A5 26     LDA $26 
$355A  29 04     AND #$04
$355C  D0 3F     BNE L_BRS_($359D)_($355C) OK
$355E  A5 26     LDA $26 
$3560  0A        ASL A 
$3561  90 03     BCC L_BRS_($3566)_($3561) OK
$3563  4C 4E 36  JMP L_JMP_($364E)_($3563) OK
//------------------------------
L_BRS_($3566)_($3561) OK
//------------------------------
$3566  20 8E 1C  JSR L_JSR_($1C8E)_($3566) OK
$3569  90 0C     BCC L_BRS_($3577)_($3569) OK
$356B  A5 FC     LDA $FC 
$356D  C9 30     CMP #$30
$356F  B0 03     BCS L_BRS_($3574)_($356F) OK
$3571  4C 0B 35  JMP L_JMP_($350B)_($3571) OK
//------------------------------
L_BRS_($3574)_($356F) OK
//------------------------------
$3574  4C B5 34  JMP L_JMP_($34B5)_($3574) OK
//------------------------------
L_BRS_($3577)_($3569) OK
//------------------------------
$3577  A5 FC     LDA $FC 
$3579  F0 22     BEQ L_BRS_($359D)_($3579) OK
$357B  A5 12     LDA $12 
$357D  C9 02     CMP #$02
$357F  D0 09     BNE L_BRS_($358A)_($357F) OK
$3581  A5 FC     LDA $FC 
$3583  C9 3A     CMP #$3A
$3585  F0 16     BEQ L_BRS_($359D)_($3585) OK
$3587  4C 94 35  JMP L_JMP_($3594)_($3587) OK
//------------------------------
L_BRS_($358A)_($357F) OK
//------------------------------
$358A  C9 01     CMP #$01
$358C  D0 06     BNE L_BRS_($3594)_($358C) OK
$358E  A5 FC     LDA $FC 
$3590  C9 27     CMP #$27
$3592  F0 09     BEQ L_BRS_($359D)_($3592) OK
//------------------------------
L_JMP_($3594)_($3587) OK
L_BRS_($3594)_($358C) OK
L_JMP_($3594)_($35EB) OK
//------------------------------
$3594  A9 00     LDA #$00
$3596  85 10     STA $10 
$3598  85 11     STA $11 
$359A  4C 5C 36  JMP L_JMP_($365C)_($359A) OK
//------------------------------
L_BRS_($359D)_($355C) OK
L_BRS_($359D)_($3579) OK
L_BRS_($359D)_($3585) OK
L_BRS_($359D)_($3592) OK
//------------------------------
$359D  60        RTS 
//------------------------------
L_JSR_($359E)_($08A6) OK
L_JMP_($359E)_($34F0) OK
L_JMP_($359E)_($3506) OK
L_JMP_($359E)_($3546) OK
//------------------------------
$359E  A5 26     LDA $26 
$35A0  29 04     AND #$04
$35A2  D0 4A     BNE L_BRS_($35EE)_($35A2) OK
$35A4  A5 26     LDA $26 
$35A6  0A        ASL A 
$35A7  B0 03     BCS L_BRS_($35AC)_($35A7) OK
$35A9  4C 4E 36  JMP L_JMP_($364E)_($35A9) OK
//------------------------------
L_BRS_($35AC)_($35A7) OK
//------------------------------
$35AC  20 8E 1C  JSR L_JSR_($1C8E)_($35AC) OK
$35AF  90 0C     BCC L_BRS_($35BD)_($35AF) OK
$35B1  A5 FC     LDA $FC 
$35B3  C9 30     CMP #$30
$35B5  B0 03     BCS L_BRS_($35BA)_($35B5) OK
$35B7  4C B5 34  JMP L_JMP_($34B5)_($35B7) OK
//------------------------------
L_BRS_($35BA)_($35B5) OK
//------------------------------
$35BA  4C 0B 35  JMP L_JMP_($350B)_($35BA) OK
//------------------------------
L_BRS_($35BD)_($35AF) OK
//------------------------------
$35BD  A5 12     LDA $12 
$35BF  C9 02     CMP #$02
$35C1  D0 0D     BNE L_BRS_($35D0)_($35C1) OK
$35C3  A5 FC     LDA $FC 
$35C5  C9 38     CMP #$38
$35C7  F0 25     BEQ L_BRS_($35EE)_($35C7) OK
$35C9  C9 5D     CMP #$5D
$35CB  F0 21     BEQ L_BRS_($35EE)_($35CB) OK
$35CD  4C EB 35  JMP L_JMP_($35EB)_($35CD) OK
//------------------------------
L_BRS_($35D0)_($35C1) OK
//------------------------------
$35D0  C9 01     CMP #$01
$35D2  D0 0D     BNE L_BRS_($35E1)_($35D2) OK
$35D4  A5 FC     LDA $FC 
$35D6  C9 25     CMP #$25
$35D8  F0 14     BEQ L_BRS_($35EE)_($35D8) OK
$35DA  C9 4E     CMP #$4E
$35DC  F0 10     BEQ L_BRS_($35EE)_($35DC) OK
$35DE  4C EB 35  JMP L_JMP_($35EB)_($35DE) OK
//------------------------------
L_BRS_($35E1)_($35D2) OK
//------------------------------
$35E1  C9 00     CMP #$00
$35E3  D0 06     BNE L_BRS_($35EB)_($35E3) OK
$35E5  A5 FC     LDA $FC 
$35E7  C9 5D     CMP #$5D
$35E9  F0 03     BEQ L_BRS_($35EE)_($35E9) OK
//------------------------------
L_JMP_($35EB)_($35CD) OK
L_JMP_($35EB)_($35DE) OK
L_BRS_($35EB)_($35E3) OK
//------------------------------
$35EB  4C 94 35  JMP L_JMP_($3594)_($35EB) OK
//------------------------------
L_BRS_($35EE)_($35A2) OK
L_BRS_($35EE)_($35C7) OK
L_BRS_($35EE)_($35CB) OK
L_BRS_($35EE)_($35D8) OK
L_BRS_($35EE)_($35DC) OK
L_BRS_($35EE)_($35E9) OK
//------------------------------
$35EE  60        RTS 
//------------------------------
L_JSR_($35EF)_($0907) OK
//------------------------------
$35EF  20 2E 32  JSR L_JSR_($322E)_($35EF) OK
$35F2  A5 26     LDA $26 
$35F4  0A        ASL A 
$35F5  90 05     BCC L_BRS_($35FC)_($35F5) OK
$35F7  E6 FC     INC $FC 
$35F9  4C FE 35  JMP L_JMP_($35FE)_($35F9) OK
//------------------------------
L_BRS_($35FC)_($35F5) OK
//------------------------------
$35FC  C6 FC     DEC $FC 
//------------------------------
L_JMP_($35FE)_($35F9) OK
//------------------------------
$35FE  A5 FB     LDA $FB 
$3600  18        CLC 
$3601  65 11     ADC $11 
$3603  85 FB     STA $FB 
$3605  A5 FC     LDA $FC 
$3607  29 01     AND #$01
$3609  0A        ASL A 
$360A  85 57     STA $57 
$360C  A5 26     LDA $26 
$360E  29 FC     AND #$FC
$3610  18        CLC 
$3611  65 57     ADC $57 
$3613  85 26     STA $26 
$3615  20 2E 32  JSR L_JSR_($322E)_($3615) OK
$3618  20 BF 33  JSR L_JSR_($33BF)_($3618) OK
$361B  20 EA 31  JSR L_JSR_($31EA)_($361B) OK
$361E  A9 01     LDA #$01
$3620  8D 13 D4  STA $D413                          // Voice 3: Attack / Decay Cycle Control ; Attack = 00, Decay = 01
$3623  A9 81     LDA #$81
$3625  8D 12 D4  STA $D412                          // Voice 3: Control Register ; Noise on, Gate Bit: 1 = Start Att,Dec,Sus
$3628  A5 FC     LDA $FC 
$362A  38        SEC 
//------------------------------
L_JSR_($362B)_($7F47) OK
//------------------------------
$362B  E5 58     SBC $58 
$362D  C9 07     CMP #$07
$362F  D0 0A     BNE L_BRS_($363B)_($362F) OK
$3631  A5 58     LDA $58 
$3633  F0 18     BEQ L_BRS_($364D)_($3633) OK
$3635  20 72 30  JSR L_JSR_($3072)_($3635) OK
$3638  4C 4D 36  JMP L_JMP_($364D)_($3638) OK
//------------------------------
L_BRS_($363B)_($362F) OK
//------------------------------
$363B  A5 FC     LDA $FC 
$363D  38        SEC 
$363E  E5 58     SBC $58 
$3640  C9 1F     CMP #$1F
$3642  D0 09     BNE L_BRS_($364D)_($3642) OK
$3644  A5 59     LDA $59 
$3646  C9 60     CMP #$60
$3648  F0 03     BEQ L_BRS_($364D)_($3648) OK
$364A  20 13 31  JSR L_JSR_($3113)_($364A) OK
//------------------------------
L_BRS_($364D)_($3633) OK
L_JMP_($364D)_($3638) OK
L_BRS_($364D)_($3642) OK
L_BRS_($364D)_($3648) OK
//------------------------------
$364D  60        RTS 
//------------------------------
L_JMP_($364E)_($34CB) OK
L_JMP_($364E)_($34D3) OK
L_JMP_($364E)_($3521) OK
L_JMP_($364E)_($3529) OK
L_JMP_($364E)_($3563) OK
L_JMP_($364E)_($35A9) OK
//------------------------------
$364E  20 2E 32  JSR L_JSR_($322E)_($364E) OK
$3651  A5 26     LDA $26 
$3653  49 80     EOR #$80
$3655  85 26     STA $26 
$3657  A9 05     LDA #$05
$3659  85 13     STA $13 
$365B  60        RTS 
//------------------------------
L_JMP_($365C)_($34FB) OK
L_JMP_($365C)_($3551) OK
L_JMP_($365C)_($359A) OK
//------------------------------
$365C  20 2E 32  JSR L_JSR_($322E)_($365C) OK
$365F  A5 FB     LDA $FB 
$3661  18        CLC 
$3662  65 10     ADC $10 
$3664  85 FB     STA $FB 
$3666  E6 26     INC $26 
//------------------------------
L_JMP_($3668)_($B503) OK
L_JMP_($3668)_($F17E) OK
//------------------------------
$3668  20 2E 32  JSR L_JSR_($322E)_($3668) OK
$366B  A5 C5     LDA $C5 
$366D  C9 C0     CMP #$C0
$366F  B0 05     BCS L_BRS_($3676)_($366F) OK
$3671  A9 06     LDA #$06
$3673  4C 78 36  JMP L_JMP_($3678)_($3673) OK
//------------------------------
L_BRS_($3676)_($366F) OK
//------------------------------
$3676  A9 02     LDA #$02
//------------------------------
L_JMP_($3678)_($3673) OK
//------------------------------
$3678  85 E5     STA $E5 
$367A  85 4B     STA $4B 
$367C  A9 01     LDA #$01
$367E  8D 13 D4  STA $D413                          // Voice 3: Attack / Decay Cycle Control ; Attack = 00, Decay = 01
$3681  A9 81     LDA #$81
$3683  8D 12 D4  STA $D412                          // Voice 3: Control Register ; Noise on, Gate Bit: 1 = Start Att,Dec,Sus
$3686  60        RTS 
//------------------------------
L_JSR_($3687)_($08C4) OK
//------------------------------
$3687  A9 1A     LDA #$1A
$3689  8D 13 D4  STA $D413                          // Voice 3: Attack / Decay Cycle Control ; Attack = 01, Decay = 0A
$368C  A9 81     LDA #$81
$368E  8D 12 D4  STA $D412                          // Voice 3: Control Register ; Noise on, Gate Bit: 1 = Start Att,Dec,Sus
$3691  A5 14     LDA $14 
$3693  49 FF     EOR #$FF
$3695  85 14     STA $14 
$3697  D0 3D     BNE L_BRS_($36D6)_($3697) OK
$3699  20 2E 32  JSR L_JSR_($322E)_($3699) OK
$369C  20 8E 1C  JSR L_JSR_($1C8E)_($369C) OK
$369F  90 15     BCC L_BRS_($36B6)_($369F) OK
$36A1  A5 FC     LDA $FC 
$36A3  C9 30     CMP #$30
$36A5  B0 05     BCS L_BRS_($36AC)_($36A5) OK
$36A7  A9 85     LDA #$85
$36A9  4C AE 36  JMP L_JMP_($36AE)_($36A9) OK
//------------------------------
L_BRS_($36AC)_($36A5) OK
//------------------------------
$36AC  A9 05     LDA #$05
//------------------------------
L_JMP_($36AE)_($36A9) OK
//------------------------------
$36AE  85 26     STA $26 
$36B0  20 2E 32  JSR L_JSR_($322E)_($36B0) OK
$36B3  4C E2 36  JMP L_JMP_($36E2)_($36B3) OK
//------------------------------
L_BRS_($36B6)_($369F) OK
//------------------------------
$36B6  A5 12     LDA $12 
$36B8  F0 0D     BEQ L_BRS_($36C7)_($36B8) OK
$36BA  A5 26     LDA $26 
$36BC  0A        ASL A 
$36BD  B0 08     BCS L_BRS_($36C7)_($36BD) OK
$36BF  20 51 1A  JSR L_JSR_($1A51)_($36BF) OK
$36C2  D0 03     BNE L_BRS_($36C7)_($36C2) OK
$36C4  4C 59 1C  JMP L_JMP_($1C59)_($36C4) OK
//------------------------------
L_BRS_($36C7)_($36B8) OK
L_BRS_($36C7)_($36BD) OK
L_BRS_($36C7)_($36C2) OK
//------------------------------
$36C7  A5 26     LDA $26 
$36C9  29 80     AND #$80
$36CB  18        CLC 
$36CC  69 06     ADC #$06
$36CE  85 26     STA $26 
$36D0  20 2E 32  JSR L_JSR_($322E)_($36D0) OK
$36D3  4C E2 36  JMP L_JMP_($36E2)_($36D3) OK
//------------------------------
L_BRS_($36D6)_($3697) OK
//------------------------------
$36D6  20 2E 32  JSR L_JSR_($322E)_($36D6) OK
$36D9  A5 26     LDA $26 
$36DB  29 80     AND #$80
$36DD  85 26     STA $26 
$36DF  20 2E 32  JSR L_JSR_($322E)_($36DF) OK
//------------------------------
L_JMP_($36E2)_($36B3) OK
L_JMP_($36E2)_($36D3) OK
//------------------------------
$36E2  60        RTS 
//------------------------------
L_JSR_($36E3)_($120C) OK
L_JSR_($36E3)_($1211) OK
L_JSR_($36E3)_($174F) OK
L_JSR_($36E3)_($1754) OK
L_JSR_($36E3)_($325C) OK
//------------------------------
$36E3  A9 08     LDA #$08
$36E5  85 52     STA $52 
$36E7  A9 40     LDA #$40
$36E9  85 53     STA $53 
$36EB  A9 00     LDA #$00
$36ED  A4 4A     LDY $4A 
$36EF  F0 06     BEQ L_BRS_($36F7)_($36EF) OK
//------------------------------
L_BRS_($36F1)_($36F5) OK
//------------------------------
$36F1  18        CLC 
$36F2  69 05     ADC #$05
$36F4  88        DEY 
$36F5  D0 FA     BNE L_BRS_($36F1)_($36F5) OK
//------------------------------
L_BRS_($36F7)_($36EF) OK
//------------------------------
$36F7  85 55     STA $55 
$36F9  A5 49     LDA $49 
$36FB  4A        LSR A 
$36FC  4A        LSR A 
$36FD  4A        LSR A 
$36FE  85 56     STA $56 
$3700  0A        ASL A 
$3701  0A        ASL A 
$3702  0A        ASL A 
$3703  85 54     STA $54 
$3705  A5 49     LDA $49 
$3707  38        SEC 
$3708  E5 54     SBC $54 
$370A  A8        TAY 
$370B  A9 80     LDA #$80
$370D  C0 00     CPY #$00
$370F  F0 04     BEQ L_BRS_($3715)_($370F) OK
//------------------------------
L_BRS_($3711)_($3713) OK
//------------------------------
$3711  4A        LSR A 
$3712  88        DEY 
$3713  D0 FC     BNE L_BRS_($3711)_($3713) OK
//------------------------------
L_BRS_($3715)_($370F) OK
//------------------------------
$3715  85 54     STA $54 
$3717  A5 55     LDA $55 
$3719  18        CLC 
$371A  65 56     ADC $56 
$371C  A8        TAY 
$371D  B1 52     LDA ($52),Y 
$371F  05 54     ORA $54
$3721  91 52     STA ($52),Y 
$3723  60        RTS 
//------------------------------
L_JSR_($3724)_($20D8) OK
//------------------------------
$3724  A5 9C     LDA $9C 
$3726  18        CLC 
$3727  69 34     ADC #$34
$3729  8D 03 D0  STA $D003                          // Sprite 1 Y Pos
$372C  8D 05 D0  STA $D005                          // Sprite 2 Y Pos
$372F  8D 07 D0  STA $D007                          // Sprite 3 Y Pos
$3732  8D 09 D0  STA $D009                          // Sprite 4 Y Pos
$3735  8D 0B D0  STA $D00B                          // Sprite 5 Y Pos
$3738  AD 10 D0  LDA $D010                          // Sprites 0-7 MSB of X coordinate
$373B  D0 05     BNE L_BRS_($3742)_($373B) OK
$373D  A9 00     LDA #$00
$373F  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($3742)_($373B) OK
//------------------------------
$3742  A5 9B     LDA $9B 
$3744  8D 02 D0  STA $D002                          // Sprite 1 X Pos
$3747  8D 08 D0  STA $D008                          // Sprite 4 X Pos
$374A  18        CLC 
$374B  69 10     ADC #$10
$374D  8D 0A D0  STA $D00A                          // Sprite 5 X Pos
$3750  90 08     BCC L_BRS_($375A)_($3750) OK
$3752  A9 2C     LDA #$2C
$3754  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$3757  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($375A)_($3750) OK
//------------------------------
$375A  AD 0A D0  LDA $D00A                          // Sprite 5 X Pos
$375D  18        CLC 
$375E  69 08     ADC #$08
$3760  8D 04 D0  STA $D004                          // Sprite 2 X Pos
$3763  90 08     BCC L_BRS_($376D)_($3763) OK
$3765  A9 0C     LDA #$0C
$3767  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$376A  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($376D)_($3763) OK
//------------------------------
$376D  AD 04 D0  LDA $D004                          // Sprite 2 X Pos
$3770  18        CLC 
$3771  69 18     ADC #$18
$3773  8D 06 D0  STA $D006                          // Sprite 3 X Pos
$3776  90 08     BCC L_BRS_($3780)_($3776) OK
$3778  A9 08     LDA #$08
$377A  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$377D  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($3780)_($3776) OK
//------------------------------
$3780  A9 30     LDA #$30
$3782  8D 1D D0  STA $D01D                          // Sprites Expand 2x Horizontal (X)
$3785  A9 2B     LDA #$2B
$3787  8D F9 CF  STA $CFF9 
$378A  A9 2C     LDA #$2C
$378C  8D FA CF  STA $CFFA 
$378F  A9 2D     LDA #$2D
$3791  8D FB CF  STA $CFFB 
$3794  A9 2E     LDA #$2E
$3796  8D FC CF  STA $CFFC 
$3799  A9 2F     LDA #$2F
$379B  8D FD CF  STA $CFFD 
$379E  60        RTS 
//------------------------------
L_JSR_($379F)_($2415) OK
//------------------------------
$379F  8D 04 D0  STA $D004                          // Sprite 2 X Pos
$37A2  8D 08 D0  STA $D008                          // Sprite 4 X Pos
$37A5  18        CLC 
$37A6  69 08     ADC #$08
$37A8  8D 00 D0  STA $D000                          // Sprite 0 X Pos
$37AB  8D 0C D0  STA $D00C                          // Sprite 6 X Pos
$37AE  90 08     BCC L_BRS_($37B8)_($37AE) OK
$37B0  A9 6B     LDA #$6B
$37B2  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$37B5  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($37B8)_($37AE) OK
//------------------------------
$37B8  AD 00 D0  LDA $D000                          // Sprite 0 X Pos
$37BB  18        CLC 
$37BC  69 18     ADC #$18
$37BE  8D 02 D0  STA $D002                          // Sprite 1 X Pos
$37C1  90 08     BCC L_BRS_($37CB)_($37C1) OK
$37C3  A9 2A     LDA #$2A
$37C5  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$37C8  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($37CB)_($37C1) OK
//------------------------------
$37CB  AD 02 D0  LDA $D002                          // Sprite 1 X Pos
$37CE  18        CLC 
$37CF  69 18     ADC #$18
$37D1  8D 06 D0  STA $D006                          // Sprite 3 X Pos
$37D4  8D 0A D0  STA $D00A                          // Sprite 5 X Pos
$37D7  90 08     BCC L_BRS_($37E1)_($37D7) OK
$37D9  A9 28     LDA #$28
$37DB  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$37DE  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($37E1)_($37D7) OK
//------------------------------
$37E1  A9 29     LDA #$29
$37E3  8D F8 CF  STA $CFF8 
$37E6  A9 2A     LDA #$2A
$37E8  8D F9 CF  STA $CFF9 
$37EB  A9 23     LDA #$23
$37ED  8D FA CF  STA $CFFA 
$37F0  A9 25     LDA #$25
$37F2  8D FB CF  STA $CFFB 
$37F5  A9 22     LDA #$22
$37F7  8D FC CF  STA $CFFC 
$37FA  A9 24     LDA #$24
$37FC  8D FD CF  STA $CFFD 
$37FF  A9 28     LDA #$28
$3801  8D FE CF  STA $CFFE 
$3804  60        RTS 
//------------------------------
L_JSR_($3805)_($241B) OK
//------------------------------
$3805  8D 06 D0  STA $D006                          // Sprite 3 X Pos
$3808  8D 0A D0  STA $D00A                          // Sprite 5 X Pos
$380B  38        SEC 
$380C  E9 38     SBC #$38
$380E  8D 04 D0  STA $D004                          // Sprite 2 X Pos
$3811  8D 08 D0  STA $D008                          // Sprite 4 X Pos
$3814  90 05     BCC L_BRS_($381B)_($3814) OK
$3816  A9 FF     LDA #$FF
$3818  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($381B)_($3814) OK
//------------------------------
$381B  AD 04 D0  LDA $D004                          // Sprite 2 X Pos
$381E  18        CLC 
$381F  69 08     ADC #$08
$3821  8D 00 D0  STA $D000                          // Sprite 0 X Pos
$3824  8D 0C D0  STA $D00C                          // Sprite 6 X Pos
$3827  90 08     BCC L_BRS_($3831)_($3827) OK
$3829  A9 43     LDA #$43
$382B  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$382E  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($3831)_($3827) OK
//------------------------------
$3831  AD 0C D0  LDA $D00C                          // Sprite 6 X Pos
$3834  18        CLC 
$3835  69 18     ADC #$18
$3837  8D 02 D0  STA $D002                          // Sprite 1 X Pos
$383A  90 08     BCC L_BRS_($3844)_($383A) OK
$383C  A9 02     LDA #$02
$383E  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$3841  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_BRS_($3844)_($383A) OK
//------------------------------
$3844  A9 29     LDA #$29
$3846  8D F8 CF  STA $CFF8 
$3849  A9 2A     LDA #$2A
$384B  8D F9 CF  STA $CFF9 
$384E  A9 21     LDA #$21
$3850  8D FA CF  STA $CFFA 
$3853  A9 27     LDA #$27
$3855  8D FB CF  STA $CFFB 
$3858  A9 20     LDA #$20
$385A  8D FC CF  STA $CFFC 
$385D  A9 26     LDA #$26
$385F  8D FD CF  STA $CFFD 
$3862  A9 28     LDA #$28
$3864  8D FE CF  STA $CFFE 
$3867  60        RTS 
//------------------------------
L_JSR_($3868)_($2591) OK
L_JSR_($3868)_($25A9) OK
L_JSR_($3868)_($25FE) OK
L_JSR_($3868)_($261C) OK
L_JSR_($3868)_($2C7E) OK
L_JSR_($3868)_($2C8F) OK
L_JSR_($3868)_($BE53) OK
L_JSR_($3868)_($BE65) OK
L_JSR_($3868)_($BE89) OK
L_JSR_($3868)_($BEB3) OK
L_JSR_($3868)_($BECE) OK
L_JSR_($3868)_($BF0D) OK
L_JSR_($3868)_($BF2F) OK
L_JSR_($3868)_($BF4B) OK
L_JSR_($3868)_($BF83) OK
L_JSR_($3868)_($FA6F) OK
L_JSR_($3868)_($FA81) OK
L_JSR_($3868)_($FAA5) OK
L_JSR_($3868)_($FACF) OK
L_JSR_($3868)_($FAEA) OK
L_JSR_($3868)_($FB29) OK
L_JSR_($3868)_($FB4B) OK
L_JSR_($3868)_($FB67) OK
L_JSR_($3868)_($FB9F) OK
//------------------------------
$3868  A9 E0     LDA #$E0	; TODO: screen pointer
$386A  85 4F     STA $4F 
$386C  A9 00     LDA #$00
$386E  85 4E     STA $4E 
//------------------------------
L_BRS_($3870)_($387E) OK
//------------------------------
$3870  E6 4F     INC $4F 
$3872  A5 4E     LDA $4E 
$3874  18        CLC 
$3875  69 40     ADC #$40
$3877  90 02     BCC L_BRS_($387B)_($3877) OK
$3879  E6 4F     INC $4F 
//------------------------------
L_BRS_($387B)_($3877) OK
//------------------------------
$387B  85 4E     STA $4E 
$387D  88        DEY 
$387E  D0 F0     BNE L_BRS_($3870)_($387E) OK
//------------------------------
L_BRS_($3880)_($388C) OK
//------------------------------
$3880  A5 4E     LDA $4E 
$3882  18        CLC 
$3883  69 08     ADC #$08
$3885  90 02     BCC L_BRS_($3889)_($3885) OK
$3887  E6 4F     INC $4F 
//------------------------------
L_BRS_($3889)_($3885) OK
//------------------------------
$3889  85 4E     STA $4E 
$388B  CA        DEX 
$388C  D0 F2     BNE L_BRS_($3880)_($388C) OK
$388E  38        SEC 
$388F  E9 C0     SBC #$C0
$3891  B0 02     BCS L_BRS_($3895)_($3891) OK
$3893  C6 4F     DEC $4F 
//------------------------------
L_BRS_($3895)_($3891) OK
//------------------------------
$3895  85 4E     STA $4E 
$3897  A9 45     LDA #$45
$3899  85 51     STA $51 
$389B  A9 00     LDA #$00
$389D  85 50     STA $50 
$389F  A0 FF     LDY #$FF
$38A1  A6 31     LDX $31 
//------------------------------
L_BRS_($38A3)_($38A9) OK
//------------------------------
$38A3  B1 50     LDA ($50),Y 
$38A5  91 4E     STA ($4E),Y 
$38A7  88        DEY 
$38A8  CA        DEX 
$38A9  D0 F8     BNE L_BRS_($38A3)_($38A9) OK
$38AB  60        RTS 
//------------------------------
L_JSR_($38AC)_($1DBE) OK
L_JSR_($38AC)_($29BA) OK
//------------------------------
$38AC  A0 10     LDY #$10		; TODO: Save Sprites
$38AE  A9 00     LDA #$00
$38B0  85 4E     STA $4E 
$38B2  A9 D0     LDA #$D0
$38B4  85 4F     STA $4F 
$38B6  A9 00     LDA #$00
$38B8  85 50     STA $50 
$38BA  A9 B9     LDA #$B9
$38BC  85 51     STA $51 
//------------------------------
L_BRS_($38BE)_($38C3) OK
//------------------------------
$38BE  B1 4E     LDA ($4E),Y 
$38C0  91 50     STA ($50),Y 
$38C2  88        DEY 
$38C3  10 F9     BPL L_BRS_($38BE)_($38C3) OK
$38C5  A0 15     LDY #$15
$38C7  B1 4E     LDA ($4E),Y 
$38C9  91 50     STA ($50),Y 
$38CB  A0 1D     LDY #$1D
$38CD  B1 4E     LDA ($4E),Y 
$38CF  91 50     STA ($50),Y 
$38D1  A0 27     LDY #$27
//------------------------------
L_BRS_($38D3)_($38DA) OK
//------------------------------
$38D3  B1 4E     LDA ($4E),Y 
$38D5  91 50     STA ($50),Y 
$38D7  C8        INY 
$38D8  C0 2F     CPY #$2F
$38DA  D0 F7     BNE L_BRS_($38D3)_($38DA) OK
$38DC  A9 00     LDA #$00
$38DE  8D 15 D0  STA $D015                          // Sprite display Enable
$38E1  A2 00     LDX #$00
//------------------------------
L_BRS_($38E3)_($38EC) OK
//------------------------------
$38E3  BD F8 CF  LDA $CFF8,X 
$38E6  9D 30 B9  STA $B930,X 
$38E9  E8        INX 
$38EA  E0 08     CPX #$08
$38EC  D0 F5     BNE L_BRS_($38E3)_($38EC) OK
$38EE  60        RTS 
//------------------------------
L_JSR_($38EF)_($1EBE) OK
L_JSR_($38EF)_($29C4) OK
//------------------------------
$38EF  A0 10     LDY #$10		; TODO: Restore sprites
$38F1  A9 00     LDA #$00
$38F3  85 4E     STA $4E 
$38F5  A9 D0     LDA #$D0
$38F7  85 4F     STA $4F 
$38F9  A9 00     LDA #$00
$38FB  85 50     STA $50 
$38FD  A9 B9     LDA #$B9
$38FF  85 51     STA $51 
//------------------------------
L_BRS_($3901)_($3906) OK
//------------------------------
$3901  B1 50     LDA ($50),Y 
$3903  91 4E     STA ($4E),Y 
$3905  88        DEY 
$3906  10 F9     BPL L_BRS_($3901)_($3906) OK
$3908  A0 15     LDY #$15
$390A  B1 50     LDA ($50),Y 
$390C  91 4E     STA ($4E),Y 
$390E  A0 1D     LDY #$1D
$3910  B1 50     LDA ($50),Y 
$3912  91 4E     STA ($4E),Y 
$3914  A0 27     LDY #$27
//------------------------------
L_BRS_($3916)_($391D) OK
//------------------------------
$3916  B1 50     LDA ($50),Y 
$3918  91 4E     STA ($4E),Y 
$391A  C8        INY 
$391B  C0 2F     CPY #$2F
$391D  D0 F7     BNE L_BRS_($3916)_($391D) OK
$391F  A2 00     LDX #$00
//------------------------------
L_BRS_($3921)_($392A) OK
//------------------------------
$3921  BD 30 B9  LDA $B930,X 
$3924  9D F8 CF  STA $CFF8,X 
$3927  E8        INX 
$3928  E0 08     CPX #$08
$392A  D0 F5     BNE L_BRS_($3921)_($392A) OK
$392C  60        RTS 
//------------------------------
L_JSR_($392D)_($3B0A) OK
//------------------------------
$392D  A9 44     LDA #$44
$392F  85 4F     STA $4F 
$3931  A9 00     LDA #$00
$3933  85 4E     STA $4E 
$3935  A0 00     LDY #$00
$3937  98        TYA 
//------------------------------
L_BRS_($3938)_($393D) OK
//------------------------------
$3938  91 4E     STA ($4E),Y 
$393A  C8        INY 
$393B  C0 20     CPY #$20
$393D  D0 F9     BNE L_BRS_($3938)_($393D) OK
$393F  60        RTS 
//------------------------------
L_JSR_($3940)_($3A44) OK
//------------------------------
$3940  A5 EB     LDA $EB 
$3942  F0 0D     BEQ L_BRS_($3951)_($3942) OK
$3944  C9 10     CMP #$10
$3946  90 04     BCC L_BRS_($394C)_($3946) OK
$3948  A9 10     LDA #$10
$394A  85 EB     STA $EB 
//------------------------------
L_BRS_($394C)_($3946) OK
//------------------------------
$394C  C6 EB     DEC $EB 
$394E  4C C6 39  JMP L_JMP_($39C6)_($394E) OK
//------------------------------
L_BRS_($3951)_($3942) OK
//------------------------------
$3951  A9 00     LDA #$00
$3953  85 CA     STA $CA 
$3955  A0 40     LDY #$40
$3957  84 CB     STY $CB 
$3959  A8        TAY 
$395A  8D 00 DC  STA $DC00                          // Data Port A (Keyboard, Joystick, Paddles)
$395D  AE 01 DC  LDX $DC01                          // Data Port B (Keyboard, Joystick, Paddles)
$3960  E0 FF     CPX #$FF
$3962  F0 62     BEQ L_BRS_($39C6)_($3962) OK
$3964  A9 00     LDA #$00
$3966  85 CE     STA $CE 
$3968  A9 5F     LDA #$5F
$396A  85 CF     STA $CF 
$396C  A9 FE     LDA #$FE
$396E  8D 00 DC  STA $DC00                          // Data Port A (Keyboard, Joystick, Paddles)
//------------------------------
L_BRS_($3971)_($39A1) OK
//------------------------------
$3971  A2 08     LDX #$08
$3973  48        PHA 
//------------------------------
L_BRS_($3974)_($397A) OK
//------------------------------
$3974  AD 01 DC  LDA $DC01                          // Data Port B (Keyboard, Joystick, Paddles)
$3977  CD 01 DC  CMP $DC01                          // Data Port B (Keyboard, Joystick, Paddles)
$397A  D0 F8     BNE L_BRS_($3974)_($397A) OK
//------------------------------
L_BRS_($397C)_($3999) OK
//------------------------------
$397C  4A        LSR A 
$397D  B0 14     BCS L_BRS_($3993)_($397D) OK
$397F  48        PHA 
$3980  B1 CE     LDA ($CE),Y 
$3982  C9 05     CMP #$05
$3984  B0 0A     BCS L_BRS_($3990)_($3984) OK
$3986  C9 03     CMP #$03
$3988  F0 06     BEQ L_BRS_($3990)_($3988) OK
$398A  05 CA     ORA $CA
$398C  85 CA     STA $CA 
$398E  10 02     BPL L_BRS_($3992)_($398E) OK
//------------------------------
L_BRS_($3990)_($3984) OK
L_BRS_($3990)_($3988) OK
//------------------------------
$3990  84 CB     STY $CB 
//------------------------------
L_BRS_($3992)_($398E) OK
//------------------------------
$3992  68        PLA 
//------------------------------
L_BRS_($3993)_($397D) OK
//------------------------------
$3993  C8        INY 
$3994  C0 41     CPY #$41
$3996  B0 0B     BCS L_BRS_($39A3)_($3996) OK
$3998  CA        DEX 
$3999  D0 E1     BNE L_BRS_($397C)_($3999) OK
$399B  38        SEC 
$399C  68        PLA 
$399D  2A        ROL A 
$399E  8D 00 DC  STA $DC00                          // Data Port A (Keyboard, Joystick, Paddles)
$39A1  D0 CE     BNE L_BRS_($3971)_($39A1) OK
//------------------------------
L_BRS_($39A3)_($3996) OK
//------------------------------
$39A3  68        PLA 
$39A4  A5 CA     LDA $CA 
$39A6  C9 03     CMP #$03
$39A8  F0 12     BEQ L_BRS_($39BC)_($39A8) OK
$39AA  0A        ASL A 
$39AB  C9 08     CMP #$08
$39AD  90 02     BCC L_BRS_($39B1)_($39AD) OK
$39AF  A9 06     LDA #$06
//------------------------------
L_BRS_($39B1)_($39AD) OK
//------------------------------
$39B1  AA        TAX 
$39B2  BD 38 44  LDA $4438,X 
$39B5  85 CE     STA $CE 
$39B7  BD 39 44  LDA $4439,X 
$39BA  85 CF     STA $CF 
//------------------------------
L_BRS_($39BC)_($39A8) OK
//------------------------------
$39BC  A4 CB     LDY $CB 
$39BE  B1 CE     LDA ($CE),Y 
$39C0  85 4C     STA $4C 
$39C2  A9 0F     LDA #$0F
$39C4  85 EB     STA $EB 
//------------------------------
L_JMP_($39C6)_($394E) OK
L_BRS_($39C6)_($3962) OK
//------------------------------
$39C6  60        RTS 
//------------------------------
$39C7  48        PHA 		; IRQ
$39C8  8A        TXA 
$39C9  48        PHA 
$39CA  98        TYA 
$39CB  48        PHA 
//------------------------------
L_JMP_($39CC)_($BBB1) OK
L_JMP_($39CC)_($F7FB) OK
//------------------------------
$39CC  E6 82     INC $82 
$39CE  C6 2E     DEC $2E 
$39D0  C6 C9     DEC $C9 
$39D2  F0 03     BEQ L_BRS_($39D7)_($39D2) OK
$39D4  4C 41 3A  JMP L_JMP_($3A41)_($39D4) OK
//------------------------------
L_BRS_($39D7)_($39D2) OK
//------------------------------
$39D7  A9 19     LDA #$19
$39D9  85 C9     STA $C9 
$39DB  A2 0F     LDX #$0F
$39DD  A9 58     LDA #$58
$39DF  85 EE     STA $EE 
$39E1  A9 E0     LDA #$E0
$39E3  85 ED     STA $ED 
$39E5  A0 00     LDY #$00
//------------------------------
L_BRS_($39E7)_($3A24) OK
//------------------------------
$39E7  B1 ED     LDA ($ED),Y 
$39E9  85 EF     STA $EF 
$39EB  C8        INY 
$39EC  B1 ED     LDA ($ED),Y 
$39EE  85 F0     STA $F0 
$39F0  C8        INY 
$39F1  B1 ED     LDA ($ED),Y 
$39F3  F0 2D     BEQ L_BRS_($3A22)_($39F3) OK
$39F5  A5 EF     LDA $EF 
$39F7  C5 58     CMP $58 
$39F9  90 27     BCC L_BRS_($3A22)_($39F9) OK
$39FB  C5 59     CMP $59 
$39FD  B0 23     BCS L_BRS_($3A22)_($39FD) OK
$39FF  84 F4     STY $F4 
$3A01  A9 CC     LDA #$CC	; TODO: Colorram pointer
$3A03  85 F3     STA $F3 
$3A05  A9 00     LDA #$00
$3A07  85 F2     STA $F2 
$3A09  A4 F0     LDY $F0 
$3A0B  F0 0E     BEQ L_BRS_($3A1B)_($3A0B) OK
//------------------------------
L_BRS_($3A0D)_($3A19) OK
//------------------------------
$3A0D  A5 F2     LDA $F2 
$3A0F  18        CLC 
$3A10  69 28     ADC #$28
$3A12  90 02     BCC L_BRS_($3A16)_($3A12) OK
$3A14  E6 F3     INC $F3 
//------------------------------
L_BRS_($3A16)_($3A12) OK
//------------------------------
$3A16  85 F2     STA $F2 
$3A18  88        DEY 
$3A19  D0 F2     BNE L_BRS_($3A0D)_($3A19) OK
//------------------------------
L_BRS_($3A1B)_($3A0B) OK
//------------------------------
$3A1B  A5 EF     LDA $EF 
$3A1D  20 90 3A  JSR L_JSR_($3A90)_($3A1D) OK
$3A20  A4 F4     LDY $F4 
//------------------------------
L_BRS_($3A22)_($39F3) OK
L_BRS_($3A22)_($39F9) OK
L_BRS_($3A22)_($39FD) OK
//------------------------------
$3A22  C8        INY 
$3A23  CA        DEX 
$3A24  D0 C1     BNE L_BRS_($39E7)_($3A24) OK
$3A26  A5 D5     LDA $D5 
$3A28  F0 17     BEQ L_BRS_($3A41)_($3A28) OK
$3A2A  A9 0A     LDA #$0A
$3A2C  C5 58     CMP $58 
$3A2E  90 11     BCC L_BRS_($3A41)_($3A2E) OK
$3A30  C5 59     CMP $59 
$3A32  B0 0D     BCS L_BRS_($3A41)_($3A32) OK
$3A34  A9 CD     LDA #$CD	; TODO: Colorram pointer
$3A36  85 F3     STA $F3 
$3A38  A9 68     LDA #$68
$3A3A  85 F2     STA $F2 
$3A3C  A9 0A     LDA #$0A
$3A3E  20 90 3A  JSR L_JSR_($3A90)_($3A3E) OK
//------------------------------
L_JMP_($3A41)_($39D4) OK
L_BRS_($3A41)_($3A28) OK
L_BRS_($3A41)_($3A2E) OK
L_BRS_($3A41)_($3A32) OK
//------------------------------
$3A41  AD 0D DC  LDA $DC0D                          // Interrupt (IRQ) Control Register
$3A44  20 40 39  JSR L_JSR_($3940)_($3A44) OK
$3A47  A5 4C     LDA $4C 
$3A49  D0 3A     BNE L_BRS_($3A85)_($3A49) OK
$3A4B  A9 00     LDA #$00
$3A4D  8D 02 DC  STA $DC02                          // Data Direction Register A
$3A50  AD 00 DC  LDA $DC00                          // Data Port A (Keyboard, Joystick, Paddles)
$3A53  49 FF     EOR #$FF
$3A55  48        PHA 
$3A56  29 10     AND #$10
$3A58  D0 21     BNE L_BRS_($3A7B)_($3A58) OK
$3A5A  68        PLA 
$3A5B  4A        LSR A 
$3A5C  90 05     BCC L_BRS_($3A63)_($3A5C) OK
$3A5E  A9 D1     LDA #$D1
$3A60  4C 83 3A  JMP L_JMP_($3A83)_($3A60) OK
//------------------------------
L_BRS_($3A63)_($3A5C) OK
//------------------------------
$3A63  4A        LSR A 
$3A64  90 05     BCC L_BRS_($3A6B)_($3A64) OK
$3A66  A9 C1     LDA #$C1
$3A68  4C 83 3A  JMP L_JMP_($3A83)_($3A68) OK
//------------------------------
L_BRS_($3A6B)_($3A64) OK
//------------------------------
$3A6B  4A        LSR A 
$3A6C  90 05     BCC L_BRS_($3A73)_($3A6C) OK
$3A6E  A9 CF     LDA #$CF
$3A70  4C 83 3A  JMP L_JMP_($3A83)_($3A70) OK
//------------------------------
L_BRS_($3A73)_($3A6C) OK
//------------------------------
$3A73  4A        LSR A 
$3A74  90 0B     BCC L_BRS_($3A81)_($3A74) OK
$3A76  A9 D0     LDA #$D0
$3A78  4C 83 3A  JMP L_JMP_($3A83)_($3A78) OK
//------------------------------
L_BRS_($3A7B)_($3A58) OK
//------------------------------
$3A7B  68        PLA 
$3A7C  A9 46     LDA #$46
$3A7E  4C 83 3A  JMP L_JMP_($3A83)_($3A7E) OK
//------------------------------
L_BRS_($3A81)_($3A74) OK
//------------------------------
$3A81  A9 00     LDA #$00
//------------------------------
L_JMP_($3A83)_($3A60) OK
L_JMP_($3A83)_($3A68) OK
L_JMP_($3A83)_($3A70) OK
L_JMP_($3A83)_($3A78) OK
L_JMP_($3A83)_($3A7E) OK
//------------------------------
$3A83  85 4C     STA $4C 
//------------------------------
L_BRS_($3A85)_($3A49) OK
//------------------------------
$3A85  A9 FF     LDA #$FF
$3A87  8D 02 DC  STA $DC02                          // Data Direction Register A
$3A8A  68        PLA 
$3A8B  A8        TAY 
$3A8C  68        PLA 
$3A8D  AA        TAX 
$3A8E  68        PLA 
$3A8F  40        RTI 
//------------------------------
L_JSR_($3A90)_($3A1D) OK
L_JSR_($3A90)_($3A3E) OK
//------------------------------
$3A90  38        SEC 			; Flip color attribute
$3A91  E5 58     SBC $58 
$3A93  18        CLC 
$3A94  65 F2     ADC $F2 
$3A96  90 02     BCC L_BRS_($3A9A)_($3A96) OK
$3A98  E6 F3     INC $F3 
//------------------------------
L_BRS_($3A9A)_($3A96) OK
//------------------------------
$3A9A  85 F2     STA $F2 
$3A9C  A0 00     LDY #$00
$3A9E  84 F5     STY $F5 
$3AA0  B1 F2     LDA ($F2),Y 
$3AA2  4A        LSR A 
$3AA3  66 F5     ROR $F5 
$3AA5  4A        LSR A 
$3AA6  66 F5     ROR $F5 
$3AA8  4A        LSR A 
$3AA9  66 F5     ROR $F5 
$3AAB  4A        LSR A 
$3AAC  66 F5     ROR $F5 
$3AAE  05 F5     ORA $F5
$3AB0  91 F2     STA ($F2),Y 
$3AB2  60        RTS 
//------------------------------
$3AB3            .byte $FF
//------------------------------
L_JSR_($3AB4)_($082F) OK
L_JSR_($3AB4)_($0832) OK
L_JSR_($3AB4)_($0835) OK
L_JSR_($3AB4)_($0838) OK
L_JSR_($3AB4)_($083E) OK
L_JSR_($3AB4)_($0841) OK
L_JSR_($3AB4)_($0844) OK
L_JSR_($3AB4)_($0847) OK
//------------------------------
$3AB4  E6 60     INC $60 
$3AB6  A5 60     LDA $60 
$3AB8  C9 14     CMP #$14
$3ABA  90 07     BCC L_BRS_($3AC3)_($3ABA) OK
$3ABC  A9 00     LDA #$00
$3ABE  85 60     STA $60 
$3AC0  4C CB 3A  JMP L_JMP_($3ACB)_($3AC0) OK
//------------------------------
L_BRS_($3AC3)_($3ABA) OK
//------------------------------
$3AC3  C9 04     CMP #$04
$3AC5  D0 04     BNE L_BRS_($3ACB)_($3AC5) OK
$3AC7  E6 60     INC $60 
$3AC9  A5 60     LDA $60 
//------------------------------
L_JMP_($3ACB)_($3AC0) OK
L_BRS_($3ACB)_($3AC5) OK
//------------------------------
$3ACB  20 79 32  JSR L_JSR_($3279)_($3ACB) OK
$3ACE  20 5E 3B  JSR L_JSR_($3B5E)_($3ACE) OK
$3AD1  20 BF 33  JSR L_JSR_($33BF)_($3AD1) OK
$3AD4  60        RTS 
//------------------------------
L_JSR_($3AD5)_($080A) OK
L_JSR_($3AD5)_($081F) OK
L_JSR_($3AD5)_($C5EA) OK
L_JSR_($3AD5)_($FFC7) OK
//------------------------------
$3AD5  A9 0F     LDA #$0F
$3AD7  85 40     STA $40 
$3AD9  E6 41     INC $41 
$3ADB  A5 41     LDA $41 
$3ADD  C9 40     CMP #$40
$3ADF  D0 04     BNE L_BRS_($3AE5)_($3ADF) OK
$3AE1  A9 00     LDA #$00
$3AE3  85 41     STA $41 
//------------------------------
L_BRS_($3AE5)_($3ADF) OK
//------------------------------
$3AE5  A9 00     LDA #$00
$3AE7  85 4E     STA $4E 
$3AE9  A9 5D     LDA #$5D
$3AEB  85 4F     STA $4F 
$3AED  A4 41     LDY $41 
$3AEF  B1 4E     LDA ($4E),Y 
$3AF1  85 42     STA $42 
$3AF3  A8        TAY 
$3AF4  A9 8C     LDA #$8C
$3AF6  85 4F     STA $4F 
$3AF8  B1 4E     LDA ($4E),Y 
$3AFA  85 70     STA $70 
$3AFC  20 73 25  JSR L_JSR_($2573)_($3AFC) OK
$3AFF  20 46 3B  JSR L_JSR_($3B46)_($3AFF) OK
$3B02  A9 03     LDA #$03
$3B04  85 2C     STA $2C 
$3B06  A9 21     LDA #$21
$3B08  85 2D     STA $2D 
$3B0A  20 2D 39  JSR L_JSR_($392D)_($3B0A) OK
$3B0D  A2 12     LDX #$12
$3B0F  A9 00     LDA #$00
$3B11  85 C8     STA $C8 
$3B13  85 C2     STA $C2 
$3B15  85 60     STA $60 
$3B17  85 50     STA $50 
$3B19  A9 78     LDA #$78
$3B1B  85 51     STA $51 
//------------------------------
L_BRS_($3B1D)_($3B43) OK
//------------------------------
$3B1D  8A        TXA 
$3B1E  48        PHA 
$3B1F  20 79 32  JSR L_JSR_($3279)_($3B1F) OK
$3B22  A4 42     LDY $42 
$3B24  B1 50     LDA ($50),Y 
$3B26  85 43     STA $43 
$3B28  A0 00     LDY #$00
$3B2A  B1 43     LDA ($43),Y 
$3B2C  85 3D     STA $3D 
$3B2E  C8        INY 
$3B2F  B1 43     LDA ($43),Y 
$3B31  85 3E     STA $3E 
$3B33  A5 3F     LDA $3F 
$3B35  09 80     ORA #$80
$3B37  85 3F     STA $3F 
$3B39  20 BF 33  JSR L_JSR_($33BF)_($3B39) OK
$3B3C  E6 60     INC $60 
$3B3E  E6 51     INC $51 
$3B40  68        PLA 
$3B41  AA        TAX 
$3B42  CA        DEX 
$3B43  D0 D8     BNE L_BRS_($3B1D)_($3B43) OK
$3B45  60        RTS 
//------------------------------
L_JSR_($3B46)_($3AFF) OK
//------------------------------
$3B46  A5 42     LDA $42 
$3B48  C9 F3     CMP #$F3
$3B4A  90 11     BCC L_BRS_($3B5D)_($3B4A) OK
$3B4C  A5 46     LDA $46 
$3B4E  F0 0D     BEQ L_BRS_($3B5D)_($3B4E) OK
$3B50  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$3B53  29 07     AND #$07
$3B55  C9 03     CMP #$03
$3B57  B0 04     BCS L_BRS_($3B5D)_($3B57) OK
$3B59  69 F3     ADC #$F3
$3B5B  85 42     STA $42 
//------------------------------
L_BRS_($3B5D)_($3B4A) OK
L_BRS_($3B5D)_($3B4E) OK
L_BRS_($3B5D)_($3B57) OK
//------------------------------
$3B5D  60        RTS 
//------------------------------
L_JSR_($3B5E)_($3ACE) OK
//------------------------------
$3B5E  A5 60     LDA $60 
$3B60  C9 12     CMP #$12
$3B62  F0 3C     BEQ L_BRS_($3BA0)_($3B62) OK
$3B64  C9 13     CMP #$13
$3B66  F0 38     BEQ L_BRS_($3BA0)_($3B66) OK
$3B68  C6 FF     DEC $FF 
$3B6A  F0 0E     BEQ L_BRS_($3B7A)_($3B6A) OK
$3B6C  A5 FF     LDA $FF 
$3B6E  4A        LSR A 
$3B6F  90 2F     BCC L_BRS_($3BA0)_($3B6F) OK
$3B71  A5 3F     LDA $3F 
$3B73  29 40     AND #$40
$3B75  D0 29     BNE L_BRS_($3BA0)_($3B75) OK
$3B77  4C E6 3B  JMP L_JMP_($3BE6)_($3B77) OK
//------------------------------
L_BRS_($3B7A)_($3B6A) OK
//------------------------------
$3B7A  AD 1B D4  LDA $D41B                          // Oscillator 3 Output
$3B7D  29 3F     AND #$3F
$3B7F  69 04     ADC #$04
$3B81  4A        LSR A 
$3B82  85 FF     STA $FF 
$3B84  90 0A     BCC L_BRS_($3B90)_($3B84) OK
$3B86  A5 3F     LDA $3F 
$3B88  09 40     ORA #$40
$3B8A  85 3F     STA $3F 
$3B8C  29 05     AND #$05
$3B8E  F0 10     BEQ L_BRS_($3BA0)_($3B8E) OK
//------------------------------
L_BRS_($3B90)_($3B84) OK
//------------------------------
$3B90  A5 3F     LDA $3F 
$3B92  29 BF     AND #$BF
$3B94  85 3F     STA $3F 
$3B96  29 0A     AND #$0A
$3B98  F0 06     BEQ L_BRS_($3BA0)_($3B98) OK
$3B9A  A5 3F     LDA $3F 
$3B9C  09 40     ORA #$40
$3B9E  85 3F     STA $3F 
//------------------------------
L_BRS_($3BA0)_($3B62) OK
L_BRS_($3BA0)_($3B66) OK
L_BRS_($3BA0)_($3B6F) OK
L_BRS_($3BA0)_($3B75) OK
L_BRS_($3BA0)_($3B8E) OK
L_BRS_($3BA0)_($3B98) OK
//------------------------------
$3BA0  A5 B1     LDA $B1 
$3BA2  F0 03     BEQ L_BRS_($3BA7)_($3BA2) OK
$3BA4  6C B0 00  JMP ($00B0) 
//------------------------------
L_BRS_($3BA7)_($3BA2) OK
//------------------------------
$3BA7  A5 3A     LDA $3A 
$3BA9  F0 09     BEQ L_BRS_($3BB4)_($3BA9) OK
$3BAB  A9 3B     LDA #$3B
$3BAD  48        PHA 
$3BAE  A9 B3     LDA #$B3
$3BB0  48        PHA 
$3BB1  6C 39 00  JMP ($0039) 
//------------------------------
L_BRS_($3BB4)_($3BA9) OK
//------------------------------
$3BB4  A5 AB     LDA $AB 
$3BB6  F0 03     BEQ L_BRS_($3BBB)_($3BB6) OK
$3BB8  6C AA 00  JMP ($00AA) 
//------------------------------
L_BRS_($3BBB)_($3BB6) OK
//------------------------------
$3BBB  A5 3F     LDA $3F 
$3BBD  0A        ASL A 
$3BBE  90 1F     BCC L_BRS_($3BDF)_($3BBE) OK
$3BC0  A5 3F     LDA $3F 
$3BC2  29 7F     AND #$7F
$3BC4  85 3F     STA $3F 
$3BC6  A5 3D     LDA $3D 
$3BC8  85 3B     STA $3B 
$3BCA  A5 3E     LDA $3E 
$3BCC  85 3C     STA $3C 
//------------------------------
L_BRS_($3BCE)_($3BE1) OK
//------------------------------
$3BCE  A0 00     LDY #$00
$3BD0  84 3A     STY $3A 
//------------------------------
L_JMP_($3BD2)_($286F) OK
//------------------------------
$3BD2  20 E7 3B  JSR L_JSR_($3BE7)_($3BD2) OK
$3BD5  85 29     STA $29 
$3BD7  20 E7 3B  JSR L_JSR_($3BE7)_($3BD7) OK
$3BDA  85 2A     STA $2A 
$3BDC  4C E3 3B  JMP L_JMP_($3BE3)_($3BDC) OK
//------------------------------
L_BRS_($3BDF)_($3BBE) OK
//------------------------------
$3BDF  A5 2A     LDA $2A 
$3BE1  F0 EB     BEQ L_BRS_($3BCE)_($3BE1) OK
//------------------------------
L_JMP_($3BE3)_($3BDC) OK
//------------------------------
$3BE3  6C 29 00  JMP ($0029) 
//------------------------------
L_JMP_($3BE6)_($3B77) OK
//------------------------------
$3BE6  60        RTS 
//------------------------------
L_JSR_($3BE7)_($12B5) OK
L_JSR_($3BE7)_($12BB) OK
L_JSR_($3BE7)_($1A0A) OK
L_JSR_($3BE7)_($2762) OK
L_JSR_($3BE7)_($2767) OK
L_JSR_($3BE7)_($27B1) OK
L_JSR_($3BE7)_($27B6) OK
L_JSR_($3BE7)_($2855) OK
L_JSR_($3BE7)_($285B) OK
L_JSR_($3BE7)_($2865) OK
L_JSR_($3BE7)_($286A) OK
L_JSR_($3BE7)_($28AB) OK
L_JSR_($3BE7)_($28C2) OK
L_JSR_($3BE7)_($28C7) OK
L_JSR_($3BE7)_($2AF9) OK
L_JSR_($3BE7)_($2B0D) OK
L_JSR_($3BE7)_($3BD2) OK
L_JSR_($3BE7)_($3BD7) OK
//------------------------------
$3BE7  84 57     STY $57 
$3BE9  A0 00     LDY #$00
$3BEB  B1 3B     LDA ($3B),Y 
$3BED  E6 3B     INC $3B 
$3BEF  D0 02     BNE L_BRS_($3BF3)_($3BEF) OK
$3BF1  E6 3C     INC $3C 
//------------------------------
L_BRS_($3BF3)_($3BEF) OK
//------------------------------
$3BF3  A4 57     LDY $57 
$3BF5  60        RTS 
//------------------------------
$3BF6            .byte $77,$00,$00,$00,$00,$80,$77,$FF
$3BFE            .byte $FF,$7F,$03,$00,$00,$0F,$00,$00
$3C06            .byte $1F,$00,$00,$3F,$00,$00,$7F,$00
$3C0E            .byte $00,$7F,$00,$00,$FF,$00,$00,$FF
$3C16            .byte $00,$00,$FF,$00,$00,$FF,$00,$00
//------------------------------
L_JSR_($3C1E)_($64AA) JAM
//------------------------------
$3C1E            .byte $7F,$00,$00,$7F,$00,$00,$3F,$00
$3C26            .byte $00,$1F,$00,$00,$0F,$00,$00,$03
$3C2E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3C36            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3C3E            .byte $00,$00,$03,$00,$00,$0C,$00,$00
$3C46  10 00     BPL L_BRS_($3C48)_($3C46) JAM
//------------------------------
L_BRS_($3C48)_($3C46) JAM
//------------------------------
$3C48            .byte $00
$3C49  20 00 00  JSR $0000
$3C4C  40        RTI 
//------------------------------
$3C4D            .byte $00,$00
$3C4F  40        RTI 
//------------------------------
$3C50            .byte $00,$00,$80,$00,$00,$80,$00,$00
$3C58            .byte $80,$00,$00,$80,$00,$00
$3C5E  40        RTI 
//------------------------------
$3C5F            .byte $00,$00
$3C61  40        RTI 
//------------------------------
$3C62            .byte $00,$00
$3C64  20 00 00  JSR $0000
$3C67  10 00     BPL L_BRS_($3C69)_($3C67) JAM
//------------------------------
L_BRS_($3C69)_($3C67) JAM
//------------------------------
$3C69            .byte $00,$0C,$00,$00,$03,$00,$00,$00
$3C71            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3C79            .byte $00,$00,$00,$00,$00,$00,$00,$03
$3C81            .byte $00,$00,$0F,$00,$00,$1F,$00,$00
$3C89            .byte $3F,$00,$00,$7F,$00,$00,$7F,$00
$3C91            .byte $00,$FF,$00,$00,$FF,$00,$00,$FF
$3C99            .byte $00,$00,$FF,$00,$00,$7F,$00,$00
$3CA1            .byte $7F,$00,$00,$3F,$00,$00,$1F,$00
$3CA9            .byte $00,$1F,$00,$00,$0F,$00,$00
$3CB0  0E 00 00  ASL $0000 
$3CB3  0E 00 00  ASL $0000 
$3CB6            .byte $0C,$00,$00
$3CB9  08        PHP 
$3CBA            .byte $00,$00
$3CBC  08        PHP 
$3CBD            .byte $00,$00,$00,$03,$00,$00,$0C,$00
$3CC5            .byte $00
$3CC6  10 00     BPL L_BRS_($3CC8)_($3CC6) JAM
//------------------------------
L_BRS_($3CC8)_($3CC6) JAM
//------------------------------
$3CC8            .byte $00
$3CC9  20 00 00  JSR $0000
$3CCC  40        RTI 
//------------------------------
$3CCD            .byte $00,$00
$3CCF  40        RTI 
//------------------------------
$3CD0            .byte $00,$00,$80,$00,$00,$80,$00,$00
$3CD8            .byte $80,$00,$00
$3CDB  40        RTI 
//------------------------------
$3CDC            .byte $00,$00
$3CDE  40        RTI 
//------------------------------
$3CDF            .byte $00,$00
$3CE1  20 00 00  JSR $0000
$3CE4  20 00 00  JSR $0000
$3CE7  10 00     BPL L_BRS_($3CE9)_($3CE7) JAM
//------------------------------
L_BRS_($3CE9)_($3CE7) JAM
//------------------------------
$3CE9            .byte $00
$3CEA  10 00     BPL L_BRS_($3CEC)_($3CEA) JAM
//------------------------------
L_BRS_($3CEC)_($3CEA) JAM
//------------------------------
$3CEC            .byte $00
$3CED  09 00     ORA #$00
$3CEF            .byte $00
$3CF0  0A        ASL A 
$3CF1            .byte $00,$00
$3CF3  0A        ASL A 
$3CF4            .byte $00,$00,$0C,$00,$00
$3CF9  08        PHP 
$3CFA            .byte $00,$00
$3CFC  08        PHP 
$3CFD            .byte $00,$00,$00
$3D00  C0 00     CPY #$00
$3D02            .byte $00
$3D03  F0 00     BEQ L_BRS_($3D05)_($3D03) JAM
//------------------------------
L_BRS_($3D05)_($3D03) JAM
//------------------------------
$3D05            .byte $00,$F8,$00,$00,$FC,$00,$00
$3D0C  FE 00 00  INC $0000,X 
$3D0F  FE 00 00  INC $0000,X 
$3D12            .byte $FF,$00,$00,$FF,$00,$00,$FF,$00
$3D1A            .byte $00,$FF,$00,$00
$3D1E  FE 00 00  INC $0000,X 
$3D21  FE 00 00  INC $0000,X 
$3D24            .byte $FC,$00,$00,$F8,$00,$00
$3D2A  F0 00     BEQ L_BRS_($3D2C)_($3D2A) JAM
//------------------------------
L_BRS_($3D2C)_($3D2A) JAM
//------------------------------
$3D2C            .byte $00
$3D2D  C0 00     CPY #$00
$3D2F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3D37            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3D3F            .byte $00
$3D40  C0 00     CPY #$00
$3D42            .byte $00
$3D43  30 00     BMI L_BRS_($3D45)_($3D43) JAM
//------------------------------
L_BRS_($3D45)_($3D43) JAM
//------------------------------
$3D45            .byte $00
$3D46  08        PHP 
$3D47            .byte $00,$00,$04,$00,$00,$02,$00,$00
$3D4F            .byte $02,$00,$00
$3D52  01 00     ORA ($00,X)
$3D54            .byte $00
$3D55  01 00     ORA ($00,X)
$3D57            .byte $00
$3D58  01 00     ORA ($00,X)
$3D5A            .byte $00
$3D5B  01 00     ORA ($00,X)
$3D5D            .byte $00,$02,$00,$00,$02,$00,$00,$04
$3D65            .byte $00,$00
$3D67  08        PHP 
$3D68            .byte $00,$00
$3D6A  30 00     BMI L_BRS_($3D6C)_($3D6A) JAM
//------------------------------
L_BRS_($3D6C)_($3D6A) JAM
//------------------------------
$3D6C            .byte $00
$3D6D  C0 00     CPY #$00
$3D6F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3D77            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3D7F            .byte $00
$3D80  C0 00     CPY #$00
$3D82            .byte $00
$3D83  F0 00     BEQ L_BRS_($3D85)_($3D83) JAM
//------------------------------
L_BRS_($3D85)_($3D83) JAM
//------------------------------
$3D85            .byte $00,$F8,$00,$00,$FC,$00,$00
$3D8C  FE 00 00  INC $0000,X 
$3D8F  FE 00 00  INC $0000,X 
$3D92            .byte $FF,$00,$00,$FF,$00,$00,$FF,$00
$3D9A            .byte $00
$3D9B  FE 00 00  INC $0000,X 
$3D9E  FE 00 00  INC $0000,X 
$3DA1            .byte $FC,$00,$00,$FC,$00,$00,$F8,$00
$3DA9            .byte $00,$F8,$00,$00
$3DAD  F0 00     BEQ L_BRS_($3DAF)_($3DAD) JAM
//------------------------------
L_BRS_($3DAF)_($3DAD) JAM
//------------------------------
$3DAF            .byte $00
$3DB0  70 00     BVS L_BRS_($3DB2)_($3DB0) JAM
//------------------------------
L_BRS_($3DB2)_($3DB0) JAM
//------------------------------
$3DB2            .byte $00
$3DB3  70 00     BVS L_BRS_($3DB5)_($3DB3) JAM
//------------------------------
L_BRS_($3DB5)_($3DB3) JAM
//------------------------------
$3DB5            .byte $00
$3DB6  30 00     BMI L_BRS_($3DB8)_($3DB6) JAM
//------------------------------
L_BRS_($3DB8)_($3DB6) JAM
//------------------------------
$3DB8            .byte $00
$3DB9  10 00     BPL L_BRS_($3DBB)_($3DB9) JAM
//------------------------------
L_BRS_($3DBB)_($3DB9) JAM
//------------------------------
$3DBB            .byte $00
$3DBC  10 00     BPL L_BRS_($3DBE)_($3DBC) JAM
//------------------------------
L_BRS_($3DBE)_($3DBC) JAM
//------------------------------
$3DBE            .byte $00,$00
$3DC0  C0 00     CPY #$00
$3DC2            .byte $00
$3DC3  30 00     BMI L_BRS_($3DC5)_($3DC3) JAM
//------------------------------
L_BRS_($3DC5)_($3DC3) JAM
//------------------------------
$3DC5            .byte $00
$3DC6  08        PHP 
$3DC7            .byte $00,$00,$04,$00,$00,$02,$00,$00
$3DCF            .byte $02,$00,$00
$3DD2  01 00     ORA ($00,X)
$3DD4            .byte $00
$3DD5  01 00     ORA ($00,X)
$3DD7            .byte $00
$3DD8  01 00     ORA ($00,X)
$3DDA            .byte $00,$02,$00,$00,$02,$00,$00,$04
$3DE2            .byte $00,$00,$04,$00,$00
$3DE7  08        PHP 
$3DE8            .byte $00,$00
$3DEA  08        PHP 
$3DEB            .byte $00,$00
$3DED  90 00     BCC L_BRS_($3DEF)_($3DED) JAM
//------------------------------
L_BRS_($3DEF)_($3DED) JAM
//------------------------------
$3DEF            .byte $00
$3DF0  50 00     BVC L_BRS_($3DF2)_($3DF0) JAM
//------------------------------
L_BRS_($3DF2)_($3DF0) JAM
//------------------------------
$3DF2            .byte $00
$3DF3  50 00     BVC L_BRS_($3DF5)_($3DF3) JAM
//------------------------------
L_BRS_($3DF5)_($3DF3) JAM
//------------------------------
$3DF5            .byte $00
$3DF6  30 00     BMI L_BRS_($3DF8)_($3DF6) JAM
//------------------------------
L_BRS_($3DF8)_($3DF6) JAM
//------------------------------
$3DF8            .byte $00
$3DF9  10 00     BPL L_BRS_($3DFB)_($3DF9) JAM
//------------------------------
L_BRS_($3DFB)_($3DF9) JAM
//------------------------------
$3DFB            .byte $00
$3DFC  10 00     BPL L_BRS_($3DFE)_($3DFC) JAM
//------------------------------
L_BRS_($3DFE)_($3DFC) JAM
//------------------------------
$3DFE            .byte $00,$00,$FF,$FF,$FF,$FF,$FF,$FF
$3E06            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3E0E            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3E16            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3E1E            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3E26            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3E2E            .byte $FF,$FF,$00,$00,$00,$00,$00,$00
$3E36            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E3E            .byte $00,$00,$FF,$FF,$FF,$00,$00,$00
$3E46            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E4E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E56            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E5E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E66            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$3E6E            .byte $FF,$FF,$00,$00,$00,$00,$00,$00
$3E76            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E7E            .byte $00,$00,$FF,$FF,$FF,$00,$00,$00
$3E86            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E8E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E96            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3E9E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3EA6            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$3EAE            .byte $FF,$FF,$00,$00,$00,$00,$00,$00
$3EB6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3EBE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3EC6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3ECE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3ED6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3EDE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3EE6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3EEE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3EF6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3EFE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F06            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F0E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F16            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F1E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F26            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F2E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F36            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F3E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F46            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($3F51)_($5A63) JAM
L_JSR_($3F51)_($5A7C) JAM
L_JSR_($3F51)_($5A9A) JAM
L_JSR_($3F51)_($5AD0) JAM
//------------------------------
$3F4E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F56            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F5E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F66            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F6E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F76            .byte $00,$00,$00,$00,$00,$00,$00,$00
$3F7E            .byte $00,$00,$FF,$FF,$FF,$FF,$FF,$FF
$3F86            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3F8E            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3F96            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3F9E            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FA6            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FAE            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FB6            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FBE            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FC6            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FCE            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FD6            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FDE            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FE6            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_JSR_($3FF0)_($7342) JAM
//------------------------------
$3FEE            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FF6            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$3FFE            .byte $FF,$FF,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($400D)_($9FA1) JAM
L_JSR_($400D)_($DC17) JAM
//------------------------------
$4006            .byte $00,$00,$00,$00,$00,$00,$00,$00
$400E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4016            .byte $00,$00,$00,$00,$00,$00,$00,$00
$401E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4026            .byte $00,$00,$00,$00,$00,$00,$00,$00
$402E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4036            .byte $00,$00,$00,$00,$00,$00,$00,$00
$403E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4046            .byte $00,$00,$00,$00,$00,$00,$00,$00
$404E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4056            .byte $00,$00,$00,$00,$00,$00,$00,$00
$405E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4066            .byte $00,$00,$00,$00,$00,$00,$00,$00
$406E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4076            .byte $00,$00,$00,$00,$00,$00,$00,$00
$407E            .byte $00,$00
$4080  B5 12     LDA $12,X 
$4082            .byte $5A,$03
$4084  B5 12     LDA $12,X 
$4086  4A        LSR A 
$4087            .byte $03,$C2
$4089  0E F9 2A  ASL $2AF9 
$408C  08        PHP 
$408D  A0 1F     LDY #$1F
$408F  B5 12     LDA $12,X 
$4091  3E 03 E9  ROL $E903,X 
$4094  09 B5     ORA #$B5
$4096            .byte $12
$4097  1E 03 B5  ASL $B503,X 
$409A            .byte $12
$409B  28        PLP 
$409C            .byte $03,$C2
$409E  0E F9 2A  ASL $2AF9 
$40A1  09 A0     ORA #$A0
$40A3            .byte $1F
$40A4  B5 12     LDA $12,X 
$40A6            .byte $34,$03
$40A8  B5 12     LDA $12,X 
$40AA            .byte $32,$03
$40AC  E9 09     SBC #$09
$40AE  B5 12     LDA $12,X 
$40B0            .byte $5A,$03
$40B2  B5 12     LDA $12,X 
$40B4  46 0A     LSR $0A 
$40B6            .byte $C2
$40B7  0E F9 2A  ASL $2AF9 
$40BA  0A        ASL A 
$40BB  A0 1F     LDY #$1F
$40BD  B5 12     LDA $12,X 
$40BF  31 0A     AND ($0A),Y 
$40C1  E9 09     SBC #$09
$40C3  B5 12     LDA $12,X 
$40C5  08        PHP 
$40C6  0A        ASL A 
$40C7  B5 12     LDA $12,X 
$40C9  16 0A     ASL $0A,X 
$40CB            .byte $C2
$40CC  0E F9 2A  ASL $2AF9 
$40CF            .byte $0B
$40D0  A0 1F     LDY #$1F
$40D2  B5 12     LDA $12,X 
$40D4            .byte $23
$40D5  0A        ASL A 
$40D6  B5 12     LDA $12,X 
$40D8            .byte $22
$40D9  0A        ASL A 
$40DA  E9 09     SBC #$09
$40DC  B5 12     LDA $12,X 
$40DE            .byte $43,$03,$04,$1A
$40E2  08        PHP 
$40E3  16 1D     ASL $1D,X 
$40E5            .byte $57
$40E6  0A        ASL A 
$40E7  65 28     ADC $28 
$40E9  A5 2C     LDA $2C 
$40EB  B5 12     LDA $12,X 
$40ED  41 03     EOR ($03,X) 
$40EF  65 28     ADC $28 
$40F1  A5 2C     LDA $2C 
$40F3            .byte $04,$1A
$40F5  08        PHP 
$40F6  16 1D     ASL $1D,X 
$40F8            .byte $57
$40F9  0A        ASL A 
$40FA  65 28     ADC $28 
$40FC  0D 27 B5  ORA $B527
$40FF            .byte $12,$44,$03
$4102  65 28     ADC $28 
$4104  0D 27 04  ORA $0427
$4107            .byte $1A
$4108  08        PHP 
$4109  16 1D     ASL $1D,X 
$410B            .byte $57
$410C  0A        ASL A 
$410D  B5 12     LDA $12,X 
$410F            .byte $43,$03,$04,$1A
$4113  08        PHP 
$4114  16 1D     ASL $1D,X 
$4116  4D 1F B5  EOR $B51F 
$4119            .byte $12
$411A  36 03     ROL $03,X 
$411C            .byte $04,$1A
$411E  09 16     ORA #$16
//------------------------------
L_JSR_($4120)_($8A2E) OK
//------------------------------
$4120  1D 57 0A  ORA $0A57,X
$4123  65 28     ADC $28 
$4125  A5 2C     LDA $2C 
$4127  B5 12     LDA $12,X 
$4129  2D 03 AB  AND $AB03 
$412C  28        PLP 
$412D  09 B5     ORA #$B5
$412F            .byte $12,$37,$03
$4132  65 28     ADC $28 
$4134  A5 2C     LDA $2C 
$4136            .byte $04,$1A
$4138  09 16     ORA #$16
$413A  1D 57 0A  ORA $0A57,X
$413D  65 28     ADC $28 
$413F  0D 27 B5  ORA $B527
//------------------------------
L_JSR_($4142)_($5ABD) JAM
//------------------------------
$4142            .byte $12
//------------------------------
L_JMP_($4143)_($55A9) OK
L_JSR_($4143)_($5A8F) OK
L_JSR_($4144)_($C4B6) BAD
L_JSR_($4144)_($FEB0) BAD
//------------------------------
$4143  35 03     AND $03,X 
$4145  65 28     ADC $28 
//------------------------------
L_JSR_($4147)_($43D1) OK
L_JSR_($4148)_($5A28) BAD
L_JSR_($4148)_($5B31) BAD
L_JSR_($4148)_($5BE9) BAD
//------------------------------
$4147  0D 27 04  ORA $0427
$414A            .byte $1A
$414B  09 16     ORA #$16
//------------------------------
L_JSR_($414D)_($4CD4) OK
L_JSR_($414D)_($550F) OK
L_JSR_($414E)_($8F71) BAD
L_JSR_($414D)_($9770) OK
L_JSR_($414E)_($CDE0) BAD
L_JSR_($414D)_($D452) OK
//------------------------------
$414D  1D 57 0A  ORA $0A57,X
//------------------------------
L_JSR_($4150)_($5C69) OK
//------------------------------
$4150  B5 12     LDA $12,X 
//------------------------------
L_JSR_($4152)_($5506) JAM
L_JSR_($4153)_($C528) JAM
L_JSR_($4153)_($FF22) JAM
//------------------------------
$4152            .byte $37,$03,$04,$1A
//------------------------------
L_JSR_($4157)_($5AA2) BAD
//------------------------------
$4156  09 16     ORA #$16
//------------------------------
L_JSR_($4159)_($C45E) BAD
L_JSR_($4159)_($FE58) BAD
//------------------------------
$4158  1D 4D 1F  ORA $1F4D,X
$415B  B5 12     LDA $12,X 
$415D  3D 0A 04  AND $040A,X 
$4160            .byte $1A
$4161  0A        ASL A 
$4162  16 1D     ASL $1D,X 
$4164            .byte $57
$4165  0A        ASL A 
$4166  65 28     ADC $28 
$4168  A5 2C     LDA $2C 
$416A  B5 12     LDA $12,X 
$416C  2D 0A AB  AND $AB0A 
$416F  28        PLP 
$4170  0A        ASL A 
$4171  B5 12     LDA $12,X 
$4173            .byte $3C
$4174  0A        ASL A 
$4175  65 28     ADC $28 
$4177  A5 2C     LDA $2C 
$4179            .byte $04,$1A
$417B  0A        ASL A 
$417C  16 1D     ASL $1D,X 
$417E            .byte $57
$417F  0A        ASL A 
$4180  65 28     ADC $28 
$4182  0D 27 B5  ORA $B527
$4185            .byte $12,$3B
$4187  0A        ASL A 
$4188  65 28     ADC $28 
$418A  0D 27 04  ORA $0427
$418D            .byte $1A
$418E  0A        ASL A 
$418F  16 1D     ASL $1D,X 
$4191            .byte $57
$4192  0A        ASL A 
$4193  B5 12     LDA $12,X 
$4195            .byte $3A
$4196  0A        ASL A 
$4197            .byte $04,$1A
$4199  0A        ASL A 
$419A  16 1D     ASL $1D,X 
$419C  4D 1F B5  EOR $B51F 
$419F            .byte $12
$41A0  24 0A     BIT $0A 
$41A2            .byte $04,$1A,$0B
$41A5  16 1D     ASL $1D,X 
$41A7            .byte $57
$41A8  0A        ASL A 
$41A9  65 28     ADC $28 
$41AB  A5 2C     LDA $2C 
$41AD  B5 12     LDA $12,X 
$41AF  1E 0A AB  ASL $AB0A,X 
$41B2  28        PLP 
$41B3            .byte $0B
$41B4  B5 12     LDA $12,X 
$41B6            .byte $23
$41B7  0A        ASL A 
$41B8  65 28     ADC $28 
$41BA  A5 2C     LDA $2C 
$41BC            .byte $04,$1A,$0B
$41BF  16 1D     ASL $1D,X 
$41C1            .byte $57
$41C2  0A        ASL A 
$41C3  65 28     ADC $28 
$41C5  0D 27 B5  ORA $B527
$41C8            .byte $12
$41C9  24 0A     BIT $0A 
$41CB  65 28     ADC $28 
$41CD  0D 27 04  ORA $0427
$41D0            .byte $1A,$0B
$41D2  16 1D     ASL $1D,X 
$41D4            .byte $57
$41D5  0A        ASL A 
$41D6  B5 12     LDA $12,X 
$41D8            .byte $22
$41D9  0A        ASL A 
$41DA            .byte $04,$1A,$0B
$41DD  16 1D     ASL $1D,X 
$41DF  4D 1F B5  EOR $B51F 
$41E2            .byte $12
$41E3  2E 11 04  ROL $0411 
$41E6            .byte $1A,$00
$41E8  65 28     ADC $28 
$41EA  A5 2C     LDA $2C 
$41EC  B5 12     LDA $12,X 
$41EE  2D 11 65  AND $6511 
$41F1  28        PLP 
$41F2  A5 2C     LDA $2C 
$41F4            .byte $04,$1A,$00
$41F7  65 28     ADC $28 
$41F9  0D 27 B5  ORA $B527
$41FC            .byte $12
$41FD  2D 11 65  AND $6511 
$4200  28        PLP 
$4201  0D 27 04  ORA $0427
$4204            .byte $1A,$00
$4206  B5 12     LDA $12,X 
$4208  24 03     BIT $03 
$420A            .byte $04,$1A,$00
$420D  65 28     ADC $28 
//------------------------------
L_BRS_($4210)_($425A) BAD
//------------------------------
$420F  A5 2C     LDA $2C 
$4211  B5 12     LDA $12,X 
$4213            .byte $23,$03
$4215  65 28     ADC $28 
$4217  A5 2C     LDA $2C 
$4219            .byte $04,$1A,$00
$421C  65 28     ADC $28 
$421E  0D 27 B5  ORA $B527
$4221            .byte $12,$23,$03
$4224  65 28     ADC $28 
$4226  0D 27 04  ORA $0427
$4229            .byte $1A,$00
$422B  65 28     ADC $28 
$422D  0D 27 5B  ORA $5B27
$4230  10 65     BPL L_BRS_($4297)_($4230) BAD
$4232  28        PLP 
$4233  0D 27 AB  ORA $AB27
$4236            .byte $27,$14,$00
$4239  B4 0E     LDY $0E,X 
$423B  B5 12     LDA $12,X 
//------------------------------
L_BRS_($423E)_($4291) BAD
//------------------------------
$423D  36 11     ROL $11,X 
$423F  B5 12     LDA $12,X 
$4241  11 2A     ORA ($2A),Y
$4243            .byte $C2
$4244  0E 35 0E  ASL $0E35 
$4247  B5 12     LDA $12,X 
//------------------------------
L_JMP_($4249)_($48D0) OK
//------------------------------
$4249  08        PHP 
$424A            .byte $03,$04,$1A,$00
$424E  B5 12     LDA $12,X 
$4250  09 0A     ORA #$0A
$4252            .byte $04,$1A,$00
$4255  B5 12     LDA $12,X 
$4257            .byte $03,$03,$5B
$425A  10 B4     BPL L_BRS_($4210)_($425A) BAD
$425C  0E B5 12  ASL $12B5 
$425F  2D 0A AB  AND $AB0A 
$4262  28        PLP 
$4263            .byte $00
$4264  B5 12     LDA $12,X 
$4266  1E 0A AB  ASL $AB0A,X 
//------------------------------
L_BRS_($4269)_($42BC) OK
//------------------------------
$4269  28        PLP 
$426A            .byte $00
$426B  B5 12     LDA $12,X 
$426D  2D 03 AB  AND $AB03 
$4270  28        PLP 
$4271            .byte $00
$4272  65 28     ADC $28 
$4274  A5 2C     LDA $2C 
$4276            .byte $5B
$4277  10 65     BPL L_BRS_($42DE)_($4277) OK
$4279  28        PLP 
$427A  A5 2C     LDA $2C 
$427C            .byte $AB,$27,$14,$00
$4280  65 28     ADC $28 
$4282  A5 2C     LDA $2C 
$4284            .byte $5B
$4285  10 65     BPL L_BRS_($42EC)_($4285) JAM
$4287  28        PLP 
$4288  A5 2C     LDA $2C 
$428A            .byte $AB,$27,$14,$00
$428E  B4 0E     LDY $0E,X 
$4290            .byte $5B
$4291  10 AB     BPL L_BRS_($423E)_($4291) BAD
$4293            .byte $27,$0F,$00
//------------------------------
L_BRS_($4297)_($4230) BAD
//------------------------------
$4296  B4 0E     LDY $0E,X 
$4298  B5 12     LDA $12,X 
$429A  5D 03 04  EOR $0403,X 
$429D            .byte $1A,$00
$429F  B5 12     LDA $12,X 
$42A1  5D 11 04  EOR $0411,X 
$42A4            .byte $1A,$00
$42A6  B5 12     LDA $12,X 
$42A8  08        PHP 
$42A9  11 04     ORA ($04),Y
$42AB            .byte $1A,$00,$AB,$27,$0F,$00
$42B1  F9 2A 10  SBC $102A,Y 
$42B4  65 28     ADC $28 
$42B6            .byte $73
$42B7  28        PLP 
$42B8            .byte $5B
$42B9  10 0D     BPL L_BRS_($42C8)_($42B9) JAM
$42BB            .byte $2B
$42BC  10 AB     BPL L_BRS_($4269)_($42BC) OK
$42BE            .byte $27,$0F,$00
$42C1  F9 2A 11  SBC $112A,Y 
$42C4  65 28     ADC $28 
//------------------------------
L_BRS_($42C8)_($42B9) JAM
//------------------------------
$42C6            .byte $97,$27,$5B
$42C9  10 0D     BPL L_BRS_($42D8)_($42C9) JAM
$42CB            .byte $2B
$42CC  11 B4     ORA ($B4),Y
$42CE  0E 04 1A  ASL $1A04 
$42D1  10 65     BPL L_BRS_($4338)_($42D1) OK
$42D3  28        PLP 
$42D4            .byte $73
$42D5  28        PLP 
$42D6  85 28     STA $28 
//------------------------------
L_BRS_($42D8)_($42C9) JAM
//------------------------------
$42D8            .byte $04,$1A
$42DA  11 65     ORA ($65),Y
$42DC  28        PLP 
$42DD            .byte $73
//------------------------------
L_BRS_($42DE)_($4277) OK
//------------------------------
$42DE  28        PLP 
$42DF  85 28     STA $28 
$42E1  B4 0E     LDY $0E,X 
$42E3  B5 12     LDA $12,X 
$42E5  5D 11 04  EOR $0411,X 
//------------------------------
L_BRS_($42EC)_($4285) JAM
//------------------------------
$42E8            .byte $1A,$1A,$04,$1A,$1B
$42ED  99 2A BC  STA $BC2A,Y 
$42F0  28        PLP 
$42F1            .byte $8F
$42F2  5E F9 2A  LSR $2AF9,X 
$42F5            .byte $1C,$5B
$42F7  10 04     BPL L_BRS_($42FD)_($42F7) BAD
$42F9            .byte $1A,$00
//------------------------------
L_BRS_($42FD)_($42F7) BAD
//------------------------------
$42FB  99 2A BC  STA $BC2A,Y 
$42FE  28        PLP 
$42FF            .byte $00
$4300  5E F9 2A  LSR $2AF9,X 
$4303            .byte $1C,$5B
$4305  10 04     BPL L_BRS_($430B)_($4305) OK
$4307            .byte $1A,$00
$4309  B5 12     LDA $12,X 
//------------------------------
L_BRS_($430B)_($4305) OK
//------------------------------
$430B  5D 03 F9  EOR $F903,X 
$430E  2A        ROL A 
$430F            .byte $1A,$04,$1A,$1C
$4313  B5 12     LDA $12,X 
$4315  06 03     ASL $03 
$4317  F9 2A 1D  SBC $1D2A,Y 
$431A            .byte $5B
$431B  10 04     BPL L_BRS_($4321)_($431B) OK
$431D            .byte $1A,$00
$431F  B5 12     LDA $12,X 
//------------------------------
L_BRS_($4321)_($431B) OK
//------------------------------
$4321  08        PHP 
$4322            .byte $03
$4323  F9 2A 1B  SBC $1B2A,Y 
$4326            .byte $04,$1A
//------------------------------
L_BRS_($4329)_($4373) BAD
//------------------------------
$4328  1D 99 2A  ORA $2A99,X
$432B  7D 27 B5  ADC $B527,X 
$432E            .byte $12
$432F  08        PHP 
$4330            .byte $03,$04,$1A,$00
$4334  B5 12     LDA $12,X 
$4336  18        CLC 
$4337            .byte $03
//------------------------------
L_BRS_($4338)_($42D1) OK
//------------------------------
$4338  F9 2A 1A  SBC $1A2A,Y 
$433B            .byte $04,$1A,$1C
$433E  65 28     ADC $28 
//------------------------------
L_JMP_($4341)_($4C91) BAD
L_JSR_($4341)_($C593) BAD
L_JSR_($4341)_($FF8D) BAD
//------------------------------
$4340  A5 2C     LDA $2C 
$4342  B5 12     LDA $12,X 
$4344  5D 03 0D  EOR $0D03,X 
$4347            .byte $2B,$1A,$5B
$434A  10 65     BPL L_BRS_($43B1)_($434A) BAD
$434C  28        PLP 
$434D  A5 2C     LDA $2C 
$434F            .byte $04,$1A,$00
//------------------------------
L_JSR_($4353)_($5C1E) BAD
//------------------------------
$4352  B5 12     LDA $12,X 
//------------------------------
L_JSR_($4354)_($C418) OK
L_JSR_($4354)_($FE12) OK
//------------------------------
$4354  2A        ROL A 
$4355            .byte $03
$4356  F9 2A 1B  SBC $1B2A,Y 
$4359            .byte $04,$1A,$1C,$4F
$435D  28        PLP 
$435E  5D 03 04  EOR $0403,X 
$4361            .byte $1A,$1A
$4363  99 2A 7D  STA $7D2A,Y 
$4366            .byte $27
$4367  B5 12     LDA $12,X 
$4369  08        PHP 
$436A            .byte $03,$04,$1A,$00
$436E  65 28     ADC $28 
$4370  0D 27 5B  ORA $5B27
$4373  10 B4     BPL L_BRS_($4329)_($4373) BAD
$4375  0E B5 12  ASL $12B5 
$4378  09 0A     ORA #$0A
$437A            .byte $04,$1A,$1C
$437D  65 28     ADC $28 
$437F            .byte $EF
$4380  26 04     ROL $04 
$4382            .byte $1A,$0C
$4384  99 2A 57  STA $572A,Y 
$4387            .byte $27
$4388  AA        TAX 
$4389            .byte $43
$438A  B5 12     LDA $12,X 
$438C  3D 11 04  AND $0411,X 
$438F            .byte $1A,$1A,$04,$1A,$1B
$4394  99 2A BC  STA $BC2A,Y 
$4397  28        PLP 
$4398  35 5E     AND $5E,X 
$439A  F9 2A 1C  SBC $1C2A,Y 
$439D            .byte $5B
$439E  10 04     BPL L_BRS_($43A4)_($439E) BAD
$43A0            .byte $1A,$00
//------------------------------
L_BRS_($43A4)_($439E) BAD
//------------------------------
$43A2  99 2A 57  STA $572A,Y 
$43A5            .byte $27
$43A6  E6 5B     INC $5B 
$43A8  30 30     BMI L_BRS_($43DA)_($43A8) BAD
$43AA  59 4F 55  EOR $554F,Y 
$43AD            .byte $27
$43AE  56 45     LSR $45,X 
//------------------------------
L_BRS_($43B1)_($434A) BAD
//------------------------------
$43B0  20 47 4F  JSR L_JSR_($4F47)_($43B0) JAM
$43B3            .byte $54
$43B4  20 4D 55  JSR L_JSR_($554D)_($43B4) JAM
$43B7  4D 50 53  EOR $5350 
$43BA  2E 20 47  ROL $4720 
$43BD            .byte $4F
$43BE  20 48 4F  JSR L_JSR_($4F48)_($43BE) JAM
$43C1  4D 45 20  EOR $2045 
$43C4  41 54     EOR ($54,X) 
$43C6  20 4F 4E  JSR L_JSR_($4E4F)_($43C6) JAM
$43C9            .byte $43
$43CA  45 2C     EOR $2C 
$43CC  20 54 48  JSR L_JSR_($4854)_($43CC) BAD
$43CF  49 53     EOR #$53
$43D1  20 47 41  JSR L_JSR_($4147)_($43D1) OK
$43D4  4D 45 20  EOR $2045 
$43D7  49 53     EOR #$53
//------------------------------
L_BRS_($43DA)_($43A8) BAD
//------------------------------
$43D9  20 4F 56  JSR L_JSR_($564F)_($43D9) BAD
$43DC  45 52     EOR $52 
$43DE  2E 20 2E  ROL $2E20 
$43E1  20 2E 20  JSR L_JSR_($202E)_($43E1) OK
$43E4  2E 50 52  ROL $5250 
$43E7  45 53     EOR $53 
$43E9            .byte $53
$43EA  20 41 20  JSR L_JSR_($2041)_($43EA) BAD
$43ED            .byte $4B
$43EE  45 59     EOR $59 
$43F0  20 54 4F  JSR L_JSR_($4F54)_($43F0) BAD
$43F3  20 50 4C  JSR L_JSR_($4C50)_($43F3) JAM
$43F6  41 59     EOR ($59,X) 
$43F8  20 41 47  JSR L_JSR_($4741)_($43F8) BAD
$43FB  41 49     EOR ($49,X) 
$43FD  4E 03 96  LSR $9603 
$4400            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4408            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4410            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4418            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JMP_($4420)_($4683) JAM
L_JMP_($4420)_($C404) JAM
L_JMP_($4420)_($FDFE) JAM
//------------------------------
$4420            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4428            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4430            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4438            .byte $00,$5F
$443A  40        RTI 
//------------------------------
$443B            .byte $5F,$80,$5F
$443E  C0 5F     CPY #$5F
$4440  0D 80 F3  ORA $F380
$4443            .byte $13
$4444  0D 80 F3  ORA $F380
$4447            .byte $13
$4448  46 80     LSR $80 
$444A            .byte $FA,$13
$444C  46 80     LSR $80 
$444E            .byte $FA,$13,$00,$00,$00,$00,$00,$00
$4456            .byte $00,$00,$13,$00,$FA,$13,$13,$00
$445E            .byte $FA,$13
$4460  4C 00 F3  JMP L_JMP_($F300)_($4460) BAD
$4463            .byte $13
$4464  4C 00 F3  JMP L_JMP_($F300)_($4464) BAD
$4467            .byte $13,$44,$6F
$446A  20 79 6F  JSR L_JSR_($6F79)_($446A) JAM
$446D  75 20     ADC $20,X 
$446F            .byte $77
$4470  61 6E     ADC ($6E,X) 
$4472            .byte $74
$4473  20 74 6F  JSR L_JSR_($6F74)_($4473) JAM
$4476  20 70 75  JSR L_JSR_($7570)_($4476) BAD
$4479            .byte $74
$447A  20 69 6E  JSR L_JSR_($6E69)_($447A) BAD
$447D            .byte $00,$00,$00,$80
$4481  40        RTI 
//------------------------------
$4482  95 40     STA $40,X 
$4484  AE 40 C3  LDX $C340 
$4487  40        RTI 
//------------------------------
$4488            .byte $DC
$4489  40        RTI 
//------------------------------
$448A  E5 40     SBC $40 
$448C            .byte $E7
$448D  40        RTI 
//------------------------------
$448E            .byte $FA
$448F  40        RTI 
//------------------------------
$4490  0D 41 18  ORA $1841
$4493  41 23     EOR ($23,X) 
$4495  41 3D     EOR ($3D,X) 
$4497  41 50     EOR ($50,X) 
$4499  41 5B     EOR ($5B,X) 
$449B  41 66     EOR ($66,X) 
$449D  41 80     EOR ($80,X) 
$449F  41 93     EOR ($93,X) 
$44A1  41 9E     EOR ($9E,X) 
$44A3  41 A9     EOR ($A9,X) 
$44A5  41 C3     EOR ($C3,X) 
$44A7  41 D6     EOR ($D6,X) 
$44A9  41 E1     EOR ($E1,X) 
$44AB  41 E8     EOR ($E8,X) 
$44AD  41 F7     EOR ($F7,X) 
$44AF  41 06     EOR ($06,X) 
$44B1            .byte $42
$44B2  0D 42 1C  ORA $1C42
$44B5            .byte $42,$2B,$42,$3B,$42,$47,$42
$44BC  4E 42 55  LSR $5542 
$44BF            .byte $42
$44C0  5D 42 72  EOR $7242,X 
$44C3            .byte $42
$44C4  90 42     BCC L_BRS_($4508)_($44C4) JAM
$44C6  98        TYA 
$44C7            .byte $42,$9F,$42
$44CA  A6 42     LDX $42 
$44CC  AD 42 CF  LDA $CF42 
$44CF            .byte $42,$E3,$42,$FB,$42
$44D4  09 43     ORA #$43
$44D6            .byte $1F,$43,$34,$43,$52,$43
$44DC  6E 43 76  ROR $7643 
$44DF            .byte $43
$44E0  8A        TXA 
$44E1            .byte $43,$00,$00,$00,$00,$00,$00,$00
$44E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$44F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$44F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($4508)_($44C4) JAM
//------------------------------
$4501            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4509            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4511            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4519            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4521            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4529            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4531            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4539            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($4542)_($49DA) JAM
L_JSR_($4542)_($4BC5) JAM
L_JSR_($4547)_($C433) JAM
L_JSR_($4547)_($FE2D) JAM
L_JSR_($4548)_($906B) JAM
L_JSR_($4548)_($CEC1) JAM
//------------------------------
$4541            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JMP_($4549)_($57AB) JAM
L_JSR_($454C)_($C54F) JAM
L_JSR_($454C)_($FF49) JAM
L_JSR_($454D)_($4AB4) JAM
L_JSR_($454E)_($8F6D) JAM
L_JSR_($454E)_($CDDC) JAM
//------------------------------
$4549            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($4552)_($5C94) JAM
L_JSR_($4552)_($C4A4) JAM
L_JSR_($4552)_($FE9E) JAM
L_JSR_($4553)_($5BA3) JAM
L_JSR_($4554)_($4BA5) JAM
L_JSR_($4554)_($9673) JAM
L_JSR_($4554)_($D366) JAM
//------------------------------
$4551            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4559            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4561            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4569            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4571            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4579            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4581            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4589            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4591            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4599            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$45F9            .byte $00,$00,$00,$00,$00,$00,$00,$44
$4601  45 4D     EOR $4D 
$4603            .byte $4F
$4604  2C 20 2D  BIT $2D20 
$4607  20 50 52  JSR L_JSR_($5250)_($4607) JAM
$460A  45 53     EOR $53 
$460C            .byte $53,$00,$00,$00
$4610  41 20     EOR ($20,X) 
$4612            .byte $4B
$4613  45 59     EOR $59 
$4615  20 54 4F  JSR L_JSR_($4F54)_($4615) BAD
$4618  20 50 4C  JSR L_JSR_($4C50)_($4618) JAM
$461B  41 59     EOR ($59,X) 
$461D            .byte $00,$00,$00
//------------------------------
L_JMP_($4620)_($5A5E) OK
//------------------------------
$4620  50 52     BVC L_BRS_($4674)_($4620) JAM
$4622  45 53     EOR $53 
$4624            .byte $53
$4625  20 27 55  JSR L_JSR_($5527)_($4625) BAD
$4628            .byte $27
$4629  20 49 46  JSR L_JSR_($4649)_($4629) JAM
$462C  20 59 4F  JSR L_JSR_($4F59)_($462C) OK
$462F  55 20     EOR $20,X 
$4631  55 4E     EOR $4E,X 
$4633            .byte $44
$4634  45 52     EOR $52 
$4636            .byte $53,$54
$4638  41 4E     EOR ($4E,X) 
$463A            .byte $44,$00,$00,$00,$00,$00
$4640  41 00     EOR ($00,X) 
$4642  20 00 00  JSR $0000
//------------------------------
L_JSR_($4646)_($A339) JAM
L_JSR_($4646)_($DFB8) JAM
L_JSR_($4648)_($C520) JAM
L_JSR_($4648)_($FF1A) JAM
L_JSR_($4649)_($4629) JAM
//------------------------------
$4645            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($464F)_($4A83) JAM
L_JSR_($464F)_($53E8) JAM
L_JSR_($464F)_($5A79) JAM
L_JSR_($464F)_($5BDE) JAM
L_JSR_($464F)_($5C72) JAM
L_JSR_($464F)_($5CBD) JAM
L_JSR_($464F)_($8D6C) JAM
L_JSR_($464F)_($CC42) JAM
//------------------------------
$464D            .byte $00,$00,$00,$00,$03
$4652  06 08     ASL $08 
$4654            .byte $0C
$4655  0E 10 13  ASL $1310 
$4658            .byte $17
$4659  19 1D 20  ORA $201D,Y
$465C  24 27     BIT $27 
$465E  29 2D     AND #$2D
$4660  30 33     BMI L_BRS_($4695)_($4660) OK
$4662            .byte $37
$4663  39 3D 00  AND $003D,Y 
$4666            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($4674)_($4620) JAM
//------------------------------
$466E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4676            .byte $00,$00,$00,$00,$00,$00,$00,$00
$467E            .byte $00,$00,$57
$4681  45 4C     EOR $4C 
$4683  4C 20 44  JMP L_JMP_($4420)_($4683) JAM
$4686            .byte $4F
$4687  4E 45 21  LSR $2145 
$468A  20 47 4F  JSR L_JSR_($4F47)_($468A) JAM
$468D            .byte $00,$00,$00
$4690  55 50     EOR $50,X 
$4692  20 41 20  JSR L_JSR_($2041)_($4692) BAD
//------------------------------
L_BRS_($4695)_($4660) OK
//------------------------------
$4695  59 45 41  EOR $4145,Y 
$4698            .byte $52,$00,$00,$00,$00,$00,$00,$00
$46A0  08        PHP 
$46A1            .byte $00
$46A2  10 07     BPL L_BRS_($46AB)_($46A2) BAD
$46A4  28        PLP 
$46A5  05 39     ORA $39
$46A7  01 4A     ORA ($4A,X)
$46A9            .byte $02
//------------------------------
L_BRS_($46AB)_($46A2) BAD
//------------------------------
$46AA  84 07     STY $07 
$46AC  0A        ASL A 
$46AD            .byte $00
$46AE  16 07     ASL $07,X 
$46B0  26 03     ROL $03 
$46B2  46 04     LSR $04 
$46B4  84 07     STY $07 
$46B6            .byte $22,$07,$33
$46B9  06 84     ASL $84 
$46BB            .byte $07,$00,$00,$00,$00
$46C0  58        CLI 
$46C1  58        CLI 
$46C2  30 20     BMI L_BRS_($46E4)_($46C2) JAM
$46C4  4C 49 4E  JMP L_JMP_($4E49)_($46C4) OK
$46C7  45 53     EOR $53 
$46C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$46D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$46D9            .byte $00,$00,$00,$00,$00,$00,$00,$1C
//------------------------------
L_BRS_($46E4)_($46C2) JAM
//------------------------------
$46E1            .byte $1C,$3B,$07,$80,$1B,$3B,$07,$B8
$46E9  19 E1 16  ORA $16E1,Y
$46EC            .byte $44
$46ED  20 3B 07  JSR $073B
$46F0            .byte $67
$46F1  16 3B     ASL $3B,X 
$46F3            .byte $07,$9E,$17,$D4,$0B,$00,$00,$00
$46FB            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4703            .byte $00,$00,$00,$00,$00,$00,$00,$00
$470B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4713            .byte $00,$00,$00,$00,$00,$00,$00,$00
$471B            .byte $00,$00,$00,$00,$00,$03
$4721  01 03     ORA ($03,X)
$4723  05 05     ORA $05
$4725            .byte $03
$4726  05 02     ORA $02
$4728            .byte $02,$02
$472A  05 05     ORA $05
$472C            .byte $02,$04,$02,$03,$04,$03,$04,$04
$4734            .byte $04,$04,$04,$04,$04,$04,$02,$02
$473C            .byte $04,$04,$04,$04
//------------------------------
L_JSR_($4741)_($43F8) BAD
L_JSR_($4741)_($4B95) BAD
L_JSR_($4741)_($5C5B) BAD
//------------------------------
$4740  05 04     ORA $04
$4742            .byte $04,$04,$04,$04,$04,$04,$04,$03
$474A            .byte $04,$04,$04
$474D  05 04     ORA $04
$474F            .byte $04,$04
$4751  05 04     ORA $04
$4753            .byte $04
$4754  05 04     ORA $04
$4756  05 05     ORA $05
$4758  05 05     ORA $05
$475A  05 02     ORA $02
$475C            .byte $03,$02
$475E  05 05     ORA $05
$4760            .byte $04,$04,$04,$04,$04,$04,$04,$04
$4768            .byte $04
$4769  01 03     ORA ($03,X)
$476B            .byte $04
$476C  01 05     ORA ($05,X)
$476E            .byte $04,$04,$04,$04,$04,$04,$03,$04
$4776            .byte $03
$4777  05 05     ORA $05
$4779            .byte $04,$04,$03
$477C  01 03     ORA ($03,X)
$477E            .byte $04
$477F  05 45     ORA $45
$4781            .byte $52
$4782  49 43     EOR #$43
$4784            .byte $00,$00,$00,$00,$00,$00,$00,$00
$478C            .byte $00,$00,$42,$4F
$4790  59 20 57  EOR $5720,Y 
$4793            .byte $4F
$4794  4E 44 45  LSR $4544 
$4797            .byte $52,$00,$00,$00,$00
$479C  41 4E     EOR ($4E,X) 
$479E            .byte $47
$479F  45 4C     EOR $4C 
$47A1  46 41     LSR $41 
$47A3            .byte $43
$47A4  45 00     EOR $00 
$47A6            .byte $00,$00,$00,$00
$47AA  45 49     EOR $49 
$47AC  4E 53 54  LSR $5453 
$47AF  45 49     EOR $49 
$47B1  4E 00 00  LSR $0000 
$47B4            .byte $00,$00,$00,$00
$47B8  4D 52 20  EOR $2052 
$47BB            .byte $57
$47BC  41 43     EOR ($43,X) 
$47BE            .byte $4B
$47BF  45 52     EOR $52 
$47C1            .byte $00,$00,$00,$00,$00
$47C6  4D 52 20  EOR $2052 
$47C9            .byte $52,$4F,$43,$4B
$47CD  49 54     EOR #$54
$47CF            .byte $54,$00,$00,$00,$00
$47D4  4D 52 20  EOR $2052 
$47D7            .byte $57
$47D8  49 54     EOR #$54
$47DA  48        PHA 
$47DB  49 54     EOR #$54
$47DD            .byte $00,$00,$00,$00,$00
$47E2  4D 52 20  EOR $2052 
$47E5            .byte $43,$52
$47E7  45 41     EOR $41 
$47E9            .byte $4B,$00,$00,$00,$00,$00,$00
$47F0  50 6C     BVC L_BRS_($485E)_($47F0) OK
$47F2  65 61     ADC $61 
$47F4            .byte $73
$47F5  65 20     ADC $20 
$47F7            .byte $53
$47F8  69 72     ADC #$72
$47FA  20 2D 20  JSR L_JSR_($202D)_($47FA) OK
$47FD  49 20     EOR #$20
$47FF            .byte $63
$4800  61 6E     ADC ($6E,X) 
$4802  6E 6F 74  ROR $746F 
$4805  20 74 65  JSR L_JSR_($6574)_($4805) JAM
$4808  6C 6C 20  JMP ($206C) 
$480B  61 20     ADC ($20,X) 
$480D  6C 69 65  JMP ($6569) 
$4810  20 2E 20  JSR L_JSR_($202E)_($4810) OK
$4813  2E 20 00  ROL $0020 
$4816  20 20 20  JSR $2020
$4819  20 20 20  JSR $2020
$481C  20 20 00  JSR $0020
$481F            .byte $00,$00,$FA
$4822  C0 28     CPY #$28
$4824            .byte $12
$4825  4E 6C 40  LSR $406C 
$4828            .byte $7C,$82
$482A  10 08     BPL L_BRS_($4834)_($482A) OK
$482C  01 08     ORA ($08,X)
$482E            .byte $03,$03,$7C,$42
$4832  46 82     LSR $82 
//------------------------------
L_BRS_($4834)_($482A) OK
//------------------------------
$4834  38        SEC 
$4835            .byte $F2,$7C,$80
$4838  6C 62 36  JMP ($3662) 
$483B  31 08     AND ($08),Y 
$483D            .byte $14,$22
$483F  40        RTI 
//------------------------------
$4840  4C 7E FE  JMP L_JMP_($FE7E)_($4840) BAD
//------------------------------
L_JSR_($4843)_($8D6F) JAM
L_JSR_($4843)_($8E72) JAM
L_JSR_($4843)_($C4AE) JAM
L_JSR_($4843)_($CC45) JAM
L_JSR_($4843)_($CCF6) JAM
L_JSR_($4843)_($FEA8) JAM
//------------------------------
$4843            .byte $7C
$4844  FE FE FE  INC $FEFE,X 
$4847  7E FE 82  ROR $82FE,X 
$484A            .byte $04
$484B  FE FE FE  INC $FEFE,X 
$484E  FE 7C FE  INC $FE7C,X 
$4851            .byte $7C
//------------------------------
L_JSR_($4854)_($43CC) BAD
L_JSR_($4853)_($49D3) BAD
L_JSR_($4854)_($5A2C) BAD
L_JSR_($4854)_($5A4B) BAD
L_JSR_($4854)_($5A6D) BAD
L_JSR_($4854)_($5AA6) BAD
L_JSR_($4854)_($5B3D) BAD
L_JSR_($4854)_($5B46) BAD
L_JSR_($4854)_($5CA3) BAD
L_JSR_($4854)_($5CE9) BAD
L_JSR_($4854)_($C5AC) BAD
L_JSR_($4854)_($FFA6) BAD
//------------------------------
$4852  FE 62 80  INC $8062,X 
$4855            .byte $FC
//------------------------------
L_JSR_($4857)_($49C6) BAD
//------------------------------
$4856  E0 FC     CPX #$FC
$4858  C6 C0     DEC $C0 
$485A  86 FF     STX $FF 
$485C  C0 81     CPY #$81
//------------------------------
L_BRS_($485E)_($47F0) OK
//------------------------------
$485E  20 01 02  JSR $0201
$4861            .byte $1C
$4862  FE 1C 1C  INC $1C1C,X 
$4865            .byte $1C
$4866  10 18     BPL L_BRS_($4880)_($4866) JAM
$4868  FE 5E 01  INC $015E,X 
$486B  FE FE 3E  INC $3EFE,X 
$486E  3E 1C 3F  ROL $3F1C,X 
$4871  18        CLC 
$4872  3E 12 10  ROL $1012,X 
$4875            .byte $3C
$4876  38        SEC 
$4877  38        SEC 
$4878            .byte $22
$4879  38        SEC 
$487A  26 18     ROL $18 
$487C            .byte $FF
$487D  81 08     STA ($08,X) 
//------------------------------
L_BRS_($4880)_($4866) JAM
//------------------------------
$487F            .byte $7C,$52
$4881  45 56     EOR $56 
$4883  49 53     EOR #$53
$4885  49 4F     EOR #$4F
$4887  4E 00 20  LSR $2000 
$488A            .byte $00,$00,$00,$00,$00,$00,$52
$4891  45 41     EOR $41 
$4893            .byte $44
$4894  49 4E     EOR #$4E
$4896            .byte $47
$4897  20 52 4F  JSR L_JSR_($4F52)_($4897) OK
$489A            .byte $4F
$489B  4D 00 00  EOR $0000 
$489E            .byte $00,$00
$48A0  4D 41 50  EOR $5041 
$48A3  20 52 4F  JSR L_JSR_($4F52)_($48A3) OK
$48A6            .byte $4F
$48A7  4D 00 00  EOR $0000 
$48AA            .byte $00,$00,$00,$00,$00,$00,$57
$48B1  48        PHA 
$48B2  49 54     EOR #$54
$48B4  45 20     EOR $20 
$48B6            .byte $52,$4F,$4F
$48B9  4D 00 00  EOR $0000 
$48BC            .byte $00,$00,$00,$00
$48C0  45 58     EOR $58 
$48C2  41 4D     EOR ($4D,X) 
$48C4  20 52 4F  JSR L_JSR_($4F52)_($48C4) OK
$48C7            .byte $4F
//------------------------------
L_BRS_($48CA)_($4946) BAD
//------------------------------
$48C8  4D 00 00  EOR $0000 
$48CB            .byte $00,$00,$00,$00,$00
$48D0  4C 49 42  JMP L_JMP_($4249)_($48D0) OK
$48D3            .byte $52
//------------------------------
L_BRS_($48D5)_($4941) BAD
L_BRS_($48D4)_($4950) OK
//------------------------------
$48D4  41 52     EOR ($52,X) 
$48D6  59 00 00  EOR $0000,Y 
$48D9            .byte $00,$00,$00,$00,$00,$00,$00,$44
$48E1  49 4E     EOR #$4E
$48E3  4E 45 52  LSR $5245 
//------------------------------
L_BRS_($48E6)_($4952) JAM
//------------------------------
$48E6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$48EE            .byte $00,$00
$48F0  50 4C     BVC L_BRS_($493E)_($48F0) JAM
$48F2  41 59     EOR ($59,X) 
$48F4            .byte $54
$48F5  49 4D     EOR #$4D
$48F7  45 00     EOR $00 
$48F9            .byte $00,$00,$00,$00,$00,$00,$00
$4900  40        RTI 
//------------------------------
$4901  C0 40     CPY #$40
$4903  C0 40     CPY #$40
$4905  C0 40     CPY #$40
$4907  C0 40     CPY #$40
$4909  C0 40     CPY #$40
$490B  50 58     BVC L_BRS_($4965)_($490B) OK
$490D  60        RTS 
//------------------------------
$490E  48        PHA 
$490F  20 30 10  JSR L_JSR_($1030)_($490F) OK
$4912            .byte $7F,$7F,$00,$00,$00,$00,$00,$00
$491A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4922            .byte $00
$4923  FE 2A 10  INC $102A,X 
$4926            .byte $92,$80,$82,$7C,$7C
$492B  08        PHP 
$492C            .byte $02
$492D  08        PHP 
$492E            .byte $03
$492F  38        SEC 
$4930  8A        TXA 
$4931  FE 8A 92  INC $928A,X 
$4934  48        PHA 
$4935            .byte $92,$92
$4937  86 92     STX $92 
$4939            .byte $92
$493A  36 32     ROL $32,X 
//------------------------------
L_BRS_($493E)_($48F0) JAM
//------------------------------
$493C            .byte $14,$14,$14
$493F  8A        TXA 
$4940            .byte $52
//------------------------------
L_JSR_($4942)_($C47C) BAD
L_JSR_($4942)_($FE76) BAD
//------------------------------
$4941  90 92     BCC L_BRS_($48D5)_($4941) BAD
$4943            .byte $82,$82,$92
//------------------------------
L_JSR_($4946)_($49E3) OK
//------------------------------
$4946  90 82     BCC L_BRS_($48CA)_($4946) BAD
//------------------------------
L_BRS_($4948)_($4948) OK
L_JSR_($4948)_($4CC5) OK
//------------------------------
$4948  10 FE     BPL L_BRS_($4948)_($4948) OK
$494A            .byte $02
//------------------------------
L_JSR_($494C)_($C43B) BAD
L_JSR_($494C)_($FE35) BAD
//------------------------------
$494B  10 02     BPL L_BRS_($494F)_($494B) JAM
//------------------------------
L_JSR_($494D)_($C55B) OK
L_JSR_($494D)_($FF55) OK
//------------------------------
$494D  40        RTI 
//------------------------------
$494E  60        RTS 
//------------------------------
L_BRS_($494F)_($494B) JAM
//------------------------------
$494F            .byte $82
$4950  90 82     BCC L_BRS_($48D4)_($4950) OK
//------------------------------
L_JSR_($4953)_($4985) BAD
L_JSR_($4953)_($5C83) BAD
//------------------------------
$4952  90 92     BCC L_BRS_($48E6)_($4952) JAM
//------------------------------
L_JSR_($4954)_($4BF4) JAM
L_JSR_($4954)_($5306) JAM
L_JSR_($4954)_($5CEE) JAM
L_JSR_($4957)_($5CE4) JAM
//------------------------------
$4954            .byte $80,$02,$1C,$02
$4958  28        PLP 
$4959  20 8A 81  JSR L_JSR_($818A)_($4959) OK
$495C  38        SEC 
$495D            .byte $FF
$495E  40        RTI 
//------------------------------
$495F  01 7E     ORA ($7E,X)
$4961            .byte $22,$22,$22,$22
//------------------------------
L_BRS_($4965)_($490B) OK
//------------------------------
$4965  2A        ROL A 
$4966  7E 25 20  ROR $2025,X 
$4969            .byte $00
$496A  01 10     ORA ($10,X)
$496C            .byte $00
$496D  20 10 22  JSR L_JSR_($2210)_($496D) OK
$4970  24 24     BIT $24 
$4972  10 2A     BPL L_BRS_($499E)_($4972) JAM
$4974  7E 02 06  ROR $0602,X 
$4977  06 14     ASL $14 
$4979  05 2A     ORA $2A
$497B  66 00     ROR $00 
$497D  66 10     ROR $10 
$497F            .byte $92,$44,$4F
$4982  4E 27 54  LSR $5427 
$4985  20 53 49  JSR L_JSR_($4953)_($4985) BAD
$4988            .byte $54
$4989  20 4F 4E  JSR L_JSR_($4E4F)_($4989) JAM
$498C            .byte $00,$00,$00,$00,$54
$4991  48        PHA 
$4992  45 20     EOR $20 
$4994            .byte $53,$54
$4996  41 49     EOR ($49,X) 
//------------------------------
L_BRS_($499E)_($4972) JAM
//------------------------------
$4998            .byte $52,$53,$00,$00,$00,$00,$00,$00
$49A0            .byte $54
$49A1  48        PHA 
$49A2  45 20     EOR $20 
$49A4            .byte $52,$4F,$4F
$49A7  4D 20 49  EOR $4920 
$49AA            .byte $53,$00,$00,$00,$00,$00
$49B0  50 52     BVC L_BRS_($4A04)_($49B0) JAM
$49B2  49 56     EOR #$56
$49B4  41 54     EOR ($54,X) 
$49B6  45 00     EOR $00 
$49B8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$49C0            .byte $47
$49C1  45 54     EOR $54 
$49C3  20 54 4F  JSR L_JSR_($4F54)_($49C3) BAD
$49C6  20 57 48  JSR L_JSR_($4857)_($49C6) BAD
$49C9  45 52     EOR $52 
//------------------------------
L_BRS_($49CC)_($4A48) BAD
//------------------------------
$49CB  45 00     EOR $00 
$49CD            .byte $00,$00,$00
//------------------------------
L_BRS_($49D2)_($4A46) BAD
//------------------------------
$49D0  59 4F 55  EOR $554F,Y 
//------------------------------
L_BRS_($49D5)_($4A41) BAD
//------------------------------
$49D3  20 53 48  JSR L_JSR_($4853)_($49D3) BAD
$49D6            .byte $4F
//------------------------------
L_BRS_($49D8)_($4A50) BAD
//------------------------------
$49D7  55 4C     EOR $4C,X 
$49D9            .byte $44
$49DA  20 42 45  JSR L_JSR_($4542)_($49DA) JAM
$49DD            .byte $00,$00,$00
$49E0  4E 4F 57  LSR $574F 
$49E3  20 46 49  JSR L_JSR_($4946)_($49E3) OK
$49E6  4E 44 00  LSR $0044 
$49E9            .byte $00,$00,$00,$00,$00,$00,$00
$49F0  41 20     EOR ($20,X) 
$49F2            .byte $53
$49F3  45 41     EOR $41 
$49F5            .byte $54,$00,$00,$00,$00,$00,$00,$00
$49FD            .byte $00,$00,$00,$2B
$4A01  2C 2D 2E  BIT $2E2D 
//------------------------------
L_BRS_($4A04)_($49B0) JAM
//------------------------------
$4A04            .byte $80,$2F
$4A06  31 32     AND ($32),Y 
$4A08            .byte $33,$34
$4A0A  35 0A     AND $0A,X 
$4A0C  0A        ASL A 
$4A0D  0A        ASL A 
$4A0E  0A        ASL A 
$4A0F  46 19     LSR $19 
$4A11  46 A0     LSR $A0 
$4A13  A0 30     LDY #$30
$4A15            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A1D            .byte $00,$00,$00,$00,$00
$4A22  C0 28     CPY #$28
$4A24            .byte $7F
$4A25  E4 92     CPX $92 
$4A27            .byte $00,$00,$00
$4A2A  38        SEC 
$4A2B  3E 00 08  ROL $0800,X 
$4A2E            .byte $00
$4A2F  C0 92     CPY #$92
$4A31            .byte $02,$92
//------------------------------
L_BRS_($4A33)_($4A33) OK
//------------------------------
$4A33  B0 FE     BCS L_BRS_($4A33)_($4A33) OK
$4A35            .byte $92,$92
$4A37  98        TYA 
$4A38            .byte $92,$92,$00,$00,$14,$14,$14
$4A3F  90 5E     BCC L_BRS_($4A9F)_($4A3F) JAM
$4A41  90 92     BCC L_BRS_($49D5)_($4A41) BAD
$4A43            .byte $82,$82,$92
$4A46  90 8A     BCC L_BRS_($49D2)_($4A46) BAD
$4A48  10 82     BPL L_BRS_($49CC)_($4A48) BAD
$4A4A            .byte $02
$4A4B  28        PLP 
$4A4C            .byte $02
$4A4D  30 18     BMI L_BRS_($4A67)_($4A4D) BAD
$4A4F            .byte $82
$4A50  90 86     BCC L_BRS_($49D8)_($4A50) BAD
$4A52  98        TYA 
$4A53            .byte $92
$4A54  FE 02 02  INC $0202,X 
$4A57            .byte $1C
$4A58  10 1E     BPL L_BRS_($4A78)_($4A58) OK
$4A5A            .byte $92,$00,$03,$00,$BF
$4A5F  01 92     ORA ($92,X)
$4A61            .byte $22,$22,$22,$22
$4A65  2A        ROL A 
//------------------------------
L_BRS_($4A67)_($4A4D) BAD
//------------------------------
$4A66  90 25     BCC L_BRS_($4A8D)_($4A66) JAM
$4A68  20 00 5E  JSR L_JSR_($5E00)_($4A68) JAM
$4A6B  28        PLP 
$4A6C            .byte $00
$4A6D  1E 20 22  ASL $2220,X 
$4A70  24 24     BIT $24 
$4A72  20 2A 10  JSR L_JSR_($102A)_($4A72) OK
$4A75            .byte $02
$4A76  38        SEC 
$4A77  38        SEC 
//------------------------------
L_BRS_($4A78)_($4A58) OK
//------------------------------
$4A78  08        PHP 
$4A79  05 32     ORA $32
$4A7B  81 00     STA ($00,X) 
$4A7D  18        CLC 
$4A7E  08        PHP 
$4A7F  AA        TAX 
$4A80            .byte $47
$4A81  45 54     EOR $54 
$4A83  20 4F 46  JSR L_JSR_($464F)_($4A83) JAM
$4A86  46 00     LSR $00 
//------------------------------
L_BRS_($4A8D)_($4A66) JAM
//------------------------------
$4A88            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A90            .byte $54
$4A91  48        PHA 
$4A92  45 20     EOR $20 
$4A94  46 4C     LSR $4C 
$4A96            .byte $4F,$4F,$52,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($4A9F)_($4A3F) JAM
//------------------------------
$4A9E            .byte $00,$00,$43,$4F
$4AA2  4D 45 20  EOR $2045 
$4AA5  41 4C     EOR ($4C,X) 
$4AA7            .byte $4F
$4AA8  4E 47 00  LSR $0047 
$4AAB            .byte $00,$00,$00,$00,$00,$57
$4AB1  49 54     EOR #$54
$4AB3  48        PHA 
$4AB4  20 4D 45  JSR L_JSR_($454D)_($4AB4) JAM
$4AB7  20 42 4F  JSR L_JSR_($4F42)_($4AB7) BAD
$4ABA  59 00 00  EOR $0000,Y 
$4ABD            .byte $00,$00,$00
$4AC0  48        PHA 
$4AC1  55 52     EOR $52,X 
$4AC3            .byte $52
$4AC4  59 20 55  EOR $5520,Y 
$4AC7  50 20     BVC L_BRS_($4AE9)_($4AC7) BAD
$4AC9  59 4F 55  EOR $554F,Y 
$4ACC            .byte $00,$00,$00,$00
$4AD0  48        PHA 
$4AD1            .byte $4F,$52,$52,$4F,$52,$00,$00,$00
$4AD9            .byte $00,$00,$00,$00,$00,$00,$00,$44
$4AE1            .byte $4F
$4AE2  4E 27 54  LSR $5427 
$4AE5  20 54 52  JSR L_JSR_($5254)_($4AE5) BAD
//------------------------------
L_BRS_($4AE9)_($4AC7) BAD
//------------------------------
$4AE8  59 20 4D  EOR $4D20,Y 
$4AEB  59 00 00  EOR $0000,Y 
$4AEE            .byte $00,$00
$4AF0  50 41     BVC L_BRS_($4B33)_($4AF0) OK
$4AF2            .byte $54
$4AF3  49 45     EOR #$45
$4AF5  4E 43 45  LSR $4543 
$4AF8  20 42 4F  JSR L_JSR_($4F42)_($4AF8) BAD
$4AFB  59 00 00  EOR $0000,Y 
//------------------------------
L_BRS_($4B02)_($4B7E) JAM
//------------------------------
$4AFE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4B06            .byte $00,$00,$00,$00,$00
$4B0B  10 10     BPL L_BRS_($4B1D)_($4B0B) JAM
$4B0D  10 10     BPL L_BRS_($4B1F)_($4B0D) JAM
$4B0F            .byte $00,$00,$00
$4B12  20 20 FF  JSR L_JSR_($FF20)_($4B12) OK
$4B15            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($4B1D)_($4B0B) JAM
L_BRS_($4B1F)_($4B0D) JAM
//------------------------------
$4B1D            .byte $00,$00,$00,$00,$00,$00
$4B23  FE 2A 00  INC $002A,X 
$4B26  6D 00 00  ADC $0000 
$4B29            .byte $00,$7C
$4B2B  08        PHP 
$4B2C            .byte $00
$4B2D  08        PHP 
$4B2E            .byte $00,$00,$7C,$00,$62
//------------------------------
L_BRS_($4B33)_($4AF0) OK
//------------------------------
$4B33  CC 08 8C  CPY $8C08 
$4B36  8C E0 6C  STY $6CE0 
$4B39            .byte $7C,$00,$00,$22,$14
$4B3E  08        PHP 
$4B3F  60        RTS 
//------------------------------
$4B40            .byte $42
$4B41  7E 6C 82  ROR $826C,X 
$4B44            .byte $7C,$82,$80
$4B47  4E FE 00  LSR $00FE 
$4B4A            .byte $FC
$4B4B  C6 02     DEC $02 
$4B4D  40        RTI 
//------------------------------
$4B4E  FE 7C 60  INC $607C,X 
$4B51            .byte $7C
$4B52  66 8C     ROR $8C 
$4B54            .byte $80,$FC,$1C,$02
$4B58  28        PLP 
$4B59  20 A2 00  JSR $00A2
$4B5C            .byte $00,$00
$4B5E  40        RTI 
//------------------------------
$4B5F  01 82     ORA ($82,X)
$4B61  3E 1C 22  ROL $221C,X 
$4B64  FE 18 40  INC $4018,X 
$4B67  3E 1E 00  ROL $001E,X 
$4B6A            .byte $00
$4B6B  06 00     ASL $00 
$4B6D  20 1E 1C  JSR L_JSR_($1C1E)_($4B6D) BAD
$4B70  18        CLC 
$4B71            .byte $3F
$4B72  10 24     BPL L_BRS_($4B98)_($4B72) OK
$4B74            .byte $00
$4B75  3E 00 06  ROL $0600,X 
$4B78            .byte $14
$4B79  3E 22 00  ROL $0022,X 
$4B7C            .byte $00,$00
$4B7E  10 82     BPL L_BRS_($4B02)_($4B7E) JAM
$4B80  4E 4F 57  LSR $574F 
$4B83  20 44 4F  JSR L_JSR_($4F44)_($4B83) BAD
$4B86  4E 27 54  LSR $5427 
$4B89            .byte $00,$00,$00,$00,$00,$00,$00,$44
$4B91            .byte $4F
$4B92  20 49 54  JSR L_JSR_($5449)_($4B92) BAD
$4B95  20 41 47  JSR L_JSR_($4741)_($4B95) BAD
//------------------------------
L_BRS_($4B98)_($4B72) OK
//------------------------------
$4B98  41 49     EOR ($49,X) 
$4B9A  4E 00 00  LSR $0000 
$4B9D            .byte $00,$00,$00,$44,$4F
$4BA2  4E 27 54  LSR $5427 
$4BA5  20 54 45  JSR L_JSR_($4554)_($4BA5) JAM
$4BA8  4C 4C 00  JMP $004C
$4BAB            .byte $00,$00,$00,$00,$00,$54
$4BB1  41 4C     EOR ($4C,X) 
$4BB3  45 53     EOR $53 
$4BB5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4BBD            .byte $00,$00,$00
$4BC0  4E 45 56  LSR $5645 
$4BC3  45 52     EOR $52 
$4BC5  20 42 45  JSR L_JSR_($4542)_($4BC5) JAM
$4BC8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4BD0  4C 41 54  JMP L_JMP_($5441)_($4BD0) BAD
$4BD3  45 20     EOR $20 
$4BD5  41 47     EOR ($47,X) 
$4BD7  41 49     EOR ($49,X) 
$4BD9  4E 00 00  LSR $0000 
$4BDC            .byte $00,$00,$00,$00
$4BE0  41 4E     EOR ($4E,X) 
$4BE2            .byte $44
$4BE3  20 53 54  JSR L_JSR_($5453)_($4BE3) OK
$4BE6  41 59     EOR ($59,X) 
$4BE8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4BF0            .byte $54
$4BF1  48        PHA 
$4BF2  49 53     EOR #$53
$4BF4  20 54 49  JSR L_JSR_($4954)_($4BF4) JAM
$4BF7  4D 45 00  EOR $0045 
$4BFA            .byte $00,$00,$00,$00,$00,$00,$54
$4C01  41 4B     EOR ($4B,X) 
$4C03  45 20     EOR $20 
$4C05            .byte $32
$4C06  30 30     BMI L_BRS_($4C38)_($4C06) JAM
$4C08  30 20     BMI L_BRS_($4C2A)_($4C08) OK
$4C0A  4C 49 4E  JMP L_JMP_($4E49)_($4C0A) OK
$4C0D  45 53     EOR $53 
$4C0F  20 59 4F  JSR L_JSR_($4F59)_($4C0F) OK
$4C12  55 20     EOR $20,X 
$4C14  4E 41 53  LSR $5341 
$4C17            .byte $54
$4C18  59 20 42  EOR $4220,Y 
$4C1B            .byte $4F
$4C1C  59 03 00  EOR $0003,Y 
$4C1F            .byte $00,$00,$00,$00
$4C23  28        PLP 
$4C24  24 00     BIT $00 
$4C26            .byte $02,$00,$00,$00
//------------------------------
L_BRS_($4C2A)_($4C08) OK
//------------------------------
$4C2A  10 08     BPL L_BRS_($4C34)_($4C2A) JAM
$4C2C            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($4C34)_($4C2A) JAM
L_BRS_($4C38)_($4C06) JAM
//------------------------------
$4C34            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($4C41)_($5C3D) JAM
//------------------------------
$4C3C            .byte $00,$00,$00,$00,$3C,$00,$00,$00
//------------------------------
L_JSR_($4C45)_($5A20) JAM
//------------------------------
$4C44            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4C4C            .byte $00
$4C4D  FE 00 00  INC $0000,X 
//------------------------------
L_JSR_($4C50)_($43F3) JAM
L_JSR_($4C50)_($4618) JAM
L_JSR_($4C50)_($5C56) JAM
//------------------------------
$4C50            .byte $00,$02,$00,$00,$80,$00
$4C56  E0 FC     CPX #$FC
$4C58  C6 C0     DEC $C0 
$4C5A            .byte $C2,$00,$00,$00
$4C5E  20 01 00  JSR $0001
$4C61            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4C69            .byte $00,$00,$00,$00
$4C6D  1E 00 00  ASL $0000,X 
$4C70            .byte $00,$00,$00,$00,$00,$00,$00
$4C77  38        SEC 
$4C78            .byte $22,$00,$00,$00,$00,$00,$00,$7C
$4C80            .byte $44,$4F
$4C82  4E 27 54  LSR $5427 
$4C85  20 54 4F  JSR L_JSR_($4F54)_($4C85) BAD
$4C88  55 43     EOR $43,X 
$4C8A  48        PHA 
$4C8B            .byte $00,$00,$00,$00,$00,$42
$4C91  4C 41 43  JMP L_JMP_($4341)_($4C91) BAD
$4C94            .byte $4B,$42,$4F
$4C97  41 52     EOR ($52,X) 
$4C99            .byte $44,$53,$00,$00,$00,$00,$00,$43
$4CA1  41 54     EOR ($54,X) 
$4CA3  41 50     EOR ($50,X) 
$4CA5  55 4C     EOR $4C,X 
$4CA7            .byte $54,$53,$00,$00,$00,$00,$00,$00
$4CAF            .byte $00
$4CB0  41 52     EOR ($52,X) 
$4CB2  45 20     EOR $20 
$4CB4  46 4F     LSR $4F 
$4CB6            .byte $52,$42
$4CB8  49 44     EOR #$44
$4CBA            .byte $44
$4CBB  45 4E     EOR $4E 
$4CBD            .byte $00,$00,$00,$44,$4F
$4CC2  4E 27 54  LSR $5427 
$4CC5  20 48 49  JSR L_JSR_($4948)_($4CC5) OK
$4CC8            .byte $54,$00,$00,$00,$00,$00,$00,$00
$4CD0  59 4F 55  EOR $554F,Y 
$4CD3            .byte $52
$4CD4  20 4D 41  JSR L_JSR_($414D)_($4CD4) OK
$4CD7            .byte $54
$4CD8  45 53     EOR $53 
$4CDA            .byte $00,$00,$00,$00,$00,$00
$4CE0  59 4F 55  EOR $554F,Y 
$4CE3  20 41 52  JSR L_JSR_($5241)_($4CE3) BAD
$4CE6  45 20     EOR $20 
$4CE8  4E 4F 54  LSR $544F 
$4CEB            .byte $00,$00,$00,$00,$00
$4CF0  41 20     EOR ($20,X) 
$4CF2            .byte $4B
$4CF3  41 4E     EOR ($4E,X) 
$4CF5            .byte $47
$4CF6  41 52     EOR ($52,X) 
$4CF8            .byte $4F,$4F,$00,$00,$00,$00,$00,$00
$4D00            .byte $53
$4D01  6E 00 00  ROR $0000 
$4D04            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4D0C            .byte $54
$4D0D  69 6E     ADC #$6E
$4D0F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4D17            .byte $00
$4D18  48        PHA 
$4D19            .byte $67,$00,$00,$00,$00,$00,$00,$00
$4D21            .byte $00,$00,$00
$4D24  4D 65 72  EOR $7265 
$4D27            .byte $63
$4D28  75 72     ADC $72,X 
$4D2A  79 00 00  ADC $0000,Y 
$4D2D            .byte $00,$00,$00
$4D30  41 75     EOR ($75,X) 
$4D32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4D3A            .byte $00,$00,$47,$6F
$4D3E  6C 64 00  JMP ($0064) 
$4D41            .byte $00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JMP_($4D49)_($5525) BAD
//------------------------------
$4D48  41 67     EOR ($67,X) 
$4D4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4D52            .byte $00,$00,$53
$4D55  69 6C     ADC #$6C
$4D57  76 65     ROR $65,X 
$4D59            .byte $72,$00,$00,$00,$00,$00,$00
$4D60  50 74     BVC L_BRS_($4DD6)_($4D60) JAM
$4D62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4D6A            .byte $00,$00
$4D6C  50 6C     BVC L_BRS_($4DDA)_($4D6C) JAM
$4D6E  61 74     ADC ($74,X) 
$4D70  69 6E     ADC #$6E
$4D72  75 6D     ADC $6D,X 
$4D74            .byte $00,$00,$00,$00,$43
$4D79  75 00     ADC $00,X 
$4D7B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4D83            .byte $00,$43,$6F
$4D86  70 70     BVS L_BRS_($4DF8)_($4D86) JAM
$4D88  65 72     ADC $72 
$4D8A            .byte $00,$00,$00,$00,$00,$00
$4D90  4D 67 00  EOR $0067 
$4D93            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4D9B            .byte $00
$4D9C  4D 61 67  EOR $6761 
$4D9F  6E 65 73  ROR $7365 
$4DA2  69 75     ADC #$75
$4DA4  6D 00 00  ADC $0000 
$4DA7            .byte $00
$4DA8  50 62     BVC L_BRS_($4E0C)_($4DA8) JAM
$4DAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4DB2            .byte $00,$00
$4DB4  4C 65 61  JMP L_JMP_($6165)_($4DB4) OK
$4DB7            .byte $64,$00,$00,$00,$00,$00,$00,$00
$4DBF            .byte $00
$4DC0  4D 6E 00  EOR $006E 
$4DC3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4DCB            .byte $00
$4DCC  4D 61 6E  EOR $6E61 
$4DCF            .byte $67
$4DD0  61 6E     ADC ($6E,X) 
$4DD2  65 73     ADC $73 
$4DD4  65 00     ADC $00 
//------------------------------
L_BRS_($4DD6)_($4D60) JAM
L_BRS_($4DDA)_($4D6C) JAM
//------------------------------
$4DD6            .byte $00,$00,$53,$62,$00,$00,$00,$00
$4DDE            .byte $00,$00,$00,$00,$00,$00
$4DE4  41 6E     EOR ($6E,X) 
$4DE6            .byte $74
$4DE7  69 6D     ADC #$6D
$4DE9            .byte $6F
$4DEA  6E 79 00  ROR $0079 
$4DED            .byte $00,$00,$00
$4DF0  41 73     EOR ($73,X) 
//------------------------------
L_BRS_($4DF8)_($4D86) JAM
//------------------------------
$4DF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4DFA            .byte $00,$00
$4DFC  41 72     EOR ($72,X) 
$4DFE            .byte $73
$4DFF  65 6E     ADC $6E 
$4E01  69 63     ADC #$63
$4E03            .byte $00,$00,$00,$00,$00,$4B,$00,$00
//------------------------------
L_BRS_($4E0C)_($4DA8) JAM
//------------------------------
$4E0B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4E13            .byte $00
$4E14  50 6F     BVC L_BRS_($4E85)_($4E14) JAM
$4E16            .byte $74
$4E17  61 73     ADC ($73,X) 
$4E19            .byte $73
$4E1A  69 75     ADC #$75
$4E1C  6D 00 00  ADC $0000 
$4E1F            .byte $00
$4E20  4E 61 00  LSR $0061 
$4E23            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4E2B            .byte $00,$53,$6F,$64
$4E2F  69 75     ADC #$75
$4E31  6D 00 00  ADC $0000 
$4E34            .byte $00,$00,$00,$00,$43
$4E39  6C 00 00  JMP ($0000) 
//------------------------------
L_JSR_($4E41)_($5367) JAM
L_JMP_($4E41)_($55E6) JAM
L_JMP_($4E41)_($55F2) JAM
L_JSR_($4E41)_($5B9F) JAM
L_JSR_($4E41)_($5C8A) JAM
L_JSR_($4E41)_($C4A0) JAM
L_JSR_($4E41)_($FE9A) JAM
//------------------------------
$4E3C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4E44            .byte $43
//------------------------------
L_JMP_($4E45)_($5C86) OK
//------------------------------
$4E45  68        PLA 
$4E46  6C 6F 72  JMP ($726F) 
//------------------------------
L_JMP_($4E49)_($46C4) OK
L_JMP_($4E49)_($4C0A) OK
L_JSR_($4E49)_($55C9) OK
L_JSR_($4E49)_($5ACD) OK
L_JSR_($4E49)_($5B3A) OK
L_JMP_($4E49)_($5BFA) OK
//------------------------------
$4E49  69 6E     ADC #$6E
$4E4B  65 00     ADC $00 
//------------------------------
L_JSR_($4E4F)_($43C6) JAM
L_JSR_($4E4F)_($4989) JAM
//------------------------------
$4E4D            .byte $00,$00,$00,$5A
$4E51  6E 00 00  ROR $0000 
//------------------------------
L_JSR_($4E54)_($5491) JAM
//------------------------------
$4E54            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4E5C            .byte $5A
$4E5D  69 6E     ADC #$6E
$4E5F            .byte $63,$00,$00,$00,$00,$00,$00,$00
$4E67            .byte $00,$57,$00,$00,$00,$00,$00,$00
$4E6F            .byte $00,$00,$00,$00,$00,$54
$4E75  75 6E     ADC $6E,X 
$4E77            .byte $67,$73,$74
$4E7A  65 6E     ADC $6E 
$4E7C            .byte $00,$00,$00,$00,$43,$73,$00,$00
//------------------------------
L_BRS_($4E85)_($4E14) JAM
//------------------------------
$4E84            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4E8C            .byte $43
$4E8D  61 65     ADC ($65,X) 
$4E8F            .byte $73
$4E90  69 75     ADC #$75
$4E92  6D 00 00  ADC $0000 
$4E95            .byte $00,$00,$00,$53
$4E99  69 00     ADC #$00
$4E9B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4EA3            .byte $00,$53
$4EA5  69 6C     ADC #$6C
$4EA7  69 63     ADC #$63
$4EA9            .byte $6F
$4EAA  6E 00 00  ROR $0000 
$4EAD            .byte $00,$00,$00
$4EB0  50 00     BVC L_BRS_($4EB2)_($4EB0) JAM
//------------------------------
L_BRS_($4EB2)_($4EB0) JAM
//------------------------------
$4EB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4EBA            .byte $00,$00
$4EBC  50 68     BVC L_BRS_($4F26)_($4EBC) JAM
$4EBE            .byte $6F,$73
$4EC0  70 68     BVS L_BRS_($4F2A)_($4EC0) BAD
$4EC2            .byte $6F,$72,$6F
$4EC5  75 73     ADC $73,X 
$4EC7            .byte $00,$42,$72,$00,$00,$00,$00,$00
$4ECF            .byte $00,$00,$00,$00,$00,$42,$72,$6F
$4ED7  6D 69 6E  ADC $6E69 
$4EDA  65 00     ADC $00 
$4EDC            .byte $00,$00,$00,$00
$4EE0  48        PHA 
$4EE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4EE9            .byte $00,$00,$00
$4EEC  48        PHA 
$4EED  79 64 72  ADC $7264,Y 
$4EF0            .byte $6F,$67
$4EF2  65 6E     ADC $6E 
$4EF4            .byte $00,$00,$00,$00,$42
$4EF9  65 72     ADC $72 
$4EFB  6E 65 00  ROR $0065 
$4EFE            .byte $00,$00,$00,$00,$00,$00,$53,$77
$4F06  69 74     ADC #$74
$4F08            .byte $7A
$4F09  65 72     ADC $72 
$4F0B  6C 61 6E  JMP ($6E61) 
$4F0E            .byte $64,$00
$4F10  48        PHA 
$4F11  65 6C     ADC $6C 
$4F13            .byte $73
$4F14  69 6E     ADC #$6E
$4F16            .byte $6B
$4F17  69 00     ADC #$00
$4F19            .byte $00,$00,$00
$4F1C  46 69     LSR $69 
$4F1E  6E 6C 61  ROR $616C 
$4F21  6E 64 00  ROR $0064 
//------------------------------
L_BRS_($4F26)_($4EBC) JAM
//------------------------------
$4F24            .byte $00,$00,$00,$00,$52
//------------------------------
L_BRS_($4F2A)_($4EC0) BAD
//------------------------------
$4F29  65 79     ADC $79 
$4F2B            .byte $6B
$4F2C  6A        ROR A 
$4F2D  61 76     ADC ($76,X) 
$4F2F  69 6B     ADC #$6B
$4F31            .byte $00,$00,$00
$4F34  49 63     EOR #$63
$4F36  65 6C     ADC $6C 
$4F38  61 6E     ADC ($6E,X) 
$4F3A            .byte $64,$00,$00,$00,$00,$00,$42
//------------------------------
L_JSR_($4F42)_($4AB7) BAD
L_JSR_($4F42)_($4AF8) BAD
L_JSR_($4F42)_($5B51) BAD
L_JSR_($4F42)_($5C7A) BAD
//------------------------------
$4F41  75 64     ADC $64,X 
//------------------------------
L_JSR_($4F44)_($4B83) BAD
L_JSR_($4F43)_($5A85) OK
L_JSR_($4F44)_($5B63) BAD
L_JSR_($4F44)_($5C0B) BAD
L_JSR_($4F43)_($5C11) OK
L_JSR_($4F43)_($C52F) OK
L_JSR_($4F43)_($FF29) OK
//------------------------------
$4F43  61 70     ADC ($70,X) 
$4F45  65 73     ADC $73 
//------------------------------
L_JSR_($4F47)_($43B0) JAM
L_JSR_($4F47)_($468A) JAM
L_JSR_($4F47)_($5DEA) JAM
L_JSR_($4F48)_($43BE) JAM
//------------------------------
$4F47            .byte $74,$00,$00,$00,$00
//------------------------------
L_JSR_($4F4C)_($5CC5) OK
//------------------------------
$4F4C  48        PHA 
//------------------------------
L_JSR_($4F4E)_($C557) BAD
L_JSR_($4F4E)_($FF51) BAD
//------------------------------
$4F4D  75 6E     ADC $6E,X 
$4F4F            .byte $67
$4F50  61 72     ADC ($72,X) 
//------------------------------
L_JSR_($4F54)_($43F0) BAD
L_JSR_($4F54)_($4615) BAD
L_JSR_($4F52)_($4897) OK
L_JSR_($4F52)_($48A3) OK
L_JSR_($4F52)_($48C4) OK
L_JSR_($4F54)_($49C3) BAD
L_JSR_($4F54)_($4C85) BAD
L_JSR_($4F54)_($5BFF) BAD
L_JSR_($4F54)_($5C1B) BAD
L_JSR_($4F54)_($5C53) BAD
//------------------------------
$4F52  79 00 00  ADC $0000,Y 
$4F55            .byte $00,$00,$00,$42
//------------------------------
L_JSR_($4F59)_($462C) OK
L_JSR_($4F59)_($4C0F) OK
L_JSR_($4F59)_($5BAA) OK
L_JSR_($4F59)_($5BE1) OK
L_JSR_($4F59)_($5C75) OK
L_JSR_($4F59)_($5CC0) OK
//------------------------------
$4F59  75 63     ADC $63,X 
$4F5B  68        PLA 
$4F5C  61 72     ADC ($72,X) 
$4F5E  65 73     ADC $73 
$4F60            .byte $74,$00,$00,$00,$52,$6F
$4F66  6D 61 6E  ADC $6E61 
$4F69  69 61     ADC #$61
$4F6B            .byte $00,$00,$00,$00,$00,$54
$4F71  69 72     ADC #$72
$4F73  61 6E     ADC ($6E,X) 
$4F75  61 00     ADC ($00,X) 
$4F77            .byte $00,$00,$00,$00,$00
$4F7C  41 6C     EOR ($6C,X) 
$4F7E            .byte $62
$4F7F  61 6E     ADC ($6E,X) 
$4F81  69 61     ADC #$61
$4F83            .byte $00,$00,$00,$00,$00
$4F88  4A        LSR A 
$4F89  61 6B     ADC ($6B,X) 
$4F8B  61 72     ADC ($72,X) 
$4F8D            .byte $74
$4F8E  61 00     ADC ($00,X) 
$4F90            .byte $00,$00,$00,$00
$4F94  49 6E     EOR #$6E
$4F96            .byte $64,$6F
$4F98  6E 65 73  ROR $7365 
$4F9B  69 61     ADC #$61
$4F9D            .byte $00,$00,$00
$4FA0  50 79     BVC L_BRS_($501B)_($4FA0) BAD
$4FA2            .byte $6F
$4FA3  6E 67 79  ROR $7967 
$4FA6  61 6E     ADC ($6E,X) 
$4FA8            .byte $67,$00,$00,$00
$4FAC  4E 6F 72  LSR $726F 
$4FAF            .byte $74
$4FB0  68        PLA 
$4FB1  20 4B 6F  JSR L_JSR_($6F4B)_($4FB1) OK
$4FB4            .byte $72
$4FB5  65 61     ADC $61 
$4FB7            .byte $00
$4FB8  56 69     LSR $69,X 
$4FBA  65 6E     ADC $6E 
$4FBC            .byte $74
$4FBD  69 61     ADC #$61
$4FBF  6E 65 00  ROR $0065 
$4FC2            .byte $00,$00
$4FC4  4C 61 6F  JMP L_JMP_($6F61)_($4FC4) JAM
$4FC7            .byte $73,$00,$00,$00,$00,$00,$00,$00
$4FCF            .byte $00
$4FD0  49 73     EOR #$73
$4FD2  6C 61 6D  JMP ($6D61) 
$4FD5  61 62     ADC ($62,X) 
$4FD7  61 64     ADC ($64,X) 
$4FD9            .byte $00,$00,$00
$4FDC  50 61     BVC L_BRS_($503F)_($4FDC) JAM
$4FDE            .byte $6B
$4FDF  69 73     ADC #$73
$4FE1            .byte $74
$4FE2  61 6E     ADC ($6E,X) 
$4FE4            .byte $00,$00,$00,$00,$52
$4FE9  61 6E     ADC ($6E,X) 
$4FEB            .byte $67,$6F,$6F
$4FEE  6E 00 00  ROR $0000 
$4FF1            .byte $00,$00,$00,$42
$4FF5  75 72     ADC $72,X 
$4FF7  6D 61 00  ADC $0061 
$4FFA            .byte $00,$00,$00,$00,$00,$00
$5000  41 6E     EOR ($6E,X) 
$5002            .byte $6B
$5003  61 72     ADC ($72,X) 
$5005  61 00     ADC ($00,X) 
$5007            .byte $00,$00,$00,$00,$00,$54
$500D  75 72     ADC $72,X 
$500F            .byte $6B
$5010  65 79     ADC $79 
$5012            .byte $00,$00,$00,$00,$00,$00
$5018  41 6D     EOR ($6D,X) 
//------------------------------
L_BRS_($501B)_($4FA0) BAD
//------------------------------
$501A  6D 61 6E  ADC $6E61 
$501D            .byte $00,$00,$00,$00,$00,$00,$00
$5024  4A        LSR A 
$5025            .byte $6F,$72,$64
$5028  61 6E     ADC ($6E,X) 
//------------------------------
L_JSR_($502E)_($5C46) JAM
//------------------------------
$502A            .byte $00,$00,$00,$00,$00,$00,$47
$5031  61 62     ADC ($62,X) 
$5033  61 72     ADC ($72,X) 
$5035            .byte $6F
$5036  6E 65 00  ROR $0065 
//------------------------------
L_BRS_($503F)_($4FDC) JAM
//------------------------------
$5039            .byte $00,$00,$00,$42,$6F,$74,$73,$77
//------------------------------
L_JMP_($5041)_($5530) OK
//------------------------------
$5041  61 6E     ADC ($6E,X) 
$5043  61 00     ADC ($00,X) 
$5045            .byte $00,$00,$00
$5048  4C 75 73  JMP L_JMP_($7375)_($5048) OK
$504B  61 6B     ADC ($6B,X) 
$504D  61 00     ADC ($00,X) 
$504F            .byte $00,$00,$00,$00,$00,$5A
$5055  61 6D     ADC ($6D,X) 
$5057            .byte $62
$5058  69 61     ADC #$61
$505A            .byte $00,$00,$00,$00,$00,$00
$5060  4D 6F 6E  EOR $6E6F 
$5063            .byte $72,$6F
$5065  76 69     ROR $69,X 
$5067  61 00     ADC ($00,X) 
$5069            .byte $00,$00,$00
$506C  4C 69 62  JMP L_JMP_($6269)_($506C) OK
$506F  65 72     ADC $72 
$5071  69 61     ADC #$61
$5073            .byte $00,$00,$00,$00,$00
$5078  4C 61 20  JMP L_JMP_($2061)_($5078) OK
$507B  50 61     BVC L_BRS_($50DE)_($507B) JAM
$507D            .byte $7A,$00,$00,$00,$00,$00,$00,$42
$5085            .byte $6F
$5086  6C 69 76  JMP ($7669) 
$5089  69 61     ADC #$61
$508B            .byte $00,$00,$00,$00,$00,$43
$5091  61 72     ADC ($72,X) 
$5093  61 63     ADC ($63,X) 
$5095  61 73     ADC ($73,X) 
$5097            .byte $00,$00,$00,$00,$00
$509C  56 65     LSR $65,X 
$509E  6E 65 7A  ROR $7A65 
$50A1  75 65     ADC $65,X 
$50A3  6C 61 00  JMP ($0061) 
$50A6            .byte $00,$00
$50A8  51 75     EOR ($75),Y 
$50AA  69 74     ADC #$74
$50AC            .byte $6F,$00,$00,$00,$00,$00,$00,$00
$50B4  45 63     EOR $63 
$50B6  75 61     ADC $61,X 
$50B8            .byte $64,$6F,$72,$00,$00,$00,$00,$00
$50C0  50 61     BVC L_BRS_($5123)_($50C0) BAD
$50C2            .byte $72
$50C3  61 6D     ADC ($6D,X) 
$50C5  61 72     ADC ($72,X) 
$50C7  69 62     ADC #$62
$50C9            .byte $6F,$00,$00,$53
$50CD  75 72     ADC $72,X 
$50CF  69 6E     ADC #$6E
$50D1  61 6D     ADC ($6D,X) 
$50D3            .byte $00,$00,$00,$00,$00,$53
$50D9  61 6E     ADC ($6E,X) 
$50DB            .byte $74
$50DC  69 61     ADC #$61
//------------------------------
L_BRS_($50DE)_($507B) JAM
//------------------------------
$50DE            .byte $67,$6F,$00,$00,$00,$00,$43
$50E5  68        PLA 
$50E6  69 6C     ADC #$6C
$50E8  65 00     ADC $00 
$50EA            .byte $00,$00,$00,$00,$00,$00
$50F0  31 30     AND ($30),Y 
$50F2  36 36     ROL $36,X 
$50F4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$50FC  48        PHA 
$50FD  61 73     ADC ($73,X) 
$50FF            .byte $74
$5100  69 6E     ADC #$6E
//------------------------------
L_JSR_($5102)_($5F3C) JAM
//------------------------------
$5102            .byte $67,$73,$00,$00,$00,$00
$5108  31 32     AND ($32),Y 
$510A  36 35     ROL $35,X 
$510C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5114  45 76     EOR $76 
$5116  65 73     ADC $73 
$5118  68        PLA 
$5119  61 6D     ADC ($6D,X) 
$511B            .byte $00,$00,$00,$00,$00
//------------------------------
L_JMP_($5120)_($5A36) OK
//------------------------------
$5120  31 33     AND ($33),Y 
//------------------------------
L_BRS_($5123)_($50C0) BAD
//------------------------------
$5122  31 34     AND ($34),Y 
$5124            .byte $00,$00,$00,$00,$00,$00,$00,$00
$512C            .byte $42
$512D  61 6E     ADC ($6E,X) 
$512F  6E 6F 63  ROR $636F 
$5132            .byte $6B,$62
$5134  75 72     ADC $72,X 
$5136  6E 00 31  ROR $3100 
$5139            .byte $33,$34
$513B  36 00     ROL $00,X 
$513D            .byte $00,$00,$00,$00,$00,$00,$00,$43
$5145            .byte $72
$5146  65 63     ADC $63 
$5148  79 00 00  ADC $0000,Y 
$514B            .byte $00,$00,$00,$00,$00
$5150  31 33     AND ($33),Y 
$5152  35 36     AND $36,X 
$5154            .byte $00,$00,$00,$00,$00,$00,$00,$00
$515C  50 6F     BVC L_BRS_($51CD)_($515C) JAM
$515E  69 74     ADC #$74
$5160  69 65     ADC #$65
$5162            .byte $72,$73,$00,$00,$00,$00
$5168  31 34     AND ($34),Y 
$516A  30 33     BMI L_BRS_($519F)_($516A) JAM
$516C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5174            .byte $53
$5175  68        PLA 
$5176            .byte $72
$5177  65 77     ADC $77 
$5179            .byte $73,$62
$517B  75 72     ADC $72,X 
$517D  79 00 00  ADC $0000,Y 
$5180  31 34     AND ($34),Y 
$5182  31 35     AND ($35),Y 
$5184            .byte $00,$00,$00,$00,$00,$00,$00,$00
$518C  41 67     EOR ($67,X) 
$518E  69 6E     ADC #$6E
$5190            .byte $63,$6F
$5192  75 72     ADC $72,X 
$5194            .byte $74,$00,$00,$00
$5198  31 34     AND ($34),Y 
$519A  38        SEC 
$519B  35 00     AND $00,X 
//------------------------------
L_BRS_($519F)_($516A) JAM
//------------------------------
$519D            .byte $00,$00,$00,$00,$00,$00,$00,$42
$51A5            .byte $6F,$73,$77,$6F,$72,$74
$51AB  68        PLA 
$51AC            .byte $00,$00,$00,$00
$51B0  31 35     AND ($35),Y 
$51B2  31 33     AND ($33),Y 
$51B4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$51BC  46 6C     LSR $6C 
$51BE            .byte $6F,$64,$64
$51C1  65 6E     ADC $6E 
$51C3            .byte $00,$00,$00,$00,$00
$51C8  31 35     AND ($35),Y 
$51CA            .byte $37
$51CB  31 00     AND ($00),Y 
//------------------------------
L_BRS_($51CD)_($515C) JAM
//------------------------------
$51CD            .byte $00,$00,$00,$00,$00,$00,$00
$51D4  4C 65 70  JMP L_JMP_($7065)_($51D4) JAM
$51D7  61 6E     ADC ($6E,X) 
$51D9            .byte $74,$6F,$00,$00,$00,$00,$00
$51E0  31 30     AND ($30),Y 
$51E2  31 34     AND ($34),Y 
$51E4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$51EC            .byte $43
$51ED  6C 6F 6E  JMP ($6E6F) 
$51F0            .byte $74
$51F1  61 72     ADC ($72,X) 
$51F3  66 00     ROR $00 
$51F5            .byte $6F,$6F,$72
$51F8  31 36     AND ($36),Y 
$51FA  38        SEC 
$51FB  35 00     AND $00,X 
//------------------------------
L_JSR_($5202)_($A915) JAM
L_JSR_($5202)_($E594) JAM
//------------------------------
$51FD            .byte $00,$00,$00,$00,$00,$00,$00,$53
$5205  65 64     ADC $64 
$5207            .byte $67
$5208  65 6D     ADC $6D 
$520A            .byte $6F,$6F,$72,$00,$00,$00
$5210  31 37     AND ($37),Y 
$5212            .byte $34
$5213  36 00     ROL $00,X 
$5215            .byte $00,$00,$00,$00,$00,$00,$00,$43
$521D  75 6C     ADC $6C,X 
$521F  6C 6F 64  JMP ($646F) 
$5222  65 6E     ADC $6E 
$5224            .byte $00,$00,$00,$00
$5228  31 37     AND ($37),Y 
$522A            .byte $37
$522B  35 00     AND $00,X 
$522D            .byte $00,$00,$00,$00,$00,$00,$00
$5234  4C 65 78  JMP L_JMP_($7865)_($5234) JAM
$5237  69 6E     ADC #$6E
$5239            .byte $67,$74,$6F
$523C  6E 00 00  ROR $0000 
$523F            .byte $00
//------------------------------
L_JSR_($5241)_($4CE3) BAD
L_JSR_($5241)_($5348) BAD
//------------------------------
$5240  31 37     AND ($37),Y 
$5242  38        SEC 
$5243  31 00     AND ($00),Y 
$5245            .byte $00,$00,$00,$00,$00,$00,$00
$524C  59 6F 72  EOR $726F,Y 
//------------------------------
L_JSR_($524F)_($5BC9) JAM
L_JSR_($5250)_($4607) JAM
//------------------------------
$524F            .byte $6B,$74,$6F,$77
//------------------------------
L_JSR_($5254)_($4AE5) BAD
//------------------------------
$5253  6E 00 00  ROR $0000 
//------------------------------
L_JSR_($5257)_($5C02) JAM
//------------------------------
$5256            .byte $00,$00
$5258  31 38     AND ($38),Y 
$525A  30 35     BMI L_BRS_($5291)_($525A) JAM
$525C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5264            .byte $54,$72
$5266  61 66     ADC ($66,X) 
$5268  61 6C     ADC ($6C,X) 
$526A            .byte $67
$526B  61 72     ADC ($72,X) 
$526D            .byte $00,$00,$00
$5270  31 38     AND ($38),Y 
$5272  31 35     AND ($35),Y 
$5274            .byte $00,$00,$00,$00,$00,$00,$00,$00
$527C            .byte $57
$527D  61 74     ADC ($74,X) 
$527F  65 72     ADC $72 
$5281  6C 6F 6F  JMP ($6F6F) 
$5284            .byte $00,$00,$00,$00
$5288  31 38     AND ($38),Y 
$528A  31 32     AND ($32),Y 
//------------------------------
L_BRS_($5291)_($525A) JAM
//------------------------------
$528C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5294            .byte $42,$6F,$72,$6F,$64
$5299  69 6E     ADC #$6E
$529B            .byte $6F,$00,$00,$00,$00
$52A0  31 38     AND ($38),Y 
$52A2            .byte $33
$52A3  36 00     ROL $00,X 
$52A5            .byte $00,$00,$00,$00,$00,$00,$00,$53
$52AD  61 6E     ADC ($6E,X) 
$52AF  20 4A 61  JSR L_JSR_($614A)_($52AF) BAD
$52B2            .byte $63
$52B3  69 6E     ADC #$6E
$52B5            .byte $74,$6F,$00
$52B8  31 38     AND ($38),Y 
$52BA  36 33     ROL $33,X 
$52BC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$52C4            .byte $47
$52C5  65 74     ADC $74 
$52C7            .byte $74
$52C8  79 73 62  ADC $6273,Y 
$52CB  75 72     ADC $72,X 
$52CD            .byte $67,$00,$00
$52D0  31 38     AND ($38),Y 
$52D2  35 34     AND $34,X 
$52D4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$52DC            .byte $42
$52DD  61 6C     ADC ($6C,X) 
$52DF  61 63     ADC ($63,X) 
$52E1  6C 61 76  JMP ($7661) 
$52E4  61 00     ADC ($00,X) 
$52E6            .byte $00,$00
$52E8  31 38     AND ($38),Y 
$52EA  30 30     BMI L_BRS_($531C)_($52EA) JAM
$52EC            .byte $F3
$52ED  0E 10 21  ASL $2110 
$52F0            .byte $17
$52F1  FE 3E 01  INC $013E,X 
$52F4  11 00     ORA ($00),Y
$52F6  40        RTI 
//------------------------------
$52F7  CD 62 FE  CMP $FE62 
$52FA  0D 20 F2  ORA $F220
$52FD            .byte $FB
$52FE  C9 00     CMP #$00
$5300            .byte $54
$5301  48        PHA 
$5302  45 20     EOR $20 
$5304            .byte $34,$37
//------------------------------
L_JSR_($5308)_($9FB1) BAD
L_JSR_($5308)_($DC27) BAD
//------------------------------
$5306  20 54 49  JSR L_JSR_($4954)_($5306) JAM
$5309  4D 45 53  EOR $5345 
$530C            .byte $02,$54
$530E  41 42     EOR ($42,X) 
$5310  4C 45 00  JMP $0045
$5313            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($531C)_($52EA) JAM
//------------------------------
$531B            .byte $00,$00,$00,$00,$00
//------------------------------
L_JMP_($5320)_($C58A) OK
L_JMP_($5320)_($FF84) OK
//------------------------------
$5320  51 55     EOR ($55),Y 
$5322  41 44     EOR ($44,X) 
$5324            .byte $52
$5325  41 54     EOR ($54,X) 
$5327  49 43     EOR #$43
$5329            .byte $02
$532A  45 51     EOR $51 
$532C  55 41     EOR $41,X 
$532E            .byte $54
$532F  49 4F     EOR #$4F
$5331  4E 53 00  LSR $0053 
$5334            .byte $00,$00,$00,$00,$00,$00,$00,$00
$533C            .byte $00,$00,$00,$00,$57
$5341  48        PHA 
//------------------------------
L_JMP_($5344)_($C590) BAD
L_JMP_($5344)_($FF8A) BAD
//------------------------------
$5342  59 20 53  EOR $5320,Y 
//------------------------------
L_JSR_($5345)_($5CDE) OK
//------------------------------
$5345  55 4D     EOR $4D,X 
$5347            .byte $53
//------------------------------
L_JSR_($5349)_($5A04) BAD
L_JSR_($5349)_($5A48) BAD
L_JSR_($5349)_($5A97) BAD
//------------------------------
$5348  20 41 52  JSR L_JSR_($5241)_($5348) BAD
$534B  45 02     EOR $02 
$534D  46 55     LSR $55 
$534F  4E 00 00  LSR $0000 
$5352            .byte $00,$00,$00,$00,$00,$00,$00,$00
$535A            .byte $00,$00,$00,$00,$00,$00
$5360  56 45     LSR $45,X 
$5362            .byte $43,$54,$4F,$52,$53
$5367  20 41 4E  JSR L_JSR_($4E41)_($5367) JAM
$536A            .byte $44,$02
$536C  4D 41 54  EOR $5441 
$536F            .byte $52
$5370  49 43     EOR #$43
$5372  45 53     EOR $53 
$5374            .byte $00,$00,$00,$00,$00,$00,$00,$00
$537C            .byte $00,$00,$00,$00
$5380  49 53     EOR #$53
$5382            .byte $4F,$53,$43
$5385  45 4C     EOR $4C 
$5387  45 53     EOR $53 
$5389            .byte $02,$54,$52
$538C  49 41     EOR #$41
$538E  4E 47 4C  LSR $4C47 
$5391  45 53     EOR $53 
$5393            .byte $00,$00,$00,$00,$00,$00,$00,$00
$539B            .byte $00,$00,$00,$00,$00
$53A0  50 59     BVC L_BRS_($53FB)_($53A0) JAM
$53A2            .byte $54
$53A3  48        PHA 
$53A4  41 47     EOR ($47,X) 
$53A6            .byte $4F,$52
$53A8  41 53     EOR ($53,X) 
$53AA            .byte $02,$54
$53AC  48        PHA 
$53AD  45 4F     EOR $4F 
$53AF            .byte $52
$53B0  45 4D     EOR $4D 
$53B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$53BA            .byte $00,$00,$00,$00,$00,$00
$53C0  46 41     LSR $41 
$53C2            .byte $43,$54,$4F,$52,$53,$00,$00,$00
$53CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$53D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$53DA            .byte $00,$00,$00,$00,$00,$00,$54
$53E1  48        PHA 
$53E2  45 20     EOR $20 
$53E4  41 52     EOR ($52,X) 
$53E6  45 41     EOR $41 
$53E8  20 4F 46  JSR L_JSR_($464F)_($53E8) JAM
$53EB            .byte $02
$53EC  41 20     EOR ($20,X) 
$53EE            .byte $43
$53EF  49 52     EOR #$52
$53F1            .byte $43
$53F2  4C 45 00  JMP $0045
//------------------------------
L_BRS_($53FB)_($53A0) JAM
//------------------------------
$53F5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$53FD            .byte $00,$00,$00,$54
$5401  68        PLA 
$5402  65 20     ADC $20 
//------------------------------
L_JSR_($5405)_($9F8B) BAD
L_JSR_($5405)_($DC01) BAD
//------------------------------
$5404  50 65     BVC L_BRS_($546B)_($5404) JAM
$5406            .byte $72
$5407  69 6F     ADC #$6F
$5409            .byte $64
$540A  69 63     ADC #$63
$540C            .byte $02,$54
$540E  61 62     ADC ($62,X) 
$5410  6C 65 00  JMP ($0065) 
$5413            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JMP_($5420)_($5C24) JAM
//------------------------------
$541B            .byte $00,$00,$00,$00,$00,$53
$5421  70 6C     BVS L_BRS_($548F)_($5421) BAD
$5423  69 74     ADC #$74
$5425            .byte $74
$5426  69 6E     ADC #$6E
$5428            .byte $67,$02,$54
$542B  68        PLA 
$542C  65 20     ADC $20 
$542E  41 74     EOR ($74,X) 
$5430            .byte $6F
$5431  6D 00 00  ADC $0000 
$5434            .byte $00,$00,$00,$00,$00,$00,$00,$00
$543C            .byte $00,$00,$00,$00
//------------------------------
L_JMP_($5441)_($4BD0) BAD
L_JSR_($5441)_($C5A9) BAD
L_JSR_($5441)_($FFA3) BAD
//------------------------------
$5440  45 78     EOR $78 
$5442  70 6C     BVS L_BRS_($54B0)_($5442) BAD
$5444            .byte $6F,$73
$5446  69 6F     ADC #$6F
//------------------------------
L_JSR_($5449)_($4B92) BAD
//------------------------------
$5448  6E 73 20  ROR $2073 
$544B  49 02     EOR #$02
$544D  68        PLA 
//------------------------------
L_JMP_($544F)_($5BDB) BAD
//------------------------------
$544E  61 76     ADC ($76,X) 
$5450  65 20     ADC $20 
$5452            .byte $6B
//------------------------------
L_JSR_($5453)_($4BE3) OK
L_JSR_($5453)_($5C8E) OK
L_JSR_($5453)_($C450) OK
L_JSR_($5453)_($FE4A) OK
//------------------------------
$5453  6E 6F 77  ROR $776F 
$5456  6E 00 00  ROR $0000 
$5459            .byte $00,$00,$00,$00,$00,$00,$00
$5460  48        PHA 
$5461            .byte $6F,$77
$5463  20 74 6F  JSR L_JSR_($6F74)_($5463) JAM
$5466  20 62 6C  JSR L_JSR_($6C62)_($5466) JAM
//------------------------------
L_BRS_($546B)_($5404) JAM
//------------------------------
$5469            .byte $6F,$77,$02
$546C  79 6F 75  ADC $756F,Y 
$546F            .byte $72,$73
$5471  65 6C     ADC $6C 
$5473  66 20     ROR $20 
$5475  75 70     ADC $70,X 
$5477            .byte $00,$00,$00,$00,$00,$00,$00,$00
$547F            .byte $00,$54
$5481  68        PLA 
$5482  69 6E     ADC #$6E
$5484            .byte $67,$73
$5486  20 74 6F  JSR L_JSR_($6F74)_($5486) JAM
$5489  20 64 6F  JSR L_JSR_($6F64)_($5489) JAM
$548C            .byte $02,$77
//------------------------------
L_BRS_($548F)_($5421) BAD
//------------------------------
$548E  69 74     ADC #$74
$5490  68        PLA 
$5491  20 54 4E  JSR L_JSR_($4E54)_($5491) JAM
$5494            .byte $54,$00,$00,$00,$00,$00,$00,$00
$549C            .byte $00,$00,$00,$00,$43
$54A1  68        PLA 
$54A2  65 6D     ADC $6D 
$54A4  69 73     ADC #$73
$54A6            .byte $74,$72
$54A8  79 02 6F  ADC $6F02,Y 
$54AB  66 20     ROR $20 
$54AD            .byte $64
//------------------------------
L_BRS_($54B0)_($5442) BAD
//------------------------------
$54AE  79 6E 61  ADC $616E,Y 
$54B1  6D 69 74  ADC $7469 
$54B4  65 00     ADC $00 
$54B6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$54BE            .byte $00,$00
$54C0  46 69     LSR $69 
$54C2            .byte $72,$73,$74
$54C5  20 61 69  JSR L_JSR_($6961)_($54C5) BAD
$54C8            .byte $64,$02
$54CA  66 6F     ROR $6F 
$54CC            .byte $72
$54CD  20 63 68  JSR L_JSR_($6863)_($54CD) JAM
$54D0  65 6D     ADC $6D 
$54D2  69 73     ADC #$73
$54D4            .byte $74,$73,$00,$00,$00,$00,$00,$00
$54DC            .byte $00,$00,$00,$00
$54E0  46 61     LSR $61 
$54E2            .byte $73,$74
$54E4  20 77 61  JSR L_JSR_($6177)_($54E4) BAD
$54E7  79 73 20  ADC $2073,Y 
$54EA            .byte $74,$6F,$02,$6F
$54EE  70 65     BVS L_BRS_($5555)_($54EE) BAD
$54F0  6E 20 64  ROR $6420 
$54F3            .byte $6F,$6F,$72,$73,$00,$00,$00,$00
$54FB            .byte $00,$00,$00,$00,$00,$57
$5501  48        PHA 
$5502  59 20 49  EOR $4920,Y 
$5505            .byte $54
$5506  20 52 41  JSR L_JSR_($4152)_($5506) JAM
$5509  49 4E     EOR #$4E
$550B            .byte $53,$02
$550D  49 4E     EOR #$4E
$550F  20 4D 41  JSR L_JSR_($414D)_($550F) OK
$5512  4E 43 48  LSR $4843 
$5515  45 53     EOR $53 
$5517            .byte $54
$5518  45 52     EOR $52 
$551A            .byte $00,$00,$00,$00,$00,$00,$54
$5521  48        PHA 
$5522  45 20     EOR $20 
$5524            .byte $43
//------------------------------
L_JSR_($5527)_($4625) BAD
//------------------------------
$5525  4C 49 4D  JMP L_JMP_($4D49)_($5525) BAD
$5528  41 54     EOR ($54,X) 
$552A  45 02     EOR $02 
$552C            .byte $4F
$552D  46 20     LSR $20 
$552F            .byte $43
$5530  4C 41 50  JMP L_JMP_($5041)_($5530) OK
$5533  48        PHA 
$5534  41 4D     EOR ($4D,X) 
$5536            .byte $00,$00,$00,$00,$00,$00,$00,$00
$553E            .byte $00,$00,$54
$5541  48        PHA 
$5542  45 20     EOR $20 
$5544  4D 4F 55  EOR $554F 
$5547  4E 54 41  LSR $4154 
$554A  49 4E     EOR #$4E
//------------------------------
L_JSR_($554D)_($43B4) JAM
//------------------------------
$554C            .byte $53,$02,$4F
$554F  46 20     LSR $20 
$5551  50 45     BVC L_BRS_($5598)_($5551) JAM
$5553            .byte $52
//------------------------------
L_BRS_($5555)_($54EE) BAD
//------------------------------
$5554  55 00     EOR $00,X 
$5556            .byte $00,$00,$00,$00,$00,$00,$00,$00
$555E            .byte $00,$00,$54
$5561  48        PHA 
$5562  45 20     EOR $20 
$5564            .byte $44,$4F
$5566  4E 43 41  LSR $4143 
$5569            .byte $53,$54
$556B  45 52     EOR $52 
$556D            .byte $02,$52
$556F  41 49     EOR ($49,X) 
$5571  4E 2D 46  LSR $462D 
$5574            .byte $4F,$52
$5576  45 53     EOR $53 
$5578            .byte $54,$00,$00,$00,$00,$00,$00,$00
$5580            .byte $54
$5581  48        PHA 
$5582  45 20     EOR $20 
$5584  45 58     EOR $58 
$5586  50 4F     BVC L_BRS_($55D7)_($5586) BAD
$5588            .byte $52,$54,$53,$02,$4F
$558D  46 20     LSR $20 
$558F  46 49     LSR $49 
$5591  4A        LSR A 
$5592  49 00     EOR #$00
//------------------------------
L_BRS_($5598)_($5551) JAM
//------------------------------
$5594            .byte $00,$00,$00,$00,$00,$00,$00,$00
$559C            .byte $00,$00,$00,$00
$55A0  41 43     EOR ($43,X) 
$55A2            .byte $54
$55A3  49 56     EOR #$56
$55A5  45 02     EOR $02 
$55A7  56 4F     LSR $4F,X 
$55A9  4C 43 41  JMP L_JMP_($4143)_($55A9) OK
$55AC  4E 4F 45  LSR $454F 
$55AF            .byte $53,$00,$00,$00,$00,$00,$00,$00
$55B7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$55BF            .byte $00
$55C0  50 4F     BVC L_BRS_($5611)_($55C0) BAD
$55C2  50 20     BVC L_BRS_($55E4)_($55C2) OK
$55C4  4D 55 53  EOR $5355 
$55C7  49 43     EOR #$43
$55C9  20 49 4E  JSR L_JSR_($4E49)_($55C9) OK
$55CC            .byte $02
$55CD  41 4E     EOR ($4E,X) 
$55CF            .byte $54
$55D0  41 52     EOR ($52,X) 
$55D2            .byte $43,$54
$55D4  49 43     EOR #$43
//------------------------------
L_BRS_($55D7)_($5586) BAD
//------------------------------
$55D6  41 00     EOR ($00,X) 
$55D8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$55E0            .byte $54
$55E1  48        PHA 
$55E2  45 20     EOR $20 
//------------------------------
L_BRS_($55E4)_($55C2) OK
//------------------------------
$55E4  55 50     EOR $50,X 
$55E6  4C 41 4E  JMP L_JMP_($4E41)_($55E6) JAM
$55E9            .byte $44,$53,$02,$4F
$55ED  46 20     LSR $20 
$55EF            .byte $52
$55F0  55 54     EOR $54,X 
$55F2  4C 41 4E  JMP L_JMP_($4E41)_($55F2) JAM
$55F5            .byte $44,$00,$00,$00,$00,$00,$00,$00
$55FD            .byte $00,$00,$00
$5600  49 6E     EOR #$6E
$5602            .byte $64
$5603  75 73     ADC $73,X 
$5605            .byte $74,$72
$5607  69 61     ADC #$61
$5609  6C 02 52  JMP ($5202) 
$560C  65 76     ADC $76 
$560E            .byte $6F
//------------------------------
L_BRS_($5611)_($55C0) BAD
//------------------------------
$560F  6C 75 74  JMP ($7475) 
$5612  69 6F     ADC #$6F
$5614  6E 00 00  ROR $0000 
$5617            .byte $00,$00,$00,$00,$00,$00,$00,$00
$561F            .byte $00,$54
$5621  68        PLA 
$5622  65 20     ADC $20 
$5624  4E 6F 72  LSR $726F 
$5627  6D 61 6E  ADC $6E61 
$562A            .byte $02,$43,$6F
$562D  6E 71 75  ROR $7571 
$5630  65 73     ADC $73 
$5632            .byte $74,$00,$00,$00,$00,$00,$00,$00
$563A            .byte $00,$00,$00,$00,$00,$00,$54
$5641  68        PLA 
$5642  65 20     ADC $20 
$5644            .byte $57
$5645  61 72     ADC ($72,X) 
$5647            .byte $73
$5648  20 6F 66  JSR L_JSR_($666F)_($5648) JAM
$564B            .byte $02,$74
$564D  68        PLA 
//------------------------------
L_JSR_($564F)_($43D9) BAD
L_JSR_($564F)_($5BEE) BAD
//------------------------------
$564E  65 20     ADC $20 
$5650            .byte $52,$6F,$73
$5653  65 73     ADC $73 
$5655            .byte $00,$00,$00,$00,$00,$00,$00,$00
$565D            .byte $00,$00,$00,$54
$5661  68        PLA 
$5662  65 20     ADC $20 
$5664            .byte $53
$5665  70 61     BVS L_BRS_($56C8)_($5665) JAM
$5667  6E 69 73  ROR $7369 
$566A  68        PLA 
$566B            .byte $02
$566C  41 72     EOR ($72,X) 
$566E  6D 61 64  ADC $6461 
$5671  61 00     ADC ($00,X) 
$5673            .byte $00,$00,$00,$00,$00,$00,$00,$00
$567B            .byte $00,$00,$00,$00,$00,$54
$5681  68        PLA 
$5682  65 20     ADC $20 
$5684  46 69     LSR $69 
$5686            .byte $72,$73,$74,$02,$43,$72
$568C  75 73     ADC $73,X 
$568E  61 64     ADC ($64,X) 
$5690  65 00     ADC $00 
$5692            .byte $00,$00,$00,$00,$00,$00,$00,$00
$569A            .byte $00,$00,$00,$00,$00,$00
$56A0  4D 61 67  EOR $6761 
$56A3  6E 61 20  ROR $2061 
$56A6            .byte $43
$56A7  61 72     ADC ($72,X) 
$56A9            .byte $74
$56AA  61 00     ADC ($00,X) 
$56AC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$56B4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$56BC            .byte $00,$00,$00,$00,$54
$56C1  68        PLA 
$56C2  65 20     ADC $20 
//------------------------------
L_BRS_($56C8)_($5665) JAM
//------------------------------
$56C4            .byte $42,$6F,$73,$74,$6F
$56C9  6E 02 54  ROR $5402 
$56CC  65 61     ADC $61 
$56CE  20 50 61  JSR L_JSR_($6150)_($56CE) JAM
$56D1            .byte $72,$74
$56D3  79 00 00  ADC $0000,Y 
$56D6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$56DE            .byte $00,$00,$54
$56E1  68        PLA 
$56E2  65 20     ADC $20 
$56E4            .byte $42
$56E5  6C 61 63  JMP ($6361) 
$56E8            .byte $6B,$02,$44
$56EB  65 61     ADC $61 
$56ED            .byte $74
$56EE  68        PLA 
$56EF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$56F7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$56FF            .byte $00
$5700  69 20     ADC #$20
$5702  68        PLA 
$5703  61 74     ADC ($74,X) 
$5705  65 02     ADC $02 
$5707  66 69     ROR $69 
$5709            .byte $7A,$7A
$570B  69 6B     ADC #$6B
$570D            .byte $73,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($571B)_($C561) JAM
L_JSR_($571B)_($FF5B) JAM
//------------------------------
$5715            .byte $00,$00,$00,$00,$00,$00,$00,$00
$571D            .byte $00,$00,$00
$5720  69 20     ADC #$20
$5722  68        PLA 
$5723  61 74     ADC ($74,X) 
$5725  65 20     ADC $20 
$5727            .byte $73
$5728  75 6D     ADC $6D,X 
$572A            .byte $73,$00,$00,$00,$00,$00,$00,$00
$5732            .byte $00,$00,$00,$00,$00,$00,$00,$00
$573A            .byte $00,$00,$00,$00,$00,$00,$73,$6B
$5742            .byte $6F,$6F
$5744  6C 20 72  JMP ($7220) 
$5747            .byte $6F,$6F
$5749  6C 73 02  JMP ($0273) 
$574C            .byte $6F
$574D  20 6B 00  JSR $006B
$5750            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5758            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5760  69 20     ADC #$20
$5762  68        PLA 
$5763  61 74     ADC ($74,X) 
$5765  65 20     ADC $20 
$5767            .byte $73,$6B,$6F,$6F
$576B  6C 00 00  JMP ($0000) 
$576E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5776            .byte $00,$00,$00,$00,$00,$00,$00,$00
$577E            .byte $00,$00,$73
$5781  70 65     BVS L_BRS_($57E8)_($5781) BAD
$5783  6C 69 6E  JMP ($6E69) 
$5786            .byte $67
$5787  20 69 7A  JSR L_JSR_($7A69)_($5787) JAM
$578A            .byte $02,$62,$6F
$578D  61 72     ADC ($72,X) 
$578F  69 6E     ADC #$6E
$5791            .byte $67,$00,$00,$00,$00,$00,$00,$00
$5799            .byte $00,$00,$00,$00,$00,$00,$00
$57A0  69 20     ADC #$20
$57A2  6C 6F 76  JMP ($766F) 
$57A5  65 02     ADC $02 
$57A7            .byte $57
$57A8  48        PHA 
$57A9  45 45     EOR $45 
$57AB  4C 49 45  JMP L_JMP_($4549)_($57AB) JAM
$57AE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$57B6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$57BE            .byte $00,$00,$53,$4B
$57C2  59 52 41  EOR $4152,Y 
$57C5  4E 47 45  LSR $4547 
$57C8            .byte $52,$02
$57CA  69 73     ADC #$73
$57CC  20 67 72  JSR L_JSR_($7267)_($57CC) JAM
$57CF  61 74     ADC ($74,X) 
$57D1  65 00     ADC $00 
$57D3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$57DB            .byte $00,$00,$00,$00,$00,$73,$6B,$6F
$57E3            .byte $6F
$57E4  6C 20 64  JMP ($6420) 
//------------------------------
L_BRS_($57E8)_($5781) BAD
//------------------------------
$57E7  69 6E     ADC #$6E
$57E9  6E 65 72  ROR $7265 
$57EC            .byte $73,$02
$57EE  61 72     ADC ($72,X) 
$57F0  65 20     ADC $20 
$57F2            .byte $6F,$72,$72
$57F5  69 62     ADC #$62
$57F7  6C 65 00  JMP ($0065) 
$57FA            .byte $00,$00,$00,$00,$00,$00
$5800  06 06     ASL $06 
$5802  06 06     ASL $06 
$5804  06 06     ASL $06 
$5806  06 06     ASL $06 
$5808  06 06     ASL $06 
$580A  06 06     ASL $06 
$580C  06 06     ASL $06 
$580E  06 06     ASL $06 
$5810  06 06     ASL $06 
$5812  06 06     ASL $06 
$5814  06 06     ASL $06 
$5816  06 06     ASL $06 
$5818            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5820  38        SEC 
$5821  40        RTI 
//------------------------------
$5822  41 32     EOR ($32,X) 
$5824  0A        ASL A 
$5825  0A        ASL A 
$5826  71 00     ADC ($00),Y 
$5828            .byte $00,$00
$582A  CC 12 12  CPY $1212 
$582D            .byte $12
$582E  D8        CLD 
$582F            .byte $00,$00,$00,$A3,$D4,$87
$5835  84 83     STY $83 
$5837            .byte $00,$00,$00,$00,$80,$9E,$00,$00
$583F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5847            .byte $00,$00,$00,$00,$00,$00,$00,$00
$584F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5857            .byte $00
$5858  30 48     BMI L_BRS_($58A2)_($5858) OK
$585A  48        PHA 
$585B  58        CLI 
$585C  68        PLA 
$585D  48        PHA 
$585E  30 00     BMI L_BRS_($5860)_($585E) OK
//------------------------------
L_BRS_($5860)_($585E) OK
//------------------------------
$5860  40        RTI 
//------------------------------
$5861            .byte $42
$5862  40        RTI 
//------------------------------
$5863            .byte $42,$42,$42,$7A,$00,$00,$00,$A3
$586B            .byte $D4,$97
$586D  94 93     STY $93,X 
$586F            .byte $00,$00,$00,$1C
$5873  A0 98     LDY #$98
$5875            .byte $04
$5876  38        SEC 
$5877            .byte $00,$00,$00,$00,$00
$587C  1E 00 00  ASL $0000,X 
$587F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5887            .byte $00,$00,$00,$00,$00,$00,$00,$00
$588F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5897            .byte $00
$5898  30 48     BMI L_BRS_($58E2)_($5898) JAM
$589A  48        PHA 
$589B  58        CLI 
$589C  68        PLA 
$589D  48        PHA 
$589E  30 00     BMI L_BRS_($58A0)_($589E) OK
//------------------------------
L_BRS_($58A0)_($589E) OK
//------------------------------
$58A0  48        PHA 
$58A1  4A        LSR A 
//------------------------------
L_BRS_($58A2)_($5858) OK
//------------------------------
$58A2  48        PHA 
$58A3            .byte $7A
$58A4  4A        LSR A 
$58A5  4A        LSR A 
$58A6  4A        LSR A 
$58A7            .byte $00,$07
$58A9  08        PHP 
$58AA  08        PHP 
$58AB  06 E1     ASL $E1 
$58AD  01 0E     ORA ($0E,X)
$58AF            .byte $00,$00,$00
$58B2  38        SEC 
$58B3  40        RTI 
//------------------------------
$58B4  40        RTI 
//------------------------------
$58B5  40        RTI 
//------------------------------
$58B6  38        SEC 
$58B7            .byte $00,$00,$00,$00,$00
$58BC  1E 00 00  ASL $0000,X 
$58BF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$58C7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$58CF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$58D7            .byte $00
$58D8  30 48     BMI L_BRS_($5922)_($58D8) JAM
$58DA  48        PHA 
$58DB  58        CLI 
$58DC  68        PLA 
$58DD  48        PHA 
$58DE  30 00     BMI L_BRS_($58E0)_($58DE) OK
//------------------------------
L_BRS_($58E0)_($58DE) OK
//------------------------------
$58E0  06 02     ASL $02 
//------------------------------
L_BRS_($58E2)_($5898) JAM
//------------------------------
$58E2            .byte $00
$58E3  08        PHP 
$58E4            .byte $02,$00,$2F,$02,$00,$32,$02,$00
$58EC  4E 02 00  LSR $0002 
$58EF  2D 08 00  AND $0008 
$58F2            .byte $32
$58F3  08        PHP 
$58F4            .byte $00,$37
$58F6  08        PHP 
$58F7            .byte $00,$3C
$58F9  08        PHP 
$58FA            .byte $00
$58FB  41 08     EOR ($08,X) 
$58FD            .byte $00,$1A
$58FF  0E 00 1C  ASL $1C00 
$5902  0E 00 1E  ASL $1E00 
$5905  0E 00 41  ASL $4100 
$5908  0E 00 43  ASL $4300 
$590B  0E 00 00  ASL $0000 
$590E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5916            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JMP_($5920)_($5C29) JAM
L_BRS_($5922)_($58D8) JAM
//------------------------------
$591E            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($5928)_($C441) JAM
L_JSR_($5928)_($C461) JAM
L_JSR_($5928)_($FE3B) JAM
L_JSR_($5928)_($FE5B) JAM
//------------------------------
$5926            .byte $03,$03,$00,$00,$00,$00,$00,$00
$592E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$5936            .byte $00,$00,$0C,$0C,$0C
$593B  06 06     ASL $06 
$593D  06 03     ASL $03 
$593F            .byte $E3,$00,$00,$00,$00
$5944  06 06     ASL $06 
$5946  06 03     ASL $03 
$5948            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($5953)_($5A58) JAM
//------------------------------
$5950            .byte $00,$00,$00,$00,$00,$00,$00,$1C
$5958            .byte $00,$00,$00,$00,$00
$595D  38        SEC 
$595E  6C CC 03  JMP ($03CC) 
$5961            .byte $03
$5962  01 01     ORA ($01,X)
$5964  0D 1C 30  ORA $301C
//------------------------------
L_BRS_($5968)_($5976) BAD
//------------------------------
$5967  20 00 00  JSR $0000
$596A  81 8B     STA ($8B,X) 
//------------------------------
L_BRS_($596C)_($598D) JAM
//------------------------------
$596C            .byte $9B,$F3
$596E  E1 F8     SBC ($F8,X) 
$5970  01 E3     ORA ($E3,X)
$5972            .byte $B3,$1F
$5974  49 18     EOR #$18
$5976  90 F0     BCC L_BRS_($5968)_($5976) BAD
$5978            .byte $B3
$5979  19 49 19  ORA $1949,Y
$597C  91 F0     STA ($F0),Y 
$597E  60        RTS 
//------------------------------
$597F            .byte $00,$03,$83
$5982  81 81     STA ($81,X) 
$5984            .byte $8F
$5985  19 19 18  ORA $1819,Y
$5988  01 0F     ORA ($0F,X)
$598A  99 99 98  STA $9899,Y 
$598D  90 DD     BCC L_BRS_($596C)_($598D) JAM
$598F  C6 1E     DEC $1E 
$5991  A2 82     LDX #$82
$5993            .byte $74
$5994  C6 C3     DEC $C3 
$5996  E1 01     SBC ($01,X) 
$5998  D8        CLD 
$5999  F0 60     BEQ L_BRS_($59FB)_($5999) BAD
$599B  66 3C     ROR $3C 
$599D  98        TYA 
$599E  C0 80     CPY #$80
$59A0  38        SEC 
$59A1  1E 03 06  ASL $0603,X 
$59A4            .byte $1C
$59A5  70 20     BVS L_BRS_($59C7)_($59A5) JAM
$59A7            .byte $00
$59A8  CE 63 60  DEC $6063 
//------------------------------
L_BRS_($59AC)_($59E5) JAM
//------------------------------
$59AB            .byte $00,$00,$00,$00,$00
$59B0  60        RTS 
//------------------------------
$59B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$59B9            .byte $00,$00,$00,$00,$00,$00,$00
$59C0  10 1D     BPL L_BRS_($59DF)_($59C0) JAM
$59C2  06 00     ASL $00 
//------------------------------
L_BRS_($59C7)_($59A5) JAM
//------------------------------
$59C4            .byte $00,$00,$00,$00
$59C8  C0 E0     CPY #$E0
$59CA            .byte $00,$00,$00,$00,$00,$00
$59D0  01 03     ORA ($03,X)
$59D2  06 0C     ASL $0C 
$59D4  08        PHP 
$59D5            .byte $00,$00,$00,$80,$00,$00,$00,$00
//------------------------------
L_BRS_($59DF)_($59C0) JAM
//------------------------------
$59DD            .byte $00,$00,$00
$59E0  21 00     AND ($00,X) 
$59E2            .byte $1B
$59E3  06 08     ASL $08 
$59E5  70 C5     BVS L_BRS_($59AC)_($59E5) JAM
$59E7  CD E8 B0  CMP $B0E8 
$59EA  E5 CD     SBC $CD 
$59EC  E8        INX 
$59ED  B6 E1     LDX $E1,Y 
$59EF  CC 68 B8  CPY $B868 
$59F2  28        PLP 
$59F3            .byte $FB
$59F4  CD E8 B5  CMP $B5E8 
$59F7  C1 10     CMP ($10,X) 
//------------------------------
L_BRS_($59FB)_($5999) BAD
//------------------------------
$59F9  EC 21 1B  CPX $1B21 
$59FC  61 36     ADC ($36,X) 
$59FE  7E C9 57  ROR $57C9,X 
$5A01  48        PHA 
$5A02  41 54     EOR ($54,X) 
$5A04  20 49 53  JSR L_JSR_($5349)_($5A04) BAD
$5A07  20 31 32  JSR L_JSR_($3231)_($5A07) BAD
$5A0A  20 78 20  JSR L_JSR_($2078)_($5A0A) BAD
$5A0D            .byte $33,$34,$3F,$03
$5A11  18        CLC 
$5A12  49 74     EOR #$74
$5A14            .byte $27,$73
$5A16  20 31 32  JSR L_JSR_($3231)_($5A16) BAD
$5A19            .byte $33,$34,$03,$57
$5A1D  48        PHA 
$5A1E  41 54     EOR ($54,X) 
$5A20  20 45 4C  JSR L_JSR_($4C45)_($5A20) JAM
$5A23  45 4D     EOR $4D 
$5A25  45 4E     EOR $4E 
$5A27            .byte $54
$5A28  20 48 41  JSR L_JSR_($4148)_($5A28) BAD
$5A2B            .byte $53
$5A2C  20 54 48  JSR L_JSR_($4854)_($5A2C) BAD
$5A2F  45 20     EOR $20 
$5A31            .byte $53
$5A32  59 4D 42  EOR $424D,Y 
$5A35            .byte $4F
$5A36  4C 20 51  JMP L_JMP_($5120)_($5A36) OK
$5A39            .byte $3F,$03
$5A3B  18        CLC 
$5A3C  49 74     EOR #$74
$5A3E  20 69 73  JSR L_JSR_($7369)_($5A3E) JAM
$5A41  20 51 03  JSR $0351
$5A44            .byte $57
$5A45  48        PHA 
$5A46  41 54     EOR ($54,X) 
$5A48  20 49 53  JSR L_JSR_($5349)_($5A48) BAD
$5A4B  20 54 48  JSR L_JSR_($4854)_($5A4B) BAD
$5A4E  45 20     EOR $20 
$5A50            .byte $43
$5A51  48        PHA 
$5A52  45 4D     EOR $4D 
$5A54  49 43     EOR #$43
$5A56  41 4C     EOR ($4C,X) 
$5A58  20 53 59  JSR L_JSR_($5953)_($5A58) JAM
$5A5B  4D 42 4F  EOR $4F42 
$5A5E  4C 20 46  JMP L_JMP_($4620)_($5A5E) OK
$5A61            .byte $4F,$52
$5A63  20 51 3F  JSR L_JSR_($3F51)_($5A63) JAM
$5A66            .byte $03,$57
$5A68  48        PHA 
$5A69  41 54     EOR ($54,X) 
$5A6B            .byte $27,$53
$5A6D  20 54 48  JSR L_JSR_($4854)_($5A6D) BAD
$5A70  45 20     EOR $20 
$5A72            .byte $43
$5A73  41 50     EOR ($50,X) 
$5A75  49 54     EOR #$54
$5A77  41 4C     EOR ($4C,X) 
$5A79  20 4F 46  JSR L_JSR_($464F)_($5A79) JAM
$5A7C  20 51 3F  JSR L_JSR_($3F51)_($5A7C) JAM
$5A7F            .byte $03,$57
$5A81  48        PHA 
$5A82  49 43     EOR #$43
$5A84  48        PHA 
$5A85  20 43 4F  JSR L_JSR_($4F43)_($5A85) OK
$5A88  55 4E     EOR $4E,X 
$5A8A            .byte $54,$52
$5A8C  59 27 53  EOR $5327,Y 
$5A8F  20 43 41  JSR L_JSR_($4143)_($5A8F) OK
$5A92  50 49     BVC L_BRS_($5ADD)_($5A92) BAD
$5A94            .byte $54
$5A95  41 4C     EOR ($4C,X) 
$5A97  20 49 53  JSR L_JSR_($5349)_($5A97) BAD
$5A9A  20 51 3F  JSR L_JSR_($3F51)_($5A9A) JAM
$5A9D            .byte $03,$57
$5A9F  48        PHA 
$5AA0  45 4E     EOR $4E 
$5AA2  20 57 41  JSR L_JSR_($4157)_($5AA2) BAD
$5AA5            .byte $53
$5AA6  20 54 48  JSR L_JSR_($4854)_($5AA6) BAD
$5AA9  45 20     EOR $20 
$5AAB            .byte $42
$5AAC  41 54     EOR ($54,X) 
$5AAE            .byte $54
$5AAF  4C 45 20  JMP L_JMP_($2045)_($5AAF) OK
$5AB2            .byte $4F
$5AB3  46 20     LSR $20 
$5AB5  51 3F     EOR ($3F),Y 
$5AB7            .byte $03,$57
$5AB9  48        PHA 
$5ABA  49 43     EOR #$43
$5ABC  48        PHA 
$5ABD  20 42 41  JSR L_JSR_($4142)_($5ABD) JAM
$5AC0            .byte $54,$54
$5AC2  4C 45 20  JMP L_JMP_($2045)_($5AC2) OK
$5AC5            .byte $4F,$43,$43
$5AC8  55 52     EOR $52,X 
$5ACA            .byte $52
$5ACB  45 44     EOR $44 
$5ACD  20 49 4E  JSR L_JSR_($4E49)_($5ACD) OK
$5AD0  20 51 3F  JSR L_JSR_($3F51)_($5AD0) JAM
$5AD3            .byte $03
$5AD4  18        CLC 
$5AD5  49 74     EOR #$74
$5AD7  20 77 61  JSR L_JSR_($6177)_($5AD7) BAD
$5ADA            .byte $73
//------------------------------
L_BRS_($5ADD)_($5A92) BAD
//------------------------------
$5ADB  20 69 6E  JSR L_JSR_($6E69)_($5ADB) BAD
$5ADE  20 51 03  JSR $0351
$5AE1  18        CLC 
$5AE2  49 74     EOR #$74
$5AE4  20 77 61  JSR L_JSR_($6177)_($5AE4) BAD
$5AE7            .byte $73
$5AE8  20 74 68  JSR L_JSR_($6874)_($5AE8) JAM
$5AEB  65 20     ADC $20 
$5AED            .byte $42
$5AEE  41 54     EOR ($54,X) 
$5AF0            .byte $54
$5AF1  4C 45 20  JMP L_JMP_($2045)_($5AF1) OK
$5AF4            .byte $4F
$5AF5  46 20     LSR $20 
$5AF7  51 03     EOR ($03),Y 
$5AF9  18        CLC 
$5AFA  10 20     BPL L_BRS_($5B1C)_($5AFA) OK
$5AFC  68        PLA 
$5AFD  69 74     ADC #$74
$5AFF  20 6D 65  JSR L_JSR_($656D)_($5AFF) BAD
$5B02            .byte $03
$5B03  18        CLC 
$5B04  10 20     BPL L_BRS_($5B26)_($5B04) JAM
$5B06  69 73     ADC #$73
$5B08  20 6E 6F  JSR L_JSR_($6F6E)_($5B08) JAM
$5B0B            .byte $74
$5B0C  20 68 65  JSR L_JSR_($6568)_($5B0C) OK
$5B0F            .byte $72
$5B10  65 03     ADC $03 
$5B12  18        CLC 
$5B13  10 20     BPL L_BRS_($5B35)_($5B13) BAD
$5B15            .byte $77,$72,$6F,$74
$5B19  65 20     ADC $20 
$5B1B            .byte $6F
//------------------------------
L_BRS_($5B1C)_($5AFA) OK
//------------------------------
$5B1C  6E 20 74  ROR $7420 
$5B1F  68        PLA 
$5B20  65 20     ADC $20 
$5B22            .byte $62
$5B23  6C 61 63  JMP ($6361) 
//------------------------------
L_BRS_($5B26)_($5B04) JAM
//------------------------------
$5B26            .byte $6B,$62,$6F
$5B29  61 72     ADC ($72,X) 
$5B2B            .byte $64,$03,$57
$5B2E  48        PHA 
$5B2F  41 54     EOR ($54,X) 
$5B31  20 48 41  JSR L_JSR_($4148)_($5B31) BAD
//------------------------------
L_BRS_($5B35)_($5B13) BAD
//------------------------------
$5B34  50 50     BVC L_BRS_($5B86)_($5B34) BAD
$5B36  45 4E     EOR $4E 
$5B38  45 44     EOR $44 
$5B3A  20 49 4E  JSR L_JSR_($4E49)_($5B3A) OK
$5B3D  20 54 48  JSR L_JSR_($4854)_($5B3D) BAD
$5B40  45 20     EOR $20 
$5B42  59 45 41  EOR $4145,Y 
$5B45            .byte $52
$5B46  20 54 48  JSR L_JSR_($4854)_($5B46) BAD
$5B49  41 54     EOR ($54,X) 
$5B4B  20 49 20  JSR L_JSR_($2049)_($5B4B) OK
$5B4E            .byte $57
$5B4F  41 53     EOR ($53,X) 
$5B51  20 42 4F  JSR L_JSR_($4F42)_($5B51) BAD
$5B54            .byte $52
$5B55  4E 03 65  LSR $6503 
$5B58            .byte $03,$52
$5B5A  49 47     EOR #$47
$5B5C  48        PHA 
$5B5D            .byte $54
$5B5E  21 20     AND ($20,X) 
$5B60            .byte $53
$5B61  49 54     EOR #$54
$5B63  20 44 4F  JSR L_JSR_($4F44)_($5B63) BAD
$5B66            .byte $57
$5B67  4E 20 4D  LSR $4D20 
$5B6A  59 20 4C  EOR $4C20,Y 
$5B6D  49 54     EOR #$54
$5B6F            .byte $54
$5B70  4C 45 20  JMP L_JMP_($2045)_($5B70) OK
$5B73            .byte $43
$5B74  48        PHA 
$5B75  45 52     EOR $52 
$5B77  55 42     EOR $42,X 
$5B79            .byte $53,$03,$43,$4F
$5B7D  4D 45 20  EOR $2045 
$5B80            .byte $4F
$5B81  4E 20 43  LSR $4320 
$5B84  48        PHA 
//------------------------------
L_BRS_($5B86)_($5B34) BAD
//------------------------------
$5B85  41 50     EOR ($50,X) 
$5B87            .byte $53
$5B88  20 2D 20  JSR L_JSR_($202D)_($5B88) OK
$5B8B            .byte $53
$5B8C  45 54     EOR $54 
$5B8E            .byte $54
$5B8F  4C 45 20  JMP L_JMP_($2045)_($5B8F) OK
$5B92            .byte $44,$4F,$57
$5B95  4E 03 42  LSR $4203 
$5B98  45 20     EOR $20 
$5B9A  51 55     EOR ($55),Y 
$5B9C  49 45     EOR #$45
$5B9E            .byte $54
$5B9F  20 41 4E  JSR L_JSR_($4E41)_($5B9F) JAM
$5BA2            .byte $44
$5BA3  20 53 45  JSR L_JSR_($4553)_($5BA3) JAM
$5BA6  41 54     EOR ($54,X) 
$5BA8  45 44     EOR $44 
$5BAA  20 59 4F  JSR L_JSR_($4F59)_($5BAA) OK
$5BAD  55 20     EOR $20,X 
$5BAF  4E 41 53  LSR $5341 
$5BB2            .byte $54
$5BB3  59 20 4C  EOR $4C20,Y 
$5BB6  49 54     EOR #$54
$5BB8            .byte $54
$5BB9  4C 45 02  JMP $0245
$5BBC            .byte $42,$4F
$5BBE  59 53 03  EOR $0353,Y 
$5BC1            .byte $53
$5BC2  49 4C     EOR #$4C
$5BC4  45 4E     EOR $4E 
$5BC6            .byte $43
$5BC7  45 21     EOR $21 
$5BC9  20 4F 52  JSR L_JSR_($524F)_($5BC9) JAM
$5BCC  20 49 27  JSR L_JSR_($2749)_($5BCC) OK
$5BCF  4C 4C 20  JMP L_JMP_($204C)_($5BCF) OK
$5BD2            .byte $43
$5BD3  41 4E     EOR ($4E,X) 
$5BD5  45 20     EOR $20 
$5BD7            .byte $54
$5BD8  48        PHA 
$5BD9  45 20     EOR $20 
$5BDB  4C 4F 54  JMP L_JMP_($544F)_($5BDB) BAD
$5BDE  20 4F 46  JSR L_JSR_($464F)_($5BDE) JAM
$5BE1  20 59 4F  JSR L_JSR_($4F59)_($5BE1) OK
$5BE4  55 03     EOR $03,X 
$5BE6  59 4F 55  EOR $554F,Y 
$5BE9  20 48 41  JSR L_JSR_($4148)_($5BE9) BAD
$5BEC  56 45     LSR $45,X 
$5BEE  20 4F 56  JSR L_JSR_($564F)_($5BEE) BAD
$5BF1  45 52     EOR $52 
$5BF3  20 31 30  JSR L_JSR_($3031)_($5BF3) BAD
$5BF6  30 30     BMI L_BRS_($5C28)_($5BF6) BAD
$5BF8  30 20     BMI L_BRS_($5C1A)_($5BF8) JAM
$5BFA  4C 49 4E  JMP L_JMP_($4E49)_($5BFA) OK
$5BFD  45 53     EOR $53 
$5BFF  20 54 4F  JSR L_JSR_($4F54)_($5BFF) BAD
$5C02  20 57 52  JSR L_JSR_($5257)_($5C02) JAM
$5C05  49 54     EOR #$54
$5C07  45 20     EOR $20 
$5C09  10 2E     BPL L_BRS_($5C39)_($5C09) JAM
$5C0B  20 44 4F  JSR L_JSR_($4F44)_($5C0B) BAD
$5C0E  4E 27 54  LSR $5427 
$5C11  20 43 4F  JSR L_JSR_($4F43)_($5C11) OK
$5C14  4D 45 20  EOR $2045 
$5C17            .byte $42
$5C18  41 43     EOR ($43,X) 
//------------------------------
L_BRS_($5C1A)_($5BF8) JAM
//------------------------------
$5C1A            .byte $4B
$5C1B  20 54 4F  JSR L_JSR_($4F54)_($5C1B) BAD
$5C1E  20 53 43  JSR L_JSR_($4353)_($5C1E) BAD
$5C21  48        PHA 
$5C22            .byte $4F,$4F
$5C24  4C 20 54  JMP L_JMP_($5420)_($5C24) JAM
//------------------------------
L_BRS_($5C28)_($5BF6) BAD
//------------------------------
$5C27  49 4C     EOR #$4C
$5C29  4C 20 59  JMP L_JMP_($5920)_($5C29) JAM
$5C2C            .byte $4F
$5C2D  55 20     EOR $20,X 
$5C2F  48        PHA 
$5C30  41 56     EOR ($56,X) 
$5C32  45 20     EOR $20 
$5C34            .byte $44,$4F
$5C36  4E 45 20  LSR $2045 
//------------------------------
L_BRS_($5C39)_($5C09) JAM
//------------------------------
$5C39            .byte $54
$5C3A  48        PHA 
$5C3B  45 4D     EOR $4D 
$5C3D  20 41 4C  JSR L_JSR_($4C41)_($5C3D) JAM
$5C40  4C 2E 20  JMP L_JMP_($202E)_($5C40) OK
$5C43  2E 20 2E  ROL $2E20 
$5C46  20 2E 50  JSR L_JSR_($502E)_($5C46) JAM
$5C49            .byte $52
$5C4A  45 53     EOR $53 
$5C4C            .byte $53
$5C4D  20 41 20  JSR L_JSR_($2041)_($5C4D) BAD
$5C50            .byte $4B
$5C51  45 59     EOR $59 
$5C53  20 54 4F  JSR L_JSR_($4F54)_($5C53) BAD
$5C56  20 50 4C  JSR L_JSR_($4C50)_($5C56) JAM
$5C59  41 59     EOR ($59,X) 
$5C5B  20 41 47  JSR L_JSR_($4741)_($5C5B) BAD
$5C5E  41 49     EOR ($49,X) 
$5C60  4E 03 54  LSR $5403 
$5C63  55 52     EOR $52,X 
$5C65  4E 20 54  LSR $5420 
$5C68            .byte $4F
$5C69  20 50 41  JSR L_JSR_($4150)_($5C69) OK
$5C6C            .byte $47
$5C6D  45 20     EOR $20 
$5C6F  31 32     AND ($32),Y 
$5C71            .byte $33
$5C72  20 4F 46  JSR L_JSR_($464F)_($5C72) JAM
$5C75  20 59 4F  JSR L_JSR_($4F59)_($5C75) OK
$5C78  55 52     EOR $52,X 
$5C7A  20 42 4F  JSR L_JSR_($4F42)_($5C7A) BAD
$5C7D            .byte $4F,$4B,$53
$5C80  2C 42 45  BIT $4542 
$5C83  20 53 49  JSR L_JSR_($4953)_($5C83) BAD
$5C86  4C 45 4E  JMP L_JMP_($4E45)_($5C86) OK
$5C89            .byte $54
$5C8A  20 41 4E  JSR L_JSR_($4E41)_($5C8A) JAM
$5C8D            .byte $44
$5C8E  20 53 54  JSR L_JSR_($5453)_($5C8E) OK
$5C91  41 52     EOR ($52,X) 
$5C93            .byte $54
$5C94  20 52 45  JSR L_JSR_($4552)_($5C94) JAM
$5C97  41 44     EOR ($44,X) 
$5C99  49 4E     EOR #$4E
$5C9B            .byte $47,$03
$5C9D  41 4E     EOR ($4E,X) 
$5C9F            .byte $53,$57
$5CA1  45 52     EOR $52 
$5CA3  20 54 48  JSR L_JSR_($4854)_($5CA3) BAD
$5CA6  45 20     EOR $20 
$5CA8  51 55     EOR ($55),Y 
$5CAA  45 53     EOR $53 
$5CAC            .byte $54
$5CAD  49 4F     EOR #$4F
$5CAF  4E 53 20  LSR $2053 
$5CB2            .byte $4F
$5CB3  4E 20 50  LSR $5020 
$5CB6  41 47     EOR ($47,X) 
$5CB8  45 20     EOR $20 
$5CBA  31 32     AND ($32),Y 
$5CBC            .byte $33
$5CBD  20 4F 46  JSR L_JSR_($464F)_($5CBD) JAM
$5CC0  20 59 4F  JSR L_JSR_($4F59)_($5CC0) OK
$5CC3  55 52     EOR $52,X 
$5CC5  20 4C 4F  JSR L_JSR_($4F4C)_($5CC5) OK
$5CC8  56 45     LSR $45,X 
$5CCA  4C 59 20  JMP L_JMP_($2059)_($5CCA) BAD
$5CCD            .byte $54
$5CCE  45 58     EOR $58 
$5CD0            .byte $54,$42,$4F,$4F,$4B,$03,$57,$52
$5CD8  49 54     EOR #$54
$5CDA  45 20     EOR $20 
$5CDC  41 4E     EOR ($4E,X) 
$5CDE  20 45 53  JSR L_JSR_($5345)_($5CDE) OK
$5CE1            .byte $53
$5CE2  41 59     EOR ($59,X) 
$5CE4  20 57 49  JSR L_JSR_($4957)_($5CE4) JAM
$5CE7            .byte $54
$5CE8  48        PHA 
$5CE9  20 54 48  JSR L_JSR_($4854)_($5CE9) BAD
$5CEC  49 53     EOR #$53
$5CEE  20 54 49  JSR L_JSR_($4954)_($5CEE) JAM
$5CF1            .byte $54
$5CF2  4C 45 03  JMP $0345
$5CF5  20 20 20  JSR $2020
$5CF8  20 20 20  JSR $2020
$5CFB  20 20 20  JSR $2020
$5CFE  20 20 F6  JSR L_JSR_($F620)_($5CFE) BAD
$5D01            .byte $E2,$E7,$F7
$5D04  EE EA F8  INC $F8EA 
$5D07  E0 F7     CPX #$F7
//------------------------------
L_BRS_($5D09)_($5D21) OK
//------------------------------
$5D09  ED E4 F9  SBC $F9E4 
$5D0C            .byte $F2
$5D0D  F1 FA     SBC ($FA),Y 
$5D0F  EC FB E8  CPX $E8FB 
$5D12            .byte $EB,$F8,$FF
$5D15  E9 EF     SBC #$EF
$5D17            .byte $FA
$5D18  E1 FD     SBC ($FD,X) 
$5D1A            .byte $F2,$E3
$5D1C  E5 F6     SBC $F6 
$5D1E  ED E9 F9  SBC $F9E9 
$5D21  F0 E6     BEQ L_BRS_($5D09)_($5D21) OK
$5D23            .byte $EB,$FB
$5D25  EA        NOP 
$5D26  F1 F7     SBC ($F7),Y 
$5D28  E0 F6     CPX #$F6
$5D2A            .byte $FF
$5D2B  EE F2 FA  INC $FAF2 
$5D2E  E5 E7     SBC $E7 
$5D30            .byte $F8,$E7
$5D32  E8        INX 
$5D33            .byte $FA
$5D34  FE F1 F2  INC $F2F1,X 
$5D37            .byte $F7
$5D38  E1 FE     SBC ($FE,X) 
$5D3A            .byte $E2
$5D3B  E6 F9     INC $F9 
$5D3D  ED EB EF  SBC $EFEB 
$5D40  C5 3E     CMP $3E 
$5D42  06 0E     ASL $0E 
$5D44  08        PHP 
$5D45  EE 10 D3  INC $D310 
$5D48            .byte $22,$22,$22,$22,$14,$14,$14,$14
$5D50            .byte $14,$14,$14,$14,$22,$22,$22,$22
$5D58  01 01     ORA ($01,X)
$5D5A  01 01     ORA ($01,X)
$5D5C  01 01     ORA ($01,X)
$5D5E  01 01     ORA ($01,X)
$5D60            .byte $22,$22,$22,$22
$5D64  05 05     ORA $05
$5D66  05 05     ORA $05
$5D68  05 05     ORA $05
$5D6A  05 05     ORA $05
$5D6C            .byte $22,$22,$22,$22,$22,$22,$22,$22
$5D74            .byte $14,$14,$14,$14,$14,$14,$14,$14
$5D7C            .byte $22,$22,$22,$22
$5D80  01 01     ORA ($01,X)
$5D82  01 01     ORA ($01,X)
$5D84  01 01     ORA ($01,X)
$5D86  01 01     ORA ($01,X)
$5D88            .byte $22,$22,$22,$22
$5D8C  05 05     ORA $05
$5D8E  05 05     ORA $05
$5D90  05 05     ORA $05
$5D92  05 05     ORA $05
$5D94            .byte $22,$22,$22,$22,$22,$22,$22,$22
$5D9C            .byte $14,$14,$14,$14,$14,$14,$14,$14
$5DA4            .byte $22,$22,$22,$22
$5DA8  01 01     ORA ($01,X)
$5DAA  01 01     ORA ($01,X)
$5DAC  01 01     ORA ($01,X)
$5DAE  01 01     ORA ($01,X)
$5DB0            .byte $22,$22,$22,$22
$5DB4  05 05     ORA $05
$5DB6  05 05     ORA $05
$5DB8  05 05     ORA $05
$5DBA  05 05     ORA $05
$5DBC            .byte $22,$22,$22,$22,$22,$22,$22,$22
$5DC4            .byte $22,$22,$22,$22,$22,$22,$22,$22
$5DCC            .byte $22,$22,$22,$22,$22,$22,$22,$22
$5DD4            .byte $22,$22,$22,$22,$22,$22,$22,$22
$5DDC            .byte $22,$22,$22,$22,$22,$22,$22,$22
$5DE4            .byte $22,$22,$22,$22
$5DE8  45 21     EOR $21 
$5DEA  20 47 4F  JSR L_JSR_($4F47)_($5DEA) JAM
$5DED            .byte $00,$00,$00
$5DF0  55 50     EOR $50,X 
$5DF2  20 41 20  JSR L_JSR_($2041)_($5DF2) BAD
$5DF5  59 45 41  EOR $4145,Y 
$5DF8            .byte $52,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($5E00)_($4A68) JAM
//------------------------------
$5E00            .byte $44,$6F
$5E02  6E 27 74  ROR $7427 
$5E05  20 6C 65  JSR L_JSR_($656C)_($5E05) OK
$5E08            .byte $74
$5E09  20 12 20  JSR L_JSR_($2012)_($5E09) OK
$5E0C            .byte $74,$6F
$5E0E  75 63     ADC $63,X 
$5E10  68        PLA 
$5E11  20 79 6F  JSR L_JSR_($6F79)_($5E11) JAM
$5E14  75 20     ADC $20,X 
$5E16            .byte $74
$5E17  68        PLA 
$5E18  69 73     ADC #$73
$5E1A  20 70 6C  JSR L_JSR_($6C70)_($5E1A) BAD
$5E1D  61 79     ADC ($79,X) 
$5E1F            .byte $74
$5E20  69 6D     ADC #$6D
$5E22  65 20     ADC $20 
$5E24  2D 20 48  AND $4820 
$5E27  65 27     ADC $27 
$5E29            .byte $73
$5E2A  20 67 6F  JSR L_JSR_($6F67)_($5E2A) JAM
$5E2D            .byte $74
$5E2E  20 6D 75  JSR L_JSR_($756D)_($5E2E) BAD
$5E31  6D 70 73  ADC $7370 
$5E34            .byte $03,$13
$5E36  20 69 73  JSR L_JSR_($7369)_($5E36) JAM
$5E39  20 67 6F  JSR L_JSR_($6F67)_($5E39) JAM
$5E3C  69 6E     ADC #$6E
$5E3E            .byte $67
$5E3F  20 74 6F  JSR L_JSR_($6F74)_($5E3F) JAM
$5E42  20 74 65  JSR L_JSR_($6574)_($5E42) JAM
$5E45  6C 6C 20  JMP ($206C) 
$5E48            .byte $14
$5E49  20 77 68  JSR L_JSR_($6877)_($5E49) BAD
$5E4C  61 74     ADC ($74,X) 
$5E4E  20 79 6F  JSR L_JSR_($6F79)_($5E4E) JAM
$5E51  75 27     ADC $27,X 
$5E53            .byte $72
$5E54  65 20     ADC $20 
$5E56  75 70     ADC $70,X 
$5E58  20 74 6F  JSR L_JSR_($6F74)_($5E58) JAM
$5E5B  2E 20 59  ROL $5920 
$5E5E            .byte $6F
$5E5F  75 20     ADC $20,X 
$5E61  6D 75 73  ADC $7375 
$5E64            .byte $74
$5E65  20 73 74  JSR L_JSR_($7473)_($5E65) BAD
$5E68            .byte $6F
$5E69  70 20     BVS L_BRS_($5E8B)_($5E69) OK
$5E6B  68        PLA 
$5E6C  69 6D     ADC #$6D
$5E6E  20 67 65  JSR L_JSR_($6567)_($5E6E) JAM
$5E71            .byte $74,$74
$5E73  69 6E     ADC #$6E
$5E75            .byte $67
$5E76  20 74 6F  JSR L_JSR_($6F74)_($5E76) JAM
$5E79  20 68 69  JSR L_JSR_($6968)_($5E79) OK
$5E7C            .byte $73
$5E7D  20 73 74  JSR L_JSR_($7473)_($5E7D) BAD
$5E80  75 64     ADC $64,X 
$5E82  79 20 74  ADC $7420,Y 
$5E85  68        PLA 
$5E86  69 73     ADC #$73
$5E88  20 62 72  JSR L_JSR_($7262)_($5E88) OK
//------------------------------
L_BRS_($5E8B)_($5E69) OK
//------------------------------
$5E8B  65 61     ADC $61 
$5E8D            .byte $6B,$03
$5E8F  11 20     ORA ($20),Y
$5E91  68        PLA 
$5E92  61 73     ADC ($73,X) 
$5E94  20 68 69  JSR L_JSR_($6968)_($5E94) OK
$5E97            .byte $64,$64
$5E99  65 6E     ADC $6E 
$5E9B  20 61 20  JSR L_JSR_($2061)_($5E9B) OK
$5E9E  70 65     BVS L_BRS_($5F05)_($5E9E) BAD
$5EA0  61 2D     ADC ($2D,X) 
$5EA2            .byte $73
$5EA3  68        PLA 
$5EA4            .byte $6F,$6F,$74
$5EA7  65 72     ADC $72 
$5EA9  20 77 69  JSR L_JSR_($6977)_($5EA9) BAD
$5EAC            .byte $74
$5EAD  68        PLA 
$5EAE  20 79 6F  JSR L_JSR_($6F79)_($5EAE) JAM
$5EB1  75 72     ADC $72,X 
$5EB3  20 6E 61  JSR L_JSR_($616E)_($5EB3) JAM
$5EB6  6D 65 20  ADC $2065 
$5EB9            .byte $6F
$5EBA  6E 20 69  ROR $6920 
$5EBD            .byte $74
$5EBE  20 6F 6E  JSR L_JSR_($6E6F)_($5EBE) JAM
$5EC1  20 74 68  JSR L_JSR_($6874)_($5EC1) JAM
$5EC4  65 20     ADC $20 
$5EC6  66 69     ROR $69 
$5EC8            .byte $72
$5EC9  65 2D     ADC $2D 
$5ECB  65 73     ADC $73 
$5ECD            .byte $63
$5ECE  61 70     ADC ($70,X) 
$5ED0  65 2E     ADC $2E 
$5ED2  20 49 66  JSR L_JSR_($6649)_($5ED2) JAM
$5ED5  20 14 20  JSR L_JSR_($2014)_($5ED5) OK
$5ED8            .byte $67
$5ED9  65 74     ADC $74 
$5EDB            .byte $73
$5EDC  20 74 68  JSR L_JSR_($6874)_($5EDC) JAM
$5EDF  65 72     ADC $72 
$5EE1  65 20     ADC $20 
$5EE3            .byte $62
$5EE4  65 66     ADC $66 
$5EE6            .byte $6F,$72
$5EE8  65 20     ADC $20 
$5EEA  11 20     ORA ($20),Y
$5EEC  79 6F 75  ADC $756F,Y 
$5EEF            .byte $27
$5EF0  6C 6C 20  JMP ($206C) 
$5EF3            .byte $67
$5EF4  65 74     ADC $74 
$5EF6  20 6C 69  JSR L_JSR_($696C)_($5EF6) JAM
$5EF9  6E 65 73  ROR $7365 
$5EFC            .byte $03,$42,$3C,$00,$14
$5F01  0D 1D 88  ORA $881D
//------------------------------
L_BRS_($5F05)_($5E9E) BAD
//------------------------------
$5F04  85 86     STA $86 
$5F06            .byte $87
$5F07  11 33     ORA ($33),Y
$5F09            .byte $57
$5F0A  41 34     EOR ($34,X) 
$5F0C            .byte $5A,$53
$5F0E  45 01     EOR $01 
$5F10  35 52     AND $52,X 
$5F12            .byte $44
$5F13  36 43     ROL $43,X 
$5F15  46 54     LSR $54 
$5F17  58        CLI 
$5F18            .byte $37
$5F19  59 47 38  EOR $3847,Y 
$5F1C            .byte $42
$5F1D  48        PHA 
$5F1E  55 56     EOR $56,X 
$5F20  39 49 4A  AND $4A49,Y 
//------------------------------
L_BRS_($5F23)_($5F8A) OK
//------------------------------
$5F23  30 4D     BMI L_BRS_($5F72)_($5F23) OK
$5F25            .byte $4B,$4F
$5F27  4E 2B 50  LSR $502B 
$5F2A  4C 2D 2E  JMP L_JMP_($2E2D)_($5F2A) BAD
$5F2D            .byte $3A
$5F2E  40        RTI 
//------------------------------
$5F2F  2C 5C 2A  BIT $2A5C 
//------------------------------
L_BRS_($5F32)_($5F63) JAM
//------------------------------
$5F32            .byte $3B,$13
$5F34  01 3D     ORA ($3D,X)
$5F36  5E 2F 31  LSR $312F,X 
$5F39            .byte $5F,$04,$32
$5F3C  20 02 51  JSR L_JSR_($5102)_($5F3C) JAM
$5F3F            .byte $03
$5F40  94 8D     STY $8D,X 
$5F42  9D 8C 89  STA $898C,X 
$5F45  8A        TXA 
$5F46            .byte $8B
$5F47  91 23     STA ($23),Y 
$5F49            .byte $D7
$5F4A  C1 24     CMP ($24,X) 
$5F4C            .byte $DA,$D3
$5F4E  C5 01     CMP $01 
$5F50  25 D2     AND $D2
$5F52  C4 26     CPY $26 
$5F54            .byte $C3
$5F55  C6 D4     DEC $D4 
$5F57  D8        CLD 
$5F58            .byte $27
$5F59  D9 C7 28  CMP $28C7,Y 
$5F5C            .byte $C2
$5F5D  C8        INY 
$5F5E  D5 D6     CMP $D6,X 
$5F60  29 C9     AND #$C9
$5F62  CA        DEX 
$5F63  30 CD     BMI L_BRS_($5F32)_($5F63) JAM
$5F65            .byte $CB,$CF
$5F67  CE DB D0  DEC $D0DB 
$5F6A  CC DD 3E  CPY $3EDD 
$5F6D            .byte $5B
$5F6E  BA        TSX 
$5F6F            .byte $3C
$5F70  A9 C0     LDA #$C0
//------------------------------
L_BRS_($5F72)_($5F23) OK
//------------------------------
$5F72  5D 93 01  EOR $0193,X 
$5F75  3D DE 3F  AND $3FDE,X 
$5F78  21 5F     AND ($5F,X) 
$5F7A            .byte $04,$22
$5F7C  A0 02     LDY #$02
$5F7E  D1 83     CMP ($83),Y 
$5F80  94 8D     STY $8D,X 
$5F82  9D 8C 89  STA $898C,X 
$5F85  8A        TXA 
$5F86            .byte $8B
$5F87  91 96     STA ($96),Y 
$5F89            .byte $B3
$5F8A  B0 97     BCS L_BRS_($5F23)_($5F8A) OK
$5F8C  AD AE B1  LDA $B1AE 
$5F8F  01 98     ORA ($98,X)
$5F91            .byte $B2
$5F92  AC 99 BC  LDY $BC99 
$5F95            .byte $BB,$A3
$5F97  BD 9A B7  LDA $B79A,X 
$5F9A  A5 9B     LDA $9B 
$5F9C            .byte $BF
$5F9D  B4 B8     LDY $B8,X 
$5F9F  BE 29 A2  LDX $A229,Y 
$5FA2  B5 30     LDA $30,X 
$5FA4            .byte $A7
$5FA5  A1 B9     LDA ($B9,X) 
$5FA7  AA        TAX 
$5FA8  A6 AF     LDX $AF 
$5FAA  B6 DC     LDX $DC,Y 
$5FAC  3E 5B A4  ROL $A45B,X 
$5FAF            .byte $3C
$5FB0  A8        TAY 
$5FB1            .byte $DF
$5FB2  5D 93 01  EOR $0193,X 
$5FB5  3D DE 3F  AND $3FDE,X 
$5FB8  81 5F     STA ($5F,X) 
$5FBA            .byte $04
$5FBB  95 A0     STA $A0,X 
$5FBD            .byte $02,$AB,$83,$FF,$FF,$FF,$FF,$FF
$5FC5            .byte $FF,$FF,$FF,$1C,$17
$5FCA  01 9F     ORA ($9F,X)
$5FCC            .byte $1A,$13
$5FCE  05 FF     ORA $FF
$5FD0            .byte $9C,$12,$04
$5FD3  1E 03 06  ASL $0603,X 
$5FD6            .byte $14
$5FD7  18        CLC 
$5FD8            .byte $1F
$5FD9  19 07 9E  ORA $9E07,Y
$5FDC            .byte $02
$5FDD  08        PHP 
$5FDE  15 16     ORA $16,X
$5FE0            .byte $12
$5FE1  09 0A     ORA #$0A
$5FE3            .byte $92
$5FE4  0D 0B 0F  ORA $0F0B
$5FE7  0E FF 10  ASL $10FF 
$5FEA            .byte $0C,$FF,$FF,$1B,$00,$FF,$1C,$FF
$5FF2  1D FF FF  ORA $FFFF,X
$5FF5            .byte $1F
$5FF6  1E FF 90  ASL $90FF,X 
$5FF9  06 FF     ASL $FF 
$5FFB  05 FF     ORA $FF
$5FFD            .byte $FF
$5FFE  11 FF     ORA ($FF),Y
$6000            .byte $00,$FF,$80,$FF,$80
$6005  81 81     STA ($81,X) 
$6007  8A        TXA 
$6008            .byte $82,$80
$600A  81 80     STA ($80,X) 
$600C            .byte $80,$FF,$00,$00
$6010  10 10     BPL L_BRS_($6022)_($6010) JAM
$6012            .byte $FF,$00,$00,$8F,$FF
$6017  08        PHP 
$6018  A0 01     LDY #$01
$601A            .byte $FF
$601B  01 01     ORA ($01,X)
//------------------------------
L_BRS_($6022)_($6010) JAM
//------------------------------
$601D            .byte $FF,$00,$43,$43,$00,$C2,$FF,$80
$6025            .byte $FF
$6026  20 00 80  JSR L_JSR_($8000)_($6026) JAM
$6029            .byte $80,$87,$FF,$FF,$00,$0F,$00,$07
$6031            .byte $00,$FF,$00,$FF,$BF,$80,$B2
$6038  66 00     ROR $00 
$603A            .byte $0F,$00,$80
$603D  E0 E0     CPX #$E0
$603F            .byte $80,$FF,$FF,$FF,$00
$6044  BC DA C0  LDY $C0DA,X 
$6047  C0 C0     CPY #$C0
$6049  C0 FF     CPY #$FF
$604B            .byte $FF,$80,$FF,$00,$00,$07,$03,$03
$6053            .byte $03,$07,$00,$FF,$00
$6058  10 00     BPL L_BRS_($605A)_($6058) JAM
//------------------------------
L_BRS_($605A)_($6058) JAM
//------------------------------
$605A            .byte $EB,$00
$605C  08        PHP 
$605D            .byte $1F
$605E  40        RTI 
//------------------------------
$605F            .byte $00,$FF,$80,$00,$FF,$00,$FF,$00
$6067            .byte $FF,$00
$6069  C0 FF     CPY #$FF
$606B            .byte $0F
$606C  E0 10     CPX #$10
$606E            .byte $BB,$FF,$80,$00
$6072  01 FF     ORA ($FF,X)
$6074            .byte $FF,$00
$6076  C0 81     CPY #$81
$6078  81 FF     STA ($FF,X) 
$607A  01 01     ORA ($01,X)
$607C            .byte $00
$607D  01 FF     ORA ($FF,X)
$607F            .byte $FF
$6080  01 00     ORA ($00,X)
$6082            .byte $00,$FF
$6084  60        RTS 
//------------------------------
$6085            .byte $FF
$6086  21 20     AND ($20,X) 
$6088            .byte $FF,$00
$608A  C0 FF     CPY #$FF
$608C            .byte $00,$FF
$608E  C0 E0     CPY #$E0
$6090            .byte $02,$00,$00,$FF,$00,$FF,$FC
$6097  01 00     ORA ($00,X)
$6099            .byte $00,$00,$FF,$FF,$00
$609E  C8        INY 
$609F  01 00     ORA ($00,X)
$60A1  10 00     BPL L_BRS_($60A3)_($60A1) JAM
//------------------------------
L_BRS_($60A3)_($60A1) JAM
//------------------------------
$60A3            .byte $FF,$BF,$BF,$BF,$FF,$00,$BF,$00
$60AB  20 00 00  JSR $0000
$60AE            .byte $FF,$FF,$FF,$00
$60B2  C0 0F     CPY #$0F
$60B4            .byte $FF,$FF,$FF,$FF,$FF,$FF,$00,$00
//------------------------------
L_BRS_($60BD)_($60BC) BAD
//------------------------------
$60BC  F0 FF     BEQ L_BRS_($60BD)_($60BC) BAD
$60BE            .byte $FF
$60BF  C0 C0     CPY #$C0
$60C1            .byte $EF,$FF,$FF,$1F,$03,$FF,$FF,$FF
$60C9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$60D1            .byte $FF,$00,$5F,$FF,$FF,$FF
$60D7  60        RTS 
//------------------------------
$60D8  C0 FF     CPY #$FF
$60DA            .byte $FF,$7F,$FF,$FF,$FF,$FF,$FF,$FF
$60E2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$60EA            .byte $FF,$FF,$FF,$FF,$FF
$60EF  81 0E     STA ($0E,X) 
$60F1  7E 7E 7E  ROR $7E7E,X 
$60F4  7E 7E 7E  ROR $7E7E,X 
$60F7  70 40     BVS L_BRS_($6139)_($60F7) BAD
$60F9            .byte $00,$00,$00,$00,$00,$00,$02,$00
$6101            .byte $DF,$80,$FF,$80
$6105  81 81     STA ($81,X) 
$6107            .byte $8B,$82,$80
$610A  FE 80 80  INC $8080,X 
$610D            .byte $FF,$00,$00
$6110  10 10     BPL L_BRS_($6122)_($6110) JAM
$6112            .byte $FF,$00,$00,$80,$00,$04,$7F
$6119  01 01     ORA ($01,X)
$611B  01 01     ORA ($01,X)
//------------------------------
L_BRS_($6122)_($6110) JAM
//------------------------------
$611D            .byte $FF,$00,$43,$43,$00,$67,$FF,$80
$6125  71 20     ADC ($20),Y 
$6127  C0 80     CPY #$80
$6129  81 BF     STA ($BF,X) 
$612B            .byte $FF,$1F,$00
$612E  01 00     ORA ($00,X)
$6130            .byte $04,$FF,$FF,$00,$80,$80,$80,$FF
//------------------------------
L_BRS_($6139)_($60F7) BAD
//------------------------------
$6138  55 00     EOR $00,X 
$613A  F0 00     BEQ L_BRS_($613C)_($613A) OK
//------------------------------
L_BRS_($613C)_($613A) OK
L_BRS_($613D)_($6158) BAD
//------------------------------
$613C  E0 E0     CPX #$E0
$613E            .byte $00,$FF,$FF
$6141  81 81     STA ($81,X) 
$6143            .byte $07
$6144  FE 5F C0  INC $C05F,X 
$6147  C0 C0     CPY #$C0
//------------------------------
L_JSR_($614A)_($52AF) BAD
//------------------------------
$6149  C0 00     CPY #$00
$614B            .byte $00,$7F,$FF
$614E  F0 0F     BEQ L_BRS_($615F)_($614E) BAD
//------------------------------
L_JSR_($6150)_($56CE) JAM
//------------------------------
$6150            .byte $07,$03,$03,$03,$3F
$6155  7E 00 FF  ROR $FF00,X 
$6158  10 E3     BPL L_BRS_($613D)_($6158) BAD
$615A            .byte $FF,$FF
$615C  08        PHP 
//------------------------------
L_BRS_($615F)_($614E) BAD
L_BRS_($615E)_($616C) BAD
//------------------------------
$615D  20 FF 7E  JSR L_JSR_($7EFF)_($615D) BAD
$6160            .byte $FF,$80
$6162  7E 00 FF  ROR $FF00,X 
//------------------------------
L_JMP_($6165)_($4DB4) OK
L_BRS_($6166)_($6165) BAD
//------------------------------
$6165  10 FF     BPL L_BRS_($6166)_($6165) BAD
$6167            .byte $FF,$00
$6169  C0 01     CPY #$01
$616B            .byte $00
$616C  10 F0     BPL L_BRS_($615E)_($616C) BAD
//------------------------------
L_JSR_($616E)_($5EB3) JAM
//------------------------------
$616E            .byte $F8,$FF,$80,$00
$6172  01 00     ORA ($00,X)
$6174            .byte $FF,$00
//------------------------------
L_JSR_($6177)_($54E4) BAD
L_JSR_($6177)_($5AD7) BAD
L_JSR_($6177)_($5AE4) BAD
//------------------------------
$6176  C0 81     CPY #$81
$6178            .byte $80,$FF
$617A  01 01     ORA ($01,X)
$617C            .byte $00,$00,$FF,$FF
$6180  01 1F     ORA ($1F,X)
$6182            .byte $00,$FF
$6184  60        RTS 
//------------------------------
$6185  E1 20     SBC ($20,X) 
$6187  20 FF 00  JSR $00FF
$618A            .byte $00,$FF
$618C  C0 FF     CPY #$FF
$618E            .byte $3C,$80,$02,$00,$00,$FF,$00,$FF
$6196            .byte $04
$6197  01 00     ORA ($00,X)
$6199            .byte $BF,$00,$7F,$FF,$00
$619E  08        PHP 
$619F            .byte $FF
$61A0  F0 10     BEQ L_BRS_($61B2)_($61A0) OK
$61A2            .byte $00,$80,$80,$80,$80,$FF,$00,$FF
$61AA            .byte $00
$61AB  20 00 00  JSR $0000
$61AE            .byte $00,$00,$00,$00
//------------------------------
L_BRS_($61B2)_($61A0) OK
//------------------------------
$61B2  40        RTI 
//------------------------------
$61B3            .byte $1F,$00,$00,$00,$00,$00,$00,$00
$61BB            .byte $00,$00,$00,$00
$61BF  C0 C0     CPY #$C0
$61C1            .byte $FF,$00,$00,$7F,$07,$00,$00,$00
$61C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$61D1            .byte $00,$FF,$5F,$00,$00,$00
$61D7  A0 FE     LDY #$FE
$61D9            .byte $00,$00
$61DB  41 FF     EOR ($FF,X) 
$61DD            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$61E5            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$61ED            .byte $FF,$FF
//------------------------------
L_JSR_($61F0)_($65AA) BAD
//------------------------------
$61EF  81 31     STA ($31,X) 
$61F1  81 81     STA ($81,X) 
$61F3  81 81     STA ($81,X) 
$61F5  81 81     STA ($81,X) 
$61F7  8C 40 00  STY $0040 
$61FA            .byte $00,$00,$00,$00,$00,$02,$00,$83
$6202            .byte $80
$6203  81 80     STA ($80,X) 
$6205  81 80     STA ($80,X) 
$6207  8A        TXA 
$6208            .byte $82,$80,$80,$80,$80,$FF,$00,$00
$6210  10 10     BPL L_BRS_($6222)_($6210) OK
$6212            .byte $FF,$00,$00,$80,$00,$04,$00
$6219  01 01     ORA ($01,X)
$621B  01 03     ORA ($03,X)
$621D            .byte $FF,$00,$43,$43,$3F
//------------------------------
L_BRS_($6222)_($6210) OK
//------------------------------
$6222  28        PLP 
$6223            .byte $FF,$80
$6225  20 20 C0  JSR L_JSR_($C020)_($6225) BAD
$6228            .byte $80
$6229  BE FF FF  LDX $FFFF,Y 
$622C            .byte $03,$00,$00,$00,$04
$6231  0E FF 00  ASL $00FF 
$6234            .byte $80,$80,$80,$00,$67,$00,$00,$00
$623C  E0 E0     CPX #$E0
$623E            .byte $00,$03,$FF
$6241  81 81     STA ($81,X) 
$6243  06 0F     ASL $0F 
$6245  DE C0 C0  DEC $C0C0,X 
//------------------------------
L_BRS_($6248)_($624E) OK
//------------------------------
$6248  C0 C1     CPY #$C1
$624A            .byte $FF,$FF,$00,$FF
$624E  10 F8     BPL L_BRS_($6248)_($624E) OK
$6250            .byte $FF,$03,$03,$03,$FF
$6255  1E FF 00  ASL $00FF,X 
$6258  10 14     BPL L_BRS_($626E)_($6258) JAM
$625A            .byte $FF,$00
$625C  08        PHP 
$625D  40        RTI 
//------------------------------
$625E            .byte $00,$72,$8F,$80
$6262  5E FF 00  LSR $00FF,X 
$6265  10 00     BPL L_BRS_($6267)_($6265) JAM
//------------------------------
L_BRS_($6267)_($6265) JAM
L_BRS_($6267)_($6284) JAM
//------------------------------
$6267            .byte $FF,$00
//------------------------------
L_JMP_($6269)_($506C) OK
//------------------------------
$6269  C0 01     CPY #$01
$626B            .byte $00
$626C  10 70     BPL L_BRS_($62DE)_($626C) JAM
//------------------------------
L_BRS_($626E)_($6258) JAM
//------------------------------
$626E            .byte $FB,$FF,$80,$00
$6272  01 7F     ORA ($7F,X)
$6274            .byte $FF,$00
$6276  C0 81     CPY #$81
$6278            .byte $80,$FF
$627A  01 00     ORA ($00,X)
$627C            .byte $03,$00,$FF,$3F
$6280  01 FF     ORA ($FF,X)
$6282            .byte $00,$FF
$6284  70 E1     BVS L_BRS_($6267)_($6284) JAM
$6286  20 20 C0  JSR L_JSR_($C020)_($6286) BAD
$6289            .byte $00,$00,$8F,$F8,$FF,$04,$80
$6290  06 07     ASL $07 
$6292            .byte $00,$FF,$00,$FF,$04,$00,$00
$6299  C1 00     CMP ($00,X) 
$629B            .byte $0F,$FF,$00
$629E  08        PHP 
$629F            .byte $FF
//------------------------------
L_BRS_($62A1)_($62A0) BAD
//------------------------------
$62A0  F0 FF     BEQ L_BRS_($62A1)_($62A0) BAD
$62A2            .byte $00,$BF,$BF,$BF,$80,$FF,$00,$FF
$62AA  E0 FF     CPX #$FF
$62AC            .byte $00,$00,$FF,$FF,$FF
$62B1  C0 FE     CPY #$FE
$62B3            .byte $3F,$FF,$FF,$FF,$FF,$FF,$FF,$00
$62BB            .byte $00,$00,$FF,$FF
$62BF  C1 C0     CMP ($C0,X) 
$62C1            .byte $FF,$FF,$FF,$FF,$0F,$FF,$FF,$FF
$62C9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$62D1            .byte $FF,$FF,$5F,$FF,$FF,$FF
$62D7  A0 FE     LDY #$FE
$62D9            .byte $FF,$FF
$62DB  49 FF     EOR #$FF
//------------------------------
L_BRS_($62DE)_($626C) JAM
//------------------------------
$62DD            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$62E5            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$62ED            .byte $FF,$FF
$62EF  81 40     STA ($40,X) 
$62F1            .byte $00,$00,$00,$00,$00,$00,$02
$62F8  40        RTI 
//------------------------------
$62F9            .byte $00,$00,$00,$00,$00,$00,$02,$00
$6301  81 80     STA ($80,X) 
$6303            .byte $80,$80
$6305  81 80     STA ($80,X) 
//------------------------------
L_JSR_($6307)_($A1AB) JAM
L_JSR_($6307)_($DE22) JAM
//------------------------------
$6307            .byte $89
$6308  81 80     STA ($80,X) 
$630A            .byte $80,$80,$80,$7F,$00,$1C
$6310  1E 10 07  ASL $0710,X 
$6313            .byte $00,$00,$80,$00,$04,$00
$6319  01 01     ORA ($01,X)
$631B            .byte $0F,$0F,$FF,$00,$43,$43,$47
$6322  28        PLP 
//------------------------------
L_BRS_($6323)_($63A0) JAM
//------------------------------
$6323            .byte $FF,$80
$6325  20 20 D7  JSR L_JSR_($D720)_($6325) JAM
$6328            .byte $80
$6329  C0 FF     CPY #$FF
$632B            .byte $FF,$00,$00,$00,$00,$FC
$6331  15 FF     ORA $FF,X
$6333            .byte $00,$80,$80,$9F,$FF,$77,$00,$00
$633B            .byte $00
$633C  E0 E0     CPX #$E0
$633E            .byte $00
$633F  01 FF     ORA ($FF,X)
$6341  81 81     STA ($81,X) 
$6343  E4 DC     CPX $DC 
$6345            .byte $DF
$6346  C0 C0     CPY #$C0
$6348  C0 CF     CPY #$CF
$634A            .byte $FF,$BF,$00,$FF
$634E  18        CLC 
$634F            .byte $0F,$FF,$03,$03,$03,$FF
$6355  4E AE 00  LSR $00AE 
$6358  10 74     BPL L_BRS_($63CE)_($6358) BAD
$635A            .byte $FF,$00
$635C  08        PHP 
$635D  40        RTI 
//------------------------------
$635E            .byte $00,$72
$6360  81 F0     STA ($F0,X) 
$6362  4E FE 00  LSR $00FE 
$6365  10 00     BPL L_BRS_($6367)_($6365) JAM
//------------------------------
L_BRS_($6367)_($6365) JAM
//------------------------------
$6367            .byte $FF,$00
$6369  C0 01     CPY #$01
$636B            .byte $00
$636C  10 70     BPL L_BRS_($63DE)_($636C) JAM
$636E  F6 1F     INC $1F,X 
$6370            .byte $80,$00,$02,$FF,$FF,$00
$6376  C0 81     CPY #$81
$6378            .byte $80,$FF
$637A  01 00     ORA ($00,X)
$637C            .byte $7F,$00,$FF,$3F
$6380  01 FE     ORA ($FE,X)
$6382            .byte $00,$FF
$6384  0E 21 20  ASL $2021 
$6387  20 00 00  JSR $0000
$638A            .byte $00,$87,$FF,$FF,$04,$80,$BF,$3C
$6392            .byte $00,$FF,$00,$FF,$04,$0F,$FC,$0F
$639A            .byte $07,$03,$FF,$00
$639E  08        PHP 
$639F            .byte $FF
$63A0  10 81     BPL L_BRS_($6323)_($63A0) JAM
$63A2            .byte $00,$BF,$BF,$BF,$80,$FF,$00,$FF
$63AA  E0 03     CPX #$03
$63AC            .byte $07,$00,$FF
$63AF  55 FF     EOR $FF,X 
$63B1  C0 1E     CPY #$1E
$63B3            .byte $7F,$FF,$57,$FF,$FF,$FF,$7F,$00
$63BB            .byte $00,$00,$FF,$AF,$CF
$63C0  C0 FF     CPY #$FF
$63C2  ED FF FF  SBC $FFFF 
$63C5            .byte $1F
$63C6  FE FF AA  INC $AAFF,X 
$63C9  75 BF     ADC $BF,X 
$63CB            .byte $FA
//------------------------------
L_BRS_($63CE)_($6358) BAD
//------------------------------
$63CC  EE 3B FB  INC $FB3B 
$63CF  BD FF FF  LDA $FFFF,X 
$63D2            .byte $FF
$63D3  60        RTS 
//------------------------------
$63D4            .byte $5F,$FF
$63D6  EE A0 00  INC $00A0 
$63D9  75 FF     ADC $FF,X 
$63DB  55 FF     EOR $FF,X 
//------------------------------
L_BRS_($63DE)_($636C) JAM
//------------------------------
$63DD            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$63E5            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$63ED            .byte $FF,$FF,$42
$63F0  40        RTI 
//------------------------------
$63F1            .byte $00,$00,$00,$00,$00,$00,$02,$80
$63F9            .byte $00,$00,$00,$00,$00,$00
$63FF  01 00     ORA ($00,X)
$6401            .byte $80,$80,$80,$80
$6405  81 80     STA ($80,X) 
$6407            .byte $89
$6408  81 80     STA ($80,X) 
$640A            .byte $80,$83,$80,$0F,$00,$13
$6410  11 10     ORA ($10),Y
$6412            .byte $00,$00,$00,$80
$6416  F0 04     BEQ L_BRS_($641C)_($6416) BAD
$6418            .byte $0B
$6419  01 01     ORA ($01,X)
//------------------------------
L_BRS_($641C)_($6416) BAD
//------------------------------
$641B  F1 7F     SBC ($7F),Y 
$641D            .byte $FF
$641E  E0 E3     CPX #$E3
$6420            .byte $43,$42,$27,$8F,$80
$6425  20 20 BF  JSR L_JSR_($BF20)_($6425) OK
$6428            .byte $80,$80,$FF,$FF,$00,$00,$00,$00
$6430            .byte $0C,$FF,$FF,$00,$80,$80
$6436  90 07     BCC L_BRS_($643F)_($6436) JAM
$6438            .byte $77,$00,$00,$00
$643C  E0 E0     CPX #$E0
//------------------------------
L_BRS_($643F)_($6436) JAM
//------------------------------
$643E            .byte $00,$FF,$FF
$6441  81 81     STA ($81,X) 
$6443  E4 D2     CPX $D2 
$6445            .byte $FF
$6446  C0 C1     CPY #$C1
$6448  C0 FF     CPY #$FF
$644A  BE AA FF  LDX $FFAA,Y 
$644D            .byte $FF
$644E  08        PHP 
//------------------------------
L_BRS_($6451)_($6458) JAM
//------------------------------
$644F            .byte $0B,$FF,$03,$FF,$03,$FF
$6455  66 AE     ROR $AE 
$6457            .byte $FC
$6458  10 F7     BPL L_BRS_($6451)_($6458) JAM
$645A            .byte $FF,$00
$645C  08        PHP 
$645D  40        RTI 
//------------------------------
L_BRS_($645E)_($646C) JAM
//------------------------------
$645E            .byte $FF
$645F  4E 80 FE  LSR $FE80 
$6462  46 CA     LSR $CA 
$6464            .byte $00
//------------------------------
L_BRS_($6466)_($6465) BAD
//------------------------------
$6465  10 FF     BPL L_BRS_($6466)_($6465) BAD
$6467            .byte $FF,$80
$6469  C0 01     CPY #$01
$646B            .byte $00
$646C  10 F0     BPL L_BRS_($645E)_($646C) JAM
$646E  F6 03     INC $03,X 
$6470            .byte $80,$00,$02,$FF,$FF,$00,$EF
$6477  81 80     STA ($80,X) 
$6479  C0 01     CPY #$01
$647B            .byte $00,$FF,$00,$00,$0F,$00
$6481  F5 00     SBC $00,X 
$6483            .byte $00
$6484  06 21     ASL $21 
$6486  20 20 00  JSR $0020
$6489            .byte $1F,$00,$80,$FF,$00,$04,$8F
$6490  C0 E0     CPY #$E0
$6492            .byte $00,$FF
$6494  C0 03     CPY #$03
$6496            .byte $04,$FF,$FC
$6499  78        SEI 
$649A            .byte $3C,$00,$FF,$00
$649E  08        PHP 
$649F            .byte $FF
$64A0  10 0E     BPL L_BRS_($64B0)_($64A0) BAD
$64A2            .byte $00,$BF
$64A4  A5 BA     LDA $BA 
$64A6            .byte $80,$FF,$00,$FF
$64AA  20 1E 3C  JSR L_JSR_($3C1E)_($64AA) JAM
$64AD            .byte $03,$FF
//------------------------------
L_BRS_($64B0)_($64A0) BAD
//------------------------------
$64AF  55 AB     EOR $AB,X 
$64B1  C0 62     CPY #$62
$64B3            .byte $FF,$FF
$64B5  55 D5     EOR $D5,X 
$64B7            .byte $FF,$27,$54,$00,$00,$00,$FF
$64BE  AA        TAX 
$64BF            .byte $FF
$64C0  C0 FF     CPY #$FF
$64C2  C5 AA     CMP $AA 
$64C4            .byte $FF,$3F
$64C6  AA        TAX 
$64C7  9D AA 55  STA $55AA,X 
$64CA  A5 4A     LDA $4A 
$64CC  AA        TAX 
$64CD  31 AA     AND ($AA),Y 
$64CF  A5 FF     LDA $FF 
$64D1  40        RTI 
//------------------------------
$64D2            .byte $FF,$7F
$64D4  55 FF     EOR $FF,X 
$64D6            .byte $00
$64D7  C0 FE     CPY #$FE
$64D9            .byte $54,$BB
$64DB  49 FF     EOR #$FF
$64DD            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$64E5            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$64ED            .byte $FF,$FF
$64EF  24 80     BIT $80 
$64F1            .byte $00,$00,$00,$00,$00,$00
$64F7  01 80     ORA ($80,X)
$64F9            .byte $00,$00,$00,$00,$00,$00
$64FF  01 00     ORA ($00,X)
$6501            .byte $80,$80,$80
$6504  81 81     STA ($81,X) 
$6506            .byte $87
$6507  85 81     STA $81 
$6509            .byte $80,$80,$FC,$83
$650D  01 00     ORA ($00,X)
$650F  10 10     BPL L_BRS_($6521)_($650F) OK
$6511            .byte $1F,$00,$00,$00,$80
$6516  18        CLC 
$6517  06 7F     ASL $7F 
$6519  01 01     ORA ($01,X)
$651B  01 FF     ORA ($FF,X)
$651D            .byte $FF,$5C,$5F,$43
//------------------------------
L_BRS_($6521)_($650F) OK
//------------------------------
$6521  41 20     EOR ($20,X) 
$6523            .byte $00,$80
$6525  20 20 BF  JSR L_JSR_($BF20)_($6525) OK
$6528            .byte $80,$80,$FF,$FF,$00,$00,$00,$00
$6530            .byte $0C,$04,$1F,$00,$80,$80
$6536  90 04     BCC L_BRS_($653C)_($6536) OK
$6538            .byte $BF,$00,$00,$03
//------------------------------
L_BRS_($653C)_($6536) OK
//------------------------------
$653C  E0 E0     CPX #$E0
$653E            .byte $00
$653F  DD FF 81  CMP $81FF,X 
$6542  81 64     STA ($64,X) 
$6544            .byte $53,$FF
$6546  C0 FE     CPY #$FE
$6548  C0 FF     CPY #$FF
$654A            .byte $C2
$654B  AA        TAX 
$654C            .byte $80,$FF
$654E  08        PHP 
$654F            .byte $0B,$FF,$03,$03,$1F,$FF,$72
$6556  AE 17 10  LDX $1017 
$6559            .byte $F4,$FF,$F8
$655C  08        PHP 
$655D  40        RTI 
//------------------------------
L_BRS_($655E)_($656C) OK
//------------------------------
$655E  40        RTI 
//------------------------------
$655F  4E 80 FF  LSR $FF80                          // Kernal Version Number
$6562            .byte $42
$6563  CA        DEX 
$6564            .byte $00
$6565  10 00     BPL L_BRS_($6567)_($6565) JAM
//------------------------------
L_JSR_($6567)_($5E6E) JAM
L_BRS_($6567)_($6565) JAM
//------------------------------
$6567            .byte $1F
//------------------------------
L_JSR_($6568)_($5B0C) OK
//------------------------------
$6568  C0 C0     CPY #$C0
$656A  01 00     ORA ($00,X)
//------------------------------
L_JSR_($656D)_($5AFF) BAD
L_JSR_($656C)_($5E05) OK
//------------------------------
$656C  10 F0     BPL L_BRS_($655E)_($656C) OK
$656E            .byte $F7,$00
$6570  C0 00     CPY #$00
//------------------------------
L_JSR_($6574)_($4805) JAM
L_JSR_($6574)_($5E42) JAM
//------------------------------
$6572            .byte $02,$FF,$7F,$00,$FF
$6577  81 80     STA ($80,X) 
$6579  7E 01 00  ROR $0001,X 
$657C            .byte $FF,$00,$00,$0F,$00,$FF,$03,$00
$6584            .byte $02
$6585  21 20     AND ($20,X) 
$6587  20 FF F0  JSR L_JSR_($F0FF)_($6587) JAM
$658A            .byte $0F,$80,$FF,$00,$04,$FF,$3F,$03
//------------------------------
L_BRS_($6592)_($65A0) JAM
//------------------------------
$6592            .byte $00,$7F
$6594  C0 00     CPY #$00
$6596            .byte $04,$FF,$04
$6599  C0 E0     CPY #$E0
$659B            .byte $00,$07,$00,$0F,$FF
$65A0  10 F0     BPL L_BRS_($6592)_($65A0) JAM
$65A2            .byte $00,$A7
$65A4  A5 BA     LDA $BA 
$65A6            .byte $80,$FF,$F8,$FF
$65AA  20 F0 61  JSR L_JSR_($61F0)_($65AA) BAD
$65AD            .byte $0F,$80
$65AF  55 AB     EOR $AB,X 
$65B1  40        RTI 
//------------------------------
$65B2            .byte $C2,$FF,$0B
$65B5  55 B5     EOR $B5,X 
$65B7  55 93     EOR $93,X 
$65B9            .byte $54,$00,$00,$00,$7A
$65BE  AA        TAX 
$65BF            .byte $FF
$65C0  C0 FF     CPY #$FF
$65C2  8D AA FF  STA $FFAA 
$65C5            .byte $7F
$65C6  AA        TAX 
$65C7  CD AA 55  CMP $55AA 
$65CA  A5 4A     LDA $4A 
$65CC  AA        TAX 
$65CD  38        SEC 
$65CE            .byte $AB
$65CF  A5 80     LDA $80 
$65D1  20 FC 80  JSR L_JSR_($80FC)_($65D1) OK
$65D4  55 00     EOR $00,X 
$65D6            .byte $03,$0F
$65D8  01 56     ORA ($56,X)
$65DA            .byte $AB
$65DB  41 FF     EOR ($FF,X) 
$65DD            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$65E5            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$65ED            .byte $FF,$FF
$65EF  24 80     BIT $80 
$65F1            .byte $00,$00,$00,$00,$00,$00
$65F7  01 80     ORA ($80,X)
$65F9            .byte $00,$00,$00,$00,$00,$00
$65FF  01 00     ORA ($00,X)
$6601            .byte $80,$80,$80
$6604  81 81     STA ($81,X) 
$6606  8E 85 BF  STX $BF85 
//------------------------------
L_BRS_($660C)_($668A) JAM
//------------------------------
$6609            .byte $80,$80,$80,$9F,$00,$00
$660F  10 10     BPL L_BRS_($6621)_($660F) JAM
$6611            .byte $00,$00,$FF,$00,$80
$6616  08        PHP 
$6617            .byte $03,$7F
$6619  01 01     ORA ($01,X)
$661B  01 FF     ORA ($FF,X)
//------------------------------
L_BRS_($6621)_($660F) JAM
//------------------------------
$661D            .byte $BF,$43,$43,$FF,$42
$6622  20 00 80  JSR L_JSR_($8000)_($6622) JAM
$6625  20 FF DF  JSR L_JSR_($DFFF)_($6625) BAD
//------------------------------
L_BRS_($662C)_($6636) JAM
//------------------------------
$6628            .byte $80,$80,$FF,$FF,$00
$662D  20 00 00  JSR $0000
$6630  0E 04 00  ASL $0004 
$6633            .byte $00,$80,$80
$6636  90 F4     BCC L_BRS_($662C)_($6636) JAM
$6638            .byte $FF,$7F,$00,$1F
$663C  E0 E0     CPX #$E0
$663E            .byte $00,$89,$BF
$6641  81 81     STA ($81,X) 
$6643  24 D2     BIT $D2 
$6645            .byte $FF
$6646  C0 C0     CPY #$C0
//------------------------------
L_JSR_($6649)_($5ED2) JAM
//------------------------------
$6648            .byte $C3,$FF,$E2
$664B  AA        TAX 
$664C            .byte $80,$FF
$664E  08        PHP 
$664F            .byte $0B,$FF,$03,$03,$E3,$FF,$3C
$6656  AA        TAX 
$6657  10 10     BPL L_BRS_($6669)_($6657) BAD
$6659  94 FF     STY $FF,X 
$665B  08        PHP 
$665C  08        PHP 
$665D  40        RTI 
//------------------------------
$665E  40        RTI 
//------------------------------
$665F  2C 80 FF  BIT $FF80                          // Kernal Version Number
$6662  24 CA     BIT $CA 
$6664            .byte $00
$6665  10 00     BPL L_BRS_($6667)_($6665) JAM
//------------------------------
L_BRS_($6667)_($6665) JAM
//------------------------------
$6667            .byte $03
//------------------------------
L_BRS_($6669)_($6657) BAD
//------------------------------
$6668  E0 C0     CPX #$C0
$666A  01 00     ORA ($00,X)
$666C  10 07     BPL L_BRS_($6675)_($666C) JAM
//------------------------------
L_JSR_($666F)_($5648) JAM
//------------------------------
$666E            .byte $FF,$00,$F8
$6671  01 FE     ORA ($FE,X)
//------------------------------
L_BRS_($6675)_($666C) JAM
//------------------------------
$6673            .byte $FF,$3F,$00,$FF
$6677  81 80     STA ($80,X) 
$6679            .byte $03
$667A  01 00     ORA ($00,X)
$667C            .byte $FF,$00
$667E  F0 03     BEQ L_BRS_($6683)_($667E) BAD
$6680            .byte $00,$FF
//------------------------------
L_BRS_($6683)_($667E) BAD
//------------------------------
$6682  7E 00 02  ROR $0200,X 
$6685  21 20     AND ($20,X) 
$6687  20 FF 03  JSR $03FF
$668A  70 80     BVS L_BRS_($660C)_($668A) JAM
$668C            .byte $FF,$00,$04,$FF
$6690  C1 1E     CMP ($1E,X) 
$6692            .byte $0F,$0F
$6694  C0 00     CPY #$00
$6696            .byte $07,$FF,$04,$00,$0F,$00,$00,$F8
//------------------------------
L_BRS_($669F)_($669E) BAD
//------------------------------
$669E  70 FF     BVS L_BRS_($669F)_($669E) BAD
$66A0  10 00     BPL L_BRS_($66A2)_($66A0) JAM
//------------------------------
L_BRS_($66A2)_($66A0) JAM
//------------------------------
$66A2            .byte $0F,$B8
$66A4  A5 BA     LDA $BA 
$66A6            .byte $80,$3F
$66A8  18        CLC 
$66A9            .byte $FF
$66AA  20 00 8E  JSR L_JSR_($8E00)_($66AA) OK
$66AD            .byte $BF,$FF
$66AF  55 AB     EOR $AB,X 
$66B1  C0 02     CPY #$02
$66B3            .byte $FF,$D7
$66B5  55 F5     EOR $F5,X 
$66B7  55 C9     EOR $C9,X 
$66B9            .byte $54,$00,$0F,$00
$66BD  75 AA     ADC $AA,X 
$66BF            .byte $FF,$C3,$FF
$66C2  1D AA FF  ORA $FFAA,X
$66C5            .byte $FF
$66C6  AA        TAX 
$66C7  E5 AA     SBC $AA 
$66C9  55 A5     EOR $A5,X 
$66CB  4A        LSR A 
$66CC  AA        TAX 
$66CD            .byte $3C,$AB
$66CF  A5 40     LDA $40 
$66D1  91 F0     STA ($F0),Y 
$66D3            .byte $FF
$66D4  55 00     EOR $00,X 
$66D6            .byte $07
//------------------------------
L_BRS_($66D8)_($66D7) BAD
//------------------------------
$66D7  10 FF     BPL L_BRS_($66D8)_($66D7) BAD
$66D9  56 AB     LSR $AB,X 
$66DB  41 FF     EOR ($FF,X) 
$66DD            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$66E5            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$66ED            .byte $FF,$FF,$14,$80,$00,$00,$00,$00
$66F5            .byte $00,$00
$66F7  01 81     ORA ($81,X)
$66F9  81 81     STA ($81,X) 
$66FB  81 81     STA ($81,X) 
$66FD  81 81     STA ($81,X) 
$66FF  81 00     STA ($00,X) 
$6701            .byte $80,$80,$80
$6704  81 81     STA ($81,X) 
$6706            .byte $9B
$6707  85 FF     STA $FF 
$6709            .byte $80,$80,$80,$FF,$00,$00
$670F  10 10     BPL L_BRS_($6721)_($670F) JAM
$6711            .byte $00,$00,$00,$FF
$6715  C0 08     CPY #$08
$6717  C0 FF     CPY #$FF
$6719  01 01     ORA ($01,X)
$671B  01 FF     ORA ($FF,X)
//------------------------------
L_BRS_($6721)_($670F) JAM
//------------------------------
$671D            .byte $07,$43,$43,$07,$43
$6722  20 00 FF  JSR L_JSR_($FF00)_($6722) OK
$6725  20 00 FF  JSR L_JSR_($FF00)_($6725) OK
//------------------------------
L_BRS_($672C)_($6736) JAM
//------------------------------
$6728            .byte $FF,$80,$FF,$FF,$00
$672D  70 00     BVS L_BRS_($672F)_($672D) OK
//------------------------------
L_BRS_($672F)_($672D) OK
//------------------------------
$672F  F0 07     BEQ L_BRS_($6738)_($672F) JAM
$6731            .byte $04,$00
//------------------------------
L_BRS_($6734)_($6733) BAD
//------------------------------
$6733  F0 FF     BEQ L_BRS_($6734)_($6733) BAD
$6735            .byte $FF
$6736  90 F4     BCC L_BRS_($672C)_($6736) JAM
//------------------------------
L_BRS_($6738)_($672F) JAM
//------------------------------
$6738            .byte $FF,$80,$00,$FF
$673C  E0 E0     CPX #$E0
$673E            .byte $00
$673F  DD 00 81  CMP $8100,X 
$6742            .byte $FF
$6743  24 53     BIT $53 
$6745            .byte $FF
$6746  C0 C0     CPY #$C0
$6748            .byte $FC,$FF,$F2
$674B  AA        TAX 
$674C            .byte $80,$7F
$674E  08        PHP 
$674F            .byte $0F,$FF,$03,$03,$03,$FF
$6755  18        CLC 
$6756  AA        TAX 
$6757  10 10     BPL L_BRS_($6769)_($6757) BAD
$6759            .byte $14,$FF
$675B  08        PHP 
$675C  08        PHP 
$675D  40        RTI 
//------------------------------
$675E  40        RTI 
//------------------------------
$675F  18        CLC 
$6760            .byte $80,$FF
$6762  18        CLC 
$6763  CA        DEX 
$6764            .byte $00,$FF,$00,$00
//------------------------------
L_BRS_($6769)_($6757) BAD
//------------------------------
$6768  C0 C0     CPY #$C0
//------------------------------
L_BRS_($676A)_($676C) JAM
//------------------------------
$676A            .byte $FF,$00
$676C  10 FC     BPL L_BRS_($676A)_($676C) JAM
$676E            .byte $FF,$00,$FF
$6771  01 00     ORA ($00,X)
$6773            .byte $FF,$07
$6775  C0 FF     CPY #$FF
$6777  81 80     STA ($80,X) 
$6779  01 01     ORA ($01,X)
$677B            .byte $00,$FF,$00,$5F,$03,$00,$FF
//------------------------------
L_BRS_($6783)_($6791) BAD
//------------------------------
$6782  C0 E0     CPY #$E0
$6784            .byte $02
$6785  21 20     AND ($20,X) 
$6787  20 FF 7E  JSR L_JSR_($7EFF)_($6787) BAD
$678A            .byte $80,$80,$FF,$00,$04,$FF,$00
$6791  70 F0     BVS L_BRS_($6783)_($6791) BAD
$6793            .byte $07
$6794  C0 00     CPY #$00
$6796  E0 FF     CPX #$FF
$6798            .byte $04,$00
$679A  70 00     BVS L_BRS_($679C)_($679A) JAM
//------------------------------
L_BRS_($679C)_($679A) JAM
//------------------------------
$679C            .byte $00
$679D  38        SEC 
$679E            .byte $80,$FF
$67A0  10 00     BPL L_BRS_($67A2)_($67A0) OK
//------------------------------
L_BRS_($67A2)_($67A0) OK
//------------------------------
$67A2  78        SEI 
$67A3            .byte $A7
$67A4  A5 BA     LDA $BA 
$67A6            .byte $80
$67A7  01 F8     ORA ($F8,X)
$67A9            .byte $FF
$67AA  20 00 70  JSR L_JSR_($7000)_($67AA) BAD
$67AD            .byte $FF
$67AE  C0 55     CPY #$55
$67B0            .byte $AB
$67B1  40        RTI 
//------------------------------
$67B2            .byte $02,$FF,$6F
$67B5  55 75     EOR $75,X 
$67B7  55 EC     EOR $EC,X 
$67B9            .byte $54,$FC,$7F,$00,$6B
$67BE  AA        TAX 
$67BF            .byte $FF,$C7,$FF
$67C2  BD AA FF  LDA $FFAA,X 
$67C5            .byte $FF
$67C6  AA        TAX 
$67C7  F5 AA     SBC $AA,X 
$67C9  55 A5     EOR $A5,X 
$67CB  4A        LSR A 
$67CC  AA        TAX 
$67CD  3E AB A5  ROL $A5AB,X 
$67D0            .byte $80
$67D1  CA        DEX 
$67D2  A0 FF     LDY #$FF
$67D4  55 00     EOR $00,X 
$67D6            .byte $0F,$3F,$FF,$57,$AB,$7F,$FF,$FF
$67DE            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$67E6            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$67EE            .byte $FF
$67EF  08        PHP 
$67F0  40        RTI 
//------------------------------
$67F1            .byte $00,$00,$00,$00,$00,$00,$02
$67F8  7E 7E 7E  ROR $7E7E,X 
$67FB  7E 7E 7E  ROR $7E7E,X 
$67FE  7E 7E 00  ROR $007E,X 
$6801            .byte $FF,$80
$6803  B0 60     BCS L_BRS_($6865)_($6803) OK
$6805  C0 80     CPY #$80
$6807  81 FF     STA ($FF,X) 
$6809  40        RTI 
//------------------------------
$680A            .byte $5F,$00
$680C  01 FF     ORA ($FF,X)
$680E            .byte $00,$FF,$BF,$BF,$BF,$00,$80,$FF
$6816            .byte $FF,$FF,$80,$80,$00,$FC,$FF
$681D  01 81     ORA ($81,X)
$681F  01 00     ORA ($00,X)
$6821            .byte $00
$6822  A0 FF     LDY #$FF
$6824            .byte $FF,$00,$00,$FF
$6828  C0 C0     CPY #$C0
$682A            .byte $FF,$F8,$FF,$FF,$FF
$682F  20 3F 00  JSR $003F
$6832            .byte $7F,$04
$6834  C4 00     CPY $00 
$6836            .byte $00,$FF,$02
$6839  41 7F     EOR ($7F,X) 
$683B            .byte $00
$683C  05 00     ORA $00
$683E            .byte $80
$683F  06 E0     ASL $E0 
$6841            .byte $00,$FF,$FF,$00
$6845  01 00     ORA ($00,X)
$6847            .byte $00,$03,$FF
$684A  08        PHP 
$684B            .byte $02
$684C  FE FF 00  INC $00FF,X 
$684F            .byte $EF,$EF,$FF,$03,$FF,$00,$FF,$FF
$6857            .byte $80
$6858  08        PHP 
$6859            .byte $EF,$0B,$03,$07,$00,$03
$685F  FD FF 42  SBC $42FF,X 
//------------------------------
L_JSR_($6863)_($54CD) JAM
//------------------------------
$6862            .byte $02,$00,$BF
//------------------------------
L_BRS_($6865)_($6803) OK
//------------------------------
$6865  19 F0 E0  ORA $E0F0,Y
$6868            .byte $00,$00
$686A  01 00     ORA ($00,X)
$686C  08        PHP 
//------------------------------
L_JSR_($6874)_($5AE8) JAM
L_JSR_($6874)_($5EC1) JAM
L_JSR_($6874)_($5EDC) JAM
//------------------------------
$686D            .byte $0F,$F7,$F8,$00,$00,$00,$3F,$03
$6875            .byte $1F
//------------------------------
L_JSR_($6877)_($5E49) BAD
//------------------------------
$6876  DD FE 01  CMP $01FE,X 
$6879            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6881            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6889            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6891            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6899            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68A1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68A9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68B1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68B9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68C1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68C9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68D1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68D9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68E1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$68E9            .byte $FF,$FF,$FF,$FF,$FF,$FF
$68EF  81 0E     STA ($0E,X) 
$68F1  7E 7E 7E  ROR $7E7E,X 
$68F4  7E 7E 7E  ROR $7E7E,X 
$68F7  70 40     BVS L_BRS_($6939)_($68F7) JAM
$68F9            .byte $00,$00,$00,$00,$00,$00,$02,$00
$6901            .byte $FF
$6902  C0 D0     CPY #$D0
$6904  A0 FE     LDY #$FE
$6906            .byte $80,$82,$80,$FF,$5F,$00,$02
$690D  01 00     ORA ($00,X)
$690F            .byte $80,$80,$80,$80,$00,$80,$00,$00
$6917            .byte $00
$6918  81 00     STA ($00,X) 
$691A            .byte $00,$FC,$00
$691D  01 01     ORA ($01,X)
$691F            .byte $00,$00,$00,$AF,$00,$00,$00,$FF
$6927            .byte $DF
$6928  C0 C0     CPY #$C0
$692A            .byte $FB,$F8,$03,$00,$FF
$692F  20 7F 00  JSR $007F
$6932            .byte $3F
$6933  84 C4     STY $C4 
$6935            .byte $00
$6936  7E FF 02  ROR $02FF,X 
//------------------------------
L_BRS_($6939)_($68F7) JAM
//------------------------------
$6939            .byte $FF,$7F,$00
$693C  F5 FF     SBC $FF,X 
$693E            .byte $80
$693F  85 FA     STA $FA 
$6941            .byte $00,$87,$17,$00,$FF
$6946  7E 00 87  ROR $8700,X 
$6949            .byte $00,$0C
$694B  01 FC     ORA ($FC,X)
$694D            .byte $00,$00,$EF,$EF,$FB,$03,$00,$00
$6955            .byte $FF,$00,$FF
$6958  08        PHP 
$6959            .byte $EF,$07,$03,$07,$00,$02
//------------------------------
L_JSR_($6961)_($54C5) BAD
//------------------------------
$695F  FD 00 E1  SBC $E100,X 
$6962  01 FF     ORA ($FF,X)
$6964            .byte $BF,$F3
$6966  C0 E0     CPY #$E0
//------------------------------
L_JSR_($6968)_($5E79) OK
L_JSR_($6968)_($5E94) OK
//------------------------------
$6968  7E 00 01  ROR $0100,X 
//------------------------------
L_JSR_($696C)_($5EF6) JAM
//------------------------------
$696B            .byte $00,$04,$FF,$F7,$F8
$6970  01 80     ORA ($80,X)
$6972            .byte $00,$3F
$6974  01 FF     ORA ($FF,X)
//------------------------------
L_JSR_($6977)_($5EA9) BAD
//------------------------------
$6976  9D FE 81  STA $81FE,X 
$6979            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6981            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6989            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6991            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6999            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69A1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69A9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69B1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69B9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69C1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69C9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69D1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69D9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69E1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$69E9            .byte $FF,$FF,$FF,$FF,$FF,$FF
$69EF  81 31     STA ($31,X) 
$69F1  81 81     STA ($81,X) 
$69F3  81 81     STA ($81,X) 
$69F5  81 81     STA ($81,X) 
$69F7  8C 40 00  STY $0040 
$69FA            .byte $00,$00,$00,$00,$00,$02,$00,$FF
$6A02  A0 B0     LDY #$B0
$6A04  A0 FE     LDY #$FE
$6A06            .byte $80
$6A07  84 80     STY $80 
$6A09            .byte $FF,$5F,$00,$04
$6A0D  01 00     ORA ($00,X)
$6A0F            .byte $BF,$BF,$BF,$80,$00,$80,$00,$FF
$6A17            .byte $FF,$82,$00
$6A1A  01 FF     ORA ($FF,X)
$6A1C            .byte $FF,$03
$6A1E  01 00     ORA ($00,X)
$6A20            .byte $FF,$BF,$AF,$FF,$FF,$FF,$FF,$CF
$6A28  C0 C0     CPY #$C0
$6A2A            .byte $FB,$F8
$6A2C  01 FF     ORA ($FF,X)
$6A2E            .byte $FF
$6A2F  20 FF FB  JSR L_JSR_($FBFF)_($6A2F) OK
$6A32            .byte $3F
$6A33  C4 C4     CPY $C4 
$6A35            .byte $EF
$6A36  1E FE 02  ASL $02FE,X 
$6A39            .byte $FF,$7F
$6A3B  FD F5 FF  SBC $FFF5,X 
$6A3E            .byte $80
$6A3F  85 FA     STA $FA 
$6A41            .byte $00,$8B,$17,$00,$FF
$6A46  5E 00 8B  LSR $8B00,X 
$6A49            .byte $1F,$04
$6A4B  01 F8     ORA ($F8,X)
$6A4D            .byte $FF,$00,$EF,$EF,$F3,$03,$F8,$00
$6A55            .byte $FF,$00
$6A57  40        RTI 
//------------------------------
$6A58            .byte $04,$EF,$0F,$03,$07,$00,$02
$6A5F  FD 40 21  SBC $2140,X 
$6A62            .byte $00,$BF,$BF,$F8,$80
$6A67  C0 72     CPY #$72
$6A69            .byte $00
$6A6A  01 00     ORA ($00,X)
$6A6C  84 F7     STY $F7 
$6A6E            .byte $F7
$6A6F  F0 03     BEQ L_BRS_($6A74)_($6A6F) BAD
$6A71  40        RTI 
//------------------------------
L_BRS_($6A74)_($6A6F) BAD
//------------------------------
$6A72  0D 3F 01  ORA $013F
$6A75            .byte $FF
$6A76  8A        TXA 
$6A77  FE 41 FF  INC $FF41,X 
$6A7A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6A82            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6A8A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6A92            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6A9A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6AA2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6AAA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6AB2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6ABA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6AC2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6ACA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6AD4)_($6B02) JAM
//------------------------------
$6AD2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6ADA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6AE2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6AEA            .byte $FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6AEF)_($6B65) OK
//------------------------------
$6AEF  81 40     STA ($40,X) 
$6AF1            .byte $00,$00,$00,$00,$00,$00,$02
$6AF8  40        RTI 
//------------------------------
$6AF9            .byte $00,$00,$00,$00,$00,$00,$02,$00
$6B01            .byte $FF
$6B02  D0 D0     BNE L_BRS_($6AD4)_($6B02) JAM
$6B04  A0 00     LDY #$00
$6B06            .byte $80
$6B07  88        DEY 
$6B08            .byte $80,$FF
$6B0A  60        RTS 
//------------------------------
$6B0B            .byte $00
$6B0C  08        PHP 
$6B0D  01 00     ORA ($00,X)
$6B0F            .byte $AF
$6B10  B5 AA     LDA $AA,X 
$6B12            .byte $80,$00,$80,$00,$FF
$6B17  AE 84 00  LDX $0084 
$6B1A            .byte $02,$FF
$6B1C  EE 05 01  INC $0105 
$6B1F            .byte $00,$00,$BF,$EF,$BF,$FF,$FF,$FF
$6B27            .byte $C7
$6B28  C0 C1     CPY #$C1
$6B2A  F9 F8 00  SBC $00F8,Y 
$6B2D  FE FF 20  INC $20FF,X 
$6B30            .byte $FF,$FB,$3F
$6B33  C4 C4     CPY $C4 
$6B35            .byte $EF
$6B36  4E FE 02  LSR $02FE 
$6B39            .byte $FF,$00
$6B3B  FD F7 FF  SBC $FFF7,X 
$6B3E            .byte $80
$6B3F  85 06     STA $06 
$6B41            .byte $80,$8B,$17,$00,$FF
$6B46  4E 00 8B  LSR $8B00 
$6B49  10 04     BPL L_BRS_($6B4F)_($6B49) OK
$6B4B  01 F0     ORA ($F0,X)
$6B4D            .byte $00,$00
//------------------------------
L_BRS_($6B4F)_($6B49) OK
//------------------------------
$6B4F  E0 FF     CPX #$FF
$6B51            .byte $E3,$03,$04,$00,$00,$00
$6B57  40        RTI 
//------------------------------
$6B58            .byte $04,$0F,$0F
$6B5B  09 03     ORA #$03
$6B5D            .byte $00,$02
$6B5F  FE 60 10  INC $1060,X 
$6B62            .byte $00,$BF,$FF
$6B65  F0 88     BEQ L_BRS_($6AEF)_($6B65) OK
$6B67  C0 72     CPY #$72
$6B69            .byte $00
$6B6A  01 80     ORA ($80,X)
$6B6C  84 F7     STY $F7 
$6B6E            .byte $FF
$6B6F  F0 01     BEQ L_BRS_($6B72)_($6B6F) BAD
//------------------------------
L_BRS_($6B72)_($6B6F) BAD
//------------------------------
$6B71  20 19 9E  JSR L_JSR_($9E19)_($6B71) BAD
$6B74            .byte $00,$FF
$6B76  C9 FC     CMP #$FC
$6B78  21 FF     AND ($FF,X) 
$6B7A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6B89)_($6C07) JAM
//------------------------------
$6B82            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6B8A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6B92            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6B9A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6BA2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6BAA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6BB4)_($6C02) JAM
//------------------------------
$6BB2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6BBA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6BC2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6BCA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6BD2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6BDA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6BE7)_($6C65) JAM
//------------------------------
$6BE2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6BEA            .byte $FF,$FF,$FF,$FF,$FF,$42
$6BF0  40        RTI 
//------------------------------
$6BF1            .byte $00,$00,$00,$00,$00,$00,$02,$80
$6BF9            .byte $00,$00,$00,$00,$00,$00
$6BFF  01 00     ORA ($00,X)
$6C01            .byte $FF
$6C02  B0 B0     BCS L_BRS_($6BB4)_($6C02) JAM
$6C04  C0 FE     CPY #$FE
$6C06            .byte $80
$6C07  90 80     BCC L_BRS_($6B89)_($6C07) JAM
$6C09            .byte $FF,$7F,$00
$6C0C  10 01     BPL L_BRS_($6C0F)_($6C0C) OK
$6C0E            .byte $00
//------------------------------
L_BRS_($6C0F)_($6C0C) OK
//------------------------------
$6C0F  AA        TAX 
$6C10  B5 AA     LDA $AA,X 
$6C12            .byte $80,$00,$80,$00
$6C16  40        RTI 
//------------------------------
$6C17  AE 88 00  LDX $0088 
$6C1A            .byte $02,$FF
$6C1C  55 09     EOR $09,X 
$6C1E  01 00     ORA ($00,X)
$6C20            .byte $00
$6C21  C0 EF     CPY #$EF
$6C23  AA        TAX 
$6C24  9D 00 FF  STA $FF00,X 
$6C27            .byte $C3
$6C28  C0 C3     CPY #$C3
$6C2A  F9 F8 00  SBC $00F8,Y 
$6C2D  CA        DEX 
$6C2E            .byte $FF
$6C2F  20 FF 00  JSR $00FF
$6C32            .byte $1F
$6C33  C4 C4     CPY $C4 
$6C35            .byte $00
$6C36  66 FE     ROR $FE 
$6C38            .byte $02,$FF,$7F
$6C3B  01 F7     ORA ($F7,X)
$6C3D  FE 80 85  INC $8580,X 
$6C40  FE 80 0B  INC $0B80,X 
$6C43            .byte $17,$00,$FF
$6C46  46 00     LSR $00 
$6C48            .byte $0B
$6C49  10 04     BPL L_BRS_($6C4F)_($6C49) JAM
$6C4B  01 F0     ORA ($F0,X)
//------------------------------
L_BRS_($6C4F)_($6C49) JAM
//------------------------------
$6C4D            .byte $00,$00,$EF,$FF,$C3,$03,$04,$00
$6C55            .byte $FF,$00
$6C57  20 02 EF  JSR L_JSR_($EF02)_($6C57) JAM
$6C5A            .byte $3F,$00,$03,$00,$02,$FF
$6C60  50 08     BVC L_BRS_($6C6A)_($6C60) BAD
//------------------------------
L_JSR_($6C62)_($5466) JAM
//------------------------------
$6C62            .byte $00,$BF,$FF
$6C65  F0 80     BEQ L_BRS_($6BE7)_($6C65) JAM
$6C67            .byte $80
//------------------------------
L_BRS_($6C6A)_($6C60) BAD
//------------------------------
$6C68  4E 00 01  LSR $0100 
$6C6B  40        RTI 
//------------------------------
$6C6C            .byte $44,$F7,$FF
//------------------------------
L_JSR_($6C70)_($5E1A) BAD
//------------------------------
$6C6F  E0 02     CPX #$02
$6C71  10 33     BPL L_BRS_($6CA6)_($6C71) JAM
$6C73  18        CLC 
$6C74            .byte $00,$FF
$6C76  65 7C     ADC $7C 
$6C78  11 FF     ORA ($FF),Y
$6C7A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6C82            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6C8A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6C92            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6C9A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6CA6)_($6C71) JAM
//------------------------------
$6CA2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6CAA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6CB2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6CBF)_($6D3D) JAM
//------------------------------
$6CBA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6CC2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6CCA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6CD4)_($6D02) JAM
//------------------------------
$6CD2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6CDA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6CE2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6CEA            .byte $FF,$FF,$FF,$FF,$FF
$6CEF  24 80     BIT $80 
$6CF1            .byte $00,$00,$00,$00,$00,$00
$6CF7  01 80     ORA ($80,X)
$6CF9            .byte $00,$00,$00,$00,$00,$00
$6CFF  01 00     ORA ($00,X)
$6D01            .byte $FF
$6D02  D0 D0     BNE L_BRS_($6CD4)_($6D02) JAM
$6D04            .byte $0F
$6D05  01 80     ORA ($80,X)
$6D07  A0 80     LDY #$80
$6D09            .byte $FC,$80,$00
$6D0C  20 01 00  JSR $0001
$6D0F  AA        TAX 
$6D10  B5 AA     LDA $AA,X 
$6D12            .byte $80,$00,$80,$00
$6D16  20 AE 90  JSR L_JSR_($90AE)_($6D16) JAM
$6D19            .byte $00,$02,$FF,$AB
$6D1D  11 01     ORA ($01),Y
$6D1F            .byte $00,$00
$6D21  C0 EF     CPY #$EF
$6D23  AA        TAX 
$6D24  CD 00 FF  CMP $FF00 
$6D27  C1 C0     CMP ($C0,X) 
$6D29            .byte $C7,$F8,$F8,$00
$6D2D  CA        DEX 
$6D2E            .byte $FF
$6D2F  20 FF 00  JSR $00FF
$6D32            .byte $1F
$6D33  C4 C4     CPY $C4 
$6D35            .byte $00,$72
$6D37  FE 02 FC  INC $FC02,X 
$6D3A            .byte $80
$6D3B  01 F7     ORA ($F7,X)
$6D3D  F0 80     BEQ L_BRS_($6CBF)_($6D3D) JAM
$6D3F  7D 01 80  ADC $8001,X 
$6D42            .byte $0B,$17,$00,$FC,$42,$00,$0B
$6D49  08        PHP 
$6D4A            .byte $02
$6D4B  01 E0     ORA ($E0,X)
$6D4D            .byte $00,$00,$EF,$FF,$83,$03,$02,$00
$6D55            .byte $FF,$00
$6D57  20 02 EF  JSR L_JSR_($EF02)_($6D57) JAM
$6D5A            .byte $3F,$00,$03,$00,$02,$FF
$6D60  48        PHA 
$6D61  08        PHP 
$6D62            .byte $00,$80,$FF,$FC,$44
$6D67  40        RTI 
//------------------------------
$6D68  4E 00 01  LSR $0100 
$6D6B  20 24 07  JSR $0724
$6D6E            .byte $FF,$44,$00
$6D71  08        PHP 
$6D72            .byte $7F
$6D73  10 00     BPL L_BRS_($6D75)_($6D73) JAM
//------------------------------
L_BRS_($6D75)_($6D73) JAM
//------------------------------
$6D75            .byte $FF,$02
$6D77  78        SEI 
$6D78  09 FF     ORA #$FF
$6D7A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6D82            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6D8A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6D92            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6D9A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DA2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DAA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6DB4)_($6E02) JAM
//------------------------------
$6DB2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DBA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DC2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DCA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DD2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DDA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DE2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6DEA            .byte $FF,$FF,$FF,$FF,$FF
$6DEF  24 80     BIT $80 
$6DF1            .byte $00,$00,$00,$00,$00,$00
$6DF7  01 80     ORA ($80,X)
$6DF9            .byte $00,$00,$00,$00,$00,$00
$6DFF  01 00     ORA ($00,X)
$6E01            .byte $FF
$6E02  B0 B0     BCS L_BRS_($6DB4)_($6E02) JAM
//------------------------------
L_BRS_($6E05)_($6E04) BAD
//------------------------------
$6E04  10 FF     BPL L_BRS_($6E05)_($6E04) BAD
$6E06            .byte $80
$6E07  C0 80     CPY #$80
//------------------------------
L_BRS_($6E0A)_($6E09) BAD
//------------------------------
$6E09  F0 FF     BEQ L_BRS_($6E0A)_($6E09) BAD
$6E0B            .byte $00
$6E0C  40        RTI 
//------------------------------
$6E0D  01 00     ORA ($00,X)
$6E0F  AA        TAX 
$6E10  B5 AA     LDA $AA,X 
$6E12            .byte $80,$00,$80,$00
$6E16  91 AA     STA ($AA),Y 
$6E18  A0 00     LDY #$00
$6E1A            .byte $04,$FF,$57
$6E1D  21 01     AND ($01,X) 
$6E1F            .byte $00,$00,$80,$FF
$6E23  AA        TAX 
$6E24  E5 00     SBC $00 
$6E26            .byte $FF
$6E27  C0 C0     CPY #$C0
$6E29            .byte $CF,$F8,$FC,$00
$6E2D  CA        DEX 
$6E2E            .byte $FF
$6E2F  20 FF 00  JSR $00FF
$6E32            .byte $1F
$6E33  C4 C4     CPY $C4 
$6E35            .byte $00,$3C
$6E37  FE 02 F0  INC $F002,X 
$6E3A            .byte $FF
$6E3B  01 FF     ORA ($FF,X)
$6E3D            .byte $80,$80
$6E3F  21 FF     AND ($FF,X) 
$6E41            .byte $80,$0B,$17,$00
$6E45  F0 24     BEQ L_BRS_($6E6B)_($6E45) OK
$6E47            .byte $00,$0B
$6E49  08        PHP 
$6E4A            .byte $02
$6E4B  01 C0     ORA ($C0,X)
$6E4D            .byte $00,$00,$EF,$FF,$03,$03,$02,$00
$6E55            .byte $FF,$00
$6E57  10 01     BPL L_BRS_($6E5A)_($6E57) JAM
//------------------------------
L_BRS_($6E5A)_($6E57) JAM
//------------------------------
$6E59            .byte $EF,$3F,$00
$6E5C  06 00     ASL $00 
$6E5E            .byte $02,$FF
$6E60  48        PHA 
$6E61            .byte $04,$00,$BF,$FF,$F8
$6E66  C8        INY 
$6E67            .byte $00
//------------------------------
L_JSR_($6E69)_($447A) BAD
L_JSR_($6E69)_($5ADB) BAD
//------------------------------
$6E68  2C 00 01  BIT $0100 
//------------------------------
L_BRS_($6E6B)_($6E45) OK
//------------------------------
$6E6B  20 24 F7  JSR L_JSR_($F724)_($6E6B) BAD
//------------------------------
L_JSR_($6E6F)_($5EBE) JAM
//------------------------------
$6E6E            .byte $FF,$0C,$00,$04,$7F
$6E73  08        PHP 
$6E74            .byte $00,$FF,$00
$6E77  38        SEC 
$6E78  05 FF     ORA $FF
$6E7A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6E82            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6E8A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6E92            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6E9A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6EA2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6EAA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6EB2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6EBA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6EC2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6ECA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_BRS_($6ED4)_($6F02) JAM
//------------------------------
$6ED2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6EDA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6EE2            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6EEA            .byte $FF,$FF,$FF,$FF,$FF,$14,$80,$00
$6EF2            .byte $00,$00,$00,$00,$00
$6EF7  01 81     ORA ($81,X)
$6EF9  81 81     STA ($81,X) 
$6EFB  81 81     STA ($81,X) 
$6EFD  81 81     STA ($81,X) 
$6EFF  81 00     STA ($00,X) 
$6F01            .byte $FF
$6F02  D0 D0     BNE L_BRS_($6ED4)_($6F02) JAM
$6F04            .byte $3F,$FF,$80,$80,$FF
$6F09  A0 FF     LDY #$FF
$6F0B            .byte $00,$80,$FF
$6F0E  E0 AA     CPX #$AA
$6F10  B5 AA     LDA $AA,X 
$6F12            .byte $80,$3F,$80,$00
$6F16  CA        DEX 
$6F17  AA        TAX 
$6F18  C0 00     CPY #$00
$6F1A            .byte $04,$FF,$AF
$6F1D  41 01     EOR ($01,X) 
$6F1F            .byte $00,$00,$EF,$FF
$6F23  AA        TAX 
$6F24  F5 FF     SBC $FF,X 
$6F26            .byte $FF
$6F27  C0 C0     CPY #$C0
$6F29            .byte $DF,$F8
$6F2B  FE FF CA  INC $CAFF,X 
$6F2E            .byte $7F
$6F2F  20 FF FF  JSR L_JSR_($FFFF)_($6F2F) OK
$6F32            .byte $0F
$6F33  C4 C4     CPY $C4 
$6F35            .byte $FF
$6F36  18        CLC 
$6F37  FE 02 80  INC $8002,X 
$6F3A            .byte $FF
$6F3B  FD FF 80  SBC $80FF,X 
$6F3E            .byte $7F,$1F,$FF,$80,$7F,$FB
$6F44  FE 80 18  INC $1880,X 
//------------------------------
L_BRS_($6F47)_($6F57) JAM
L_BRS_($6F47)_($6F65) JAM
//------------------------------
$6F47            .byte $07,$7F
$6F49  08        PHP 
$6F4A            .byte $02
//------------------------------
L_JSR_($6F4B)_($4FB1) OK
//------------------------------
$6F4B  01 80     ORA ($80,X)
$6F4D            .byte $00,$EF,$EF,$FF,$03,$03
$6F53  01 FF     ORA ($FF,X)
$6F55            .byte $FF,$FF
$6F57  10 EE     BPL L_BRS_($6F47)_($6F57) JAM
$6F59            .byte $EF,$07,$03,$04,$03,$02,$FF,$44
//------------------------------
L_JMP_($6F61)_($4FC4) JAM
L_JSR_($6F64)_($5489) JAM
//------------------------------
$6F61            .byte $02,$00,$BF,$FF
$6F65  F0 E0     BEQ L_BRS_($6F47)_($6F65) JAM
//------------------------------
L_JSR_($6F67)_($5E2A) JAM
L_JSR_($6F67)_($5E39) JAM
//------------------------------
$6F67            .byte $00
$6F68  18        CLC 
$6F69            .byte $7F
$6F6A  01 10     ORA ($10,X)
//------------------------------
L_JSR_($6F6E)_($5B08) JAM
//------------------------------
$6F6C            .byte $14,$F7,$FF
$6F6F  08        PHP 
//------------------------------
L_JSR_($6F74)_($4473) JAM
L_JSR_($6F74)_($5463) JAM
L_JSR_($6F74)_($5486) JAM
L_JSR_($6F74)_($5E3F) JAM
L_JSR_($6F74)_($5E58) JAM
L_JSR_($6F74)_($5E76) JAM
//------------------------------
$6F70            .byte $00,$02,$3F,$07,$00,$FF,$0F
$6F77  10 03     BPL L_BRS_($6F7C)_($6F77) JAM
//------------------------------
L_JSR_($6F79)_($446A) JAM
L_JSR_($6F79)_($5E11) JAM
L_JSR_($6F79)_($5E4E) JAM
L_JSR_($6F79)_($5EAE) JAM
L_BRS_($6F7C)_($6F77) JAM
//------------------------------
$6F79            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6F81            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6F89            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6F91            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6F99            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FA1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FA9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FB1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FB9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FC1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FC9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FD1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FD9            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FE1            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$6FE9            .byte $FF,$FF,$FF,$FF,$FF,$FF
$6FEF  08        PHP 
$6FF0  40        RTI 
//------------------------------
$6FF1            .byte $00,$00,$00,$00,$00,$00,$02
$6FF8  7E 7E 7E  ROR $7E7E,X 
$6FFB  7E 7E 7E  ROR $7E7E,X 
//------------------------------
L_JSR_($7000)_($67AA) BAD
//------------------------------
$6FFE  7E 7E 00  ROR $007E,X 
//------------------------------
L_JSR_($7004)_($9D59) JAM
L_JSR_($7004)_($AD59) JAM
L_JSR_($7004)_($D9D0) JAM
L_JSR_($7004)_($E9D2) JAM
//------------------------------
$7001            .byte $FF,$FF,$00,$80,$00,$00,$7F,$00
$7009            .byte $FF,$00,$00
$700C  86 80     STX $80 
$700E            .byte $00,$FF,$00,$00,$00,$FF,$80,$80
$7016            .byte $80,$00,$FF,$00
$701A  01 01     ORA ($01,X)
$701C            .byte $00
$701D  01 00     ORA ($00,X)
$701F            .byte $FF,$FF
$7021  01 01     ORA ($01,X)
$7023  01 0F     ORA ($0F,X)
$7025            .byte $00,$02
//------------------------------
L_BRS_($7028)_($7027) BAD
//------------------------------
$7027  F0 FF     BEQ L_BRS_($7028)_($7027) BAD
$7029            .byte $80
$702A  C0 FF     CPY #$FF
//------------------------------
L_BRS_($702C)_($702D) JAM
//------------------------------
$702C            .byte $00
$702D  10 FD     BPL L_BRS_($702C)_($702D) JAM
$702F            .byte $00,$04,$00,$00,$FF,$00,$FF,$FF
$7037            .byte $00,$13,$FF,$80,$00
$703C  08        PHP 
$703D            .byte $00
$703E  01 00     ORA ($00,X)
$7040            .byte $03,$FF,$3F,$80,$00
$7045  20 00 FF  JSR L_JSR_($FF00)_($7045) OK
$7048  01 FF     ORA ($FF,X)
$704A            .byte $FF,$03,$80,$07
$704E  40        RTI 
//------------------------------
$704F            .byte $00,$FF
$7051  06 FF     ASL $FF 
$7053  84 04     STY $04 
$7055            .byte $FF,$00
$7057  01 FF     ORA ($FF,X)
$7059            .byte $FF,$00,$00,$FF,$80,$00,$FF,$FF
$7061            .byte $00
$7062  81 81     STA ($81,X) 
//------------------------------
L_JMP_($7065)_($51D4) JAM
//------------------------------
$7064            .byte $FF,$FF
$7066  01 00     ORA ($00,X)
$7068            .byte $00,$FF
//------------------------------
L_BRS_($706B)_($706A) BAD
//------------------------------
$706A  F0 FF     BEQ L_BRS_($706B)_($706A) BAD
$706C  E0 FF     CPX #$FF
$706E            .byte $00
$706F  05 05     ORA $05
$7071            .byte $FF,$00,$FF,$7F,$FF
$7076  01 00     ORA ($00,X)
$7078            .byte $FF
$7079  88        DEY 
$707A            .byte $FF
$707B  E0 00     CPX #$00
$707D            .byte $FF,$FF
$707F  01 06     ORA ($06,X)
$7081            .byte $02,$02
$7083  FE 00 F0  INC $F000,X 
$7086            .byte $80
$7087  84 F0     STY $F0 
$7089            .byte $00,$FF
$708B  91 00     STA ($00),Y 
$708D  10 20     BPL L_BRS_($70AF)_($708D) OK
$708F            .byte $FF
$7090  11 00     ORA ($00),Y
$7092  08        PHP 
$7093            .byte $04,$FC,$1C,$14,$14,$FF
$7099  06 06     ASL $06 
$709B            .byte $07,$FF,$F8
$709E  40        RTI 
//------------------------------
$709F  40        RTI 
//------------------------------
$70A0  A0 50     LDY #$50
$70A2  28        PLP 
$70A3            .byte $02,$00,$FF,$52,$52
$70A8  29 15     AND #$15
$70AA  40        RTI 
//------------------------------
$70AB            .byte $00,$FF
$70AD  94 94     STY $94,X 
//------------------------------
L_BRS_($70AF)_($708D) OK
//------------------------------
$70AF  8A        TXA 
$70B0  4A        LSR A 
$70B1  4A        LSR A 
$70B2            .byte $D4,$3F,$1F,$FF,$00
$70B7  C0 80     CPY #$80
//------------------------------
L_BRS_($70BA)_($7138) BAD
//------------------------------
$70B9  F0 00     BEQ L_BRS_($70BB)_($70B9) JAM
//------------------------------
L_BRS_($70BB)_($70B9) JAM
//------------------------------
$70BB            .byte $FF,$00
$70BD  20 FF 01  JSR $01FF
$70C0            .byte $FF,$FF,$03,$80,$07
$70C5  6A        ROR A 
$70C6  AA        TAX 
$70C7            .byte $FF
$70C8  06 FF     ASL $FF 
$70CA  84 04     STY $04 
$70CC            .byte $FF
$70CD  AA        TAX 
$70CE            .byte $AB,$FF,$FF,$00
$70D2  AA        TAX 
$70D3            .byte $FF,$80,$00,$FF,$FF,$00
$70D9  81 81     STA ($81,X) 
$70DB            .byte $FF,$FF
$70DD  01 00     ORA ($00,X)
$70DF            .byte $00,$FF
//------------------------------
L_BRS_($70E2)_($70E1) BAD
//------------------------------
$70E1  F0 FF     BEQ L_BRS_($70E2)_($70E1) BAD
$70E3  E0 FF     CPX #$FF
$70E5            .byte $00
$70E6  05 05     ORA $05
$70E8            .byte $FF,$00,$FF,$7F,$FF
$70ED  01 00     ORA ($00,X)
$70EF  81 0E     STA ($0E,X) 
$70F1  7E 7E 7E  ROR $7E7E,X 
$70F4  7E 7E 7E  ROR $7E7E,X 
$70F7  70 40     BVS L_BRS_($7139)_($70F7) BAD
$70F9            .byte $00,$00,$00,$00,$00,$00,$02,$00
$7101            .byte $FF
$7102  01 FF     ORA ($FF,X)
$7104            .byte $80,$00,$FF,$7F
$7108  81 05     STA ($05,X) 
$710A  7E 00 85  ROR $8500,X 
$710D            .byte $FA
$710E  7E 80 FF  ROR $FF80,X                          // Kernal Version Number
$7111  7E FF FF  ROR $FFFF,X 
$7114            .byte $80,$80
$7116  C0 FF     CPY #$FF
$7118            .byte $FF,$00
$711A  01 01     ORA ($01,X)
$711C            .byte $00
$711D  01 81     ORA ($81,X)
$711F  09 FF     ORA #$FF
$7121  01 01     ORA ($01,X)
$7123  01 00     ORA ($00,X)
$7125            .byte $00,$02,$F8,$FF,$FF
$712A  C0 FF     CPY #$FF
$712C            .byte $00
//------------------------------
L_BRS_($712E)_($712D) BAD
//------------------------------
$712D  10 FF     BPL L_BRS_($712E)_($712D) BAD
$712F            .byte $00,$04,$00,$00,$FC,$83
$7135  11 FF     ORA ($FF),Y
$7137            .byte $00
//------------------------------
L_BRS_($7139)_($70F7) BAD
//------------------------------
$7138  10 80     BPL L_BRS_($70BA)_($7138) BAD
$713A            .byte $FF,$0F
$713C  08        PHP 
$713D            .byte $00,$00,$00,$03,$FF
$7142  20 80 00  JSR $0080
$7145            .byte $FC,$00
$7147  FD 03 08  SBC $0803,X 
$714A            .byte $FF
$714B  3D 00 01  AND $0100,X 
$714E  40        RTI 
//------------------------------
$714F            .byte $00,$FF
$7151  06 87     ASL $87 
$7153            .byte $04,$04,$FF,$00,$00,$FF,$FF,$F8
$715B            .byte $00,$FF,$80,$00,$FF,$FF,$00
$7162  81 01     STA ($01,X) 
$7164            .byte $FF,$FF
$7166  01 FF     ORA ($FF,X)
$7168            .byte $FF,$FF,$80,$FF
$716C  E0 00     CPX #$00
$716E            .byte $00
$716F  FD FD FF  SBC $FFFD,X 
$7172            .byte $00,$FF,$00
$7175  FD 01 7F  SBC $7F01,X 
$7178  88        DEY 
$7179  88        DEY 
$717A            .byte $00
$717B  E0 7E     CPX #$7E
$717D            .byte $FF
$717E  01 01     ORA ($01,X)
//------------------------------
L_BRS_($7180)_($71BD) OK
//------------------------------
$7180  FE FE FE  INC $FEFE,X 
$7183  FE 00 F0  INC $F000,X 
$7186            .byte $80
$7187  84 E0     STY $E0 
$7189            .byte $00
$718A  91 91     STA ($91),Y 
$718C            .byte $00
$718D  10 20     BPL L_BRS_($71AF)_($718D) OK
$718F  11 11     ORA ($11),Y
$7191            .byte $00
$7192  08        PHP 
$7193            .byte $04,$04,$1C,$14,$14,$FF
$7199  06 07     ASL $07 
$719B            .byte $07,$FF,$80
$719E  40        RTI 
//------------------------------
$719F  40        RTI 
//------------------------------
$71A0  A0 50     LDY #$50
$71A2            .byte $14
$71A3  01 00     ORA ($00,X)
$71A5            .byte $FF,$52
$71A7  2A        ROL A 
$71A8  29 15     AND #$15
$71AA  30 00     BMI L_BRS_($71AC)_($71AA) JAM
//------------------------------
L_BRS_($71AC)_($71AA) JAM
//------------------------------
$71AC            .byte $FF
$71AD  94 92     STY $92,X 
//------------------------------
L_BRS_($71AF)_($718D) OK
//------------------------------
$71AF  8A        TXA 
$71B0  4A        LSR A 
$71B1  4A        LSR A 
$71B2            .byte $D3,$3F,$1F,$FF,$00,$80,$80,$FF
//------------------------------
L_BRS_($71BA)_($7238) OK
//------------------------------
$71BA  E0 FF     CPX #$FF
$71BC            .byte $00
$71BD  10 C1     BPL L_BRS_($7180)_($71BD) OK
$71BF  01 08     ORA ($08,X)
$71C1            .byte $FF
//------------------------------
L_BRS_($71C2)_($7233) OK
//------------------------------
$71C2  3D 00 01  AND $0100,X 
$71C5  55 55     EOR $55,X 
$71C7            .byte $FF,$07,$87,$04,$04,$FF
$71CD  55 55     EOR $55,X 
$71CF            .byte $FF,$FF,$F8
$71D2  55 FF     EOR $FF,X 
$71D4            .byte $80,$00,$FF,$FF,$00
$71D9  81 01     STA ($01,X) 
$71DB            .byte $FF,$FF
$71DD  01 FF     ORA ($FF,X)
$71DF            .byte $FF,$FF,$80,$FF
$71E3  E0 00     CPX #$00
$71E5            .byte $00
$71E6  FD FD FF  SBC $FFFD,X 
$71E9            .byte $00,$FF,$00
$71EC  FD 01 7F  SBC $7F01,X 
$71EF  81 31     STA ($31,X) 
$71F1  81 81     STA ($81,X) 
$71F3  81 81     STA ($81,X) 
$71F5  81 81     STA ($81,X) 
$71F7  8C 40 00  STY $0040 
$71FA            .byte $00,$00,$00,$00,$00,$02,$00,$FF
$7202  01 FF     ORA ($FF,X)
$7204            .byte $80,$00,$FF,$7F,$82
$7209  05 1E     ORA $1E
$720B            .byte $00
$720C  85 FA     STA $FA 
$720E  5E 80 FF  LSR $FF80,X                          // Kernal Version Number
$7211            .byte $72,$FF,$FF,$80,$80
//------------------------------
L_BRS_($7217)_($7216) BAD
//------------------------------
$7216  F0 FF     BEQ L_BRS_($7217)_($7216) BAD
$7218            .byte $FF,$00
$721A  01 C1     ORA ($C1,X)
$721C            .byte $00
$721D  01 86     ORA ($86,X)
$721F  09 F1     ORA #$F1
$7221  01 01     ORA ($01,X)
$7223  01 00     ORA ($00,X)
$7225            .byte $03,$7F,$FF,$FF,$FF
$722A  C0 FF     CPY #$FF
$722C            .byte $00
//------------------------------
L_BRS_($722E)_($722D) BAD
//------------------------------
$722D  10 FF     BPL L_BRS_($722E)_($722D) BAD
$722F            .byte $07,$FF,$00,$00
$7233  F0 8D     BEQ L_BRS_($71C2)_($7233) OK
$7235  11 FF     ORA ($FF),Y
$7237            .byte $00
$7238  10 80     BPL L_BRS_($71BA)_($7238) OK
$723A            .byte $FF,$0F,$FF,$00,$00,$00,$03,$FF
$7242  20 00 00  JSR $0000
$7245            .byte $83,$00
$7247  F1 1F     SBC ($1F),Y 
$7249  08        PHP 
$724A            .byte $FF
$724B  20 00 01  JSR $0100
$724E  40        RTI 
//------------------------------
$724F  E0 FF     CPX #$FF
$7251  0E 86 04  ASL $0486 
$7254            .byte $04,$83,$00,$00,$FF,$FC,$FF,$00
$725C            .byte $FF,$00
$725E  C0 FF     CPY #$FF
$7260            .byte $FF,$00
//------------------------------
L_JSR_($7262)_($5E88) OK
//------------------------------
$7262  81 01     STA ($01,X) 
$7264  FE F1 01  INC $01F1,X 
//------------------------------
L_JSR_($7267)_($57CC) JAM
//------------------------------
$7267            .byte $00,$00,$FF,$00,$FF
$726C  E0 00     CPX #$00
$726E            .byte $00
$726F  01 01     ORA ($01,X)
$7271            .byte $FF,$00,$FF,$00
$7275  F1 01     SBC ($01),Y 
$7277            .byte $7F
$7278  88        DEY 
$7279  88        DEY 
$727A            .byte $00,$F8
$727C  7E FF 01  ROR $01FF,X 
$727F  01 00     ORA ($00,X)
$7281            .byte $00,$00,$FF,$00,$FC,$80
$7287  84 E0     STY $E0 
$7289            .byte $00
$728A  91 91     STA ($91),Y 
$728C            .byte $00
$728D  10 40     BPL L_BRS_($72CF)_($728D) JAM
$728F  11 11     ORA ($11),Y
$7291            .byte $00
$7292  08        PHP 
$7293            .byte $02,$04,$1C,$14,$14,$FF
$7299  06 07     ASL $07 
$729B            .byte $07,$FF,$80
$729E  40        RTI 
//------------------------------
$729F  40        RTI 
//------------------------------
$72A0  A0 50     LDY #$50
$72A2            .byte $14,$00
//------------------------------
L_BRS_($72A5)_($72A4) BAD
//------------------------------
$72A4  F0 FF     BEQ L_BRS_($72A5)_($72A4) BAD
$72A6            .byte $52
$72A7  2A        ROL A 
$72A8  29 0D     AND #$0D
$72AA  CC 00 FF  CPY $FF00 
$72AD  94 8A     STY $8A,X 
$72AF  8A        TXA 
$72B0  4A        LSR A 
$72B1  4A        LSR A 
$72B2            .byte $7F,$3F,$1F,$FF,$00,$80,$80,$FF
//------------------------------
L_BRS_($72BA)_($7338) OK
//------------------------------
$72BA  18        CLC 
$72BB  F0 00     BEQ L_BRS_($72BD)_($72BB) OK
//------------------------------
L_BRS_($72BD)_($72BB) OK
//------------------------------
$72BD  18        CLC 
$72BE  01 01     ORA ($01,X)
$72C0  08        PHP 
$72C1            .byte $FF
$72C2  2A        ROL A 
$72C3            .byte $00
$72C4  01 6A     ORA ($6A,X)
$72C6  EA        NOP 
$72C7            .byte $FF
$72C8  0E 86 04  ASL $0486 
$72CB            .byte $04,$AB
$72CD  AA        TAX 
$72CE  AA        TAX 
//------------------------------
L_BRS_($72CF)_($728D) JAM
//------------------------------
$72CF            .byte $FF,$FC,$FF
$72D2  AA        TAX 
$72D3            .byte $FF,$00
$72D5  C0 FF     CPY #$FF
//------------------------------
L_BRS_($72D7)_($7351) JAM
//------------------------------
$72D7            .byte $FF,$00
$72D9  81 01     STA ($01,X) 
$72DB  FE F1 01  INC $01F1,X 
$72DE            .byte $00,$00,$FF,$00,$FF
$72E3  E0 00     CPX #$00
$72E5            .byte $00
$72E6  01 01     ORA ($01,X)
$72E8            .byte $FF,$00,$FF,$00
$72EC  F1 01     SBC ($01),Y 
$72EE            .byte $7F
$72EF  81 40     STA ($40,X) 
$72F1            .byte $00,$00,$00,$00,$00,$00,$02
$72F8  40        RTI 
//------------------------------
$72F9            .byte $00,$00,$00,$00,$00,$00,$02,$00
$7301            .byte $FF
$7302  01 FF     ORA ($FF,X)
$7304            .byte $80,$00,$FF,$00,$82
$7309  05 4E     ORA $4E
$730B            .byte $00
//------------------------------
L_JSR_($730C)_($A5AB) OK
L_JSR_($730C)_($E22A) OK
//------------------------------
$730C  85 06     STA $06 
$730E  4E 80 FF  LSR $FF80                          // Kernal Version Number
$7311            .byte $72,$FF,$FF,$80,$80,$F8,$FF,$FF
$7319            .byte $00
$731A  01 F9     ORA ($F9,X)
$731C            .byte $00
$731D  01 84     ORA ($84,X)
$731F  09 81     ORA #$81
$7321  01 01     ORA ($01,X)
$7323  01 00     ORA ($00,X)
$7325            .byte $03
$7326  78        SEI 
$7327            .byte $FF,$FF,$FF
$732A  C0 FF     CPY #$FF
$732C            .byte $00
//------------------------------
L_BRS_($732E)_($732D) BAD
//------------------------------
$732D  10 FF     BPL L_BRS_($732E)_($732D) BAD
$732F            .byte $07
$7330  C0 E0     CPY #$E0
$7332            .byte $00
$7333  C0 89     CPY #$89
$7335  11 FF     ORA ($FF),Y
$7337            .byte $00
$7338  10 80     BPL L_BRS_($72BA)_($7338) OK
$733A            .byte $FF
$733B  08        PHP 
$733C  81 E0     STA ($E0,X) 
$733E            .byte $00,$00,$03,$FF
$7342  20 F0 3F  JSR L_JSR_($3FF0)_($7342) JAM
$7345  F0 00     BEQ L_BRS_($7347)_($7345) OK
//------------------------------
L_BRS_($7347)_($7345) OK
//------------------------------
$7347  C1 FF     CMP ($FF,X) 
$7349  08        PHP 
$734A            .byte $FF
$734B  20 00 01  JSR $0100
$734E            .byte $FC,$3C,$FF
$7351  70 84     BVS L_BRS_($72D7)_($7351) JAM
$7353            .byte $04,$04,$00,$00,$00,$FF,$FC,$7F
$735B            .byte $00,$FF,$00
$735E  FE FF FE  INC $FEFF,X 
$7361            .byte $00
$7362  81 01     STA ($01,X) 
$7364            .byte $F8
$7365  01 01     ORA ($01,X)
//------------------------------
L_JSR_($7369)_($5A3E) JAM
L_JSR_($7369)_($5E36) JAM
//------------------------------
$7367            .byte $FF,$FF,$FF,$00,$FF
$736C  E0 00     CPX #$00
$736E            .byte $00
$736F  FD FD FF  SBC $FFFD,X 
$7372            .byte $00,$FF,$00
//------------------------------
L_JMP_($7375)_($5048) OK
//------------------------------
$7375  81 0F     STA ($0F,X) 
$7377            .byte $7F
$7378  88        DEY 
$7379  88        DEY 
$737A            .byte $00,$F8
$737C  7E 00 01  ROR $0100,X 
$737F  01 FE     ORA ($FE,X)
$7381  FE FE FF  INC $FFFE,X                          // Vector: IRQ
$7384            .byte $00,$FC,$80
$7387  88        DEY 
$7388  C0 00     CPY #$00
$738A  91 91     STA ($91),Y 
$738C            .byte $00
$738D  10 40     BPL L_BRS_($73CF)_($738D) BAD
$738F  11 11     ORA ($11),Y
$7391            .byte $00
$7392  08        PHP 
$7393            .byte $02,$04,$1C,$14,$14,$00
$7399  06 07     ASL $07 
$739B            .byte $07,$00,$80
$739E  40        RTI 
//------------------------------
$739F  40        RTI 
//------------------------------
$73A0  A0 50     LDY #$50
$73A2  0A        ASL A 
$73A3            .byte $00,$FF,$00,$52
$73A7  2A        ROL A 
$73A8  29 0B     AND #$0B
$73AA            .byte $33,$00,$00
$73AD  94 8A     STY $8A,X 
$73AF  8A        TXA 
$73B0  4A        LSR A 
$73B1  4A        LSR A 
$73B2  FE 3F 1F  INC $1F3F,X 
$73B5  10 00     BPL L_BRS_($73B7)_($73B5) JAM
//------------------------------
L_BRS_($73B7)_($73B5) JAM
L_BRS_($73BA)_($7438) JAM
//------------------------------
$73B7            .byte $80,$80,$FF,$14,$00,$00,$14
$73BE  01 01     ORA ($01,X)
$73C0  08        PHP 
$73C1            .byte $FF
$73C2  35 00     AND $00,X 
$73C4  01 FD     ORA ($FD,X)
$73C6  3D FF 75  AND $75FF,X 
$73C9  84 04     STY $04 
$73CB            .byte $04
$73CC  55 55     EOR $55,X 
//------------------------------
L_BRS_($73CF)_($738D) BAD
//------------------------------
$73CE  55 FF     EOR $FF,X 
$73D0            .byte $FC,$7F
$73D2  55 FF     EOR $FF,X 
$73D4            .byte $00
$73D5  FE FF FE  INC $FEFF,X 
$73D8            .byte $00
$73D9  81 01     STA ($01,X) 
$73DB            .byte $F8
$73DC  01 01     ORA ($01,X)
$73DE            .byte $FF,$FF,$FF,$00,$FF
$73E3  E0 00     CPX #$00
$73E5            .byte $00
$73E6  FD FD FF  SBC $FFFD,X 
$73E9            .byte $00,$FF,$00
$73EC  81 0F     STA ($0F,X) 
$73EE            .byte $7F,$42
$73F0  40        RTI 
//------------------------------
$73F1            .byte $00,$00,$00,$00,$00,$00,$02,$80
$73F9            .byte $00,$00,$00,$00,$00,$00
$73FF  01 00     ORA ($00,X)
$7401            .byte $FF
$7402  01 FF     ORA ($FF,X)
$7404            .byte $80,$00
$7406  FE 7F 82  INC $827F,X 
$7409  05 66     ORA $66
$740B            .byte $00
$740C  05 FE     ORA $FE
$740E  46 80     LSR $80 
$7410            .byte $FF
$7411  4E FF FF  LSR $FFFF 
$7414            .byte $80,$80
$7416  FE FF FC  INC $FCFF,X 
$7419            .byte $00
$741A  01 FF     ORA ($FF,X)
$741C            .byte $00
$741D  01 84     ORA ($84,X)
$741F  09 01     ORA #$01
$7421  01 01     ORA ($01,X)
$7423  01 00     ORA ($00,X)
$7425            .byte $02
$7426  46 FF     LSR $FF 
$7428            .byte $FF
$7429  FE C0 FF  INC $FFC0,X                          // Open Vector
$742C            .byte $00
//------------------------------
L_BRS_($742E)_($742D) BAD
//------------------------------
$742D  10 FF     BPL L_BRS_($742E)_($742D) BAD
$742F            .byte $04
$7430  78        SEI 
$7431            .byte $3C
$7432  C0 00     CPY #$00
$7434  09 11     ORA #$11
$7436            .byte $FF,$00
$7438  10 80     BPL L_BRS_($73BA)_($7438) JAM
$743A            .byte $FF
$743B  08        PHP 
$743C  70 3C     BVS L_BRS_($747A)_($743C) JAM
$743E            .byte $00,$03,$03
$7441  C0 20     CPY #$20
$7443            .byte $FF,$3F
$7445  1E 00 01  ASL $0100,X 
$7448            .byte $FF
$7449  08        PHP 
$744A            .byte $00
$744B  20 00 F1  JSR L_JSR_($F100)_($744B) OK
$744E            .byte $03,$07,$00
$7451  40        RTI 
//------------------------------
$7452  84 04     STY $04 
$7454            .byte $04,$80,$F8,$00,$00
$7459  F0 0F     BEQ L_BRS_($746A)_($7459) JAM
$745B            .byte $00,$03,$00,$FF,$FF
$7460  C0 F0     CPY #$F0
$7462  81 01     STA ($01,X) 
$7464  C0 01     CPY #$01
$7466  01 00     ORA ($00,X)
//------------------------------
L_BRS_($746A)_($7459) JAM
//------------------------------
$7468            .byte $00,$FF,$00,$FF
$746C  E0 00     CPX #$00
$746E            .byte $00
$746F  05 05     ORA $05
//------------------------------
L_JSR_($7473)_($5E65) BAD
L_JSR_($7473)_($5E7D) BAD
//------------------------------
$7471  FE 00 FF  INC $FF00,X 
$7474            .byte $00
$7475  01 7F     ORA ($7F,X)
$7477            .byte $7F
$7478  88        DEY 
$7479  88        DEY 
//------------------------------
L_BRS_($747A)_($743C) JAM
//------------------------------
$747A            .byte $00
$747B  FE 7E FF  INC $FF7E,X 
$747E  01 01     ORA ($01,X)
//------------------------------
L_BRS_($7481)_($74D0) JAM
//------------------------------
$7480            .byte $02,$02,$02,$FF,$00,$FF
$7486  81 88     STA ($88,X) 
$7488  E0 00     CPX #$00
$748A  91 91     STA ($91),Y 
$748C            .byte $FF
$748D  10 40     BPL L_BRS_($74CF)_($748D) JAM
$748F  11 11     ORA ($11),Y
$7491  C0 08     CPY #$08
$7493            .byte $02,$04,$1C,$14,$14,$FF
$7499  06 07     ASL $07 
$749B            .byte $07,$FF,$80
$749E  40        RTI 
//------------------------------
$749F  40        RTI 
//------------------------------
$74A0  A0 50     LDY #$50
$74A2  0A        ASL A 
$74A3            .byte $00,$FF,$FF,$52
$74A7  2A        ROL A 
$74A8  29 07     AND #$07
$74AA            .byte $0C
//------------------------------
L_BRS_($74AC)_($74AB) BAD
//------------------------------
$74AB  F0 FF     BEQ L_BRS_($74AC)_($74AB) BAD
$74AD  94 8A     STY $8A,X 
$74AF  8A        TXA 
$74B0  4A        LSR A 
$74B1  4A        LSR A 
$74B2  36 3F     ROL $3F,X 
$74B4  09 00     ORA #$00
//------------------------------
L_BRS_($74BA)_($7538) JAM
//------------------------------
$74B6            .byte $00,$80,$00,$FF,$12,$00,$00,$12
$74BE  01 F1     ORA ($F1,X)
$74C0  08        PHP 
$74C1            .byte $00
$74C2  2A        ROL A 
$74C3            .byte $00
$74C4  F1 03     SBC ($03),Y 
$74C6            .byte $07,$00
$74C8  6A        ROR A 
$74C9  84 04     STY $04 
$74CB            .byte $04
$74CC  AA        TAX 
$74CD            .byte $FA
$74CE  AA        TAX 
//------------------------------
L_BRS_($74CF)_($748D) JAM
//------------------------------
$74CF            .byte $00
$74D0  F0 AF     BEQ L_BRS_($7481)_($74D0) JAM
$74D2  AA        TAX 
$74D3            .byte $03,$00,$FF,$FF
$74D7  C0 F0     CPY #$F0
$74D9  81 01     STA ($01,X) 
$74DB  C0 01     CPY #$01
$74DD  01 00     ORA ($00,X)
$74DF            .byte $00,$FF,$00,$FF
$74E3  E0 00     CPX #$00
$74E5            .byte $00
$74E6  05 05     ORA $05
$74E8  FE 00 FF  INC $FF00,X 
$74EB            .byte $00
$74EC  01 7F     ORA ($7F,X)
$74EE            .byte $7F
$74EF  24 80     BIT $80 
$74F1            .byte $00,$00,$00,$00,$00,$00
$74F7  01 80     ORA ($80,X)
$74F9            .byte $00,$00,$00,$00,$00,$00
$74FF  01 00     ORA ($00,X)
$7501            .byte $FF
$7502  01 FC     ORA ($FC,X)
$7504            .byte $80,$00
$7506  F1 80     SBC ($80),Y 
$7508            .byte $02
$7509  05 72     ORA $72
$750B            .byte $00
$750C  FD 01 42  SBC $4201,X 
$750F            .byte $80
$7510  FE 4E FF  INC $FF4E,X 
$7513            .byte $FF,$80,$80,$FF
$7517  FE E0 00  INC $00E0,X 
$751A  01 FF     ORA ($FF,X)
$751C  01 C1     ORA ($C1,X)
$751E            .byte $04
$751F  09 01     ORA #$01
$7521  01 01     ORA ($01,X)
$7523  01 00     ORA ($00,X)
$7525            .byte $02
$7526  41 FF     EOR ($FF,X) 
$7528            .byte $FC,$F8
$752A  C0 FF     CPY #$FF
$752C            .byte $1F
//------------------------------
L_BRS_($752E)_($752D) BAD
//------------------------------
$752D  10 FF     BPL L_BRS_($752E)_($752D) BAD
$752F            .byte $04,$0F
$7531  86 F0     STX $F0 
$7533            .byte $00
$7534  09 11     ORA #$11
$7536  E0 00     CPX #$00
$7538  F0 80     BEQ L_BRS_($74BA)_($7538) JAM
$753A            .byte $FF
$753B  08        PHP 
$753C            .byte $0F,$07,$00,$03,$03,$00
$7542  20 FF 20  JSR L_JSR_($20FF)_($7542) OK
$7545            .byte $03,$00
$7547  01 FF     ORA ($FF,X)
$7549  08        PHP 
$754A            .byte $00
$754B  20 00 FF  JSR L_JSR_($FF00)_($754B) OK
$754E            .byte $FC
$754F  C0 00     CPY #$00
$7551  40        RTI 
//------------------------------
$7552  84 04     STY $04 
$7554            .byte $04,$FF,$0F
$7557  F0 00     BEQ L_BRS_($7559)_($7557) OK
//------------------------------
L_BRS_($7559)_($7557) OK
L_BRS_($755A)_($7559) BAD
//------------------------------
$7559  F0 FF     BEQ L_BRS_($755A)_($7559) BAD
$755B  C0 7E     CPY #$7E
$755D            .byte $00,$FF
$755F  FE 00 FE  INC $FE00,X                          // Set Logical File Parameters/
$7562  81 01     STA ($01,X) 
$7564            .byte $00
$7565  01 01     ORA ($01,X)
$7567            .byte $FF,$00,$FF,$00,$FF
//------------------------------
L_JSR_($756D)_($5E2E) BAD
//------------------------------
$756C  E0 00     CPX #$00
$756E            .byte $00
//------------------------------
L_JSR_($7570)_($4476) BAD
//------------------------------
$756F  FD 05 F8  SBC $F805,X 
$7572            .byte $03,$FF,$00
$7575  01 FF     ORA ($FF,X)
$7577            .byte $7F
$7578  88        DEY 
$7579  88        DEY 
$757A            .byte $00
$757B  FE 7E FF  INC $FF7E,X 
$757E  01 01     ORA ($01,X)
$7580  FE FE 02  INC $02FE,X 
$7583            .byte $FF,$00,$FF,$83
$7587  88        DEY 
$7588            .byte $F8,$80
$758A  91 91     STA ($91),Y 
$758C            .byte $FF
$758D  20 80 11  JSR L_JSR_($1180)_($758D) BAD
$7590  11 F0     ORA ($F0),Y
$7592            .byte $04
$7593  01 04     ORA ($04,X)
$7595            .byte $14,$14,$14
$7598  FE 06 07  INC $0706,X 
$759B            .byte $07,$FF,$80
$759E  40        RTI 
//------------------------------
$759F  A0 A0     LDY #$A0
$75A1  28        PLP 
$75A2  05 00     ORA $00
$75A4            .byte $FF
$75A5  DE 52 2A  DEC $2A52,X 
$75A8  15 03     ORA $03,X
$75AA            .byte $03,$FF,$D4
$75AD  94 8A     STY $8A,X 
$75AF  4A        LSR A 
$75B0  4A        LSR A 
$75B1  49 F6     EOR #$F6
$75B3            .byte $3F,$00,$00,$00,$80,$00,$FF
$75BA  11 00     ORA ($00),Y
$75BC            .byte $00
$75BD  11 01     ORA ($01),Y
$75BF            .byte $FF
$75C0  08        PHP 
$75C1            .byte $00
$75C2  35 00     AND $00,X 
$75C4            .byte $FF,$FC
$75C6  C0 00     CPY #$00
$75C8  55 84     EOR $84,X 
$75CA            .byte $04,$04,$FF,$0F
$75CE  F5 00     SBC $00,X 
//------------------------------
L_BRS_($75D1)_($75D0) BAD
//------------------------------
$75D0  F0 FF     BEQ L_BRS_($75D1)_($75D0) BAD
$75D2  D5 7E     CMP $7E,X 
$75D4            .byte $00,$FF
$75D6  FE 00 FE  INC $FE00,X                          // Set Logical File Parameters/
$75D9  81 01     STA ($01,X) 
$75DB            .byte $00
$75DC  01 01     ORA ($01,X)
$75DE            .byte $FF,$00,$FF,$00,$FF
$75E3  E0 00     CPX #$00
$75E5            .byte $00
$75E6  FD 05 F8  SBC $F805,X 
//------------------------------
L_BRS_($75EA)_($7628) JAM
//------------------------------
$75E9            .byte $03,$FF,$00
$75EC  01 FF     ORA ($FF,X)
$75EE            .byte $7F
$75EF  24 80     BIT $80 
$75F1            .byte $00,$00,$00,$00,$00,$00
$75F7  01 80     ORA ($80,X)
$75F9            .byte $00,$00,$00,$00,$00,$00
$75FF  01 00     ORA ($00,X)
$7601            .byte $FF
$7602  01 F0     ORA ($F0,X)
$7604            .byte $80,$00,$80,$FF,$02
$7609  05 3C     ORA $3C
$760B            .byte $00
$760C  81 FF     STA ($FF,X) 
$760E  24 80     BIT $80 
$7610            .byte $F8
$7611  2C F8 FE  BIT $FEF8 
$7614            .byte $80,$00,$FF
$7617  F0 00     BEQ L_BRS_($7619)_($7617) JAM
//------------------------------
L_BRS_($7619)_($7617) JAM
//------------------------------
$7619            .byte $00
$761A  01 FF     ORA ($FF,X)
$761C  01 F1     ORA ($F1,X)
$761E            .byte $04
$761F  09 01     ORA #$01
$7621            .byte $07
$7622  01 C1     ORA ($C1,X)
$7624            .byte $00,$02
$7626  40        RTI 
//------------------------------
$7627            .byte $FF
$7628  F0 C0     BEQ L_BRS_($75EA)_($7628) JAM
$762A  C0 FC     CPY #$FC
$762C  18        CLC 
//------------------------------
L_BRS_($762E)_($762D) BAD
//------------------------------
$762D  10 FF     BPL L_BRS_($762E)_($762D) BAD
//------------------------------
L_BRS_($762F)_($763D) JAM
//------------------------------
$762F            .byte $04,$00
$7631  71 FC     ADC ($FC),Y 
$7633            .byte $00
$7634  09 11     ORA #$11
$7636            .byte $00,$1F
//------------------------------
L_BRS_($7638)_($76B6) OK
//------------------------------
$7638  0E 80 FF  ASL $FF80                          // Kernal Version Number
$763B  08        PHP 
$763C            .byte $00
$763D  F0 F0     BEQ L_BRS_($762F)_($763D) JAM
$763F            .byte $03,$03,$00,$F8,$FF
$7644  20 00 F0  JSR L_JSR_($F000)_($7644) JAM
$7647  01 FF     ORA ($FF,X)
$7649  08        PHP 
$764A            .byte $00
$764B  20 00 FF  JSR L_JSR_($FF00)_($764B) OK
$764E            .byte $03
$764F  78        SEI 
$7650            .byte $00
$7651  40        RTI 
//------------------------------
$7652  84 04     STY $04 
$7654            .byte $04,$FF
$7656  C0 0E     CPY #$0E
$7658            .byte $0F
$7659  C0 FF     CPY #$FF
$765B  7E C0 00  ROR $00C0,X 
$765E            .byte $FF,$FC,$00,$FF
$7662  81 01     STA ($01,X) 
$7664            .byte $00
$7665  01 81     ORA ($81,X)
$7667            .byte $00,$00,$FF,$00
$766B  E0 E0     CPX #$E0
$766D            .byte $00,$02
$766F  01 05     ORA ($05,X)
$7671  C0 03     CPY #$03
$7673            .byte $00,$00
$7675  01 FF     ORA ($FF,X)
$7677            .byte $7F
$7678  88        DEY 
$7679  88        DEY 
$767A            .byte $00,$FF
$767C  7E 00 01  ROR $0100,X 
$767F  01 00     ORA ($00,X)
$7681            .byte $00,$02,$FF
$7684  C0 FF     CPY #$FF
$7686            .byte $87
$7687  88        DEY 
$7688  FE C0 91  INC $91C0,X 
$768B  91 FF     STA ($FF),Y 
$768D  20 80 11  JSR L_JSR_($1180)_($768D) BAD
$7690  11 F8     ORA ($F8),Y
$7692            .byte $04
$7693  01 04     ORA ($04,X)
//------------------------------
L_BRS_($7695)_($7713) JAM
//------------------------------
$7695            .byte $14,$14,$F4,$02
$7699  06 07     ASL $07 
$769B            .byte $07,$FF,$80
$769E  40        RTI 
//------------------------------
$769F  A0 50     LDY #$50
$76A1  28        PLP 
$76A2  05 00     ORA $00
$76A4            .byte $FF
$76A5  DE 52 29  DEC $2952,X 
$76A8  15 01     ORA $01,X
$76AA            .byte $00,$FF
$76AC  94 94     STY $94,X 
$76AE  8A        TXA 
$76AF  4A        LSR A 
$76B0  4A        LSR A 
$76B1  A5 36     LDA $36 
$76B3            .byte $1F
$76B4  F0 00     BEQ L_BRS_($76B6)_($76B4) OK
//------------------------------
L_BRS_($76B6)_($76B4) OK
//------------------------------
$76B6  30 80     BMI L_BRS_($7638)_($76B6) OK
$76B8            .byte $00,$FF
$76BA  11 00     ORA ($00),Y
$76BC            .byte $80
$76BD  11 01     ORA ($01),Y
$76BF            .byte $FF
$76C0  08        PHP 
$76C1            .byte $00
$76C2  2A        ROL A 
$76C3            .byte $00,$FF,$AB
$76C6  78        SEI 
$76C7            .byte $00
$76C8  6A        ROR A 
$76C9  84 04     STY $04 
$76CB            .byte $04,$FF
$76CD  C0 0E     CPY #$0E
$76CF            .byte $0F
$76D0  C0 FF     CPY #$FF
$76D2  7E C0 00  ROR $00C0,X 
$76D5            .byte $FF,$FC,$00,$FF
$76D9  81 01     STA ($01,X) 
$76DB            .byte $00
$76DC  01 81     ORA ($81,X)
$76DE            .byte $00,$00,$FF,$00
$76E2  E0 E0     CPX #$E0
$76E4            .byte $00,$02
$76E6  01 05     ORA ($05,X)
$76E8  C0 03     CPY #$03
$76EA            .byte $00,$00
$76EC  01 FF     ORA ($FF,X)
$76EE            .byte $7F,$14,$80,$00,$00,$00,$00,$00
$76F6            .byte $00
$76F7  01 81     ORA ($81,X)
$76F9  81 81     STA ($81,X) 
$76FB  81 81     STA ($81,X) 
$76FD  81 81     STA ($81,X) 
$76FF  81 00     STA ($00,X) 
$7701            .byte $FF,$FF,$80,$7F,$FF,$80,$FF,$7F
$7709  FE 18 07  INC $0718,X 
$770C            .byte $7F,$FF
$770E  18        CLC 
$770F            .byte $FF,$80
$7711  18        CLC 
$7712            .byte $80
$7713  F0 80     BEQ L_BRS_($7695)_($7713) JAM
$7715            .byte $00,$FF,$80,$00
$7719  01 01     ORA ($01,X)
$771B            .byte $FF
$771C  01 FD     ORA ($FD,X)
$771E            .byte $7F
$771F  FE 01 FF  INC $FF01,X 
$7722            .byte $FF
$7723  F1 00     SBC ($00),Y 
$7725            .byte $02
$7726  40        RTI 
//------------------------------
$7727            .byte $FF
$7728  C0 C0     CPY #$C0
$772A            .byte $BF,$80,$1F
//------------------------------
L_BRS_($772E)_($772D) BAD
//------------------------------
$772D  10 FF     BPL L_BRS_($772E)_($772D) BAD
$772F            .byte $04,$00
$7731  0E FF 00  ASL $00FF 
$7734            .byte $7F
$7735  FE 00 1C  INC $1C00,X 
$7738  01 80     ORA ($80,X)
$773A            .byte $FF
$773B  08        PHP 
$773C            .byte $00
$773D  0E 1E 03  ASL $031E 
$7740            .byte $03,$00,$07,$FF
$7744  20 00 0F  JSR L_JSR_($0F00)_($7744) BAD
$7747  01 FF     ORA ($FF,X)
$7749            .byte $FF,$00
$774B  20 00 FF  JSR L_JSR_($FF00)_($774B) OK
$774E            .byte $00
$774F  0E 07 40  ASL $4007 
$7752  84 04     STY $04 
$7754            .byte $04,$FF
$7756  7E 01 F8  ROR $F801,X 
$7759            .byte $80,$FF,$03,$00,$00,$FF
$775F  E0 00     CPX #$00
$7761            .byte $FF
$7762  81 01     STA ($01,X) 
$7764            .byte $00
$7765  01 FF     ORA ($FF,X)
$7767            .byte $FF,$00
$7769  FE 00 FF  INC $FF00,X 
$776C            .byte $FF,$00
//------------------------------
L_JSR_($776F)_($8DEC) BAD
L_JSR_($776F)_($CC77) BAD
//------------------------------
$776E  05 FD     ORA $FD
$7770  05 00     ORA $00
$7772            .byte $03,$FF,$FF
$7775  01 FF     ORA ($FF,X)
$7777            .byte $00
$7778  88        DEY 
$7779  88        DEY 
$777A            .byte $FF,$FF,$00,$FF
$777E  01 07     ORA ($07,X)
$7780  FE FE 02  INC $02FE,X 
$7783            .byte $FF
$7784  C0 FF     CPY #$FF
$7786  84 88     STY $88 
$7788            .byte $FF
$7789  C0 91     CPY #$91
$778B  91 7F     STA ($7F),Y 
$778D  20 80 11  JSR L_JSR_($1180)_($778D) BAD
$7790  11 F8     ORA ($F8),Y
$7792            .byte $04
$7793  01 FC     ORA ($FC,X)
$7795            .byte $14,$14,$FC
$7798  FE 06 07  INC $0706,X 
$779B            .byte $07,$FF,$80
$779E  40        RTI 
//------------------------------
$779F  A0 50     LDY #$50
$77A1  28        PLP 
$77A2            .byte $02,$00,$FF,$D2,$52
$77A7  29 15     AND #$15
$77A9  81 00     STA ($00,X) 
$77AB            .byte $FF
$77AC  94 94     STY $94,X 
$77AE  8A        TXA 
$77AF  4A        LSR A 
$77B0  4A        LSR A 
$77B1  A5 3E     LDA $3E 
$77B3            .byte $1F,$FF,$00
$77B6  60        RTS 
//------------------------------
$77B7            .byte $80,$00,$FF
$77BA  11 00     ORA ($00),Y
$77BC  40        RTI 
//------------------------------
$77BD  11 01     ORA ($01),Y
$77BF            .byte $FF,$FF,$00
$77C2  35 00     AND $00,X 
$77C4            .byte $FF
$77C5  55 AE     EOR $AE,X 
$77C7            .byte $07
$77C8  55 84     EOR $84,X 
$77CA            .byte $04,$04,$FF
$77CD  7E 01 F8  ROR $F801,X 
$77D0            .byte $80,$FF,$03,$00,$00,$FF
$77D6  E0 00     CPX #$00
$77D8            .byte $FF
$77D9  81 01     STA ($01,X) 
$77DB            .byte $00
$77DC  01 FF     ORA ($FF,X)
$77DE            .byte $FF,$00
$77E0  FE 00 FF  INC $FF00,X 
$77E3            .byte $FF,$00
$77E5  05 FD     ORA $FD
$77E7  05 00     ORA $00
$77E9            .byte $03,$FF,$FF
$77EC  01 FF     ORA ($FF,X)
$77EE            .byte $00
$77EF  08        PHP 
$77F0  40        RTI 
//------------------------------
$77F1            .byte $00,$00,$00,$00,$00,$00,$02
$77F8  7E 7E 7E  ROR $7E7E,X 
$77FB  7E 7E 7E  ROR $7E7E,X 
$77FE  7E 7E 01  ROR $017E,X 
$7801  0D 1D 2B  ORA $2B1D
$7804            .byte $2B,$2B,$2B,$2B
$7808  60        RTS 
//------------------------------
$7809            .byte $67
//------------------------------
L_JSR_($780C)_($AD2C) BAD
L_JSR_($780C)_($E9A5) BAD
//------------------------------
$780A  4D 2B 2B  EOR $2B2B 
$780D            .byte $2B,$2B,$2B,$8B,$93,$2B,$2B,$2B
$7815            .byte $2B,$2B,$2B,$2B,$2B,$2B,$2B,$2B
$781D            .byte $2B,$2B,$2B
$7820  01 01     ORA ($01,X)
$7822  01 01     ORA ($01,X)
$7824  01 01     ORA ($01,X)
$7826  01 01     ORA ($01,X)
$7828  2A        ROL A 
$7829  01 01     ORA ($01,X)
$782B  01 01     ORA ($01,X)
$782D  01 01     ORA ($01,X)
$782F  01 01     ORA ($01,X)
$7831  01 01     ORA ($01,X)
$7833  01 01     ORA ($01,X)
$7835  01 01     ORA ($01,X)
$7837  01 01     ORA ($01,X)
$7839  51 01     EOR ($01),Y 
$783B  01 01     ORA ($01,X)
$783D  01 01     ORA ($01,X)
$783F  01 01     ORA ($01,X)
$7841  01 01     ORA ($01,X)
$7843  01 01     ORA ($01,X)
$7845  01 01     ORA ($01,X)
$7847  01 01     ORA ($01,X)
$7849  01 28     ORA ($28,X)
$784B            .byte $47
$784C  01 01     ORA ($01,X)
$784E  01 01     ORA ($01,X)
$7850  01 69     ORA ($69,X)
$7852  71 75     ADC ($75),Y 
$7854            .byte $7B
$7855  84 00     STY $00 
$7857            .byte $00,$00,$00,$00,$00,$00,$00,$00
$785F            .byte $00
$7860  40        RTI 
//------------------------------
$7861            .byte $2B
$7862  11 00     ORA ($00),Y
//------------------------------
L_JMP_($7865)_($5234) JAM
//------------------------------
$7864            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($786E)_($78E4) JAM
//------------------------------
$786C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7874            .byte $00,$00,$00,$00,$00
$7879  18        CLC 
$787A  48        PHA 
$787B            .byte $00,$00,$00,$00,$00,$03,$03,$03
$7883            .byte $03,$03,$03,$03,$03,$07,$07,$07
$788B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7893            .byte $07,$07,$07,$07,$07,$07,$07,$07
$789B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$78A3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$78AB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$78B3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$78BB            .byte $07,$07,$07,$07,$07,$07,$07,$07
//------------------------------
L_BRS_($78C4)_($78F8) JAM
//------------------------------
$78C3            .byte $07,$07,$07,$07
$78C7  0D 0D 0D  ORA $0D0D
$78CA  0D 0D 07  ORA $070D
$78CD            .byte $07,$07,$07,$07,$07,$07,$07,$23
$78D5            .byte $23,$03,$03,$03,$03,$03,$03,$03
$78DD            .byte $03,$03,$03
$78E0  AA        TAX 
$78E1  AA        TAX 
$78E2            .byte $92
$78E3  9A        TXS 
$78E4  B0 88     BCS L_BRS_($786E)_($78E4) JAM
$78E6  9A        TXS 
$78E7            .byte $92
$78E8  A2 9A     LDX #$9A
$78EA            .byte $92,$92
$78EC  88        DEY 
$78ED            .byte $92
$78EE  88        DEY 
$78EF  9A        TXS 
$78F0            .byte $92
$78F1  9A        TXS 
$78F2  A2 C4     LDX #$C4
$78F4  C4 C4     CPY $C4 
$78F6  C6 B0     DEC $B0 
$78F8  B0 CA     BCS L_BRS_($78C4)_($78F8) JAM
$78FA  C4 C4     CPY $C4 
$78FC  CC CC B0  CPY $B0CC 
$78FF  C4 02     CPY $02 
$7901  0E 0E 2C  ASL $2C0E 
$7904  0D 2B 2B  ORA $2B2B
$7907            .byte $2B
$7908  61 68     ADC ($68,X) 
$790A            .byte $6B,$6F,$74,$2B,$2B,$2B
$7910  8C 94 9B  STY $9B94 
$7913            .byte $93,$2B,$2B,$2B,$2B,$2B,$2B,$2B
$791B            .byte $2B,$2B,$2B,$2B,$2B
$7920  01 01     ORA ($01,X)
$7922  01 01     ORA ($01,X)
$7924  01 01     ORA ($01,X)
$7926  01 01     ORA ($01,X)
$7928            .byte $2B,$32
$792A  01 01     ORA ($01,X)
$792C  01 01     ORA ($01,X)
$792E  01 01     ORA ($01,X)
$7930  01 01     ORA ($01,X)
$7932  01 01     ORA ($01,X)
$7934  01 01     ORA ($01,X)
$7936  01 01     ORA ($01,X)
$7938  4C 52 01  JMP $0152
$793B  01 01     ORA ($01,X)
$793D  01 01     ORA ($01,X)
$793F  01 01     ORA ($01,X)
$7941  01 01     ORA ($01,X)
$7943  01 01     ORA ($01,X)
$7945  01 01     ORA ($01,X)
$7947  01 28     ORA ($28,X)
$7949            .byte $33,$3F
$794B  48        PHA 
$794C  01 01     ORA ($01,X)
$794E  01 5F     ORA ($5F,X)
$7950            .byte $64
$7951  6A        ROR A 
$7952            .byte $72
$7953  76 01     ROR $01,X 
$7955  85 89     STA $89 
$7957            .byte $00,$00,$00,$00,$00,$00,$00,$00
$795F            .byte $00
$7960  C0 2C     CPY #$2C
$7962  11 00     ORA ($00),Y
$7964            .byte $00,$00,$00,$00,$00,$00,$00,$00
$796C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7974            .byte $00,$00,$00,$00,$00
$7979  18        CLC 
$797A  48        PHA 
$797B            .byte $00,$00,$00,$00,$00,$03,$03,$03
$7983            .byte $03,$03,$03,$03,$03,$07,$07,$07
$798B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7993            .byte $07,$07,$07,$07,$07,$07,$07,$07
$799B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$79A3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$79AB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$79B3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$79BB            .byte $07
$79BC  0D 0D 0D  ORA $0D0D
$79BF  0D 07 07  ORA $0707
$79C2            .byte $07,$07,$07,$07,$07
$79C7  0D 0D 0D  ORA $0D0D
$79CA  0D 0D 07  ORA $070D
$79CD            .byte $07,$07,$07,$07,$07,$27,$27,$27
$79D5            .byte $23,$23,$03,$03,$03,$03,$03,$03
$79DD            .byte $03,$03,$03
$79E0  AA        TAX 
$79E1  AA        TAX 
$79E2            .byte $92
$79E3  9A        TXS 
$79E4            .byte $92
$79E5  88        DEY 
$79E6  A2 A2     LDX #$A2
$79E8            .byte $92
$79E9  9A        TXS 
$79EA  88        DEY 
$79EB  88        DEY 
$79EC            .byte $92
$79ED  A2 9A     LDX #$9A
$79EF  A2 92     LDX #$92
$79F1  9A        TXS 
$79F2  88        DEY 
$79F3  C4 C4     CPY $C4 
$79F5  C4 C6     CPY $C6 
$79F7  C6 B0     DEC $B0 
$79F9  CA        DEX 
$79FA  C4 C4     CPY $C4 
$79FC  CE CE C6  DEC $C6CE 
$79FF  B0 02     BCS L_BRS_($7A03)_($79FF) BAD
$7A01            .byte $0F
//------------------------------
L_BRS_($7A03)_($79FF) BAD
//------------------------------
$7A02  1E 2D 0E  ASL $0E2D,X 
$7A05  0E 55 00  ASL $0055 
$7A08            .byte $62
$7A09  69 0E     ADC #$0E
$7A0B  0E 0E 02  ASL $020E 
$7A0E            .byte $00,$00,$00
$7A11  69 0E     ADC #$0E
$7A13  0E 02 34  ASL $3402 
$7A16  6A        ROR A 
$7A17            .byte $00,$34
$7A19  6A        ROR A 
$7A1A            .byte $00,$34
$7A1C  6A        ROR A 
$7A1D            .byte $00,$34
$7A1F  6A        ROR A 
$7A20            .byte $00
$7A21  08        PHP 
$7A22  0D 00 08  ORA $0800
$7A25  0D 00 08  ORA $0800
$7A28  2C 33 08  BIT $0833 
$7A2B  0D 00 08  ORA $0800
$7A2E  0D 46 08  ORA $0846
$7A31  0D 68 08  ORA $0868
$7A34  0D 00 08  ORA $0800
$7A37  0D 14 52  ORA $5214
$7A3A  56 0D     LSR $0D,X 
$7A3C            .byte $00
$7A3D  08        PHP 
$7A3E  0D 00 02  ORA $0200
$7A41            .byte $00,$0F,$02,$00,$0F,$02,$00,$14
$7A49            .byte $00
$7A4A  40        RTI 
//------------------------------
$7A4B            .byte $00,$00,$00
$7A4E  11 14     ORA ($14),Y
$7A50            .byte $00,$00
$7A52  40        RTI 
//------------------------------
$7A53            .byte $00,$00,$00,$14,$00,$00,$00,$00
$7A5B            .byte $00,$00,$00,$00,$00
$7A60  40        RTI 
//------------------------------
$7A61  2D 11 00  AND $0011 
//------------------------------
L_JSR_($7A69)_($5787) JAM
//------------------------------
$7A64            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7A6C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7A74            .byte $00,$00,$00,$00,$00
$7A79  18        CLC 
$7A7A  48        PHA 
$7A7B            .byte $00,$00,$00,$00,$00,$03,$03,$03
$7A83            .byte $03,$03
$7A85  0E 2E 0E  ASL $0E2E 
$7A88  6E 07 07  ROR $0707 
$7A8B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7A93            .byte $07,$07,$03,$03,$07,$03,$03,$07
$7A9B            .byte $03,$03,$07,$03,$03,$07,$03,$03
$7AA3            .byte $07,$03,$03,$07,$03,$03,$07,$03
$7AAB            .byte $03,$07,$03,$03,$67,$03,$03,$27
$7AB3            .byte $03,$03,$07,$03,$03,$07,$07,$03
$7ABB            .byte $03
$7ABC  0D 03 03  ORA $0303
$7ABF  0D 03 0D  ORA $0D03
$7AC2            .byte $03,$03
$7AC4  0D 03 03  ORA $0303
$7AC7  0D 0D 0D  ORA $0D0D
$7ACA  0D 07 07  ORA $0707
$7ACD            .byte $07,$67,$07,$07,$07,$07,$07,$07
$7AD5            .byte $07,$03,$03,$03,$03,$03,$03,$03
$7ADD            .byte $03,$03,$03
$7AE0  AA        TAX 
$7AE1  AA        TAX 
$7AE2            .byte $92
$7AE3  9A        TXS 
$7AE4            .byte $92
$7AE5  88        DEY 
$7AE6  9A        TXS 
$7AE7            .byte $92
$7AE8  88        DEY 
$7AE9  9A        TXS 
$7AEA  A2 9A     LDX #$9A
$7AEC  88        DEY 
$7AED  9A        TXS 
$7AEE  88        DEY 
$7AEF  9A        TXS 
$7AF0  88        DEY 
$7AF1  9A        TXS 
$7AF2  A2 C4     LDX #$C4
$7AF4  C4 C4     CPY $C4 
$7AF6  C6 C8     DEC $C8 
$7AF8  C6 CA     DEC $CA 
$7AFA  C4 C4     CPY $C4 
$7AFC  CE CE C8  DEC $C8CE 
$7AFF  C4 02     CPY $02 
$7B01  10 1F     BPL L_BRS_($7B22)_($7B01) JAM
$7B03  2E 3C 4A  ROL $4A3C 
$7B06  56 4B     LSR $4B,X 
$7B08            .byte $63
$7B09  69 0E     ADC #$0E
$7B0B  0E 0E 02  ASL $020E 
$7B0E            .byte $00,$34
$7B10  65 69     ADC $69 
$7B12  0E A3 AE  ASL $AEA3 
$7B15  B4 B7     LDY $B7,X 
$7B17  BD C2 4A  LDA $4AC2,X 
$7B1A  56 4B     LSR $4B,X 
$7B1C  CC CF D4  CPY $D4CF 
$7B1F  D9 02 00  CMP $0002,Y 
//------------------------------
L_BRS_($7B22)_($7B01) JAM
//------------------------------
$7B22            .byte $00,$0F
$7B24  16 1C     ASL $1C,X 
$7B26            .byte $23,$17
$7B28  2D 34 CE  AND $CE34 
$7B2B  CD CC CB  CMP $CBCC 
$7B2E  CA        DEX 
$7B2F  C9 C8     CMP #$C8
$7B31            .byte $C7,$00,$00,$00,$00,$00,$00,$14
$7B39            .byte $52,$00,$5A
$7B3C  65 6F     ADC $6F 
$7B3E            .byte $72
$7B3F  75 00     ADC $00,X 
$7B41            .byte $00,$00,$00,$00,$00,$00,$00,$14
$7B49            .byte $00
$7B4A  40        RTI 
//------------------------------
$7B4B  49 02     EOR #$02
$7B4D            .byte $00,$00,$14,$00,$00
$7B52  40        RTI 
//------------------------------
$7B53            .byte $77,$7C,$00,$14,$00,$00,$00,$00
$7B5B            .byte $00,$00,$00,$00,$00
$7B60  C0 2E     CPY #$2E
$7B62  11 00     ORA ($00),Y
$7B64            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7B6C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7B74            .byte $00,$00,$00,$00,$00
$7B79  18        CLC 
$7B7A  48        PHA 
$7B7B            .byte $00,$00,$00,$00,$00,$03,$03,$03
$7B83            .byte $03,$03,$0F,$0F,$0F,$0F,$07,$07
$7B8B            .byte $07,$07,$07,$07,$03,$03,$07,$07
$7B93            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7B9B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7BA3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7BAB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7BB3            .byte $07,$07,$07,$07,$07,$07,$07
$7BBA  0D 01 01  ORA $0101
$7BBD  01 01     ORA ($01,X)
//------------------------------
L_BRS_($7BBF)_($7BF7) OK
//------------------------------
$7BBF  01 0D     ORA ($0D,X)
$7BC1  0D 0D 0D  ORA $0D0D
$7BC4  0D 0D 0D  ORA $0D0D
$7BC7  0D 0D 0D  ORA $0D0D
$7BCA  0D 03 03  ORA $0303
$7BCD            .byte $07,$07,$07,$07,$07,$07,$0F,$0F
$7BD5            .byte $07,$03,$03,$03,$03,$03,$03,$03
$7BDD            .byte $03,$03,$03
$7BE0  AA        TAX 
$7BE1  AA        TAX 
$7BE2            .byte $92
$7BE3  A2 92     LDX #$92
$7BE5            .byte $92
$7BE6  9A        TXS 
$7BE7  A2 9A     LDX #$9A
$7BE9  A2 9A     LDX #$9A
$7BEB            .byte $92,$92
$7BED  88        DEY 
$7BEE  88        DEY 
$7BEF  A2 92     LDX #$92
$7BF1  9A        TXS 
$7BF2  88        DEY 
$7BF3  C4 C4     CPY $C4 
$7BF5  C4 C8     CPY $C8 
$7BF7  B0 C6     BCS L_BRS_($7BBF)_($7BF7) OK
$7BF9  C6 C8     DEC $C8 
$7BFB  C4 CE     CPY $CE 
$7BFD  CE CA C6  DEC $C6CA 
$7C00            .byte $02
$7C01  11 20     ORA ($20),Y
$7C03            .byte $2F
$7C04  3D 4B 4B  AND $4B4B,X 
$7C07  56 63     LSR $63,X 
$7C09  69 0E     ADC #$0E
$7C0B  0E 0E 02  ASL $020E 
$7C0E            .byte $00,$34
$7C10  65 69     ADC $69 
$7C12  0E A4 AF  ASL $AFA4 
$7C15  B5 B8     LDA $B8,X 
$7C17            .byte $63,$4B
$7C19  C6 C8     DEC $C8 
$7C1B  CA        DEX 
$7C1C  CD D0 D5  CMP $D5D0 
$7C1F  D5 03     CMP $03,X 
$7C21            .byte $00,$00
$7C23  10 17     BPL L_BRS_($7C3C)_($7C23) OK
$7C25            .byte $1C
$7C26  24 23     BIT $23 
$7C28  2D 34 C6  AND $C634 
$7C2B  C5 C4     CMP $C4 
$7C2D            .byte $C3,$C2
$7C2F  C1 C0     CMP ($C0,X) 
$7C31            .byte $BF,$00,$00,$00,$00,$00,$00,$14
$7C39            .byte $52,$00,$5B
//------------------------------
L_BRS_($7C3C)_($7C23) OK
//------------------------------
$7C3C  66 70     ROR $70 
$7C3E            .byte $73
$7C3F  76 00     ROR $00,X 
$7C41            .byte $00,$00,$00,$00,$00,$00,$00,$14
$7C49            .byte $00
$7C4A  40        RTI 
//------------------------------
$7C4B  49 02     EOR #$02
$7C4D            .byte $00,$00,$14,$00,$00
$7C52  40        RTI 
//------------------------------
$7C53            .byte $77,$7C,$00,$14,$00,$00,$00,$00
$7C5B            .byte $00,$00,$00,$00,$00
$7C60  40        RTI 
//------------------------------
$7C61            .byte $80
$7C62  11 00     ORA ($00),Y
$7C64            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7C6C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7C74            .byte $00,$00,$00,$00,$00
$7C79  18        CLC 
$7C7A  48        PHA 
$7C7B            .byte $00,$00,$00,$00,$00,$03,$03,$03
//------------------------------
L_BRS_($7C89)_($7CE5) JAM
//------------------------------
$7C83            .byte $03,$03,$0F,$0F,$0F,$0F,$07,$07
$7C8B            .byte $07,$07,$07,$07,$03,$03,$07,$07
$7C93            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7C9B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7CA3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7CAB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7CB3            .byte $07,$07,$07,$07,$07,$07,$07
$7CBA  0D 01 01  ORA $0101
$7CBD  01 01     ORA ($01,X)
$7CBF  01 0D     ORA ($0D,X)
$7CC1  0D 0D 0D  ORA $0D0D
$7CC4  0D 0D 0D  ORA $0D0D
$7CC7  0D 0D 0D  ORA $0D0D
$7CCA  0D 03 03  ORA $0303
$7CCD            .byte $07,$07,$07,$07,$07,$07,$0F,$0F
$7CD5            .byte $07,$03,$03,$03,$03,$03,$03,$03
$7CDD            .byte $03,$03,$03
$7CE0  AA        TAX 
$7CE1  AA        TAX 
$7CE2            .byte $92
$7CE3  A2 A2     LDX #$A2
$7CE5  B0 A2     BCS L_BRS_($7C89)_($7CE5) JAM
$7CE7            .byte $92
$7CE8  88        DEY 
$7CE9            .byte $92
$7CEA  A2 88     LDX #$88
$7CEC  9A        TXS 
$7CED            .byte $92
$7CEE  A2 9A     LDX #$9A
$7CF0  A2 9A     LDX #$9A
$7CF2  A2 C4     LDX #$C4
$7CF4  C4 C4     CPY $C4 
$7CF6  C8        INY 
$7CF7  C6 CA     DEC $CA 
$7CF9  C8        INY 
$7CFA  C8        INY 
$7CFB  C4 CE     CPY $CE 
$7CFD  CE B0 C8  DEC $C8B0 
$7D00            .byte $02
$7D01  0E 21 30  ASL $3021 
$7D04  3E 4C 57  ROL $574C,X 
$7D07            .byte $5B,$64
$7D09  69 0E     ADC #$0E
$7D0B  0E 0E 02  ASL $020E 
$7D0E            .byte $00,$00,$00
$7D11  69 0E     ADC #$0E
$7D13  A5 B0     LDA $B0 
$7D15  B6 B9     LDX $B9,Y 
$7D17  BE C3 C7  LDX $C7C3,Y 
$7D1A  C9 CB     CMP #$CB
$7D1C  CE D1 D6  DEC $D6D1 
$7D1F            .byte $DA,$03,$00,$00
$7D23  11 17     ORA ($17),Y
$7D25            .byte $17,$23,$17
$7D28  24 34     BIT $34 
$7D2A  01 01     ORA ($01,X)
$7D2C  01 01     ORA ($01,X)
$7D2E  01 37     ORA ($37,X)
$7D30  3D 42 3D  AND $3D42,X 
$7D33  48        PHA 
$7D34  3D 48 3D  AND $3D48,X 
$7D37  48        PHA 
$7D38  3D 48 00  AND $0048,X 
$7D3B            .byte $5C,$67,$00,$74,$77,$03
$7D41  08        PHP 
$7D42  10 08     BPL L_BRS_($7D4C)_($7D42) JAM
$7D44            .byte $12
$7D45  08        PHP 
$7D46            .byte $17
$7D47  1E 29 34  ASL $3429,X 
$7D4A  40        RTI 
//------------------------------
L_BRS_($7D4C)_($7D42) JAM
//------------------------------
$7D4B            .byte $00,$00,$00,$00,$14,$00,$00
$7D52  40        RTI 
//------------------------------
$7D53  78        SEI 
$7D54  78        SEI 
$7D55  78        SEI 
$7D56  8A        TXA 
$7D57            .byte $8F,$8F,$8F,$8F,$8F,$8F,$8F
$7D5E  BA        TSX 
$7D5F  BC C0 2F  LDY $2FC0,X 
$7D62  11 00     ORA ($00),Y
$7D64            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7D6C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7D74            .byte $00,$00,$00,$00,$00
$7D79  18        CLC 
$7D7A            .byte $00,$00,$00,$00,$00,$00,$03,$03
$7D82            .byte $03,$03,$03
$7D85  0E 0E 0E  ASL $0E0E 
$7D88  0E 07 07  ASL $0707 
$7D8B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7D93            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7D9B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7DA3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7DAB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7DB3            .byte $07,$07,$07,$07,$07,$07,$07
$7DBA  0D 01 01  ORA $0101
$7DBD  01 01     ORA ($01,X)
$7DBF  01 0D     ORA ($0D,X)
$7DC1  0D 0D 0D  ORA $0D0D
$7DC4  0D 0D 0D  ORA $0D0D
$7DC7  0D 0D 0D  ORA $0D0D
$7DCA  0D 07 07  ORA $0707
$7DCD            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7DD5            .byte $07,$03,$03,$03,$03,$03,$03,$03
$7DDD            .byte $03,$03,$03
$7DE0  AA        TAX 
$7DE1  AA        TAX 
$7DE2  9A        TXS 
$7DE3  A2 A2     LDX #$A2
$7DE5            .byte $92
$7DE6  A2 A2     LDX #$A2
$7DE8  9A        TXS 
//------------------------------
L_BRS_($7DE9)_($7E57) OK
//------------------------------
$7DE9  A2 9A     LDX #$9A
//------------------------------
L_BRS_($7DEB)_($7E59) OK
//------------------------------
$7DEB  9A        TXS 
$7DEC  88        DEY 
//------------------------------
L_BRS_($7DED)_($7E5B) OK
//------------------------------
$7DED  A2 92     LDX #$92
//------------------------------
L_BRS_($7DEF)_($7E5D) OK
//------------------------------
$7DEF  9A        TXS 
$7DF0  A2 9A     LDX #$9A
$7DF2  88        DEY 
$7DF3  C4 C4     CPY $C4 
$7DF5  C4 C8     CPY $C8 
$7DF7  CA        DEX 
$7DF8  C8        INY 
$7DF9  C6 CA     DEC $CA 
$7DFB  C4 CE     CPY $CE 
$7DFD  CE C6 CA  DEC $CAC6 
//------------------------------
L_JSR_($7E00)_($AD34) JAM
L_JSR_($7E00)_($E9AD) JAM
//------------------------------
$7E00            .byte $02
$7E01  0E 22 31  ASL $3122 
$7E04            .byte $3F
$7E05  09 58     ORA #$58
$7E07            .byte $5C,$00
$7E09  69 0E     ADC #$0E
$7E0B  0E 0E 02  ASL $020E 
$7E0E            .byte $00,$00,$00
$7E11  69 0E     ADC #$0E
$7E13  A6 15     LDX $15 
$7E15  15 15     ORA $15,X
$7E17  15 15     ORA $15,X
$7E19  15 15     ORA $15,X
$7E1B  15 15     ORA $15,X
$7E1D  15 15     ORA $15,X
$7E1F  15 03     ORA $03,X
$7E21            .byte $00,$00,$12
$7E24  15 15     ORA $15,X
$7E26  15 15     ORA $15,X
$7E28  15 34     ORA $34,X
$7E2A            .byte $00,$00,$00,$00,$00
$7E2F  38        SEC 
$7E30  3E 43 3E  ROL $3E43,X 
$7E33            .byte $43
$7E34  3E 43 3E  ROL $3E43,X 
$7E37            .byte $43
$7E38  3E 43 00  ROL $0043,X 
$7E3B            .byte $00,$00,$00,$00,$00,$04
$7E41  09 04     ORA #$04
$7E43  09 04     ORA #$04
$7E45  09 04     ORA #$04
$7E47            .byte $1F
$7E48  2A        ROL A 
$7E49  35 40     AND $40,X 
$7E4B            .byte $00,$00,$00,$00,$14,$00,$00
$7E52  40        RTI 
//------------------------------
$7E53  79 79 79  ADC $7979,Y 
$7E56            .byte $8B
$7E57  90 90     BCC L_BRS_($7DE9)_($7E57) OK
$7E59  90 90     BCC L_BRS_($7DEB)_($7E59) OK
$7E5B  90 90     BCC L_BRS_($7DED)_($7E5B) OK
$7E5D  90 90     BCC L_BRS_($7DEF)_($7E5D) OK
$7E5F  BD 40 31  LDA $3140,X 
$7E62  11 00     ORA ($00),Y
$7E64            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7E6C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7E74            .byte $00,$00,$00,$00,$00
$7E79  18        CLC 
$7E7A            .byte $00,$00,$00,$00,$00,$00,$03,$03
$7E82            .byte $03,$03,$03
$7E85  0E 0E 0E  ASL $0E0E 
$7E88  0E 07 07  ASL $0707 
$7E8B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7E93            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7E9B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7EA3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7EAB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7EB3            .byte $07,$07,$07,$07,$07,$07,$07
$7EBA  0D 0D 0D  ORA $0D0D
$7EBD  0D 0D 0D  ORA $0D0D
//------------------------------
L_BRS_($7EC1)_($7EF7) BAD
//------------------------------
$7EC0  0D 0D 0D  ORA $0D0D
$7EC3  0D 0D 0D  ORA $0D0D
$7EC6  0D 0D 0D  ORA $0D0D
$7EC9  0D 0D 07  ORA $070D
$7ECC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7ED4            .byte $07,$07,$03,$03,$03,$03,$03,$03
$7EDC            .byte $03,$03,$03,$03
$7EE0  AA        TAX 
$7EE1  AA        TAX 
$7EE2  9A        TXS 
$7EE3  A2 9A     LDX #$9A
$7EE5            .byte $92
$7EE6  9A        TXS 
$7EE7  9A        TXS 
$7EE8            .byte $92
$7EE9  A2 88     LDX #$88
$7EEB            .byte $92
$7EEC  A2 9A     LDX #$9A
$7EEE  88        DEY 
$7EEF            .byte $92
$7EF0  A2 9A     LDX #$9A
$7EF2  A2 C4     LDX #$C4
$7EF4  C4 C4     CPY $C4 
$7EF6  CA        DEX 
$7EF7  B0 C8     BCS L_BRS_($7EC1)_($7EF7) BAD
$7EF9  C8        INY 
$7EFA  CA        DEX 
$7EFB  C4 CE     CPY $CE 
//------------------------------
L_JSR_($7EFF)_($615D) BAD
L_JSR_($7EFF)_($6787) BAD
//------------------------------
$7EFD  CE C8 B0  DEC $B0C8 
$7F00            .byte $03,$12,$23,$32
$7F04  40        RTI 
//------------------------------
$7F05  4D 2B 2B  EOR $2B2B 
$7F08            .byte $2B,$2B,$2B
$7F0B  60        RTS 
//------------------------------
$7F0C  0D 79 7E  ORA $7E79
$7F0F            .byte $83
$7F10  8D 95 9C  STA $9C95 
$7F13            .byte $A7,$2B,$2B
$7F16  2C 0D 1D  BIT $1D0D 
$7F19            .byte $2B,$2B,$2B,$2B,$2B,$2B,$2B
$7F20  01 01     ORA ($01,X)
$7F22  01 01     ORA ($01,X)
$7F24  01 01     ORA ($01,X)
$7F26  01 27     ORA ($27,X)
$7F28  2E 01 01  ROL $0101 
$7F2B  01 01     ORA ($01,X)
$7F2D  01 01     ORA ($01,X)
$7F2F  01 01     ORA ($01,X)
$7F31  01 01     ORA ($01,X)
$7F33  01 01     ORA ($01,X)
$7F35  01 01     ORA ($01,X)
$7F37  01 01     ORA ($01,X)
$7F39  01 01     ORA ($01,X)
$7F3B  01 01     ORA ($01,X)
$7F3D  01 01     ORA ($01,X)
$7F3F  01 01     ORA ($01,X)
$7F41  01 01     ORA ($01,X)
$7F43  01 01     ORA ($01,X)
$7F45            .byte $13
$7F46  18        CLC 
$7F47  20 2B 36  JSR L_JSR_($362B)_($7F47) OK
$7F4A  41 4A     EOR ($4A,X) 
$7F4C  50 58     BVC L_BRS_($7FA6)_($7F4C) JAM
$7F4E            .byte $5C
$7F4F  60        RTS 
//------------------------------
$7F50  65 6B     ADC $6B 
$7F52            .byte $73,$73
$7F54  7D 7D 7D  ADC $7D7D,X 
$7F57  7D 7D 98  ADC $987D,X 
$7F5A            .byte $9C
$7F5B  A5 AC     LDA $AC 
$7F5D  B5 BB     LDA $BB,X 
$7F5F  BE C0 32  LDX $32C0,Y 
$7F62  11 00     ORA ($00),Y
$7F64            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F6C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F74            .byte $00,$00,$00,$00,$00
$7F79  18        CLC 
$7F7A            .byte $00,$00,$00,$00,$00,$00
$7F80  0D 0D 0D  ORA $0D0D
$7F83  0D 0D 0D  ORA $0D0D
$7F86  0D 0D 07  ORA $070D
$7F89  0D 0D 07  ORA $070D
$7F8C            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7F94            .byte $07,$07,$0F,$0F,$0F,$0F,$0F,$0F
$7F9C            .byte $0F,$0F,$0F,$0F,$07,$07,$07,$07
//------------------------------
L_BRS_($7FA6)_($7F4C) JAM
//------------------------------
$7FA4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7FAC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7FB4            .byte $07,$07,$07,$07,$07,$07,$07,$07
//------------------------------
L_BRS_($7FC1)_($7FF9) JAM
//------------------------------
$7FBC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7FC4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7FCC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7FD4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$7FDC            .byte $07,$07,$07,$07
$7FE0  AA        TAX 
$7FE1  AA        TAX 
$7FE2  9A        TXS 
$7FE3  A2 9A     LDX #$9A
$7FE5            .byte $92
$7FE6  A2 92     LDX #$92
$7FE8  9A        TXS 
$7FE9  88        DEY 
$7FEA  9A        TXS 
$7FEB  88        DEY 
$7FEC            .byte $92
$7FED  88        DEY 
$7FEE            .byte $92
$7FEF  9A        TXS 
$7FF0            .byte $92
$7FF1  9A        TXS 
$7FF2  88        DEY 
$7FF3  C4 C4     CPY $C4 
$7FF5  C4 CA     CPY $CA 
$7FF7  C6 CA     DEC $CA 
$7FF9  B0 C6     BCS L_BRS_($7FC1)_($7FF9) JAM
$7FFB  C4 CE     CPY $CE 
$7FFD  CE CA C6  DEC $C6CA 
//------------------------------
L_JSR_($8000)_($6026) JAM
L_JSR_($8000)_($6622) JAM
//------------------------------
$8000            .byte $04,$13,$14,$33,$00
$8005  0E 02 00  ASL $0002 
$8008            .byte $00,$00,$00
$800B  70 75     BVS L_BRS_($8082)_($800B) BAD
$800D            .byte $7A,$1A
//------------------------------
L_JSR_($800F)_($9DA1) OK
L_JSR_($800F)_($DA18) OK
//------------------------------
$800F  84 00     STY $00 
$8011            .byte $00,$00,$00,$00
$8015  19 BA 0E  ORA $0EBA,Y
$8018  0E 02 00  ASL $0002 
$801B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8023            .byte $00,$00,$00,$00
$8027  28        PLP 
$8028            .byte $2F,$00,$00,$00,$00
$802D  36 00     ROL $00,X 
$802F            .byte $00,$00,$00
$8032  46 00     LSR $00 
$8034            .byte $00,$00,$00
$8037  36 00     ROL $00,X 
$8039            .byte $00,$00,$00
$803C  68        PLA 
$803D            .byte $00,$00,$00,$00
$8041  0A        ASL A 
$8042            .byte $00,$00,$00,$14
$8046  19 21 00  ORA $0021,Y
$8049            .byte $00,$00,$00
$804C  51 39     EOR ($39),Y 
$804E            .byte $14,$00,$1A
$8051  6C 74 7A  JMP ($7A74) 
$8054            .byte $7A,$7A,$7A,$7A
$8058  94 99     STY $99,X 
$805A  9D A6 AD  STA $ADA6,X 
$805D            .byte $00,$00,$1A
$8060  40        RTI 
//------------------------------
$8061            .byte $33
$8062  11 00     ORA ($00),Y
$8064            .byte $00,$00,$00,$00,$00,$00,$00,$00
$806C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8074            .byte $00,$00,$00,$00,$00
$8079  18        CLC 
$807A  48        PHA 
$807B            .byte $00,$00,$00,$00,$00
//------------------------------
L_BRS_($8082)_($800B) BAD
//------------------------------
$8080  0D 0D 0D  ORA $0D0D
$8083  0D 0D 0D  ORA $0D0D
$8086  0D 0D 0D  ORA $0D0D
$8089  0D 0D 07  ORA $070D
$808C            .byte $07,$07,$0F,$07,$07,$07,$07,$07
$8094            .byte $07,$07,$0F,$0F,$0F,$0F,$0F,$0F
$809C            .byte $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
$80A4            .byte $0F,$0F,$0F,$07,$07,$07,$07,$07
$80AC            .byte $07,$27,$07,$07,$07,$07,$67,$07
$80B4            .byte $07,$07,$07,$27,$07,$07,$07,$07
$80BC            .byte $67,$07,$07,$07,$07,$27,$07,$07
$80C4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80CC            .byte $07,$0F,$07,$07,$07,$07,$07,$07
//------------------------------
L_JSR_($80D8)_($A999) JAM
L_JSR_($80D8)_($E615) JAM
//------------------------------
$80D4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80DC            .byte $07,$07,$07,$07
$80E0  AA        TAX 
$80E1  AA        TAX 
$80E2  9A        TXS 
$80E3  9A        TXS 
$80E4  9A        TXS 
$80E5  88        DEY 
$80E6  A2 9A     LDX #$9A
$80E8  88        DEY 
$80E9  88        DEY 
$80EA  A2 9A     LDX #$9A
$80EC  9A        TXS 
$80ED            .byte $92
$80EE  9A        TXS 
$80EF            .byte $92,$92
$80F1  9A        TXS 
$80F2  88        DEY 
$80F3  C4 C4     CPY $C4 
$80F5  C4 CA     CPY $CA 
$80F7  C8        INY 
$80F8  C4 B0     CPY $B0 
$80FA  C6 C4     DEC $C4 
//------------------------------
L_JSR_($80FC)_($65D1) OK
//------------------------------
$80FC  CE CE B0  DEC $B0CE 
$80FF  C8        INY 
$8100  05 14     ORA $14
$8102  24 15     BIT $15 
$8104  41 0E     EOR ($0E,X) 
$8106            .byte $02,$34
$8108  65 6A     ADC $6A 
$810A            .byte $DB,$34
$810C  69 7B     ADC #$7B
$810E            .byte $7F,$1A
$8110  8E 00 00  STX $0000 
$8113            .byte $00,$34
$8115  65 6A     ADC $6A 
$8117  69 0E     ADC #$0E
$8119            .byte $02
$811A  EE ED EC  INC $ECED 
$811D            .byte $EB
$811E  EA        NOP 
$811F  E9 E8     SBC #$E8
$8121            .byte $E7,$00,$00,$00,$00,$00
$8127  28        PLP 
$8128            .byte $2F
$8129  DE DD DC  DEC $DCDD,X 
$812C            .byte $DB,$DA
$812E  D9 D8 D7  CMP $D7D8,Y 
$8131            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8139            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8141            .byte $00,$00,$00,$00,$14,$1A,$02,$00
$8149            .byte $00,$00,$4B
$814C  39 59 5D  AND $5D59,Y 
$814F            .byte $00,$1A
$8151  6D 6D 6D  ADC $6D6D 
$8154  7E 00 00  ROR $0000,X 
$8157            .byte $00
$8158  95 99     STA $99,X 
$815A            .byte $14
$815B  A6 AD     LDX $AD 
$815D            .byte $00,$00,$1A
$8160  C0 34     CPY #$34
$8162  11 00     ORA ($00),Y
$8164            .byte $00,$00,$00,$00,$00,$00,$00,$00
$816C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8174            .byte $00,$00,$00,$00,$00
$8179  18        CLC 
$817A  48        PHA 
$817B            .byte $00,$00,$00,$00,$00
//------------------------------
L_BRS_($8182)_($81E6) BAD
//------------------------------
$8180  0D 03 03  ORA $0303
$8183            .byte $03,$03
$8185  0D 0D 03  ORA $030D
$8188            .byte $03,$03
//------------------------------
L_JSR_($818A)_($4959) OK
//------------------------------
$818A  0D 03 07  ORA $0703
$818D            .byte $07,$07,$0F,$07,$07,$07,$07,$03
$8195            .byte $03,$03,$0F,$0F,$0F,$0F,$0F,$0F
$819D            .byte $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
$81A5            .byte $0F,$0F,$07,$07,$07,$07,$07,$07
$81AD            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81B5            .byte $07,$07,$07,$07,$07,$07,$07,$07
//------------------------------
L_BRS_($81C0)_($81F6) JAM
L_BRS_($81C0)_($81FA) JAM
//------------------------------
$81BD            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81C5            .byte $07,$07,$03,$07,$07,$07,$07,$0F
$81CD            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81D5            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81DD            .byte $07,$07,$07
$81E0  AA        TAX 
$81E1  AA        TAX 
$81E2  9A        TXS 
$81E3  9A        TXS 
$81E4  9A        TXS 
$81E5  88        DEY 
$81E6  B0 9A     BCS L_BRS_($8182)_($81E6) BAD
$81E8  A2 88     LDX #$88
$81EA  88        DEY 
$81EB            .byte $92
$81EC  9A        TXS 
$81ED  9A        TXS 
$81EE            .byte $92
$81EF  9A        TXS 
$81F0  A2 9A     LDX #$9A
$81F2  A2 D2     LDX #$D2
$81F4  E0 D0     CPX #$D0
$81F6  B0 C8     BCS L_BRS_($81C0)_($81F6) JAM
$81F8  C4 C4     CPY $C4 
$81FA  B0 C4     BCS L_BRS_($81C0)_($81FA) JAM
$81FC  CE CE B0  DEC $B0CE 
$81FF  CA        DEX 
$8200  05 00     ORA $00
$8202            .byte $02
$8203  35 42     AND $42,X 
$8205  0E 02 34  ASL $3402 
$8208  65 6A     ADC $6A 
$820A            .byte $00,$34
$820C  69 0E     ADC #$0E
$820E            .byte $80
$820F  85 1A     STA $1A 
$8211  96 9D     STX $9D,Y 
$8213            .byte $00,$34
$8215  65 6A     ADC $6A 
$8217  69 0E     ADC #$0E
$8219            .byte $02
$821A  E6 E5     INC $E5 
$821C  E4 E3     CPX $E3 
$821E            .byte $E2
$821F  E1 E0     SBC ($E0,X) 
$8221            .byte $DF,$00,$00,$00,$00,$00
$8227  28        PLP 
$8228            .byte $2F
$8229  D6 D5     DEC $D5,X 
$822B            .byte $D4,$D3,$D2
$822E  D1 D0     CMP ($D0),Y 
$8230            .byte $CF,$00,$00,$00,$00,$00,$00,$00
$8238            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8240            .byte $00,$00,$00,$00,$00,$14,$1A,$22
$8248            .byte $00,$37,$42
$824B  39 52 4C  AND $4C52,Y 
$824E            .byte $00,$00,$1A
$8251  6E 00 00  ROR $0000 
$8254            .byte $7F,$00,$00,$00
$8258  96 99     STX $99,Y 
$825A            .byte $14
$825B  A6 AD     LDX $AD 
$825D            .byte $00,$00,$1A
$8260  40        RTI 
//------------------------------
$8261  35 11     AND $11,X 
$8263            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($8270)_($82E6) JAM
//------------------------------
$826B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8273            .byte $00,$00,$00,$00,$00,$00
$8279  18        CLC 
$827A            .byte $00,$00,$00,$00,$00,$00
$8280  0D 03 03  ORA $0303
$8283            .byte $03,$03
$8285  0D 0D 03  ORA $030D
$8288            .byte $03,$03
$828A  0D 03 07  ORA $0703
$828D            .byte $07,$07,$07,$0F,$07,$07,$07,$03
//------------------------------
L_BRS_($8296)_($82E4) JAM
//------------------------------
$8295            .byte $03,$03,$0F,$0F,$0F,$0F,$0F,$0F
$829D            .byte $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
$82A5            .byte $0F,$0F,$07,$07,$07,$07,$07,$07
$82AD            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82B5            .byte $07,$07,$07,$07,$07,$07,$07,$07
//------------------------------
L_BRS_($82C0)_($82FA) JAM
//------------------------------
$82BD            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82C5            .byte $07,$07,$03,$07,$07,$07,$0F,$07
$82CD            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82D5            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82DD            .byte $07,$07,$07
$82E0  AA        TAX 
$82E1  AA        TAX 
$82E2  9A        TXS 
$82E3  9A        TXS 
$82E4  B0 B0     BCS L_BRS_($8296)_($82E4) JAM
$82E6  B0 88     BCS L_BRS_($8270)_($82E6) JAM
$82E8            .byte $92,$92,$92
$82EB  A2 A2     LDX #$A2
$82ED  A2 A2     LDX #$A2
$82EF  88        DEY 
$82F0  88        DEY 
$82F1  A2 92     LDX #$92
$82F3  C4 C4     CPY $C4 
$82F5  C4 B0     CPY $B0 
$82F7  CA        DEX 
$82F8  C4 C4     CPY $C4 
$82FA  B0 C4     BCS L_BRS_($82C0)_($82FA) JAM
$82FC  CE CE B0  DEC $B0CE 
$82FF  C4 06     CPY $06 
$8301  16 25     ASL $25,X 
$8303  36 43     ROL $43,X 
$8305  4E 02 5D  LSR $5D02 
$8308  15 15     ORA $15,X
$830A  6C 71 69  JMP ($6971) 
$830D  0E 0E 86  ASL $860E 
$8310            .byte $1A,$1A,$9E
$8313  A8        TAY 
$8314            .byte $00,$00,$00
$8317  69 0E     ADC #$0E
$8319            .byte $02,$2B,$2B,$2B,$2B,$2B,$2B
$8320  01 01     ORA ($01,X)
$8322  0E 13 0E  ASL $0E13 
$8325            .byte $13
$8326  0E 28 2F  ASL $2F28 
$8329  01 01     ORA ($01,X)
$832B  01 01     ORA ($01,X)
$832D  01 01     ORA ($01,X)
$832F  01 01     ORA ($01,X)
$8331            .byte $44,$47,$44,$47,$44,$00,$00,$00
$8339            .byte $00,$00
$833B  5D 69 47  EOR $4769,X 
$833E  69 47     ADC #$47
$8340  05 0B     ORA $0B
$8342  05 0B     ORA $0B
$8344  05 15     ORA $15
$8346            .byte $1A,$00
$8348  2C 38 39  BIT $3938 
$834B  39 53 00  AND $0053,Y 
$834E            .byte $00,$00,$1A,$6F,$67,$67,$80,$14
$8356            .byte $00,$00
$8358  96 99     STX $99,Y 
$835A            .byte $14
$835B  A6 AD     LDX $AD 
$835D            .byte $00,$00,$1A
$8360  50 0A     BVC L_BRS_($836C)_($8360) JAM
$8362  11 00     ORA ($00),Y
$8364            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($836C)_($8360) JAM
//------------------------------
$836C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8374            .byte $00,$00,$00,$00,$00
$8379  18        CLC 
$837A            .byte $44,$00,$00,$00,$00,$00
$8380  0D 0D 0D  ORA $0D0D
$8383  0D 0D 0D  ORA $0D0D
$8386  0D 0D 0D  ORA $0D0D
$8389  0D 0D 0D  ORA $0D0D
$838C            .byte $07,$07,$07,$07,$07,$0F,$07,$07
$8394            .byte $07,$07,$07,$0F,$0F,$0F,$0F,$0F
$839C            .byte $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
$83A4            .byte $0F,$0F,$0F,$07,$07,$07,$07,$07
$83AC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$83B4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$83BC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$83C4            .byte $07,$07,$07,$07,$07,$07,$0F,$07
$83CC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$83D4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$83DC            .byte $07,$07,$07,$07
$83E0  BA        TSX 
$83E1            .byte $B8
$83E2  84 BE     STY $BE 
$83E4            .byte $82
$83E5  BE BE 84  LDX $84BE,Y 
$83E8            .byte $82
$83E9  84 86     STY $86 
$83EB            .byte $82
$83EC  86 80     STX $80 
$83EE  84 80     STY $80 
$83F0  BE 84 BE  LDX $BE84,Y 
$83F3  BE D6 DA  LDX $DAD6,Y 
$83F6  BE BA BE  LDX $BEBA,Y 
$83F9  BE BE BE  LDX $BEBE,Y 
$83FC  BE C4 BC  LDX $BCC4,Y 
$83FF  BE 07 17  LDX $1707,Y 
$8402  26 37     ROL $37 
//------------------------------
L_JSR_($8404)_($AF15) JAM
L_JSR_($8404)_($EB8E) JAM
//------------------------------
$8404            .byte $44,$4F
$8406  59 5E 66  EOR $665E,Y 
$8409  66 6D     ROR $6D 
$840B            .byte $72
$840C  69 0E     ADC #$0E
$840E  0E 87 7D  ASL $7D87 
$8411            .byte $1A,$1A,$5C,$00,$00,$00
$8417  69 0E     ADC #$0E
$8419            .byte $02,$00,$00,$00,$D2,$D7,$D2,$04
$8421  09 04     ORA #$04
$8423  09 04     ORA #$04
$8425  09 04     ORA #$04
$8427  28        PLP 
$8428            .byte $2F,$00,$00
$842B  09 04     ORA #$04
$842D  09 04     ORA #$04
$842F  39 3F 45  AND $453F,Y 
$8432            .byte $3F
$8433  45 3F     EOR $3F 
$8435  45 3F     EOR $3F 
$8437            .byte $00,$00,$00,$00
$843B  5E 45 3F  LSR $3F45,X 
$843E  45 3F     EOR $3F 
$8440  06 0C     ASL $0C 
$8442  06 0C     ASL $0C 
$8444  06 0C     ASL $0C 
$8446            .byte $1A,$00
$8448  2D 39 39  AND $3939 
$844B  4C 54 00  JMP $0054
$844E            .byte $00,$00,$1A,$6F,$67,$67
$8454  81 14     STA ($14,X) 
$8456            .byte $00,$00
$8458  96 9A     STX $9A,Y 
$845A            .byte $9E
$845B  A6 AD     LDX $AD 
$845D            .byte $00,$00,$1A
$8460  58        CLI 
$8461  0A        ASL A 
$8462  11 00     ORA ($00),Y
$8464            .byte $00,$00,$00,$00,$00,$00,$00,$00
$846C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8474            .byte $00,$00,$00,$00,$00
$8479  18        CLC 
$847A            .byte $44,$00,$00,$00,$00,$00
$8480  0D 0D 0D  ORA $0D0D
$8483  0D 0D 0D  ORA $0D0D
$8486  0D 0D 0D  ORA $0D0D
$8489  0D 0D 0D  ORA $0D0D
$848C            .byte $07,$07,$07,$07,$07,$07,$0F,$07
$8494            .byte $07,$07,$07,$0F,$0F,$0F,$0F,$0F
$849C            .byte $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
$84A4            .byte $0F,$0F,$0F,$07,$07,$07,$07,$07
$84AC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$84B4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$84BC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$84C4            .byte $07,$07,$07,$07,$07,$0F,$07,$07
$84CC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$84D4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$84DC            .byte $07,$07,$07,$07
$84E0  BC BC C4  LDY $C4BC,X 
$84E3  84 84     STY $84 
$84E5  9A        TXS 
$84E6  86 86     STX $86 
$84E8  84 82     STY $82 
$84EA  84 84     STY $84 
$84EC  84 84     STY $84 
$84EE  86 82     STX $82 
$84F0            .byte $82
$84F1  86 86     STX $86 
$84F3  DE BE BE  DEC $BEBE,X 
$84F6  BE BC C4  LDX $C4BC,Y 
$84F9  BC C4 C4  LDY $C4C4,X 
$84FC  C4 C4     CPY $C4 
$84FE  BC C4 08  LDY $08C4,X 
$8501  18        CLC 
$8502            .byte $27
$8503  38        SEC 
$8504  45 50     EOR $50 
$8506            .byte $5A,$2B,$2B,$2B
$850A  6E 73 76  ROR $7673 
$850D            .byte $7C
$850E  81 88     STA ($88,X) 
$8510            .byte $8F,$97,$9F
$8513  A9 2B     LDA #$2B
$8515            .byte $2B,$2B,$BF
$8518  C4 2B     CPY $2B 
$851A            .byte $2B,$2B,$2B,$D3
$851E  D8        CLD 
$851F            .byte $D3
$8520  05 0A     ORA $0A
$8522  05 0A     ORA $0A
$8524  05 0A     ORA $0A
$8526  05 29     ORA $29
$8528  30 01     BMI L_BRS_($852B)_($8528) BAD
//------------------------------
L_BRS_($852B)_($8528) BAD
//------------------------------
$852A  01 0A     ORA ($0A,X)
$852C  05 0A     ORA $0A
$852E  05 3A     ORA $3A
$8530  40        RTI 
//------------------------------
$8531            .byte $3A
$8532  40        RTI 
//------------------------------
$8533            .byte $3A
$8534  40        RTI 
//------------------------------
$8535            .byte $3A
$8536  40        RTI 
//------------------------------
$8537  01 01     ORA ($01,X)
$8539  01 01     ORA ($01,X)
$853B            .byte $5F,$3A
$853D  40        RTI 
//------------------------------
$853E            .byte $3A
$853F  40        RTI 
//------------------------------
$8540            .byte $07
$8541  0D 07 0D  ORA $0D07
$8544            .byte $07
$8545  0D 1B 01  ORA $011B
$8548  2E 3A 43  ROL $433A 
$854B  4D 55 5A  EOR $5A55 
$854E  5E 61 66  LSR $6661,X 
$8551            .byte $6F,$67,$67
$8554  81 14     STA ($14,X) 
$8556            .byte $00,$00
$8558  96 9B     STX $9B,Y 
$855A            .byte $9F
$855B  A6 AE     LDX $AE 
$855D            .byte $00,$00,$1A
$8560  60        RTS 
//------------------------------
$8561  0A        ASL A 
$8562  11 00     ORA ($00),Y
$8564            .byte $00,$00,$00,$00,$00,$00,$00,$00
$856C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8574            .byte $00,$00,$00,$00,$00
$8579  18        CLC 
$857A            .byte $44,$00,$00,$00,$00,$00
$8580  0D 0D 0D  ORA $0D0D
$8583  0D 0D 0D  ORA $0D0D
$8586  0D 0D 0D  ORA $0D0D
$8589  0D 0D 0D  ORA $0D0D
$858C            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8594            .byte $07,$07,$07,$0F,$0F,$0F,$0F,$0F
$859C            .byte $0F,$0F,$0F,$0F,$0F,$0F,$0F,$0F
//------------------------------
L_BRS_($85AA)_($8610) JAM
//------------------------------
$85A4            .byte $0F,$0F,$0F,$07,$07,$07,$07,$07
$85AC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$85B4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$85BC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$85C4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$85CC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$85D4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$85DC            .byte $07,$07,$07,$07,$B8
$85E1  C6 82     DEC $82 
$85E3  BE CA 80  LDX $80CA,Y 
$85E6  84 80     STY $80 
$85E8            .byte $80,$80,$80,$80,$80
$85ED  86 80     STX $80 
$85EF  84 80     STY $80 
$85F1  C4 80     CPY $80 
$85F3  BE BE BE  LDX $BEBE,Y 
$85F6  BE BC BC  LDX $BCBC,Y 
$85F9  C4 BC     CPY $BC 
$85FB  BC C4 C4  LDY $C4C4,X 
$85FE  BC BC 09  LDY $09BC,X 
$8601  19 09 00  ORA $0009,Y
$8604  46 51     LSR $51 
$8606            .byte $00,$00,$00,$00,$00,$00,$77,$1A
$860E            .byte $82,$89
$8610  90 98     BCC L_BRS_($85AA)_($8610) JAM
$8612            .byte $00,$00,$00
$8615  19 0E 0E  ORA $0E0E,Y
$8618  0E 02 5F  ASL $5F02 
$861B            .byte $00
$861C  55 00     EOR $00,X 
$861E            .byte $62
$861F  19 06 0B  ORA $0B06,Y
$8622            .byte $0B,$14,$14
$8625  1D 00 00  ORA $0000,X
$8628            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8630            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8638            .byte $00,$00,$00,$00
$863C  6A        ROR A 
$863D            .byte $00,$00
$863F  6A        ROR A 
$8640            .byte $00
$8641  0E 00 11  ASL $1100 
$8644            .byte $00,$14,$00,$1A,$00,$00,$44
$864B  4E 56 5B  LSR $5B56 
$864E            .byte $14,$62,$67,$6F,$67,$67
$8654  81 14     STA ($14,X) 
$8656            .byte $00,$00
$8658  96 9B     STX $9B,Y 
$865A  A0 A7     LDY #$A7
$865C            .byte $AF,$00,$00,$1A
$8660  48        PHA 
$8661  0A        ASL A 
$8662  11 00     ORA ($00),Y
$8664            .byte $00,$00,$00,$00,$00,$00,$00,$00
$866C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8674            .byte $00,$00,$00,$00,$00
$8679  18        CLC 
$867A            .byte $44,$00,$00,$00,$00,$00
$8680  01 01     ORA ($01,X)
$8682  01 01     ORA ($01,X)
$8684  01 01     ORA ($01,X)
$8686            .byte $07,$07,$07,$07,$07,$07,$07,$0F
$868E            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8696            .byte $07,$07,$07,$07,$67,$07,$27,$07
$869E            .byte $67,$07,$07,$07,$07
$86A3  0D 07 07  ORA $0707
$86A6  0D 0D 0D  ORA $0D0D
$86A9  0D 0D 0D  ORA $0D0D
$86AC  0D 0D 0D  ORA $0D0D
$86AF  0D 0D 0D  ORA $0D0D
$86B2  0D 0D 0D  ORA $0D0D
$86B5  0D 0D 0D  ORA $0D0D
$86B8  0D 0D 0D  ORA $0D0D
$86BB  0D 0D 07  ORA $070D
$86BE            .byte $07,$07,$07,$67,$07,$27,$07,$07
$86C6            .byte $07,$07,$07,$07,$07,$07,$07,$07
$86CE            .byte $0F,$07,$07,$07,$07,$07,$07,$07
$86D6            .byte $07,$07,$07,$07,$07,$07,$07,$07
$86DE            .byte $07,$07
$86E0  BC BC BC  LDY $BCBC,X 
$86E3  BC 86 82  LDY $8286,X 
$86E6            .byte $82,$82
$86E8  86 86     STX $86 
$86EA            .byte $82
$86EB  86 82     STX $82 
$86ED            .byte $82,$82
$86EF  86 86     STX $86 
$86F1  BC 82 BE  LDY $BE82,X 
$86F4  BE BE BC  LDX $BCBE,Y 
$86F7  BC BC BC  LDY $BCBC,X 
$86FA  BC BC C4  LDY $C4BC,X 
$86FD  C4 BC     CPY $BC 
$86FF  BC 09 19  LDY $1909,X 
$8702  28        PLP 
$8703  39 47 52  AND $5247,Y 
$8706            .byte $00,$00,$00,$00,$00,$00
$870C  78        SEI 
$870D            .byte $1A,$1A
$870F  8A        TXA 
$8710  91 99     STA ($99),Y 
$8712  A0 00     LDY #$00
$8714            .byte $00
$8715  19 BB 94  ORA $94BB,Y
$8718  0E 02 00  ASL $0002 
$871B            .byte $00,$00,$00,$00
$871F  19 06 0B  ORA $0B06,Y
$8722            .byte $0B,$14
$8724  18        CLC 
$8725  1E 00 00  ASL $0000,X 
$8728            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8730            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8738            .byte $00,$00,$00,$00
$873C  6A        ROR A 
$873D            .byte $00,$00
$873F  6A        ROR A 
$8740            .byte $00,$00,$00,$00,$00,$14,$1C,$23
$8748            .byte $00,$3B
$874A  45 4F     EOR $4F 
$874C            .byte $57
$874D  39 39 63  AND $6339,Y 
$8750            .byte $67,$6F,$67,$67
$8754  81 14     STA ($14,X) 
$8756            .byte $00,$00
$8758  96 9B     STX $9B,Y 
$875A  A1 A8     LDA ($A8,X) 
$875C  B0 00     BCS L_BRS_($875E)_($875C) JAM
//------------------------------
L_BRS_($875E)_($875C) JAM
//------------------------------
$875E            .byte $00,$1A
$8760  20 44 11  JSR L_JSR_($1144)_($8760) OK
$8763            .byte $00,$00,$00,$00,$00,$00,$00,$00
$876B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8773            .byte $00,$00,$00,$00,$00,$00
$8779  18        CLC 
$877A  48        PHA 
$877B            .byte $00,$00,$00,$00,$00
$8780  01 01     ORA ($01,X)
$8782  01 01     ORA ($01,X)
$8784  01 01     ORA ($01,X)
$8786            .byte $07,$07,$07,$07,$07,$07,$07,$07
$878E            .byte $0F,$07,$07,$07,$07,$07,$07,$07
$8796            .byte $07,$07,$07,$07,$07,$07,$07,$07
$879E            .byte $07,$07,$07,$07,$07
$87A3  0D 07 07  ORA $0707
$87A6  0D 0D 0D  ORA $0D0D
$87A9  0D 0D 0D  ORA $0D0D
$87AC  0D 0D 0D  ORA $0D0D
$87AF  0D 0D 0D  ORA $0D0D
$87B2  0D 0D 0D  ORA $0D0D
$87B5  0D 0D 0D  ORA $0D0D
$87B8  0D 0D 0D  ORA $0D0D
$87BB  0D 0D 07  ORA $070D
$87BE            .byte $07,$07,$07,$07,$07,$07,$07,$07
$87C6            .byte $07,$07,$07,$07,$07,$07,$07,$0F
$87CE            .byte $07,$07,$07,$07,$07,$07,$07,$07
$87D6            .byte $07,$07,$07,$07,$07,$07,$07,$07
$87DE            .byte $07,$07
$87E0  AE AE 9E  LDX $9EAE 
$87E3            .byte $9E
$87E4  A6 B4     LDX $B4 
$87E6  B4 8E     LDY $8E,X 
$87E8  A6 96     LDX $96 
$87EA  96 A6     STX $A6,Y 
$87EC  A6 B4     LDX $B4 
$87EE  B4 8E     LDY $8E,X 
$87F0  8E A6 96  STX $96A6 
$87F3            .byte $DC
$87F4  C4 C4     CPY $C4 
$87F6  B6 B6     LDX $B6,Y 
$87F8  B6 B6     LDX $B6,Y 
$87FA  B6 B6     LDX $B6,Y 
$87FC  B6 B6     LDX $B6,Y 
$87FE  B6 B6     LDX $B6,Y 
$8800  0A        ASL A 
$8801            .byte $1A
$8802  09 00     ORA #$00
//------------------------------
L_JSR_($8804)_($AD15) OK
L_JSR_($8804)_($E98E) OK
//------------------------------
$8804  46 51     LSR $51 
$8806            .byte $00,$00,$00,$00,$00,$00
$880C  09 7D     ORA #$7D
$880E            .byte $1A,$1A,$92
$8811  9A        TXS 
$8812  A1 AA     LDA ($AA,X) 
$8814            .byte $00
$8815  7D BC 69  ADC $69BC,X 
$8818  0E 02 00  ASL $0002 
$881B            .byte $00,$00,$00,$00
$881F  19 06 0B  ORA $0B06,Y
$8822            .byte $0C
$8823  15 19     ORA $19,X
$8825            .byte $1F
$8826  15 15     ORA $15,X
$8828  15 15     ORA $15,X
$882A  15 15     ORA $15,X
$882C  15 15     ORA $15,X
$882E  15 15     ORA $15,X
$8830  15 15     ORA $15,X
$8832  15 15     ORA $15,X
$8834  15 15     ORA $15,X
$8836  15 49     ORA $49,X
$8838  4D 53 15  EOR $1553 
$883B  60        RTS 
//------------------------------
$883C  15 71     ORA $71,X
$883E            .byte $00
$883F  6A        ROR A 
$8840            .byte $00,$00,$00,$00,$00,$14,$1A
$8847  24 2F     BIT $2F 
$8849            .byte $3C
$884A  3D 46 39  AND $3946,X 
$884D  39 4C 1A  AND $1A4C,Y 
$8850            .byte $67,$6F,$67,$67
$8854  81 86     STA ($86,X) 
$8856  8C 91 96  STY $9691 
$8859            .byte $9B
$885A  A2 A9     LDX #$A9
$885C  B1 B6     LDA ($B6),Y 
$885E            .byte $00,$1A
$8860  30 19     BMI L_BRS_($887B)_($8860) JAM
$8862  11 00     ORA ($00),Y
$8864            .byte $00,$00,$00,$00,$00,$00,$00,$00
$886C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8874            .byte $00,$00,$00,$00,$00
$8879  18        CLC 
$887A  48        PHA 
//------------------------------
L_BRS_($887B)_($8860) JAM
//------------------------------
$887B            .byte $00,$00,$00,$00,$00
$8880  01 01     ORA ($01,X)
$8882  01 01     ORA ($01,X)
$8884  01 01     ORA ($01,X)
$8886            .byte $07,$07,$07,$07,$07,$07,$07,$07
$888E            .byte $07
$888F  01 07     ORA ($07,X)
$8891            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8899            .byte $07,$07,$07,$07,$07,$07,$07,$07
$88A1            .byte $07,$07,$07,$07,$07,$07,$07,$07
$88A9            .byte $07,$07,$07,$07,$07,$07,$07,$07
$88B1            .byte $07,$07,$07,$07,$07,$07,$07,$07
$88B9            .byte $07,$07,$07,$07,$07,$07,$07,$07
$88C1            .byte $07,$07,$07,$07,$07,$07,$07,$07
$88C9            .byte $07,$07,$07
$88CC  01 07     ORA ($07,X)
$88CE            .byte $07,$07,$07,$07,$07,$07,$07,$07
$88D6            .byte $07,$07,$07,$07,$07,$07,$07,$07
$88DE            .byte $07,$07
$88E0  AC AC 9C  LDY $9CAC 
$88E3            .byte $9C,$B2
$88E5  8C B2 9C  STY $9CB2 
$88E8  94 94     STY $94,X 
$88EA  94 A4     STY $A4,X 
$88EC            .byte $B2,$B2
$88EE  A4 9C     LDY $9C 
$88F0  8C A4 94  STY $94A4 
$88F3  C4 C4     CPY $C4 
$88F5  D8        CLD 
$88F6  C0 C2     CPY #$C2
$88F8  C0 C0     CPY #$C0
$88FA  C0 C2     CPY #$C2
$88FC            .byte $C2,$C2
$88FE  C0 C2     CPY #$C2
$8900  09 19     ORA #$19
$8902  09 00     ORA #$00
//------------------------------
L_JSR_($8904)_($AB15) OK
L_JSR_($8904)_($E78E) OK
//------------------------------
$8904  48        PHA 
$8905            .byte $53,$00,$00,$00,$00,$00,$00
$890C  09 00     ORA #$00
$890E  7D 1A 1A  ADC $1A1A,X 
$8911            .byte $92
$8912  9A        TXS 
$8913            .byte $AB
$8914  B1 00     LDA ($00),Y 
$8916            .byte $00
$8917  69 0E     ADC #$0E
$8919            .byte $02,$00,$00,$00,$00,$00
$891F  19 06 0C  ORA $0C06,Y
$8922            .byte $00,$00,$00,$00,$00,$00,$00,$00
$892A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8932            .byte $00,$00,$00,$00,$00
$8937  4A        LSR A 
$8938            .byte $00,$00,$57
$893B  61 6B     ADC ($6B,X) 
$893D            .byte $1F
$893E  71 6A     ADC ($6A),Y 
$8940            .byte $00,$00,$00,$00,$00,$14,$1A
$8947  25 30     AND $30
$8949  3D 46 39  AND $3946,X 
$894C  39 4C 00  AND $004C,Y 
$894F            .byte $1A
$8950  68        PLA 
$8951  70 68     BVS L_BRS_($89BB)_($8951) JAM
$8953  68        PLA 
$8954            .byte $82,$87
$8956  8D 92 96  STA $9692 
$8959            .byte $9B,$A3
$895B  AA        TAX 
$895C            .byte $B2,$B7,$00,$1A
$8960  10 42     BPL L_BRS_($89A4)_($8960) JAM
$8962  11 00     ORA ($00),Y
$8964            .byte $00,$00,$00,$00,$00,$00,$00,$00
$896C            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($8978)_($89E6) JAM
//------------------------------
$8974            .byte $00,$00,$00,$00,$00
$8979  18        CLC 
$897A  48        PHA 
$897B            .byte $00,$00,$00,$00,$00
//------------------------------
L_BRS_($8981)_($89EF) BAD
//------------------------------
$8980  01 01     ORA ($01,X)
$8982  01 01     ORA ($01,X)
$8984  01 01     ORA ($01,X)
$8986            .byte $07,$07,$07,$07,$07,$07,$07,$07
$898E            .byte $07,$07
$8990  01 07     ORA ($07,X)
//------------------------------
L_BRS_($8996)_($89E4) JAM
//------------------------------
$8992            .byte $07,$07,$07,$07,$07,$07,$07,$07
$899A            .byte $07,$07,$07,$07,$07,$07,$07,$07
//------------------------------
L_BRS_($89A4)_($8960) JAM
//------------------------------
$89A2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$89AA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$89B2            .byte $07,$07,$07,$07,$07,$07,$07,$07
//------------------------------
L_BRS_($89BB)_($8951) JAM
//------------------------------
$89BA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$89C2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$89CA            .byte $07
$89CB  01 07     ORA ($07,X)
$89CD            .byte $07,$07,$07,$07,$07,$07,$07,$07
$89D5            .byte $07,$07,$07,$07,$07,$07,$07,$07
$89DD            .byte $07,$07,$07
$89E0  AA        TAX 
$89E1  AA        TAX 
$89E2  A0 A0     LDY #$A0
$89E4  B0 B0     BCS L_BRS_($8996)_($89E4) JAM
$89E6  B0 90     BCS L_BRS_($8978)_($89E6) JAM
$89E8  98        TYA 
$89E9  98        TYA 
$89EA  98        TYA 
$89EB  A8        TAY 
$89EC  A8        TAY 
$89ED  A8        TAY 
$89EE  A8        TAY 
$89EF  90 90     BCC L_BRS_($8981)_($89EF) BAD
$89F1  A8        TAY 
$89F2  98        TYA 
$89F3  C4 D4     CPY $D4 
$89F5  C4 C4     CPY $C4 
$89F7  C4 C4     CPY $C4 
$89F9  C4 C4     CPY $C4 
$89FB  C4 C4     CPY $C4 
$89FD  C4 C4     CPY $C4 
$89FF  C4 0B     CPY $0B 
$8A01            .byte $1B
$8A02  29 3A     AND #$3A
$8A04  46 51     LSR $51 
$8A06            .byte $00,$00,$00,$00,$00,$00
$8A0C  09 00     ORA #$00
$8A0E            .byte $00
$8A0F  7D 1A 1A  ADC $1A1A,X 
$8A12  A2 AC     LDX #$AC
$8A14            .byte $B2,$00,$00
$8A17  69 0E     ADC #$0E
$8A19            .byte $02,$00,$00,$00,$00,$00
$8A1F  19 07 00  ORA $0007,Y
$8A22            .byte $00,$00,$1A
$8A25  20 20 20  JSR $2020
$8A28  20 20 20  JSR $2020
$8A2B  20 20 20  JSR $2020
$8A2E  20 20 41  JSR L_JSR_($4120)_($8A2E) OK
$8A31            .byte $00,$00,$00,$00,$00,$00,$4B
$8A38  4E 54 58  LSR $5854 
$8A3B            .byte $62
$8A3C  6C 00 1F  JMP ($1F00) 
$8A3F  78        SEI 
$8A40            .byte $00,$00,$00,$00,$00,$14,$1A
$8A47  26 31     ROL $31 
$8A49  3E 39 39  ROL $3939,X 
$8A4C  4C 00 00  JMP $0000
$8A4F            .byte $1A
$8A50  01 2E     ORA ($2E,X)
$8A52  01 01     ORA ($01,X)
$8A54            .byte $83
$8A55  88        DEY 
$8A56  8E 93 97  STX $9793 
$8A59            .byte $9B,$00,$00,$B3,$14,$00,$1A,$7F
$8A61  A0 11     LDY #$11
$8A63            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8A6B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8A73            .byte $00,$00
$8A75  E5 40     SBC $40 
$8A77  E5 40     SBC $40 
$8A79  18        CLC 
$8A7A  48        PHA 
$8A7B            .byte $00,$00,$00,$00,$00
$8A80  01 01     ORA ($01,X)
$8A82  01 01     ORA ($01,X)
$8A84  01 01     ORA ($01,X)
$8A86            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8A8E            .byte $07,$07,$07
$8A91  01 07     ORA ($07,X)
$8A93            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8A9B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8AA3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8AAB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8AB3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8ABB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8AC3            .byte $07,$07,$07,$07,$07,$07,$07
$8ACA  01 07     ORA ($07,X)
$8ACC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8AD4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8ADC            .byte $07,$07,$07,$07
$8AE0  8A        TXA 
$8AE1  8A        TXA 
$8AE2  8A        TXA 
$8AE3  8A        TXA 
$8AE4  8A        TXA 
$8AE5  8A        TXA 
$8AE6  8A        TXA 
$8AE7  8A        TXA 
$8AE8  8A        TXA 
$8AE9  8A        TXA 
$8AEA  8A        TXA 
$8AEB  8A        TXA 
$8AEC  8A        TXA 
$8AED  8A        TXA 
$8AEE  8A        TXA 
$8AEF  8A        TXA 
$8AF0  8A        TXA 
$8AF1  8A        TXA 
$8AF2  8A        TXA 
$8AF3  8A        TXA 
$8AF4  8A        TXA 
$8AF5  8A        TXA 
$8AF6  8A        TXA 
$8AF7  8A        TXA 
$8AF8  8A        TXA 
$8AF9  8A        TXA 
$8AFA  8A        TXA 
$8AFB  8A        TXA 
$8AFC  8A        TXA 
$8AFD  8A        TXA 
$8AFE  8A        TXA 
$8AFF  8A        TXA 
$8B00  09 19     ORA #$19
$8B02  09 3B     ORA #$3B
$8B04  49 54     EOR #$54
$8B06            .byte $2B,$2B,$2B,$2B,$2B,$2B
$8B0C  09 00     ORA #$00
$8B0E            .byte $00,$00
$8B10  7D 1A 1A  ADC $1A1A,X 
$8B13  AD B3 2B  LDA $2BB3 
$8B16            .byte $2B
$8B17  C0 C5     CPY #$C5
$8B19            .byte $2B,$2B,$2B,$2B,$2B,$2B,$2B
$8B20  01 01     ORA ($01,X)
$8B22  01 01     ORA ($01,X)
$8B24            .byte $1B
$8B25  21 25     AND ($25,X) 
$8B27  25 31     AND $31
$8B29  25 25     AND $25
$8B2B  25 35     AND $35
$8B2D  25 25     AND $25
$8B2F            .byte $3B
$8B30  01 01     ORA ($01,X)
$8B32  01 01     ORA ($01,X)
$8B34  01 01     ORA ($01,X)
$8B36  01 01     ORA ($01,X)
$8B38            .byte $4F
$8B39  55 59     EOR $59,X 
$8B3B            .byte $63
$8B3C  6D 01 01  ADC $0101 
$8B3F  01 01     ORA ($01,X)
$8B41  01 01     ORA ($01,X)
$8B43  01 01     ORA ($01,X)
$8B45  16 1D     ASL $1D,X 
$8B47            .byte $27,$32
$8B49  39 39 4C  AND $4C39,Y 
$8B4C            .byte $00,$00,$00,$1A
$8B50  01 01     ORA ($01,X)
$8B52  01 01     ORA ($01,X)
$8B54  01 01     ORA ($01,X)
$8B56  01 01     ORA ($01,X)
$8B58  01 01     ORA ($01,X)
$8B5A  A4 AB     LDY $AB 
$8B5C  B4 B8     LDY $B8,X 
$8B5E            .byte $00,$1A,$7F
$8B61  A0 11     LDY #$11
$8B63            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B6B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B73            .byte $00,$00
$8B75  E5 40     SBC $40 
$8B77  E5 40     SBC $40 
$8B79  18        CLC 
$8B7A  48        PHA 
$8B7B            .byte $00,$00,$00,$00,$00,$0F,$0F,$0F
$8B83            .byte $0F,$0F,$0F,$07,$07,$07,$07,$07
$8B8B            .byte $07,$07,$07,$07,$07,$07,$07
$8B92  01 07     ORA ($07,X)
$8B94            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8B9C            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8BA4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8BAC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8BB4            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8BBC            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8BC4            .byte $07,$07,$07,$07,$07
$8BC9  01 07     ORA ($07,X)
$8BCB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8BD3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8BDB            .byte $07,$07,$07,$07,$07
$8BE0  8A        TXA 
$8BE1  8A        TXA 
$8BE2  8A        TXA 
$8BE3  8A        TXA 
$8BE4  8A        TXA 
$8BE5  8A        TXA 
$8BE6  8A        TXA 
$8BE7  8A        TXA 
$8BE8  8A        TXA 
$8BE9  8A        TXA 
$8BEA  8A        TXA 
$8BEB  8A        TXA 
$8BEC  8A        TXA 
$8BED  8A        TXA 
$8BEE  8A        TXA 
$8BEF  8A        TXA 
$8BF0  8A        TXA 
$8BF1  8A        TXA 
$8BF2  8A        TXA 
$8BF3  8A        TXA 
$8BF4  8A        TXA 
$8BF5  8A        TXA 
$8BF6  8A        TXA 
$8BF7  8A        TXA 
$8BF8  8A        TXA 
$8BF9  8A        TXA 
$8BFA  8A        TXA 
$8BFB  8A        TXA 
$8BFC  8A        TXA 
$8BFD  8A        TXA 
$8BFE  8A        TXA 
$8BFF  8A        TXA 
$8C00            .byte $0C,$1C
$8C02  2A        ROL A 
$8C03            .byte $2B,$2B,$2B,$2B,$2B,$2B,$2B,$2B
$8C0B            .byte $2B,$2B,$2B,$2B,$2B,$2B,$2B,$2B
$8C13            .byte $2B,$2B,$2B,$2B
$8C17  C1 2B     CMP ($2B,X) 
$8C19            .byte $2B,$2B,$2B,$2B,$2B,$2B,$2B
$8C20  01 01     ORA ($01,X)
$8C22  01 01     ORA ($01,X)
$8C24  01 22     ORA ($22,X)
$8C26  26 26     ROL $26 
$8C28  26 26     ROL $26 
$8C2A  26 26     ROL $26 
$8C2C  26 26     ROL $26 
$8C2E  26 3C     ROL $3C 
$8C30  01 01     ORA ($01,X)
$8C32  01 01     ORA ($01,X)
$8C34  01 01     ORA ($01,X)
$8C36  01 01     ORA ($01,X)
$8C38  50 01     BVC L_BRS_($8C3B)_($8C38) BAD
//------------------------------
L_BRS_($8C3B)_($8C38) BAD
//------------------------------
$8C3A  50 64     BVC L_BRS_($8CA0)_($8C3A) JAM
$8C3C  6E 01 01  ROR $0101 
$8C3F  01 01     ORA ($01,X)
$8C41  01 01     ORA ($01,X)
$8C43  01 01     ORA ($01,X)
$8C45  01 01     ORA ($01,X)
$8C47  01 01     ORA ($01,X)
$8C49  01 01     ORA ($01,X)
$8C4B  01 01     ORA ($01,X)
$8C4D  01 01     ORA ($01,X)
$8C4F  01 01     ORA ($01,X)
$8C51  01 01     ORA ($01,X)
$8C53  01 01     ORA ($01,X)
$8C55  01 01     ORA ($01,X)
$8C57  01 01     ORA ($01,X)
$8C59  01 01     ORA ($01,X)
$8C5B  01 01     ORA ($01,X)
$8C5D  B9 A4 BF  LDA $BFA4,Y 
$8C60            .byte $00
$8C61  30 11     BMI L_BRS_($8C74)_($8C61) JAM
$8C63            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C6B            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($8C74)_($8C61) JAM
//------------------------------
$8C73            .byte $00,$00
$8C75  A8        TAY 
$8C76            .byte $43
$8C77  A8        TAY 
$8C78            .byte $43
$8C79  18        CLC 
$8C7A  48        PHA 
$8C7B            .byte $00,$00,$00,$00,$00,$0F,$0F,$0F
$8C83            .byte $0F,$0F,$0F,$07,$07,$07,$07,$07
$8C8B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8C93            .byte $07,$07,$07,$07,$07,$07,$07,$07
//------------------------------
L_BRS_($8CA0)_($8C3A) JAM
//------------------------------
$8C9B            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8CA3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8CAB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8CB3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8CBB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8CC3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8CCB            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8CD3            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8CDB            .byte $07,$07,$07,$07,$07
$8CE0  26 06     ROL $06 
$8CE2            .byte $04,$14
$8CE4  45 45     EOR $45 
$8CE6  45 22     EOR $22 
$8CE8  01 11     ORA ($11,X)
$8CEA  31 33     AND ($33),Y 
$8CEC            .byte $03,$23,$13,$02,$22,$13
$8CF2  31 47     AND ($47),Y 
$8CF4            .byte $47,$47,$47,$47,$47,$47,$47,$47
$8CFC            .byte $47,$47,$47,$47,$00,$00,$00,$00
$8D04            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D0C            .byte $00,$47,$00,$00,$00,$00,$00,$00
$8D14            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D1C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D24            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D2C            .byte $00,$47,$00,$00,$00,$00,$00,$00
$8D34            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D3C            .byte $00,$47,$00,$00,$00,$00,$00,$00
$8D44            .byte $00,$00,$00,$00,$00
$8D49  66 00     ROR $00 
$8D4B  66 74     ROR $74 
$8D4D            .byte $74,$00,$00,$00,$5A,$00,$5A
$8D54  4C 4C 00  JMP $004C
$8D57            .byte $00,$00
$8D59  09 00     ORA #$00
$8D5B  09 00     ORA #$00
$8D5D            .byte $00,$00,$00,$00,$27,$00,$27,$00
$8D65            .byte $00,$00,$00,$43
$8D69  41 53     EOR ($53,X) 
$8D6B            .byte $54
$8D6C  20 4F 46  JSR L_JSR_($464F)_($8D6C) JAM
$8D6F  20 43 48  JSR L_JSR_($4843)_($8D6F) JAM
$8D72  41 52     EOR ($52,X) 
$8D74  41 43     EOR ($43,X) 
$8D76            .byte $54
$8D77  45 52     EOR $52 
$8D79            .byte $53,$00,$00,$00,$00,$00,$00,$00
$8D81            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D89            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D91            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D99            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DA1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DA9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DB1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DB9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DC1            .byte $00,$00,$00,$00,$00,$00,$00,$BB
$8DC9  E8        INX 
$8DCA            .byte $BB
$8DCB  E8        INX 
$8DCC            .byte $BB,$BB,$00,$00
$8DD0  E4 00     CPX $00 
$8DD2  E4 00     CPX $00 
$8DD4  E4 E4     CPX $E4 
$8DD6            .byte $00,$00,$82,$00,$82,$00,$82,$82
$8DDE            .byte $00,$00,$9E
$8DE1  E4 9E     CPX $9E 
$8DE3  E4 9E     CPX $9E 
$8DE5            .byte $9E,$00,$00
$8DE8  79 6F 75  ADC $756F,Y 
$8DEB            .byte $72
$8DEC  20 6F 77  JSR L_JSR_($776F)_($8DEC) BAD
$8DEF  6E 20 6E  ROR $6E20 
$8DF2  61 6D     ADC ($6D,X) 
$8DF4  65 73     ADC $73 
$8DF6  20 59 2F  JSR L_JSR_($2F59)_($8DF6) BAD
$8DF9  4E 3F 00  LSR $003F 
$8DFC            .byte $00,$00,$00,$00
//------------------------------
L_JSR_($8E00)_($66AA) OK
//------------------------------
$8E00  26 07     ROL $07 
$8E02  26 07     ROL $07 
$8E04  26 26     ROL $26 
$8E06            .byte $00,$00
$8E08  26 39     ROL $39 
$8E0A  26 42     ROL $42 
$8E0C  45 48     EOR $48 
$8E0E            .byte $00,$00,$00
$8E11  21 00     AND ($00,X) 
$8E13  21 00     AND ($00,X) 
$8E15            .byte $00,$00,$00,$00,$17,$00
$8E1B  11 00     ORA ($00),Y
$8E1D            .byte $17,$00,$00
$8E20  26 29     ROL $29 
$8E22  26 29     ROL $29 
$8E24  26 26     ROL $26 
$8E26            .byte $00,$00,$00,$00
$8E2A  26 42     ROL $42 
$8E2C  45 48     EOR $48 
$8E2E            .byte $00,$00
$8E30  26 2F     ROL $2F 
$8E32  26 2F     ROL $2F 
$8E34  26 26     ROL $26 
$8E36            .byte $00,$00
$8E38  26 39     ROL $39 
$8E3A            .byte $00,$00
$8E3C  45 48     EOR $48 
$8E3E            .byte $00,$00,$00
$8E41  75 00     ADC $00,X 
$8E43  75 00     ADC $00,X 
$8E45            .byte $00,$00,$00,$00
$8E49  69 00     ADC #$00
$8E4B  69 75     ADC #$75
$8E4D  75 78     ADC $78,X 
$8E4F  78        SEI 
$8E50            .byte $63
$8E51  58        CLI 
$8E52            .byte $63
$8E53  58        CLI 
$8E54            .byte $4B,$4B,$00,$00,$00,$0B,$00,$0B
$8E5C  19 19 00  ORA $0019,Y
$8E5F            .byte $00,$1F
$8E61  2A        ROL A 
$8E62            .byte $1F
$8E63  2A        ROL A 
$8E64            .byte $37,$37,$00,$00
$8E68  50 52     BVC L_BRS_($8EBC)_($8E68) JAM
$8E6A  45 53     EOR $53 
$8E6C            .byte $53,$27,$43,$27,$54,$4F
$8E72  20 43 48  JSR L_JSR_($4843)_($8E72) JAM
$8E75  41 4E     EOR ($4E,X) 
$8E77            .byte $47
$8E78  45 20     EOR $20 
$8E7A  4E 41 4D  LSR $4D41 
$8E7D  45 00     EOR $00 
$8E7F            .byte $00,$82,$00,$82,$00,$82,$82,$00
$8E87            .byte $00,$82,$82,$82,$82,$82,$82,$00
$8E8F            .byte $00,$A7,$00,$A7,$00,$A7,$A7,$00
$8E97            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E9F            .byte $00,$82,$00,$82,$00,$82,$82,$00
$8EA7            .byte $00,$00,$00,$82,$82,$82,$82,$00
$8EAF            .byte $00,$82,$00,$82,$00,$82,$82,$00
//------------------------------
L_BRS_($8EBC)_($8E68) JAM
//------------------------------
$8EB7            .byte $00,$82,$82,$00,$00,$82,$82,$00
$8EBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EC7            .byte $00
$8EC8  BD EB BD  LDA $BDEB,X 
$8ECB            .byte $EB
$8ECC  BD BD FA  LDA $FABD,X 
$8ECF            .byte $FA
$8ED0  E1 E4     SBC ($E4,X) 
$8ED2  E1 E4     SBC ($E4,X) 
$8ED4  E1 E1     SBC ($E1,X) 
$8ED6  C8        INY 
$8ED7  C8        INY 
$8ED8  84 8D     STY $8D 
$8EDA  84 8D     STY $8D 
$8EDC  84 84     STY $84 
$8EDE            .byte $FF,$FF
$8EE0  A1 AC     LDA ($AC,X) 
$8EE2  A1 AC     LDA ($AC,X) 
$8EE4  A1 A1     LDA ($A1,X) 
$8EE6  A9 A9     LDA #$A9
$8EE8            .byte $1A,$13,$A7
$8EEB  C8        INY 
$8EEC            .byte $6F
$8EED  26 D9     ROL $D9 
$8EEF  46 24     LSR $24 
$8EF1  7E CD E8  ROR $E8CD,X 
$8EF4  AD 0D 10  LDA $100D 
$8EF7            .byte $F8,$AF
$8EF9  0D CD E8  ORA $E8CD
$8EFC  AD 18 E9  LDA $E918 
$8EFF            .byte $00,$03
$8F01  08        PHP 
$8F02            .byte $03
$8F03  08        PHP 
$8F04  11 11     ORA ($11),Y
$8F06            .byte $00,$00,$34,$37,$3C
$8F0B  40        RTI 
//------------------------------
$8F0C  46 46     LSR $46 
$8F0E            .byte $00,$00,$03
$8F11  08        PHP 
$8F12            .byte $03
$8F13  08        PHP 
$8F14  11 11     ORA ($11),Y
$8F16            .byte $00,$00,$00
$8F19  18        CLC 
$8F1A            .byte $00,$1C,$00
$8F1D  18        CLC 
$8F1E            .byte $00,$00,$03
$8F21  08        PHP 
$8F22            .byte $03
$8F23  08        PHP 
$8F24  11 11     ORA ($11),Y
$8F26            .byte $00,$00,$00,$00,$3C
$8F2B  40        RTI 
//------------------------------
$8F2C  46 46     LSR $46 
$8F2E            .byte $00,$00,$03
$8F31  08        PHP 
$8F32            .byte $03
$8F33  08        PHP 
$8F34  11 11     ORA ($11),Y
$8F36            .byte $00,$00,$34,$37,$00,$00
$8F3C  46 46     LSR $46 
$8F3E            .byte $00,$00
$8F40  78        SEI 
$8F41            .byte $73
$8F42  78        SEI 
$8F43            .byte $73
$8F44  70 70     BVS L_BRS_($8FB6)_($8F44) JAM
$8F46  6C 00 00  JMP ($0000) 
$8F49  6C 00 6C  JMP ($6C00) 
$8F4C            .byte $00,$00,$7B,$7B
$8F50  60        RTS 
//------------------------------
$8F51  56 60     LSR $60,X 
$8F53  56 60     LSR $60,X 
$8F55  60        RTS 
//------------------------------
$8F56            .byte $00,$00,$00
$8F59  0E 00 0E  ASL $0E00 
$8F5C            .byte $1B,$1B,$00,$00
$8F60  CD 2D CD  CMP $CD2D 
$8F63  2D 00 00  AND $0000 
$8F66            .byte $00,$00
$8F68  45 4E     EOR $4E 
$8F6A            .byte $54
$8F6B  45 52     EOR $52 
$8F6D  20 4E 45  JSR L_JSR_($454E)_($8F6D) JAM
$8F70            .byte $57
$8F71  20 4E 41  JSR L_JSR_($414E)_($8F71) BAD
$8F74  4D 45 00  EOR $0045 
$8F77            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F7F            .byte $00
$8F80  85 00     STA $00 
$8F82  85 00     STA $00 
$8F84            .byte $92,$92,$97,$00
$8F88  B6 B8     LDX $B8,Y 
$8F8A  85 85     STA $85 
$8F8C  85 85     STA $85 
$8F8E            .byte $00,$00
$8F90  85 00     STA $00 
$8F92  85 00     STA $00 
$8F94            .byte $92,$92
$8F96  A4 00     LDY $00 
$8F98            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FA0  85 00     STA $00 
$8FA2  85 00     STA $00 
$8FA4            .byte $92,$92
$8FA6  AC 00 00  LDY $0000 
$8FA9            .byte $00
$8FAA  85 85     STA $85 
$8FAC  85 85     STA $85 
$8FAE            .byte $00,$00
$8FB0  85 00     STA $00 
$8FB2  85 00     STA $00 
//------------------------------
L_BRS_($8FB6)_($8F44) JAM
//------------------------------
$8FB4            .byte $92,$92,$B2,$00
$8FB8  B6 B8     LDX $B8,Y 
$8FBA            .byte $00,$00
$8FBC  85 85     STA $85 
$8FBE            .byte $00,$00
$8FC0  F6 00     INC $00,X 
$8FC2  F6 00     INC $00,X 
$8FC4            .byte $00,$00,$00,$00,$BF
$8FC9  EE BF EE  INC $EEBF 
$8FCC            .byte $BF,$BF
$8FCE  FD FD DE  SBC $DEFD,X 
$8FD1            .byte $D4
$8FD2  DE D4 DE  DEC $DED4,X 
$8FD5  DE C6 C6  DEC $C6C6,X 
$8FD8  86 90     STX $90 
$8FDA  86 90     STX $90 
$8FDC  86 86     STX $86 
$8FDE  CA        DEX 
$8FDF  CA        DEX 
$8FE0  A4 AF     LDY $AF 
$8FE2  A4 AF     LDY $AF 
$8FE4  A4 A4     LDY $A4 
$8FE6  B4 B4     LDY $B4,X 
//------------------------------
L_JSR_($8FE8)_($BF20) OK
L_JSR_($8FE8)_($FB3C) OK
//------------------------------
$8FE8  A9 8F     LDA #$8F
$8FEA  85 D7     STA $D7 
$8FEC  A9 47     LDA #$47
$8FEE  85 4F     STA $4F 
$8FF0  A5 72     LDA $72 
$8FF2  85 4E     STA $4E 
$8FF4  A0 0B     LDY #$0B
$8FF6  A9 00     LDA #$00
//------------------------------
L_BRS_($8FF8)_($8FFB) OK
//------------------------------
$8FF8  91 4E     STA ($4E),Y 
$8FFA  88        DEY 
$8FFB  10 FB     BPL L_BRS_($8FF8)_($8FFB) OK
$8FFD  60        RTS 
//------------------------------
$8FFE            .byte $00,$00,$00,$0B,$00
$9003  0E 13 13  ASL $1313 
$9006  18        CLC 
$9007            .byte $1B,$00,$00
$900A  3E 3E 00  ROL $003E,X 
$900D            .byte $00,$00,$00,$00,$0B,$00
$9013  0E 13 13  ASL $1313 
$9016  18        CLC 
$9017            .byte $1B,$00
$9019  19 00 1D  ORA $1D00,Y
$901C            .byte $00
$901D  19 00 00  ORA $0000,Y
$9020            .byte $00,$0B,$00
$9023  0E 13 13  ASL $1313 
$9026  18        CLC 
$9027            .byte $1B,$00,$00
$902A  3E 3E 00  ROL $003E,X 
$902D            .byte $00,$00,$00,$00,$0B,$00
$9033  0E 13 13  ASL $1313 
$9036  18        CLC 
$9037            .byte $1B,$00,$00,$00,$00,$00,$00,$00
$903F            .byte $1B,$00
$9041  7E 00 7B  ROR $7B00,X 
$9044  6E 6E 6A  ROR $6A6E 
$9047  68        PLA 
$9048            .byte $00,$6F,$00,$6F,$00,$00
$904E  45 45     EOR $45 
$9050  5D 53 5D  EOR $5D53,X 
$9053            .byte $4F
$9054  5D 5D 45  EOR $455D,X 
$9057  45 00     EOR $00 
$9059  11 00     ORA ($00),Y
$905B  16 00     ASL $00,X 
$905D            .byte $00
$905E  45 45     EOR $45 
$9060            .byte $00
$9061  30 00     BMI L_BRS_($9063)_($9061) OK
//------------------------------
L_BRS_($9063)_($9061) OK
//------------------------------
$9063  35 00     AND $00,X 
$9065            .byte $00
$9066  45 45     EOR $45 
$9068            .byte $4F
$9069  55 52     EOR $52,X 
$906B  20 48 45  JSR L_JSR_($4548)_($906B) JAM
$906E            .byte $52,$4F,$00,$00,$00,$00,$00,$00
$9076            .byte $00,$00,$00,$00,$00,$00,$00,$00
$907E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9086  9A        TXS 
$9087  9D 00 00  STA $0000,X 
$908A  85 85     STA $85 
$908C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9094            .byte $00,$00
$9096  9A        TXS 
$9097  A5 00     LDA $00 
$9099            .byte $00,$00,$00,$00,$00,$00,$00,$00
$90A1            .byte $00,$00,$00,$00,$00
$90A6  9A        TXS 
$90A7  AD 00 00  LDA $0000 
$90AA  85 85     STA $85 
//------------------------------
L_JSR_($90AE)_($6D16) JAM
//------------------------------
$90AC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$90B4            .byte $00,$00
$90B6  9A        TXS 
$90B7            .byte $B3,$00,$00,$00,$00,$00,$00,$00
$90BF            .byte $B3,$00,$00,$00,$00,$00,$00,$00
$90C7  E6 C1     INC $C1 
$90C9  F1 F3     SBC ($F3),Y 
$90CB  F1 C1     SBC ($C1),Y 
$90CD  C1 C3     CMP ($C3,X) 
$90CF            .byte $C3,$DB
$90D1  8D DB CD  STA $CDDB 
$90D4            .byte $DB,$DB,$C3,$C3
$90D8  88        DEY 
$90D9            .byte $93
$90DA  95 98     STA $98,X 
$90DC  88        DEY 
$90DD  88        DEY 
$90DE            .byte $C3,$C3
$90E0  A6 B2     LDX $B2 
$90E2  A6 8D     LDX $8D 
$90E4  A6 A6     LDX $A6 
$90E6            .byte $C3,$C3,$B8
$90E9  C6 D4     DEC $D4 
$90EB            .byte $E2,$9C
$90ED  8E AA 80  STX $80AA 
$90F0  40        RTI 
//------------------------------
$90F1  C5 CD     CMP $CD 
$90F3  E8        INX 
$90F4            .byte $AF
$90F5  C1 CD     CMP ($CD,X) 
$90F7            .byte $72
$90F8  B0 26     BCS L_BRS_($9120)_($90F8) JAM
$90FA  D9 E5 C3  CMP $C3E5,Y 
$90FD  E8        INX 
$90FE  B1 00     LDA ($00),Y 
$9100            .byte $00,$00,$00,$00
$9104  15 00     ORA $00,X
$9106            .byte $00,$00,$00,$00,$00,$00,$00,$00
$910E            .byte $00,$00,$00,$00,$00,$00
$9114  15 00     ORA $00,X
$9116            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($9120)_($90F8) JAM
//------------------------------
$911E            .byte $00,$00,$00,$00,$00,$00
$9124  15 00     ORA $00,X
$9126            .byte $00,$00,$00,$00,$00,$00,$00,$00
$912E            .byte $00,$00,$00,$00,$00,$00
$9134  15 00     ORA $00,X
$9136            .byte $00,$00,$00,$00,$00,$00,$00,$00
$913E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9146            .byte $00,$00,$3A,$67,$3A,$67,$3A,$3A
$914E            .byte $00,$00
$9150  65 59     ADC $59 
$9152  65 59     ADC $59 
$9154  65 65     ADC $65 
$9156            .byte $00,$00
$9158  01 0A     ORA ($0A,X)
$915A  01 0A     ORA ($0A,X)
$915C  01 01     ORA ($01,X)
$915E            .byte $00,$00
$9160  1D 28 1D  ORA $1D28,X
$9163  28        PLP 
$9164  1D 1D 00  ORA $001D,X
$9167            .byte $00,$54
$9169  48        PHA 
$916A  45 20     EOR $20 
$916C            .byte $53,$57,$4F,$54,$00,$00,$00,$00
$9174            .byte $00,$00,$00,$00,$00,$00,$00,$00
$917C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9184  95 00     STA $00,X 
$9186            .byte $00,$00,$00,$00,$00,$00,$00,$00
$918E            .byte $00,$00,$00,$00,$00,$00
$9194  95 00     STA $00,X 
$9196            .byte $00,$00,$00,$00,$00,$00,$00,$00
$919E            .byte $00,$00,$00,$00,$00,$00
$91A4  95 00     STA $00,X 
$91A6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91AE            .byte $00,$00,$00,$00,$00,$00
$91B4  95 00     STA $00,X 
$91B6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91BE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91C6            .byte $00,$00
$91C8  BA        TSX 
$91C9            .byte $E7
$91CA  BA        TSX 
$91CB            .byte $E7
$91CC  BA        TSX 
$91CD  BA        TSX 
$91CE            .byte $00,$00
$91D0  E5 D9     SBC $D9 
$91D2  E5 D9     SBC $D9 
$91D4  E5 E5     SBC $E5 
$91D6            .byte $00,$00
$91D8  81 8A     STA ($8A,X) 
$91DA  81 8A     STA ($8A,X) 
$91DC  81 81     STA ($81,X) 
$91DE            .byte $00,$00
$91E0  9D A8 9D  STA $9DA8,X 
$91E3  A8        TAY 
$91E4  9D 9D 00  STA $009D,X 
$91E7            .byte $00
//------------------------------
L_JMP_($91E8)_($98F8) OK
L_JMP_($91E8)_($D5A1) OK
//------------------------------
$91E8  A0 0E     LDY #$0E
$91EA  8A        TXA 
//------------------------------
L_JMP_($91EB)_($92FC) OK
L_JMP_($91EB)_($D093) OK
//------------------------------
$91EB  AA        TAX 
$91EC  88        DEY 
$91ED  88        DEY 
$91EE  10 06     BPL L_BRS_($91F6)_($91EE) OK
$91F0  8E 10 D0  STX $D010                          // Sprites 0-7 MSB of X coordinate
$91F3  4C 77 98  JMP L_JMP_($9877)_($91F3) OK
//------------------------------
L_BRS_($91F6)_($91EE) OK
//------------------------------
$91F6  8C E9 92  STY $92E9 
$91F9  8C EF 92  STY $92EF 
$91FC  4C E8 92  JMP L_JMP_($92E8)_($91FC) OK
$91FF            .byte $00
$9200  01 09     ORA ($09,X)
$9202  01 09     ORA ($09,X)
$9204  01 01     ORA ($01,X)
$9206            .byte $00,$00
$9208  01 3A     ORA ($3A,X)
$920A  01 44     ORA ($44,X)
$920C  01 01     ORA ($01,X)
$920E            .byte $00,$00
$9210  20 22 20  JSR L_JSR_($2022)_($9210) BAD
$9213            .byte $22
$9214  20 20 00  JSR $0020
$9217            .byte $00,$00,$00,$00,$14,$00,$00,$00
$921F            .byte $00
$9220  28        PLP 
$9221  2A        ROL A 
$9222  28        PLP 
$9223  2A        ROL A 
$9224  28        PLP 
$9225  28        PLP 
$9226            .byte $00,$00,$00,$00
$922A  28        PLP 
$922B            .byte $43
$922C  28        PLP 
$922D  28        PLP 
$922E            .byte $00,$00
$9230  2E 30 2E  ROL $2E30 
$9233  30 2E     BMI L_BRS_($9263)_($9233) JAM
$9235  2E 00 00  ROL $0000 
$9238  2E 3B 00  ROL $003B 
$923B            .byte $00
$923C  2E 2E 00  ROL $002E 
$923F            .byte $00
$9240  79 74 79  ADC $7974,Y 
$9243            .byte $74
$9244  71 71     ADC ($71),Y 
$9246            .byte $00,$00,$3C
$9249  6A        ROR A 
$924A            .byte $3C
$924B  6A        ROR A 
$924C  76 76     ROR $76,X 
$924E  79 79 62  ADC $6279,Y 
$9251            .byte $57,$62,$57,$62,$62
$9256  49 49     EOR #$49
$9258            .byte $03,$0C,$03,$0C,$1A,$1A,$42,$42
$9260  20 2B 20  JSR L_JSR_($202B)_($9260) OK
//------------------------------
L_BRS_($9263)_($9233) JAM
L_BRS_($9263)_($92B3) JAM
//------------------------------
$9263            .byte $2B
$9264  38        SEC 
$9265  38        SEC 
$9266  51 51     EOR ($51),Y 
$9268            .byte $54
$9269  48        PHA 
$926A  45 20     EOR $20 
$926C            .byte $54
$926D  45 41     EOR $41 
$926F            .byte $52
$9270  41 57     EOR ($57,X) 
$9272  41 59     EOR ($59,X) 
$9274            .byte $00,$00,$00,$00,$00,$00,$00,$00
$927C            .byte $00,$00,$00
$927F  49 81     EOR #$81
$9281            .byte $89
$9282  81 89     STA ($89,X) 
$9284  81 81     STA ($81,X) 
$9286            .byte $00,$00
$9288  81 BA     STA ($BA,X) 
$928A  81 C4     STA ($C4,X) 
$928C  81 81     STA ($81,X) 
$928E            .byte $00,$00
$9290  A0 A2     LDY #$A2
$9292  A0 A2     LDY #$A2
$9294  A0 A0     LDY #$A0
$9296            .byte $00,$00,$00,$00,$00
$929B  94 00     STY $00,X 
$929D            .byte $00,$00,$00
$92A0  A8        TAY 
$92A1  AA        TAX 
$92A2  A8        TAY 
$92A3  AA        TAX 
$92A4  A8        TAY 
$92A5  A8        TAY 
$92A6            .byte $00,$00,$00,$00
$92AA  A8        TAY 
$92AB            .byte $C3
$92AC  A8        TAY 
$92AD  A8        TAY 
$92AE            .byte $00,$00
$92B0  AE B0 AE  LDX $AEB0 
$92B3  B0 AE     BCS L_BRS_($9263)_($92B3) JAM
$92B5  AE 00 00  LDX $0000 
$92B8  AE BB 00  LDX $00BB 
$92BB            .byte $00
$92BC  AE AE 00  LDX $00AE 
$92BF            .byte $00
$92C0  F9 F4 F9  SBC $F9F4,Y 
$92C3            .byte $F4
$92C4  F1 F1     SBC ($F1),Y 
$92C6            .byte $00,$00
$92C8  BC EA BC  LDY $BCEA,X 
$92CB  EA        NOP 
$92CC  F6 F6     INC $F6,X 
$92CE  F9 F9 E2  SBC $E2F9,Y 
$92D1            .byte $D7,$E2,$D7,$E2,$E2
$92D6  C9 C9     CMP #$C9
$92D8            .byte $83
$92D9  8C 83 8C  STY $8C83 
$92DC  9A        TXS 
$92DD  9A        TXS 
$92DE            .byte $C2,$C2
$92E0  A0 AB     LDY #$AB
$92E2  A0 AB     LDY #$AB
$92E4            .byte $B8,$B8
$92E6  D1 D1     CMP ($D1),Y 
//------------------------------
L_JMP_($92E8)_($91FC) OK
L_JMP_($92E8)_($CFA3) OK
//------------------------------
$92E8  AD 00 D0  LDA $D000                          // Sprite 0 X Pos
$92EB  38        SEC 
$92EC  E9 40     SBC #$40
$92EE  8D 00 D0  STA $D000                          // Sprite 0 X Pos
$92F1  B0 04     BCS L_BRS_($92F7)_($92F1) OK
$92F3  8A        TXA 
$92F4  29 7F     AND #$7F
$92F6  AA        TAX 
//------------------------------
L_BRS_($92F7)_($92F1) OK
//------------------------------
$92F7  8A        TXA 
$92F8  18        CLC 
$92F9  2A        ROL A 
$92FA  69 00     ADC #$00
$92FC  4C EB 91  JMP L_JMP_($91EB)_($92FC) OK
$92FF  49 04     EOR #$04
$9301  0A        ASL A 
$9302            .byte $04
$9303  0A        ASL A 
$9304  10 10     BPL L_BRS_($9316)_($9304) JAM
$9306  16 00     ASL $00,X 
$9308  35 35     AND $35,X 
$930A  3D 41 04  AND $0441,X 
$930D            .byte $04,$00,$00
$9310  1E 1F 1E  ASL $1E1F,X 
$9313            .byte $1F
$9314  10 10     BPL L_BRS_($9326)_($9314) JAM
//------------------------------
L_BRS_($9316)_($9304) JAM
L_BRS_($9316)_($9384) JAM
//------------------------------
$9316            .byte $23,$00,$00,$1A,$00
$931B  1E 00 1A  ASL $1A00,X 
$931E            .byte $00,$00,$04
$9321  0A        ASL A 
$9322            .byte $04
$9323  0A        ASL A 
$9324  10 10     BPL L_BRS_($9336)_($9324) OK
//------------------------------
L_BRS_($9326)_($9314) JAM
L_BRS_($9326)_($9394) JAM
//------------------------------
$9326            .byte $2B,$00,$00,$00
$932A  3D 41 04  AND $0441,X 
$932D            .byte $04,$00,$00,$04
$9331  0A        ASL A 
$9332            .byte $04
$9333  0A        ASL A 
$9334  10 10     BPL L_BRS_($9346)_($9334) JAM
//------------------------------
L_BRS_($9336)_($9324) OK
L_BRS_($9336)_($93A4) OK
//------------------------------
$9336  31 00     AND ($00),Y 
$9338  35 35     AND $35,X 
$933A            .byte $00,$00,$04,$04,$00,$00,$77,$72
//------------------------------
L_BRS_($9346)_($9334) JAM
L_BRS_($9346)_($93B4) JAM
//------------------------------
$9342            .byte $77,$72,$6F,$6F,$6B,$00
$9348  3E 6D 3E  ROL $3E6D,X 
$934B  6D 77 77  ADC $7777 
$934E            .byte $7C,$7C,$5F
$9351  55 5F     EOR $5F,X 
$9353  55 5F     EOR $5F,X 
$9355            .byte $5F,$47,$47
$9358  05 0F     ORA $0F
$935A  05 0F     ORA $0F
$935C            .byte $1C,$1C
$935E  7E 7E 23  ROR $237E,X 
$9361  2E 23 2E  ROL $2E23 
$9364  39 39 22  AND $2239,Y 
$9367            .byte $22,$54
$9369  48        PHA 
$936A  45 20     EOR $20 
$936C            .byte $42
$936D  55 4C     EOR $4C,X 
$936F  4C 59 00  JMP $0059
$9372            .byte $00,$00,$00,$00,$00,$00,$00,$00
$937A            .byte $00,$00,$00,$00,$00,$00
$9380  84 8A     STY $8A 
$9382  84 8A     STY $8A 
$9384  90 90     BCC L_BRS_($9316)_($9384) JAM
$9386  96 00     STX $00,Y 
$9388  B5 B5     LDA $B5,X 
$938A  BD C1 84  LDA $84C1,X 
$938D  84 00     STY $00 
$938F            .byte $00,$9E,$9F,$9E,$9F
$9394  90 90     BCC L_BRS_($9326)_($9394) JAM
$9396            .byte $A3,$00,$00
$9399  9A        TXS 
$939A            .byte $00,$9E,$00
$939D  9A        TXS 
$939E            .byte $00,$00
$93A0  84 8A     STY $8A 
$93A2  84 8A     STY $8A 
$93A4  90 90     BCC L_BRS_($9336)_($93A4) OK
$93A6            .byte $AB,$00,$00,$00
$93AA  BD C1 84  LDA $84C1,X 
$93AD  84 00     STY $00 
$93AF            .byte $00
$93B0  84 8A     STY $8A 
$93B2  84 8A     STY $8A 
$93B4  90 90     BCC L_BRS_($9346)_($93B4) JAM
$93B6  B1 00     LDA ($00),Y 
$93B8  B5 B5     LDA $B5,X 
$93BA            .byte $00,$00
$93BC  84 84     STY $84 
$93BE            .byte $00,$00,$F7,$F2,$F7,$F2,$EF,$EF
$93C6            .byte $EB,$00
$93C8  BE ED BE  LDX $BEED,Y 
$93CB  ED F7 F7  SBC $F7F7 
$93CE            .byte $FC,$FC,$DF
$93D1  D5 DF     CMP $DF,X 
$93D3  D5 DF     CMP $DF,X 
$93D5            .byte $DF,$C7,$C7
$93D8  85 8F     STA $8F 
$93DA  85 8F     STA $8F 
$93DC            .byte $9C,$9C
$93DE  FE FE A3  INC $A3FE,X 
$93E1  AE A3 AE  LDX $AEA3 
$93E4  B9 B9 A2  LDA $A2B9,Y 
//------------------------------
L_JMP_($93E8)_($9874) BAD
L_JMP_($93E8)_($D526) BAD
//------------------------------
$93E7  A2 A0     LDX #$A0
//------------------------------
L_JMP_($93EB)_($94FC) BAD
L_JMP_($93EB)_($D284) BAD
//------------------------------
$93E9  0E 8A AA  ASL $AA8A 
$93EC  88        DEY 
$93ED  88        DEY 
$93EE  10 06     BPL L_BRS_($93F6)_($93EE) OK
$93F0  8E 10 D0  STX $D010                          // Sprites 0-7 MSB of X coordinate
$93F3  4C 77 98  JMP L_JMP_($9877)_($93F3) OK
//------------------------------
L_BRS_($93F6)_($93EE) OK
//------------------------------
$93F6  8C E9 94  STY $94E9 
$93F9  8C EF 94  STY $94EF 
$93FC  4C E8 94  JMP L_JMP_($94E8)_($93FC) BAD
$93FF            .byte $00
$9400  06 0C     ASL $0C 
$9402  0D 0F 14  ORA $140F
$9405            .byte $14
$9406  19 1C 06  ORA $061C,Y
$9409  06 3F     ASL $3F 
$940B            .byte $3F
$940C  06 06     ASL $06 
$940E            .byte $00,$00
$9410  06 0C     ASL $0C 
$9412  0D 0F 14  ORA $140F
$9415            .byte $14
$9416  19 1C 00  ORA $001C,Y
$9419            .byte $1B,$00,$1F,$00,$1B,$00,$00
$9420  06 0C     ASL $0C 
$9422  0D 0F 14  ORA $140F
$9425            .byte $14
$9426  19 1C 00  ORA $001C,Y
$9429            .byte $00,$3F,$3F
$942C  06 06     ASL $06 
$942E            .byte $00,$00
$9430  06 0C     ASL $0C 
$9432  0D 0F 14  ORA $140F
$9435            .byte $14
$9436  19 1C 06  ORA $061C,Y
$9439  06 00     ASL $00 
$943B            .byte $00
$943C  06 06     ASL $06 
$943E            .byte $00,$1C,$7F
$9441  7D 7C 7A  ADC $7A7C,X 
$9444  6D 6D 69  ADC $696D 
$9447            .byte $67
$9448  40        RTI 
//------------------------------
$9449  70 72     BVS L_BRS_($94BD)_($9449) BAD
$944B  70 40     BVS L_BRS_($948D)_($944B) BAD
$944D  40        RTI 
//------------------------------
$944E            .byte $44,$44,$5C,$52
$9452  50 4E     BVC L_BRS_($94A2)_($9452) OK
$9454            .byte $5C,$5C,$44,$44,$07,$12,$14,$17
$945C            .byte $07,$07,$44,$44
$9460  25 31     AND $31
$9462            .byte $33
$9463  36 25     ROL $25,X 
$9465  25 44     AND $44
$9467            .byte $44,$54
$9469  48        PHA 
$946A  45 20     EOR $20 
$946C  48        PHA 
$946D  49 53     EOR #$53
$946F            .byte $54,$4F,$52
$9472  59 20 4D  EOR $4D20,Y 
$9475  41 53     EOR ($53,X) 
$9477            .byte $54
$9478  45 52     EOR $52 
$947A            .byte $00,$00,$00,$00,$00,$00
$9480  86 8C     STX $8C 
$9482  8D 8F 94  STA $948F 
$9485  94 99     STY $99,X 
$9487            .byte $9C
$9488  86 86     STX $86 
$948A            .byte $BF,$BF
//------------------------------
L_BRS_($948D)_($944B) BAD
L_BRS_($948D)_($94CB) BAD
//------------------------------
$948C  86 86     STX $86 
$948E            .byte $00,$00
$9490  86 8C     STX $8C 
$9492  8D 8F 94  STA $948F 
$9495  94 99     STY $99,X 
$9497            .byte $9C,$00,$9B,$00,$9F,$00,$9B,$00
$949F            .byte $00
$94A0  86 8C     STX $8C 
//------------------------------
L_BRS_($94A2)_($9452) OK
L_BRS_($94A2)_($94D2) OK
//------------------------------
$94A2  8D 8F 94  STA $948F 
$94A5  94 99     STY $99,X 
$94A7            .byte $9C,$00,$00,$BF,$BF
$94AC  86 86     STX $86 
$94AE            .byte $00,$00
$94B0  86 8C     STX $8C 
$94B2  8D 8F 94  STA $948F 
$94B5  94 99     STY $99,X 
$94B7            .byte $9C
$94B8  86 86     STX $86 
$94BA            .byte $00,$00
//------------------------------
L_BRS_($94BD)_($9449) BAD
//------------------------------
$94BC  86 86     STX $86 
$94BE            .byte $00,$9C,$FF
$94C1  FD FC FA  SBC $FAFC,X 
$94C4  ED ED E9  SBC $E9ED 
$94C7            .byte $E7
$94C8  C0 F0     CPY #$F0
$94CA            .byte $F2
$94CB  F0 C0     BEQ L_BRS_($948D)_($94CB) BAD
$94CD  C0 C4     CPY #$C4
$94CF  C4 DC     CPY $DC 
$94D1            .byte $D2
$94D2  D0 CE     BNE L_BRS_($94A2)_($94D2) OK
$94D4            .byte $DC,$DC
$94D6  C4 C4     CPY $C4 
$94D8            .byte $87,$92
$94DA  94 97     STY $97,X 
$94DC            .byte $87,$87
$94DE  C4 C4     CPY $C4 
$94E0  A5 B1     LDA $B1 
$94E2            .byte $B3
$94E3  B6 A5     LDX $A5,Y 
$94E5  A5 C4     LDA $C4 
//------------------------------
L_JMP_($94E8)_($93FC) BAD
L_JMP_($94E8)_($D187) BAD
//------------------------------
$94E7  C4 AD     CPY $AD 
$94E9            .byte $00
$94EA  D0 18     BNE L_BRS_($9504)_($94EA) JAM
$94EC  69 40     ADC #$40
$94EE  8D 00 D0  STA $D000                          // Sprite 0 X Pos
$94F1  90 04     BCC L_BRS_($94F7)_($94F1) OK
$94F3  8A        TXA 
$94F4  09 80     ORA #$80
$94F6  AA        TAX 
//------------------------------
L_BRS_($94F7)_($94F1) OK
//------------------------------
$94F7  8A        TXA 
$94F8  18        CLC 
$94F9  2A        ROL A 
$94FA  69 00     ADC #$00
$94FC  4C EB 93  JMP L_JMP_($93EB)_($94FC) BAD
//------------------------------
L_BRS_($9504)_($94EA) JAM
//------------------------------
$94FF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9507            .byte $00,$00,$00,$00,$00,$00,$00,$00
$950F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9517            .byte $00,$00,$00,$00,$00,$00,$00,$00
$951F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9527            .byte $00,$00,$00,$00,$00,$00,$00,$00
$952F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9537            .byte $00,$00,$00,$00,$00,$00,$00,$00
$953F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9547            .byte $00,$3B
$9549  68        PLA 
$954A            .byte $3B
$954B  68        PLA 
$954C            .byte $3B,$3B,$00,$00,$64,$00,$64,$00
$9554            .byte $64,$64,$00,$00,$02,$00,$02,$00
$955C            .byte $02,$02,$00,$00
$9560  1E 64 1E  ASL $1E64,X 
$9563            .byte $64
$9564  1E 1E 00  ASL $001E,X 
$9567            .byte $00,$54
$9569  48        PHA 
$956A  45 20     EOR $20 
$956C            .byte $47
$956D  45 4F     EOR $4F 
$956F            .byte $47,$52
$9571  41 50     EOR ($50,X) 
$9573  48        PHA 
$9574  59 20 54  EOR $5420,Y 
$9577  45 41     EOR $41 
$9579            .byte $43
$957A  48        PHA 
$957B  45 52     EOR $52 
$957D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9585            .byte $00,$00,$00,$00,$00,$00,$00,$00
$958D            .byte $C7,$00,$00,$00,$00,$00,$00,$00
$9595            .byte $00,$00,$00,$00,$00,$00,$00,$00
$959D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95A5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95AD            .byte $C7,$00,$00,$00,$00,$00,$00,$00
$95B5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95BD            .byte $C7,$00,$00,$00,$00,$00,$00,$00
$95C5            .byte $00,$00,$00,$00
$95C9  E6 00     INC $00 
$95CB  E6 F4     INC $F4 
$95CD            .byte $F4,$00,$00,$00,$DA,$00,$DA
$95D4  CC CC 00  CPY $00CC 
$95D7            .byte $00,$00,$89,$00,$89,$00,$00,$00
$95DF            .byte $00,$00,$A7,$00,$A7,$00,$00,$00
$95E7            .byte $00
//------------------------------
L_JSR_($95E8)_($986C) OK
L_JSR_($95E8)_($98EC) OK
L_JSR_($95E8)_($D51E) OK
L_JSR_($95E8)_($D595) OK
//------------------------------
$95E8  AD 15 D0  LDA $D015                          // Sprite display Enable
$95EB  F0 0F     BEQ L_BRS_($95FC)_($95EB) OK
$95ED  AC 04 D0  LDY $D004                          // Sprite 2 X Pos
$95F0  A9 00     LDA #$00
$95F2  8D 15 D0  STA $D015                          // Sprite display Enable
$95F5  AD 10 D0  LDA $D010                          // Sprites 0-7 MSB of X coordinate
$95F8  2A        ROL A 
$95F9  4C FB 98  JMP L_JMP_($98FB)_($95F9) OK
//------------------------------
L_BRS_($95FC)_($95EB) OK
//------------------------------
$95FC  68        PLA 
$95FD  68        PLA 
$95FE  60        RTS 
//------------------------------
$95FF            .byte $00,$02,$00,$02,$00,$02,$02,$00
$9607            .byte $00,$02,$02,$02,$02,$02,$02,$00
$960F            .byte $00,$27,$00,$27,$00,$27,$27,$00
$9617            .byte $00,$00,$00,$00,$00,$00,$00,$00
$961F            .byte $00,$02,$00,$02,$00,$02,$02,$00
$9627            .byte $00,$00,$00,$02,$02,$02,$02,$00
$962F            .byte $00,$02,$00,$02,$00,$02,$02,$00
$9637            .byte $00,$02,$02,$00,$00,$02,$02,$00
$963F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9647            .byte $00
$9648  3D 6B 3D  AND $3D6B,X 
$964B            .byte $6B
$964C  3D 3D 7A  AND $7A3D,X 
$964F            .byte $7A
$9650  61 64     ADC ($64,X) 
$9652  61 64     ADC ($64,X) 
$9654  61 61     ADC ($61,X) 
$9656  48        PHA 
$9657  48        PHA 
$9658            .byte $04
$9659  0D 04 0D  ORA $0D04
$965C            .byte $04,$04,$7F,$7F
$9660  21 2C     AND ($2C,X) 
$9662  21 2C     AND ($2C,X) 
$9664  21 21     AND ($21,X) 
$9666  29 29     AND #$29
$9668            .byte $54
$9669  48        PHA 
$966A  45 20     EOR $20 
$966C            .byte $53,$43
$966E  49 45     EOR #$45
$9670  4E 43 45  LSR $4543 
$9673  20 54 45  JSR L_JSR_($4554)_($9673) JAM
$9676  41 43     EOR ($43,X) 
$9678  48        PHA 
$9679  45 52     EOR $52 
$967B            .byte $00,$00,$00,$00,$00
$9680  A6 87     LDX $87 
$9682  A6 87     LDX $87 
$9684  A6 A6     LDX $A6 
$9686            .byte $00,$00
$9688  A6 B9     LDX $B9 
$968A  A6 C2     LDX $C2 
$968C  C5 C8     CMP $C8 
$968E            .byte $00,$00,$00
$9691  A1 00     LDA ($00,X) 
$9693  A1 00     LDA ($00,X) 
$9695            .byte $00,$00,$00,$00,$97,$00
$969B  91 00     STA ($00),Y 
$969D            .byte $97,$00,$00
$96A0  A6 A9     LDX $A9 
$96A2  A6 A9     LDX $A9 
$96A4  A6 A6     LDX $A6 
$96A6            .byte $00,$00,$00,$00
$96AA  A6 C2     LDX $C2 
$96AC  C5 C8     CMP $C8 
$96AE            .byte $00,$00
$96B0  A6 AF     LDX $AF 
$96B2  A6 AF     LDX $AF 
$96B4  A6 A6     LDX $A6 
$96B6            .byte $00,$00
$96B8  A6 B9     LDX $B9 
$96BA            .byte $00,$00
$96BC  C5 C8     CMP $C8 
$96BE            .byte $00,$00,$00
$96C1  F5 00     SBC $00,X 
$96C3  F5 00     SBC $00,X 
$96C5            .byte $00,$00,$00,$00
$96C9  E9 00     SBC #$00
$96CB  E9 F5     SBC #$F5
$96CD  F5 F8     SBC $F8,X 
$96CF            .byte $F8,$E3
$96D1  D8        CLD 
$96D2            .byte $E3
$96D3  D8        CLD 
$96D4            .byte $CB,$CB,$00,$00,$00,$8B,$00,$8B
$96DC  99 99 00  STA $0099,Y 
$96DF            .byte $00,$9F
$96E1  AA        TAX 
$96E2            .byte $9F
$96E3  AA        TAX 
$96E4            .byte $B7,$B7,$00,$00
//------------------------------
L_JMP_($96E8)_($9871) OK
L_JMP_($96E8)_($98F5) OK
L_JMP_($96E8)_($D523) OK
L_JMP_($96E8)_($D59E) OK
//------------------------------
$96E8  A0 80     LDY #$80
//------------------------------
L_JMP_($96EA)_($97F9) OK
L_JMP_($96EA)_($D4D3) OK
//------------------------------
$96EA  C8        INY 
$96EB  C0 8A     CPY #$8A
$96ED  D0 01     BNE L_BRS_($96F0)_($96ED) OK
$96EF  60        RTS 
//------------------------------
L_BRS_($96F0)_($96ED) OK
//------------------------------
$96F0  8C FB 96  STY $96FB 
$96F3  8C EE 97  STY $97EE 
$96F6  8C F7 97  STY $97F7 
$96F9  AD 69 00  LDA $0069 
$96FC  4C E8 97  JMP L_JMP_($97E8)_($96FC) OK
$96FF            .byte $00
$9700  05 00     ORA $00
$9702  05 00     ORA $00
$9704            .byte $12,$12,$17,$00
$9708  36 38     ROL $38,X 
$970A  05 05     ORA $05
$970C  05 05     ORA $05
$970E            .byte $00,$00
$9710  05 00     ORA $00
$9712  05 00     ORA $00
$9714            .byte $12,$12
$9716  24 00     BIT $00 
$9718            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9720  05 00     ORA $00
$9722  05 00     ORA $00
$9724            .byte $12,$12
$9726  2C 00 00  BIT $0000 
$9729            .byte $00
$972A  05 05     ORA $05
$972C  05 05     ORA $05
$972E            .byte $00,$00
$9730  05 00     ORA $00
$9732  05 00     ORA $00
$9734            .byte $12,$12,$32,$00
$9738  36 38     ROL $38,X 
$973A            .byte $00,$00
$973C  05 05     ORA $05
$973E            .byte $00,$00
$9740  76 00     ROR $00,X 
$9742  76 00     ROR $00,X 
$9744            .byte $00,$00,$00,$00,$3F
$9749  6E 3F 6E  ROR $6E3F 
$974C            .byte $3F,$3F
$974E  7D 7D 5E  ADC $5E7D,X 
$9751            .byte $54
$9752  5E 54 5E  LSR $5E54,X 
$9755  5E 46 46  LSR $4646,X 
$9758  06 10     ASL $10 
$975A  06 10     ASL $10 
$975C  06 06     ASL $06 
$975E  4A        LSR A 
$975F  4A        LSR A 
$9760  24 2F     BIT $2F 
$9762  24 2F     BIT $2F 
$9764  24 24     BIT $24 
$9766            .byte $34,$34,$54
$9769  48        PHA 
$976A  45 20     EOR $20 
$976C  48        PHA 
$976D  45 41     EOR $41 
$976F            .byte $44
$9770  20 4D 41  JSR L_JSR_($414D)_($9770) OK
$9773            .byte $53,$54
$9775  45 52     EOR $52 
$9777            .byte $00,$00,$00,$00,$00,$00,$00,$00
$977F            .byte $00,$83
$9781  88        DEY 
$9782            .byte $83
$9783  88        DEY 
$9784  91 91     STA ($91),Y 
$9786            .byte $00,$00
$9788  B4 B7     LDY $B7,X 
$978A  BC C0 C6  LDY $C6C0,X 
$978D  C6 00     DEC $00 
$978F            .byte $00,$83
$9791  88        DEY 
$9792            .byte $83
$9793  88        DEY 
$9794  91 91     STA ($91),Y 
$9796            .byte $00,$00,$00
$9799  98        TYA 
$979A            .byte $00,$9C,$00
$979D  98        TYA 
$979E            .byte $00,$00,$83
$97A1  88        DEY 
$97A2            .byte $83
$97A3  88        DEY 
$97A4  91 91     STA ($91),Y 
$97A6            .byte $00,$00,$00,$00
$97AA  BC C0 C6  LDY $C6C0,X 
$97AD  C6 00     DEC $00 
$97AF            .byte $00,$83
$97B1  88        DEY 
$97B2            .byte $83
$97B3  88        DEY 
$97B4  91 91     STA ($91),Y 
//------------------------------
L_BRS_($97B6)_($97C4) JAM
//------------------------------
$97B6            .byte $00,$00
$97B8  B4 B7     LDY $B7,X 
$97BA            .byte $00,$00
$97BC  C6 C6     DEC $C6 
$97BE            .byte $00,$00,$F8,$F3,$F8,$F3
$97C4  F0 F0     BEQ L_BRS_($97B6)_($97C4) JAM
$97C6  EC 00 00  CPX $0000 
$97C9  EC 00 EC  CPX $EC00 
$97CC            .byte $00,$00,$FB,$FB
$97D0  E0 D6     CPX #$D6
$97D2  E0 D6     CPX #$D6
$97D4  E0 E0     CPX #$E0
$97D6            .byte $00,$00,$00
$97D9  8E 00 8E  STX $8E00 
$97DC            .byte $9B,$9B,$00,$00
$97E0  4D AD 4D  EOR $4DAD 
$97E3  AD 00 00  LDA $0000 
$97E6            .byte $00,$00
//------------------------------
L_JMP_($97E8)_($96FC) OK
L_JMP_($97E8)_($D3E8) OK
//------------------------------
$97E8  C9 58     CMP #$58
$97EA  D0 0D     BNE L_BRS_($97F9)_($97EA) OK
$97EC  AD 6A 00  LDA $006A 
$97EF  C9 24     CMP #$24
$97F1  D0 06     BNE L_BRS_($97F9)_($97F1) OK
$97F3  A9 62     LDA #$62
$97F5  8D 69 00  STA $0069 
$97F8  60        RTS 
//------------------------------
L_BRS_($97F9)_($97EA) OK
L_BRS_($97F9)_($97F1) OK
//------------------------------
$97F9  4C EA 96  JMP L_JMP_($96EA)_($97F9) OK
$97FC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9804            .byte $00,$00,$1A
$9807  1D 00 00  ORA $0000,X
$980A  05 05     ORA $05
$980C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9814            .byte $00,$00,$1A
$9817  25 00     AND $00
$9819            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9821            .byte $00,$00,$00,$00,$00,$1A
$9827  2D 00 00  AND $0000 
$982A  05 05     ORA $05
$982C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9834            .byte $00,$00,$1A,$33,$00,$00,$00,$00
$983C            .byte $00,$00,$00,$33,$00,$00,$00,$00
$9844            .byte $00,$00,$00
$9847  66 41     ROR $41 
$9849  71 73     ADC ($73),Y 
$984B  71 41     ADC ($41),Y 
$984D  41 43     EOR ($43,X) 
$984F            .byte $43,$5B
$9851  0D 5B 4D  ORA $4D5B
$9854            .byte $5B,$5B,$43,$43
$9858  08        PHP 
$9859            .byte $13
$985A  15 18     ORA $18,X
$985C  08        PHP 
$985D  08        PHP 
$985E            .byte $43,$43
$9860  26 32     ROL $32 
$9862  26 0D     ROL $0D 
$9864  26 26     ROL $26 
$9866            .byte $43,$43
//------------------------------
L_JSR_($9868)_($30DE) OK
//------------------------------
$9868  A9 CC     LDA #$CC	; Colorram?
$986A  85 5D     STA $5D 
$986C  20 E8 95  JSR L_JSR_($95E8)_($986C) OK
$986F  F0 03     BEQ L_BRS_($9874)_($986F) OK
$9871  4C E8 96  JMP L_JMP_($96E8)_($9871) OK
//------------------------------
L_BRS_($9874)_($986F) OK
//------------------------------
$9874  4C E8 93  JMP L_JMP_($93E8)_($9874) BAD
//------------------------------
L_JMP_($9877)_($91F3) OK
L_JMP_($9877)_($93F3) OK
L_JMP_($9877)_($CF9A) OK
L_JMP_($9877)_($D17E) OK
//------------------------------
$9877  A9 7F     LDA #$7F
$9879  8D 15 D0  STA $D015                          // Sprite display Enable
$987C  60        RTS 
//------------------------------
$987D            .byte $00,$00,$00,$00,$8B,$00
$9883  8E 93 93  STX $9393 
$9886  98        TYA 
$9887            .byte $9B,$00,$00
$988A  BE BE 00  LDX $00BE,Y 
$988D            .byte $00,$00,$00,$00,$8B,$00
$9893  8E 93 93  STX $9393 
$9896  98        TYA 
$9897            .byte $9B,$00
$9899  99 00 9D  STA $9D00,Y 
$989C            .byte $00
$989D  99 00 00  STA $0000,Y 
$98A0            .byte $00,$8B,$00
$98A3  8E 93 93  STX $9393 
$98A6  98        TYA 
$98A7            .byte $9B,$00,$00
$98AA  BE BE 00  LDX $00BE,Y 
$98AD            .byte $00,$00,$00,$00,$8B,$00
$98B3  8E 93 93  STX $9393 
$98B6  98        TYA 
$98B7            .byte $9B,$00,$00,$00,$00,$00,$00,$00
$98BF            .byte $9B,$00
$98C1  FE 00 FB  INC $FB00,X 
$98C4  EE EE EA  INC $EAEE 
$98C7  E8        INX 
$98C8            .byte $00,$EF,$00,$EF,$00,$00
$98CE  C5 C5     CMP $C5 
$98D0  DD D3 DD  CMP $DDD3,X 
$98D3            .byte $CF
$98D4  DD DD C5  CMP $C5DD,X 
$98D7  C5 00     CMP $00 
$98D9  91 00     STA ($00),Y 
$98DB  96 00     STX $00,Y 
$98DD            .byte $00
$98DE  C5 C5     CMP $C5 
$98E0            .byte $00
$98E1  B0 00     BCS L_BRS_($98E3)_($98E1) OK
//------------------------------
L_BRS_($98E3)_($98E1) OK
//------------------------------
$98E3  B5 00     LDA $00,X 
$98E5            .byte $00
$98E6  C5 C5     CMP $C5 
//------------------------------
L_JSR_($98E8)_($3180) OK
//------------------------------
$98E8  A9 CC     LDA #$CC	; Colorram?
$98EA  85 5D     STA $5D 
$98EC  20 E8 95  JSR L_JSR_($95E8)_($98EC) OK
$98EF  D0 07     BNE L_BRS_($98F8)_($98EF) OK
$98F1  C0 40     CPY #$40
$98F3  B0 03     BCS L_BRS_($98F8)_($98F3) OK
$98F5  4C E8 96  JMP L_JMP_($96E8)_($98F5) OK
//------------------------------
L_BRS_($98F8)_($98EF) OK
L_BRS_($98F8)_($98F3) OK
//------------------------------
$98F8  4C E8 91  JMP L_JMP_($91E8)_($98F8) OK
//------------------------------
L_JMP_($98FB)_($95F9) OK
L_JMP_($98FB)_($D2FF) OK
//------------------------------
$98FB  AA        TAX 
$98FC  29 08     AND #$08
$98FE  60        RTS 
//------------------------------
$98FF            .byte $00
$9900  10 00     BPL L_BRS_($9902)_($9900) JAM
//------------------------------
L_BRS_($9902)_($9900) JAM
//------------------------------
$9902            .byte $00,$00,$FF,$80,$7F,$00,$0F,$00
$990A            .byte $F8,$07
$990C  F0 7F     BEQ L_BRS_($998D)_($990C) OK
$990E            .byte $07
$990F  F0 7F     BEQ L_BRS_($9990)_($990F) OK
$9911            .byte $00,$80,$02,$80,$00,$00,$00,$00
$9919  60        RTS 
//------------------------------
$991A            .byte $F8,$00,$00,$00,$FF,$F8,$00,$00
$9922            .byte $00,$00,$00,$00,$00,$00,$00,$00
$992A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9932            .byte $00,$00
$9934  01 FF     ORA ($FF,X)
$9936            .byte $80,$7F
$9938  C0 00     CPY #$00
//------------------------------
L_BRS_($9941)_($995B) JAM
//------------------------------
$993A            .byte $00,$00,$14,$7F,$00,$4F,$7F,$FF
$9942            .byte $00,$00,$00
$9945  10 07     BPL L_BRS_($994E)_($9945) JAM
$9947            .byte $00
$9948  0A        ASL A 
//------------------------------
L_BRS_($994E)_($9945) JAM
//------------------------------
$9949            .byte $00,$04,$14,$00,$00,$8F
$994F  0E E4 00  ASL $00E4 
$9952            .byte $E7,$0C,$80
$9955  E4 3E     CPX $3E 
$9957            .byte $9C,$0B,$00,$00
$995B  F0 E4     BEQ L_BRS_($9941)_($995B) JAM
$995D            .byte $00
$995E  48        PHA 
$995F  EE 03 C0  INC $C003 
$9962  B9 00 00  LDA $0000,Y 
$9965            .byte $00,$00,$00,$00
$9969  FE 03 00  INC $0003,X 
$996C            .byte $00
$996D  40        RTI 
//------------------------------
$996E  01 3E     ORA ($3E,X)
$9970            .byte $00,$00
$9972  F0 02     BEQ L_BRS_($9976)_($9972) JAM
//------------------------------
L_BRS_($9976)_($9972) JAM
//------------------------------
$9974            .byte $00,$00,$00,$2F,$00,$00
$997A  F0 07     BEQ L_BRS_($9983)_($997A) JAM
$997C            .byte $7F
$997D  F0 07     BEQ L_BRS_($9986)_($997D) BAD
$997F            .byte $7F
$9980  08        PHP 
//------------------------------
L_BRS_($9983)_($997A) JAM
//------------------------------
$9981            .byte $00,$00,$00,$FF
//------------------------------
L_BRS_($9986)_($997D) BAD
//------------------------------
$9985  01 FE     ORA ($FE,X)
$9987            .byte $00
$9988  F0 00     BEQ L_BRS_($998A)_($9988) JAM
//------------------------------
L_BRS_($998A)_($9988) JAM
//------------------------------
$998A            .byte $1F
$998B  E0 0F     CPX #$0F
//------------------------------
L_BRS_($998D)_($990C) OK
//------------------------------
$998D  FE E0 0F  INC $0FE0,X 
//------------------------------
L_BRS_($9990)_($990F) OK
//------------------------------
$9990  FE 00 01  INC $0100,X 
$9993  40        RTI 
//------------------------------
$9994  01 00     ORA ($00,X)
$9996            .byte $00,$00,$00
$9999  06 1F     ASL $1F 
$999B            .byte $00,$00,$00,$FF,$1F,$00,$00,$00
$99A3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$99AB            .byte $00,$00,$00,$00,$00,$00,$00,$00
$99B3            .byte $00,$80,$FF
$99B6  01 FE     ORA ($FE,X)
$99B8            .byte $03,$00,$00,$00
$99BC  28        PLP 
$99BD  FE 00 F2  INC $F200,X 
$99C0  FE FF 00  INC $00FF,X 
$99C3            .byte $00,$00
$99C5  08        PHP 
$99C6  E0 00     CPX #$00
$99C8  50 00     BVC L_BRS_($99CA)_($99C8) OK
//------------------------------
L_BRS_($99CA)_($99C8) OK
//------------------------------
$99CA  20 28 00  JSR $0028
$99CD            .byte $00
$99CE  F1 70     SBC ($70),Y 
$99D0            .byte $27,$00,$E7
$99D3  30 01     BMI L_BRS_($99D6)_($99D3) JAM
//------------------------------
L_BRS_($99D6)_($99D3) JAM
//------------------------------
$99D5            .byte $27,$7C
$99D7  39 D0 00  AND $00D0,Y 
$99DA            .byte $00,$0F,$27,$00,$12,$77
$99E0  C0 03     CPY #$03
$99E2  9D 00 00  STA $0000,X 
$99E5            .byte $00,$00,$00,$00,$7F
$99EA  C0 00     CPY #$00
$99EC            .byte $00,$02,$80,$7C,$00,$00,$0F
$99F3  40        RTI 
//------------------------------
L_BRS_($99F8)_($9A07) JAM
//------------------------------
$99F4            .byte $00,$00,$00,$F4,$00,$00,$0F
$99FB  E0 FE     CPX #$FE
$99FD            .byte $0F
$99FE  E0 FE     CPX #$FE
$9A00            .byte $00,$07,$FF
$9A03  FE FF BF  INC $BFFF,X 
$9A06            .byte $7F
$9A07  F0 EF     BEQ L_BRS_($99F8)_($9A07) JAM
$9A09            .byte $7F,$FB,$C7,$F7,$7F,$E7,$F7,$7F
$9A11            .byte $FF,$BF,$FA,$BF,$FF,$FF,$FF,$FF
$9A19  6E FB FF  ROR $FFFB 
$9A1C            .byte $FF
$9A1D  FD FF FB  SBC $FBFF,X 
$9A20            .byte $C3
$9A21  FD 3F FF  SBC $FF3F,X 
$9A24            .byte $FF,$00,$FF,$FF,$87,$F8,$7F,$FF
$9A2C            .byte $FF,$FF,$83,$F8,$3F,$00,$FF
$9A33  FD F9 FF  SBC $FFF9,X 
$9A36            .byte $BF,$7F,$DF,$FF,$07,$83,$D4,$7F
$9A3E            .byte $FF,$4F,$7F,$FF,$FF,$87,$07,$D7
$9A46            .byte $F7,$FF
$9A48  EA        NOP 
$9A49            .byte $EF,$F4,$D4,$FF,$7F,$8F
$9A4F  EE E4 7F  INC $7FE4 
$9A52            .byte $E7
$9A53  EC BF E4  CPX $E4BF 
$9A56  BE 9D EB  LDX $EB9D,Y 
$9A59            .byte $3F,$FC,$F7
$9A5C  E4 FE     CPX $FE 
$9A5E            .byte $4B
$9A5F  EE FB DF  INC $DFFB 
$9A62  B9 FE FF  LDA $FFFE,Y                          // Vector: IRQ
$9A65            .byte $C3,$FF,$FF,$FF
$9A69  FE FB 87  INC $87FB,X 
$9A6C            .byte $FF,$5F
$9A6E  FD BE FF  SBC $FFBE,X 
$9A71            .byte $FF,$F7,$FA,$FF,$FF,$7F,$AF,$FF
$9A79            .byte $FF,$F7,$E7,$7F,$F7,$C7,$7F,$00
$9A81  E0 FF     CPX #$FF
$9A83            .byte $7F,$FF
$9A85  FD FE 0F  SBC $0FFE,X 
$9A88            .byte $F7
$9A89  FE DF E3  INC $E3DF,X 
$9A8C            .byte $EF
$9A8D  FE E7 EF  INC $EFE7,X 
$9A90  FE FF FD  INC $FDFF,X 
$9A93            .byte $5F
$9A94  FD FF FF  SBC $FFFF,X 
$9A97            .byte $FF,$FF
$9A99  76 DF     ROR $DF,X 
$9A9B            .byte $FF,$FF,$BF,$FF,$DF,$C3,$BF,$FC
$9AA3            .byte $FF,$FF,$00,$FF,$FF
$9AA8  E1 1F     SBC ($1F,X) 
$9AAA  FE FF FF  INC $FFFF,X 
$9AAD            .byte $FF
$9AAE  C1 1F     CMP ($1F,X) 
$9AB0            .byte $FC,$00,$FF,$BF,$9F,$FF
$9AB6  FD FE FB  SBC $FBFE,X 
$9AB9            .byte $FF
$9ABA  E0 C1     CPX #$C1
$9ABC            .byte $2B
$9ABD  FE FF F2  INC $F2FF,X 
$9AC0  FE FF FF  INC $FFFF,X 
$9AC3  E1 E0     SBC ($E0,X) 
$9AC5            .byte $EB,$EF,$FF,$57,$F7,$2F,$2B,$FF
$9ACD  FE F1 77  INC $77F1,X 
$9AD0            .byte $27
$9AD1  FE E7 37  INC $37E7,X 
$9AD4  FD 27 7D  SBC $7D27,X 
$9AD7  B9 D7 FC  LDA $FCD7,Y 
$9ADA            .byte $3F,$EF,$27,$7F,$D2,$77,$DF,$FB
$9AE2  9D 7F FF  STA $FF7F,X 
$9AE5            .byte $C3,$FF,$FF,$FF,$7F,$DF
$9AEB  E1 FF     SBC ($FF,X) 
$9AED            .byte $FA,$BF
$9AEF  7D FF FF  ADC $FFFF,X 
$9AF2            .byte $EF,$5F,$FF,$FF
$9AF6  FE F5 FF  INC $FFF5,X 
$9AF9            .byte $FF,$EF,$E7
$9AFC  FE EF E3  INC $E3EF,X 
$9AFF  FE 00 F8  INC $F800,X 
$9B02            .byte $00,$00,$FF,$80
$9B06  7E 0F 0F  ROR $0F0F,X 
$9B09            .byte $80,$F8,$03
$9B0C  20 7E 0B  JSR L_JSR_($0B7E)_($9B0C) BAD
$9B0F  D0 3F     BNE L_BRS_($9B50)_($9B0F) JAM
//------------------------------
L_BRS_($9B13)_($9B19) JAM
//------------------------------
$9B11            .byte $00,$80,$03,$80,$00,$00,$00,$00
$9B19  90 F8     BCC L_BRS_($9B13)_($9B19) JAM
$9B1B            .byte $00,$00,$02,$FB,$B8,$3C,$03
$9B22  C0 00     CPY #$00
$9B24            .byte $00,$00,$00,$00
$9B28  78        SEI 
$9B29            .byte $07,$80,$00,$00,$00,$7C,$07
$9B30  C0 00     CPY #$00
$9B32            .byte $00,$02,$07,$FF
$9B36  C0 20     CPY #$20
$9B38  C0 00     CPY #$00
//------------------------------
L_BRS_($9B41)_($9B5B) JAM
//------------------------------
$9B3A            .byte $F8,$7C,$1F,$FF,$00,$93,$02,$7F
$9B42            .byte $00
$9B43  78        SEI 
$9B44            .byte $F8
$9B45  28        PLP 
$9B46            .byte $03,$00
$9B48  0E 10 02  ASL $0210 
//------------------------------
L_BRS_($9B50)_($9B0F) JAM
//------------------------------
$9B4B            .byte $12,$00,$00,$8F,$0F,$F4,$00,$F3
$9B53            .byte $0C,$80
$9B55  E8        INX 
$9B56  26 FE     ROL $FE 
$9B58            .byte $0F
$9B59  C0 03     CPY #$03
$9B5B  70 E4     BVS L_BRS_($9B41)_($9B5B) JAM
$9B5D            .byte $00
$9B5E  88        DEY 
$9B5F  6E 02 E0  ROR $E002 
$9B62            .byte $FF,$00,$00,$3C,$00,$00,$00
$9B69  7E 02 78  ROR $7802,X 
$9B6C            .byte $00
$9B6D  C0 01     CPY #$01
$9B6F            .byte $1F,$00,$00,$F8,$07,$00,$00,$80
//------------------------------
L_BRS_($9B79)_($9B87) JAM
//------------------------------
$9B77            .byte $7F,$00,$00
$9B7A  D0 0B     BNE L_BRS_($9B87)_($9B7A) OK
$9B7C  7E 20 03  ROR $0320,X 
$9B7F  7E 00 1F  ROR $1F00,X 
$9B82            .byte $00,$00,$FF
$9B85  01 7E     ORA ($7E,X)
//------------------------------
L_BRS_($9B87)_($9B7A) OK
//------------------------------
$9B87  F0 F0     BEQ L_BRS_($9B79)_($9B87) JAM
$9B89  01 1F     ORA ($1F,X)
$9B8B  C0 04     CPY #$04
$9B8D  7E D0 0B  ROR $0BD0,X 
$9B90            .byte $FC,$00
$9B92  01 C0     ORA ($C0,X)
$9B94  01 00     ORA ($00,X)
$9B96            .byte $00,$00,$00
$9B99  09 1F     ORA #$1F
$9B9B            .byte $00,$00
$9B9D  40        RTI 
//------------------------------
$9B9E            .byte $DF
$9B9F  1D 3C C0  ORA $C03C,X
$9BA2            .byte $03,$00,$00,$00,$00,$00
$9BA8  1E E0 01  ASL $01E0,X 
$9BAB            .byte $00,$00,$00
$9BAE  3E E0 03  ROL $03E0,X 
$9BB1            .byte $00,$00
$9BB3  40        RTI 
//------------------------------
$9BB4  E0 FF     CPX #$FF
$9BB6            .byte $03,$04,$03,$00,$1F
$9BBB  3E F8 FF  ROL $FFF8,X                          // SYSTEM
$9BBE            .byte $00
$9BBF  C9 40     CMP #$40
$9BC1  FE 00 1E  INC $1E00,X 
$9BC4            .byte $1F,$14
$9BC6  C0 00     CPY #$00
$9BC8  70 08     BVS L_BRS_($9BD2)_($9BC8) JAM
$9BCA  40        RTI 
//------------------------------
$9BCB  48        PHA 
$9BCC            .byte $00,$00
$9BCE  F1 F0     SBC ($F0),Y 
//------------------------------
L_BRS_($9BD2)_($9BC8) JAM
//------------------------------
$9BD0            .byte $2F,$00,$CF
$9BD3  30 01     BMI L_BRS_($9BD6)_($9BD3) JAM
//------------------------------
L_BRS_($9BD6)_($9BD3) JAM
//------------------------------
$9BD5            .byte $17,$64,$7F
$9BD8  F0 03     BEQ L_BRS_($9BDD)_($9BD8) JAM
$9BDA  C0 0E     CPY #$0E
//------------------------------
L_BRS_($9BDD)_($9BD8) JAM
//------------------------------
$9BDC            .byte $27,$00
$9BDE  11 76     ORA ($76),Y
$9BE0  40        RTI 
//------------------------------
$9BE1            .byte $07,$FF,$00,$00,$3C,$00,$00,$00
$9BE9  7E 40 1E  ROR $1E40,X 
$9BEC            .byte $00,$03,$80,$F8,$00,$00,$1F
$9BF3  E0 00     CPX #$00
$9BF5            .byte $00
$9BF6  01 FE     ORA ($FE,X)
$9BF8            .byte $00,$00,$0B,$14
$9BFC  7E 04 C0  ROR $C004,X 
$9BFF  7E 00 FB  ROR $FB00,X 
$9C02            .byte $FF
$9C03  FE FF BF  INC $BFFF,X 
$9C06  7E EF EF  ROR $EFEF,X 
$9C09            .byte $BF,$FB,$FB,$2F
$9C0D  7E EB D7  ROR $D7EB,X 
$9C10            .byte $BF,$FF,$BF,$FB,$BF,$FF,$F8,$3F
$9C18  FE 94 FB  INC $FB94,X 
$9C1B            .byte $FF,$FF,$C2,$FB,$BB
$9C20  BC FB CF  LDY $CFFB,X 
$9C23  FE 1F F3  INC $F31F,X                          // Set File values
$9C26  FE FF 7B  INC $7BFF,X 
$9C29            .byte $F7,$BF,$FC,$3F,$83
$9C2E  7D F7 DF  ADC $DFF7,X 
$9C31            .byte $FC,$1F,$02,$F7,$FF,$DF
$9C37  A0 DF     LDY #$DF
$9C39  FE FB 7D  INC $7DFB,X 
$9C3C            .byte $DF,$FF
$9C3E  FE 93 82  INC $8293,X 
$9C41            .byte $7F
$9C42  FE 7B FB  INC $FB7B,X 
$9C45  AA        TAX 
$9C46            .byte $FB,$FF
$9C48  EE D7 FA  INC $FAD7 
$9C4B            .byte $D2,$FF,$7F,$8F,$EF,$F4,$7F,$F3
$9C53  EC BF E8  CPX $E8BF 
$9C56  A6 FE     LDX $FE 
$9C58            .byte $EF,$DF,$FB,$77
$9C5C  E4 FE     CPX $FE 
$9C5E            .byte $8B
$9C5F  6E FA EF  ROR $EFFA 
$9C62            .byte $FF
$9C63  FE FF BD  INC $BDFF,X 
$9C66  E1 FF     SBC ($FF,X) 
$9C68            .byte $FF
$9C69  7E FA 7B  ROR $7BFA,X 
$9C6C            .byte $FF,$DF
$9C6E  FD DF FF  SBC $FFDF,X 
$9C71            .byte $FF,$FB,$F7,$FF,$FF,$BF,$7F,$FF
$9C79            .byte $FF,$D7,$EB
$9C7C  7E 2F FB  ROR $FB2F,X 
$9C7F  7E 00 DF  ROR $DF00,X 
$9C82            .byte $FF,$7F,$FF
$9C85  FD 7E F7  SBC $F77E,X 
$9C88            .byte $F7
$9C89  FD DF DF  SBC $DFDF,X 
$9C8C            .byte $F4
$9C8D  7E D7 EB  ROR $EBD7,X 
$9C90  FD FF FD  SBC $FDFF,X 
$9C93            .byte $DF
$9C94  FD FF 1F  SBC $1FFF,X 
$9C97            .byte $FC,$7F
$9C99  29 DF     AND #$DF
$9C9B            .byte $FF,$FF,$43,$DF
$9C9F  DD 3D DF  CMP $DF3D,X 
$9CA2            .byte $F3,$7F,$F8,$CF,$7F,$FF
$9CA8  DE EF FD  DEC $FDEF,X 
$9CAB            .byte $3F,$FC
$9CAD  C1 BE     CMP ($BE,X) 
$9CAF            .byte $EF,$FB,$3F,$F8
$9CB3  40        RTI 
//------------------------------
$9CB4            .byte $EF,$FF,$FB
$9CB7  05 FB     ORA $FB
$9CB9            .byte $7F,$DF
$9CBB  BE FB FF  LDX $FFFB,Y 
$9CBE            .byte $7F
$9CBF  C9 41     CMP #$41
$9CC1  FE 7F DE  INC $DE7F,X 
$9CC4            .byte $DF
$9CC5  55 DF     EOR $DF,X 
$9CC7            .byte $FF,$77,$EB,$5F,$4B,$FF
$9CCD  FE F1 F7  INC $F7F1,X 
$9CD0            .byte $2F
$9CD1  FE CF 37  INC $37CF,X 
$9CD4  FD 17 65  SBC $6517,X 
$9CD7            .byte $7F,$F7,$FB,$DF
$9CDB  EE 27 7F  INC $7F27 
$9CDE  D1 76     CMP ($76),Y 
$9CE0            .byte $5F,$F7,$FF,$7F,$FF
$9CE5  BD 87 FF  LDA $FF87,X                          // Init Ram & Buffers
$9CE8            .byte $FF
$9CE9  7E 5F DE  ROR $DE5F,X 
$9CEC            .byte $FF,$FB,$BF,$FB,$FF,$FF,$DF,$EF
$9CF4            .byte $FF,$FF
$9CF6  FD FE FF  SBC $FFFE,X                          // Vector: IRQ
$9CF9            .byte $FF,$EB,$D7
$9CFC  7E F4 DF  ROR $DFF4,X 
$9CFF  7E 00 7C  ROR $7C00,X 
$9D02            .byte $00,$00,$FF,$80
$9D06  2A        ROL A 
$9D07            .byte $07,$0F
$9D09  C0 F8     CPY #$F8
$9D0B            .byte $02
$9D0C  40        RTI 
//------------------------------
$9D0D  2A        ROL A 
$9D0E            .byte $0B
$9D0F  50 7F     BVC L_BRS_($9D90)_($9D0F) OK
$9D11            .byte $00,$80,$03,$80,$00,$07
$9D17  C0 01     CPY #$01
$9D19            .byte $0B,$FC,$00,$00
$9D1D  2E FF F8  ROL $F8FF 
$9D20            .byte $4F,$04
$9D22  F0 01     BEQ L_BRS_($9D25)_($9D22) BAD
//------------------------------
L_BRS_($9D25)_($9D22) BAD
//------------------------------
$9D24  E0 0C     CPX #$0C
$9D26            .byte $00,$00,$FC,$0F
$9D2A  C0 03     CPY #$03
$9D2C  C0 6C     CPY #$6C
$9D2E            .byte $82
$9D2F  08        PHP 
$9D30  20 03 E0  JSR L_JSR_($E003)_($9D30) JAM
$9D33            .byte $5A,$0B,$FF
$9D36  C0 00     CPY #$00
$9D38            .byte $00,$00,$7C,$82,$07,$FF,$00
$9D3F  A2 03     LDX #$03
$9D41            .byte $FF,$00,$FC,$7C
$9D45  38        SEC 
$9D46  01 00     ORA ($00,X)
$9D48            .byte $0C
$9D49  28        PLP 
$9D4A  01 17     ORA ($17,X)
$9D4C            .byte $00,$00,$9F,$0F,$F4,$00
$9D52  F1 09     SBC ($09),Y 
$9D54  40        RTI 
//------------------------------
$9D55            .byte $EF
$9D56  1E ED 14  ASL $14ED,X 
$9D59  20 04 70  JSR L_JSR_($7004)_($9D59) JAM
$9D5C  E4 00     CPX $00 
$9D5E            .byte $F4
$9D5F  EE 01 D0  INC $D001                          // Sprite 0 Y Pos
$9D62  6E 01 00  ROR $0001 
$9D65            .byte $42
$9D66  16 00     ASL $00,X 
$9D68            .byte $00
$9D69  3E 04 5C  ROL $5C04,X 
$9D6C            .byte $00
$9D6D  C0 01     CPY #$01
$9D6F            .byte $3F,$00,$00,$B8,$07,$00,$00,$80
$9D77            .byte $7B,$00,$00
$9D7A  50 0B     BVC L_BRS_($9D87)_($9D7A) OK
$9D7C  2A        ROL A 
$9D7D  40        RTI 
//------------------------------
$9D7E            .byte $02
$9D7F  2A        ROL A 
$9D80            .byte $00
$9D81  3E 00 00  ROL $0000,X 
$9D84            .byte $FF
$9D85  01 54     ORA ($54,X)
//------------------------------
L_BRS_($9D87)_($9D7A) OK
//------------------------------
$9D87  E0 F0     CPX #$F0
$9D89            .byte $03,$1F
$9D8B  40        RTI 
//------------------------------
$9D8C            .byte $02,$54
$9D8E  D0 0A     BNE L_BRS_($9D9A)_($9D8E) BAD
//------------------------------
L_BRS_($9D90)_($9D0F) OK
//------------------------------
$9D90  FE 00 01  INC $0100,X 
$9D93  C0 01     CPY #$01
$9D95            .byte $00
$9D96  E0 03     CPX #$03
$9D98            .byte $80
//------------------------------
L_BRS_($9D9A)_($9D8E) BAD
//------------------------------
$9D99  D0 3F     BNE L_BRS_($9DDA)_($9D99) OK
$9D9B            .byte $00,$00,$74,$FF,$1F,$F2
$9DA1  20 0F 80  JSR L_JSR_($800F)_($9DA1) OK
$9DA4            .byte $07
$9DA5  30 00     BMI L_BRS_($9DA7)_($9DA5) JAM
//------------------------------
L_BRS_($9DA7)_($9DA5) JAM
//------------------------------
$9DA7            .byte $00,$3F
$9DA9  F0 03     BEQ L_BRS_($9DAE)_($9DA9) BAD
$9DAB  C0 03     CPY #$03
//------------------------------
L_BRS_($9DAE)_($9DA9) BAD
//------------------------------
$9DAD  36 41     ROL $41,X 
$9DAF  10 04     BPL L_BRS_($9DB5)_($9DAF) BAD
$9DB1  C0 07     CPY #$07
$9DB3            .byte $5A
//------------------------------
L_BRS_($9DB5)_($9DAF) BAD
L_BRS_($9DB5)_($9DB4) BAD
//------------------------------
$9DB4  D0 FF     BNE L_BRS_($9DB5)_($9DB4) BAD
$9DB6            .byte $03,$00,$00,$00
$9DBA  3E 41 E0  ROL $E041,X 
$9DBD            .byte $FF,$00
$9DBF  45 C0     EOR $C0 
$9DC1            .byte $FF,$00,$3F
$9DC4  3E 1C 80  ROL $801C,X 
$9DC7            .byte $00
$9DC8  30 14     BMI L_BRS_($9DDE)_($9DC8) JAM
$9DCA            .byte $80
$9DCB  E8        INX 
$9DCC            .byte $00,$00
$9DCE  F9 F0 2F  SBC $2FF0,Y 
$9DD1            .byte $00,$8F
$9DD3  90 02     BCC L_BRS_($9DD7)_($9DD3) JAM
$9DD5            .byte $F7
$9DD6  78        SEI 
//------------------------------
L_BRS_($9DD7)_($9DD3) JAM
//------------------------------
$9DD7            .byte $B7
$9DD8  28        PLP 
$9DD9            .byte $04
//------------------------------
L_BRS_($9DDA)_($9D99) OK
//------------------------------
$9DDA  20 0E 27  JSR L_JSR_($270E)_($9DDA) BAD
//------------------------------
L_BRS_($9DDE)_($9DC8) JAM
//------------------------------
$9DDD            .byte $00,$2F,$77,$80,$0B
$9DE2  76 80     ROR $80,X 
$9DE4            .byte $00,$42
$9DE6  68        PLA 
$9DE7            .byte $00,$00,$7C
$9DEA  20 3A 00  JSR $003A
$9DED            .byte $03,$80,$FC,$00,$00
$9DF2  1D E0 00  ORA $00E0,X
$9DF5            .byte $00
$9DF6  01 DE     ORA ($DE,X)
$9DF8            .byte $00,$00
$9DFA  0A        ASL A 
$9DFB  D0 54     BNE L_BRS_($9E51)_($9DFB) JAM
$9DFD            .byte $02
$9DFE  40        RTI 
//------------------------------
$9DFF            .byte $54,$00
$9E01  7D FF FE  ADC $FEFF,X 
$9E04            .byte $FF,$BF
$9E06  AA        TAX 
$9E07            .byte $F7,$EF,$DF,$FB,$FA,$5F
$9E0D  AA        TAX 
$9E0E            .byte $EB,$57,$7F,$FF,$BF,$FB,$BF,$9F
$9E16            .byte $F7,$DF
//------------------------------
L_JSR_($9E19)_($6B71) BAD
//------------------------------
$9E18  FD 0B FD  SBC $FD0B,X 
$9E1B            .byte $FF
$9E1C  F0 2E     BEQ L_BRS_($9E4C)_($9E1C) BAD
$9E1E            .byte $FF,$FB,$4F,$F4,$F7
$9E23  FD E7 8D  SBC $8DE7,X 
$9E26  FE 7F FD  INC $FD7F,X 
$9E29            .byte $EF,$DF,$FB,$DF
$9E2D  6D 82 E8  ADC $E882 
$9E30            .byte $2F,$FB,$EF,$5A,$EB,$FF,$DF
$9E37  DE 3F FE  DEC $FE3F,X 
$9E3A  7D 82 E7  ADC $E782,X 
$9E3D            .byte $FF
$9E3E  FE AA FB  INC $FBAA,X 
$9E41            .byte $FF
$9E42  FE FD 7D  INC $7DFD,X 
$9E45  BA        TSX 
$9E46  FD FF EC  SBC $ECFF,X 
$9E49            .byte $AB
//------------------------------
L_BRS_($9E4C)_($9E1C) BAD
//------------------------------
$9E4A  FD D7 FF  SBC $FFD7,X 
//------------------------------
L_BRS_($9E51)_($9DFB) JAM
//------------------------------
$9E4D            .byte $7F,$9F,$EF,$F4,$7F
$9E52  F1 E9     SBC ($E9),Y 
$9E54            .byte $5F,$EF
$9E56  DE ED D4  DEC $D4ED,X 
//------------------------------
L_BRS_($9E5A)_($9E99) JAM
//------------------------------
$9E59            .byte $2F,$F4,$77
$9E5C  E4 FE     CPX $FE 
$9E5E  F5 EE     SBC $EE,X 
$9E60  FD D7 6E  SBC $6ED7,X 
$9E63  FD FF 42  SBC $42FF,X 
$9E66  D6 FF     DEC $FF,X 
$9E68            .byte $FF
$9E69  3E F4 5D  ROL $5DF4,X 
$9E6C            .byte $FF,$DF
$9E6E  FD BF FF  SBC $FFBF,X 
$9E71            .byte $FF,$BB,$F7,$FF,$FF,$BF,$7B,$FF
$9E79            .byte $FF,$57,$EB
$9E7C  AA        TAX 
$9E7D            .byte $5F,$FA
$9E7F  AA        TAX 
$9E80            .byte $00
$9E81  BE FF 7F  LDX $7FFF,Y 
$9E84            .byte $FF
$9E85  FD 55 EF  SBC $EF55,X 
$9E88            .byte $F7,$FB,$DF,$5F,$FA
$9E8D  55 D7     EOR $D7,X 
$9E8F  EA        NOP 
$9E90  FE FF FD  INC $FDFF,X 
$9E93            .byte $DF
$9E94  FD F9 EF  SBC $EFF9,X 
$9E97            .byte $FB,$BF
$9E99  D0 BF     BNE L_BRS_($9E5A)_($9E99) JAM
$9E9B            .byte $FF,$0F,$74,$FF,$DF,$F2,$2F,$EF
$9EA3            .byte $BF,$E7
$9EA5  B1 7F     LDA ($7F),Y 
$9EA7  FE BF F7  INC $F7BF,X 
$9EAA            .byte $FB,$DF,$FB
$9EAD  B6 41     LDX $41,Y 
$9EAF            .byte $17,$F4,$DF,$F7,$5A,$D7,$FF,$FB
$9EB7            .byte $7B,$FC,$7F
$9EBA  BE 41 E7  LDX $E741,Y 
$9EBD            .byte $FF,$7F
$9EBF  55 DF     EOR $DF,X 
$9EC1            .byte $FF,$7F,$BF
$9EC4  BE 5D BF  LDX $BF5D,Y 
$9EC7            .byte $FF,$37
$9EC9  D5 BF     CMP $BF,X 
$9ECB            .byte $EB,$FF
$9ECD  FE F9 F7  INC $F7F9,X 
$9ED0            .byte $2F
$9ED1  FE 8F 97  INC $978F,X 
$9ED4            .byte $FA,$F7,$7B,$B7,$2B,$F4,$2F
$9EDB  EE 27 7F  INC $7F27 
$9EDE            .byte $AF,$77,$BF,$EB
$9EE2  76 BF     ROR $BF,X 
$9EE4            .byte $FF,$42,$6B,$FF,$FF,$7C,$2F
$9EEB  BA        TSX 
$9EEC            .byte $FF,$FB,$BF
$9EEF  FD FF FF  SBC $FFFF,X 
$9EF2  DD EF FF  CMP $FFEF,X 
$9EF5            .byte $FF
$9EF6  FD DE FF  SBC $FFDE,X                          // Read Real-Time Clock
$9EF9            .byte $FF
$9EFA  EA        NOP 
$9EFB            .byte $D7
$9EFC  55 FA     EOR $FA,X 
//------------------------------
L_BRS_($9EFE)_($9F32) JAM
//------------------------------
$9EFE            .byte $5F
$9EFF  55 00     EOR $00,X 
$9F01            .byte $5C,$00,$00,$FF,$80
$9F06  2A        ROL A 
$9F07  05 0F     ORA $0F
$9F09  C0 F8     CPY #$F8
$9F0B            .byte $04
$9F0C  A0 2A     LDY #$2A
$9F0E            .byte $14
$9F0F  48        PHA 
$9F10            .byte $5F,$00,$80,$07,$80
$9F15  60        RTS 
//------------------------------
$9F16            .byte $03
$9F17  E0 02     CPX #$02
$9F19            .byte $47,$FC,$00,$0F
$9F1D  E6 FF     INC $FF 
$9F1F            .byte $F8,$4B,$04
$9F22  B0 02     BCS L_BRS_($9F26)_($9F22) JAM
$9F24  78        SEI 
//------------------------------
L_BRS_($9F26)_($9F22) JAM
//------------------------------
$9F25            .byte $52,$00,$00,$9C
$9F29  09 C0     ORA #$C0
$9F2B            .byte $07
$9F2C  E0 C6     CPX #$C6
$9F2E            .byte $62
$9F2F  06 20     ASL $20 
$9F31            .byte $04
$9F32  10 CA     BPL L_BRS_($9EFE)_($9F32) JAM
$9F34            .byte $0F,$FF,$00,$00,$00,$00,$5C,$62
$9F3C            .byte $02,$7F,$00
$9F3F  A2 00     LDX #$00
$9F41            .byte $7F,$00,$9C,$5C
$9F45  30 00     BMI L_BRS_($9F47)_($9F45) JAM
//------------------------------
L_BRS_($9F47)_($9F45) JAM
//------------------------------
$9F47            .byte $00,$0C
$9F49  10 00     BPL L_BRS_($9F4B)_($9F49) OK
//------------------------------
L_BRS_($9F4B)_($9F49) OK
//------------------------------
$9F4B  0D 00 00  ORA $0000
$9F4E            .byte $17,$07,$74,$80
$9F52  78        SEI 
$9F53  09 40     ORA #$40
$9F55            .byte $1F,$0F
$9F57  ED 16 70  SBC $7016 
$9F5A            .byte $04
$9F5B  70 6E     BVS L_BRS_($9FCB)_($9F5B) OK
$9F5D            .byte $00,$F4
$9F5F  F1 00     SBC ($00),Y 
$9F61  D0 6E     BNE L_BRS_($9FD1)_($9F61) OK
$9F63  01 00     ORA ($00,X)
$9F65            .byte $47,$32,$00,$00
$9F69  3E 05 04  ROL $0405,X 
$9F6C            .byte $00
$9F6D  C0 03     CPY #$03
$9F6F            .byte $5F,$00,$00,$F8,$07,$00,$00,$80
$9F77            .byte $7F,$00,$00
$9F7A  48        PHA 
$9F7B            .byte $14
$9F7C  2A        ROL A 
$9F7D  A0 04     LDY #$04
$9F7F  2A        ROL A 
$9F80            .byte $00,$3A,$00,$00,$FF
$9F85  01 54     ORA ($54,X)
$9F87  A0 F0     LDY #$F0
$9F89            .byte $03,$1F
$9F8B  20 05 54  JSR L_JSR_($5405)_($9F8B) BAD
$9F8E  28        PLP 
//------------------------------
L_BRS_($9F8F)_($9FD6) JAM
//------------------------------
$9F8F            .byte $12,$FA,$00
$9F92  01 E0     ORA ($E0,X)
$9F94  01 06     ORA ($06,X)
$9F96  C0 07     CPY #$07
$9F98  40        RTI 
//------------------------------
$9F99            .byte $E2,$3F,$00
$9F9C  F0 67     BEQ L_BRS_($A005)_($9F9C) BAD
$9F9E            .byte $FF,$1F,$D2
$9FA1  20 0D 40  JSR L_JSR_($400D)_($9FA1) JAM
$9FA4  1E 4A 00  ASL $004A,X 
$9FA7            .byte $00
$9FA8  39 90 03  AND $0390,Y 
$9FAB  E0 07     CPX #$07
$9FAD            .byte $63
$9FAE  46 60     LSR $60 
$9FB0            .byte $04
$9FB1  20 08 53  JSR L_JSR_($5308)_($9FB1) BAD
//------------------------------
L_BRS_($9FB5)_($9FB4) BAD
//------------------------------
$9FB4  F0 FF     BEQ L_BRS_($9FB5)_($9FB4) BAD
$9FB6            .byte $00,$00,$00,$00,$3A
$9FBB  46 40     LSR $40 
$9FBD  FE 00 45  INC $4500,X 
$9FC0            .byte $00
$9FC1  FE 00 39  INC $3900,X 
$9FC4            .byte $3A,$0C,$00,$00
$9FC8  30 08     BMI L_BRS_($9FD2)_($9FC8) BAD
$9FCA            .byte $00
//------------------------------
L_BRS_($9FCB)_($9F5B) OK
//------------------------------
$9FCB  B0 00     BCS L_BRS_($9FCD)_($9FCB) JAM
//------------------------------
L_BRS_($9FCD)_($9FCB) JAM
//------------------------------
$9FCD            .byte $00
$9FCE  E8        INX 
$9FCF  E0 2E     CPX #$2E
//------------------------------
L_BRS_($9FD1)_($9F61) OK
L_BRS_($9FD2)_($9FC8) BAD
//------------------------------
$9FD1  01 1E     ORA ($1E,X)
$9FD3  90 02     BCC L_BRS_($9FD7)_($9FD3) BAD
$9FD5            .byte $F8
//------------------------------
L_BRS_($9FD7)_($9FD3) BAD
//------------------------------
$9FD6  F0 B7     BEQ L_BRS_($9F8F)_($9FD6) JAM
$9FD8  68        PLA 
$9FD9  0E 20 0E  ASL $0E20 
$9FDC  76 00     ROR $00,X 
$9FDE            .byte $2F,$8F,$00,$0B
$9FE2  76 80     ROR $80,X 
$9FE4            .byte $00,$E2
$9FE6  4C 00 00  JMP $0000
$9FE9            .byte $7C
$9FEA  A0 20     LDY #$20
$9FEC            .byte $00,$03
$9FEE  C0 FA     CPY #$FA
$9FF0            .byte $00,$00,$1F
$9FF3  E0 00     CPX #$00
$9FF5            .byte $00
$9FF6  01 FE     ORA ($FE,X)
$9FF8            .byte $00,$00,$12
$9FFB  28        PLP 
$9FFC            .byte $54
$9FFD  05 20     ORA $20
$9FFF            .byte $54
$A000  94 5D     STY $5D,X 
$A002            .byte $FF
//------------------------------
L_BRS_($A005)_($9F9C) BAD
//------------------------------
$A003  FE FF BF  INC $BFFF,X 
$A006  AA        TAX 
$A007  F5 EF     SBC $EF,X 
$A009            .byte $DF,$FB,$F4,$AF
$A00D  AA        TAX 
$A00E  D5 4B     CMP $4B,X 
$A010            .byte $5F,$FF,$BF,$F7,$BF,$7F,$FB,$EF
$A018  EA        NOP 
$A019            .byte $47
$A01A  FD BE 0F  SBC $0FBE,X 
$A01D  E6 FF     INC $FF 
$A01F            .byte $FB,$4B,$F4,$B7,$FA,$7B,$52
$A026  FE 7F 9D  INC $9D7F,X 
$A029  E9 DF     SBC #$DF
$A02B            .byte $F7,$EF
$A02D  C6 62     DEC $62 
$A02F  F6 2F     INC $2F,X 
$A031            .byte $F4,$17
$A033  CA        DEX 
$A034            .byte $EF,$FF,$3F
$A037  FE 7F C0  INC $C07F,X 
$A03A  5D 62 FA  EOR $FA62,X 
$A03D            .byte $7F
$A03E  FE AA FC  INC $FCAA,X 
$A041            .byte $7F
$A042  FE 9D 5D  INC $5D9D,X 
$A045  B6 FE     LDX $FE,Y 
$A047            .byte $FF
$A048  EC D7 FE  CPX $FED7 
$A04B  ED FF 7F  SBC $7FFF 
$A04E            .byte $17,$F7,$74,$BF
$A052  78        SEI 
$A053  E9 5F     SBC #$5F
$A055            .byte $1F,$EF
$A057  ED D6 77  SBC $77D6 
$A05A            .byte $F4,$77
$A05C  6E FF F5  ROR $F5FF 
$A05F  F1 FE     SBC ($FE),Y 
$A061            .byte $D7
$A062  6E FD 7F  ROR $7FFD 
$A065            .byte $47,$32,$80,$EF
$A069  3E F5 05  ROL $05F5,X 
$A06C            .byte $FF,$DF,$FB,$5F,$FF,$87,$FB,$F7
$A074            .byte $7F,$F8,$BF,$7F,$FF,$87,$4B
$A07B  D5 AA     CMP $AA,X 
$A07D            .byte $AF,$F4
$A07F  AA        TAX 
$A080            .byte $00
$A081  BA        TSX 
$A082            .byte $FF,$7F,$FF
$A085  FD 55 AF  SBC $AF55,X 
$A088            .byte $F7,$FB,$DF,$2F
$A08C  F5 55     SBC $55,X 
$A08E            .byte $AB,$D2,$FA,$FF
$A092  FD EF FD  SBC $FDEF,X 
$A095  FE DF F7  INC $F7DF,X 
$A098            .byte $57,$E2,$BF
$A09B  7D F0 67  ADC $67F0,X 
$A09E            .byte $FF,$DF,$D2,$2F
$A0A2  ED 5F DE  SBC $DE5F 
$A0A5  4A        LSR A 
$A0A6            .byte $7F
$A0A7  FE B9 97  INC $97B9,X 
$A0AA            .byte $FB,$EF,$F7,$63
$A0AE  46 6F     LSR $6F 
$A0B0            .byte $F4,$2F
$A0B2  E8        INX 
$A0B3            .byte $53,$F7,$FF,$FC,$7F
$A0B8  FE 03 BA  INC $BA03,X 
$A0BB  46 5F     LSR $5F 
$A0BD  FE 7F 55  INC $557F,X 
$A0C0            .byte $3F
$A0C1  FE 7F B9  INC $B97F,X 
$A0C4  BA        TSX 
$A0C5  6D 7F FF  ADC $FF7F 
$A0C8            .byte $37,$EB,$7F,$B7,$FF
$A0CD  FE E8 EF  INC $EFE8,X 
$A0D0  2E FD 1E  ROL $1EFD 
$A0D3            .byte $97,$FA,$F8,$F7,$B7,$6B
$A0D9  EE 2F EE  INC $EE2F 
$A0DC  76 FF     ROR $FF,X 
$A0DE            .byte $AF,$8F,$7F,$EB
$A0E2  76 BF     ROR $BF,X 
$A0E4  FE E2 4C  INC $4CE2,X 
$A0E7  01 F7     ORA ($F7,X)
$A0E9            .byte $7C,$AF
$A0EB  A0 FF     LDY #$FF
$A0ED            .byte $FB,$DF,$FA,$FF
$A0F1  E1 DF     SBC ($DF,X) 
$A0F3            .byte $EF
$A0F4  FE 1F FD  INC $FD1F,X 
$A0F7  FE FF E1  INC $E1FF,X 
$A0FA            .byte $D2,$AB
$A0FC  55 F5     EOR $F5,X 
$A0FE            .byte $2F
$A0FF  55 00     EOR $00,X 
$A101            .byte $04,$00,$00,$FF,$80
$A106  2A        ROL A 
$A107            .byte $00,$0F
$A109  40        RTI 
//------------------------------
$A10A            .byte $F8
$A10B  05 D0     ORA $D0
//------------------------------
L_BRS_($A10E)_($A132) JAM
//------------------------------
$A10D            .byte $1A,$14
$A10F  24 FF     BIT $FF 
$A111            .byte $00,$80,$00,$00
$A115  A0 02     LDY #$02
$A117  E0 17     CPX #$17
$A119            .byte $A3,$FC
$A11B  41 FF     EOR ($FF,X) 
$A11D  AE FF F8  LDX $F8FF 
$A120            .byte $63
$A121  06 30     ASL $30 
$A123            .byte $02
$A124  58        CLI 
$A125            .byte $42,$00,$00,$14
$A129  01 40     ORA ($40,X)
$A12B            .byte $04
$A12C  E0 C6     CPX #$C6
$A12E            .byte $5A
$A12F  05 A0     ORA $A0
$A131            .byte $03
$A132  10 DA     BPL L_BRS_($A10E)_($A132) JAM
$A134            .byte $13,$FF,$00,$00,$00,$3F,$F4
$A13B  E6 01     INC $01 
$A13D            .byte $FF,$00
//------------------------------
L_BRS_($A140)_($A15E) BAD
//------------------------------
$A13F  A2 00     LDX #$00
$A141            .byte $3F,$00,$14,$04
$A145  30 00     BMI L_BRS_($A147)_($A145) JAM
//------------------------------
L_BRS_($A147)_($A145) JAM
//------------------------------
$A147            .byte $00
$A148  0E 00 00  ASL $0000 
$A14B  09 00     ORA #$00
$A14D            .byte $00,$1F
$A14F  01 0C     ORA ($0C,X)
$A151  C0 04     CPY #$04
$A153  09 00     ORA #$00
$A155            .byte $0F
$A156  0E 6D 16  ASL $166D 
$A159  F0 06     BEQ L_BRS_($A161)_($A159) OK
$A15B  40        RTI 
//------------------------------
$A15C  24 00     BIT $00 
$A15E  F0 E0     BEQ L_BRS_($A140)_($A15E) BAD
$A160            .byte $00
//------------------------------
L_BRS_($A161)_($A159) OK
//------------------------------
$A161  D0 6E     BNE L_BRS_($A1D1)_($A161) BAD
$A163  01 00     ORA ($00,X)
$A165            .byte $6F
$A166  D6 7F     DEC $7F,X 
$A168  10 3E     BPL L_BRS_($A1A8)_($A168) OK
$A16A  0D 7C 00  ORA $007C
$A16D            .byte $00,$00,$7F,$00
$A171  78        SEI 
$A172            .byte $F8,$07,$80,$07,$80,$7F,$00
$A179  78        SEI 
$A17A  24 14     BIT $14 
$A17C            .byte $1A
$A17D  D0 05     BNE L_BRS_($A184)_($A17D) JAM
$A17F  2A        ROL A 
$A180            .byte $00
$A181  20 00 00  JSR $0000
//------------------------------
L_BRS_($A184)_($A17D) JAM
//------------------------------
$A184            .byte $FF
$A185  01 54     ORA ($54,X)
$A187            .byte $00
$A188  F0 02     BEQ L_BRS_($A18C)_($A188) BAD
$A18A            .byte $1F
//------------------------------
L_BRS_($A18C)_($A188) BAD
//------------------------------
$A18B  A0 0B     LDY #$0B
$A18D  58        CLI 
$A18E  28        PLP 
$A18F  24 FF     BIT $FF 
$A191            .byte $00
$A192  01 00     ORA ($00,X)
$A194            .byte $00
$A195  05 40     ORA $40
$A197            .byte $07
$A198  E8        INX 
$A199  C5 3F     CMP $3F 
$A19B            .byte $82,$FF
$A19D  75 FF     ADC $FF,X 
$A19F            .byte $1F
$A1A0  C6 60     DEC $60 
$A1A2            .byte $0C
$A1A3  40        RTI 
//------------------------------
$A1A4            .byte $1A,$42,$00,$00
//------------------------------
L_BRS_($A1A8)_($A168) OK
//------------------------------
$A1A8  28        PLP 
$A1A9            .byte $80,$02
$A1AB  20 07 63  JSR L_JSR_($6307)_($A1AB) JAM
$A1AE            .byte $5A
$A1AF  A0 05     LDY #$05
$A1B1  C0 08     CPY #$08
$A1B3            .byte $5B
$A1B4  C8        INY 
$A1B5            .byte $FF,$00,$00,$00,$FC,$2F,$67,$80
$A1BD            .byte $FF,$00
$A1BF  45 00     EOR $00 
$A1C1            .byte $FC,$00
$A1C3  28        PLP 
$A1C4  20 0C 00  JSR $000C
$A1C7            .byte $00
$A1C8  70 00     BVS L_BRS_($A1CA)_($A1C8) JAM
//------------------------------
L_BRS_($A1CA)_($A1C8) JAM
//------------------------------
$A1CA            .byte $00
$A1CB  90 00     BCC L_BRS_($A1CD)_($A1CB) JAM
//------------------------------
L_BRS_($A1CD)_($A1CB) JAM
//------------------------------
$A1CD            .byte $00,$F8,$80
//------------------------------
L_BRS_($A1D1)_($A161) BAD
//------------------------------
$A1D0  30 03     BMI L_BRS_($A1D5)_($A1D0) OK
$A1D2  20 90 00  JSR $0090
//------------------------------
L_BRS_($A1D5)_($A1D0) OK
//------------------------------
$A1D5  F0 70     BEQ L_BRS_($A247)_($A1D5) JAM
$A1D7  B6 68     LDX $68,Y 
$A1D9            .byte $0F
$A1DA  60        RTS 
//------------------------------
$A1DB            .byte $02
$A1DC  24 00     BIT $00 
$A1DE            .byte $0F,$07,$00,$0B
$A1E2  76 80     ROR $80,X 
$A1E4            .byte $00
$A1E5  F6 6B     INC $6B,X 
$A1E7  FE 08 7C  INC $7C08,X 
$A1EA  B0 3E     BCS L_BRS_($A22A)_($A1EA) BAD
$A1EC            .byte $00,$00,$00
$A1EF  FE 00 1E  INC $1E00,X 
$A1F2            .byte $1F
$A1F3  E0 01     CPX #$01
$A1F5  E0 01     CPX #$01
//------------------------------
L_BRS_($A1F8)_($A207) BAD
//------------------------------
$A1F7  FE 00 1E  INC $1E00,X 
$A1FA  24 28     BIT $28 
$A1FC  58        CLI 
$A1FD            .byte $0B
$A1FE  A0 54     LDY #$54
$A200            .byte $00
$A201  05 FF     ORA $FF
$A203  FE FF BF  INC $BFFF,X 
$A206  AA        TAX 
$A207  F0 EF     BEQ L_BRS_($A1F8)_($A207) BAD
$A209            .byte $5F,$FB
$A20B  F5 D7     SBC $D7,X 
$A20D            .byte $DA
$A20E  D5 A5     CMP $A5,X 
$A210            .byte $FF
$A211  FE BF F8  INC $F8BF,X 
$A214            .byte $7F,$AF,$FA,$EF,$D7,$A3
$A21A  FD 41 FF  SBC $FF41,X 
$A21D  AE FF FB  LDX $FBFF 
$A220            .byte $63
$A221  F6 37     INC $37,X 
$A223            .byte $FA,$5B,$42
$A226  FE 7F 15  INC $157F,X 
//------------------------------
L_BRS_($A22A)_($A1EA) BAD
//------------------------------
$A229  E1 5F     SBC ($5F,X) 
$A22B            .byte $F4,$EF
$A22D  C6 5A     DEC $5A 
$A22F  F5 AF     SBC $AF,X 
$A231            .byte $FB,$17,$DA,$D3,$FF,$7F
$A237  FE 7F BF  INC $BF7F,X 
$A23A  F5 E6     SBC $E6,X 
$A23C  FD FF FE  SBC $FEFF,X 
$A23F  AA        TAX 
$A240            .byte $FF,$BF
$A242  FE 15 05  INC $0515,X 
$A245  B6 FE     LDX $FE,Y 
//------------------------------
L_BRS_($A247)_($A1D5) JAM
//------------------------------
$A247            .byte $FF
$A248  EE EF FE  INC $FEEF 
$A24B  E9 FF     SBC #$FF
$A24D            .byte $7F,$1F
$A24F  F9 8C DF  SBC $DF8C,Y 
$A252            .byte $04
$A253  E9 1F     SBC #$1F
$A255            .byte $0F
$A256  EE 6D D6  INC $D66D 
$A259            .byte $F7
$A25A  F6 4F     INC $4F,X 
$A25C  A4 FF     LDY $FF 
$A25E            .byte $F3
$A25F  E0 FE     CPX #$FE
$A261            .byte $D7
$A262  6E FD 7F  ROR $7FFD 
$A265            .byte $6F
$A266  D6 7F     DEC $7F,X 
$A268  D0 3E     BNE L_BRS_($A2A8)_($A268) BAD
$A26A  CD 7D FF  CMP $FF7D 
$A26D            .byte $3F,$FC,$7F,$FF,$7B,$FB,$F7,$BF
$A275            .byte $F7,$BF,$7F,$FF,$7B
$A27A  A5 D5     LDA $D5 
$A27C            .byte $DA,$D7
$A27E  F5 AA     SBC $AA,X 
$A280            .byte $00
$A281  A0 FF     LDY #$FF
$A283            .byte $7F,$FF
$A285  FD 55 0F  SBC $0F55,X 
$A288            .byte $F7,$FA,$DF,$AF,$EB,$5B,$AB
$A28F  A5 FF     LDA $FF 
$A291            .byte $7F
$A292  FD 1F FE  SBC $FE1F,X 
$A295  F5 5F     SBC $5F,X 
$A297            .byte $F7,$EB
$A299  C5 BF     CMP $BF 
$A29B            .byte $82,$FF
$A29D  75 FF     ADC $FF,X 
$A29F            .byte $DF
$A2A0  C6 6F     DEC $6F 
$A2A2  EC 5F DA  CPX $DA5F 
$A2A5            .byte $42,$7F
//------------------------------
L_BRS_($A2A8)_($A268) BAD
//------------------------------
$A2A7  FE A8 87  INC $87A8,X 
$A2AA            .byte $FA,$2F,$F7,$63,$5A,$AF
$A2B0  F5 DF     SBC $DF,X 
$A2B2  E8        INX 
$A2B3            .byte $5B,$CB,$FF
$A2B6  FE 7F FE  INC $FE7F,X 
$A2B9  FD AF 67  SBC $67AF,X 
$A2BC            .byte $BF,$FF,$7F
$A2BF  55 FF     EOR $FF,X 
$A2C1  FD 7F A8  SBC $A87F,X 
$A2C4  A0 6D     LDY #$6D
$A2C6            .byte $7F,$FF,$77,$F7,$7F,$97,$FF
$A2CD  FE F8 9F  INC $9FF8,X 
$A2D0  31 FB     AND ($FB),Y 
$A2D2  20 97 F8  JSR L_JSR_($F897)_($A2D2) BAD
$A2D5  F0 77     BEQ L_BRS_($A34E)_($A2D5) JAM
$A2D7  B6 6B     LDX $6B,Y 
$A2D9            .byte $EF,$6F,$F2
$A2DC  25 FF     AND $FF
$A2DE            .byte $CF,$07,$7F,$EB
$A2E2  76 BF     ROR $BF,X 
$A2E4  FE F6 6B  INC $6BF6,X 
$A2E7  FE 0B 7C  INC $7C0B,X 
$A2EA            .byte $B3
$A2EB  BE FF FC  LDX $FCFF,Y 
$A2EE            .byte $3F
$A2EF  FE FF DE  INC $DEFF,X 
$A2F2            .byte $DF,$EF
$A2F4  FD EF FD  SBC $FDEF,X 
$A2F7  FE FF DE  INC $DEFF,X 
$A2FA  A5 AB     LDA $AB 
$A2FC            .byte $5B,$EB,$AF
//------------------------------
L_JSR_($A300)_($B71E) BAD
L_JSR_($A300)_($F399) BAD
//------------------------------
$A2FF  55 00     EOR $00,X 
$A301  7E 00 01  ROR $0100,X 
$A304            .byte $FF,$80
//------------------------------
L_BRS_($A306)_($A332) OK
//------------------------------
$A306  3E 07 1F  ROL $1F07,X 
$A309  E0 F8     CPX #$F8
$A30B  0E 50 1E  ASL $1E50 
$A30E            .byte $1C,$1C,$1F
$A311  01 80     ORA ($80,X)
$A313            .byte $00,$00
$A315  90 00     BCC L_BRS_($A317)_($A315) OK
//------------------------------
L_BRS_($A317)_($A315) OK
//------------------------------
$A317  30 1F     BMI L_BRS_($A338)_($A317) JAM
$A319            .byte $FB
$A31A  EC 7F FF  CPX $FF7F 
$A31D  EE FF F8  INC $F8FF 
$A320  0E 00 E0  ASL $E000                          // EXP continued From BASIC ROM
$A323            .byte $03
$A324  18        CLC 
$A325  CE 00 00  DEC $0000 
$A328  86 08     STX $08 
$A32A  60        RTS 
//------------------------------
$A32B            .byte $00
$A32C  A0 DE     LDY #$DE
$A32E            .byte $04,$00
$A330  40        RTI 
//------------------------------
$A331            .byte $02
$A332  D0 D2     BNE L_BRS_($A306)_($A332) OK
//------------------------------
L_BRS_($A338)_($A317) JAM
//------------------------------
$A334            .byte $0C,$FF,$00,$00,$00
$A339  20 46 46  JSR L_JSR_($4646)_($A339) JAM
$A33C            .byte $00,$3F,$00,$E3,$00,$3F,$00
//------------------------------
L_BRS_($A344)_($A35E) BAD
//------------------------------
$A343  86 7E     STX $7E 
$A345  38        SEC 
$A346            .byte $00,$00
$A348  0E 00 00  ASL $0000 
$A34B  09 00     ORA #$00
//------------------------------
L_BRS_($A34E)_($A2D5) JAM
//------------------------------
$A34D            .byte $00,$E7,$03
$A350  1D C0 02  ORA $02C0,X
$A353  1E 00 4F  ASL $4F00,X 
$A356  0E AD 16  ASL $16AD 
$A359  70 04     BVS L_BRS_($A35F)_($A359) BAD
$A35B  C0 3D     CPY #$3D
$A35D            .byte $00
//------------------------------
L_BRS_($A35F)_($A359) BAD
//------------------------------
$A35E  F0 E4     BEQ L_BRS_($A344)_($A35E) BAD
$A360            .byte $00
$A361  D0 6E     BNE L_BRS_($A3D1)_($A361) JAM
$A363  01 00     ORA ($00,X)
$A365            .byte $47
$A366  F6 FF     INC $FF,X 
$A368            .byte $1F
$A369  7E 3F 2C  ROR $2C3F,X 
$A36C            .byte $00,$00,$00,$9F,$00,$5C,$F8,$0F
$A374  C0 05     CPY #$05
$A376            .byte $80,$FF,$00,$5C,$1C,$1C
$A37C  1E 50 0E  ASL $0E50,X 
$A37F  3E 00 7E  ROL $7E00,X 
$A382            .byte $00,$80,$FF
$A385  01 7C     ORA ($7C,X)
$A387  E0 F8     CPX #$F8
$A389            .byte $07,$1F
$A38B  70 0A     BVS L_BRS_($A397)_($A38B) JAM
//------------------------------
L_BRS_($A38D)_($A3D6) OK
//------------------------------
$A38D  78        SEI 
$A38E  38        SEC 
$A38F  38        SEC 
$A390            .byte $F8,$80
$A392  01 00     ORA ($00,X)
$A394            .byte $00
$A395  09 00     ORA #$00
//------------------------------
L_BRS_($A397)_($A38B) JAM
//------------------------------
$A397            .byte $0C,$F8,$DF,$37
$A39B  FE FF 77  INC $77FF,X 
$A39E            .byte $FF,$1F
$A3A0  70 00     BVS L_BRS_($A3A2)_($A3A0) JAM
//------------------------------
L_BRS_($A3A2)_($A3A0) JAM
//------------------------------
$A3A2            .byte $07
$A3A3  C0 18     CPY #$18
$A3A5            .byte $73,$00,$00
$A3A8  61 10     ADC ($10,X) 
$A3AA  06 00     ASL $00 
$A3AC  05 7B     ORA $7B
$A3AE  20 00 02  JSR $0200
$A3B1  40        RTI 
//------------------------------
$A3B2            .byte $0B,$4B
//------------------------------
L_BRS_($A3B5)_($A3B4) BAD
//------------------------------
$A3B4  30 FF     BMI L_BRS_($A3B5)_($A3B4) BAD
$A3B6            .byte $00,$00,$00,$04,$62,$62,$00,$FC
$A3BE            .byte $00,$C7,$00,$FC,$00
$A3C3  61 7E     ADC ($7E,X) 
$A3C5            .byte $1C,$00,$00
$A3C8  70 00     BVS L_BRS_($A3CA)_($A3C8) JAM
//------------------------------
L_BRS_($A3CA)_($A3C8) JAM
//------------------------------
$A3CA            .byte $00
$A3CB  90 00     BCC L_BRS_($A3CD)_($A3CB) JAM
//------------------------------
L_BRS_($A3CD)_($A3CB) JAM
//------------------------------
$A3CD            .byte $00,$E7
$A3CF  C0 B8     CPY #$B8
//------------------------------
L_BRS_($A3D1)_($A361) JAM
//------------------------------
$A3D1            .byte $03
$A3D2  40        RTI 
//------------------------------
$A3D3  78        SEI 
$A3D4            .byte $00,$F2
$A3D6  70 B5     BVS L_BRS_($A38D)_($A3D6) OK
$A3D8  68        PLA 
$A3D9  0E 20 03  ASL $0320 
//------------------------------
L_BRS_($A3DC)_($A42B) OK
//------------------------------
$A3DC  BC 00 0F  LDY $0F00,X 
$A3DF            .byte $27,$00,$0B
$A3E2  76 80     ROR $80,X 
$A3E4            .byte $00,$E2,$6F,$FF,$F8
$A3E9  7E FC 34  ROR $34FC,X 
$A3EC            .byte $00,$00,$00
$A3EF  F9 00 3A  SBC $3A00,Y 
$A3F2            .byte $1F
$A3F3  F0 03     BEQ L_BRS_($A3F8)_($A3F3) JAM
$A3F5  A0 01     LDY #$01
//------------------------------
L_BRS_($A3F8)_($A3F3) JAM
//------------------------------
$A3F7            .byte $FF,$00,$3A
$A3FA  38        SEC 
$A3FB  38        SEC 
$A3FC  78        SEI 
$A3FD  0A        ASL A 
$A3FE  70 7C     BVS L_BRS_($A47C)_($A3FE) BAD
$A400            .byte $00
$A401  7E FF FD  ROR $FDFF,X 
$A404            .byte $FF,$BF
$A406  BE F7 DF  LDX $DFF7,Y 
$A409            .byte $EF,$FB
$A40B  EE 57 DE  INC $DE57 
$A40E  DD DD 1F  CMP $1FDD,X 
$A411  FD BF FF  SBC $FFBF,X 
$A414            .byte $FF,$97,$F8,$37,$DF,$FB
$A41A  ED 7F FF  SBC $FF7F 
$A41D  EE FF FB  INC $FBFF 
$A420  0E F0 EF  ASL $EFF0 
$A423            .byte $FB,$1B
$A425  CE FE FF  DEC $FFFE                          // Vector: IRQ
$A428  86 E8     STX $E8 
$A42A            .byte $6F
$A42B  F0 AF     BEQ L_BRS_($A3DC)_($A42B) OK
$A42D  DE 05 F0  DEC $F005,X 
$A430            .byte $5F,$FA,$D7,$D2
$A434  EC FF 7F  CPX $7FFF 
$A437  FE 7F A0  INC $A07F,X 
$A43A  46 46     LSR $46 
$A43C  FE BF FE  INC $FEBF,X 
$A43F            .byte $EB,$FF,$BF,$80
$A443  86 7E     STX $7E 
$A445  BA        TSX 
$A446  FE FF EE  INC $EEFF,X 
$A449            .byte $FF
$A44A  FE E9 FF  INC $FFE9,X 
$A44D            .byte $7F,$E7,$FB
$A450  DD DF FA  CMP $FADF,X 
$A453  DE 7F 4F  DEC $4F7F,X 
$A456  EE AD D6  INC $D6AD 
$A459            .byte $77,$F4,$DF
$A45C  BD FF F7  LDA $F7FF,X 
$A45F  EE FE D7  INC $D7FE 
$A462  6E FD 7F  ROR $7FFD 
$A465            .byte $47
$A466  F6 FF     INC $FF,X 
$A468            .byte $DF
$A469  7E BF 2D  ROR $2DBF,X 
$A46C            .byte $FC,$FF,$FF,$9F
$A470  FE 5D FB  INC $FB5D,X 
$A473            .byte $EF,$DF
$A475  F5 BF     SBC $BF,X 
$A477            .byte $FF
$A478  FE 5D DD  INC $DD5D,X 
//------------------------------
L_BRS_($A47C)_($A3FE) BAD
//------------------------------
$A47B  DD DE 57  CMP $57DE,X 
$A47E  EE BE 00  INC $00BE 
$A481  7E FF BF  ROR $BFFF,X 
$A484            .byte $FF
$A485  FD 7D EF  SBC $EF7D,X 
$A488            .byte $FB,$F7,$DF,$77
$A48C  EA        NOP 
$A48D            .byte $7B,$BB,$BB,$F8,$BF
$A492  FD FF FF  SBC $FFFF,X 
$A495  E9 1F     SBC #$1F
$A497  EC FB DF  CPX $DFFB 
$A49A  B5 FE     LDA $FE,X 
$A49C            .byte $FF,$77,$FF,$DF
$A4A0  70 0F     BVS L_BRS_($A4B1)_($A4A0) JAM
$A4A2            .byte $F7,$DF
$A4A4  D8        CLD 
$A4A5            .byte $73,$7F,$FF
$A4A8  61 17     ADC ($17,X) 
$A4AA  F6 0F     INC $0F,X 
$A4AC  F5 7B     SBC $7B,X 
$A4AE  A0 0F     LDY #$0F
//------------------------------
L_BRS_($A4B1)_($A4A0) JAM
//------------------------------
$A4B0            .byte $FA,$5F,$EB,$4B,$37,$FF
$A4B6  FE 7F FE  INC $FE7F,X 
$A4B9  05 62     ORA $62
$A4BB            .byte $62,$7F
$A4BD  FD 7F D7  SBC $D77F,X 
$A4C0            .byte $FF
$A4C1  FD 01 61  SBC $6101,X 
$A4C4  7E 5D 7F  ROR $7F5D,X 
//------------------------------
L_BRS_($A4CC)_($A524) JAM
//------------------------------
$A4C7            .byte $FF,$77,$FF,$7F,$97,$FF
$A4CD  FE E7 DF  INC $DFE7,X 
$A4D0            .byte $BB,$FB,$5F,$7B
$A4D4  FE F2 77  INC $77F2,X 
$A4D7  B5 6B     LDA $6B,X 
$A4D9  EE 2F FB  INC $FB2F 
$A4DC  BD FF EF  LDA $EFFF,X 
$A4DF            .byte $77,$7F,$EB
$A4E2  76 BF     ROR $BF,X 
$A4E4  FE E2 6F  INC $6FE2,X 
$A4E7            .byte $FF,$FB
$A4E9  7E FD B4  ROR $B4FD,X 
$A4EC            .byte $3F,$FF,$FF
$A4EF  F9 7F BA  SBC $BA7F,Y 
$A4F2            .byte $DF,$F7,$FB,$AF
$A4F6  FD FF 7F  SBC $7FFF,X 
$A4F9  BA        TSX 
//------------------------------
L_BRS_($A4FC)_($A52C) JAM
//------------------------------
$A4FA            .byte $BB,$BB,$7B
$A4FD  EA        NOP 
$A4FE            .byte $77
$A4FF  7D 00 2F  ADC $2F00,X 
//------------------------------
L_BRS_($A503)_($A509) JAM
//------------------------------
$A502            .byte $00,$02,$FF,$80
$A506  3E 02 2F  ROL $2F02,X 
$A509  F0 F8     BEQ L_BRS_($A503)_($A509) JAM
$A50B  1E 38 0E  ASL $0E38,X 
$A50E  38        SEC 
$A50F            .byte $0C,$7F,$02,$00,$00,$00
$A515  E0 03     CPX #$03
$A517  F0 1F     BEQ L_BRS_($A538)_($A517) JAM
$A519            .byte $9F
$A51A  EA        NOP 
$A51B  71 BF     ADC ($BF),Y 
$A51D            .byte $FC,$FF,$F8,$74,$07
$A522  40        RTI 
//------------------------------
$A523            .byte $00
$A524  70 A6     BVS L_BRS_($A4CC)_($A524) JAM
$A526            .byte $00,$00,$FF,$0F
$A52A  F0 04     BEQ L_BRS_($A530)_($A52A) BAD
$A52C  30 CE     BMI L_BRS_($A4FC)_($A52C) JAM
//------------------------------
L_BRS_($A530)_($A52A) BAD
L_BRS_($A530)_($A532) BAD
//------------------------------
$A52E  7E 07 E0  ROR $E007,X 
$A531            .byte $00
$A532  30 FC     BMI L_BRS_($A530)_($A532) BAD
//------------------------------
L_BRS_($A538)_($A517) JAM
//------------------------------
$A534            .byte $00,$7F,$00,$00,$00,$3F,$E7
$A53B  E5 00     SBC $00 
//------------------------------
L_BRS_($A544)_($A55E) JAM
//------------------------------
$A53D            .byte $3F,$00,$E3,$00,$3F,$7F,$FF,$EF
$A545            .byte $1C,$00,$00
$A548  0E 00 00  ASL $0000 
$A54B            .byte $04,$00,$00
$A54E  C6 07     DEC $07 
$A550            .byte $3F
$A551  C0 03     CPY #$03
$A553  3E 00 4F  ROL $4F00,X 
$A556  0E CD 16  ASL $16CD 
$A559  F0 06     BEQ L_BRS_($A561)_($A559) OK
$A55B  C0 7F     CPY #$7F
$A55D            .byte $00
$A55E  F0 E4     BEQ L_BRS_($A544)_($A55E) JAM
$A560            .byte $00
//------------------------------
L_BRS_($A561)_($A559) OK
//------------------------------
$A561  D0 06     BNE L_BRS_($A569)_($A561) JAM
$A563  01 00     ORA ($00,X)
$A565            .byte $6F
$A566  FE 6F 1C  INC $1C6F,X 
//------------------------------
L_BRS_($A569)_($A561) JAM
//------------------------------
$A569            .byte $FC,$1F
$A56B  3E 03 00  ROL $0003,X 
$A56E            .byte $00
$A56F  3E 01 04  ROL $0401,X 
$A572            .byte $F8,$17
$A574  40        RTI 
//------------------------------
$A575            .byte $00,$80,$7F
$A578  01 04     ORA ($04,X)
$A57A            .byte $0C
$A57B  38        SEC 
$A57C  0E 38 1E  ASL $1E38 
$A57F  3E 00 F4  ROL $F400,X 
$A582            .byte $00
$A583  40        RTI 
//------------------------------
$A584            .byte $FF
$A585  01 7C     ORA ($7C,X)
$A587  40        RTI 
//------------------------------
$A588            .byte $F4,$0F,$1F
//------------------------------
L_BRS_($A58B)_($A5D6) OK
//------------------------------
$A58B  78        SEI 
$A58C            .byte $1C
$A58D  70 1C     BVS L_BRS_($A5AB)_($A58D) OK
//------------------------------
L_BRS_($A58F)_($A58F) OK
//------------------------------
$A58F  30 FE     BMI L_BRS_($A58F)_($A58F) OK
$A591  40        RTI 
//------------------------------
$A592            .byte $00,$00,$00,$07
$A596  C0 0F     CPY #$0F
$A598            .byte $F8
$A599  F9 57 8E  SBC $8E57,Y 
$A59C  FD 3F FF  SBC $FF3F,X 
$A59F            .byte $1F
$A5A0  2E E0 02  ROL $02E0 
$A5A3            .byte $00
$A5A4  0E 65 00  ASL $0065 
$A5A7            .byte $00,$FF
$A5A9  F0 0F     BEQ L_BRS_($A5BA)_($A5A9) JAM
//------------------------------
L_BRS_($A5AB)_($A58D) OK
//------------------------------
$A5AB  20 0C 73  JSR L_JSR_($730C)_($A5AB) OK
$A5AE  7E E0 07  ROR $07E0,X 
$A5B1            .byte $00,$0C,$3F,$00
$A5B5  FE 00 00  INC $0000,X 
//------------------------------
L_BRS_($A5BA)_($A5A9) JAM
//------------------------------
$A5B8            .byte $00,$FC,$E7,$A7,$00,$FC,$00,$C7
$A5C0            .byte $00,$FC
$A5C2  FE FF F7  INC $F7FF,X 
$A5C5  38        SEC 
$A5C6            .byte $00,$00
$A5C8  70 00     BVS L_BRS_($A5CA)_($A5C8) JAM
//------------------------------
L_BRS_($A5CA)_($A5C8) JAM
//------------------------------
$A5CA            .byte $00
$A5CB  20 00 00  JSR $0000
$A5CE            .byte $63
$A5CF  E0 FC     CPX #$FC
$A5D1            .byte $03
$A5D2  C0 7C     CPY #$7C
$A5D4            .byte $00,$F2
$A5D6  70 B3     BVS L_BRS_($A58B)_($A5D6) OK
$A5D8  68        PLA 
$A5D9            .byte $0F
$A5DA  60        RTS 
//------------------------------
$A5DB            .byte $03
$A5DC  FE 00 0F  INC $0F00,X 
$A5DF            .byte $27,$00,$0B
$A5E2  60        RTS 
//------------------------------
$A5E3            .byte $80,$00
$A5E5  F6 7F     INC $7F,X 
$A5E7  F6 38     INC $38,X 
$A5E9            .byte $3F,$F8,$7C
$A5EC  C0 00     CPY #$00
$A5EE            .byte $00,$7C,$80
$A5F1  20 1F E8  JSR L_JSR_($E81F)_($A5F1) JAM
$A5F4            .byte $02,$00
$A5F6  01 FE     ORA ($FE,X)
$A5F8            .byte $80
$A5F9  20 30 1C  JSR L_JSR_($1C30)_($A5F9) OK
$A5FC  70 1C     BVS L_BRS_($A61A)_($A5FC) OK
$A5FE  78        SEI 
$A5FF            .byte $7C,$00,$AF,$7F,$FA,$FF,$BF
$A606  BE FA AF  LDX $AFFA,Y 
$A609            .byte $F7,$FB
$A60B  A2 BB     LDX #$BB
$A60D  EE BB ED  INC $EDBB 
$A610            .byte $7F,$FA,$7F,$FF,$FF,$EF,$FB,$F7
$A618            .byte $DF,$9F
//------------------------------
L_BRS_($A61A)_($A5FC) OK
//------------------------------
$A61A  EA        NOP 
$A61B  71 BF     ADC ($BF),Y 
$A61D            .byte $FC,$FF,$FB,$74,$F7,$4F,$F8,$73
$A625  A6 FE     LDX $FE 
$A627            .byte $FF,$FF,$EF,$F7,$F4,$37
$A62D  CE 7E F7  DEC $F77E 
$A630            .byte $E7,$F8,$37
$A633  FD F3 7F  SBC $7FF3,X 
//------------------------------
L_BRS_($A636)_($A675) JAM
//------------------------------
$A636            .byte $7F
$A637  FE 7F BF  INC $BF7F,X 
$A63A            .byte $E7
$A63B  E5 FF     SBC $FF 
$A63D            .byte $BF
$A63E  FE EB FF  INC $FFEB,X 
$A641            .byte $BF,$7F,$FF,$EF,$DC
$A646  FE FF EE  INC $EEFF,X 
$A649            .byte $FF
$A64A  FE F4 F7  INC $F7F4,X 
$A64D            .byte $FF
$A64E  C6 F7     DEC $F7 
$A650            .byte $BF,$DF,$FB
$A653  BE 7F 4F  LDX $4F7F,Y 
$A656  EE CD D6  INC $D6CD 
$A659            .byte $F7
$A65A  F6 DF     INC $DF,X 
$A65C            .byte $7F,$FF,$F7
$A65F  E4 FE     CPX $FE 
$A661            .byte $D7
$A662  06 FD     ASL $FD 
$A664            .byte $7F,$6F
$A666  FE 6F DC  INC $DC6F,X 
$A669            .byte $FC,$9F
$A66B  3E FB FF  ROL $FFFB,X 
$A66E            .byte $FF
$A66F  3E FD 05  ROL $05FD,X 
$A672            .byte $FB,$D7,$5F
$A675  F0 BF     BEQ L_BRS_($A636)_($A675) JAM
$A677            .byte $7F
$A678  FD 05 ED  SBC $ED05,X 
$A67B            .byte $BB
$A67C  EE BB A2  INC $A2BB 
$A67F  BE 00 F5  LDX $F500,Y 
$A682  FE 5F FF  INC $FF5F,X 
$A685  FD 7D 5F  SBC $5F7D,X 
$A688  F5 EF     SBC $EF,X 
$A68A            .byte $DF
$A68B  45 DD     EOR $DD 
$A68D            .byte $77
$A68E  DD B7 FE  CMP $FEB7,X 
$A691            .byte $5F
$A692  FE FF FF  INC $FFFF,X 
$A695            .byte $F7,$DF,$EF,$FB
$A699  F9 57 8E  SBC $8E57,Y 
$A69C  FD 3F FF  SBC $FF3F,X 
$A69F            .byte $DF
$A6A0  2E EF F2  ROL $F2EF 
$A6A3            .byte $1F
$A6A4  CE 65 7F  DEC $7F65 
$A6A7            .byte $FF,$FF,$F7,$EF,$2F
$A6AC  EC 73 7E  CPX $7E73 
$A6AF            .byte $EF,$E7,$1F
$A6B2  EC BF CF  CPX $CFBF 
$A6B5  FE FE 7F  INC $7FFE,X 
$A6B8  FE FD E7  INC $E7FD,X 
$A6BB            .byte $A7,$FF
$A6BD  FD 7F D7  SBC $D77F,X 
$A6C0            .byte $FF
$A6C1  FD FE FF  SBC $FFFE,X                          // Vector: IRQ
$A6C4            .byte $F7,$3B,$7F,$FF,$77,$FF,$7F,$2F
$A6CC            .byte $EF,$FF,$63,$EF
$A6D0  FD FB DF  SBC $DFFB,X 
$A6D3  7D FE F2  ADC $F2FE,X 
$A6D6            .byte $77,$B3,$6B,$EF,$6F,$FB
$A6DC  FE FF EF  INC $EFFF,X 
$A6DF            .byte $27,$7F,$EB
$A6E2  60        RTS 
//------------------------------
$A6E3            .byte $BF
$A6E4  FE F6 7F  INC $7FF6,X 
$A6E7  F6 3B     INC $3B,X 
$A6E9            .byte $3F
$A6EA  F9 7C DF  SBC $DF7C,Y 
$A6ED            .byte $FF,$FF,$7C,$BF
$A6F1  A0 DF     LDY #$DF
$A6F3            .byte $EB,$FA,$0F
$A6F6  FD FE BF  SBC $BFFE,X 
$A6F9  A0 B7     LDY #$B7
$A6FB  DD 77 DD  CMP $DD77,X 
$A6FE  45 7D     EOR $7D 
$A700            .byte $00,$7F,$80
$A703  01 7E     ORA ($7E,X)
$A705            .byte $80
$A706  7E 07 17  ROR $1707,X 
$A709            .byte $F8
$A70A  E8        INX 
$A70B            .byte $3C
$A70C  78        SEI 
$A70D  1E 78 1C  ASL $1C78,X 
$A710            .byte $80,$02,$00,$00,$00
$A715  70 01     BVS L_BRS_($A718)_($A715) JAM
$A717  78        SEI 
//------------------------------
L_BRS_($A718)_($A715) JAM
//------------------------------
$A718            .byte $1F,$07
$A71A  CE 7F 1F  DEC $1F7F 
$A71D  E0 7E     CPX #$7E
$A71F  E8        INX 
$A720            .byte $17
$A721  01 70     ORA ($70,X)
$A723            .byte $03
$A724  B0 7C     BCS L_BRS_($A7A2)_($A724) OK
$A726            .byte $00,$00,$7F,$07,$F8,$07,$F8,$FC
$A72E            .byte $7F,$07,$F8,$03,$F8
$A733  C0 00     CPY #$00
$A735            .byte $7F,$00,$00,$00,$4F,$FF,$FF,$00
$A73D            .byte $3F
$A73E  01 E7     ORA ($E7,X)
//------------------------------
L_BRS_($A744)_($A75E) JAM
//------------------------------
$A740            .byte $00,$3F,$5F,$FF,$FF,$0F,$00,$04
//------------------------------
L_BRS_($A74B)_($A761) JAM
//------------------------------
$A748            .byte $0F,$00,$00,$04
$A74C  08        PHP 
$A74D            .byte $00
$A74E  CC 07 7F  CPY $7F07 
$A751            .byte $80,$07
$A753  7E 00 4F  ROR $4F00,X 
$A756  0E EF 1E  ASL $1EEF 
$A759  E0 07     CPX #$07
$A75B  C0 FF     CPY #$FF
$A75D            .byte $00
$A75E  F0 E4     BEQ L_BRS_($A744)_($A75E) JAM
$A760            .byte $00
$A761  F0 E8     BEQ L_BRS_($A74B)_($A761) JAM
$A763  01 00     ORA ($00,X)
$A765  7E F0 C7  ROR $C7F0,X 
$A768            .byte $1F
$A769  78        SEI 
$A76A  0E FE 04  ASL $04FE 
$A76D            .byte $00,$00
$A76F  40        RTI 
//------------------------------
$A770  01 7C     ORA ($7C,X)
$A772  E8        INX 
$A773            .byte $0F
$A774  E0 07     CPX #$07
$A776            .byte $80
$A777  FE 00 7E  INC $7E00,X 
$A77A            .byte $1C
$A77B  78        SEI 
$A77C  1E 78 3C  ASL $3C78,X 
$A77F  7E 00 FE  ROR $FE00,X                          // Set Logical File Parameters/
$A782  01 80     ORA ($80,X)
$A784  7E 01 7E  ROR $7E01,X 
$A787  E0 E8     CPX #$E8
$A789            .byte $1F,$17,$3C
$A78C  1E 78 1E  ASL $1E78,X 
$A78F  38        SEC 
$A790  01 40     ORA ($40,X)
$A792            .byte $00,$00,$00
$A795  0E 80 1E  ASL $1E80 
$A798            .byte $F8
$A799  E0 73     CPX #$73
$A79B  FE F8 07  INC $07F8,X 
$A79E  7E 17 E8  ROR $E817,X 
$A7A1            .byte $80
//------------------------------
L_BRS_($A7A2)_($A724) OK
//------------------------------
$A7A2  0E C0 0D  ASL $0DC0 
$A7A5  3E 00 00  ROL $0000,X 
$A7A8  FE E0 1F  INC $1FE0,X 
$A7AB  E0 1F     CPX #$1F
$A7AD            .byte $3F
$A7AE  FE E0 1F  INC $1FE0,X 
$A7B1  C0 1F     CPY #$1F
$A7B3            .byte $03,$00
$A7B5  FE 00 00  INC $0000,X 
$A7B8            .byte $00,$F2,$FF,$FF,$00,$FC,$80,$E7
$A7C0            .byte $00,$FC,$FA,$FF,$FF
$A7C5  F0 00     BEQ L_BRS_($A7C7)_($A7C5) OK
//------------------------------
L_BRS_($A7C7)_($A7C5) OK
//------------------------------
$A7C7  20 F0 00  JSR $00F0
$A7CA            .byte $00
$A7CB  20 10 00  JSR $0010
$A7CE            .byte $33
//------------------------------
L_BRS_($A7CF)_($A7D6) OK
//------------------------------
$A7CF  E0 FE     CPX #$FE
$A7D1  01 E0     ORA ($E0,X)
$A7D3  7E 00 F2  ROR $F200,X 
$A7D6  70 F7     BVS L_BRS_($A7CF)_($A7D6) OK
$A7D8  78        SEI 
$A7D9            .byte $07
$A7DA  E0 03     CPX #$03
$A7DC            .byte $FF,$00,$0F,$27,$00,$0F,$17,$80
$A7E4            .byte $00
$A7E5  7E 0F E3  ROR $E30F,X 
$A7E8            .byte $F8
$A7E9  1E 70 7F  ASL $7F70,X 
$A7EC  20 00 00  JSR $0000
$A7EF            .byte $02,$80
$A7F1  3E 17 F0  ROL $F017,X                          // Send to RS232 Buffer
$A7F4            .byte $07
$A7F5  E0 01     CPX #$01
$A7F7            .byte $7F,$00
$A7F9  7E 38 1E  ROR $1E38,X 
$A7FC  78        SEI 
$A7FD  1E 3C 7E  ASL $7E3C,X 
$A800            .byte $00,$7F,$BF
$A803  FD 7E BF  SBC $BF7E,X 
$A806  7E F7 D7  ROR $D7F7,X 
$A809            .byte $FB,$EB
$A80B  BD 7B DE  LDA $DE7B,X 
$A80E            .byte $7B
$A80F  DD 80 FA  CMP $FA80,X 
$A812            .byte $FF,$FF,$FF,$77
$A816  9D 7B DF  STA $DF7B,X 
$A819            .byte $07
$A81A  CE 7F 1F  DEC $1F7F 
$A81D  E1 7E     SBC ($7E,X) 
$A81F            .byte $EB,$17
$A821  F1 77     SBC ($77),Y 
$A823            .byte $9B,$B7
$A825  7D FF 7F  ADC $7FFF,X 
$A828            .byte $7F,$F7,$FB,$97,$FB
$A82D  FD 7F F7  SBC $F77F,X 
$A830            .byte $FB,$9B,$FB
$A833  C1 FF     CMP ($FF,X) 
$A835            .byte $7F,$7F
$A837  FE 7F 4F  INC $4F7F,X 
$A83A            .byte $FF,$FF,$FF,$BF
$A83E  FD E7 FF  SBC $FFE7,X                          // Close All Channels And Files
$A841            .byte $BF,$5F,$FF,$FF,$EF,$FF,$F4,$EF
$A849            .byte $FF
$A84A  FE F4 CB  INC $CBF4,X 
$A84D            .byte $FF
$A84E  CD F7 7F  CMP $7FF7 
$A851            .byte $BF,$F7
$A853  7E 7F 4F  ROR $4F7F,X 
$A856  EE EF DE  INC $DEEF 
$A859            .byte $E3,$F7,$DF,$FF
$A85D  FE F7 E4  INC $E4F7,X 
$A860  FE F7 E8  INC $E8F7,X 
$A863  FD 3F 7E  SBC $7E3F,X 
$A866  F1 C7     SBC ($C7),Y 
$A868            .byte $DF
$A869  79 EE FE  ADC $FEEE,Y 
$A86C            .byte $F4,$FF,$FF
$A86F  41 FD     EOR ($FD,X) 
$A871  7D EB EF  ADC $EFEB,X 
$A874            .byte $EF,$F7,$BF
$A877  FE FE 7E  INC $7EFE,X 
$A87A  DD 7B DE  CMP $DE7B,X 
$A87D            .byte $7B
$A87E  BD 7E 00  LDA $007E,X 
$A881  FE FD BF  INC $BFFD,X 
$A884  7E FD 7E  ROR $7EFD,X 
$A887            .byte $EF,$EB,$DF,$D7
$A88B  BD DE 7B  LDA $7BDE,X 
$A88E  DE BB 01  DEC $01BB,X 
$A891            .byte $5F,$FF,$FF,$FF
$A895  EE B9 DE  INC $DEB9 
$A898            .byte $FB
$A899  E0 73     CPX #$73
$A89B  FE F8 87  INC $87F8,X 
$A89E  7E D7 E8  ROR $E8D7,X 
$A8A1            .byte $8F
$A8A2  EE D9 ED  INC $EDD9 
$A8A5  BE FF FE  LDX $FEFF,Y 
$A8A8  FE EF DF  INC $DFEF,X 
$A8AB  E9 DF     SBC #$DF
$A8AD            .byte $BF
$A8AE  FE EF DF  INC $DFEF,X 
$A8B1  D9 DF 83  CMP $83DF,Y 
$A8B4            .byte $FF
$A8B5  FE FE 7F  INC $7FFE,X 
$A8B8  FE F2 FF  INC $FFF2,X 
$A8BB            .byte $FF,$FF
$A8BD  FD BF E7  SBC $E7BF,X 
$A8C0            .byte $FF
$A8C1  FD FA FF  SBC $FFFA,X                          // Vector: NMI
$A8C4            .byte $FF,$F7,$FF,$2F,$F7,$FF,$7F,$2F
$A8CC            .byte $D3,$FF,$B3,$EF
$A8D0  FE FD EF  INC $EFFD,X 
//------------------------------
L_BRS_($A8D4)_($A922) BAD
//------------------------------
$A8D3  7E FE F2  ROR $F2FE,X 
$A8D6            .byte $77,$F7,$7B,$C7,$EF,$FB,$FF,$7F
$A8DE            .byte $EF,$27,$7F,$EF,$17,$BF,$FC
$A8E5  7E 8F E3  ROR $E38F,X 
$A8E8            .byte $FB,$9E,$77,$7F,$2F,$FF,$FF,$82
$A8F0            .byte $BF
$A8F1  BE D7 F7  LDX $F7D7,Y                          // Set Buffer Stat / End Pointers
$A8F4            .byte $F7,$EF
$A8F6  FD 7F 7F  SBC $7F7F,X 
$A8F9  7E BB DE  ROR $DEBB,X 
$A8FC            .byte $7B
$A8FD  DE BD 7E  DEC $7EBD,X 
$A900  10 00     BPL L_BRS_($A902)_($A900) JAM
//------------------------------
L_BRS_($A902)_($A900) JAM
//------------------------------
$A902            .byte $00,$1B
$A904  C0 44     CPY #$44
$A906  98        TYA 
$A907  24 40     BIT $40 
$A909            .byte $00,$00
$A90B  01 BC     ORA ($BC,X)
$A90D            .byte $00,$04
$A90F  49 80     EOR #$80
$A911  01 44     ORA ($44,X)
$A913            .byte $00,$12
$A915  20 02 52  JSR L_JSR_($5202)_($A915) JAM
$A918            .byte $00,$04,$1B
$A91B  01 64     ORA ($64,X)
$A91D            .byte $00,$00,$00
$A920  38        SEC 
$A921            .byte $FC
$A922  50 B0     BVC L_BRS_($A8D4)_($A922) BAD
$A924            .byte $32,$1F
$A926  C0 00     CPY #$00
$A928            .byte $00,$00,$03,$8F
$A92C  C0 0B     CPY #$0B
$A92E            .byte $03
$A92F  20 03 DE  JSR L_JSR_($DE03)_($A92F) BAD
$A932            .byte $00,$3F
$A934  50 01     BVC L_BRS_($A937)_($A934) OK
$A936            .byte $FC
//------------------------------
L_BRS_($A937)_($A934) OK
//------------------------------
$A937  08        PHP 
$A938  38        SEC 
$A939  E0 00     CPX #$00
$A93B            .byte $00,$3C,$FC
$A93E  5E C6 1D  LSR $1DC6,X 
//------------------------------
L_BRS_($A941)_($A95B) OK
//------------------------------
$A941  5E 00 A4  LSR $A400,X 
$A944  06 00     ASL $00 
$A946  50 5C     BVC L_BRS_($A9A4)_($A946) BAD
$A948            .byte $00,$00
$A94A  D0 14     BNE L_BRS_($A960)_($A94A) BAD
$A94C            .byte $00,$00,$8F
$A94F  0E E4 00  ASL $00E4 
$A952            .byte $E7,$0C,$80
$A955  E4 3E     CPX $3E 
$A957            .byte $9C,$0B,$00,$00
$A95B  F0 E4     BEQ L_BRS_($A941)_($A95B) OK
$A95D            .byte $00
$A95E  48        PHA 
//------------------------------
L_BRS_($A960)_($A94A) BAD
//------------------------------
$A95F  EE 02 C0  INC $C002 
$A962  B9 00 00  LDA $0000,Y 
$A965            .byte $00,$00,$00,$00,$03,$CF
$A96B  C0 05     CPY #$05
//------------------------------
L_BRS_($A96F)_($A9AD) BAD
//------------------------------
$A96D  EC 60 01  CPX $0160 
$A970  B5 E0     LDA $E0,X 
$A972  1D 5E 00  ORA $005E,X
$A975  05 3C     ORA $3C
$A977  7E 00 00  ROR $0000,X 
$A97A            .byte $00,$07,$1A
$A97D  A0 4A     LDY #$4A
$A97F            .byte $00
$A980  08        PHP 
$A981            .byte $00,$00
$A983  D8        CLD 
$A984            .byte $03,$22
$A986  19 24 02  ORA $0224,Y
$A989            .byte $00,$00,$80
$A98C  3D 00 20  AND $2000,X 
$A98F            .byte $92
$A990  01 80     ORA ($80,X)
$A992            .byte $22,$00
$A994  48        PHA 
$A995            .byte $04
$A996  40        RTI 
//------------------------------
$A997  4A        LSR A 
$A998            .byte $00
$A999  20 D8 80  JSR L_JSR_($80D8)_($A999) JAM
$A99C  26 00     ROL $00 
$A99E            .byte $00,$00,$1C,$3F
$A9A2  0A        ASL A 
//------------------------------
L_BRS_($A9A4)_($A946) BAD
//------------------------------
$A9A3  0D 4C F8  ORA $F84C
$A9A6            .byte $03,$00,$00,$00
$A9AA  C0 F1     CPY #$F1
$A9AC            .byte $03
$A9AD  D0 C0     BNE L_BRS_($A96F)_($A9AD) BAD
$A9AF            .byte $04
$A9B0  C0 7B     CPY #$7B
$A9B2            .byte $00,$FC
$A9B4  0A        ASL A 
$A9B5            .byte $80,$3F
$A9B7  10 1C     BPL L_BRS_($A9D5)_($A9B7) JAM
$A9B9            .byte $07,$00,$00,$3C,$3F,$7A,$63,$B8
$A9C1            .byte $7A,$00
$A9C3  25 60     AND $60
$A9C5            .byte $00
$A9C6  0A        ASL A 
$A9C7            .byte $3A,$00,$00,$0B
$A9CB  28        PLP 
$A9CC            .byte $00,$00
$A9CE  F1 70     SBC ($70),Y 
$A9D0            .byte $27,$00,$E7
$A9D3  30 01     BMI L_BRS_($A9D6)_($A9D3) JAM
//------------------------------
L_BRS_($A9D5)_($A9B7) JAM
L_BRS_($A9D6)_($A9D3) JAM
//------------------------------
$A9D5            .byte $27,$7C
$A9D7  39 D0 00  AND $00D0,Y 
$A9DA            .byte $00,$0F,$27,$00,$12,$77
$A9E0  40        RTI 
//------------------------------
$A9E1            .byte $03
$A9E2  9D 00 00  STA $0000,X 
$A9E5            .byte $00,$00,$00,$00
$A9E9  C0 F3     CPY #$F3
$A9EB            .byte $03
$A9EC  A0 37     LDY #$37
$A9EE  06 80     ASL $80 
$A9F0  AD 07 B8  LDA $B807 
$A9F3            .byte $7A,$00
$A9F5  A0 3C     LDY #$3C
$A9F7  7E 00 00  ROR $0000,X 
$A9FA            .byte $00
$A9FB  E0 58     CPX #$58
$A9FD  05 52     ORA $52
$A9FF            .byte $00,$00,$E3,$FF,$DB,$DF,$44,$9B
$AA07  A4 5F     LDY $5F 
$AA09  FE 3F FD  INC $FD3F,X 
$AA0C  BD FF F4  LDA $F4FF,X 
$AA0F  49 BF     EOR #$BF
$AA11  FD 45 FF  SBC $FF45,X 
$AA14            .byte $D2,$2F,$FA,$52,$FF
$AA19  E5 9B     SBC $9B 
$AA1B  FD 64 E0  SBC $E064,X 
$AA1E            .byte $7F,$FF,$B8
$AA21  FD 50 B0  SBC $B050,X 
$AA24            .byte $32,$DF,$DF
$AA27  FE 07 FF  INC $FF07,X                          // NMI RS232 Out
$AA2A            .byte $FB,$8F,$DF,$EB,$03,$2F,$FB
$AA31  DE FF BF  DEC $BFFF,X 
$AA34            .byte $57
$AA35  FD FD 8B  SBC $8BFD,X 
$AA38            .byte $B8
$AA39  E0 E1     CPX #$E1
$AA3B            .byte $FF
$AA3C  BC FD 5E  LDY $5EFD,X 
$AA3F  C6 DD     DEC $DD 
$AA41  5E FF A5  LSR $A5FF,X 
$AA44  F6 19     INC $19,X 
$AA46            .byte $57,$5C,$FF,$FF,$D7,$D4,$FF,$7F
$AA4E            .byte $8F
$AA4F  EE E4 FF  INC $FFE4                          // Get From Keyboad
$AA52            .byte $E7
$AA53  EC BF E4  CPX $E4BF 
$AA56  BE 9D EB  LDX $EB9D,Y 
$AA59            .byte $3F,$FC,$F7
$AA5C  E4 FE     CPX $FE 
$AA5E            .byte $4B
$AA5F  EE FA DF  INC $DFFA 
$AA62  B9 FE FF  LDA $FFFE,Y                          // Vector: IRQ
$AA65            .byte $C3
$AA66  FE 1F FF  INC $FF1F,X 
$AA69            .byte $FB,$CF,$DF
$AA6C  F5 EC     SBC $EC,X 
$AA6E            .byte $6F
$AA6F  FD B5 EF  SBC $EFB5,X 
$AA72  DD 5E FF  CMP $FF5E,X 
$AA75  F5 3C     SBC $3C,X 
$AA77  7E FF FF  ROR $FFFF,X 
$AA7A            .byte $FF,$F7,$5A,$AF
$AA7E  4A        LSR A 
$AA7F            .byte $FF,$00,$C7,$FF,$DB,$FB,$22
$AA86  D9 25 FA  CMP $FA25,Y 
$AA89            .byte $7F,$FC,$BF
$AA8C  BD FF 2F  LDA $2FFF,X 
$AA8F            .byte $92
$AA90  FD BF A2  SBC $A2BF,X 
$AA93            .byte $FF,$4B,$F4,$5F
$AA97  4A        LSR A 
$AA98            .byte $FF,$A7
$AA9A  D9 BF 26  CMP $26BF,Y 
$AA9D            .byte $07
$AA9E  FE FF 1D  INC $1DFF,X 
$AAA1            .byte $BF
$AAA2  0A        ASL A 
$AAA3  0D 4C FB  ORA $FB4C
$AAA6            .byte $FB,$7F
$AAA8  E0 FF     CPX #$FF
$AAAA            .byte $DF
$AAAB  F1 FB     SBC ($FB),Y 
$AAAD            .byte $D7
$AAAE  C0 F4     CPY #$F4
$AAB0            .byte $DF,$7B,$FF
$AAB3  FD EA BF  SBC $BFEA,X 
$AAB6            .byte $BF
$AAB7  D1 1D     CMP ($1D),Y 
$AAB9            .byte $07,$87,$FF
$AABC  3D BF 7A  AND $7ABF,X 
$AABF            .byte $63,$BB,$7A,$FF
$AAC3  A5 6F     LDA $6F 
$AAC5            .byte $FF
$AAC6  EA        NOP 
$AAC7            .byte $3A,$FF,$FF,$EB,$2B,$FF
$AACD  FE F1 77  INC $77F1,X 
$AAD0            .byte $27,$FF,$E7,$37
$AAD4  FD 27 7D  SBC $7D27,X 
$AAD7  B9 D7 FC  LDA $FCD7,Y 
$AADA            .byte $3F,$EF,$27,$7F,$D2,$77,$5F,$FB
$AAE2  9D 7F FF  STA $FF7F,X 
$AAE5            .byte $C3,$7F,$F8,$FF,$DF,$F3,$FB,$AF
$AAED            .byte $37
$AAEE  F6 BF     INC $BF,X 
$AAF0  AD F7 BB  LDA $BBF7 
$AAF3            .byte $7A,$FF,$AF,$3C
$AAF7  7E FF FF  ROR $FFFF,X 
$AAFA            .byte $FF,$EF,$5A
$AAFD  F5 52     SBC $52,X 
$AAFF            .byte $FF,$00,$1C,$00,$3F
$AB04  A0 48     LDY #$48
$AB06  90 14     BCC L_BRS_($AB1C)_($AB06) OK
$AB08  40        RTI 
//------------------------------
$AB09  01 C0     ORA ($C0,X)
$AB0B            .byte $03,$FA,$00,$04
$AB0F  91 00     STA ($00),Y 
$AB11  01 8C     ORA ($8C,X)
$AB13            .byte $00,$12
$AB15  20 04 89  JSR L_JSR_($8904)_($AB15) OK
$AB18            .byte $00
$AB19  0A        ASL A 
$AB1A            .byte $7F,$00
//------------------------------
L_BRS_($AB1C)_($AB06) OK
//------------------------------
$AB1C  E4 1F     CPX $1F 
$AB1E            .byte $80,$00,$4F,$C2
$AB22  4E A3 54  LSR $54A3 
$AB25            .byte $1F
$AB26  C0 01     CPY #$01
$AB28            .byte $F8,$00,$04,$FC
$AB2C  20 0A 35  JSR L_JSR_($350A)_($AB2C) OK
$AB2F  40        RTI 
//------------------------------
$AB30            .byte $03,$CF,$00,$1F
$AB34  50 00     BVC L_BRS_($AB36)_($AB34) JAM
//------------------------------
L_BRS_($AB36)_($AB34) JAM
//------------------------------
$AB36            .byte $FC,$14,$4F,$3B
$AB3A  1E 00 7D  ASL $7D00,X 
$AB3D            .byte $F4
$AB3E  7D 2E 1D  ADC $1D2E,X 
//------------------------------
L_BRS_($AB41)_($AB5B) OK
//------------------------------
$AB41  5E 00 E4  LSR $E400,X 
$AB44  06 00     ASL $00 
$AB46  D0 4E     BNE L_BRS_($AB96)_($AB46) OK
$AB48            .byte $00,$00
$AB4A  50 12     BVC L_BRS_($AB5E)_($AB4A) OK
$AB4C            .byte $00,$00,$8F,$0F,$F4,$00,$F3,$0C
$AB54            .byte $80
$AB55  E8        INX 
$AB56  26 FE     ROL $FE 
$AB58            .byte $0F
$AB59  C0 03     CPY #$03
//------------------------------
L_BRS_($AB5B)_($ABAD) OK
//------------------------------
$AB5B  70 E4     BVS L_BRS_($AB41)_($AB5B) OK
$AB5D            .byte $00
//------------------------------
L_BRS_($AB5E)_($AB4A) OK
L_BRS_($AB5E)_($AB7C) OK
//------------------------------
$AB5E  88        DEY 
$AB5F  6E 02 E0  ROR $E002 
$AB62            .byte $FF,$00,$00,$3C
$AB66  01 E0     ORA ($E0,X)
$AB68            .byte $00,$07,$DF
$AB6B  40        RTI 
//------------------------------
$AB6C            .byte $07,$D2
$AB6E  E0 01     CPX #$01
$AB70            .byte $97
$AB71  E0 19     CPX #$19
$AB73  5E 00 04  LSR $0400,X 
$AB76  FD 1D 00  SBC $001D,X 
$AB79            .byte $00,$00,$04
$AB7C  90 E0     BCC L_BRS_($AB5E)_($AB7C) OK
$AB7E  45 00     EOR $00 
$AB80            .byte $00
$AB81  38        SEC 
$AB82            .byte $00,$FC
$AB84  05 12     ORA $12
$AB86  09 28     ORA #$28
$AB88            .byte $02,$80,$03
$AB8B  C0 5F     CPY #$5F
$AB8D            .byte $00
$AB8E  20 89 00  JSR $0089
$AB91            .byte $80
$AB92  31 00     AND ($00),Y 
$AB94  48        PHA 
$AB95            .byte $04
//------------------------------
L_BRS_($AB96)_($AB46) OK
//------------------------------
$AB96  20 91 00  JSR $0091
//------------------------------
L_BRS_($AB99)_($AB99) OK
//------------------------------
$AB99  50 FE     BVC L_BRS_($AB99)_($AB99) OK
$AB9B            .byte $00,$27,$F8
$AB9E  01 00     ORA ($00,X)
$ABA0            .byte $F2,$43,$72
$ABA3  C5 2A     CMP $2A 
$ABA5            .byte $F8,$03,$80,$1F,$00
$ABAA  20 3F 04  JSR $043F
$ABAD  50 AC     BVC L_BRS_($AB5B)_($ABAD) OK
$ABAF            .byte $02
$ABB0  C0 F3     CPY #$F3
$ABB2            .byte $00,$F8
$ABB4  0A        ASL A 
$ABB5            .byte $00,$3F
$ABB7  28        PLP 
$ABB8            .byte $F2,$DC
$ABBA  78        SEI 
$ABBB            .byte $00
$ABBC  BE 2F BE  LDX $BE2F,Y 
$ABBF            .byte $74,$B8,$7A,$00,$27
$ABC4  60        RTS 
//------------------------------
$ABC5            .byte $00,$0B,$72,$00,$00
$ABCA  0A        ASL A 
$ABCB  48        PHA 
$ABCC            .byte $00,$00
$ABCE  F1 F0     SBC ($F0),Y 
$ABD0            .byte $2F,$00,$CF
$ABD3  30 01     BMI L_BRS_($ABD6)_($ABD3) JAM
//------------------------------
L_BRS_($ABD6)_($ABD3) JAM
//------------------------------
$ABD5            .byte $17,$64,$7F
$ABD8  F0 03     BEQ L_BRS_($ABDD)_($ABD8) JAM
$ABDA  C0 0E     CPY #$0E
//------------------------------
L_BRS_($ABDD)_($ABD8) JAM
//------------------------------
$ABDC            .byte $27,$00
$ABDE  11 76     ORA ($76),Y
$ABE0  40        RTI 
//------------------------------
$ABE1            .byte $07,$FF,$00,$00,$3C,$80,$07,$00
$ABE9  E0 FB     CPX #$FB
$ABEB            .byte $02
$ABEC  E0 4B     CPX #$4B
$ABEE            .byte $07,$80
$ABF0  E9 07     SBC #$07
$ABF2  98        TYA 
$ABF3            .byte $7A,$00
$ABF5  20 BF B8  JSR L_JSR_($B8BF)_($ABF5) JAM
$ABF8            .byte $00,$00,$00
$ABFB  20 09 07  JSR $0709
$ABFE  A2 00     LDX #$00
$AC00            .byte $00,$DC,$FF,$BF,$AF
$AC05  48        PHA 
$AC06            .byte $97,$D4,$5F
$AC09  FD CF FB  SBC $FBCF,X 
$AC0C            .byte $FA,$FF,$F4
$AC0F  91 7F     STA ($7F),Y 
$AC11  FD 8D FF  SBC $FF8D,X                          // Change Vectors For User
$AC14            .byte $D2,$2F,$F4,$89,$7F
$AC19  EA        NOP 
$AC1A            .byte $7F
$AC1B  FE E4 DF  INC $DFE4,X 
$AC1E            .byte $9F,$FF,$4F,$C2
$AC22  4E A3 55  LSR $55A3 
$AC25            .byte $DF,$DF
$AC27  FD F9 FF  SBC $FFF9,X 
$AC2A            .byte $F4,$FC,$2F
$AC2D  EA        NOP 
$AC2E  35 5F     AND $5F,X 
$AC30            .byte $FB,$CF,$7F
$AC33  E9 57     SBC #$57
$AC35  FE FD D5  INC $D5FD,X 
$AC38            .byte $4F,$3B
$AC3A  DE FF 7D  DEC $7DFF,X 
$AC3D  F5 7D     SBC $7D,X 
$AC3F  2E DD 5E  ROL $5EDD 
$AC42            .byte $FF
$AC43  E5 F6     SBC $F6 
$AC45            .byte $BF,$D7
$AC47  4E FF FC  LSR $FCFF 
$AC4A            .byte $57,$D2,$FF,$7F,$8F,$EF,$F4,$F8
$AC52            .byte $F3
$AC53  EC BF E8  CPX $E8BF 
$AC56  A6 FE     LDX $FE 
$AC58            .byte $EF,$DF,$FB,$77
$AC5C  E4 FE     CPX $FE 
$AC5E            .byte $8B
$AC5F  6E FA EF  ROR $EFFA 
$AC62            .byte $FF
$AC63  FE FF BD  INC $BDFF,X 
$AC66  FD EF FF  SBC $FFEF,X 
//------------------------------
L_BRS_($AC6D)_($AC7C) JAM
//------------------------------
$AC69            .byte $F7,$DF,$5F,$F7,$D2,$EF
$AC6F  FD 97 EF  SBC $EF97,X 
$AC72  D9 5E FF  CMP $FF5E,Y 
$AC75            .byte $F4
$AC76  FD 9D FF  SBC $FF9D,X 
$AC79            .byte $FF,$FF,$F4
$AC7C  90 EF     BCC L_BRS_($AC6D)_($AC7C) JAM
$AC7E  45 FF     EOR $FF 
$AC80            .byte $00,$3B,$FF
$AC83  FD F5 12  SBC $12F5,X 
$AC86  E9 2B     SBC #$2B
$AC88            .byte $FA,$BF,$F3,$DF,$5F,$FF,$2F,$89
$AC90  FE BF B1  INC $B1BF,X                          // FAC#1 to Positive Integer
$AC93            .byte $FF,$4B,$F4,$2F
$AC97  91 FE     STA ($FE),Y 
$AC99            .byte $57
$AC9A  FE 7F 27  INC $277F,X 
$AC9D            .byte $FB
$AC9E  F9 FF F2  SBC $F2FF,Y 
$ACA1            .byte $43,$72
$ACA3  C5 AA     CMP $AA 
$ACA5            .byte $FB,$FB,$BF,$9F,$FF,$2F,$3F,$F4
$ACAD            .byte $57
$ACAE  AC FA DF  LDY $DFFA 
$ACB1            .byte $F3
$ACB2  FE FB EA  INC $EAFB,X 
$ACB5            .byte $7F,$BF,$AB,$F2,$DC,$7B,$FF
$ACBC  BE AF BE  LDX $BEAF,Y 
$ACBF            .byte $74,$BB,$7A,$FF,$A7,$6F
$ACC5  FD EB 72  SBC $72EB,X 
$ACC8            .byte $FF,$3F
$ACCA  EA        NOP 
$ACCB            .byte $4B,$FF
$ACCD  FE F1 F7  INC $F7F1,X 
$ACD0            .byte $2F,$1F,$CF,$37
$ACD4  FD 17 65  SBC $6517,X 
$ACD7            .byte $7F,$F7,$FB,$DF
$ACDB  EE 27 7F  INC $7F27 
$ACDE  D1 76     CMP ($76),Y 
$ACE0            .byte $5F,$F7,$FF,$7F,$FF
$ACE5  BD BF F7  LDA $F7BF,X 
$ACE8            .byte $FF,$EF,$FB,$FA,$EF,$4B,$F7,$BF
$ACF0  E9 F7     SBC #$F7
$ACF2            .byte $9B,$7A,$FF,$2F,$BF
$ACF7  B9 FF FF  LDA $FFFF,Y 
$ACFA            .byte $FF,$2F
$ACFC  09 F7     ORA #$F7
$ACFE  A2 FF     LDX #$FF
$AD00            .byte $00,$03,$00
$AD03  6E 10 68  ROR $6810 
$AD06  70 14     BVS L_BRS_($AD1C)_($AD06) OK
$AD08  40        RTI 
//------------------------------
$AD09            .byte $00
$AD0A  30 06     BMI L_BRS_($AD12)_($AD0A) OK
$AD0C  E1 00     SBC ($00,X) 
$AD0E  06 87     ASL $87 
$AD10            .byte $00,$00
//------------------------------
L_BRS_($AD12)_($AD0A) OK
//------------------------------
$AD12  8E 00 12  STX $1200 
$AD15  20 04 88  JSR L_JSR_($8804)_($AD15) OK
$AD18            .byte $80
$AD19  09 8E     ORA #$8E
$AD1B            .byte $00
//------------------------------
L_BRS_($AD1C)_($AD06) OK
//------------------------------
$AD1C  28        PLP 
$AD1D            .byte $0F
$AD1E  E0 00     CPX #$00
$AD20  85 C2     STA $C2 
$AD22  48        PHA 
$AD23            .byte $C7
$AD24  8C 1F C0  STY $C01F 
$AD27            .byte $00
$AD28  FE 00 08  INC $0800,X 
$AD2B            .byte $5C
$AD2C  20 0C 78  JSR L_JSR_($780C)_($AD2C) BAD
$AD2F  C0 07     CPY #$07
$AD31            .byte $CF,$80,$1F
$AD34  20 00 7E  JSR L_JSR_($7E00)_($AD34) JAM
$AD37            .byte $12
$AD38  85 23     STA $23 
$AD3A  21 00     AND ($00,X) 
$AD3C  7E F4 7E  ROR $7EF4,X 
$AD3F  1E 1F 5C  ASL $5C1F,X 
$AD42            .byte $00
$AD43  B4 0E     LDY $0E,X 
$AD45  40        RTI 
//------------------------------
$AD46  A0 47     LDY #$47
$AD48            .byte $00,$03
$AD4A  20 17 00  JSR $0017
$AD4D            .byte $00,$9F,$0F,$F4,$07
$AD52  F1 09     SBC ($09),Y 
$AD54  40        RTI 
//------------------------------
$AD55            .byte $EF
$AD56  1E ED 14  ASL $14ED,X 
$AD59  20 04 70  JSR L_JSR_($7004)_($AD59) JAM
$AD5C  E4 00     CPX $00 
$AD5E            .byte $F4
$AD5F  EE 01 D0  INC $D001                          // Sprite 0 Y Pos
$AD62  6E 01 00  ROR $0001 
$AD65            .byte $42,$02
$AD67  10 00     BPL L_BRS_($AD69)_($AD67) JAM
//------------------------------
L_BRS_($AD69)_($AD67) JAM
//------------------------------
$AD69            .byte $07,$EF
$AD6B  40        RTI 
//------------------------------
$AD6C            .byte $07
$AD6D  E1 E0     SBC ($E0,X) 
$AD6F  01 95     ORA ($95,X)
$AD71  E0 19     CPX #$19
$AD73            .byte $5C,$00
$AD75  05 FE     ORA $FE
$AD77            .byte $1C,$00,$00,$00,$04
$AD7C  8D 60 44  STA $4460 
$AD7F            .byte $00,$00
$AD81  C0 00     CPY #$00
$AD83  76 08     ROR $08,X 
$AD85  16 0E     ASL $0E,X 
$AD87  28        PLP 
$AD88            .byte $02,$00,$0C
$AD8B  60        RTS 
//------------------------------
$AD8C            .byte $87,$00
$AD8E  60        RTS 
//------------------------------
$AD8F  E1 00     SBC ($00,X) 
$AD91            .byte $00
$AD92  71 00     ADC ($00),Y 
$AD94  48        PHA 
$AD95            .byte $04
$AD96  20 11 01  JSR $0111
$AD99  90 71     BCC L_BRS_($AE0C)_($AD99) BAD
$AD9B            .byte $00,$14
$AD9D  F0 07     BEQ L_BRS_($ADA6)_($AD9D) JAM
$AD9F            .byte $00
$ADA0  A1 43     LDA ($43,X) 
$ADA2            .byte $12,$E3
$ADA4  31 F8     AND ($F8),Y 
//------------------------------
L_BRS_($ADA6)_($AD9D) JAM
//------------------------------
$ADA6            .byte $03,$00,$7F,$00
$ADAA  10 3A     BPL L_BRS_($ADE6)_($ADAA) OK
$ADAC            .byte $04
$ADAD  30 1E     BMI L_BRS_($ADCD)_($ADAD) JAM
$ADAF            .byte $03
$ADB0  E0 F3     CPX #$F3
$ADB2  01 F8     ORA ($F8,X)
$ADB4            .byte $04,$00
$ADB6  7E 48 A1  ROR $A148,X 
$ADB9  C4 84     CPY $84 
$ADBB            .byte $00
$ADBC  7E 2F 7E  ROR $7E2F,X 
$ADBF  78        SEI 
$ADC0            .byte $F8,$3A,$00
$ADC3  2D 70 02  AND $0270 
$ADC6  05 E2     ORA $E2
$ADC8            .byte $00
$ADC9  C0 04     CPY #$04
$ADCB  E8        INX 
//------------------------------
L_BRS_($ADCD)_($ADAD) JAM
//------------------------------
$ADCC            .byte $00,$00
$ADCE  F9 F0 2F  SBC $2FF0,Y 
$ADD1  E0 8F     CPX #$8F
$ADD3  90 02     BCC L_BRS_($ADD7)_($ADD3) JAM
$ADD5            .byte $F7
$ADD6  78        SEI 
//------------------------------
L_BRS_($ADD7)_($ADD3) JAM
//------------------------------
$ADD7            .byte $B7
$ADD8  28        PLP 
$ADD9            .byte $04
$ADDA  20 0E 27  JSR L_JSR_($270E)_($ADDA) BAD
$ADDD            .byte $00,$2F,$77,$80,$0B
$ADE2  76 80     ROR $80,X 
$ADE4            .byte $00,$42
//------------------------------
L_BRS_($ADE6)_($ADAA) OK
//------------------------------
$ADE6  40        RTI 
//------------------------------
$ADE7  08        PHP 
$ADE8            .byte $00
$ADE9  E0 F7     CPX #$F7
$ADEB            .byte $02
$ADEC  E0 87     CPX #$87
$ADEE            .byte $07,$80
$ADF0  A9 07     LDA #$07
$ADF2  98        TYA 
$ADF3            .byte $3A,$00
$ADF5  A0 7F     LDY #$7F
$ADF7  38        SEC 
$ADF8            .byte $00,$00,$00
$ADFB  20 B1 06  JSR $06B1
$ADFE            .byte $22,$00,$00,$C3,$7F
$AE03  6E 17 68  ROR $6817 
$AE06            .byte $77,$D4,$5F,$FC,$37
//------------------------------
L_BRS_($AE0C)_($AD99) BAD
//------------------------------
$AE0B  F6 E1     INC $E1,X 
$AE0D            .byte $7F
$AE0E  F6 87     INC $87,X 
$AE10            .byte $7F
$AE11  FE 8E FF  INC $FF8E,X 
$AE14            .byte $D2,$2F,$F4
$AE17  A8        TAY 
$AE18            .byte $BF
$AE19  E9 8E     SBC #$8E
$AE1B            .byte $FF
$AE1C  28        PLP 
$AE1D            .byte $EF,$EF
$AE1F  FE 85 C2  INC $C285,X 
$AE22  48        PHA 
$AE23            .byte $C7
$AE24  8D DF DF  STA $DFDF 
$AE27  FE FE 7F  INC $7FFE,X 
$AE2A  E8        INX 
$AE2B            .byte $5C,$2F
$AE2D  EC 78 DF  CPX $DF78 
$AE30            .byte $F7,$CF,$BF
$AE33  E0 2F     CPX #$2F
$AE35            .byte $FF
$AE36  7E D2 85  ROR $85D2,X 
$AE39            .byte $A3
$AE3A  A1 7F     LDA ($7F,X) 
$AE3C  7E F5 7E  ROR $7EF5,X 
$AE3F  1E DF 5D  ASL $5DDF,X 
$AE42            .byte $FC
$AE43  B5 CE     LDA $CE,X 
$AE45            .byte $5F,$A7,$47,$7F,$FB,$2F,$D7,$FF
$AE4D            .byte $7F,$9F,$EF,$F4,$F7
$AE52  F1 E9     SBC ($E9),Y 
$AE54            .byte $5F,$EF
$AE56  DE ED D4  DEC $D4ED,X 
$AE59            .byte $2F,$F4,$77
$AE5C  E4 FE     CPX $FE 
$AE5E  F5 EE     SBC $EE,X 
$AE60  FD D7 6E  SBC $6ED7,X 
$AE63  FD FF 42  SBC $42FF,X 
$AE66            .byte $FA,$17,$FF,$F7,$EF,$5F,$F7
$AE6D  E1 EF     SBC ($EF,X) 
$AE6F  FD 95 EF  SBC $EF95,X 
$AE72  D9 5D FF  CMP $FF5D,Y 
$AE75  F5 FE     SBC $FE,X 
$AE77            .byte $DC,$7F,$FF,$FF,$F4
$AE7C  8D 6F 44  STA $446F 
$AE7F            .byte $7F,$00,$C3
$AE82  FE 76 E8  INC $E876,X 
$AE85  16 EE     ASL $EE,X 
$AE87            .byte $2B,$FA,$3F
$AE8A  EC 6F 87  CPX $876F 
$AE8D  FE 6F E1  INC $E16F,X 
$AE90  FE 7F 71  INC $717F,X 
$AE93            .byte $FF,$4B,$F4,$2F
$AE97  15 FD     ORA $FD,X
$AE99            .byte $97
$AE9A  71 FF     ADC ($FF),Y 
$AE9C            .byte $14,$F7,$F7,$7F
$AEA0  A1 43     LDA ($43,X) 
$AEA2            .byte $12,$E3
$AEA4  B1 FB     LDA ($FB),Y 
$AEA6            .byte $FB,$7F,$7F
$AEA9  FE 17 3A  INC $3A17,X 
$AEAC            .byte $F4,$37
$AEAE  1E FB EF  ASL $EFFB,X 
$AEB1            .byte $F3
$AEB2  FD FB F4  SBC $F4FB,X 
$AEB5            .byte $FF
$AEB6  7E 4B A1  ROR $A14B,X 
$AEB9  C5 85     CMP $85 
$AEBB  FE 7E AF  INC $AF7E,X 
$AEBE  7E 78 FB  ROR $FB78,X 
$AEC1  BA        TSX 
$AEC2            .byte $3F
$AEC3  AD 73 FA  LDA $FA73 
$AEC6  E5 E2     SBC $E2 
$AEC8  FE DF F4  INC $F4DF,X 
$AECB            .byte $EB,$FF
$AECD  FE F9 F7  INC $F7F9,X 
$AED0            .byte $2F,$EF,$8F,$97,$FA,$F7,$7B,$B7
$AED8            .byte $2B,$F4,$2F
$AEDB  EE 27 7F  INC $7F27 
$AEDE            .byte $AF,$77,$BF,$EB
$AEE2  76 BF     ROR $BF,X 
$AEE4            .byte $FF,$42,$5F
$AEE7  E8        INX 
$AEE8            .byte $FF,$EF,$F7,$FA,$EF,$87,$F7,$BF
$AEF0  A9 F7     LDA #$F7
$AEF2            .byte $9B
$AEF3  BA        TSX 
$AEF4            .byte $FF,$AF,$7F,$3B
$AEF8  FE FF FF  INC $FFFF,X 
$AEFB            .byte $2F
$AEFC  B1 F6     LDA ($F6),Y 
$AEFE            .byte $22
$AEFF  FE 00 2B  INC $2B00,X 
$AF02            .byte $80,$44
$AF04  88        DEY 
$AF05  24 50     BIT $50 
$AF07            .byte $14
$AF08  40        RTI 
//------------------------------
$AF09            .byte $02,$B8,$04
$AF0C  48        PHA 
$AF0D            .byte $80,$02
$AF0F  45 00     EOR $00 
$AF11            .byte $00
$AF12  8D 00 12  STA $1200 
$AF15  20 04 84  JSR L_JSR_($8404)_($AF15) JAM
$AF18  40        RTI 
//------------------------------
$AF19            .byte $0B
$AF1A  84 00     STY $00 
$AF1C  28        PLP 
$AF1D  10 70     BPL L_BRS_($AF8F)_($AF1D) OK
$AF1F            .byte $00
$AF20  85 82     STA $82 
$AF22  28        PLP 
$AF23            .byte $8F
$AF24  C4 1F     CPY $1F 
$AF26  C0 01     CPY #$01
$AF28            .byte $07,$80
$AF2A  08        PHP 
$AF2B  58        CLI 
$AF2C  20 08 FC  JSR L_JSR_($FC08)_($AF2C) BAD
$AF2F  40        RTI 
//------------------------------
$AF30            .byte $07,$87,$80,$1F
$AF34  F0 00     BEQ L_BRS_($AF36)_($AF34) JAM
//------------------------------
L_BRS_($AF36)_($AF34) JAM
//------------------------------
$AF36            .byte $FF
$AF37  16 85     ASL $85,X 
$AF39            .byte $23,$43,$80,$72
$AF3D  E4 1D     CPX $1D 
$AF3F  FE 1F 5C  INC $5C1F,X 
$AF42            .byte $03,$B2
$AF44  3D 60 F0  AND $F060,X 
$AF47            .byte $27,$80,$04
$AF4A  70 0D     BVS L_BRS_($AF59)_($AF4A) BAD
$AF4C            .byte $00,$00,$17,$07,$74
$AF51  08        PHP 
$AF52  78        SEI 
$AF53  09 40     ORA #$40
$AF55            .byte $1F,$0F
//------------------------------
L_BRS_($AF59)_($AF4A) BAD
//------------------------------
$AF57  ED 16 70  SBC $7016 
$AF5A            .byte $04
$AF5B  70 6E     BVS L_BRS_($AFCB)_($AF5B) BAD
$AF5D            .byte $00,$F4
$AF5F  F1 00     SBC ($00),Y 
$AF61  D0 6E     BNE L_BRS_($AFD1)_($AF61) OK
$AF63  01 00     ORA ($00,X)
$AF65            .byte $47,$04
$AF67  38        SEC 
$AF68            .byte $00,$07
$AF6A  2E 40 01  ROL $0140 
$AF6D            .byte $DF
$AF6E  E0 01     CPX #$01
$AF70  95 90     STA $90,X 
$AF72  19 5C 00  ORA $005C,Y
$AF75            .byte $03,$72
$AF77  1D 80 00  ORA $0080,X
$AF7A            .byte $00,$03
$AF7C  48        PHA 
$AF7D  70 27     BVS L_BRS_($AFA6)_($AF7D) JAM
$AF7F            .byte $80,$00,$D4
$AF82  01 22     ORA ($22,X)
$AF84  11 24     ORA ($24),Y
$AF86  0A        ASL A 
$AF87  28        PLP 
$AF88            .byte $02
$AF89  40        RTI 
//------------------------------
$AF8A  1D 20 12  ORA $1220,X
$AF8D  01 40     ORA ($40,X)
//------------------------------
L_BRS_($AF8F)_($AF1D) OK
L_BRS_($AF8F)_($AFD6) OK
//------------------------------
$AF8F  A2 00     LDX #$00
$AF91            .byte $00
$AF92  B1 00     LDA ($00),Y 
$AF94  48        PHA 
$AF95            .byte $04
$AF96  20 21 02  JSR $0221
$AF99  D0 21     BNE L_BRS_($AFBC)_($AF99) BAD
$AF9B            .byte $00,$14
$AF9D  08        PHP 
$AF9E  0E 00 A1  ASL $A100 
$AFA1  41 14     EOR ($14,X) 
$AFA3  F1 23     SBC ($23),Y 
//------------------------------
L_BRS_($AFA6)_($AF7D) JAM
//------------------------------
$AFA5            .byte $F8,$03,$80
$AFA8  E0 01     CPX #$01
$AFAA  10 1A     BPL L_BRS_($AFC6)_($AFAA) BAD
$AFAC            .byte $04
$AFAD  10 3F     BPL L_BRS_($AFEE)_($AFAD) JAM
$AFAF            .byte $02
$AFB0  E0 E1     CPX #$E1
$AFB2  01 F8     ORA ($F8,X)
$AFB4            .byte $0F,$00,$FF
$AFB7  68        PLA 
$AFB8  A1 C4     LDA ($C4,X) 
$AFBA            .byte $C2
//------------------------------
L_BRS_($AFBC)_($AF99) BAD
//------------------------------
$AFBB  01 4E     ORA ($4E,X)
$AFBD            .byte $27,$B8,$7F,$F8,$3A
$AFC2  C0 4D     CPY #$4D
//------------------------------
L_BRS_($AFC6)_($AFAA) BAD
//------------------------------
$AFC4  BC 06 0F  LDY $0F06,X 
$AFC7  E4 01     CPX $01 
//------------------------------
L_BRS_($AFCB)_($AF5B) BAD
//------------------------------
$AFC9  20 0E B0  JSR L_JSR_($B00E)_($AFC9) JAM
$AFCC            .byte $00,$00
$AFCE  E8        INX 
$AFCF  E0 2E     CPX #$2E
//------------------------------
L_BRS_($AFD1)_($AF61) OK
//------------------------------
$AFD1  10 1E     BPL L_BRS_($AFF1)_($AFD1) BAD
$AFD3  90 02     BCC L_BRS_($AFD7)_($AFD3) BAD
$AFD5            .byte $F8
//------------------------------
L_BRS_($AFD7)_($AFD3) BAD
//------------------------------
$AFD6  F0 B7     BEQ L_BRS_($AF8F)_($AFD6) OK
$AFD8  68        PLA 
$AFD9  0E 20 0E  ASL $0E20 
$AFDC  76 00     ROR $00,X 
$AFDE            .byte $2F,$8F,$00,$0B
$AFE2  76 80     ROR $80,X 
$AFE4            .byte $00,$E2
$AFE6  20 1C 00  JSR $001C
$AFE9  E0 74     CPX #$74
//------------------------------
L_BRS_($AFEE)_($AFAD) JAM
//------------------------------
$AFEB            .byte $02,$80,$FB,$07,$80
//------------------------------
L_BRS_($AFF1)_($AFD1) BAD
//------------------------------
$AFF0  A9 09     LDA #$09
$AFF2  98        TYA 
$AFF3            .byte $3A,$00
$AFF5  C0 4E     CPY #$4E
$AFF7            .byte $B8
$AFF8  01 00     ORA ($00,X)
$AFFA            .byte $00
$AFFB  C0 12     CPY #$12
$AFFD  0E E4 01  ASL $01E4 
$B000            .byte $00,$AB,$BF,$44,$8B
$B005  A4 57     LDY $57 
$B007            .byte $D4,$5F,$FA,$BB,$F4
$B00C  48        PHA 
//------------------------------
L_JSR_($B00E)_($AFC9) JAM
L_JSR_($B00E)_($EC42) JAM
//------------------------------
$B00D            .byte $BF,$FA
$B00F  45 7F     EOR $7F 
$B011  FE 8D 7F  INC $7F8D,X 
$B014            .byte $D2,$2F,$F4
$B017  B4 5F     LDY $5F,X 
$B019            .byte $EB
$B01A  84 FF     STY $FF 
$B01C  A8        TAY 
$B01D  D0 77     BNE L_BRS_($B096)_($B01D) JAM
$B01F  FE 85 82  INC $8285,X 
$B022  A8        TAY 
$B023            .byte $8F
$B024  C5 DF     CMP $DF 
$B026            .byte $DF
$B027  FD 07 BF  SBC $BF07,X 
$B02A  E8        INX 
$B02B  58        CLI 
$B02C            .byte $2F
$B02D  E8        INX 
$B02E            .byte $FC,$5F,$F7,$B7,$BF,$DF,$F7
$B035  FE FF D6  INC $D6FF,X 
$B038  85 A3     STA $A3 
$B03A            .byte $43,$BF,$72
$B03D  E5 9D     SBC $9D 
$B03F  FE DF 5D  INC $5DDF,X 
$B042            .byte $FB,$B2
$B044  3D 60 F7  AND $F760,X 
$B047            .byte $A7,$BF
$B049  E4 77     CPX $77 
$B04B  ED FF 7F  SBC $7FFF 
$B04E            .byte $17,$F7,$74
$B051  E8        INX 
$B052  78        SEI 
$B053  E9 5F     SBC #$5F
$B055            .byte $1F,$EF
$B057  ED D6 77  SBC $77D6 
$B05A            .byte $F4,$77
$B05C  6E FF F5  ROR $F5FF 
$B05F  F1 FE     SBC ($FE),Y 
$B061            .byte $D7
$B062  6E FD 7F  ROR $7FFD 
$B065            .byte $47,$F4,$3B,$FF,$F7
$B06A  2E 5F F9  ROL $F95F 
$B06D            .byte $DF,$EF
$B06F  FD 95 97  SBC $9795,X 
$B072  D9 5D FF  CMP $FF5D,Y 
$B075            .byte $FB,$72
$B077  DD BF FF  CMP $FFBF,X 
$B07A            .byte $FF,$FB
$B07C  48        PHA 
$B07D            .byte $77,$A7,$BF,$00
$B081  D5 FD     CMP $FD,X 
$B083            .byte $22
$B084  D1 25     CMP ($25),Y 
$B086  EA        NOP 
$B087            .byte $2B,$FA,$5F
$B08A  DD 2F 12  CMP $122F,X 
$B08D  FD 5F A2  SBC $A25F,X 
$B090  FE 7F B1  INC $B17F,X 
$B093  FE 4B F4  INC $F44B,X 
//------------------------------
L_BRS_($B096)_($B01D) JAM
//------------------------------
$B096            .byte $2F
$B097  2D FA D7  AND $D7FA 
$B09A  21 FF     AND ($FF,X) 
$B09C  15 0B     ORA $0B,X
$B09E  EE 7F A1  INC $A17F 
$B0A1  41 15     EOR ($15,X) 
$B0A3  F1 A3     SBC ($A3),Y 
$B0A5            .byte $FB,$FB,$BF
$B0A8  E0 FD     CPX #$FD
$B0AA            .byte $17,$1A,$F4,$17,$3F,$FA,$EF
$B0B1  ED FD FB  SBC $FBFD 
$B0B4            .byte $EF,$7F,$FF,$6B
$B0B8  A1 C5     LDA ($C5,X) 
$B0BA            .byte $C2
$B0BB  FD 4E A7  SBC $A74E,X 
$B0BE  B9 7F FB  LDA $FB7F,Y 
$B0C1  BA        TSX 
$B0C2            .byte $DF
$B0C3  4D BC 06  EOR $06BC 
$B0C6            .byte $EF
$B0C7  E5 FD     SBC $FD 
$B0C9            .byte $27
$B0CA  EE B7 FF  INC $FFB7                          // Read I/O Status Word
$B0CD  FE E8 EF  INC $EFE8,X 
$B0D0  2E 17 1E  ROL $1E17 
$B0D3            .byte $97,$FA,$F8,$F7,$B7,$6B
$B0D9  EE 2F EE  INC $EE2F 
$B0DC  76 FF     ROR $FF,X 
$B0DE            .byte $AF,$8F,$7F,$EB
$B0E2  76 BF     ROR $BF,X 
$B0E4  FE E2 2F  INC $2FE2,X 
$B0E7            .byte $DC,$FF,$EF,$74,$FA,$9F,$FB,$F7
$B0EF            .byte $BF
$B0F0  A9 E9     LDA #$E9
$B0F2            .byte $9B
$B0F3  BA        TSX 
$B0F4            .byte $FF,$DF
$B0F6  4E BB FD  LSR $FDBB 
$B0F9            .byte $FF,$FF,$DF,$12
$B0FD  EE E5 FD  INC $FDE5 
$B100            .byte $00
$B101  56 80     LSR $80,X 
$B103  45 C8     EOR $C8 
$B105  2C 10 0C  BIT $0C10 
$B108  40        RTI 
//------------------------------
$B109  05 68     ORA $68
$B10B            .byte $04,$5C,$80,$02
$B10F  C1 00     CMP ($00,X) 
$B111            .byte $00,$9F,$80,$12
$B115  20 05 02  JSR $0205
$B118  60        RTS 
//------------------------------
$B119  06 A5     ASL $A5 
$B11B            .byte $00
$B11C  24 1A     BIT $1A 
$B11E  F0 00     BEQ L_BRS_($B120)_($B11E) OK
//------------------------------
L_BRS_($B120)_($B11E) OK
//------------------------------
$B120  A5 92     LDA $92 
$B122            .byte $27,$9F
$B124  E8        INX 
$B125            .byte $1F
$B126  C0 01     CPY #$01
$B128            .byte $AF,$80
$B12A  0A        ASL A 
$B12B  59 20 09  EOR $0920,Y 
$B12E  FE 80 07  INC $0780,X 
$B131            .byte $83
$B132  40        RTI 
//------------------------------
$B133            .byte $0F
$B134  90 00     BCC L_BRS_($B136)_($B134) JAM
//------------------------------
L_BRS_($B136)_($B134) JAM
//------------------------------
$B136            .byte $FF
$B137  1D 85 23  ORA $2385,X
$B13A  6A        ROR A 
$B13B            .byte $80
$B13C  78        SEI 
$B13D  E6 1D     INC $1D 
//------------------------------
L_BRS_($B140)_($B15E) BAD
//------------------------------
$B13F  5E 03 48  LSR $4803,X 
$B142  06 AA     ASL $AA 
$B144            .byte $C3,$7F
//------------------------------
L_BRS_($B146)_($B1AA) OK
//------------------------------
$B146  90 23     BCC L_BRS_($B16B)_($B146) BAD
$B148  C0 1F     CPY #$1F
$B14A  90 09     BCC L_BRS_($B155)_($B14A) JAM
$B14C            .byte $00,$00,$1F
$B14F  01 0C     ORA ($0C,X)
$B151            .byte $1F,$04
$B153  09 00     ORA #$00
//------------------------------
L_BRS_($B155)_($B14A) JAM
//------------------------------
$B155            .byte $0F
$B156  0E 6D 16  ASL $166D 
$B159  F0 06     BEQ L_BRS_($B161)_($B159) OK
$B15B  40        RTI 
//------------------------------
$B15C  24 00     BIT $00 
$B15E  F0 E0     BEQ L_BRS_($B140)_($B15E) BAD
$B160            .byte $00
//------------------------------
L_BRS_($B161)_($B159) OK
//------------------------------
$B161  D0 6E     BNE L_BRS_($B1D1)_($B161) BAD
$B163  01 00     ORA ($00,X)
$B165            .byte $6F
$B166  06 A8     ASL $A8 
$B168            .byte $00,$07
//------------------------------
L_BRS_($B16B)_($B146) BAD
//------------------------------
$B16A  8E 60 01  STX $0160 
$B16D  D5 E0     CMP $E0,X 
$B16F            .byte $00
$B170  94 90     STY $90,X 
$B172  09 48     ORA #$48
$B174            .byte $00
$B175  01 38     ORA ($38,X)
$B177  1D 40 00  ORA $0040,X
$B17A            .byte $00,$03,$5F
$B17D  90 22     BCC L_BRS_($B1A1)_($B17D) BAD
$B17F            .byte $80,$00
$B181  6A        ROR A 
$B182  01 A2     ORA ($A2,X)
$B184            .byte $13,$34
$B186  08        PHP 
$B187  30 02     BMI L_BRS_($B18B)_($B187) OK
$B189  A0 16     LDY #$16
//------------------------------
L_BRS_($B18B)_($B187) OK
//------------------------------
$B18B  20 3A 01  JSR $013A
$B18E  40        RTI 
//------------------------------
$B18F            .byte $83,$00,$00
$B192  F9 01 48  SBC $4801,Y 
$B195            .byte $04
$B196  A0 40     LDY #$40
$B198  06 60     ASL $60 
$B19A  A5 00     LDA $00 
$B19C  24 58     BIT $58 
$B19E            .byte $0F,$00
//------------------------------
L_BRS_($B1A1)_($B17D) BAD
//------------------------------
$B1A0  A5 49     LDA $49 
$B1A2  E4 F9     CPX $F9 
$B1A4            .byte $17,$F8,$03,$80
$B1A8  F5 01     SBC $01,X 
$B1AA  50 9A     BVC L_BRS_($B146)_($B1AA) OK
$B1AC            .byte $04
$B1AD  90 7F     BCC L_BRS_($B22E)_($B1AD) OK
$B1AF  01 E0     ORA ($E0,X)
$B1B1  C1 02     CMP ($02,X) 
$B1B3  F0 09     BEQ L_BRS_($B1BE)_($B1B3) BAD
$B1B5            .byte $00,$FF,$B8
$B1B8  A1 C4     LDA ($C4,X) 
$B1BA  56 01     LSR $01,X 
//------------------------------
L_BRS_($B1BE)_($B1B3) BAD
//------------------------------
$B1BC  1E 67 B8  ASL $B867,X                          // Perform Addition
$B1BF            .byte $7A
$B1C0  C0 12     CPY #$12
$B1C2  60        RTS 
//------------------------------
$B1C3  55 C3     EOR $C3,X 
$B1C5  FE 09 C4  INC $C409,X 
$B1C8            .byte $03,$F8
//------------------------------
L_BRS_($B1CA)_($B1D0) OK
//------------------------------
$B1CA  09 90     ORA #$90
$B1CC            .byte $00,$00,$F8,$80
//------------------------------
L_BRS_($B1D1)_($B161) BAD
//------------------------------
$B1D0  30 F8     BMI L_BRS_($B1CA)_($B1D0) OK
$B1D2  20 90 00  JSR $0090
$B1D5  F0 70     BEQ L_BRS_($B247)_($B1D5) JAM
$B1D7  B6 68     LDX $68,Y 
$B1D9            .byte $0F
$B1DA  60        RTS 
//------------------------------
$B1DB            .byte $02
$B1DC  24 00     BIT $00 
$B1DE            .byte $0F,$07,$00,$0B
$B1E2  76 80     ROR $80,X 
$B1E4            .byte $00
$B1E5  F6 60     INC $60,X 
$B1E7  15 00     ORA $00,X
$B1E9  E0 71     CPX #$71
$B1EB  06 80     ASL $80 
$B1ED            .byte $AB,$07,$00
$B1F0  29 09     AND #$09
$B1F2  90 12     BCC L_BRS_($B206)_($B1F2) BAD
$B1F4            .byte $00,$80,$1C,$B8,$02,$00,$00
$B1FB  C0 FA     CPY #$FA
$B1FD  09 44     ORA #$44
$B1FF  01 00     ORA ($00,X)
$B201  56 BF     LSR $BF,X 
$B203  45 CB     EOR $CB 
//------------------------------
L_BRS_($B206)_($B1F2) BAD
//------------------------------
$B205  AC 17 EC  LDY $EC17 
$B208            .byte $5F
$B209  F5 6B     SBC $6B,X 
$B20B            .byte $F4,$5C,$BF,$FA
$B20F  C1 7F     CMP ($7F,X) 
$B211  FE 9F BF  INC $BF9F,X 
$B214            .byte $D2,$2F
$B216  F5 7A     SBC $7A,X 
$B218            .byte $6F
$B219  F6 A5     INC $A5,X 
$B21B            .byte $FF
$B21C  A4 DA     LDY $DA 
$B21E            .byte $F7
$B21F  FE A5 92  INC $92A5,X 
$B222            .byte $A7,$9F,$EB,$DF,$DF
$B227  FD AF 9F  SBC $9FAF,X 
$B22A  EA        NOP 
$B22B  59 2F E9  EOR $E92F,Y 
//------------------------------
L_BRS_($B22E)_($B1AD) OK
//------------------------------
$B22E  FE BF E7  INC $E7BF,X 
$B231            .byte $BB,$4F,$EF,$97
$B235  FE FF DD  INC $DDFF,X 
$B238  85 A3     STA $A3 
$B23A  6A        ROR A 
$B23B            .byte $BF
$B23C  78        SEI 
$B23D  E6 DD     INC $DD 
$B23F  5E E3 4B  LSR $4BE3,X 
$B242  E6 AA     INC $AA 
//------------------------------
L_BRS_($B247)_($B1D5) JAM
//------------------------------
$B244            .byte $C3,$7F,$97,$A3,$DF,$DF,$97
$B24B  E9 FF     SBC #$FF
$B24D            .byte $7F,$1F
$B24F  F9 8C DF  SBC $DF8C,Y 
$B252            .byte $04
$B253  E9 1F     SBC #$1F
$B255            .byte $0F
$B256  EE 6D D6  INC $D66D 
$B259            .byte $F7
$B25A  F6 4F     INC $4F,X 
$B25C  A4 FF     LDY $FF 
$B25E            .byte $F3
$B25F  E0 FE     CPX #$FE
$B261            .byte $D7
$B262  6E FD 7F  ROR $7FFD 
$B265            .byte $6F
$B266  F6 BB     INC $BB,X 
$B268            .byte $FF,$F7
$B26A  8E 6F FD  STX $FD6F 
$B26D  D5 EF     CMP $EF,X 
$B26F  FE 94 97  INC $9794,X 
$B272  E9 4B     SBC #$4B
$B274            .byte $FF
$B275  FD 38 DD  SBC $DD38,X 
$B278            .byte $5F,$F8,$7F,$FB,$5F,$97
$B27E  A2 BF     LDX #$BF
$B280            .byte $00
$B281  6A        ROR A 
$B282  FD A2 D3  SBC $D3A2,X 
$B285  35 E8     AND $E8,X 
$B287            .byte $37,$FA,$AF
$B28A  D6 2F     DEC $2F,X 
$B28C            .byte $3A
$B28D  FD 5F 83  SBC $835F,X 
$B290  FE 7F F9  INC $F97F,X 
$B293  FD 4B F4  SBC $F44B,X 
$B296            .byte $AF
$B297  5E F6 6F  LSR $6FF6,X 
$B29A  A5 FF     LDA $FF 
$B29C  25 5B     AND $5B
$B29E            .byte $EF,$7F
$B2A0  A5 49     LDA $49 
$B2A2  E5 F9     SBC $F9 
$B2A4            .byte $D7,$FB,$FB,$BF
$B2A8  F5 F9     SBC $F9,X 
$B2AA            .byte $57
$B2AB  9A        TXS 
$B2AC            .byte $F4,$97,$7F
$B2AF  FD E7 DD  SBC $DDE7,X 
$B2B2            .byte $F2,$F7
$B2B4  E9 7F     SBC #$7F
$B2B6            .byte $FF,$BB
$B2B8  A1 C5     LDA ($C5,X) 
$B2BA  56 FD     LSR $FD,X 
$B2BC  1E 67 BB  ASL $BB67,X 
$B2BF            .byte $7A,$C7,$D2,$67
$B2C3  55 C3     EOR $C3,X 
$B2C5  FE E9 C5  INC $C5E9,X 
$B2C8            .byte $FB,$FB
$B2CA  E9 97     SBC #$97
$B2CC            .byte $FF
$B2CD  FE F8 9F  INC $9FF8,X 
$B2D0  31 FB     AND ($FB),Y 
$B2D2  20 97 F8  JSR L_JSR_($F897)_($B2D2) BAD
$B2D5  F0 77     BEQ L_BRS_($B34E)_($B2D5) JAM
$B2D7  B6 6B     LDX $6B,Y 
$B2D9            .byte $EF,$6F,$F2
$B2DC  25 FF     AND $FF
$B2DE            .byte $CF,$07,$7F,$EB
$B2E2  76 BF     ROR $BF,X 
$B2E4  FE F6 6F  INC $6FF6,X 
$B2E7  DD FF EF  CMP $EFFF,X 
$B2EA  71 F6     ADC ($F6),Y 
$B2EC            .byte $BF,$AB,$F7,$7F
$B2F0  29 E9     AND #$E9
$B2F2            .byte $97,$D2,$FF,$BF,$1C,$BB,$FA,$1F
$B2FA  FE DF FA  INC $FADF,X 
$B2FD  E9 45     SBC #$45
$B2FF  FD 00 28  SBC $2800,X 
$B302            .byte $80,$44
$B304  48        PHA 
$B305  2E 10 1F  ROL $1F10 
$B308  40        RTI 
//------------------------------
$B309            .byte $02
$B30A  90 04     BCC L_BRS_($B310)_($B30A) BAD
$B30C            .byte $44,$80,$02
//------------------------------
L_BRS_($B310)_($B30A) BAD
//------------------------------
$B30F  E1 00     SBC ($00,X) 
$B311  01 D4     ORA ($D4,X)
$B313            .byte $80,$3B
$B315  A0 0F     LDY #$0F
$B317  01 E0     ORA ($E0,X)
$B319  06 A4     ASL $A4 
$B31B            .byte $00
$B31C  2C 10 50  BIT $5010 
$B31F            .byte $00
$B320  A5 92     LDA $92 
$B322            .byte $17,$7F,$F8,$3F
$B326  C0 01     CPY #$01
$B328  05 E0     ORA $E0
$B32A  0A        ASL A 
$B32B  59 20 07  EOR $0720,Y 
$B32E            .byte $FF,$80,$1F
$B331  81 40     STA ($40,X) 
$B333            .byte $1F
$B334  08        PHP 
//------------------------------
L_BRS_($B336)_($B3B4) BAD
//------------------------------
$B335  01 F6     ORA ($F6,X)
$B337            .byte $04
$B338  85 2F     STA $2F 
$B33A            .byte $43,$80
$B33C  78        SEI 
$B33D  E6 1D     INC $1D 
$B33F  5E 01 48  LSR $4801,X 
$B342            .byte $1F
//------------------------------
L_BRS_($B344)_($B35E) BAD
//------------------------------
$B343  EE 37 70  INC $7037 
//------------------------------
L_BRS_($B346)_($B3AA) OK
//------------------------------
$B346  88        DEY 
$B347            .byte $17
$B348  20 24 08  JSR L_JSR_($0824)_($B348) BAD
$B34B  09 00     ORA #$00
//------------------------------
L_BRS_($B34E)_($B2D5) JAM
//------------------------------
$B34D            .byte $00,$E7,$03
$B350  1D 2F 02  ORA $022F,X
$B353  1E 00 4F  ASL $4F00,X 
$B356  0E AD 16  ASL $16AD 
$B359  70 04     BVS L_BRS_($B35F)_($B359) BAD
$B35B  C0 3D     CPY #$3D
$B35D            .byte $00
//------------------------------
L_BRS_($B35F)_($B359) BAD
//------------------------------
$B35E  F0 E4     BEQ L_BRS_($B344)_($B35E) BAD
$B360            .byte $00
$B361  D0 6E     BNE L_BRS_($B3D1)_($B361) JAM
$B363  01 00     ORA ($00,X)
$B365            .byte $47,$04
$B367  38        SEC 
$B368            .byte $00,$07
$B36A  8E 60 01  STX $0160 
$B36D  D5 E0     CMP $E0,X 
$B36F            .byte $00
$B370  94 70     STY $70,X 
$B372  09 48     ORA #$48
$B374            .byte $00,$00
$B376  98        TYA 
$B377  1D 20 07  ORA $0720,X
$B37A            .byte $80
$B37B  05 2F     ORA $2F
$B37D  88        DEY 
$B37E            .byte $13,$80,$00,$14
$B382  01 22     ORA ($22,X)
$B384            .byte $12,$74
$B386  08        PHP 
$B387            .byte $F8,$02
$B389  40        RTI 
//------------------------------
$B38A  09 20     ORA #$20
$B38C            .byte $22
//------------------------------
L_BRS_($B38D)_($B3D6) OK
//------------------------------
$B38D  01 40     ORA ($40,X)
$B38F            .byte $87,$00,$80,$2B
$B393  01 DC     ORA ($DC,X)
$B395  05 F0     ORA $F0
$B397            .byte $80,$07
$B399  60        RTS 
//------------------------------
$B39A  25 00     AND $00
$B39C            .byte $34
$B39D  08        PHP 
$B39E  0A        ASL A 
$B39F            .byte $00
$B3A0  A5 49     LDA $49 
$B3A2  E8        INX 
$B3A3  FE 1F FC  INC $FC1F,X 
$B3A6            .byte $03,$80
$B3A8  A0 07     LDY #$07
$B3AA  50 9A     BVC L_BRS_($B346)_($B3AA) OK
$B3AC            .byte $04
$B3AD  E0 FF     CPX #$FF
$B3AF  01 F8     ORA ($F8,X)
$B3B1  81 02     STA ($02,X) 
$B3B3            .byte $F8
$B3B4  10 80     BPL L_BRS_($B336)_($B3B4) BAD
$B3B6            .byte $6F
$B3B7  20 A1 F4  JSR L_JSR_($F4A1)_($B3B7) JAM
$B3BA            .byte $C2
$B3BB  01 1E     ORA ($1E,X)
$B3BD            .byte $67,$B8,$7A,$80,$12,$F8,$77
$B3C4  EC 0E 11  CPX $110E 
$B3C7  E8        INX 
$B3C8            .byte $04
$B3C9  24 10     BIT $10 
$B3CB  90 00     BCC L_BRS_($B3CD)_($B3CB) JAM
//------------------------------
L_BRS_($B3CD)_($B3CB) JAM
//------------------------------
$B3CD            .byte $00,$E7
$B3CF  C0 B8     CPY #$B8
//------------------------------
L_BRS_($B3D1)_($B361) JAM
//------------------------------
$B3D1            .byte $F4
$B3D2  40        RTI 
//------------------------------
$B3D3  78        SEI 
$B3D4            .byte $00,$F2
$B3D6  70 B5     BVS L_BRS_($B38D)_($B3D6) OK
$B3D8  68        PLA 
$B3D9  0E 20 03  ASL $0320 
$B3DC  BC 00 0F  LDY $0F00,X 
$B3DF            .byte $27,$00,$0B
$B3E2  76 80     ROR $80,X 
$B3E4            .byte $00,$E2
$B3E6  20 1C 00  JSR $001C
$B3E9  E0 71     CPX #$71
$B3EB  06 80     ASL $80 
$B3ED            .byte $AB,$07,$00
$B3F0  29 0E     AND #$0E
$B3F2  90 12     BCC L_BRS_($B406)_($B3F2) BAD
$B3F4            .byte $00,$00
$B3F6  19 B8 04  ORA $04B8,Y
$B3F9  E0 01     CPX #$01
$B3FB  A0 F4     LDY #$F4
$B3FD  11 C8     ORA ($C8),Y
$B3FF  01 00     ORA ($00,X)
$B401  A8        TAY 
$B402            .byte $BF,$44,$4B
//------------------------------
L_BRS_($B406)_($B3F2) BAD
//------------------------------
$B405  AE 17 DF  LDX $DF17 
$B408            .byte $5F,$FA,$93,$F4,$44,$BF,$FA
$B40F  E1 7F     SBC ($7F,X) 
$B411  FD D4 BF  SBC $BFD4,X                          // Table of Constants  9.6414017 E-3
$B414            .byte $BB,$AF,$EF
$B417  7D EF F6  ADC $F6EF,X 
$B41A  A4 FF     LDY $FF 
$B41C  AC D0 57  LDY $57D0 
$B41F  FE A5 92  INC $92A5,X 
$B422            .byte $D7,$7F,$FB,$BF,$DF
$B427  FD 05 EF  SBC $EF05,X 
$B42A  EA        NOP 
$B42B  59 2F F7  EOR $F72F,Y 
$B42E            .byte $FF,$BF,$DF
$B431  BD 4F DF  LDA $DF4F,X 
$B434            .byte $0B
$B435  FD F6 E4  SBC $E4F6,X 
$B438  85 AF     STA $AF 
$B43A            .byte $43,$8F
$B43C  78        SEI 
$B43D  E6 DD     INC $DD 
$B43F  5E FD 4B  LSR $4BFD,X 
$B442            .byte $9F
$B443  EE 37 70  INC $7037 
$B446            .byte $8B,$D7,$2F
$B449  A4 0B     LDY $0B 
$B44B  E9 FF     SBC #$FF
$B44D            .byte $7F,$E7,$FB
$B450  DD AF FA  CMP $FAAF,X 
$B453  DE 7F 4F  DEC $4F7F,X 
$B456  EE AD D6  INC $D6AD 
$B459            .byte $77,$F4,$DF
$B45C  BD FF F7  LDA $F7FF,X 
$B45F  EE FE D7  INC $D7FE 
$B462  6E FD 7F  ROR $7FFD 
$B465            .byte $47,$F4
$B467  38        SEC 
$B468            .byte $FF,$F7
$B46A  8E 6F FD  STX $FD6F 
$B46D  D5 EF     CMP $EF,X 
$B46F  FE 94 77  INC $7794,X 
$B472  E9 4B     SBC #$4B
$B474            .byte $FF
//------------------------------
L_BRS_($B475)_($B4B4) OK
//------------------------------
$B475  FE 98 DD  INC $DD98,X 
$B478            .byte $AF,$F7,$BF
$B47B  F5 2F     SBC $2F,X 
$B47D            .byte $8B,$D3,$9F,$00
$B481  15 FD     ORA $FD,X
$B483            .byte $22,$D2
$B485  75 E8     ADC $E8,X 
$B487            .byte $FB,$FA,$5F
$B48A  C9 2F     CMP #$2F
$B48C            .byte $22
$B48D  FD 5F 87  SBC $875F,X 
$B490  FE BF 2B  INC $2BBF,X 
$B493  FD DD F5  SBC $F5DD,X                          // Save RAM
$B496            .byte $F7
$B497  BE F7 6F  LDX $6FF7,Y 
$B49A  25 FF     AND $FF
$B49C  35 0B     AND $0B,X 
$B49E  EA        NOP 
$B49F            .byte $7F
$B4A0  A5 49     LDA $49 
$B4A2            .byte $EB
$B4A3  FE DF FD  INC $FDDF,X 
$B4A6            .byte $FB,$BF
$B4A8  A0 F7     LDY #$F7
$B4AA            .byte $57
$B4AB  9A        TXS 
$B4AC            .byte $F4,$EF,$FF
$B4AF  FD FB BD  SBC $BDFB,X 
$B4B2            .byte $F2,$FB
$B4B4  D0 BF     BNE L_BRS_($B475)_($B4B4) OK
$B4B6            .byte $6F,$27
$B4B8  A1 F5     LDA ($F5,X) 
$B4BA            .byte $C2
$B4BB  F1 1E     SBC ($1E),Y 
$B4BD            .byte $67,$BB,$7A,$BF,$D2
$B4C2  F9 77 EC  SBC $EC77,Y 
$B4C5  0E D1 EB  ASL $EBD1 
$B4C8            .byte $F4
$B4C9  25 D0     AND $D0
$B4CB            .byte $97,$FF
$B4CD  FE E7 DF  INC $DFE7,X 
$B4D0            .byte $BB
$B4D1  F5 5F     SBC $5F,X 
$B4D3            .byte $7B
$B4D4  FE F2 77  INC $77F2,X 
$B4D7  B5 6B     LDA $6B,X 
$B4D9  EE 2F FB  INC $FB2F 
$B4DC  BD FF EF  LDA $EFFF,X 
$B4DF            .byte $77,$7F,$EB
$B4E2  76 BF     ROR $BF,X 
$B4E4  FE E2 2F  INC $2FE2,X 
$B4E7            .byte $1C,$FF,$EF
$B4EA  71 F6     ADC ($F6),Y 
$B4EC            .byte $BF,$AB,$F7,$7F
$B4F0  29 EE     AND #$EE
$B4F2            .byte $97,$D2,$FF,$7F
$B4F6  19 BB F5  ORA $F5BB,Y
$B4F9            .byte $EF
$B4FA  FD AF F4  SBC $F4AF,X 
$B4FD  D1 CB     CMP ($CB),Y 
$B4FF  F9 00 21  SBC $2100,Y 
$B502            .byte $00
$B503  4C 68 36  JMP L_JMP_($3668)_($B503) OK
$B506  10 35     BPL L_BRS_($B53D)_($B506) OK
$B508  C0 02     CPY #$02
$B50A  10 04     BPL L_BRS_($B510)_($B50A) BAD
$B50C  C6 80     DEC $80 
$B50E            .byte $03
//------------------------------
L_BRS_($B510)_($B50A) BAD
L_BRS_($B50F)_($B545) OK
//------------------------------
$B50F  C1 00     CMP ($00,X) 
$B511  01 75     ORA ($75,X)
$B513            .byte $00
$B514  6E E0 19  ROR $19E0 
$B517  01 60     ORA ($60,X)
$B519            .byte $02
$B51A  2C 00 2E  BIT $2E00 
$B51D  1E 50 00  ASL $0050,X 
$B520  A5 92     LDA $92 
$B522            .byte $0F,$3F
$B524  E0 42     CPX #$42
$B526  20 01 E5  JSR L_JSR_($E501)_($B526) BAD
$B529  70 0A     BVS L_BRS_($B535)_($B529) JAM
$B52B  59 20 03  EOR $0320,Y 
$B52E  FE 00 30  INC $3000,X 
$B531            .byte $82
$B532  C0 24     CPY #$24
$B534  48        PHA 
//------------------------------
L_BRS_($B535)_($B529) JAM
//------------------------------
$B535            .byte $02,$14,$02
$B538  05 3F     ORA $3F
$B53A  35 F0     AND $F0,X 
$B53C            .byte $7C
//------------------------------
L_BRS_($B53D)_($B506) OK
//------------------------------
$B53D  E6 1D     INC $1D 
$B53F  5E 01 78  LSR $7801,X 
$B542            .byte $64
//------------------------------
L_BRS_($B544)_($B55E) BAD
//------------------------------
$B543  E9 FF     SBC #$FF
$B545  70 C8     BVS L_BRS_($B50F)_($B545) OK
$B547  0E 70 44  ASL $4470 
$B54A  48        PHA 
$B54B            .byte $04,$00,$00
$B54E  C6 07     DEC $07 
$B550            .byte $3F
$B551  50 03     BVC L_BRS_($B556)_($B551) OK
$B553  3E 00 4F  ROL $4F00,X 
//------------------------------
L_BRS_($B556)_($B551) OK
//------------------------------
$B556  0E CD 16  ASL $16CD 
$B559  F0 06     BEQ L_BRS_($B561)_($B559) OK
$B55B  C0 7F     CPY #$7F
$B55D            .byte $00
$B55E  F0 E4     BEQ L_BRS_($B544)_($B55E) BAD
$B560            .byte $00
//------------------------------
L_BRS_($B561)_($B559) OK
//------------------------------
$B561  D0 06     BNE L_BRS_($B569)_($B561) JAM
$B563  01 00     ORA ($00,X)
//------------------------------
L_BRS_($B569)_($B561) JAM
//------------------------------
$B565            .byte $6F,$03,$5F,$00,$07
$B56A  CE 60 01  DEC $0160 
$B56D  D5 E0     CMP $E0,X 
$B56F  01 F4     ORA ($F4,X)
$B571  E0 1F     CPX #$1F
$B573  70 00     BVS L_BRS_($B575)_($B573) JAM
//------------------------------
L_BRS_($B575)_($B573) JAM
//------------------------------
$B575            .byte $00,$9C
$B577  1D 10 08  ORA $0810,X
$B57A  40        RTI 
//------------------------------
$B57B            .byte $00
$B57C  8E C8 0F  STX $0FC8 
$B57F  60        RTS 
//------------------------------
$B580            .byte $00
$B581  84 00     STY $00 
$B583            .byte $32
$B584  16 6C     ASL $6C,X 
$B586  08        PHP 
$B587  AC 03 40  LDY $4003 
$B58A  08        PHP 
//------------------------------
L_BRS_($B58B)_($B5D6) OK
//------------------------------
$B58B  20 63 01  JSR $0163
$B58E  C0 83     CPY #$83
$B590            .byte $00,$80
$B592  AE 00 76  LDX $7600 
$B595            .byte $07
$B596  98        TYA 
$B597            .byte $80
$B598  06 40     ASL $40 
$B59A            .byte $34,$00,$74
$B59D  78        SEI 
$B59E  0A        ASL A 
$B59F            .byte $00
//------------------------------
L_BRS_($B5A0)_($B5A2) OK
//------------------------------
$B5A0  A5 49     LDA $49 
$B5A2  F0 FC     BEQ L_BRS_($B5A0)_($B5A2) OK
$B5A4            .byte $07,$42,$04,$80,$A7
$B5A9  0E 50 9A  ASL $9A50 
$B5AC            .byte $04
$B5AD  C0 7F     CPY #$7F
$B5AF            .byte $00,$0C
$B5B1  41 03     EOR ($03,X) 
$B5B3  24 12     BIT $12 
$B5B5  40        RTI 
//------------------------------
$B5B6  28        PLP 
$B5B7  40        RTI 
//------------------------------
$B5B8  A0 FC     LDY #$FC
$B5BA  AC 0F 3E  LDY $3E0F 
$B5BD            .byte $67,$B8,$7A,$80
$B5C1  1E 26 97  ASL $9726,X 
$B5C4            .byte $FF
$B5C5  0E 13 70  ASL $7013 
$B5C8  0E 22 12  ASL $1222 
$B5CB  20 00 00  JSR $0000
$B5CE            .byte $63
$B5CF  E0 FC     CPX #$FC
$B5D1  0A        ASL A 
$B5D2  C0 7C     CPY #$7C
$B5D4            .byte $00,$F2
$B5D6  70 B3     BVS L_BRS_($B58B)_($B5D6) OK
$B5D8  68        PLA 
$B5D9            .byte $0F
$B5DA  60        RTS 
//------------------------------
$B5DB            .byte $03
$B5DC  FE 00 0F  INC $0F00,X 
$B5DF            .byte $27,$00,$0B
$B5E2  60        RTS 
//------------------------------
$B5E3            .byte $80,$00
$B5E5  F6 C0     INC $C0,X 
$B5E7            .byte $FA,$00
$B5E9  E0 73     CPX #$73
$B5EB  06 80     ASL $80 
$B5ED            .byte $AB,$07,$80,$2F,$07,$F8
$B5F3  0E 00 00  ASL $0000 
$B5F6  39 B8 08  AND $08B8,Y 
$B5F9  10 02     BPL L_BRS_($B5FD)_($B5F9) BAD
$B5FB            .byte $00
//------------------------------
L_BRS_($B5FD)_($B5F9) BAD
//------------------------------
$B5FC  71 13     ADC ($13),Y 
$B5FE  F0 06     BEQ L_BRS_($B606)_($B5FE) JAM
$B600            .byte $00
$B601  A1 7F     LDA ($7F,X) 
$B603  4C 6B B6  JMP L_JMP_($B66B)_($B603) BAD
//------------------------------
L_BRS_($B606)_($B5FE) JAM
//------------------------------
$B606            .byte $17
$B607  B5 DF     LDA $DF,X 
$B609            .byte $FA,$17,$F4
$B60C  C6 BF     DEC $BF 
$B60E            .byte $FB
$B60F  C1 7F     CMP ($7F,X) 
$B611  FD 75 7F  SBC $7F75,X 
$B614  6E EF D9  ROR $D9EF 
$B617  7D 6F FA  ADC $FA6F,X 
$B61A  2C FF AE  BIT $AEFF 
$B61D  DE 57 FE  DEC $FE57,X 
$B620  A5 92     LDA $92 
$B622            .byte $EF,$BF,$E7,$42,$2F
$B627  FD E5 77  SBC $77E5,X 
$B62A  EA        NOP 
$B62B  59 2F FB  EOR $FB2F,Y 
$B62E  FE 7F B0  INC $B07F,X 
$B631  BA        TSX 
$B632            .byte $CF
$B633  A4 4B     LDY $4B 
$B635            .byte $E2,$14,$FA
$B638  05 BF     ORA $BF
$B63A  B5 F7     LDA $F7,X 
$B63C            .byte $7C
$B63D  E6 DD     INC $DD 
$B63F  5E FD 7B  LSR $7BFD,X 
$B642            .byte $64
$B643  E9 FF     SBC #$FF
$B645  71 CB     ADC ($CB),Y 
$B647  EE 77 44  INC $4477 
$B64A            .byte $4B,$F4,$F7,$FF
//------------------------------
L_BRS_($B64E)_($B651) OK
//------------------------------
$B64E  C6 F7     DEC $F7 
$B650            .byte $BF
$B651  50 FB     BVC L_BRS_($B64E)_($B651) OK
$B653  BE 7F 4F  LDX $4F7F,Y 
$B656  EE CD D6  INC $D6CD 
$B659            .byte $F7
$B65A  F6 DF     INC $DF,X 
$B65C            .byte $7F,$FF,$F7
$B65F  E4 FE     CPX $FE 
$B661            .byte $D7
$B662  06 FD     ASL $FD 
$B664            .byte $7F,$6F,$FB,$5F,$7F,$F7
//------------------------------
L_JMP_($B66B)_($B603) BAD
L_JMP_($B66B)_($F27E) BAD
//------------------------------
$B66A  CE 6F FD  DEC $FD6F 
$B66D  D5 EF     CMP $EF,X 
$B66F  FD F4 EF  SBC $EFF4,X 
$B672            .byte $DF,$77
$B674  FD FE 9C  SBC $9CFE,X 
$B677  DD D7 E8  CMP $E8D7,X 
$B67A            .byte $5F,$FA
$B67C  8E CB EF  STX $EFCB 
$B67F            .byte $6F,$00
$B681  85 FE     STA $FE 
$B683            .byte $32
$B684  D6 6D     DEC $6D,X 
$B686  E8        INX 
$B687  AD FB 5F  LDA $5FFB 
$B68A  E8        INX 
$B68B            .byte $2F,$63
$B68D  FD DF 83  SBC $83DF,X 
$B690  FE BF AE  INC $AEBF,X 
$B693  FE 76 F7  INC $F776,X 
$B696            .byte $9B
$B697  BE F6 5F  LDX $5FF6,Y 
$B69A            .byte $34,$FF
$B69C  75 7B     ADC $7B,X 
$B69E  EA        NOP 
$B69F            .byte $7F
$B6A0  A5 49     LDA $49 
$B6A2            .byte $F7
$B6A3  FD E7 42  SBC $42E7,X 
$B6A6            .byte $F4,$BF,$A7
$B6A9  EE 57 9A  INC $9A57 
$B6AC            .byte $F4,$DF,$7F
$B6AF  FE 0D 5D  INC $5D0D,X 
$B6B2            .byte $F3
$B6B3  25 D2     AND $D2
$B6B5            .byte $47
$B6B6  28        PLP 
$B6B7            .byte $5F
$B6B8  A0 FD     LDY #$FD
$B6BA  AD EF 3E  LDA $3EEF 
$B6BD            .byte $67,$BB,$7A,$BF
$B6C1  DE 26 97  DEC $9726,X 
$B6C4            .byte $FF
$B6C5  0E D3 77  ASL $77D3 
$B6C8  EE 22 D2  INC $D222 
$B6CB            .byte $2F,$EF,$FF,$63,$EF
$B6D0  FD 0A DF  SBC $DF0A,X 
$B6D3  7D FE F2  ADC $F2FE,X 
$B6D6            .byte $77,$B3,$6B,$EF,$6F,$FB
$B6DC  FE FF EF  INC $EFFF,X 
$B6DF            .byte $27,$7F,$EB
$B6E2  60        RTS 
//------------------------------
$B6E3            .byte $BF
$B6E4  FE F6 DF  INC $DFF6,X 
$B6E7            .byte $FA
$B6E8  FE EF 73  INC $73EF,X 
$B6EB  F6 BF     INC $BF,X 
$B6ED            .byte $AB,$F7,$BF,$2F,$F7,$FB
$B6F3  EE BF 7F  INC $7FBF 
$B6F6  39 BB EB  AND $EBBB,Y 
$B6F9            .byte $17,$FA,$5F
$B6FC  71 D3     ADC ($D3),Y 
$B6FE            .byte $F7
$B6FF  F6 00     INC $00,X 
$B701  3D 80 65  AND $6580,X 
$B704  48        PHA 
$B705  35 E0     AND $E0,X 
$B707  48        PHA 
$B708  40        RTI 
//------------------------------
$B709            .byte $03
$B70A  D8        CLD 
$B70B  06 54     ASL $54 
$B70D            .byte $80,$03
$B70F  5E 00 02  LSR $0200,X 
$B712  1E 00 44  ASL $4400,X 
$B715  20 11 02  JSR $0211
$B718  20 02 25  JSR L_JSR_($2502)_($B718) BAD
$B71B            .byte $00
$B71C  36 08     ROL $08,X 
$B71E  20 00 A3  JSR L_JSR_($A300)_($B71E) BAD
$B721            .byte $7A,$0F,$3F
$B724  E0 7F     CPX #$7F
$B726  E0 00     CPX #$00
$B728            .byte $82
$B729  F0 0A     BEQ L_BRS_($B735)_($B729) JAM
$B72B            .byte $37
$B72C  A0 03     LDY #$03
$B72E  FE 00 0F  INC $0F00,X 
$B731            .byte $87,$80,$7F
$B734  68        PLA 
//------------------------------
L_BRS_($B735)_($B729) JAM
//------------------------------
$B735            .byte $07,$F7
$B737  01 23     ORA ($23,X)
$B739            .byte $3F
$B73A  21 F8     AND ($F8,X) 
$B73C            .byte $5C
$B73D  E6 1D     INC $1D 
$B73F  5E 03 78  LSR $7803,X 
$B742  45 DE     EOR $DE 
//------------------------------
L_BRS_($B744)_($B75E) JAM
//------------------------------
$B744            .byte $FF,$7F
$B746  E8        INX 
$B747  0E F0 4E  ASL $4EF0 
$B74A  C8        INY 
//------------------------------
L_BRS_($B74B)_($B761) JAM
//------------------------------
$B74B            .byte $04
$B74C  08        PHP 
$B74D            .byte $00
$B74E  CC 07 7F  CPY $7F07 
$B751            .byte $5A,$07
$B753  7E 00 4F  ROR $4F00,X 
$B756  0E EF 1E  ASL $1EEF 
$B759  E0 07     CPX #$07
$B75B  C0 FF     CPY #$FF
$B75D            .byte $00
$B75E  F0 E4     BEQ L_BRS_($B744)_($B75E) JAM
$B760            .byte $00
$B761  F0 E8     BEQ L_BRS_($B74B)_($B761) JAM
$B763  01 00     ORA ($00,X)
$B765  7E 02 1F  ROR $1F02,X 
$B768            .byte $80
$B769  05 CE     ORA $CE
$B76B  60        RTS 
//------------------------------
$B76C  01 D5     ORA ($D5,X)
$B76E  E0 03     CPX #$03
$B770  F5 C0     SBC $C0,X 
$B772            .byte $3F
$B773  70 02     BVS L_BRS_($B777)_($B773) OK
$B775            .byte $00,$5C
//------------------------------
L_BRS_($B777)_($B773) OK
//------------------------------
$B777  1D 08 10  ORA $1008,X
$B77A  E0 00     CPX #$00
$B77C  7E E8 0F  ROR $0FE8,X 
$B77F  70 00     BVS L_BRS_($B781)_($B77F) OK
//------------------------------
L_BRS_($B781)_($B77F) OK
//------------------------------
$B781  BC 01 A6  LDY $A601,X 
$B784            .byte $12
$B785  AC 07 12  LDY $1207 
$B788            .byte $02
$B789  C0 1B     CPY #$1B
$B78B  60        RTS 
//------------------------------
$B78C  2A        ROL A 
$B78D  01 C0     ORA ($C0,X)
$B78F            .byte $7A,$00
$B791  40        RTI 
//------------------------------
$B792  78        SEI 
//------------------------------
L_BRS_($B793)_($B7B0) JAM
//------------------------------
$B793            .byte $00,$22,$04
$B796  88        DEY 
$B797  40        RTI 
//------------------------------
L_BRS_($B798)_($B7AA) JAM
//------------------------------
$B798            .byte $04
$B799  40        RTI 
//------------------------------
$B79A  A4 00     LDY $00 
$B79C  6C 10 04  JMP ($0410) 
$B79F            .byte $00
//------------------------------
L_BRS_($B7A0)_($B7A2) OK
//------------------------------
$B7A0  C5 5E     CMP $5E 
$B7A2  F0 FC     BEQ L_BRS_($B7A0)_($B7A2) OK
$B7A4            .byte $07
$B7A5  FE 07 00  INC $0007,X 
$B7A8  41 0F     EOR ($0F,X) 
$B7AA  50 EC     BVC L_BRS_($B798)_($B7AA) JAM
$B7AC  05 C0     ORA $C0
$B7AE            .byte $7F,$00
$B7B0  F0 E1     BEQ L_BRS_($B793)_($B7B0) JAM
$B7B2  01 FE     ORA ($FE,X)
$B7B4  16 E0     ASL $E0,X 
$B7B6            .byte $EF,$80
$B7B8  C4 FC     CPY $FC 
$B7BA  84 1F     STY $1F 
$B7BC            .byte $3A,$67,$B8,$7A
$B7C0  C0 1E     CPY #$1E
$B7C2  A2 7B     LDX #$7B
$B7C4            .byte $FF
$B7C5  FE 17 70  INC $7017,X 
$B7C8            .byte $0F,$72,$13
$B7CB  20 10 00  JSR $0010
$B7CE            .byte $33
//------------------------------
L_BRS_($B7CF)_($B7D6) OK
//------------------------------
$B7CF  E0 FE     CPX #$FE
$B7D1            .byte $5A
$B7D2  E0 7E     CPX #$7E
$B7D4            .byte $00,$F2
$B7D6  70 F7     BVS L_BRS_($B7CF)_($B7D6) OK
$B7D8  78        SEI 
$B7D9            .byte $07
$B7DA  E0 03     CPX #$03
$B7DC            .byte $FF,$00,$0F,$27,$00,$0F,$17,$80
$B7E4            .byte $00
$B7E5  7E 40 F8  ROR $F840,X 
$B7E8  01 A0     ORA ($A0,X)
$B7EA            .byte $73
$B7EB  06 80     ASL $80 
$B7ED            .byte $AB,$07
$B7EF  C0 AF     CPY #$AF
$B7F1            .byte $03,$FC
$B7F3  0E 40 00  ASL $0040 
$B7F6            .byte $3A,$B8
$B7F8  10 08     BPL L_BRS_($B802)_($B7F8) JAM
$B7FA            .byte $07,$00
$B7FC  7E 17 F0  ROR $F017,X                          // Send to RS232 Buffer
$B7FF  0E 00 BD  ASL $BD00 
//------------------------------
L_BRS_($B802)_($B7F8) JAM
//------------------------------
$B802            .byte $BF
$B803  65 4B     ADC $4B 
$B805  B5 EF     LDA $EF,X 
$B807  48        PHA 
$B808            .byte $5F,$FB,$DB
$B80B  F6 54     INC $54,X 
$B80D            .byte $BF,$FB
$B80F  5E FF FA  LSR $FAFF,X 
$B812  1E FF 44  ASL $44FF,X 
$B815            .byte $2F
$B816  D1 7A     CMP ($7A),Y 
$B818            .byte $2F,$FA
$B81A  25 FF     AND $FF
$B81C  B6 C8     LDX $C8,Y 
$B81E            .byte $23
$B81F  FE A3 7A  INC $7AA3,X 
$B822            .byte $EF,$BF,$EF,$7F,$EF,$FC,$82,$F7
$B82A  EA        NOP 
$B82B            .byte $37,$AF,$FB
$B82E  FE FF 8F  INC $8FFF,X 
$B831            .byte $B7,$BF,$7F,$6B,$F7,$F7
$B837  FD 23 BF  SBC $BF23,X 
$B83A  A1 FB     LDA ($FB,X) 
$B83C            .byte $5C
$B83D  E6 DD     INC $DD 
$B83F  5E FB 7B  LSR $7BFB,X 
$B842  45 DE     EOR $DE 
$B844            .byte $FF,$7F,$EB
$B847  EE F7 4E  INC $4EF7 
$B84A            .byte $CB,$F4,$CB,$FF
$B84E  CD F7 7F  CMP $7FF7 
$B851            .byte $5A,$F7
$B853  7E 7F 4F  ROR $4F7F,X 
$B856  EE EF DE  INC $DEEF 
$B859            .byte $E3,$F7,$DF,$FF
$B85D  FE F7 E4  INC $E4F7,X 
$B860  FE F7 E8  INC $E8F7,X 
$B863  FD 3F 7E  SBC $7E3F,X 
$B866            .byte $FA,$1F,$BF
$B869  F5 CE     SBC $CE,X 
$B86B            .byte $6F
$B86C  FD D5 EF  SBC $EFD5,X 
$B86F            .byte $FB
$B870  F5 DF     SBC $DF,X 
$B872            .byte $BF,$77,$F2,$FF,$5C
$B877  DD E8 D0  CMP $D0E8,X 
$B87A            .byte $EF,$FF
$B87C  7E EB EF  ROR $EFEB,X 
$B87F            .byte $77,$00
$B881  BD FD A6  LDA $A6FD,X 
$B884            .byte $D2
$B885  AD F7 12  LDA $12F7 
$B888            .byte $FA,$DF,$DB,$6F
$B88C  2A        ROL A 
$B88D  FD DF 7A  SBC $7ADF,X 
$B890            .byte $FF,$5F
$B892  78        SEI 
$B893            .byte $FF,$22,$F4,$8B
$B897  5E F4 5F  LSR $5FF4,X 
$B89A  A4 FF     LDY $FF 
$B89C  6D 13 C4  ADC $C413 
$B89F            .byte $7F
$B8A0  C5 5E     CMP $5E 
$B8A2            .byte $F7
$B8A3  FD F7 FE  SBC $FEF7,X 
$B8A6            .byte $F7,$3F
$B8A8  41 EF     EOR ($EF,X) 
$B8AA            .byte $57
$B8AB  EC F5 DF  CPX $DFF5 
$B8AE            .byte $7F,$FF
$B8B0  F1 ED     SBC ($ED),Y 
$B8B2  FD FD D6  SBC $D6FD,X 
$B8B5            .byte $EF,$EF,$BF
$B8B8  C4 FD     CPY $FD 
$B8BA  85 DF     STA $DF 
//------------------------------
L_JSR_($B8BF)_($ABF5) JAM
L_JSR_($B8BF)_($E86E) JAM
//------------------------------
$B8BC            .byte $3A,$67,$BB,$7A,$DF
$B8C1  DE A2 7B  DEC $7BA2,X 
$B8C4            .byte $FF
$B8C5  FE D7 77  INC $77D7,X 
$B8C8            .byte $EF,$72,$D3,$2F,$D3,$FF,$B3,$EF
$B8D0  FE 5A EF  INC $EF5A,X 
$B8D3  7E FE F2  ROR $F2FE,X 
$B8D6            .byte $77,$F7,$7B,$C7,$EF,$FB,$FF,$7F
$B8DE            .byte $EF,$27,$7F,$EF,$17,$BF,$FC
$B8E5  7E 5F F8  ROR $F85F,X 
$B8E8  FD AF 73  SBC $73AF,X 
$B8EB  F6 BF     INC $BF,X 
$B8ED            .byte $AB,$F7,$DF,$AF,$FB
$B8F2  FD EE 4F  SBC $4FEE,X 
$B8F5            .byte $FF,$3A,$BB,$17,$0B,$F7,$FF
$B8FC  7E D7 F7  ROR $F7D7,X                          // Set Buffer Stat / End Pointers
$B8FF  EE EA FF  INC $FFEA                          // Increment Real-Time Clock
$B902            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$B90A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$B912            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$B91A            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$B922            .byte $FF,$FF,$FF
$B925  AA        TAX 
$B926            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$B92E            .byte $FF,$FF
$B930  AA        TAX 
$B931            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$B939  FE FF FF  INC $FFFF,X 
$B93C            .byte $FF,$FF,$FF,$FF
//------------------------------
L_JSR_($B940)_($BA2C) OK
L_JSR_($B940)_($F677) OK
//------------------------------
$B940  A9 16     LDA #$16
$B942  8D 05 D4  STA $D405                          // Voice 1: Attack / Decay Cycle Control
$B945  A9 1C     LDA #$1C
$B947  8D 0C D4  STA $D40C                          // Voice 2: Attack / Decay Cycle Control
$B94A  A9 1C     LDA #$1C
$B94C  8D 13 D4  STA $D413                          // Voice 3: Attack / Decay Cycle Control
$B94F  A9 00     LDA #$00
$B951  8D 06 D4  STA $D406                          // Voice 1: Sustain / Release Cycle Control
$B954  A9 00     LDA #$00
$B956  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control
$B959  A9 00     LDA #$00
$B95B  8D 14 D4  STA $D414                          // Voice 3: Sustain / Release Cycle Control
$B95E  A9 20     LDA #$20
$B960  8D CB BB  STA $BBCB 
$B963  A9 20     LDA #$20
$B965  8D CC BB  STA $BBCC 
$B968  A9 20     LDA #$20
$B96A  8D CD BB  STA $BBCD 
$B96D  A9 80     LDA #$80
$B96F  8D 02 D4  STA $D402                          // Voice 1: Pulse Waveform Width - Low-Byte
$B972  A9 80     LDA #$80
$B974  8D 03 D4  STA $D403                          // Voice 1: Pulse Waveform Width - High-Nybble
$B977  A9 80     LDA #$80
$B979  8D 09 D4  STA $D409                          // Voice 2: Pulse Waveform Width - Low-Byte
$B97C  A9 80     LDA #$80
$B97E  8D 0A D4  STA $D40A                          // Voice 2: Pulse Waveform Width - High-Nybble
$B981  A9 80     LDA #$80
$B983  8D 10 D4  STA $D410                          // Voice 3: Pulse Waveform Width - Low-Byte
$B986  A9 80     LDA #$80
$B988  8D 11 D4  STA $D411                          // Voice 3: Pulse Waveform Width - High-Nybble
$B98B  A9 00     LDA #$00
$B98D  8D 16 D4  STA $D416                          // Filter Cutoff Frequency: High-Byte
$B990  A9 00     LDA #$00
$B992  8D 15 D4  STA $D415                          // Filter Cutoff Frequency: Low-Nybble
$B995  A9 00     LDA #$00
$B997  8D 17 D4  STA $D417                          // Filter Resonance Control / Voice Input Control
$B99A  A9 0F     LDA #$0F
$B99C  8D 18 D4  STA $D418                          // Select Filter Mode and Volume
$B99F  60        RTS 
//------------------------------
L_JSR_($B9A0)_($BA74) OK
L_JSR_($B9A0)_($F6BF) OK
//------------------------------
$B9A0  A9 46     LDA #$46
$B9A2  8D 05 D4  STA $D405                          // Voice 1: Attack / Decay Cycle Control
$B9A5  A9 2C     LDA #$2C
$B9A7  8D 0C D4  STA $D40C                          // Voice 2: Attack / Decay Cycle Control
$B9AA  A9 2C     LDA #$2C
$B9AC  8D 13 D4  STA $D413                          // Voice 3: Attack / Decay Cycle Control
$B9AF  A9 00     LDA #$00
$B9B1  8D 06 D4  STA $D406                          // Voice 1: Sustain / Release Cycle Control
$B9B4  A9 00     LDA #$00
$B9B6  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control
$B9B9  A9 00     LDA #$00
$B9BB  8D 14 D4  STA $D414                          // Voice 3: Sustain / Release Cycle Control
$B9BE  A9 20     LDA #$20
$B9C0  8D CB BB  STA $BBCB 
$B9C3  A9 10     LDA #$10
$B9C5  8D CC BB  STA $BBCC 
$B9C8  A9 10     LDA #$10
$B9CA  8D CD BB  STA $BBCD 
$B9CD  A9 80     LDA #$80
$B9CF  8D 02 D4  STA $D402                          // Voice 1: Pulse Waveform Width - Low-Byte
$B9D2  A9 80     LDA #$80
$B9D4  8D 03 D4  STA $D403                          // Voice 1: Pulse Waveform Width - High-Nybble
$B9D7  A9 00     LDA #$00
$B9D9  8D 09 D4  STA $D409                          // Voice 2: Pulse Waveform Width - Low-Byte
$B9DC  A9 00     LDA #$00
$B9DE  8D 0A D4  STA $D40A                          // Voice 2: Pulse Waveform Width - High-Nybble
$B9E1  A9 00     LDA #$00
$B9E3  8D 10 D4  STA $D410                          // Voice 3: Pulse Waveform Width - Low-Byte
$B9E6  A9 00     LDA #$00
$B9E8  8D 11 D4  STA $D411                          // Voice 3: Pulse Waveform Width - High-Nybble
$B9EB  A9 00     LDA #$00
$B9ED  8D 16 D4  STA $D416                          // Filter Cutoff Frequency: High-Byte
$B9F0  A9 00     LDA #$00
$B9F2  8D 15 D4  STA $D415                          // Filter Cutoff Frequency: Low-Nybble
$B9F5  A9 00     LDA #$00
$B9F7  8D 17 D4  STA $D417                          // Filter Resonance Control / Voice Input Control
$B9FA  A9 0F     LDA #$0F
$B9FC  8D 18 D4  STA $D418                          // Select Filter Mode and Volume
$B9FF  60        RTS 
//------------------------------
L_JSR_($BA00)_($080D) OK
L_JSR_($BA00)_($2C9C) OK
//------------------------------
$BA00  78        SEI 
$BA01  A9 BA     LDA #$BA
$BA03  8D FF FF  STA $FFFF 
$BA06  A9 B4     LDA #$B4
$BA08  8D FE FF  STA $FFFE                          // Vector: IRQ
$BA0B  20 90 BA  JSR L_JSR_($BA90)_($BA0B) OK
$BA0E  A9 00     LDA #$00
$BA10  8D C3 BB  STA $BBC3 
$BA13  A9 BC     LDA #$BC
$BA15  8D C6 BB  STA $BBC6 
$BA18  A9 41     LDA #$41
$BA1A  8D C4 BB  STA $BBC4 
$BA1D  A9 BC     LDA #$BC
$BA1F  8D C7 BB  STA $BBC7                          // Store FAC#1 in Memory
$BA22  A9 5A     LDA #$5A
$BA24  8D C5 BB  STA $BBC5 
$BA27  A9 BC     LDA #$BC
$BA29  8D C8 BB  STA $BBC8 
$BA2C  20 40 B9  JSR L_JSR_($B940)_($BA2C) OK
$BA2F  58        CLI 
//------------------------------
L_JMP_($BA30)_($BA35) OK
L_JMP_($BA30)_($F680) OK
//------------------------------
$BA30  AD CE BB  LDA $BBCE 
$BA33  D0 03     BNE L_BRS_($BA38)_($BA33) OK
$BA35  4C 30 BA  JMP L_JMP_($BA30)_($BA35) OK
//------------------------------
L_BRS_($BA38)_($BA33) OK
//------------------------------
$BA38  78        SEI 
$BA39  A9 39     LDA #$39
$BA3B  8D FF FF  STA $FFFF 
$BA3E  A9 C7     LDA #$C7
$BA40  8D FE FF  STA $FFFE                          // Vector: IRQ
$BA43  58        CLI 
$BA44  20 2A 30  JSR L_JSR_($302A)_($BA44) OK
$BA47  60        RTS 
//------------------------------
L_JSR_($BA48)_($2C51) OK
//------------------------------
$BA48  78        SEI 
$BA49  A9 BA     LDA #$BA
$BA4B  8D FF FF  STA $FFFF 
$BA4E  A9 B4     LDA #$B4
$BA50  8D FE FF  STA $FFFE                          // Vector: IRQ
$BA53  20 90 BA  JSR L_JSR_($BA90)_($BA53) OK
$BA56  A9 73     LDA #$73
$BA58  8D C3 BB  STA $BBC3 
$BA5B  A9 BC     LDA #$BC
$BA5D  8D C6 BB  STA $BBC6 
$BA60  A9 A0     LDA #$A0
$BA62  8D C4 BB  STA $BBC4 
$BA65  A9 BC     LDA #$BC
$BA67  8D C7 BB  STA $BBC7                          // Store FAC#1 in Memory
$BA6A  A9 C7     LDA #$C7
$BA6C  8D C5 BB  STA $BBC5 
$BA6F  A9 BC     LDA #$BC
$BA71  8D C8 BB  STA $BBC8 
$BA74  20 A0 B9  JSR L_JSR_($B9A0)_($BA74) OK
$BA77  58        CLI 
//------------------------------
L_JMP_($BA78)_($BA7D) OK
L_JMP_($BA78)_($F6C8) OK
//------------------------------
$BA78  AD CE BB  LDA $BBCE 
$BA7B  D0 03     BNE L_BRS_($BA80)_($BA7B) OK
$BA7D  4C 78 BA  JMP L_JMP_($BA78)_($BA7D) OK
//------------------------------
L_BRS_($BA80)_($BA7B) OK
//------------------------------
$BA80  78        SEI 
$BA81  A9 39     LDA #$39
$BA83  8D FF FF  STA $FFFF 
$BA86  A9 C7     LDA #$C7
$BA88  8D FE FF  STA $FFFE                          // Vector: IRQ
$BA8B  58        CLI 
$BA8C  20 2A 30  JSR L_JSR_($302A)_($BA8C) OK
$BA8F  60        RTS 
//------------------------------
L_JSR_($BA90)_($BA0B) OK
L_JSR_($BA90)_($BA53) OK
L_JSR_($BA90)_($F656) OK
L_JSR_($BA90)_($F69E) OK
//------------------------------
$BA90  A9 B4     LDA #$B4
$BA92  85 4E     STA $4E 
$BA94  A9 BB     LDA #$BB
$BA96  85 4F     STA $4F 
$BA98  A0 00     LDY #$00
$BA9A  98        TYA 
//------------------------------
L_BRS_($BA9B)_($BAA0) OK
//------------------------------
$BA9B  91 4E     STA ($4E),Y 
$BA9D  C8        INY 
$BA9E  C0 20     CPY #$20
$BAA0  D0 F9     BNE L_BRS_($BA9B)_($BAA0) OK
$BAA2  60        RTS 
//------------------------------
L_JSR_($BAA3)_($BB01) OK
L_JSR_($BAA3)_($BB0A) OK
L_JSR_($BAA3)_($F74C) OK
L_JSR_($BAA3)_($F755) OK
//------------------------------
$BAA3  BC C0 BB  LDY $BBC0,X 
$BAA6  B1 4E     LDA ($4E),Y 
$BAA8  C8        INY 
$BAA9  D0 02     BNE L_BRS_($BAAD)_($BAA9) OK
$BAAB  E6 4F     INC $4F 
//------------------------------
L_BRS_($BAAD)_($BAA9) OK
//------------------------------
$BAAD  48        PHA 
$BAAE  98        TYA 
$BAAF  9D C0 BB  STA $BBC0,X 
$BAB2  68        PLA 
$BAB3  60        RTS 
//------------------------------
$BAB4  48        PHA 
$BAB5  8A        TXA 
$BAB6  48        PHA 
$BAB7  98        TYA 
$BAB8  48        PHA 
$BAB9  EE CA BB  INC $BBCA 
$BABC  AD CA BB  LDA $BBCA 
$BABF  C9 04     CMP #$04
$BAC1  F0 03     BEQ L_BRS_($BAC6)_($BAC1) OK
$BAC3  4C B1 BB  JMP L_JMP_($BBB1)_($BAC3) OK
//------------------------------
L_BRS_($BAC6)_($BAC1) OK
//------------------------------
$BAC6  A2 00     LDX #$00
$BAC8  8E CA BB  STX $BBCA 
$BACB  86 4E     STX $4E 
//------------------------------
L_JMP_($BACD)_($BB75) OK
L_JMP_($BACD)_($F7BF) OK
//------------------------------
$BACD  8E BF BB  STX $BBBF 
$BAD0  BD C6 BB  LDA $BBC6,X 
$BAD3  85 4F     STA $4F 
$BAD5  BD C3 BB  LDA $BBC3,X 
$BAD8  85 4E     STA $4E 
$BADA  BD B6 BB  LDA $BBB6,X 
$BADD  F0 06     BEQ L_BRS_($BAE5)_($BADD) OK
$BADF  DE B6 BB  DEC $BBB6,X 
$BAE2  4C 6B BB  JMP L_JMP_($BB6B)_($BAE2) OK
//------------------------------
L_BRS_($BAE5)_($BADD) OK
//------------------------------
$BAE5  BD CB BB  LDA $BBCB,X 
$BAE8  29 FE     AND #$FE
$BAEA  E0 02     CPX #$02
$BAEC  F0 10     BEQ L_BRS_($BAFE)_($BAEC) OK
$BAEE  E0 01     CPX #$01
$BAF0  F0 06     BEQ L_BRS_($BAF8)_($BAF0) OK
$BAF2  8D 04 D4  STA $D404                          // Voice 1: Control Register
$BAF5  4C 01 BB  JMP L_JMP_($BB01)_($BAF5) OK
//------------------------------
L_BRS_($BAF8)_($BAF0) OK
//------------------------------
$BAF8  8D 0B D4  STA $D40B                          // Voice 2: Control Register
$BAFB  4C 01 BB  JMP L_JMP_($BB01)_($BAFB) OK
//------------------------------
L_BRS_($BAFE)_($BAEC) OK
//------------------------------
$BAFE  8D 12 D4  STA $D412                          // Voice 3: Control Register
//------------------------------
L_JMP_($BB01)_($BAF5) OK
L_JMP_($BB01)_($BAFB) OK
L_JMP_($BB01)_($F740) OK
L_JMP_($BB01)_($F746) OK
//------------------------------
$BB01  20 A3 BA  JSR L_JSR_($BAA3)_($BB01) OK
$BB04  8D B4 BB  STA $BBB4 
$BB07  0A        ASL A 
$BB08  B0 56     BCS L_BRS_($BB60)_($BB08) OK
$BB0A  20 A3 BA  JSR L_JSR_($BAA3)_($BB0A) OK
$BB0D  9D B6 BB  STA $BBB6,X 
$BB10  DE B6 BB  DEC $BBB6,X 
$BB13  AD B4 BB  LDA $BBB4 
$BB16  F0 3D     BEQ L_BRS_($BB55)_($BB16) OK
$BB18  29 F0     AND #$F0
$BB1A  4A        LSR A 
$BB1B  4A        LSR A 
$BB1C  4A        LSR A 
$BB1D  4A        LSR A 
$BB1E  8D B5 BB  STA $BBB5 
$BB21  A9 07     LDA #$07
$BB23  38        SEC 
$BB24  ED B5 BB  SBC $BBB5 
$BB27  8D B5 BB  STA $BBB5 
$BB2A  AD B4 BB  LDA $BBB4 
$BB2D  29 0F     AND #$0F
$BB2F  A8        TAY 
$BB30  B9 D4 BB  LDA $BBD4,Y 
$BB33  9D B9 BB  STA $BBB9,X 
$BB36  B9 E0 BB  LDA $BBE0,Y 
$BB39  9D BC BB  STA $BBBC,X 
$BB3C  AC B5 BB  LDY $BBB5 
$BB3F  F0 09     BEQ L_BRS_($BB4A)_($BB3F) OK
//------------------------------
L_BRS_($BB41)_($BB48) OK
//------------------------------
$BB41  5E BC BB  LSR $BBBC,X 
$BB44  7E B9 BB  ROR $BBB9,X 
$BB47  88        DEY 
$BB48  D0 F7     BNE L_BRS_($BB41)_($BB48) OK
//------------------------------
L_BRS_($BB4A)_($BB3F) OK
//------------------------------
$BB4A  BD CB BB  LDA $BBCB,X 
$BB4D  09 01     ORA #$01
$BB4F  9D CB BB  STA $BBCB,X 
$BB52  4C 6B BB  JMP L_JMP_($BB6B)_($BB52) OK
//------------------------------
L_BRS_($BB55)_($BB16) OK
//------------------------------
$BB55  BD CB BB  LDA $BBCB,X 
$BB58  29 FE     AND #$FE
$BB5A  9D CB BB  STA $BBCB,X 
$BB5D  4C 6B BB  JMP L_JMP_($BB6B)_($BB5D) OK
//------------------------------
L_BRS_($BB60)_($BB08) OK
//------------------------------
$BB60  A9 FF     LDA #$FF
$BB62  8D CE BB  STA $BBCE 
$BB65  4C B1 BB  JMP L_JMP_($BBB1)_($BB65) OK
$BB68  AE BF BB  LDX $BBBF 
//------------------------------
L_JMP_($BB6B)_($BAE2) OK
L_JMP_($BB6B)_($BB52) OK
L_JMP_($BB6B)_($BB5D) OK
L_JMP_($BB6B)_($F72D) OK
L_JMP_($BB6B)_($F79C) OK
L_JMP_($BB6B)_($F7A7) OK
//------------------------------
$BB6B  A5 4F     LDA $4F 
$BB6D  9D C6 BB  STA $BBC6,X 
$BB70  E8        INX 
$BB71  E0 03     CPX #$03
$BB73  F0 03     BEQ L_BRS_($BB78)_($BB73) OK
$BB75  4C CD BA  JMP L_JMP_($BACD)_($BB75) OK
//------------------------------
L_BRS_($BB78)_($BB73) OK
//------------------------------
$BB78  CA        DEX 
$BB79  BD B9 BB  LDA $BBB9,X 
$BB7C  8D 0E D4  STA $D40E                          // Voice 3: Frequency Control - Low-Byte
$BB7F  BD BC BB  LDA $BBBC,X 
$BB82  8D 0F D4  STA $D40F                          // Voice 3: Frequency Control - High-Byte
$BB85  BD CB BB  LDA $BBCB,X 
$BB88  8D 12 D4  STA $D412                          // Voice 3: Control Register
$BB8B  CA        DEX 
$BB8C  BD B9 BB  LDA $BBB9,X 
$BB8F  8D 07 D4  STA $D407                          // Voice 2: Frequency Control - Low-Byte
$BB92  BD BC BB  LDA $BBBC,X 
$BB95  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte
$BB98  BD CB BB  LDA $BBCB,X 
$BB9B  8D 0B D4  STA $D40B                          // Voice 2: Control Register
$BB9E  CA        DEX 
$BB9F  BD B9 BB  LDA $BBB9,X 
$BBA2  8D 00 D4  STA $D400                          // Voice 1: Frequency Control - Low-Byte
$BBA5  BD BC BB  LDA $BBBC,X 
$BBA8  8D 01 D4  STA $D401                          // Voice 1: Frequency Control - High-Byte
$BBAB  BD CB BB  LDA $BBCB,X 
$BBAE  8D 04 D4  STA $D404                          // Voice 1: Control Register
//------------------------------
L_JMP_($BBB1)_($BAC3) OK
L_JMP_($BBB1)_($BB65) OK
L_JMP_($BBB1)_($F70E) OK
L_JMP_($BBB1)_($F7AF) OK
//------------------------------
$BBB1  4C CC 39  JMP L_JMP_($39CC)_($BBB1) OK
$BBB4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BBBC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BBC4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BBCC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BBD4  1E 18 8B  ASL $8B18,X 
$BBD7  7E FA 06  ROR $06FA,X 
$BBDA  AC F3 E6  LDY $E6F3 
$BBDD            .byte $8F,$F8
$BBDF  2E 86 8E  ROL $8E86 
$BBE2  96 9F     STX $9F,Y 
$BBE4  A8        TAY 
$BBE5            .byte $B3
$BBE6  BD C8 D4  LDA $D4C8,X 
$BBE9  E1 EE     SBC ($EE,X) 
$BBEB  FD 00 00  SBC $0000,X 
$BBEE            .byte $00,$00,$AF,$00,$00,$00,$00,$00
$BBF6            .byte $77,$00,$00,$00,$00
$BBFB  A0 77     LDY #$77
$BBFD            .byte $FF,$FF,$7F,$57,$04,$54,$02
$BC04  55 04     EOR $04,X 
$BC06            .byte $52,$02,$57,$04,$54,$02
$BC0C  50 04     BVC L_BRS_($BC12)_($BC0C) JAM
$BC0E  50 02     BVC L_BRS_($BC12)_($BC0E) JAM
//------------------------------
L_BRS_($BC12)_($BC0C) JAM
L_BRS_($BC12)_($BC0E) JAM
//------------------------------
$BC10            .byte $52,$04,$54,$02
$BC14  55 02     EOR $02,X 
$BC16            .byte $54,$02,$52,$02,$57,$04,$54,$02
$BC1E  50 06     BVC L_BRS_($BC26)_($BC1E) JAM
$BC20            .byte $57,$04,$54,$02
$BC24  55 04     EOR $04,X 
//------------------------------
L_BRS_($BC26)_($BC1E) JAM
//------------------------------
$BC26            .byte $52,$02,$57,$04,$54,$02
$BC2C  50 04     BVC L_BRS_($BC32)_($BC2C) JAM
$BC2E  50 02     BVC L_BRS_($BC32)_($BC2E) JAM
//------------------------------
L_BRS_($BC32)_($BC2C) JAM
L_BRS_($BC32)_($BC2E) JAM
//------------------------------
$BC30            .byte $52,$04,$54,$02
$BC34  55 02     EOR $02,X 
$BC36            .byte $54,$02,$52,$02,$57,$04,$54,$02
$BC3E  50 12     BVC L_BRS_($BC52)_($BC3E) JAM
$BC40            .byte $FF,$37
$BC42  06 35     ASL $35 
$BC44  06 37     ASL $37 
$BC46            .byte $0C,$34
$BC48  06 35     ASL $35 
$BC4A  06 37     ASL $37 
$BC4C            .byte $0C,$37
$BC4E  06 35     ASL $35 
$BC50  06 37     ASL $37 
//------------------------------
L_BRS_($BC52)_($BC3E) JAM
//------------------------------
$BC52            .byte $0C,$3A
$BC54  06 39     ASL $39 
$BC56  06 37     ASL $37 
$BC58  18        CLC 
$BC59            .byte $FF
$BC5A  30 06     BMI L_BRS_($BC62)_($BC5A) OK
$BC5C  2A        ROL A 
$BC5D  06 30     ASL $30 
$BC5F            .byte $0C
$BC60  29 06     AND #$06
//------------------------------
L_BRS_($BC62)_($BC5A) OK
//------------------------------
$BC62  2A        ROL A 
$BC63  06 30     ASL $30 
$BC65            .byte $0C
$BC66  30 06     BMI L_BRS_($BC6E)_($BC66) BAD
$BC68  2A        ROL A 
$BC69  06 30     ASL $30 
$BC6B            .byte $0C,$33
//------------------------------
L_BRS_($BC6E)_($BC66) BAD
//------------------------------
$BC6D  06 32     ASL $32 
$BC6F  06 30     ASL $30 
$BC71  18        CLC 
$BC72            .byte $FF,$57,$02,$57,$02,$57,$02
$BC79  59 02 5B  EOR $5B02,Y 
$BC7C            .byte $04
$BC7D  59 04 57  EOR $5704,Y 
$BC80            .byte $02,$5B,$02
$BC83  59 02 59  EOR $5902,Y 
$BC86            .byte $02,$57
$BC88  08        PHP 
$BC89            .byte $57,$02,$57,$02,$57,$02
$BC8F  59 02 5B  EOR $5B02,Y 
$BC92            .byte $04
$BC93  59 04 57  EOR $5704,Y 
$BC96            .byte $02,$5B,$02
$BC99  59 02 59  EOR $5902,Y 
$BC9C            .byte $02,$57
$BC9E  08        PHP 
$BC9F            .byte $FF,$42,$04,$44,$04
$BCA4  46 04     LSR $04 
$BCA6            .byte $44,$04,$42,$04,$44,$04
$BCAC  46 04     LSR $04 
$BCAE            .byte $44,$04,$44,$04,$43,$04,$42,$02
$BCB6  45 02     EOR $02 
$BCB8            .byte $44,$02,$43,$02,$42,$02,$44,$02
$BCC0            .byte $44,$02
$BCC2  46 02     LSR $02 
$BCC4            .byte $47
$BCC5  08        PHP 
$BCC6            .byte $FF,$37
$BCC8  10 37     BPL L_BRS_($BD01)_($BCC8) BAD
$BCCA  10 41     BPL L_BRS_($BD0D)_($BCCA) OK
$BCCC            .byte $04
$BCCD  40        RTI 
//------------------------------
$BCCE            .byte $04,$3B,$04
$BCD1  40        RTI 
//------------------------------
$BCD2            .byte $04,$3B,$02
$BCD5  40        RTI 
//------------------------------
$BCD6            .byte $02
$BCD7  41 02     EOR ($02,X) 
$BCD9            .byte $42,$02,$37
$BCDC  08        PHP 
$BCDD            .byte $FF,$00,$00
$BCE0  AA        TAX 
$BCE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BCE9            .byte $00,$00,$FF,$00,$00,$00,$00
$BCF0  AE 00 00  LDX $0000 
$BCF3            .byte $00,$00,$00,$77,$00,$00,$00,$00
$BCFB  A0 77     LDY #$77
$BCFD            .byte $FF,$FF,$FF
//------------------------------
L_JSR_($BD00)_($0825) OK
L_BRS_($BD01)_($BCC8) BAD
//------------------------------
$BD00  A5 2C     LDA $2C 
$BD02  C9 01     CMP #$01
$BD04  D0 03     BNE L_BRS_($BD09)_($BD04) OK
$BD06  4C 1A BD  JMP L_JMP_($BD1A)_($BD06) OK
//------------------------------
L_BRS_($BD09)_($BD04) OK
//------------------------------
$BD09  C9 02     CMP #$02
$BD0B  D0 03     BNE L_BRS_($BD10)_($BD0B) OK
//------------------------------
L_BRS_($BD0D)_($BCCA) OK
//------------------------------
$BD0D  4C 66 BD  JMP L_JMP_($BD66)_($BD0D) OK
//------------------------------
L_BRS_($BD10)_($BD0B) OK
//------------------------------
$BD10  C9 03     CMP #$03
$BD12  D0 03     BNE L_BRS_($BD17)_($BD12) OK
$BD14  4C B2 BD  JMP L_JMP_($BDB2)_($BD14) OK
//------------------------------
L_BRS_($BD17)_($BD12) OK
//------------------------------
$BD17  4C 07 BE  JMP L_JMP_($BE07)_($BD17) OK
//------------------------------
L_JMP_($BD1A)_($BD06) OK
L_JMP_($BD1A)_($F924) OK
//------------------------------
$BD1A  C6 2D     DEC $2D 
$BD1C  A5 2D     LDA $2D 
$BD1E  C9 10     CMP #$10
$BD20  D0 1C     BNE L_BRS_($BD3E)_($BD20) OK
$BD22  A9 40     LDA #$40
$BD24  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte ; frequency = 962,158203125 Hz
$BD27  A9 00     LDA #$00
$BD29  8D 07 D4  STA $D407                          // Voice 2: Frequency Control - Low-Byte
$BD2C  A9 00     LDA #$00
$BD2E  8D 0C D4  STA $D40C                          // Voice 2: Attack / Decay Cycle Control ; attack = 0, decay = 0
$BD31  A9 F0     LDA #$F0
$BD33  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control ; sustain = f, release = 0
$BD36  A9 11     LDA #$11
$BD38  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Select Triangle Waveform, 1 = On, Gate Bit: 1 = Start Att,Dec,Sus
$BD3B  4C 07 BE  JMP L_JMP_($BE07)_($BD3B) OK
//------------------------------
L_BRS_($BD3E)_($BD20) OK
//------------------------------
$BD3E  C9 00     CMP #$00
$BD40  D0 13     BNE L_BRS_($BD55)_($BD40) OK
$BD42  A9 FB     LDA #$FB
$BD44  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control ; sustain = f, release = B
$BD47  A9 10     LDA #$10
$BD49  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Select Triangle Waveform, Gate Bit: 0 = Start Release
$BD4C  A9 00     LDA #$00
$BD4E  85 2C     STA $2C 
$BD50  85 2D     STA $2D 
$BD52  4C 07 BE  JMP L_JMP_($BE07)_($BD52) OK
//------------------------------
L_BRS_($BD55)_($BD40) OK
//------------------------------
$BD55  A9 10     LDA #$10
$BD57  38        SEC 
$BD58  E5 2D     SBC $2D 
$BD5A  0A        ASL A 
$BD5B  0A        ASL A 
$BD5C  0A        ASL A 
$BD5D  18        CLC 
$BD5E  69 40     ADC #$40
$BD60  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte ; frequency - variable, check which values are possible
$BD63  4C 07 BE  JMP L_JMP_($BE07)_($BD63) OK
//------------------------------
L_JMP_($BD66)_($BD0D) OK
L_JMP_($BD66)_($F92B) OK
//------------------------------
$BD66  C6 2D     DEC $2D 
$BD68  A5 2D     LDA $2D 
$BD6A  C9 20     CMP #$20
$BD6C  D0 1C     BNE L_BRS_($BD8A)_($BD6C) OK
$BD6E  A9 A0     LDA #$A0
$BD70  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte ; frequency = 2405,3955078125 Hz
$BD73  A9 00     LDA #$00
$BD75  8D 07 D4  STA $D407                          // Voice 2: Frequency Control - Low-Byte
$BD78  A9 00     LDA #$00
$BD7A  8D 0C D4  STA $D40C                          // Voice 2: Attack / Decay Cycle Control ; Attack = 0, decay = 0
$BD7D  A9 F0     LDA #$F0
$BD7F  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control ; Sustain = F, release = 0
$BD82  A9 21     LDA #$21
$BD84  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Select Sawtooth Waveform, 1 = On, Gate Bit: 1 = Start Att,Dec,Sus
$BD87  4C 07 BE  JMP L_JMP_($BE07)_($BD87) OK
//------------------------------
L_BRS_($BD8A)_($BD6C) OK
//------------------------------
$BD8A  C9 00     CMP #$00
$BD8C  D0 13     BNE L_BRS_($BDA1)_($BD8C) OK
$BD8E  A9 F7     LDA #$F7
$BD90  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control ; Sustain = F, release = 7
$BD93  A9 20     LDA #$20
$BD95  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Select Sawtooth Waveform, 1 = On, Gate Bit: 0 = Start Release
$BD98  A9 00     LDA #$00
$BD9A  85 2C     STA $2C 
$BD9C  85 2D     STA $2D 
$BD9E  4C 07 BE  JMP L_JMP_($BE07)_($BD9E) OK
//------------------------------
L_BRS_($BDA1)_($BD8C) OK
//------------------------------
$BDA1  85 57     STA $57 
$BDA3  A9 20     LDA #$20
$BDA5  38        SEC 
$BDA6  E5 57     SBC $57 
$BDA8  0A        ASL A 
$BDA9  18        CLC 
$BDAA  69 A0     ADC #$A0
$BDAC  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte ; variable frequency
$BDAF  4C 07 BE  JMP L_JMP_($BE07)_($BDAF) OK
//------------------------------
L_JMP_($BDB2)_($BD14) OK
L_JMP_($BDB2)_($F932) OK
//------------------------------
$BDB2  C6 2D     DEC $2D 
$BDB4  A5 2D     LDA $2D 
$BDB6  C9 20     CMP #$20
$BDB8  D0 26     BNE L_BRS_($BDE0)_($BDB8) OK
$BDBA  A9 38     LDA #$38
$BDBC  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte ; frequency = 841,888427734375 Hz
$BDBF  A9 00     LDA #$00
$BDC1  8D 07 D4  STA $D407                          // Voice 2: Frequency Control - Low-Byte
$BDC4  A9 00     LDA #$00
$BDC6  8D 0C D4  STA $D40C                          // Voice 2: Attack / Decay Cycle Control ; attack = 0, decay = 0
$BDC9  A9 F0     LDA #$F0
$BDCB  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control ; sustain = f, release = 0
$BDCE  A9 43     LDA #$43
$BDD0  8D 0A D4  STA $D40A                          // Voice 2: Pulse Waveform Width - High-Nybble
$BDD3  A9 50     LDA #$50
$BDD5  8D 09 D4  STA $D409                          // Voice 2: Pulse Waveform Width - Low-Byte
$BDD8  A9 41     LDA #$41
$BDDA  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Select Pulse Waveform, 1 = On; Gate Bit: 1 = Start Att,Dec,Sus
$BDDD  4C 07 BE  JMP L_JMP_($BE07)_($BDDD) OK
//------------------------------
L_BRS_($BDE0)_($BDB8) OK
//------------------------------
$BDE0  C9 00     CMP #$00
$BDE2  D0 13     BNE L_BRS_($BDF7)_($BDE2) OK
$BDE4  A9 F4     LDA #$F4
$BDE6  8D 0D D4  STA $D40D                          // Voice 2: Sustain / Release Cycle Control ; sustain = f, release = 4
$BDE9  A9 40     LDA #$40
$BDEB  8D 0B D4  STA $D40B                          // Voice 2: Control Register ; Select Pulse Waveform, 1 = On; Gate Bit: 0 = Start Release
$BDEE  A9 00     LDA #$00
$BDF0  85 2C     STA $2C 
$BDF2  85 2D     STA $2D 
$BDF4  4C 07 BE  JMP L_JMP_($BE07)_($BDF4) OK
//------------------------------
L_BRS_($BDF7)_($BDE2) OK
//------------------------------
$BDF7  4A        LSR A 
$BDF8  90 05     BCC L_BRS_($BDFF)_($BDF8) OK
$BDFA  A9 39     LDA #$39
$BDFC  4C 01 BE  JMP L_JMP_($BE01)_($BDFC) OK
//------------------------------
L_BRS_($BDFF)_($BDF8) OK
//------------------------------
$BDFF  A9 37     LDA #$37
//------------------------------
L_JMP_($BE01)_($BDFC) OK
L_JMP_($BE01)_($FA1A) OK
//------------------------------
$BE01  8D 08 D4  STA $D408                          // Voice 2: Frequency Control - High-Byte ; frequency = 826,854705810546875 Hz ($3700) or 856,922149658203125 Hz ($3900)
$BE04  4C 07 BE  JMP L_JMP_($BE07)_($BE04) OK
//------------------------------
L_JMP_($BE07)_($BD17) OK
L_JMP_($BE07)_($BD3B) OK
L_JMP_($BE07)_($BD52) OK
L_JMP_($BE07)_($BD63) OK
L_JMP_($BE07)_($BD87) OK
L_JMP_($BE07)_($BD9E) OK
L_JMP_($BE07)_($BDAF) OK
L_JMP_($BE07)_($BDDD) OK
L_JMP_($BE07)_($BDF4) OK
L_JMP_($BE07)_($BE04) OK
L_JMP_($BE07)_($F935) OK
L_JMP_($BE07)_($F959) OK
L_JMP_($BE07)_($F970) OK
L_JMP_($BE07)_($F981) OK
L_JMP_($BE07)_($F9A5) OK
L_JMP_($BE07)_($F9BC) OK
L_JMP_($BE07)_($F9CD) OK
L_JMP_($BE07)_($F9FB) OK
L_JMP_($BE07)_($FA12) OK
L_JMP_($BE07)_($FA22) OK
//------------------------------
$BE07  60        RTS 
//------------------------------
$BE08            .byte $FF
//------------------------------
L_JSR_($BE09)_($0807) OK
L_JSR_($BE09)_($C5E7) OK
L_JSR_($BE09)_($FFC4) OK
//------------------------------
$BE09  20 13 2E  JSR L_JSR_($2E13)_($BE09) OK
$BE0C  A2 00     LDX #$00
$BE0E  A0 01     LDY #$01
$BE10  A9 60     LDA #$60
$BE12  85 50     STA $50 
$BE14  A9 78     LDA #$78
$BE16  85 51     STA $51 
$BE18  8A        TXA 
//------------------------------
L_BRS_($BE19)_($BE25) OK
//------------------------------
$BE19  91 50     STA ($50),Y 
$BE1B  E6 51     INC $51 
$BE1D  EA        NOP 
$BE1E  EA        NOP 
$BE1F  EA        NOP 
$BE20  EA        NOP 
$BE21  EA        NOP 
$BE22  E8        INX 
$BE23  E0 15     CPX #$15
$BE25  D0 F2     BNE L_BRS_($BE19)_($BE25) OK
$BE27  A9 A9     LDA #$A9
$BE29  8D 3F 33  STA $333F 
$BE2C  8D 4B 33  STA $334B 
$BE2F  A9 06     LDA #$06
$BE31  8D 40 33  STA $3340 
$BE34  A9 00     LDA #$00
$BE36  8D 4C 33  STA $334C 
$BE39  20 12 30  JSR L_JSR_($3012)_($BE39) OK
$BE3C  A9 44     LDA #$44
$BE3E  85 D7     STA $D7 
$BE40  A9 68     LDA #$68
$BE42  85 D6     STA $D6 
$BE44  A9 10     LDA #$10
$BE46  85 9D     STA $9D 
$BE48  A9 80     LDA #$80
$BE4A  85 31     STA $31 
$BE4C  20 F5 BF  JSR L_JSR_($BFF5)_($BE4C) OK
$BE4F  A2 14     LDX #$14
$BE51  A0 01     LDY #$01
$BE53  20 68 38  JSR L_JSR_($3868)_($BE53) OK
$BE56  A9 8D     LDA #$8D
$BE58  85 D7     STA $D7 
$BE5A  A9 E8     LDA #$E8
$BE5C  85 D6     STA $D6 
$BE5E  20 F5 BF  JSR L_JSR_($BFF5)_($BE5E) OK
$BE61  A2 14     LDX #$14
$BE63  A0 02     LDY #$02
$BE65  20 68 38  JSR L_JSR_($3868)_($BE65) OK
$BE68  A9 00     LDA #$00
$BE6A  85 4C     STA $4C 
//------------------------------
L_BRS_($BE6C)_($BE75) OK
//------------------------------
$BE6C  A5 4C     LDA $4C 
$BE6E  A8        TAY 
$BE6F  C0 59     CPY #$59
$BE71  F0 07     BEQ L_BRS_($BE7A)_($BE71) OK
$BE73  C0 4E     CPY #$4E
$BE75  D0 F5     BNE L_BRS_($BE6C)_($BE75) OK
$BE77  4C DB BF  JMP L_JMP_($BFDB)_($BE77) OK
//------------------------------
L_BRS_($BE7A)_($BE71) OK
//------------------------------
$BE7A  A9 8D     LDA #$8D
$BE7C  85 D7     STA $D7 
$BE7E  A9 68     LDA #$68
$BE80  85 D6     STA $D6 
$BE82  20 F5 BF  JSR L_JSR_($BFF5)_($BE82) OK
$BE85  A2 14     LDX #$14
$BE87  A0 05     LDY #$05
$BE89  20 68 38  JSR L_JSR_($3868)_($BE89) OK
$BE8C  A9 14     LDA #$14
$BE8E  85 60     STA $60 
//------------------------------
L_JMP_($BE90)_($BFD8) OK
L_JMP_($BE90)_($FBF4) OK
//------------------------------
$BE90  20 79 32  JSR L_JSR_($3279)_($BE90) OK
$BE93  A5 60     LDA $60 
$BE95  C9 14     CMP #$14
$BE97  D0 03     BNE L_BRS_($BE9C)_($BE97) OK
$BE99  38        SEC 
$BE9A  E9 02     SBC #$02
//------------------------------
L_BRS_($BE9C)_($BE97) OK
//------------------------------
$BE9C  85 52     STA $52 
$BE9E  A9 12     LDA #$12
$BEA0  38        SEC 
$BEA1  E5 52     SBC $52 
$BEA3  18        CLC 
$BEA4  69 90     ADC #$90
$BEA6  85 D7     STA $D7 
$BEA8  A9 68     LDA #$68
$BEAA  85 D6     STA $D6 
$BEAC  20 F5 BF  JSR L_JSR_($BFF5)_($BEAC) OK
$BEAF  A2 14     LDX #$14
$BEB1  A0 08     LDY #$08
$BEB3  20 68 38  JSR L_JSR_($3868)_($BEB3) OK
$BEB6  A5 52     LDA $52 
$BEB8  38        SEC 
$BEB9  E9 0B     SBC #$0B
$BEBB  AA        TAX 
$BEBC  BD E8 90  LDA $90E8,X 
$BEBF  85 72     STA $72 
$BEC1  85 D6     STA $D6 
$BEC3  A9 47     LDA #$47
$BEC5  85 D7     STA $D7 
$BEC7  20 F5 BF  JSR L_JSR_($BFF5)_($BEC7) OK
$BECA  A2 14     LDX #$14
$BECC  A0 11     LDY #$11
$BECE  20 68 38  JSR L_JSR_($3868)_($BECE) OK
$BED1  A9 1C     LDA #$1C
$BED3  85 FC     STA $FC 
$BED5  A9 0A     LDA #$0A
$BED7  85 FB     STA $FB 
$BED9  A9 40     LDA #$40
$BEDB  85 AD     STA $AD 
$BEDD  A9 32     LDA #$32
$BEDF  85 AC     STA $AC 
$BEE1  20 BF 33  JSR L_JSR_($33BF)_($BEE1) OK
//------------------------------
L_BRS_($BEE4)_($BEFC) OK
//------------------------------
$BEE4  20 79 32  JSR L_JSR_($3279)_($BEE4) OK
$BEE7  20 7B 13  JSR L_JSR_($137B)_($BEE7) OK
$BEEA  A2 3F     LDX #$3F
//------------------------------
L_BRS_($BEEC)_($BEF2) OK
//------------------------------
$BEEC  A0 FF     LDY #$FF
//------------------------------
L_BRS_($BEEE)_($BEEF) OK
//------------------------------
$BEEE  88        DEY 
$BEEF  D0 FD     BNE L_BRS_($BEEE)_($BEEF) OK
$BEF1  CA        DEX 
$BEF2  D0 F8     BNE L_BRS_($BEEC)_($BEF2) OK
$BEF4  20 BF 33  JSR L_JSR_($33BF)_($BEF4) OK
$BEF7  20 EA 31  JSR L_JSR_($31EA)_($BEF7) OK
$BEFA  A5 AD     LDA $AD 
$BEFC  D0 E6     BNE L_BRS_($BEE4)_($BEFC) OK
//------------------------------
L_BRS_($BEFE)_($BF5F) OK
//------------------------------
$BEFE  A9 8E     LDA #$8E
$BF00  85 D7     STA $D7 
$BF02  A9 68     LDA #$68
$BF04  85 D6     STA $D6 
$BF06  20 F5 BF  JSR L_JSR_($BFF5)_($BF06) OK
$BF09  A2 14     LDX #$14
$BF0B  A0 13     LDY #$13
$BF0D  20 68 38  JSR L_JSR_($3868)_($BF0D) OK
$BF10  A9 00     LDA #$00
$BF12  85 4C     STA $4C 
//------------------------------
L_BRS_($BF14)_($BF17) OK
//------------------------------
$BF14  A5 4C     LDA $4C 
$BF16  A8        TAY 
$BF17  F0 FB     BEQ L_BRS_($BF14)_($BF17) OK
$BF19  C0 43     CPY #$43
$BF1B  F0 03     BEQ L_BRS_($BF20)_($BF1B) OK
$BF1D  4C A1 BF  JMP L_JMP_($BFA1)_($BF1D) OK
//------------------------------
L_JSR_($BF20)_($6425) OK
L_JSR_($BF20)_($6525) OK
L_BRS_($BF20)_($BF1B) OK
//------------------------------
$BF20  20 E8 8F  JSR L_JSR_($8FE8)_($BF20) OK
$BF23  EA        NOP 
$BF24  A9 68     LDA #$68
$BF26  85 D6     STA $D6 
$BF28  20 F5 BF  JSR L_JSR_($BFF5)_($BF28) OK
$BF2B  A2 14     LDX #$14
$BF2D  A0 13     LDY #$13
$BF2F  20 68 38  JSR L_JSR_($3868)_($BF2F) OK
$BF32  A2 0B     LDX #$0B
$BF34  A9 00     LDA #$00
//------------------------------
L_BRS_($BF36)_($BF3A) OK
//------------------------------
$BF36  9D 00 47  STA $4700,X 
$BF39  CA        DEX 
$BF3A  10 FA     BPL L_BRS_($BF36)_($BF3A) OK
$BF3C  A9 47     LDA #$47
$BF3E  85 D7     STA $D7 
$BF40  A9 00     LDA #$00
$BF42  85 D6     STA $D6 
$BF44  20 F5 BF  JSR L_JSR_($BFF5)_($BF44) OK
$BF47  A2 14     LDX #$14
$BF49  A0 11     LDY #$11
$BF4B  20 68 38  JSR L_JSR_($3868)_($BF4B) OK
$BF4E  A0 00     LDY #$00
//------------------------------
L_BRS_($BF50)_($BF63) OK
L_BRS_($BF50)_($BF67) OK
L_BRS_($BF50)_($BF6B) OK
L_JMP_($BF50)_($BF9E) OK
L_JMP_($BF50)_($FBBA) OK
//------------------------------
$BF50  A9 00     LDA #$00
$BF52  85 4C     STA $4C 
//------------------------------
L_BRS_($BF54)_($BF56) OK
//------------------------------
$BF54  A5 4C     LDA $4C 
$BF56  F0 FC     BEQ L_BRS_($BF54)_($BF56) OK
$BF58  AA        TAX 
$BF59  E0 20     CPX #$20
$BF5B  F0 0C     BEQ L_BRS_($BF69)_($BF5B) OK
$BF5D  E0 0D     CPX #$0D
$BF5F  F0 9D     BEQ L_BRS_($BEFE)_($BF5F) OK
$BF61  E0 41     CPX #$41
$BF63  90 EB     BCC L_BRS_($BF50)_($BF63) OK
$BF65  E0 5B     CPX #$5B
$BF67  B0 E7     BCS L_BRS_($BF50)_($BF67) OK
//------------------------------
L_BRS_($BF69)_($BF5B) OK
//------------------------------
$BF69  C0 0C     CPY #$0C
$BF6B  F0 E3     BEQ L_BRS_($BF50)_($BF6B) OK
$BF6D  8A        TXA 
$BF6E  99 00 47  STA $4700,Y 
$BF71  C8        INY 
$BF72  98        TYA 
$BF73  48        PHA 
$BF74  A9 47     LDA #$47
$BF76  85 D7     STA $D7 
$BF78  A9 00     LDA #$00
$BF7A  85 D6     STA $D6 
$BF7C  20 F5 BF  JSR L_JSR_($BFF5)_($BF7C) OK
$BF7F  A2 14     LDX #$14
$BF81  A0 11     LDY #$11
$BF83  20 68 38  JSR L_JSR_($3868)_($BF83) OK
$BF86  68        PLA 
$BF87  A8        TAY 
$BF88  A9 47     LDA #$47
$BF8A  85 4F     STA $4F 
$BF8C  85 51     STA $51 
$BF8E  A9 00     LDA #$00
$BF90  85 4E     STA $4E 
$BF92  A5 72     LDA $72 
$BF94  85 50     STA $50 
$BF96  88        DEY 
$BF97  B1 4E     LDA ($4E),Y 
$BF99  91 50     STA ($50),Y 
$BF9B  C8        INY 
$BF9C  EA        NOP 
$BF9D  EA        NOP 
$BF9E  4C 50 BF  JMP L_JMP_($BF50)_($BF9E) OK
//------------------------------
L_JMP_($BFA1)_($BF1D) OK
L_JMP_($BFA1)_($FB39) OK
//------------------------------
$BFA1  A9 4A     LDA #$4A
$BFA3  85 AC     STA $AC 
$BFA5  A9 40     LDA #$40
$BFA7  85 AD     STA $AD 
$BFA9  20 BF 33  JSR L_JSR_($33BF)_($BFA9) OK
//------------------------------
L_BRS_($BFAC)_($BFC4) OK
//------------------------------
$BFAC  20 79 32  JSR L_JSR_($3279)_($BFAC) OK
$BFAF  20 7B 13  JSR L_JSR_($137B)_($BFAF) OK
$BFB2  A2 3F     LDX #$3F
//------------------------------
L_BRS_($BFB4)_($BFBA) OK
//------------------------------
$BFB4  A0 FF     LDY #$FF
//------------------------------
L_BRS_($BFB6)_($BFB7) OK
//------------------------------
$BFB6  88        DEY 
$BFB7  D0 FD     BNE L_BRS_($BFB6)_($BFB7) OK
$BFB9  CA        DEX 
$BFBA  D0 F8     BNE L_BRS_($BFB4)_($BFBA) OK
$BFBC  20 BF 33  JSR L_JSR_($33BF)_($BFBC) OK
$BFBF  20 EA 31  JSR L_JSR_($31EA)_($BFBF) OK
$BFC2  A5 AD     LDA $AD 
$BFC4  D0 E6     BNE L_BRS_($BFAC)_($BFC4) OK
$BFC6  A5 60     LDA $60 
$BFC8  C9 14     CMP #$14
$BFCA  D0 04     BNE L_BRS_($BFD0)_($BFCA) OK
$BFCC  C6 60     DEC $60 
$BFCE  C6 60     DEC $60 
//------------------------------
L_BRS_($BFD0)_($BFCA) OK
//------------------------------
$BFD0  C6 60     DEC $60 
$BFD2  A5 60     LDA $60 
$BFD4  C9 0A     CMP #$0A
$BFD6  F0 03     BEQ L_BRS_($BFDB)_($BFD6) OK
$BFD8  4C 90 BE  JMP L_JMP_($BE90)_($BFD8) OK
//------------------------------
L_JMP_($BFDB)_($BE77) OK
L_BRS_($BFDB)_($BFD6) OK
L_JMP_($BFDB)_($FA93) OK
//------------------------------
$BFDB  A9 B1     LDA #$B1
$BFDD  8D 3F 33  STA $333F 
$BFE0  8D 4B 33  STA $334B 
$BFE3  A9 52     LDA #$52
$BFE5  8D 40 33  STA $3340 
$BFE8  A9 54     LDA #$54
$BFEA  8D 4C 33  STA $334C 
$BFED  20 13 2E  JSR L_JSR_($2E13)_($BFED) OK
$BFF0  A9 01     LDA #$01
$BFF2  85 46     STA $46 
$BFF4  60        RTS 
//------------------------------
L_JSR_($BFF5)_($BE4C) OK
L_JSR_($BFF5)_($BE5E) OK
L_JSR_($BFF5)_($BE82) OK
L_JSR_($BFF5)_($BEAC) OK
L_JSR_($BFF5)_($BEC7) OK
L_JSR_($BFF5)_($BF06) OK
L_JSR_($BFF5)_($BF28) OK
L_JSR_($BFF5)_($BF44) OK
L_JSR_($BFF5)_($BF7C) OK
L_JSR_($BFF5)_($FA68) OK
L_JSR_($BFF5)_($FA7A) OK
L_JSR_($BFF5)_($FA9E) OK
L_JSR_($BFF5)_($FAC8) OK
L_JSR_($BFF5)_($FAE3) OK
L_JSR_($BFF5)_($FB22) OK
L_JSR_($BFF5)_($FB44) OK
L_JSR_($BFF5)_($FB60) OK
L_JSR_($BFF5)_($FB98) OK
//------------------------------
$BFF5  20 05 20  JSR L_JSR_($2005)_($BFF5) OK
$BFF8  20 3B 21  JSR L_JSR_($213B)_($BFF8) OK
$BFFB  60        RTS 
//------------------------------
$BFFC            .byte $77,$FF,$FF,$FF
$C000  A9 00     LDA #$00
$C002  8D 20 D0  STA $D020                          // Border Color
$C005  8D 21 D0  STA $D021                          // Background Color 0
$C008  8D 18 D4  STA $D418                          // Select Filter Mode and Volume
$C00B  85 C6     STA $C6 
$C00D  A9 EA     LDA #$EA
$C00F  8D 28 03  STA $0328 
$C012  20 44 E5  JSR L_JSR_($E544)_($C012) JAM
$C015  A9 17     LDA #$17
$C017  8D 18 D0  STA $D018                          // Memory Control Register
$C01A  A2 27     LDX #$27
//------------------------------
L_BRS_($C01C)_($C028) OK
//------------------------------
$C01C  BD 00 C4  LDA $C400,X 
//------------------------------
L_JSR_($C020)_($6225) BAD
L_JSR_($C020)_($6286) BAD
//------------------------------
$C01F  9D 00 04  STA $0400,X 
$C022  A9 01     LDA #$01
$C024  9D 00 D8  STA $D800,X 
$C027  CA        DEX 
$C028  10 F2     BPL L_BRS_($C01C)_($C028) OK
$C02A  A2 1F     LDX #$1F
//------------------------------
L_BRS_($C02C)_($C038) OK
//------------------------------
$C02C  BD 28 C4  LDA $C428,X 
$C02F  9D 50 04  STA $0450,X 
$C032  A9 07     LDA #$07
$C034  9D 50 D8  STA $D850,X 
$C037  CA        DEX 
$C038  10 F2     BPL L_BRS_($C02C)_($C038) OK
//------------------------------
L_BRS_($C03A)_($C04D) OK
//------------------------------
$C03A  20 E4 FF  JSR L_JSR_($FFE4)_($C03A) OK
$C03D  C9 59     CMP #$59
$C03F  D0 0A     BNE L_BRS_($C04B)_($C03F) OK
$C041  A2 04     LDX #$04
$C043  8E 5F 1D  STX $1D5F 
$C046  8E A5 1D  STX $1DA5 
$C049  D0 04     BNE L_BRS_($C04F)_($C049) OK
//------------------------------
L_BRS_($C04B)_($C03F) OK
//------------------------------
$C04B  C9 4E     CMP #$4E
$C04D  D0 EB     BNE L_BRS_($C03A)_($C04D) OK
//------------------------------
L_BRS_($C04F)_($C049) OK
//------------------------------
$C04F  8D 71 04  STA $0471 
$C052  A9 01     LDA #$01
$C054  8D 71 D8  STA $D871 
$C057  A2 1F     LDX #$1F
//------------------------------
L_BRS_($C059)_($C065) OK
//------------------------------
$C059  BD 48 C4  LDA $C448,X 
$C05C  9D 78 04  STA $0478,X 
$C05F  A9 0B     LDA #$0B
$C061  9D 78 D8  STA $D878,X 
$C064  CA        DEX 
$C065  10 F2     BPL L_BRS_($C059)_($C065) OK
//------------------------------
L_BRS_($C067)_($C077) OK
//------------------------------
$C067  20 E4 FF  JSR L_JSR_($FFE4)_($C067) OK
$C06A  C9 59     CMP #$59
$C06C  D0 07     BNE L_BRS_($C075)_($C06C) OK
$C06E  A2 60     LDX #$60
$C070  8E 43 1E  STX $1E43 
$C073  D0 04     BNE L_BRS_($C079)_($C073) OK
//------------------------------
L_BRS_($C075)_($C06C) OK
//------------------------------
$C075  C9 4E     CMP #$4E
$C077  D0 EE     BNE L_BRS_($C067)_($C077) OK
//------------------------------
L_BRS_($C079)_($C073) OK
//------------------------------
$C079  8D 99 04  STA $0499 
$C07C  A9 01     LDA #$01
$C07E  8D 99 D8  STA $D899 
$C081  A2 24     LDX #$24
//------------------------------
L_BRS_($C083)_($C08F) OK
//------------------------------
$C083  BD 68 C4  LDA $C468,X 
$C086  9D A0 04  STA $04A0,X 
$C089  A9 07     LDA #$07
$C08B  9D A0 D8  STA $D8A0,X 
$C08E  CA        DEX 
$C08F  10 F2     BPL L_BRS_($C083)_($C08F) OK
//------------------------------
L_BRS_($C091)_($C09A) OK
//------------------------------
$C091  20 E4 FF  JSR L_JSR_($FFE4)_($C091) OK
$C094  C9 4E     CMP #$4E
$C096  F0 69     BEQ L_BRS_($C101)_($C096) OK
$C098  C9 59     CMP #$59
$C09A  D0 F5     BNE L_BRS_($C091)_($C09A) OK
$C09C  8D C6 04  STA $04C6 
$C09F  A9 01     LDA #$01
$C0A1  8D C6 D8  STA $D8C6 
$C0A4  A2 3F     LDX #$3F
//------------------------------
L_BRS_($C0A6)_($C0B2) OK
//------------------------------
$C0A6  BD 8D C4  LDA $C48D,X 
$C0A9  9D C8 04  STA $04C8,X 
$C0AC  A9 0A     LDA #$0A
$C0AE  9D C8 D8  STA $D8C8,X 
$C0B1  CA        DEX 
$C0B2  10 F2     BPL L_BRS_($C0A6)_($C0B2) OK
$C0B4  A9 00     LDA #$00
$C0B6  85 FA     STA $FA 
//------------------------------
L_BRS_($C0B8)_($C0EA) OK
L_BRS_($C0B8)_($C0EE) OK
//------------------------------
$C0B8  20 E4 FF  JSR L_JSR_($FFE4)_($C0B8) OK
$C0BB  C9 11     CMP #$11
$C0BD  D0 04     BNE L_BRS_($C0C3)_($C0BD) OK
//------------------------------
L_BRS_($C0BF)_($C0C9) OK
//------------------------------
$C0BF  E6 FA     INC $FA 
$C0C1  10 08     BPL L_BRS_($C0CB)_($C0C1) OK
//------------------------------
L_BRS_($C0C3)_($C0BD) OK
//------------------------------
$C0C3  C9 91     CMP #$91
$C0C5  D0 25     BNE L_BRS_($C0EC)_($C0C5) OK
//------------------------------
L_BRS_($C0C7)_($C0CF) OK
//------------------------------
$C0C7  C6 FA     DEC $FA 
$C0C9  30 F4     BMI L_BRS_($C0BF)_($C0C9) OK
//------------------------------
L_BRS_($C0CB)_($C0C1) OK
//------------------------------
$C0CB  A5 FA     LDA $FA 
$C0CD  C9 15     CMP #$15
$C0CF  B0 F6     BCS L_BRS_($C0C7)_($C0CF) OK
$C0D1  A0 C4     LDY #$C4
$C0D3  84 FC     STY $FC 
$C0D5  2A        ROL A 
$C0D6  2A        ROL A 
$C0D7  18        CLC 
$C0D8  69 C9     ADC #$C9
$C0DA  85 FB     STA $FB 
$C0DC  90 02     BCC L_BRS_($C0E0)_($C0DC) OK
$C0DE  E6 FC     INC $FC 
//------------------------------
L_BRS_($C0E0)_($C0DC) OK
//------------------------------
$C0E0  A0 03     LDY #$03
//------------------------------
L_BRS_($C0E2)_($C0E8) OK
//------------------------------
$C0E2  B1 FB     LDA ($FB),Y 
$C0E4  99 04 05  STA $0504,Y 
$C0E7  88        DEY 
$C0E8  10 F8     BPL L_BRS_($C0E2)_($C0E8) OK
$C0EA  30 CC     BMI L_BRS_($C0B8)_($C0EA) OK
//------------------------------
L_BRS_($C0EC)_($C0C5) OK
//------------------------------
$C0EC  C9 0D     CMP #$0D
$C0EE  D0 C8     BNE L_BRS_($C0B8)_($C0EE) OK
$C0F0  A9 A9     LDA #$A9
$C0F2  8D AA 2A  STA $2AAA 
$C0F5  A5 FA     LDA $FA 
$C0F7  8D AB 2A  STA $2AAB 
$C0FA  A9 EA     LDA #$EA
$C0FC  8D AC 2A  STA $2AAC 
$C0FF  D0 08     BNE L_BRS_($C109)_($C0FF) OK
//------------------------------
L_BRS_($C101)_($C096) OK
//------------------------------
$C101  8D C6 04  STA $04C6 
$C104  A9 01     LDA #$01
$C106  8D C6 D8  STA $D8C6 
//------------------------------
L_BRS_($C109)_($C0FF) OK
//------------------------------
$C109  A2 24     LDX #$24
//------------------------------
L_BRS_($C10B)_($C117) OK
//------------------------------
$C10B  BD 1D C5  LDA $C51D,X 
$C10E  9D 18 05  STA $0518,X 
$C111  A9 0B     LDA #$0B
$C113  9D 18 D9  STA $D918,X 
$C116  CA        DEX 
$C117  10 F2     BPL L_BRS_($C10B)_($C117) OK
//------------------------------
L_BRS_($C119)_($C131) OK
//------------------------------
$C119  20 E4 FF  JSR L_JSR_($FFE4)_($C119) OK
$C11C  C9 59     CMP #$59
$C11E  D0 0F     BNE L_BRS_($C12F)_($C11E) OK
$C120  48        PHA 
$C121  A2 17     LDX #$17
//------------------------------
L_BRS_($C123)_($C12A) OK
//------------------------------
$C123  BD 00 C6  LDA $C600,X 
$C126  9D 30 29  STA $2930,X 
$C129  CA        DEX 
$C12A  10 F7     BPL L_BRS_($C123)_($C12A) OK
$C12C  68        PLA 
$C12D  D0 04     BNE L_BRS_($C133)_($C12D) OK
//------------------------------
L_BRS_($C12F)_($C11E) OK
//------------------------------
$C12F  C9 4E     CMP #$4E
$C131  D0 E6     BNE L_BRS_($C119)_($C131) OK
//------------------------------
L_BRS_($C133)_($C12D) OK
//------------------------------
$C133  8D 3E 05  STA $053E 
$C136  A9 01     LDA #$01
$C138  8D 3E D9  STA $D93E 
$C13B  A2 45     LDX #$45
//------------------------------
L_BRS_($C13D)_($C149) OK
//------------------------------
$C13D  BD 42 C5  LDA $C542,X 
$C140  9D 40 05  STA $0540,X 
$C143  A9 07     LDA #$07
$C145  9D 40 D9  STA $D940,X 
$C148  CA        DEX 
$C149  10 F2     BPL L_BRS_($C13D)_($C149) OK
//------------------------------
L_BRS_($C14B)_($C16E) OK
//------------------------------
$C14B  20 E4 FF  JSR L_JSR_($FFE4)_($C14B) OK
$C14E  C9 59     CMP #$59
$C150  D0 1A     BNE L_BRS_($C16C)_($C150) OK
$C152  A2 A9     LDX #$A9
$C154  8E 4C 29  STX $294C 
$C157  8E 5A 29  STX $295A 
$C15A  A2 01     LDX #$01
$C15C  8E 4D 29  STX $294D 
$C15F  8E 5B 29  STX $295B 
$C162  A2 EA     LDX #$EA
$C164  8E 4E 29  STX $294E 
$C167  8E 5C 29  STX $295C 
$C16A  D0 04     BNE L_BRS_($C170)_($C16A) OK
//------------------------------
L_BRS_($C16C)_($C150) OK
//------------------------------
$C16C  C9 4E     CMP #$4E
$C16E  D0 DB     BNE L_BRS_($C14B)_($C16E) OK
//------------------------------
L_BRS_($C170)_($C16A) OK
//------------------------------
$C170  8D 87 05  STA $0587 
$C173  A9 01     LDA #$01
$C175  8D 87 D9  STA $D987 
$C178  A2 37     LDX #$37
//------------------------------
L_BRS_($C17A)_($C186) OK
//------------------------------
$C17A  BD 88 C5  LDA $C588,X 
$C17D  9D 90 05  STA $0590,X 
$C180  A9 0B     LDA #$0B
$C182  9D 90 D9  STA $D990,X 
$C185  CA        DEX 
$C186  10 F2     BPL L_BRS_($C17A)_($C186) OK
//------------------------------
L_BRS_($C188)_($C1C5) OK
//------------------------------
$C188  20 E4 FF  JSR L_JSR_($FFE4)_($C188) OK
$C18B  C9 59     CMP #$59
$C18D  D0 34     BNE L_BRS_($C1C3)_($C18D) OK
$C18F  A2 20     LDX #$20
$C191  8E 07 2C  STX $2C07 
$C194  8E F7 2B  STX $2BF7 
$C197  A2 00     LDX #$00
$C199  8E 08 2C  STX $2C08 
$C19C  8E F8 2B  STX $2BF8 
$C19F  A2 07     LDX #$07
$C1A1  8E 09 2C  STX $2C09 
$C1A4  8E F9 2B  STX $2BF9 
$C1A7  A2 EA     LDX #$EA
$C1A9  8E 0A 2C  STX $2C0A 
$C1AC  8E FA 2B  STX $2BFA 
$C1AF  48        PHA 
$C1B0  A2 17     LDX #$17
//------------------------------
L_BRS_($C1B2)_($C1BE) OK
//------------------------------
$C1B2  BD 20 C6  LDA $C620,X 
$C1B5  9D 00 07  STA $0700,X 
$C1B8  A9 00     LDA #$00
$C1BA  9D 00 DB  STA $DB00,X 
$C1BD  CA        DEX 
$C1BE  10 F2     BPL L_BRS_($C1B2)_($C1BE) OK
$C1C0  68        PLA 
$C1C1  D0 04     BNE L_BRS_($C1C7)_($C1C1) OK
//------------------------------
L_BRS_($C1C3)_($C18D) OK
//------------------------------
$C1C3  C9 4E     CMP #$4E
$C1C5  D0 C1     BNE L_BRS_($C188)_($C1C5) OK
//------------------------------
L_BRS_($C1C7)_($C1C1) OK
//------------------------------
$C1C7  A2 0D     LDX #$0D
//------------------------------
L_BRS_($C1C9)_($C1D0) OK
//------------------------------
$C1C9  BD E0 C5  LDA $C5E0,X 
$C1CC  9D 00 08  STA $0800,X 
$C1CF  CA        DEX 
$C1D0  10 F7     BPL L_BRS_($C1C9)_($C1D0) OK
$C1D2  4C 00 08  JMP L_JMP_($0800)_($C1D2) OK
$C1D5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1DD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1E5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1ED            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1F5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1FD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C205            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C20D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C215            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C21D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C225            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C22D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C235            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C23D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C245            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C24D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C255            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C25D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C265            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C26D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C275            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C27D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C285            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C28D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C295            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C29D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2A5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2AD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2B5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2BD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2C5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2CD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2D5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2DD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2E5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2ED            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2F5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2FD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C305            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C30D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C315            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C31D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C325            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C32D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C335            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C33D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C345            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C34D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C355            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C35D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C365            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C36D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C375            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C37D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C385            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C38D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C395            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C39D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3A5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3AD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3B5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3BD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3C5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3CD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3D5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3DD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3E5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3ED            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3F5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3FD            .byte $00,$00,$00,$53,$4B,$4F,$4F
$C404  4C 20 44  JMP L_JMP_($4420)_($C404) JAM
$C407  41 5A     EOR ($5A,X) 
$C409  45 2B     EOR $2B 
$C40B  36 20     ROL $20,X 
$C40D  20 54 12  JSR L_JSR_($1254)_($C40D) OK
$C410  01 09     ORA ($09,X)
$C412  0E 05 04  ASL $0405 
$C415  20 02 19  JSR L_JSR_($1902)_($C415) BAD
$C418  20 54 43  JSR L_JSR_($4354)_($C418) OK
$C41B  45 2F     EOR $2F 
$C41D  48        PHA 
$C41E  46 20     LSR $20 
$C420            .byte $0F
$C421  0E 20 44  ASL $4420 
$C424  05 03     ORA $03
$C426  30 33     BMI L_BRS_($C45B)_($C426) OK
$C428            .byte $57
$C429  41 4E     EOR ($4E,X) 
$C42B  4E 41 20  LSR $2041 
$C42E  41 56     EOR ($56,X) 
$C430            .byte $4F
$C431  49 44     EOR #$44
$C433  20 47 45  JSR L_JSR_($4547)_($C433) JAM
$C436            .byte $54,$54
$C438  49 4E     EOR #$4E
$C43A            .byte $47
$C43B  20 4C 49  JSR L_JSR_($494C)_($C43B) BAD
$C43E  4E 45 53  LSR $5345 
$C441  20 28 59  JSR L_JSR_($5928)_($C441) JAM
$C444            .byte $2F
$C445  4E 29 3F  LSR $3F29 
$C448            .byte $54
$C449  45 41     EOR $41 
$C44B            .byte $43
$C44C  48        PHA 
$C44D  45 52     EOR $52 
$C44F            .byte $53
$C450  20 53 54  JSR L_JSR_($5453)_($C450) OK
$C453            .byte $4F
$C454  50 20     BVC L_BRS_($C476)_($C454) BAD
$C456  41 4E     EOR ($4E,X) 
$C458  4E 4F 59  LSR $594F 
//------------------------------
L_BRS_($C45B)_($C426) OK
//------------------------------
$C45B  49 4E     EOR #$4E
$C45D            .byte $47
$C45E  20 59 41  JSR L_JSR_($4159)_($C45E) BAD
$C461  20 28 59  JSR L_JSR_($5928)_($C461) JAM
$C464            .byte $2F
$C465  4E 29 3F  LSR $3F29 
$C468            .byte $57
$C469  41 4E     EOR ($4E,X) 
$C46B  4E 41 20  LSR $2041 
$C46E            .byte $53
$C46F  45 54     EOR $54 
$C471  20 4D 12  JSR L_JSR_($124D)_($C471) OK
//------------------------------
L_BRS_($C476)_($C454) BAD
//------------------------------
$C474  2E 43 52  ROL $5243 
$C477  45 41     EOR $41 
$C479            .byte $4B,$27,$53
$C47C  20 42 49  JSR L_JSR_($4942)_($C47C) BAD
$C47F            .byte $52,$54
$C481  48        PHA 
$C482            .byte $44
$C483  41 54     EOR ($54,X) 
$C485  45 20     EOR $20 
$C487  28        PLP 
$C488  59 2F 4E  EOR $4E2F,Y 
$C48B  29 3F     AND #$3F
$C48D  55 53     EOR $53,X 
$C48F  45 20     EOR $20 
$C491  55 10     EOR $10,X 
$C493            .byte $2F,$44,$0F,$17
$C497  0E 20 43  ASL $4320 
$C49A  55 52     EOR $52,X 
$C49C            .byte $53,$4F,$52,$53
$C4A0  20 41 4E  JSR L_JSR_($4E41)_($C4A0) JAM
$C4A3            .byte $44
$C4A4  20 52 45  JSR L_JSR_($4552)_($C4A4) JAM
$C4A7            .byte $54
$C4A8  55 52     EOR $52,X 
$C4AA  4E 20 54  LSR $5420 
$C4AD            .byte $4F
$C4AE  20 43 48  JSR L_JSR_($4843)_($C4AE) JAM
$C4B1            .byte $4F,$4F,$53
$C4B4  45 41     EOR $41 
$C4B6  20 44 41  JSR L_JSR_($4144)_($C4B6) BAD
$C4B9            .byte $54
$C4BA  45 20     EOR $20 
$C4BC  41 4D     EOR ($4D,X) 
$C4BE            .byte $4F
$C4BF  4E 47 20  LSR $2047 
$C4C2            .byte $54
$C4C3  48        PHA 
$C4C4  45 53     EOR $53 
$C4C6  45 3A     EOR $3A 
$C4C8  20 31 30  JSR L_JSR_($3031)_($C4C8) BAD
$C4CB  36 36     ROL $36,X 
$C4CD  31 32     AND ($32),Y 
$C4CF  36 35     ROL $35,X 
$C4D1  31 33     AND ($33),Y 
$C4D3  31 34     AND ($34),Y 
$C4D5  31 33     AND ($33),Y 
$C4D7            .byte $34
$C4D8  36 31     ROL $31,X 
$C4DA            .byte $33
$C4DB  35 36     AND $36,X 
$C4DD  31 34     AND ($34),Y 
$C4DF  30 33     BMI L_BRS_($C514)_($C4DF) OK
$C4E1  31 34     AND ($34),Y 
$C4E3  31 35     AND ($35),Y 
$C4E5  31 34     AND ($34),Y 
$C4E7  38        SEC 
$C4E8  35 31     AND $31,X 
$C4EA  35 31     AND $31,X 
$C4EC            .byte $33
$C4ED  31 35     AND ($35),Y 
$C4EF            .byte $37
$C4F0  31 31     AND ($31),Y 
$C4F2  30 31     BMI L_BRS_($C525)_($C4F2) BAD
$C4F4            .byte $34
$C4F5  31 36     AND ($36),Y 
$C4F7  38        SEC 
$C4F8  35 31     AND $31,X 
$C4FA            .byte $37,$34
$C4FC  36 31     ROL $31,X 
$C4FE            .byte $37,$37
$C500  35 31     AND $31,X 
$C502            .byte $37
$C503  38        SEC 
$C504  31 31     AND ($31),Y 
$C506  38        SEC 
$C507  30 35     BMI L_BRS_($C53E)_($C507) BAD
$C509  31 38     AND ($38),Y 
$C50B  31 35     AND ($35),Y 
$C50D  31 38     AND ($38),Y 
$C50F  31 32     AND ($32),Y 
$C511  31 38     AND ($38),Y 
$C513            .byte $33
//------------------------------
L_BRS_($C514)_($C4DF) OK
//------------------------------
$C514  36 31     ROL $31,X 
$C516  38        SEC 
$C517  36 33     ROL $33,X 
$C519  31 38     AND ($38),Y 
$C51B  35 34     AND $34,X 
$C51D            .byte $53
$C51E  45 54     EOR $54 
$C520  20 48 46  JSR L_JSR_($4648)_($C520) JAM
$C523  48        PHA 
//------------------------------
L_BRS_($C525)_($C4F2) BAD
//------------------------------
$C524  46 20     LSR $20 
$C526  41 53     EOR ($53,X) 
$C528  20 53 41  JSR L_JSR_($4153)_($C528) JAM
$C52B  46 45     LSR $45 
$C52D            .byte $27,$53
$C52F  20 43 4F  JSR L_JSR_($4F43)_($C52F) OK
$C532  4D 42 49  EOR $4942 
$C535  4E 41 54  LSR $5441 
$C538  49 4F     EOR #$4F
$C53A  4E 20 28  LSR $2820 
//------------------------------
L_BRS_($C53E)_($C507) BAD
//------------------------------
$C53D  59 2F 4E  EOR $4E2F,Y 
$C540  29 3F     AND #$3F
$C542            .byte $43,$4F
$C544  4D 42 49  EOR $4942 
$C547  4E 41 54  LSR $5441 
$C54A  49 4F     EOR #$4F
$C54C  4E 27 53  LSR $5327 
$C54F  20 4C 45  JSR L_JSR_($454C)_($C54F) JAM
$C552            .byte $54,$54
$C554  45 52     EOR $52 
$C556            .byte $53
$C557  20 4E 4F  JSR L_JSR_($4F4E)_($C557) BAD
$C55A            .byte $54
$C55B  20 4D 49  JSR L_JSR_($494D)_($C55B) OK
$C55E  58        CLI 
$C55F  45 44     EOR $44 
$C561  20 1B 57  JSR L_JSR_($571B)_($C561) JAM
$C564  41 43     EOR ($43,X) 
$C566            .byte $4B
$C567  45 52     EOR $52 
$C569  2C 52 4F  BIT $4F52 
$C56C            .byte $43,$4B
$C56E  49 54     EOR #$54
$C570            .byte $54
$C571  2C 20 57  BIT $5720 
$C574  49 54     EOR #$54
$C576  48        PHA 
$C577  49 54     EOR #$54
$C579  2C 20 43  BIT $4320 
$C57C            .byte $52
$C57D  45 41     EOR $41 
$C57F            .byte $4B
$C580  1D 20 28  ORA $2820,X
$C583  59 2F 4E  EOR $4E2F,Y 
$C586  29 3F     AND #$3F
$C588  41 4C     EOR ($4C,X) 
$C58A  4C 20 53  JMP L_JMP_($5320)_($C58A) OK
$C58D  48        PHA 
$C58E  49 45     EOR #$45
$C590  4C 44 53  JMP L_JMP_($5344)_($C590) BAD
$C593  20 41 43  JSR L_JSR_($4341)_($C593) BAD
$C596            .byte $54
$C597  49 56     EOR #$56
$C599  41 54     EOR ($54,X) 
$C59B  45 44     EOR $44 
$C59D            .byte $2F,$44
$C59F  45 41     EOR $41 
$C5A1            .byte $43,$54
$C5A3  49 56     EOR #$56
$C5A5  41 54     EOR ($54,X) 
$C5A7  45 44     EOR $44 
$C5A9  20 41 54  JSR L_JSR_($5441)_($C5A9) BAD
$C5AC  20 54 48  JSR L_JSR_($4854)_($C5AC) BAD
$C5AF  45 53     EOR $53 
$C5B1  41 4D     EOR ($4D,X) 
$C5B3  45 20     EOR $20 
$C5B5            .byte $54
$C5B6  49 4D     EOR #$4D
$C5B8  45 20     EOR $20 
$C5BA  28        PLP 
$C5BB  59 2F 4E  EOR $4E2F,Y 
$C5BE  29 3F     AND #$3F
$C5C0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C5C8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C5D0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C5D8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C5E0  20 D9 2C  JSR L_JSR_($2CD9)_($C5E0) OK
$C5E3  A5 46     LDA $46 
$C5E5  F0 03     BEQ L_BRS_($C5EA)_($C5E5) OK
$C5E7  20 09 BE  JSR L_JSR_($BE09)_($C5E7) OK
//------------------------------
L_BRS_($C5EA)_($C5E5) OK
//------------------------------
$C5EA  20 D5 3A  JSR L_JSR_($3AD5)_($C5EA) OK
$C5ED  20 00 00  JSR $0000
$C5F0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C5F8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C600            .byte $00
$C601  A9 48     LDA #$48
$C603  85 90     STA $90 
$C605  85 92     STA $92 
//------------------------------
L_BRS_($C608)_($C66C) BAD
//------------------------------
$C607  85 4E     STA $4E 
$C609  85 50     STA $50 
$C60B  A9 46     LDA #$46
$C60D  85 91     STA $91 
$C60F  85 93     STA $93 
$C611  85 4F     STA $4F 
$C613  85 51     STA $51 
$C615  EA        NOP 
$C616  EA        NOP 
$C617  EA        NOP 
$C618            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C620  98        TYA 
$C621  48        PHA 
$C622  B1 4E     LDA ($4E),Y 
$C624  49 01     EOR #$01
$C626  A0 02     LDY #$02
//------------------------------
L_BRS_($C628)_($C62F) OK
//------------------------------
$C628  91 4E     STA ($4E),Y 
$C62A  C8        INY 
$C62B  C8        INY 
$C62C  C8        INY 
$C62D  C0 2F     CPY #$2F
$C62F  D0 F7     BNE L_BRS_($C628)_($C62F) OK
$C631  A9 0E     LDA #$0E
$C633  85 D9     STA $D9 
$C635  68        PLA 
$C636  A8        TAY 
$C637  60        RTS 
//------------------------------
$C638  C0 34     CPY #$34
$C63A  11 DA     ORA ($DA),Y
$C63C  16 00     ASL $00,X 
$C63E  18        CLC 
$C63F  48        PHA 
$C640            .byte $DA
$C641  05 00     ORA $00
$C643  0D DA 04  ORA $04DA
//------------------------------
L_BRS_($C646)_($C67C) JAM
L_BRS_($C646)_($C680) JAM
//------------------------------
$C646            .byte $03
$C647  0D 0D 03  ORA $030D
$C64A            .byte $03,$03
$C64C  0D 03 07  ORA $0703
$C64F            .byte $07,$07,$0F,$DA,$04,$07,$03,$03
$C657            .byte $03,$DA
$C659  10 0F     BPL L_BRS_($C66A)_($C659) OK
$C65B            .byte $DA
$C65C  20 07 03  JSR $0307
$C65F            .byte $DA,$04,$07,$0F,$DA,$13,$07
$C666  AA        TAX 
$C667  AA        TAX 
$C668  9A        TXS 
$C669  9A        TXS 
//------------------------------
L_BRS_($C66A)_($C659) OK
//------------------------------
$C66A  9A        TXS 
$C66B  88        DEY 
$C66C  B0 9A     BCS L_BRS_($C608)_($C66C) BAD
$C66E  A2 88     LDX #$88
$C670  88        DEY 
$C671            .byte $92
$C672  9A        TXS 
$C673  9A        TXS 
$C674            .byte $92
$C675  9A        TXS 
$C676  A2 9A     LDX #$9A
$C678  A2 D2     LDX #$D2
$C67A  E0 D0     CPX #$D0
$C67C  B0 C8     BCS L_BRS_($C646)_($C67C) JAM
$C67E  C4 C4     CPY $C4 
$C680  B0 C4     BCS L_BRS_($C646)_($C680) JAM
$C682  CE CE B0  DEC $B0CE 
$C685  CA        DEX 
$C686  05 00     ORA $00
$C688            .byte $02
$C689  35 42     AND $42,X 
$C68B  0E 02 34  ASL $3402 
$C68E  65 6A     ADC $6A 
//------------------------------
L_BRS_($C690)_($C706) JAM
//------------------------------
$C690            .byte $00,$34
$C692  69 0E     ADC #$0E
$C694            .byte $80
$C695  85 1A     STA $1A 
$C697  96 9D     STX $9D,Y 
$C699            .byte $00,$34
$C69B  65 6A     ADC $6A 
$C69D  69 0E     ADC #$0E
$C69F            .byte $02
$C6A0  E6 E5     INC $E5 
$C6A2  E4 E3     CPX $E3 
$C6A4            .byte $E2
$C6A5  E1 E0     SBC ($E0,X) 
$C6A7            .byte $DF,$DA
$C6A9  05 00     ORA $00
$C6AB  28        PLP 
$C6AC            .byte $2F
$C6AD  D6 D5     DEC $D5,X 
$C6AF            .byte $D4,$D3,$D2
$C6B2  D1 D0     CMP ($D0),Y 
//------------------------------
L_BRS_($C6B6)_($C704) JAM
//------------------------------
$C6B4            .byte $CF,$DA,$14,$00,$14,$1A,$22,$00
$C6BC            .byte $37,$42
$C6BE  39 52 4C  AND $4C52,Y 
$C6C1            .byte $00,$00,$1A
$C6C4  6E 00 00  ROR $0000 
$C6C7            .byte $7F,$00,$00,$00
$C6CB  96 99     STX $99,Y 
$C6CD            .byte $14
$C6CE  A6 AD     LDX $AD 
$C6D0            .byte $00,$00,$1A
$C6D3  40        RTI 
//------------------------------
$C6D4  35 11     AND $11,X 
$C6D6            .byte $DA
$C6D7  16 00     ASL $00,X 
$C6D9  18        CLC 
$C6DA            .byte $DA
$C6DB  06 00     ASL $00 
//------------------------------
L_BRS_($C6DF)_($C719) BAD
//------------------------------
$C6DD  0D DA 04  ORA $04DA
$C6E0            .byte $03
$C6E1  0D 0D 03  ORA $030D
$C6E4            .byte $03,$03
$C6E6  0D 03 DA  ORA $DA03
$C6E9            .byte $04,$07,$0F,$07,$07,$07,$03,$03
$C6F1            .byte $03,$DA
$C6F3  10 0F     BPL L_BRS_($C704)_($C6F3) OK
$C6F5            .byte $DA
$C6F6  20 07 03  JSR $0307
$C6F9            .byte $07,$07,$07,$0F,$DA,$14,$07
$C700  AA        TAX 
$C701  AA        TAX 
$C702  9A        TXS 
$C703  9A        TXS 
//------------------------------
L_BRS_($C704)_($C6F3) OK
//------------------------------
$C704  B0 B0     BCS L_BRS_($C6B6)_($C704) JAM
$C706  B0 88     BCS L_BRS_($C690)_($C706) JAM
$C708            .byte $92,$92,$92,$DA,$04
$C70D  A2 88     LDX #$88
$C70F  88        DEY 
$C710  A2 92     LDX #$92
$C712  C4 C4     CPY $C4 
$C714  C4 B0     CPY $B0 
$C716  CA        DEX 
$C717  C4 C4     CPY $C4 
$C719  B0 C4     BCS L_BRS_($C6DF)_($C719) BAD
$C71B  CE CE B0  DEC $B0CE 
$C71E  C4 06     CPY $06 
$C720  16 25     ASL $25,X 
$C722  36 43     ROL $43,X 
$C724  4E 02 5D  LSR $5D02 
$C727  15 15     ORA $15,X
$C729  6C 71 69  JMP ($6971) 
$C72C  0E 0E 86  ASL $860E 
$C72F            .byte $1A,$1A,$9E
$C732  A8        TAY 
$C733            .byte $00,$00,$00
$C736  69 0E     ADC #$0E
$C738            .byte $02,$DA
$C73A  06 2B     ASL $2B 
$C73C  01 01     ORA ($01,X)
$C73E  0E 13 0E  ASL $0E13 
$C741            .byte $13
$C742  0E 28 2F  ASL $2F28 
$C745            .byte $DA
$C746  08        PHP 
$C747  01 44     ORA ($44,X)
$C749            .byte $47,$44,$47,$44,$DA
$C74E  05 00     ORA $00
$C750  5D 69 47  EOR $4769,X 
$C753  69 47     ADC #$47
$C755  05 0B     ORA $0B
$C757  05 0B     ORA $0B
$C759  05 15     ORA $15
$C75B            .byte $1A,$00
$C75D  2C 38 39  BIT $3938 
$C760  39 53 00  AND $0053,Y 
$C763            .byte $00,$00,$1A,$6F,$67,$67,$80,$14
$C76B            .byte $00,$00
$C76D  96 99     STX $99,Y 
$C76F            .byte $14
$C770  A6 AD     LDX $AD 
$C772            .byte $00,$00,$1A
$C775  50 0A     BVC L_BRS_($C781)_($C775) JAM
$C777  11 DA     ORA ($DA),Y
$C779  16 00     ASL $00,X 
$C77B  18        CLC 
$C77C            .byte $44,$DA
$C77E  05 00     ORA $00
//------------------------------
L_BRS_($C781)_($C775) JAM
//------------------------------
$C780            .byte $DA,$0C
$C782  0D DA 05  ORA $05DA
$C785            .byte $07,$0F,$DA
$C788  05 07     ORA $07
$C78A            .byte $DA
$C78B  10 0F     BPL L_BRS_($C79C)_($C78B) JAM
$C78D            .byte $DA,$23,$07,$0F,$DA
$C792  15 07     ORA $07,X
$C794  BA        TSX 
$C795            .byte $B8
$C796  84 BE     STY $BE 
$C798            .byte $82
$C799  BE BE 84  LDX $84BE,Y 
//------------------------------
L_BRS_($C79C)_($C78B) JAM
//------------------------------
$C79C            .byte $82
$C79D  84 86     STY $86 
$C79F            .byte $82
$C7A0  86 80     STX $80 
$C7A2  84 80     STY $80 
$C7A4  BE 84 BE  LDX $BE84,Y 
$C7A7  BE D6 DA  LDX $DAD6,Y 
$C7AA  01 DA     ORA ($DA,X)
$C7AC  BE BA DA  LDX $DABA,Y 
$C7AF  05 BE     ORA $BE
$C7B1  C4 BC     CPY $BC 
$C7B3  BE 07 17  LDX $1707,Y 
$C7B6  26 37     ROL $37 
$C7B8            .byte $44,$4F
$C7BA  59 5E 66  EOR $665E,Y 
$C7BD  66 6D     ROR $6D 
$C7BF            .byte $72
$C7C0  69 0E     ADC #$0E
$C7C2  0E 87 7D  ASL $7D87 
$C7C5            .byte $1A,$1A,$5C,$00,$00,$00
$C7CB  69 0E     ADC #$0E
$C7CD            .byte $02,$00,$00,$00,$D2,$D7,$D2,$04
$C7D5  09 04     ORA #$04
$C7D7  09 04     ORA #$04
$C7D9  09 04     ORA #$04
$C7DB  28        PLP 
$C7DC            .byte $2F,$00,$00
$C7DF  09 04     ORA #$04
$C7E1  09 04     ORA #$04
$C7E3  39 3F 45  AND $453F,Y 
$C7E6            .byte $3F
$C7E7  45 3F     EOR $3F 
$C7E9  45 3F     EOR $3F 
$C7EB            .byte $DA,$04,$00
$C7EE  5E 45 3F  LSR $3F45,X 
$C7F1  45 3F     EOR $3F 
$C7F3  06 0C     ASL $0C 
$C7F5  06 0C     ASL $0C 
$C7F7  06 0C     ASL $0C 
$C7F9            .byte $1A,$00
$C7FB  2D 39 39  AND $3939 
$C7FE  4C 54 00  JMP $0054
$C801            .byte $00,$00,$1A,$6F,$67,$67
$C807  81 14     STA ($14,X) 
$C809            .byte $00,$00
$C80B  96 9A     STX $9A,Y 
$C80D            .byte $9E
$C80E  A6 AD     LDX $AD 
$C810            .byte $00,$00,$1A
$C813  58        CLI 
$C814  0A        ASL A 
$C815  11 DA     ORA ($DA),Y
$C817  16 00     ASL $00,X 
$C819  18        CLC 
$C81A            .byte $44,$DA
$C81C  05 00     ORA $00
$C81E            .byte $DA,$0C
$C820  0D DA 06  ORA $06DA
$C823            .byte $07,$0F,$DA,$04,$07,$DA
$C829  10 0F     BPL L_BRS_($C83A)_($C829) OK
$C82B            .byte $DA,$22,$07,$0F,$DA
$C830  16 07     ASL $07,X 
$C832  BC BC C4  LDY $C4BC,X 
$C835  84 84     STY $84 
$C837  9A        TXS 
$C838  86 86     STX $86 
//------------------------------
L_BRS_($C83A)_($C829) OK
//------------------------------
$C83A  84 82     STY $82 
$C83C            .byte $DA,$04
$C83E  84 86     STY $86 
$C840            .byte $82,$82
$C842  86 86     STX $86 
$C844  DE BE BE  DEC $BEBE,X 
$C847  BE BC C4  LDX $C4BC,Y 
$C84A  BC DA 04  LDY $04DA,X 
$C84D  C4 BC     CPY $BC 
$C84F  C4 08     CPY $08 
$C851  18        CLC 
$C852            .byte $27
$C853  38        SEC 
$C854  45 50     EOR $50 
$C856            .byte $5A,$2B,$2B,$2B
$C85A  6E 73 76  ROR $7673 
$C85D            .byte $7C
$C85E  81 88     STA ($88,X) 
$C860            .byte $8F,$97,$9F
$C863  A9 2B     LDA #$2B
$C865            .byte $2B,$2B,$BF
$C868  C4 DA     CPY $DA 
$C86A            .byte $04,$2B,$D3
$C86D  D8        CLD 
$C86E            .byte $D3
$C86F  05 0A     ORA $0A
$C871  05 0A     ORA $0A
$C873  05 0A     ORA $0A
$C875  05 29     ORA $29
$C877  30 01     BMI L_BRS_($C87A)_($C877) BAD
//------------------------------
L_BRS_($C87A)_($C877) BAD
//------------------------------
$C879  01 0A     ORA ($0A,X)
$C87B  05 0A     ORA $0A
$C87D  05 3A     ORA $3A
$C87F  40        RTI 
//------------------------------
$C880            .byte $3A
$C881  40        RTI 
//------------------------------
$C882            .byte $3A
$C883  40        RTI 
//------------------------------
$C884            .byte $3A
$C885  40        RTI 
//------------------------------
$C886            .byte $DA,$04
//------------------------------
L_BRS_($C888)_($C8EE) OK
//------------------------------
$C888  01 5F     ORA ($5F,X)
$C88A            .byte $3A
$C88B  40        RTI 
//------------------------------
$C88C            .byte $3A
$C88D  40        RTI 
//------------------------------
$C88E            .byte $07
$C88F  0D 07 0D  ORA $0D07
$C892            .byte $07
$C893  0D 1B 01  ORA $011B
$C896  2E 3A 43  ROL $433A 
$C899  4D 55 5A  EOR $5A55 
$C89C  5E 61 66  LSR $6661,X 
$C89F            .byte $6F,$67,$67
$C8A2  81 14     STA ($14,X) 
$C8A4            .byte $00,$00
$C8A6  96 9B     STX $9B,Y 
$C8A8            .byte $9F
$C8A9  A6 AE     LDX $AE 
$C8AB            .byte $00,$00,$1A
$C8AE  60        RTS 
//------------------------------
$C8AF  0A        ASL A 
$C8B0  11 DA     ORA ($DA),Y
$C8B2  16 00     ASL $00,X 
$C8B4  18        CLC 
$C8B5            .byte $44,$DA
$C8B7  05 00     ORA $00
$C8B9            .byte $DA,$0C
$C8BB  0D DA 0B  ORA $0BDA
$C8BE            .byte $07,$DA
$C8C0  10 0F     BPL L_BRS_($C8D1)_($C8C0) OK
$C8C2            .byte $DA
$C8C3  39 07 B8  AND $B807,Y 
$C8C6  C6 82     DEC $82 
$C8C8  BE CA 80  LDX $80CA,Y 
$C8CB  84 DA     STY $DA 
$C8CD  06 80     ASL $80 
$C8CF  86 80     STX $80 
//------------------------------
L_BRS_($C8D1)_($C8C0) OK
//------------------------------
$C8D1  84 80     STY $80 
$C8D3  C4 80     CPY $80 
$C8D5            .byte $DA,$04
$C8D7  BE BC BC  LDX $BCBC,Y 
$C8DA  C4 BC     CPY $BC 
$C8DC  BC C4 C4  LDY $C4C4,X 
$C8DF  BC BC 09  LDY $09BC,X 
$C8E2  19 09 00  ORA $0009,Y
$C8E5  46 51     LSR $51 
$C8E7            .byte $DA
$C8E8  06 00     ASL $00 
$C8EA            .byte $77,$1A,$82,$89
$C8EE  90 98     BCC L_BRS_($C888)_($C8EE) OK
$C8F0            .byte $00,$00,$00
$C8F3  19 0E 0E  ORA $0E0E,Y
$C8F6  0E 02 5F  ASL $5F02 
$C8F9            .byte $00
$C8FA  55 00     EOR $00,X 
$C8FC            .byte $62
$C8FD  19 06 0B  ORA $0B06,Y
$C900            .byte $0B,$14,$14
$C903  1D DA 16  ORA $16DA,X
$C906            .byte $00
$C907  6A        ROR A 
$C908            .byte $00,$00
$C90A  6A        ROR A 
$C90B            .byte $00
$C90C  0E 00 11  ASL $1100 
$C90F            .byte $00,$14,$00,$1A,$00,$00,$44
$C916  4E 56 5B  LSR $5B56 
$C919            .byte $14,$62,$67,$6F,$67,$67
$C91F  81 14     STA ($14,X) 
$C921            .byte $00,$00
$C923  96 9B     STX $9B,Y 
$C925  A0 A7     LDY #$A7
$C927            .byte $AF,$00,$00,$1A
$C92B  48        PHA 
$C92C  0A        ASL A 
$C92D  11 DA     ORA ($DA),Y
$C92F  16 00     ASL $00,X 
$C931  18        CLC 
$C932            .byte $44,$DA
$C934  05 00     ORA $00
$C936            .byte $DA
$C937  06 01     ASL $01 
$C939            .byte $DA,$07,$07,$0F,$DA,$0C,$07,$67
$C941            .byte $07,$27,$07,$67,$DA,$04,$07
$C948  0D 07 07  ORA $0707
$C94B            .byte $DA,$17
$C94D  0D DA 04  ORA $04DA
$C950            .byte $07,$67,$07,$27,$DA
$C955  0A        ASL A 
$C956            .byte $07,$0F,$DA
$C959  11 07     ORA ($07),Y
$C95B            .byte $DA,$04
$C95D  BC 86 82  LDY $8286,X 
$C960            .byte $82,$82
$C962  86 86     STX $86 
$C964            .byte $82
$C965  86 82     STX $82 
$C967            .byte $82,$82
$C969  86 86     STX $86 
$C96B  BC 82 BE  LDY $BE82,X 
$C96E  BE BE DA  LDX $DABE,Y 
$C971  06 BC     ASL $BC 
$C973  C4 C4     CPY $C4 
$C975  BC BC 09  LDY $09BC,X 
$C978  19 28 39  ORA $3928,Y
$C97B            .byte $47,$52,$DA
$C97E  06 00     ASL $00 
$C980  78        SEI 
$C981            .byte $1A,$1A
$C983  8A        TXA 
$C984  91 99     STA ($99),Y 
$C986  A0 00     LDY #$00
$C988            .byte $00
$C989  19 BB 94  ORA $94BB,Y
$C98C  0E 02 DA  ASL $DA02 
$C98F  05 00     ORA $00
$C991  19 06 0B  ORA $0B06,Y
$C994            .byte $0B,$14
$C996  18        CLC 
$C997  1E DA 16  ASL $16DA,X 
$C99A            .byte $00
$C99B  6A        ROR A 
$C99C            .byte $00,$00
$C99E  6A        ROR A 
$C99F            .byte $DA
$C9A0  05 00     ORA $00
$C9A2            .byte $14,$1C,$23,$00,$3B
$C9A7  45 4F     EOR $4F 
$C9A9            .byte $57
$C9AA  39 39 63  AND $6339,Y 
$C9AD            .byte $67,$6F,$67,$67
$C9B1  81 14     STA ($14,X) 
$C9B3            .byte $00,$00
$C9B5  96 9B     STX $9B,Y 
$C9B7  A1 A8     LDA ($A8,X) 
$C9B9  B0 00     BCS L_BRS_($C9BB)_($C9B9) JAM
//------------------------------
L_BRS_($C9BB)_($C9B9) JAM
//------------------------------
$C9BB            .byte $00,$1A
$C9BD  20 44 11  JSR L_JSR_($1144)_($C9BD) OK
$C9C0            .byte $DA
$C9C1  16 00     ASL $00,X 
$C9C3  18        CLC 
$C9C4  48        PHA 
$C9C5            .byte $DA
$C9C6  05 00     ORA $00
$C9C8            .byte $DA
$C9C9  06 01     ASL $01 
$C9CB            .byte $DA
$C9CC  08        PHP 
$C9CD            .byte $07,$0F,$DA,$14,$07
$C9D2  0D 07 07  ORA $0707
$C9D5            .byte $DA,$17
$C9D7  0D DA 10  ORA $10DA
$C9DA            .byte $07,$0F,$DA,$12,$07
$C9DF  AE AE 9E  LDX $9EAE 
$C9E2            .byte $9E
$C9E3  A6 B4     LDX $B4 
$C9E5  B4 8E     LDY $8E,X 
$C9E7  A6 96     LDX $96 
$C9E9  96 A6     STX $A6,Y 
$C9EB  A6 B4     LDX $B4 
$C9ED  B4 8E     LDY $8E,X 
$C9EF  8E A6 96  STX $96A6 
$C9F2            .byte $DC
$C9F3  C4 C4     CPY $C4 
$C9F5            .byte $DA
$C9F6  0A        ASL A 
$C9F7  B6 0A     LDX $0A,Y 
$C9F9            .byte $1A
$C9FA  09 00     ORA #$00
$C9FC  46 51     LSR $51 
$C9FE            .byte $DA
$C9FF  06 00     ASL $00 
$CA01  09 7D     ORA #$7D
$CA03            .byte $1A,$1A,$92
$CA06  9A        TXS 
$CA07  A1 AA     LDA ($AA,X) 
$CA09            .byte $00
$CA0A  7D BC 69  ADC $69BC,X 
$CA0D  0E 02 DA  ASL $DA02 
$CA10  05 00     ORA $00
$CA12  19 06 0B  ORA $0B06,Y
$CA15            .byte $0C
$CA16  15 19     ORA $19,X
$CA18            .byte $1F,$DA
$CA1A  11 15     ORA ($15),Y
$CA1C  49 4D     EOR #$4D
$CA1E            .byte $53
$CA1F  15 60     ORA $60,X
$CA21  15 71     ORA $71,X
$CA23            .byte $00
$CA24  6A        ROR A 
$CA25            .byte $DA
$CA26  05 00     ORA $00
$CA28            .byte $14,$1A
$CA2A  24 2F     BIT $2F 
$CA2C            .byte $3C
$CA2D  3D 46 39  AND $3946,X 
$CA30  39 4C 1A  AND $1A4C,Y 
$CA33            .byte $67,$6F,$67,$67
$CA37  81 86     STA ($86,X) 
$CA39  8C 91 96  STY $9691 
$CA3C            .byte $9B
$CA3D  A2 A9     LDX #$A9
$CA3F  B1 B6     LDA ($B6),Y 
$CA41            .byte $00,$1A
$CA43  30 19     BMI L_BRS_($CA5E)_($CA43) BAD
$CA45  11 DA     ORA ($DA),Y
$CA47  16 00     ASL $00,X 
$CA49  18        CLC 
$CA4A  48        PHA 
$CA4B            .byte $DA
$CA4C  05 00     ORA $00
$CA4E            .byte $DA
$CA4F  06 01     ASL $01 
$CA51            .byte $DA
$CA52  09 07     ORA #$07
$CA54  01 DA     ORA ($DA,X)
$CA56            .byte $3C,$07
$CA58  01 DA     ORA ($DA,X)
$CA5A            .byte $13,$07
//------------------------------
L_BRS_($CA5E)_($CA43) BAD
//------------------------------
$CA5C  AC AC 9C  LDY $9CAC 
$CA5F            .byte $9C,$B2
$CA61  8C B2 9C  STY $9CB2 
$CA64  94 94     STY $94,X 
$CA66  94 A4     STY $A4,X 
$CA68            .byte $B2,$B2
$CA6A  A4 9C     LDY $9C 
$CA6C  8C A4 94  STY $94A4 
$CA6F  C4 C4     CPY $C4 
$CA71  D8        CLD 
$CA72  C0 C2     CPY #$C2
//------------------------------
L_BRS_($CA74)_($CAE2) OK
//------------------------------
$CA74  C0 C0     CPY #$C0
$CA76  C0 C2     CPY #$C2
$CA78            .byte $C2,$C2
$CA7A  C0 C2     CPY #$C2
//------------------------------
L_BRS_($CA7C)_($CAEA) OK
//------------------------------
$CA7C  09 19     ORA #$19
$CA7E  09 00     ORA #$00
$CA80  48        PHA 
$CA81            .byte $53,$DA
$CA83  06 00     ASL $00 
$CA85  09 00     ORA #$00
$CA87  7D 1A 1A  ADC $1A1A,X 
$CA8A            .byte $92
$CA8B  9A        TXS 
$CA8C            .byte $AB
$CA8D  B1 00     LDA ($00),Y 
$CA8F            .byte $00
$CA90  69 0E     ADC #$0E
//------------------------------
L_BRS_($CA92)_($CAE0) JAM
//------------------------------
$CA92            .byte $02,$DA
$CA94  05 00     ORA $00
$CA96  19 06 0C  ORA $0C06,Y
$CA99            .byte $DA
$CA9A  15 00     ORA $00,X
$CA9C  4A        LSR A 
$CA9D            .byte $00,$00,$57
$CAA0  61 6B     ADC ($6B,X) 
$CAA2            .byte $1F
$CAA3  71 6A     ADC ($6A),Y 
$CAA5            .byte $DA
$CAA6  05 00     ORA $00
$CAA8            .byte $14,$1A
$CAAA  25 30     AND $30
$CAAC  3D 46 39  AND $3946,X 
$CAAF  39 4C 00  AND $004C,Y 
$CAB2            .byte $1A
$CAB3  68        PLA 
$CAB4  70 68     BVS L_BRS_($CB1E)_($CAB4) JAM
$CAB6  68        PLA 
$CAB7            .byte $82,$87
$CAB9  8D 92 96  STA $9692 
$CABC            .byte $9B,$A3
$CABE  AA        TAX 
$CABF            .byte $B2,$B7,$00,$1A
$CAC3  10 42     BPL L_BRS_($CB07)_($CAC3) OK
$CAC5  11 DA     ORA ($DA),Y
$CAC7  16 00     ASL $00,X 
$CAC9  18        CLC 
$CACA  48        PHA 
$CACB            .byte $DA
$CACC  05 00     ORA $00
$CACE            .byte $DA
$CACF  06 01     ASL $01 
$CAD1            .byte $DA
$CAD2  0A        ASL A 
$CAD3            .byte $07
$CAD4  01 DA     ORA ($DA,X)
$CAD6            .byte $3A,$07
$CAD8  01 DA     ORA ($DA,X)
$CADA            .byte $14,$07
$CADC  AA        TAX 
$CADD  AA        TAX 
$CADE  A0 A0     LDY #$A0
$CAE0  B0 B0     BCS L_BRS_($CA92)_($CAE0) JAM
$CAE2  B0 90     BCS L_BRS_($CA74)_($CAE2) OK
$CAE4  98        TYA 
$CAE5  98        TYA 
$CAE6  98        TYA 
$CAE7            .byte $DA,$04
$CAE9  A8        TAY 
$CAEA  90 90     BCC L_BRS_($CA7C)_($CAEA) OK
$CAEC  A8        TAY 
$CAED  98        TYA 
$CAEE  C4 D4     CPY $D4 
$CAF0            .byte $DA,$0B
$CAF2  C4 0B     CPY $0B 
$CAF4            .byte $1B
$CAF5  29 3A     AND #$3A
$CAF7  46 51     LSR $51 
$CAF9            .byte $DA
$CAFA  06 00     ASL $00 
$CAFC  09 00     ORA #$00
$CAFE            .byte $00
$CAFF  7D 1A 1A  ADC $1A1A,X 
$CB02  A2 AC     LDX #$AC
$CB04            .byte $B2,$00,$00
//------------------------------
L_BRS_($CB07)_($CAC3) OK
//------------------------------
$CB07  69 0E     ADC #$0E
$CB09            .byte $02,$DA
$CB0B  05 00     ORA $00
$CB0D  19 07 00  ORA $0007,Y
$CB10            .byte $00,$00,$1A,$DA,$0B
$CB15  20 41 DA  JSR L_JSR_($DA41)_($CB15) JAM
$CB18  06 00     ASL $00 
$CB1A            .byte $4B
$CB1B  4E 54 58  LSR $5854 
//------------------------------
L_BRS_($CB1E)_($CAB4) JAM
//------------------------------
$CB1E            .byte $62
$CB1F  6C 00 1F  JMP ($1F00) 
$CB22  78        SEI 
$CB23            .byte $DA
$CB24  05 00     ORA $00
$CB26            .byte $14,$1A
$CB28  26 31     ROL $31 
$CB2A  3E 39 39  ROL $3939,X 
$CB2D  4C 00 00  JMP $0000
$CB30            .byte $1A
$CB31  01 2E     ORA ($2E,X)
$CB33  01 01     ORA ($01,X)
$CB35            .byte $83
$CB36  88        DEY 
$CB37  8E 93 97  STX $9793 
$CB3A            .byte $9B,$00,$00,$B3,$14,$00,$1A,$7F
$CB42  A0 11     LDY #$11
$CB44            .byte $DA,$12,$00
$CB47  E5 40     SBC $40 
$CB49  E5 40     SBC $40 
$CB4B  18        CLC 
$CB4C  48        PHA 
$CB4D            .byte $DA
$CB4E  05 00     ORA $00
$CB50            .byte $DA
$CB51  06 01     ASL $01 
$CB53            .byte $DA,$0B,$07
$CB56  01 DA     ORA ($DA,X)
$CB58  38        SEC 
$CB59            .byte $07
$CB5A  01 DA     ORA ($DA,X)
$CB5C  15 07     ORA $07,X
$CB5E            .byte $DA
$CB5F  20 8A 09  JSR L_JSR_($098A)_($CB5F) OK
$CB62  19 09 3B  ORA $3B09,Y
$CB65  49 54     EOR #$54
$CB67            .byte $DA
$CB68  06 2B     ASL $2B 
$CB6A  09 00     ORA #$00
$CB6C            .byte $00,$00
$CB6E  7D 1A 1A  ADC $1A1A,X 
$CB71  AD B3 2B  LDA $2BB3 
$CB74            .byte $2B
$CB75  C0 C5     CPY #$C5
$CB77            .byte $DA,$07,$2B,$DA,$04
$CB7C  01 1B     ORA ($1B,X)
$CB7E  21 25     AND ($25,X) 
$CB80  25 31     AND $31
$CB82  25 25     AND $25
$CB84  25 35     AND $35
$CB86  25 25     AND $25
$CB88            .byte $3B,$DA
$CB8A  08        PHP 
$CB8B  01 4F     ORA ($4F,X)
$CB8D  55 59     EOR $59,X 
$CB8F            .byte $63
$CB90  6D DA 08  ADC $08DA 
$CB93  01 16     ORA ($16,X)
$CB95  1D 27 32  ORA $3227,X
$CB98  39 39 4C  AND $4C39,Y 
$CB9B            .byte $00,$00,$00,$1A,$DA
$CBA0  0A        ASL A 
$CBA1  01 A4     ORA ($A4,X)
$CBA3            .byte $AB
$CBA4  B4 B8     LDY $B8,X 
$CBA6            .byte $00,$1A,$7F
$CBA9  A0 11     LDY #$11
$CBAB            .byte $DA,$12,$00
$CBAE  E5 40     SBC $40 
$CBB0  E5 40     SBC $40 
$CBB2  18        CLC 
$CBB3  48        PHA 
$CBB4            .byte $DA
$CBB5  05 00     ORA $00
$CBB7            .byte $DA
$CBB8  06 0F     ASL $0F 
$CBBA            .byte $DA,$0C,$07
$CBBD  01 DA     ORA ($DA,X)
$CBBF  36 07     ROL $07,X 
$CBC1  01 DA     ORA ($DA,X)
$CBC3  16 07     ASL $07,X 
$CBC5            .byte $DA
$CBC6  20 8A 0C  JSR L_JSR_($0C8A)_($CBC6) OK
$CBC9            .byte $1C
$CBCA  2A        ROL A 
$CBCB            .byte $DA,$14,$2B
$CBCE  C1 DA     CMP ($DA,X) 
$CBD0  08        PHP 
$CBD1            .byte $2B,$DA
$CBD3  05 01     ORA $01
$CBD5            .byte $22,$DA
$CBD7  09 26     ORA #$26
$CBD9            .byte $3C,$DA
$CBDB  08        PHP 
$CBDC  01 50     ORA ($50,X)
$CBDE  01 50     ORA ($50,X)
$CBE0            .byte $64
$CBE1  6E DA 20  ROR $20DA 
$CBE4  01 B9     ORA ($B9,X)
$CBE6  A4 BF     LDY $BF 
$CBE8            .byte $00
$CBE9  30 11     BMI L_BRS_($CBFC)_($CBE9) JAM
$CBEB            .byte $DA,$12,$00
$CBEE  A8        TAY 
$CBEF            .byte $43
$CBF0  A8        TAY 
$CBF1            .byte $43
$CBF2  18        CLC 
$CBF3  48        PHA 
$CBF4            .byte $DA
$CBF5  05 00     ORA $00
$CBF7            .byte $DA
$CBF8  06 0F     ASL $0F 
//------------------------------
L_BRS_($CBFC)_($CBE9) JAM
//------------------------------
$CBFA            .byte $DA,$5A,$07
$CBFD  26 06     ROL $06 
$CBFF            .byte $04,$14
$CC01  45 45     EOR $45 
$CC03  45 22     EOR $22 
$CC05  01 11     ORA ($11,X)
$CC07  31 33     AND ($33),Y 
$CC09            .byte $03,$23,$13,$02,$22,$13
$CC0F  31 DA     AND ($DA),Y 
$CC11  0D 47 DA  ORA $DA47
$CC14  0D 00 47  ORA $4700
$CC17            .byte $DA,$1F,$00,$47,$DA,$0F,$00,$47
$CC1F            .byte $DA,$0B,$00
$CC22  66 00     ROR $00 
$CC24  66 74     ROR $74 
$CC26            .byte $74,$00,$00,$00,$5A,$00,$5A
$CC2D  4C 4C 00  JMP $004C
$CC30            .byte $00,$00
$CC32  09 00     ORA #$00
$CC34  09 DA     ORA #$DA
$CC36  05 00     ORA $00
$CC38            .byte $27,$00,$27,$DA,$04,$00,$43
$CC3F  41 53     EOR ($53,X) 
$CC41            .byte $54
$CC42  20 4F 46  JSR L_JSR_($464F)_($CC42) JAM
$CC45  20 43 48  JSR L_JSR_($4843)_($CC45) JAM
$CC48  41 52     EOR ($52,X) 
$CC4A  41 43     EOR ($43,X) 
$CC4C            .byte $54
$CC4D  45 52     EOR $52 
$CC4F            .byte $53,$DA
$CC51  4E 00 BB  LSR $BB00 
$CC54  E8        INX 
$CC55            .byte $BB
$CC56  E8        INX 
$CC57            .byte $BB,$BB,$00,$00
$CC5B  E4 00     CPX $00 
$CC5D  E4 00     CPX $00 
$CC5F  E4 E4     CPX $E4 
$CC61            .byte $00,$00,$82,$00,$82,$00,$82,$82
$CC69            .byte $00,$00,$9E
$CC6C  E4 9E     CPX $9E 
$CC6E  E4 9E     CPX $9E 
$CC70            .byte $9E,$00,$00
$CC73  79 6F 75  ADC $756F,Y 
$CC76            .byte $72
$CC77  20 6F 77  JSR L_JSR_($776F)_($CC77) BAD
$CC7A  6E 20 6E  ROR $6E20 
$CC7D  61 6D     ADC ($6D,X) 
$CC7F  65 73     ADC $73 
$CC81  20 59 2F  JSR L_JSR_($2F59)_($CC81) BAD
$CC84  4E 3F DA  LSR $DA3F 
$CC87  05 00     ORA $00
$CC89  26 07     ROL $07 
$CC8B  26 07     ROL $07 
$CC8D  26 26     ROL $26 
$CC8F            .byte $00,$00
$CC91  26 39     ROL $39 
$CC93  26 42     ROL $42 
$CC95  45 48     EOR $48 
$CC97            .byte $00,$00,$00
$CC9A  21 00     AND ($00,X) 
$CC9C  21 DA     AND ($DA,X) 
$CC9E  05 00     ORA $00
$CCA0            .byte $17,$00
$CCA2  11 00     ORA ($00),Y
$CCA4            .byte $17,$00,$00
$CCA7  26 29     ROL $29 
$CCA9  26 29     ROL $29 
$CCAB  26 26     ROL $26 
$CCAD            .byte $DA,$04,$00
$CCB0  26 42     ROL $42 
$CCB2  45 48     EOR $48 
$CCB4            .byte $00,$00
$CCB6  26 2F     ROL $2F 
$CCB8  26 2F     ROL $2F 
$CCBA  26 26     ROL $26 
$CCBC            .byte $00,$00
$CCBE  26 39     ROL $39 
$CCC0            .byte $00,$00
$CCC2  45 48     EOR $48 
$CCC4            .byte $00,$00,$00
$CCC7  75 00     ADC $00,X 
$CCC9  75 DA     ADC $DA,X 
$CCCB  05 00     ORA $00
$CCCD  69 00     ADC #$00
$CCCF  69 75     ADC #$75
$CCD1  75 78     ADC $78,X 
$CCD3  78        SEI 
$CCD4            .byte $63
$CCD5  58        CLI 
$CCD6            .byte $63
$CCD7  58        CLI 
$CCD8            .byte $4B,$4B,$00,$00,$00,$0B,$00,$0B
$CCE0  19 19 00  ORA $0019,Y
$CCE3            .byte $00,$1F
$CCE5  2A        ROL A 
$CCE6            .byte $1F
$CCE7  2A        ROL A 
$CCE8            .byte $37,$37,$00,$00
$CCEC  50 52     BVC L_BRS_($CD40)_($CCEC) JAM
$CCEE  45 53     EOR $53 
$CCF0            .byte $53,$27,$43,$27,$54,$4F
$CCF6  20 43 48  JSR L_JSR_($4843)_($CCF6) JAM
$CCF9  41 4E     EOR ($4E,X) 
$CCFB            .byte $47
$CCFC  45 20     EOR $20 
$CCFE  4E 41 4D  LSR $4D41 
$CD01  45 00     EOR $00 
$CD03            .byte $00,$82,$00,$82,$00,$82,$82,$00
$CD0B            .byte $00,$DA
$CD0D  06 82     ASL $82 
$CD0F            .byte $00,$00,$A7,$00,$A7,$00,$A7,$A7
$CD17            .byte $DA
$CD18  0A        ASL A 
$CD19            .byte $00,$82,$00,$82,$00,$82,$82,$DA
$CD21            .byte $04,$00,$DA,$04,$82,$00,$00,$82
$CD29            .byte $00,$82,$00,$82,$82,$00,$00,$82
$CD31            .byte $82,$00,$00,$82,$82,$DA
$CD37  0A        ASL A 
$CD38            .byte $00
$CD39  BD EB BD  LDA $BDEB,X 
$CD3C            .byte $EB
$CD3D  BD BD FA  LDA $FABD,X 
//------------------------------
L_BRS_($CD40)_($CCEC) JAM
//------------------------------
$CD40            .byte $FA
$CD41  E1 E4     SBC ($E4,X) 
$CD43  E1 E4     SBC ($E4,X) 
$CD45  E1 E1     SBC ($E1,X) 
$CD47  C8        INY 
$CD48  C8        INY 
$CD49  84 8D     STY $8D 
$CD4B  84 8D     STY $8D 
$CD4D  84 84     STY $84 
$CD4F            .byte $FF,$FF
$CD51  A1 AC     LDA ($AC,X) 
$CD53  A1 AC     LDA ($AC,X) 
$CD55  A1 A1     LDA ($A1,X) 
$CD57  A9 A9     LDA #$A9
$CD59            .byte $1A,$13,$A7
$CD5C  C8        INY 
$CD5D            .byte $6F
$CD5E  26 D9     ROL $D9 
$CD60  46 24     LSR $24 
$CD62  7E CD E8  ROR $E8CD,X 
$CD65  AD 0D 10  LDA $100D 
$CD68            .byte $F8,$AF
$CD6A  0D CD E8  ORA $E8CD
$CD6D  AD 18 E9  LDA $E918 
$CD70            .byte $00,$03
$CD72  08        PHP 
$CD73            .byte $03
$CD74  08        PHP 
$CD75  11 11     ORA ($11),Y
$CD77            .byte $00,$00,$34,$37,$3C
$CD7C  40        RTI 
//------------------------------
$CD7D  46 46     LSR $46 
$CD7F            .byte $00,$00,$03
$CD82  08        PHP 
$CD83            .byte $03
$CD84  08        PHP 
$CD85  11 11     ORA ($11),Y
$CD87            .byte $00,$00,$00
$CD8A  18        CLC 
$CD8B            .byte $00,$1C,$00
$CD8E  18        CLC 
$CD8F            .byte $00,$00,$03
$CD92  08        PHP 
$CD93            .byte $03
$CD94  08        PHP 
$CD95  11 11     ORA ($11),Y
$CD97            .byte $DA,$04,$00,$3C
$CD9B  40        RTI 
//------------------------------
$CD9C  46 46     LSR $46 
$CD9E            .byte $00,$00,$03
$CDA1  08        PHP 
$CDA2            .byte $03
$CDA3  08        PHP 
$CDA4  11 11     ORA ($11),Y
$CDA6            .byte $00,$00,$34,$37,$00,$00
$CDAC  46 46     LSR $46 
$CDAE            .byte $00,$00
$CDB0  78        SEI 
$CDB1            .byte $73
$CDB2  78        SEI 
$CDB3            .byte $73
$CDB4  70 70     BVS L_BRS_($CE26)_($CDB4) JAM
$CDB6  6C 00 00  JMP ($0000) 
$CDB9  6C 00 6C  JMP ($6C00) 
$CDBC            .byte $00,$00,$7B,$7B
$CDC0  60        RTS 
//------------------------------
$CDC1  56 60     LSR $60,X 
$CDC3  56 60     LSR $60,X 
$CDC5  60        RTS 
//------------------------------
$CDC6            .byte $00,$00,$00
$CDC9  0E 00 0E  ASL $0E00 
$CDCC            .byte $1B,$1B,$00,$00
$CDD0  CD 2D CD  CMP $CD2D 
$CDD3  2D DA 04  AND $04DA 
$CDD6            .byte $00
$CDD7  45 4E     EOR $4E 
$CDD9            .byte $54
$CDDA  45 52     EOR $52 
$CDDC  20 4E 45  JSR L_JSR_($454E)_($CDDC) JAM
$CDDF            .byte $57
$CDE0  20 4E 41  JSR L_JSR_($414E)_($CDE0) BAD
$CDE3  4D 45 DA  EOR $DA45 
$CDE6  0A        ASL A 
$CDE7            .byte $00
$CDE8  85 00     STA $00 
$CDEA  85 00     STA $00 
$CDEC            .byte $92,$92,$97,$00
$CDF0  B6 B8     LDX $B8,Y 
$CDF2            .byte $DA,$04
$CDF4  85 00     STA $00 
$CDF6            .byte $00
$CDF7  85 00     STA $00 
$CDF9  85 00     STA $00 
$CDFB            .byte $92,$92
$CDFD  A4 DA     LDY $DA 
$CDFF  09 00     ORA #$00
$CE01  85 00     STA $00 
$CE03  85 00     STA $00 
$CE05            .byte $92,$92
$CE07  AC 00 00  LDY $0000 
$CE0A            .byte $00,$DA,$04
$CE0D  85 00     STA $00 
$CE0F            .byte $00
$CE10  85 00     STA $00 
$CE12  85 00     STA $00 
$CE14            .byte $92,$92,$B2,$00
$CE18  B6 B8     LDX $B8,Y 
$CE1A            .byte $00,$00
$CE1C  85 85     STA $85 
$CE1E            .byte $00,$00
$CE20  F6 00     INC $00,X 
$CE22  F6 DA     INC $DA,X 
$CE24  05 00     ORA $00
//------------------------------
L_BRS_($CE26)_($CDB4) JAM
//------------------------------
$CE26            .byte $BF
$CE27  EE BF EE  INC $EEBF 
$CE2A            .byte $BF,$BF
$CE2C  FD FD DE  SBC $DEFD,X 
$CE2F            .byte $D4
$CE30  DE D4 DE  DEC $DED4,X 
$CE33  DE C6 C6  DEC $C6C6,X 
$CE36  86 90     STX $90 
$CE38  86 90     STX $90 
$CE3A  86 86     STX $86 
$CE3C  CA        DEX 
$CE3D  CA        DEX 
$CE3E  A4 AF     LDY $AF 
$CE40  A4 AF     LDY $AF 
$CE42  A4 A4     LDY $A4 
$CE44  B4 B4     LDY $B4,X 
$CE46  A9 8F     LDA #$8F
$CE48  85 D7     STA $D7 
$CE4A  A9 47     LDA #$47
$CE4C  85 4F     STA $4F 
$CE4E  A5 72     LDA $72 
$CE50  85 4E     STA $4E 
$CE52  A0 0B     LDY #$0B
$CE54  A9 00     LDA #$00
//------------------------------
L_BRS_($CE56)_($CE59) OK
//------------------------------
$CE56  91 4E     STA ($4E),Y 
$CE58  88        DEY 
$CE59  10 FB     BPL L_BRS_($CE56)_($CE59) OK
$CE5B  60        RTS 
//------------------------------
$CE5C            .byte $00,$00,$00,$0B,$00
$CE61  0E 13 13  ASL $1313 
$CE64  18        CLC 
$CE65            .byte $1B,$00,$00
$CE68  3E 3E DA  ROL $DA3E,X 
$CE6B  05 00     ORA $00
$CE6D            .byte $0B,$00
$CE6F  0E 13 13  ASL $1313 
$CE72  18        CLC 
$CE73            .byte $1B,$00
$CE75  19 00 1D  ORA $1D00,Y
$CE78            .byte $00
$CE79  19 00 00  ORA $0000,Y
$CE7C            .byte $00,$0B,$00
$CE7F  0E 13 13  ASL $1313 
$CE82  18        CLC 
$CE83            .byte $1B,$00,$00
$CE86  3E 3E DA  ROL $DA3E,X 
$CE89  05 00     ORA $00
$CE8B            .byte $0B,$00
$CE8D  0E 13 13  ASL $1313 
$CE90  18        CLC 
$CE91            .byte $1B,$DA,$07,$00,$1B,$00
$CE97  7E 00 7B  ROR $7B00,X 
$CE9A  6E 6E 6A  ROR $6A6E 
$CE9D  68        PLA 
$CE9E            .byte $00,$6F,$00,$6F,$00,$00
$CEA4  45 45     EOR $45 
$CEA6  5D 53 5D  EOR $5D53,X 
$CEA9            .byte $4F
$CEAA  5D 5D 45  EOR $455D,X 
$CEAD  45 00     EOR $00 
$CEAF  11 00     ORA ($00),Y
$CEB1  16 00     ASL $00,X 
$CEB3            .byte $00
$CEB4  45 45     EOR $45 
$CEB6            .byte $00
$CEB7  30 00     BMI L_BRS_($CEB9)_($CEB7) OK
//------------------------------
L_BRS_($CEB9)_($CEB7) OK
//------------------------------
$CEB9  35 00     AND $00,X 
$CEBB            .byte $00
$CEBC  45 45     EOR $45 
$CEBE            .byte $4F
$CEBF  55 52     EOR $52,X 
$CEC1  20 48 45  JSR L_JSR_($4548)_($CEC1) JAM
$CEC4            .byte $52,$4F,$DA
$CEC7  16 00     ASL $00,X 
$CEC9  9A        TXS 
$CECA  9D 00 00  STA $0000,X 
$CECD  85 85     STA $85 
$CECF            .byte $DA
$CED0  0A        ASL A 
$CED1            .byte $00
$CED2  9A        TXS 
$CED3  A5 DA     LDA $DA 
$CED5  0E 00 9A  ASL $9A00 
$CED8  AD 00 00  LDA $0000 
$CEDB  85 85     STA $85 
$CEDD            .byte $DA
$CEDE  0A        ASL A 
$CEDF            .byte $00
$CEE0  9A        TXS 
$CEE1            .byte $B3,$DA,$07,$00,$B3,$DA,$07,$00
$CEE9  E6 C1     INC $C1 
$CEEB  F1 F3     SBC ($F3),Y 
$CEED  F1 C1     SBC ($C1),Y 
$CEEF  C1 C3     CMP ($C3,X) 
$CEF1            .byte $C3,$DB
$CEF3  8D DB CD  STA $CDDB 
$CEF6            .byte $DB,$DB,$C3,$C3
$CEFA  88        DEY 
$CEFB            .byte $93
$CEFC  95 98     STA $98,X 
$CEFE  88        DEY 
$CEFF  88        DEY 
$CF00            .byte $C3,$C3
$CF02  A6 B2     LDX $B2 
$CF04  A6 8D     LDX $8D 
$CF06  A6 A6     LDX $A6 
$CF08            .byte $C3,$C3,$B8
$CF0B  C6 D4     DEC $D4 
$CF0D            .byte $E2,$9C
$CF0F  8E AA 80  STX $80AA 
$CF12  40        RTI 
//------------------------------
$CF13  C5 CD     CMP $CD 
$CF15  E8        INX 
$CF16            .byte $AF
$CF17  C1 CD     CMP ($CD,X) 
$CF19            .byte $72
$CF1A  B0 26     BCS L_BRS_($CF42)_($CF1A) JAM
$CF1C  D9 E5 C3  CMP $C3E5,Y 
$CF1F  E8        INX 
$CF20  B1 DA     LDA ($DA),Y 
$CF22  05 00     ORA $00
$CF24  15 DA     ORA $DA,X
$CF26            .byte $0F,$00
$CF28  15 DA     ORA $DA,X
$CF2A            .byte $0F,$00
$CF2C  15 DA     ORA $DA,X
$CF2E            .byte $0F,$00
$CF30  15 DA     ORA $DA,X
$CF32            .byte $13,$00,$3A,$67,$3A,$67,$3A,$3A
$CF3A            .byte $00,$00
$CF3C  65 59     ADC $59 
$CF3E  65 59     ADC $59 
$CF40  65 65     ADC $65 
//------------------------------
L_BRS_($CF42)_($CF1A) JAM
//------------------------------
$CF42            .byte $00,$00
$CF44  01 0A     ORA ($0A,X)
$CF46  01 0A     ORA ($0A,X)
$CF48  01 01     ORA ($01,X)
$CF4A            .byte $00,$00
$CF4C  1D 28 1D  ORA $1D28,X
$CF4F  28        PLP 
$CF50  1D 1D 00  ORA $001D,X
$CF53            .byte $00,$54
$CF55  48        PHA 
$CF56  45 20     EOR $20 
$CF58            .byte $53,$57,$4F,$54,$DA,$14,$00
$CF5F  95 DA     STA $DA,X 
$CF61            .byte $0F,$00
$CF63  95 DA     STA $DA,X 
$CF65            .byte $0F,$00
$CF67  95 DA     STA $DA,X 
$CF69            .byte $0F,$00
$CF6B  95 DA     STA $DA,X 
$CF6D            .byte $13,$00
$CF6F  BA        TSX 
$CF70            .byte $E7
$CF71  BA        TSX 
$CF72            .byte $E7
$CF73  BA        TSX 
$CF74  BA        TSX 
$CF75            .byte $00,$00
$CF77  E5 D9     SBC $D9 
$CF79  E5 D9     SBC $D9 
$CF7B  E5 E5     SBC $E5 
$CF7D            .byte $00,$00
$CF7F  81 8A     STA ($8A,X) 
$CF81  81 8A     STA ($8A,X) 
$CF83  81 81     STA ($81,X) 
$CF85            .byte $00,$00
$CF87  9D A8 9D  STA $9DA8,X 
$CF8A  A8        TAY 
$CF8B  9D 9D 00  STA $009D,X 
$CF8E            .byte $00
$CF8F  A0 0E     LDY #$0E
$CF91  8A        TXA 
$CF92  AA        TAX 
$CF93  88        DEY 
$CF94  88        DEY 
$CF95  10 06     BPL L_BRS_($CF9D)_($CF95) OK
$CF97  8E 10 D0  STX $D010                          // Sprites 0-7 MSB of X coordinate
$CF9A  4C 77 98  JMP L_JMP_($9877)_($CF9A) OK
//------------------------------
L_BRS_($CF9D)_($CF95) OK
//------------------------------
$CF9D  8C E9 92  STY $92E9 
$CFA0  8C EF 92  STY $92EF 
$CFA3  4C E8 92  JMP L_JMP_($92E8)_($CFA3) OK
$CFA6            .byte $00
$CFA7  01 09     ORA ($09,X)
$CFA9  01 09     ORA ($09,X)
$CFAB  01 01     ORA ($01,X)
$CFAD            .byte $00,$00
$CFAF  01 3A     ORA ($3A,X)
$CFB1  01 44     ORA ($44,X)
$CFB3  01 01     ORA ($01,X)
$CFB5            .byte $00,$00
$CFB7  20 22 20  JSR L_JSR_($2022)_($CFB7) BAD
$CFBA            .byte $22
$CFBB  20 20 DA  JSR L_JSR_($DA20)_($CFBB) OK
$CFBE  05 00     ORA $00
$CFC0            .byte $14,$DA,$04,$00
$CFC4  28        PLP 
$CFC5  2A        ROL A 
$CFC6  28        PLP 
$CFC7  2A        ROL A 
$CFC8  28        PLP 
$CFC9  28        PLP 
$CFCA            .byte $DA,$04,$00
$CFCD  28        PLP 
$CFCE            .byte $43
$CFCF  28        PLP 
$CFD0  28        PLP 
$CFD1            .byte $00,$00
$CFD3  2E 30 2E  ROL $2E30 
$CFD6  30 2E     BMI L_BRS_($D006)_($CFD6) JAM
$CFD8  2E 00 00  ROL $0000 
$CFDB  2E 3B 00  ROL $003B 
$CFDE            .byte $00
$CFDF  2E 2E 00  ROL $002E 
$CFE2            .byte $00
$CFE3  79 74 79  ADC $7974,Y 
$CFE6            .byte $74
$CFE7  71 71     ADC ($71),Y 
$CFE9            .byte $00,$00,$3C
$CFEC  6A        ROR A 
$CFED            .byte $3C
$CFEE  6A        ROR A 
$CFEF  76 76     ROR $76,X 
$CFF1  79 79 62  ADC $6279,Y 
$CFF4            .byte $57,$62,$57,$62,$62
//------------------------------
L_BRS_($CFFA)_($D04A) BAD
//------------------------------
$CFF9  49 49     EOR #$49
$CFFB            .byte $03,$0C,$03,$0C,$1A,$1A,$42,$42
$D003  20 2B 20  JSR L_JSR_($202B)_($D003) OK
//------------------------------
L_BRS_($D006)_($CFD6) JAM
//------------------------------
$D006            .byte $2B
$D007  38        SEC 
$D008  38        SEC 
$D009  51 51     EOR ($51),Y 
$D00B            .byte $54
$D00C  48        PHA 
$D00D  45 20     EOR $20 
$D00F            .byte $54
$D010  45 41     EOR $41 
$D012            .byte $52
$D013  41 57     EOR ($57,X) 
$D015  41 59     EOR ($59,X) 
$D017            .byte $DA,$0B,$00
$D01A  49 81     EOR #$81
$D01C            .byte $89
$D01D  81 89     STA ($89,X) 
$D01F  81 81     STA ($81,X) 
$D021            .byte $00,$00
$D023  81 BA     STA ($BA,X) 
$D025  81 C4     STA ($C4,X) 
$D027  81 81     STA ($81,X) 
$D029            .byte $00,$00
$D02B  A0 A2     LDY #$A2
$D02D  A0 A2     LDY #$A2
$D02F  A0 A0     LDY #$A0
$D031            .byte $DA
$D032  05 00     ORA $00
$D034  94 DA     STY $DA,X 
$D036            .byte $04,$00
$D038  A8        TAY 
$D039  AA        TAX 
$D03A  A8        TAY 
$D03B  AA        TAX 
$D03C  A8        TAY 
$D03D  A8        TAY 
$D03E            .byte $DA,$04,$00
$D041  A8        TAY 
$D042            .byte $C3
$D043  A8        TAY 
$D044  A8        TAY 
$D045            .byte $00,$00
$D047  AE B0 AE  LDX $AEB0 
$D04A  B0 AE     BCS L_BRS_($CFFA)_($D04A) BAD
$D04C  AE 00 00  LDX $0000 
$D04F  AE BB 00  LDX $00BB 
$D052            .byte $00
$D053  AE AE 00  LDX $00AE 
$D056            .byte $00
$D057  F9 F4 F9  SBC $F9F4,Y 
$D05A            .byte $F4
$D05B  F1 F1     SBC ($F1),Y 
$D05D            .byte $00,$00
$D05F  BC EA BC  LDY $BCEA,X 
$D062  EA        NOP 
$D063  F6 F6     INC $F6,X 
$D065  F9 F9 E2  SBC $E2F9,Y 
$D068            .byte $D7,$E2,$D7,$E2,$E2
$D06D  C9 C9     CMP #$C9
$D06F            .byte $83
$D070  8C 83 8C  STY $8C83 
$D073  9A        TXS 
$D074  9A        TXS 
$D075            .byte $C2,$C2
$D077  A0 AB     LDY #$AB
$D079  A0 AB     LDY #$AB
$D07B            .byte $B8,$B8
$D07D  D1 D1     CMP ($D1),Y 
$D07F  AD 00 D0  LDA $D000                          // Sprite 0 X Pos
$D082  38        SEC 
$D083  E9 40     SBC #$40
$D085  8D 00 D0  STA $D000                          // Sprite 0 X Pos
$D088  B0 04     BCS L_BRS_($D08E)_($D088) OK
$D08A  8A        TXA 
$D08B  29 7F     AND #$7F
$D08D  AA        TAX 
//------------------------------
L_BRS_($D08E)_($D088) OK
//------------------------------
$D08E  8A        TXA 
$D08F  18        CLC 
$D090  2A        ROL A 
$D091  69 00     ADC #$00
$D093  4C EB 91  JMP L_JMP_($91EB)_($D093) OK
$D096  49 04     EOR #$04
$D098  0A        ASL A 
$D099            .byte $04
$D09A  0A        ASL A 
$D09B  10 10     BPL L_BRS_($D0AD)_($D09B) JAM
$D09D  16 00     ASL $00,X 
$D09F  35 35     AND $35,X 
//------------------------------
L_BRS_($D0A1)_($D10F) OK
//------------------------------
$D0A1  3D 41 04  AND $0441,X 
$D0A4            .byte $04,$00,$00
$D0A7  1E 1F 1E  ASL $1E1F,X 
$D0AA            .byte $1F
$D0AB  10 10     BPL L_BRS_($D0BD)_($D0AB) JAM
//------------------------------
L_BRS_($D0AD)_($D09B) JAM
L_BRS_($D0B1)_($D11F) JAM
//------------------------------
$D0AD            .byte $23,$00,$00,$1A,$00
$D0B2  1E 00 1A  ASL $1A00,X 
$D0B5            .byte $00,$00,$04
$D0B8  0A        ASL A 
$D0B9            .byte $04
$D0BA  0A        ASL A 
$D0BB  10 10     BPL L_BRS_($D0CD)_($D0BB) OK
//------------------------------
L_BRS_($D0BD)_($D0AB) JAM
//------------------------------
$D0BD            .byte $2B,$00,$00,$00
//------------------------------
L_BRS_($D0C1)_($D12F) OK
//------------------------------
$D0C1  3D 41 04  AND $0441,X 
$D0C4            .byte $04,$00,$00,$04
$D0C8  0A        ASL A 
$D0C9            .byte $04
$D0CA  0A        ASL A 
$D0CB  10 10     BPL L_BRS_($D0DD)_($D0CB) JAM
//------------------------------
L_BRS_($D0CD)_($D0BB) OK
//------------------------------
$D0CD  31 00     AND ($00),Y 
$D0CF  35 35     AND $35,X 
//------------------------------
L_BRS_($D0D1)_($D13F) JAM
//------------------------------
$D0D1            .byte $00,$00,$04,$04,$00,$00,$77,$72
//------------------------------
L_BRS_($D0DD)_($D0CB) JAM
//------------------------------
$D0D9            .byte $77,$72,$6F,$6F,$6B,$00
$D0DF  3E 6D 3E  ROL $3E6D,X 
$D0E2  6D 77 77  ADC $7777 
$D0E5            .byte $7C,$7C,$5F
$D0E8  55 5F     EOR $5F,X 
$D0EA  55 5F     EOR $5F,X 
$D0EC            .byte $5F,$47,$47
$D0EF  05 0F     ORA $0F
$D0F1  05 0F     ORA $0F
$D0F3            .byte $1C,$1C
$D0F5  7E 7E 23  ROR $237E,X 
$D0F8  2E 23 2E  ROL $2E23 
$D0FB  39 39 22  AND $2239,Y 
$D0FE            .byte $22,$54
$D100  48        PHA 
$D101  45 20     EOR $20 
$D103            .byte $42
$D104  55 4C     EOR $4C,X 
$D106  4C 59 DA  JMP L_JMP_($DA59)_($D106) OK
$D109            .byte $0F,$00
$D10B  84 8A     STY $8A 
$D10D  84 8A     STY $8A 
$D10F  90 90     BCC L_BRS_($D0A1)_($D10F) OK
$D111  96 00     STX $00,Y 
$D113  B5 B5     LDA $B5,X 
$D115  BD C1 84  LDA $84C1,X 
$D118  84 00     STY $00 
$D11A            .byte $00,$9E,$9F,$9E,$9F
$D11F  90 90     BCC L_BRS_($D0B1)_($D11F) JAM
$D121            .byte $A3,$00,$00
$D124  9A        TXS 
$D125            .byte $00,$9E,$00
$D128  9A        TXS 
$D129            .byte $00,$00
$D12B  84 8A     STY $8A 
$D12D  84 8A     STY $8A 
$D12F  90 90     BCC L_BRS_($D0C1)_($D12F) OK
$D131            .byte $AB,$00,$00,$00
$D135  BD C1 84  LDA $84C1,X 
$D138  84 00     STY $00 
$D13A            .byte $00
$D13B  84 8A     STY $8A 
$D13D  84 8A     STY $8A 
$D13F  90 90     BCC L_BRS_($D0D1)_($D13F) JAM
$D141  B1 00     LDA ($00),Y 
$D143  B5 B5     LDA $B5,X 
$D145            .byte $00,$00
$D147  84 84     STY $84 
$D149            .byte $00,$00,$F7,$F2,$F7,$F2,$EF,$EF
$D151            .byte $EB,$00
$D153  BE ED BE  LDX $BEED,Y 
$D156  ED F7 F7  SBC $F7F7 
$D159            .byte $FC,$FC,$DF
$D15C  D5 DF     CMP $DF,X 
$D15E  D5 DF     CMP $DF,X 
$D160            .byte $DF,$C7,$C7
$D163  85 8F     STA $8F 
$D165  85 8F     STA $8F 
$D167            .byte $9C,$9C
$D169  FE FE A3  INC $A3FE,X 
$D16C  AE A3 AE  LDX $AEA3 
$D16F  B9 B9 A2  LDA $A2B9,Y 
$D172  A2 A0     LDX #$A0
$D174  0E 8A AA  ASL $AA8A 
$D177  88        DEY 
$D178  88        DEY 
$D179  10 06     BPL L_BRS_($D181)_($D179) OK
$D17B  8E 10 D0  STX $D010                          // Sprites 0-7 MSB of X coordinate
$D17E  4C 77 98  JMP L_JMP_($9877)_($D17E) OK
//------------------------------
L_BRS_($D181)_($D179) OK
//------------------------------
$D181  8C E9 94  STY $94E9 
$D184  8C EF 94  STY $94EF 
$D187  4C E8 94  JMP L_JMP_($94E8)_($D187) BAD
$D18A            .byte $00
$D18B  06 0C     ASL $0C 
$D18D  0D 0F 14  ORA $140F
$D190            .byte $14
$D191  19 1C 06  ORA $061C,Y
$D194  06 3F     ASL $3F 
$D196            .byte $3F
$D197  06 06     ASL $06 
$D199            .byte $00,$00
$D19B  06 0C     ASL $0C 
$D19D  0D 0F 14  ORA $140F
$D1A0            .byte $14
$D1A1  19 1C 00  ORA $001C,Y
$D1A4            .byte $1B,$00,$1F,$00,$1B,$00,$00
$D1AB  06 0C     ASL $0C 
$D1AD  0D 0F 14  ORA $140F
$D1B0            .byte $14
$D1B1  19 1C 00  ORA $001C,Y
$D1B4            .byte $00,$3F,$3F
$D1B7  06 06     ASL $06 
$D1B9            .byte $00,$00
$D1BB  06 0C     ASL $0C 
$D1BD  0D 0F 14  ORA $140F
$D1C0            .byte $14
$D1C1  19 1C 06  ORA $061C,Y
$D1C4  06 00     ASL $00 
$D1C6            .byte $00
$D1C7  06 06     ASL $06 
$D1C9            .byte $00,$1C,$7F
$D1CC  7D 7C 7A  ADC $7A7C,X 
$D1CF  6D 6D 69  ADC $696D 
$D1D2            .byte $67
$D1D3  40        RTI 
//------------------------------
$D1D4  70 72     BVS L_BRS_($D248)_($D1D4) JAM
$D1D6  70 40     BVS L_BRS_($D218)_($D1D6) OK
$D1D8  40        RTI 
//------------------------------
$D1D9            .byte $44,$44,$5C,$52
$D1DD  50 4E     BVC L_BRS_($D22D)_($D1DD) OK
$D1DF            .byte $5C,$5C,$44,$44,$07,$12,$14,$17
$D1E7            .byte $07,$07,$44,$44
$D1EB  25 31     AND $31
$D1ED            .byte $33
$D1EE  36 25     ROL $25,X 
$D1F0  25 44     AND $44
$D1F2            .byte $44,$54
$D1F4  48        PHA 
$D1F5  45 20     EOR $20 
$D1F7  48        PHA 
$D1F8  49 53     EOR #$53
$D1FA            .byte $54,$4F,$52
$D1FD  59 20 4D  EOR $4D20,Y 
$D200  41 53     EOR ($53,X) 
$D202            .byte $54
$D203  45 52     EOR $52 
$D205            .byte $DA
$D206  06 00     ASL $00 
$D208  86 8C     STX $8C 
$D20A  8D 8F 94  STA $948F 
$D20D  94 99     STY $99,X 
$D20F            .byte $9C
$D210  86 86     STX $86 
$D212            .byte $BF,$BF
//------------------------------
L_BRS_($D215)_($D253) BAD
//------------------------------
$D214  86 86     STX $86 
$D216            .byte $00,$00
//------------------------------
L_BRS_($D218)_($D1D6) OK
//------------------------------
$D218  86 8C     STX $8C 
$D21A  8D 8F 94  STA $948F 
$D21D  94 99     STY $99,X 
$D21F            .byte $9C,$00,$9B,$00,$9F,$00,$9B,$00
$D227            .byte $00
$D228  86 8C     STX $8C 
//------------------------------
L_BRS_($D22A)_($D25A) OK
//------------------------------
$D22A  8D 8F 94  STA $948F 
//------------------------------
L_BRS_($D22D)_($D1DD) OK
//------------------------------
$D22D  94 99     STY $99,X 
$D22F            .byte $9C,$00,$00,$BF,$BF
$D234  86 86     STX $86 
$D236            .byte $00,$00
$D238  86 8C     STX $8C 
$D23A  8D 8F 94  STA $948F 
$D23D  94 99     STY $99,X 
$D23F            .byte $9C
$D240  86 86     STX $86 
$D242            .byte $00,$00
$D244  86 86     STX $86 
//------------------------------
L_BRS_($D248)_($D1D4) JAM
//------------------------------
$D246            .byte $00,$9C,$FF
$D249  FD FC FA  SBC $FAFC,X 
$D24C  ED ED E9  SBC $E9ED 
$D24F            .byte $E7
$D250  C0 F0     CPY #$F0
$D252            .byte $F2
$D253  F0 C0     BEQ L_BRS_($D215)_($D253) BAD
$D255  C0 C4     CPY #$C4
$D257  C4 DC     CPY $DC 
$D259            .byte $D2
$D25A  D0 CE     BNE L_BRS_($D22A)_($D25A) OK
$D25C            .byte $DC,$DC
$D25E  C4 C4     CPY $C4 
$D260            .byte $87,$92
$D262  94 97     STY $97,X 
$D264            .byte $87,$87
$D266  C4 C4     CPY $C4 
$D268  A5 B1     LDA $B1 
$D26A            .byte $B3
$D26B  B6 A5     LDX $A5,Y 
$D26D  A5 C4     LDA $C4 
$D26F  C4 AD     CPY $AD 
$D271            .byte $00
$D272  D0 18     BNE L_BRS_($D28C)_($D272) JAM
$D274  69 40     ADC #$40
$D276  8D 00 D0  STA $D000                          // Sprite 0 X Pos
$D279  90 04     BCC L_BRS_($D27F)_($D279) OK
$D27B  8A        TXA 
$D27C  09 80     ORA #$80
$D27E  AA        TAX 
//------------------------------
L_BRS_($D27F)_($D279) OK
//------------------------------
$D27F  8A        TXA 
$D280  18        CLC 
$D281  2A        ROL A 
$D282  69 00     ADC #$00
$D284  4C EB 93  JMP L_JMP_($93EB)_($D284) BAD
$D287            .byte $DA
$D288  49 00     EOR #$00
$D28A            .byte $3B
$D28B  68        PLA 
//------------------------------
L_BRS_($D28C)_($D272) JAM
//------------------------------
$D28C            .byte $3B
$D28D  68        PLA 
$D28E            .byte $3B,$3B,$00,$00,$64,$00,$64,$00
$D296            .byte $64,$64,$00,$00,$02,$00,$02,$00
$D29E            .byte $02,$02,$00,$00
$D2A2  1E 64 1E  ASL $1E64,X 
$D2A5            .byte $64
$D2A6  1E 1E 00  ASL $001E,X 
$D2A9            .byte $00,$54
$D2AB  48        PHA 
$D2AC  45 20     EOR $20 
$D2AE            .byte $47
$D2AF  45 4F     EOR $4F 
$D2B1            .byte $47,$52
$D2B3  41 50     EOR ($50,X) 
$D2B5  48        PHA 
$D2B6  59 20 54  EOR $5420,Y 
$D2B9  45 41     EOR $41 
$D2BB            .byte $43
$D2BC  48        PHA 
$D2BD  45 52     EOR $52 
$D2BF            .byte $DA
$D2C0  10 00     BPL L_BRS_($D2C2)_($D2C0) JAM
//------------------------------
L_BRS_($D2C2)_($D2C0) JAM
//------------------------------
$D2C2            .byte $C7,$DA,$1F,$00,$C7,$DA,$0F,$00
$D2CA            .byte $C7,$DA,$0B,$00
$D2CE  E6 00     INC $00 
$D2D0  E6 F4     INC $F4 
$D2D2            .byte $F4,$00,$00,$00,$DA
$D2D7  01 DA     ORA ($DA,X)
$D2D9            .byte $00,$DA
$D2DB  01 DA     ORA ($DA,X)
$D2DD  CC CC 00  CPY $00CC 
$D2E0            .byte $00,$00,$89,$00,$89,$DA
$D2E6  05 00     ORA $00
$D2E8            .byte $A7,$00,$A7,$DA,$04,$00
$D2EE  AD 15 D0  LDA $D015                          // Sprite display Enable
$D2F1  F0 0F     BEQ L_BRS_($D302)_($D2F1) OK
$D2F3  AC 04 D0  LDY $D004                          // Sprite 2 X Pos
$D2F6  A9 00     LDA #$00
$D2F8  8D 15 D0  STA $D015                          // Sprite display Enable
$D2FB  AD 10 D0  LDA $D010                          // Sprites 0-7 MSB of X coordinate
$D2FE  2A        ROL A 
$D2FF  4C FB 98  JMP L_JMP_($98FB)_($D2FF) OK
//------------------------------
L_BRS_($D302)_($D2F1) OK
//------------------------------
$D302  68        PLA 
$D303  68        PLA 
$D304  60        RTS 
//------------------------------
$D305            .byte $00,$02,$00,$02,$00,$02,$02,$00
$D30D            .byte $00,$DA
$D30F  06 02     ASL $02 
$D311            .byte $00,$00,$27,$00,$27,$00,$27,$27
$D319            .byte $DA
$D31A  0A        ASL A 
$D31B            .byte $00,$02,$00,$02,$00,$02,$02,$DA
$D323            .byte $04,$00,$DA,$04,$02,$00,$00,$02
$D32B            .byte $00,$02,$00,$02,$02,$00,$00,$02
$D333            .byte $02,$00,$00,$02,$02,$DA
$D339  0A        ASL A 
$D33A            .byte $00
$D33B  3D 6B 3D  AND $3D6B,X 
$D33E            .byte $6B
$D33F  3D 3D 7A  AND $7A3D,X 
$D342            .byte $7A
$D343  61 64     ADC ($64,X) 
$D345  61 64     ADC ($64,X) 
$D347  61 61     ADC ($61,X) 
$D349  48        PHA 
$D34A  48        PHA 
$D34B            .byte $04
$D34C  0D 04 0D  ORA $0D04
$D34F            .byte $04,$04,$7F,$7F
$D353  21 2C     AND ($2C,X) 
$D355  21 2C     AND ($2C,X) 
$D357  21 21     AND ($21,X) 
$D359  29 29     AND #$29
$D35B            .byte $54
$D35C  48        PHA 
$D35D  45 20     EOR $20 
$D35F            .byte $53,$43
$D361  49 45     EOR #$45
$D363  4E 43 45  LSR $4543 
$D366  20 54 45  JSR L_JSR_($4554)_($D366) JAM
$D369  41 43     EOR ($43,X) 
$D36B  48        PHA 
$D36C  45 52     EOR $52 
$D36E            .byte $DA
$D36F  05 00     ORA $00
$D371  A6 87     LDX $87 
$D373  A6 87     LDX $87 
$D375  A6 A6     LDX $A6 
$D377            .byte $00,$00
$D379  A6 B9     LDX $B9 
$D37B  A6 C2     LDX $C2 
$D37D  C5 C8     CMP $C8 
$D37F            .byte $00,$00,$00
$D382  A1 00     LDA ($00,X) 
$D384  A1 DA     LDA ($DA,X) 
$D386  05 00     ORA $00
$D388            .byte $97,$00
$D38A  91 00     STA ($00),Y 
$D38C            .byte $97,$00,$00
$D38F  A6 A9     LDX $A9 
$D391  A6 A9     LDX $A9 
$D393  A6 A6     LDX $A6 
$D395            .byte $DA,$04,$00
$D398  A6 C2     LDX $C2 
$D39A  C5 C8     CMP $C8 
$D39C            .byte $00,$00
$D39E  A6 AF     LDX $AF 
$D3A0  A6 AF     LDX $AF 
$D3A2  A6 A6     LDX $A6 
$D3A4            .byte $00,$00
$D3A6  A6 B9     LDX $B9 
$D3A8            .byte $00,$00
$D3AA  C5 C8     CMP $C8 
$D3AC            .byte $00,$00,$00
$D3AF  F5 00     SBC $00,X 
$D3B1  F5 DA     SBC $DA,X 
$D3B3  05 00     ORA $00
$D3B5  E9 00     SBC #$00
$D3B7  E9 F5     SBC #$F5
$D3B9  F5 F8     SBC $F8,X 
$D3BB            .byte $F8,$E3
$D3BD  D8        CLD 
$D3BE            .byte $E3
$D3BF  D8        CLD 
$D3C0            .byte $CB,$CB,$00,$00,$00,$8B,$00,$8B
$D3C8  99 99 00  STA $0099,Y 
$D3CB            .byte $00,$9F
$D3CD  AA        TAX 
$D3CE            .byte $9F
$D3CF  AA        TAX 
$D3D0            .byte $B7,$B7,$00,$00
$D3D4  A0 80     LDY #$80
$D3D6  C8        INY 
$D3D7  C0 8A     CPY #$8A
$D3D9  D0 01     BNE L_BRS_($D3DC)_($D3D9) OK
$D3DB  60        RTS 
//------------------------------
L_BRS_($D3DC)_($D3D9) OK
//------------------------------
$D3DC  8C FB 96  STY $96FB 
$D3DF  8C EE 97  STY $97EE 
$D3E2  8C F7 97  STY $97F7 
$D3E5  AD 69 00  LDA $0069 
$D3E8  4C E8 97  JMP L_JMP_($97E8)_($D3E8) OK
$D3EB            .byte $00
$D3EC  05 00     ORA $00
$D3EE  05 00     ORA $00
$D3F0            .byte $12,$12,$17,$00
$D3F4  36 38     ROL $38,X 
$D3F6            .byte $DA,$04
$D3F8  05 00     ORA $00
$D3FA            .byte $00
$D3FB  05 00     ORA $00
$D3FD  05 00     ORA $00
$D3FF            .byte $12,$12
$D401  24 DA     BIT $DA 
$D403  09 00     ORA #$00
$D405  05 00     ORA $00
$D407  05 00     ORA $00
$D409            .byte $12,$12
$D40B  2C 00 00  BIT $0000 
$D40E            .byte $00,$DA,$04
$D411  05 00     ORA $00
$D413            .byte $00
$D414  05 00     ORA $00
$D416  05 00     ORA $00
$D418            .byte $12,$12,$32,$00
$D41C  36 38     ROL $38,X 
$D41E            .byte $00,$00
$D420  05 05     ORA $05
$D422            .byte $00,$00
$D424  76 00     ROR $00,X 
$D426  76 DA     ROR $DA,X 
$D428  05 00     ORA $00
$D42A            .byte $3F
$D42B  6E 3F 6E  ROR $6E3F 
$D42E            .byte $3F,$3F
$D430  7D 7D 5E  ADC $5E7D,X 
$D433            .byte $54
$D434  5E 54 5E  LSR $5E54,X 
$D437  5E 46 46  LSR $4646,X 
$D43A  06 10     ASL $10 
$D43C  06 10     ASL $10 
$D43E  06 06     ASL $06 
$D440  4A        LSR A 
$D441  4A        LSR A 
$D442  24 2F     BIT $2F 
$D444  24 2F     BIT $2F 
$D446  24 24     BIT $24 
$D448            .byte $34,$34,$54
$D44B  48        PHA 
$D44C  45 20     EOR $20 
$D44E  48        PHA 
$D44F  45 41     EOR $41 
$D451            .byte $44
$D452  20 4D 41  JSR L_JSR_($414D)_($D452) OK
$D455            .byte $53,$54
$D457  45 52     EOR $52 
$D459            .byte $DA
$D45A  09 00     ORA #$00
$D45C            .byte $83
$D45D  88        DEY 
$D45E            .byte $83
$D45F  88        DEY 
$D460  91 91     STA ($91),Y 
$D462            .byte $00,$00
$D464  B4 B7     LDY $B7,X 
$D466  BC C0 C6  LDY $C6C0,X 
$D469  C6 00     DEC $00 
$D46B            .byte $00,$83
$D46D  88        DEY 
$D46E            .byte $83
$D46F  88        DEY 
$D470  91 91     STA ($91),Y 
$D472            .byte $00,$00,$00
$D475  98        TYA 
$D476            .byte $00,$9C,$00
$D479  98        TYA 
$D47A            .byte $00,$00,$83
$D47D  88        DEY 
$D47E            .byte $83
$D47F  88        DEY 
$D480  91 91     STA ($91),Y 
$D482            .byte $DA,$04,$00
$D485  BC C0 C6  LDY $C6C0,X 
$D488  C6 00     DEC $00 
$D48A            .byte $00,$83
$D48C  88        DEY 
$D48D            .byte $83
$D48E  88        DEY 
$D48F  91 91     STA ($91),Y 
//------------------------------
L_BRS_($D491)_($D49F) JAM
//------------------------------
$D491            .byte $00,$00
$D493  B4 B7     LDY $B7,X 
$D495            .byte $00,$00
$D497  C6 C6     DEC $C6 
$D499            .byte $00,$00,$F8,$F3,$F8,$F3
$D49F  F0 F0     BEQ L_BRS_($D491)_($D49F) JAM
$D4A1  EC 00 00  CPX $0000 
$D4A4  EC 00 EC  CPX $EC00 
$D4A7            .byte $00,$00,$FB,$FB
$D4AB  E0 D6     CPX #$D6
$D4AD  E0 D6     CPX #$D6
$D4AF  E0 E0     CPX #$E0
$D4B1            .byte $00,$00,$00
$D4B4  8E 00 8E  STX $8E00 
$D4B7            .byte $9B,$9B,$00,$00
$D4BB  4D AD 4D  EOR $4DAD 
$D4BE  AD DA 04  LDA $04DA 
$D4C1            .byte $00
$D4C2  C9 58     CMP #$58
$D4C4  D0 0D     BNE L_BRS_($D4D3)_($D4C4) OK
$D4C6  AD 6A 00  LDA $006A 
$D4C9  C9 24     CMP #$24
$D4CB  D0 06     BNE L_BRS_($D4D3)_($D4CB) OK
$D4CD  A9 62     LDA #$62
$D4CF  8D 69 00  STA $0069 
$D4D2  60        RTS 
//------------------------------
L_BRS_($D4D3)_($D4C4) OK
L_BRS_($D4D3)_($D4CB) OK
//------------------------------
$D4D3  4C EA 96  JMP L_JMP_($96EA)_($D4D3) OK
$D4D6            .byte $DA
$D4D7  0A        ASL A 
$D4D8            .byte $00,$1A
$D4DA  1D 00 00  ORA $0000,X
$D4DD  05 05     ORA $05
$D4DF            .byte $DA
$D4E0  0A        ASL A 
$D4E1            .byte $00,$1A
$D4E3  25 DA     AND $DA
$D4E5  0E 00 1A  ASL $1A00 
$D4E8  2D 00 00  AND $0000 
$D4EB  05 05     ORA $05
$D4ED            .byte $DA
$D4EE  0A        ASL A 
$D4EF            .byte $00,$1A,$33,$DA,$07,$00,$33,$DA
$D4F7            .byte $07,$00
$D4F9  66 41     ROR $41 
$D4FB  71 73     ADC ($73),Y 
$D4FD  71 41     ADC ($41),Y 
$D4FF  41 43     EOR ($43,X) 
$D501            .byte $43,$5B
$D503  0D 5B 4D  ORA $4D5B
$D506            .byte $5B,$5B,$43,$43
$D50A  08        PHP 
$D50B            .byte $13
$D50C  15 18     ORA $18,X
$D50E  08        PHP 
$D50F  08        PHP 
$D510            .byte $43,$43
$D512  26 32     ROL $32 
$D514  26 0D     ROL $0D 
$D516  26 26     ROL $26 
$D518            .byte $43,$43
$D51A  A9 CC     LDA #$CC
$D51C  85 5D     STA $5D 
$D51E  20 E8 95  JSR L_JSR_($95E8)_($D51E) OK
$D521  F0 03     BEQ L_BRS_($D526)_($D521) OK
$D523  4C E8 96  JMP L_JMP_($96E8)_($D523) OK
//------------------------------
L_BRS_($D526)_($D521) OK
//------------------------------
$D526  4C E8 93  JMP L_JMP_($93E8)_($D526) BAD
$D529  A9 7F     LDA #$7F
$D52B  8D 15 D0  STA $D015                          // Sprite display Enable
$D52E  60        RTS 
//------------------------------
$D52F            .byte $DA,$04,$00,$8B,$00
$D534  8E 93 93  STX $9393 
$D537  98        TYA 
$D538            .byte $9B,$00,$00
$D53B  BE BE DA  LDX $DABE,Y 
$D53E  05 00     ORA $00
$D540            .byte $8B,$00
$D542  8E 93 93  STX $9393 
$D545  98        TYA 
$D546            .byte $9B,$00
$D548  99 00 9D  STA $9D00,Y 
$D54B            .byte $00
$D54C  99 00 00  STA $0000,Y 
$D54F            .byte $00,$8B,$00
$D552  8E 93 93  STX $9393 
$D555  98        TYA 
$D556            .byte $9B,$00,$00
$D559  BE BE DA  LDX $DABE,Y 
$D55C  05 00     ORA $00
$D55E            .byte $8B,$00
$D560  8E 93 93  STX $9393 
$D563  98        TYA 
$D564            .byte $9B,$DA,$07,$00,$9B,$00
$D56A  FE 00 FB  INC $FB00,X 
$D56D  EE EE EA  INC $EAEE 
$D570  E8        INX 
$D571            .byte $00,$EF,$00,$EF,$00,$00
$D577  C5 C5     CMP $C5 
$D579  DD D3 DD  CMP $DDD3,X 
$D57C            .byte $CF
$D57D  DD DD C5  CMP $C5DD,X 
$D580  C5 00     CMP $00 
$D582  91 00     STA ($00),Y 
$D584  96 00     STX $00,Y 
$D586            .byte $00
$D587  C5 C5     CMP $C5 
$D589            .byte $00
$D58A  B0 00     BCS L_BRS_($D58C)_($D58A) OK
//------------------------------
L_BRS_($D58C)_($D58A) OK
//------------------------------
$D58C  B5 00     LDA $00,X 
$D58E            .byte $00
$D58F  C5 C5     CMP $C5 
$D591  A9 CC     LDA #$CC
$D593  85 5D     STA $5D 
$D595  20 E8 95  JSR L_JSR_($95E8)_($D595) OK
$D598  D0 07     BNE L_BRS_($D5A1)_($D598) OK
$D59A  C0 40     CPY #$40
$D59C  B0 03     BCS L_BRS_($D5A1)_($D59C) OK
$D59E  4C E8 96  JMP L_JMP_($96E8)_($D59E) OK
//------------------------------
L_BRS_($D5A1)_($D598) OK
L_BRS_($D5A1)_($D59C) OK
//------------------------------
$D5A1  4C E8 91  JMP L_JMP_($91E8)_($D5A1) OK
$D5A4  AA        TAX 
$D5A5  29 08     AND #$08
$D5A7  60        RTS 
//------------------------------
$D5A8            .byte $00
$D5A9  10 00     BPL L_BRS_($D5AB)_($D5A9) JAM
//------------------------------
L_BRS_($D5AB)_($D5A9) JAM
//------------------------------
$D5AB            .byte $00,$00,$FF,$80,$7F,$00,$0F,$00
$D5B3            .byte $F8,$07
$D5B5  F0 7F     BEQ L_BRS_($D636)_($D5B5) JAM
$D5B7            .byte $07
$D5B8  F0 7F     BEQ L_BRS_($D639)_($D5B8) BAD
$D5BA            .byte $00,$80,$02,$80,$DA,$04,$00
$D5C1  60        RTS 
//------------------------------
$D5C2            .byte $F8,$00,$00,$00,$FF,$F8,$DA,$14
$D5CA            .byte $00
$D5CB  01 FF     ORA ($FF,X)
$D5CD            .byte $80,$7F
$D5CF  C0 00     CPY #$00
//------------------------------
L_BRS_($D5D8)_($D5F2) JAM
//------------------------------
$D5D1            .byte $00,$00,$14,$7F,$00,$4F,$7F,$FF
$D5D9            .byte $00,$00,$00
$D5DC  10 07     BPL L_BRS_($D5E5)_($D5DC) JAM
$D5DE            .byte $00
$D5DF  0A        ASL A 
//------------------------------
L_BRS_($D5E5)_($D5DC) JAM
//------------------------------
$D5E0            .byte $00,$04,$14,$00,$00,$8F
$D5E6  0E E4 00  ASL $00E4 
$D5E9            .byte $E7,$0C,$80
$D5EC  E4 3E     CPX $3E 
$D5EE            .byte $9C,$0B,$00,$00
$D5F2  F0 E4     BEQ L_BRS_($D5D8)_($D5F2) JAM
$D5F4            .byte $00
$D5F5  48        PHA 
$D5F6  EE 03 C0  INC $C003 
$D5F9  B9 DA 06  LDA $06DA,Y 
$D5FC            .byte $00
$D5FD  FE 03 00  INC $0003,X 
$D600            .byte $00
$D601  40        RTI 
//------------------------------
$D602  01 3E     ORA ($3E,X)
$D604            .byte $00,$00
$D606  F0 02     BEQ L_BRS_($D60A)_($D606) JAM
//------------------------------
L_BRS_($D60A)_($D606) JAM
//------------------------------
$D608            .byte $00,$00,$00,$2F,$00,$00
$D60E  F0 07     BEQ L_BRS_($D617)_($D60E) JAM
$D610            .byte $7F
$D611  F0 07     BEQ L_BRS_($D61A)_($D611) BAD
$D613            .byte $7F
$D614  08        PHP 
//------------------------------
L_BRS_($D617)_($D60E) JAM
//------------------------------
$D615            .byte $00,$00,$00,$FF
//------------------------------
L_BRS_($D61A)_($D611) BAD
//------------------------------
$D619  01 FE     ORA ($FE,X)
$D61B            .byte $00
$D61C  F0 00     BEQ L_BRS_($D61E)_($D61C) JAM
//------------------------------
L_BRS_($D61E)_($D61C) JAM
//------------------------------
$D61E            .byte $1F
$D61F  E0 0F     CPX #$0F
$D621  FE E0 0F  INC $0FE0,X 
$D624  FE 00 01  INC $0100,X 
$D627  40        RTI 
//------------------------------
$D628  01 DA     ORA ($DA,X)
$D62A            .byte $04,$00
$D62C  06 1F     ASL $1F 
$D62E            .byte $00,$00,$00,$FF,$1F,$DA,$14,$00
//------------------------------
L_BRS_($D636)_($D5B5) JAM
//------------------------------
$D636            .byte $80,$FF
//------------------------------
L_BRS_($D639)_($D5B8) BAD
//------------------------------
$D638  01 FE     ORA ($FE,X)
$D63A            .byte $03,$00,$00,$00
$D63E  28        PLP 
$D63F  FE 00 F2  INC $F200,X 
$D642  FE FF 00  INC $00FF,X 
$D645            .byte $00,$00
$D647  08        PHP 
$D648  E0 00     CPX #$00
$D64A  50 00     BVC L_BRS_($D64C)_($D64A) OK
//------------------------------
L_BRS_($D64C)_($D64A) OK
//------------------------------
$D64C  20 28 00  JSR $0028
$D64F            .byte $00
$D650  F1 70     SBC ($70),Y 
$D652            .byte $27,$00,$E7
$D655  30 01     BMI L_BRS_($D658)_($D655) JAM
//------------------------------
L_BRS_($D658)_($D655) JAM
//------------------------------
$D657            .byte $27,$7C
$D659  39 D0 00  AND $00D0,Y 
$D65C            .byte $00,$0F,$27,$00,$12,$77
$D662  C0 03     CPY #$03
$D664  9D DA 06  STA $06DA,X 
$D667            .byte $00,$7F
$D669  C0 00     CPY #$00
$D66B            .byte $00,$02,$80,$7C,$00,$00,$0F
$D672  40        RTI 
//------------------------------
L_BRS_($D677)_($D686) JAM
//------------------------------
$D673            .byte $00,$00,$00,$F4,$00,$00,$0F
$D67A  E0 FE     CPX #$FE
$D67C            .byte $0F
$D67D  E0 FE     CPX #$FE
$D67F            .byte $00,$07,$FF
$D682  FE FF BF  INC $BFFF,X 
$D685            .byte $7F
$D686  F0 EF     BEQ L_BRS_($D677)_($D686) JAM
$D688            .byte $7F,$FB,$C7,$F7,$7F,$E7,$F7,$7F
$D690            .byte $FF,$BF,$FA,$BF,$DA,$04,$FF
$D697  6E FB FF  ROR $FFFB 
$D69A            .byte $FF
$D69B  FD FF FB  SBC $FBFF,X 
$D69E            .byte $C3
$D69F  FD 3F FF  SBC $FF3F,X 
$D6A2            .byte $FF,$00,$FF,$FF,$87,$F8,$7F,$FF
$D6AA            .byte $FF,$FF,$83,$F8,$3F,$00,$FF
$D6B1  FD F9 FF  SBC $FFF9,X 
$D6B4            .byte $BF,$7F,$DF,$FF,$07,$83,$D4,$7F
$D6BC            .byte $FF,$4F,$7F,$FF,$FF,$87,$07,$D7
$D6C4            .byte $F7,$FF
$D6C6  EA        NOP 
$D6C7            .byte $EF,$F4,$D4,$FF,$7F,$8F
$D6CD  EE E4 7F  INC $7FE4 
$D6D0            .byte $E7
$D6D1  EC BF E4  CPX $E4BF 
$D6D4  BE 9D EB  LDX $EB9D,Y 
$D6D7            .byte $3F,$FC,$F7
$D6DA  E4 FE     CPX $FE 
$D6DC            .byte $4B
$D6DD  EE FB DF  INC $DFFB 
$D6E0  B9 FE FF  LDA $FFFE,Y                          // Vector: IRQ
$D6E3            .byte $C3,$FF,$FF,$FF
$D6E7  FE FB 87  INC $87FB,X 
$D6EA            .byte $FF,$5F
$D6EC  FD BE FF  SBC $FFBE,X 
$D6EF            .byte $FF,$F7,$FA,$FF,$FF,$7F,$AF,$FF
$D6F7            .byte $FF,$F7,$E7,$7F,$F7,$C7,$7F,$00
$D6FF  E0 FF     CPX #$FF
$D701            .byte $7F,$FF
$D703  FD FE 0F  SBC $0FFE,X 
$D706            .byte $F7
$D707  FE DF E3  INC $E3DF,X 
$D70A            .byte $EF
$D70B  FE E7 EF  INC $EFE7,X 
$D70E  FE FF FD  INC $FDFF,X 
$D711            .byte $5F
$D712  FD DA 04  SBC $04DA,X 
$D715            .byte $FF
$D716  76 DF     ROR $DF,X 
$D718            .byte $FF,$FF,$BF,$FF,$DF,$C3,$BF,$FC
//------------------------------
L_JSR_($D720)_($6325) JAM
//------------------------------
$D720            .byte $FF,$FF,$00,$FF,$FF
$D725  E1 1F     SBC ($1F,X) 
$D727  FE FF FF  INC $FFFF,X 
$D72A            .byte $FF
$D72B  C1 1F     CMP ($1F,X) 
$D72D            .byte $FC,$00,$FF,$BF,$9F,$FF
$D733  FD FE FB  SBC $FBFE,X 
$D736            .byte $FF
$D737  E0 C1     CPX #$C1
$D739            .byte $2B
$D73A  FE FF F2  INC $F2FF,X 
$D73D  FE FF FF  INC $FFFF,X 
$D740  E1 E0     SBC ($E0,X) 
$D742            .byte $EB,$EF,$FF,$57,$F7,$2F,$2B,$FF
$D74A  FE F1 77  INC $77F1,X 
$D74D            .byte $27
$D74E  FE E7 37  INC $37E7,X 
$D751  FD 27 7D  SBC $7D27,X 
$D754  B9 D7 FC  LDA $FCD7,Y 
$D757            .byte $3F,$EF,$27,$7F,$D2,$77,$DF,$FB
$D75F  9D 7F FF  STA $FF7F,X 
$D762            .byte $C3,$FF,$FF,$FF,$7F,$DF
$D768  E1 FF     SBC ($FF,X) 
$D76A            .byte $FA,$BF
$D76C  7D FF FF  ADC $FFFF,X 
$D76F            .byte $EF,$5F,$FF,$FF
$D773  FE F5 FF  INC $FFF5,X 
$D776            .byte $FF,$EF,$E7
$D779  FE EF E3  INC $E3EF,X 
$D77C  FE 00 F8  INC $F800,X 
$D77F            .byte $00,$00,$FF,$80
$D783  7E 0F 0F  ROR $0F0F,X 
$D786            .byte $80,$F8,$03
$D789  20 7E 0B  JSR L_JSR_($0B7E)_($D789) BAD
$D78C  D0 3F     BNE L_BRS_($D7CD)_($D78C) JAM
//------------------------------
L_BRS_($D78F)_($D795) JAM
//------------------------------
$D78E            .byte $00,$80,$03,$80,$DA,$04,$00
$D795  90 F8     BCC L_BRS_($D78F)_($D795) JAM
$D797            .byte $00,$00,$02,$FB,$B8,$3C,$03
$D79E  C0 DA     CPY #$DA
$D7A0  05 00     ORA $00
$D7A2  78        SEI 
$D7A3            .byte $07,$80,$00,$00,$00,$7C,$07
$D7AA  C0 00     CPY #$00
$D7AC            .byte $00,$02,$07,$FF
$D7B0  C0 20     CPY #$20
$D7B2  C0 00     CPY #$00
//------------------------------
L_BRS_($D7BB)_($D7D5) JAM
//------------------------------
$D7B4            .byte $F8,$7C,$1F,$FF,$00,$93,$02,$7F
$D7BC            .byte $00
$D7BD  78        SEI 
$D7BE            .byte $F8
$D7BF  28        PLP 
$D7C0            .byte $03,$00
$D7C2  0E 10 02  ASL $0210 
$D7C5            .byte $12,$00,$00,$8F,$0F,$F4,$00,$F3
//------------------------------
L_BRS_($D7CD)_($D78C) JAM
//------------------------------
$D7CD            .byte $0C,$80
$D7CF  E8        INX 
$D7D0  26 FE     ROL $FE 
$D7D2            .byte $0F
$D7D3  C0 03     CPY #$03
$D7D5  70 E4     BVS L_BRS_($D7BB)_($D7D5) JAM
$D7D7            .byte $00
$D7D8  88        DEY 
$D7D9  6E 02 E0  ROR $E002 
$D7DC            .byte $FF,$00,$00,$3C,$00,$00,$00
$D7E3  7E 02 78  ROR $7802,X 
$D7E6            .byte $00
$D7E7  C0 01     CPY #$01
$D7E9            .byte $1F,$00,$00,$F8,$07,$00,$00,$80
//------------------------------
L_BRS_($D7F3)_($D801) JAM
//------------------------------
$D7F1            .byte $7F,$00,$00
$D7F4  D0 0B     BNE L_BRS_($D801)_($D7F4) OK
$D7F6  7E 20 03  ROR $0320,X 
$D7F9  7E 00 1F  ROR $1F00,X 
$D7FC            .byte $00,$00,$FF
$D7FF  01 7E     ORA ($7E,X)
//------------------------------
L_BRS_($D801)_($D7F4) OK
//------------------------------
$D801  F0 F0     BEQ L_BRS_($D7F3)_($D801) JAM
$D803  01 1F     ORA ($1F,X)
$D805  C0 04     CPY #$04
$D807  7E D0 0B  ROR $0BD0,X 
$D80A            .byte $FC,$00
$D80C  01 C0     ORA ($C0,X)
$D80E  01 DA     ORA ($DA,X)
$D810            .byte $04,$00
$D812  09 1F     ORA #$1F
$D814            .byte $00,$00
$D816  40        RTI 
//------------------------------
$D817            .byte $DF
$D818  1D 3C C0  ORA $C03C,X
$D81B            .byte $03,$DA
$D81D  05 00     ORA $00
$D81F  1E E0 01  ASL $01E0,X 
$D822            .byte $00,$00,$00
$D825  3E E0 03  ROL $03E0,X 
$D828            .byte $00,$00
$D82A  40        RTI 
//------------------------------
$D82B  E0 FF     CPX #$FF
$D82D            .byte $03,$04,$03,$00,$1F
$D832  3E F8 FF  ROL $FFF8,X                          // SYSTEM
$D835            .byte $00
$D836  C9 40     CMP #$40
$D838  FE 00 1E  INC $1E00,X 
$D83B            .byte $1F,$14
$D83D  C0 00     CPY #$00
$D83F  70 08     BVS L_BRS_($D849)_($D83F) JAM
$D841  40        RTI 
//------------------------------
$D842  48        PHA 
$D843            .byte $00,$00
$D845  F1 F0     SBC ($F0),Y 
//------------------------------
L_BRS_($D849)_($D83F) JAM
//------------------------------
$D847            .byte $2F,$00,$CF
$D84A  30 01     BMI L_BRS_($D84D)_($D84A) JAM
//------------------------------
L_BRS_($D84D)_($D84A) JAM
//------------------------------
$D84C            .byte $17,$64,$7F
$D84F  F0 03     BEQ L_BRS_($D854)_($D84F) JAM
$D851  C0 0E     CPY #$0E
//------------------------------
L_BRS_($D854)_($D84F) JAM
//------------------------------
$D853            .byte $27,$00
$D855  11 76     ORA ($76),Y
$D857  40        RTI 
//------------------------------
$D858            .byte $07,$FF,$00,$00,$3C,$00,$00,$00
$D860  7E 40 1E  ROR $1E40,X 
$D863            .byte $00,$03,$80,$F8,$00,$00,$1F
$D86A  E0 00     CPX #$00
$D86C            .byte $00
$D86D  01 FE     ORA ($FE,X)
$D86F            .byte $00,$00,$0B,$14
$D873  7E 04 C0  ROR $C004,X 
$D876  7E 00 FB  ROR $FB00,X 
$D879            .byte $FF
$D87A  FE FF BF  INC $BFFF,X 
$D87D  7E EF EF  ROR $EFEF,X 
$D880            .byte $BF,$FB,$FB,$2F
$D884  7E EB D7  ROR $D7EB,X 
$D887            .byte $BF,$FF,$BF,$FB,$BF,$FF,$F8,$3F
$D88F  FE 94 FB  INC $FB94,X 
$D892            .byte $FF,$FF,$C2,$FB,$BB
$D897  BC FB CF  LDY $CFFB,X 
$D89A  FE 1F F3  INC $F31F,X                          // Set File values
$D89D  FE FF 7B  INC $7BFF,X 
$D8A0            .byte $F7,$BF,$FC,$3F,$83
$D8A5  7D F7 DF  ADC $DFF7,X 
$D8A8            .byte $FC,$1F,$02,$F7,$FF,$DF
$D8AE  A0 DF     LDY #$DF
$D8B0  FE FB 7D  INC $7DFB,X 
$D8B3            .byte $DF,$FF
$D8B5  FE 93 82  INC $8293,X 
$D8B8            .byte $7F
$D8B9  FE 7B FB  INC $FB7B,X 
$D8BC  AA        TAX 
$D8BD            .byte $FB,$FF
$D8BF  EE D7 FA  INC $FAD7 
$D8C2            .byte $D2,$FF,$7F,$8F,$EF,$F4,$7F,$F3
$D8CA  EC BF E8  CPX $E8BF 
$D8CD  A6 FE     LDX $FE 
$D8CF            .byte $EF,$DF,$FB,$77
$D8D3  E4 FE     CPX $FE 
$D8D5            .byte $8B
$D8D6  6E FA EF  ROR $EFFA 
$D8D9            .byte $FF
$D8DA  FE FF BD  INC $BDFF,X 
$D8DD  E1 FF     SBC ($FF,X) 
$D8DF            .byte $FF
$D8E0  7E FA 7B  ROR $7BFA,X 
$D8E3            .byte $FF,$DF
$D8E5  FD DF FF  SBC $FFDF,X 
$D8E8            .byte $FF,$FB,$F7,$FF,$FF,$BF,$7F,$FF
$D8F0            .byte $FF,$D7,$EB
$D8F3  7E 2F FB  ROR $FB2F,X 
$D8F6  7E 00 DF  ROR $DF00,X 
$D8F9            .byte $FF,$7F,$FF
$D8FC  FD 7E F7  SBC $F77E,X 
$D8FF            .byte $F7
$D900  FD DF DF  SBC $DFDF,X 
$D903            .byte $F4
$D904  7E D7 EB  ROR $EBD7,X 
$D907  FD FF FD  SBC $FDFF,X 
$D90A            .byte $DF
$D90B  FD FF 1F  SBC $1FFF,X 
$D90E            .byte $FC,$7F
$D910  29 DF     AND #$DF
$D912            .byte $FF,$FF,$43,$DF
$D916  DD 3D DF  CMP $DF3D,X 
$D919            .byte $F3,$7F,$F8,$CF,$7F,$FF
$D91F  DE EF FD  DEC $FDEF,X 
$D922            .byte $3F,$FC
$D924  C1 BE     CMP ($BE,X) 
$D926            .byte $EF,$FB,$3F,$F8
$D92A  40        RTI 
//------------------------------
$D92B            .byte $EF,$FF,$FB
$D92E  05 FB     ORA $FB
$D930            .byte $7F,$DF
$D932  BE FB FF  LDX $FFFB,Y 
$D935            .byte $7F
$D936  C9 41     CMP #$41
$D938  FE 7F DE  INC $DE7F,X 
$D93B            .byte $DF
$D93C  55 DF     EOR $DF,X 
$D93E            .byte $FF,$77,$EB,$5F,$4B,$FF
$D944  FE F1 F7  INC $F7F1,X 
$D947            .byte $2F
$D948  FE CF 37  INC $37CF,X 
$D94B  FD 17 65  SBC $6517,X 
$D94E            .byte $7F,$F7,$FB,$DF
$D952  EE 27 7F  INC $7F27 
$D955  D1 76     CMP ($76),Y 
$D957            .byte $5F,$F7,$FF,$7F,$FF
$D95C  BD 87 FF  LDA $FF87,X                          // Init Ram & Buffers
$D95F            .byte $FF
$D960  7E 5F DE  ROR $DE5F,X 
$D963            .byte $FF,$FB,$BF,$FB,$FF,$FF,$DF,$EF
$D96B            .byte $FF,$FF
$D96D  FD FE FF  SBC $FFFE,X                          // Vector: IRQ
$D970            .byte $FF,$EB,$D7
$D973  7E F4 DF  ROR $DFF4,X 
$D976  7E 00 7C  ROR $7C00,X 
$D979            .byte $00,$00,$FF,$80
$D97D  2A        ROL A 
$D97E            .byte $07,$0F
$D980  C0 F8     CPY #$F8
$D982            .byte $02
$D983  40        RTI 
//------------------------------
$D984  2A        ROL A 
$D985            .byte $0B
$D986  50 7F     BVC L_BRS_($DA07)_($D986) OK
$D988            .byte $00,$80,$03,$80,$00,$07
$D98E  C0 01     CPY #$01
$D990            .byte $0B,$FC,$00,$00
$D994  2E FF F8  ROL $F8FF 
$D997            .byte $4F,$04
$D999  F0 01     BEQ L_BRS_($D99C)_($D999) BAD
//------------------------------
L_BRS_($D99C)_($D999) BAD
//------------------------------
$D99B  E0 0C     CPX #$0C
$D99D            .byte $00,$00,$FC,$0F
$D9A1  C0 03     CPY #$03
$D9A3  C0 6C     CPY #$6C
$D9A5            .byte $82
$D9A6  08        PHP 
$D9A7  20 03 E0  JSR L_JSR_($E003)_($D9A7) JAM
$D9AA            .byte $5A,$0B,$FF
$D9AD  C0 00     CPY #$00
$D9AF            .byte $00,$00,$7C,$82,$07,$FF,$00
$D9B6  A2 03     LDX #$03
$D9B8            .byte $FF,$00,$FC,$7C
$D9BC  38        SEC 
$D9BD  01 00     ORA ($00,X)
$D9BF            .byte $0C
$D9C0  28        PLP 
$D9C1  01 17     ORA ($17,X)
$D9C3            .byte $00,$00,$9F,$0F,$F4,$00
$D9C9  F1 09     SBC ($09),Y 
$D9CB  40        RTI 
//------------------------------
$D9CC            .byte $EF
$D9CD  1E ED 14  ASL $14ED,X 
$D9D0  20 04 70  JSR L_JSR_($7004)_($D9D0) JAM
$D9D3  E4 00     CPX $00 
$D9D5            .byte $F4
$D9D6  EE 01 D0  INC $D001                          // Sprite 0 Y Pos
$D9D9  6E 01 00  ROR $0001 
$D9DC            .byte $42
$D9DD  16 00     ASL $00,X 
$D9DF            .byte $00
$D9E0  3E 04 5C  ROL $5C04,X 
$D9E3            .byte $00
$D9E4  C0 01     CPY #$01
$D9E6            .byte $3F,$00,$00,$B8,$07,$00,$00,$80
$D9EE            .byte $7B,$00,$00
$D9F1  50 0B     BVC L_BRS_($D9FE)_($D9F1) OK
$D9F3  2A        ROL A 
$D9F4  40        RTI 
//------------------------------
$D9F5            .byte $02
$D9F6  2A        ROL A 
$D9F7            .byte $00
$D9F8  3E 00 00  ROL $0000,X 
$D9FB            .byte $FF
$D9FC  01 54     ORA ($54,X)
//------------------------------
L_BRS_($D9FE)_($D9F1) OK
//------------------------------
$D9FE  E0 F0     CPX #$F0
$DA00            .byte $03,$1F
$DA02  40        RTI 
//------------------------------
$DA03            .byte $02,$54
$DA05  D0 0A     BNE L_BRS_($DA11)_($DA05) BAD
//------------------------------
L_BRS_($DA07)_($D986) OK
//------------------------------
$DA07  FE 00 01  INC $0100,X 
$DA0A  C0 01     CPY #$01
$DA0C            .byte $00
$DA0D  E0 03     CPX #$03
$DA0F            .byte $80
//------------------------------
L_BRS_($DA11)_($DA05) BAD
//------------------------------
$DA10  D0 3F     BNE L_BRS_($DA51)_($DA10) OK
$DA12            .byte $00,$00,$74,$FF,$1F,$F2
$DA18  20 0F 80  JSR L_JSR_($800F)_($DA18) OK
$DA1B            .byte $07
$DA1C  30 00     BMI L_BRS_($DA1E)_($DA1C) JAM
//------------------------------
L_BRS_($DA1E)_($DA1C) JAM
//------------------------------
$DA1E            .byte $00,$3F
//------------------------------
L_JSR_($DA20)_($CFBB) OK
//------------------------------
$DA20  F0 03     BEQ L_BRS_($DA25)_($DA20) BAD
$DA22  C0 03     CPY #$03
//------------------------------
L_BRS_($DA25)_($DA20) BAD
//------------------------------
$DA24  36 41     ROL $41,X 
$DA26  10 04     BPL L_BRS_($DA2C)_($DA26) BAD
$DA28  C0 07     CPY #$07
$DA2A            .byte $5A
//------------------------------
L_BRS_($DA2C)_($DA26) BAD
L_BRS_($DA2C)_($DA2B) BAD
//------------------------------
$DA2B  D0 FF     BNE L_BRS_($DA2C)_($DA2B) BAD
$DA2D            .byte $03,$00,$00,$00
$DA31  3E 41 E0  ROL $E041,X 
$DA34            .byte $FF,$00
$DA36  45 C0     EOR $C0 
$DA38            .byte $FF,$00,$3F
$DA3B  3E 1C 80  ROL $801C,X 
$DA3E            .byte $00
$DA3F  30 14     BMI L_BRS_($DA55)_($DA3F) JAM
//------------------------------
L_JSR_($DA41)_($CB15) JAM
//------------------------------
$DA41            .byte $80
$DA42  E8        INX 
$DA43            .byte $00,$00
$DA45  F9 F0 2F  SBC $2FF0,Y 
$DA48            .byte $00,$8F
$DA4A  90 02     BCC L_BRS_($DA4E)_($DA4A) JAM
$DA4C            .byte $F7
$DA4D  78        SEI 
//------------------------------
L_BRS_($DA4E)_($DA4A) JAM
//------------------------------
$DA4E            .byte $B7
$DA4F  28        PLP 
$DA50            .byte $04
//------------------------------
L_BRS_($DA51)_($DA10) OK
//------------------------------
$DA51  20 0E 27  JSR L_JSR_($270E)_($DA51) BAD
//------------------------------
L_BRS_($DA55)_($DA3F) JAM
//------------------------------
$DA54            .byte $00,$2F,$77,$80,$0B
//------------------------------
L_JMP_($DA59)_($D106) OK
//------------------------------
$DA59  76 80     ROR $80,X 
$DA5B            .byte $00,$42
$DA5D  68        PLA 
$DA5E            .byte $00,$00,$7C
$DA61  20 3A 00  JSR $003A
$DA64            .byte $03,$80,$FC,$00,$00
$DA69  1D E0 00  ORA $00E0,X
$DA6C            .byte $00
$DA6D  01 DE     ORA ($DE,X)
$DA6F            .byte $00,$00
$DA71  0A        ASL A 
$DA72  D0 54     BNE L_BRS_($DAC8)_($DA72) JAM
$DA74            .byte $02
$DA75  40        RTI 
//------------------------------
$DA76            .byte $54,$00
$DA78  7D FF FE  ADC $FEFF,X 
$DA7B            .byte $FF,$BF
$DA7D  AA        TAX 
$DA7E            .byte $F7,$EF,$DF,$FB,$FA,$5F
$DA84  AA        TAX 
$DA85            .byte $EB,$57,$7F,$FF,$BF,$FB,$BF,$9F
$DA8D            .byte $F7,$DF
$DA8F  FD 0B FD  SBC $FD0B,X 
$DA92            .byte $FF
$DA93  F0 2E     BEQ L_BRS_($DAC3)_($DA93) BAD
$DA95            .byte $FF,$FB,$4F,$F4,$F7
$DA9A  FD E7 8D  SBC $8DE7,X 
$DA9D  FE 7F FD  INC $FD7F,X 
$DAA0            .byte $EF,$DF,$FB,$DF
$DAA4  6D 82 E8  ADC $E882 
$DAA7            .byte $2F,$FB,$EF,$5A,$EB,$FF,$DF
$DAAE  DE 3F FE  DEC $FE3F,X 
$DAB1  7D 82 E7  ADC $E782,X 
$DAB4            .byte $FF
$DAB5  FE AA FB  INC $FBAA,X 
$DAB8            .byte $FF
$DAB9  FE FD 7D  INC $7DFD,X 
$DABC  BA        TSX 
$DABD  FD FF EC  SBC $ECFF,X 
$DAC0            .byte $AB
//------------------------------
L_BRS_($DAC3)_($DA93) BAD
//------------------------------
$DAC1  FD D7 FF  SBC $FFD7,X 
//------------------------------
L_BRS_($DAC8)_($DA72) JAM
//------------------------------
$DAC4            .byte $7F,$9F,$EF,$F4,$7F
$DAC9  F1 E9     SBC ($E9),Y 
$DACB            .byte $5F,$EF
$DACD  DE ED D4  DEC $D4ED,X 
//------------------------------
L_BRS_($DAD1)_($DB10) JAM
//------------------------------
$DAD0            .byte $2F,$F4,$77
$DAD3  E4 FE     CPX $FE 
$DAD5  F5 EE     SBC $EE,X 
$DAD7  FD D7 6E  SBC $6ED7,X 
$DADA  FD FF 42  SBC $42FF,X 
$DADD  D6 FF     DEC $FF,X 
$DADF            .byte $FF
$DAE0  3E F4 5D  ROL $5DF4,X 
$DAE3            .byte $FF,$DF
$DAE5  FD BF FF  SBC $FFBF,X 
$DAE8            .byte $FF,$BB,$F7,$FF,$FF,$BF,$7B,$FF
$DAF0            .byte $FF,$57,$EB
$DAF3  AA        TAX 
$DAF4            .byte $5F,$FA
$DAF6  AA        TAX 
$DAF7            .byte $00
$DAF8  BE FF 7F  LDX $7FFF,Y 
$DAFB            .byte $FF
$DAFC  FD 55 EF  SBC $EF55,X 
$DAFF            .byte $F7,$FB,$DF,$5F,$FA
$DB04  55 D7     EOR $D7,X 
$DB06  EA        NOP 
$DB07  FE FF FD  INC $FDFF,X 
$DB0A            .byte $DF
$DB0B  FD F9 EF  SBC $EFF9,X 
$DB0E            .byte $FB,$BF
$DB10  D0 BF     BNE L_BRS_($DAD1)_($DB10) JAM
$DB12            .byte $FF,$0F,$74,$FF,$DF,$F2,$2F,$EF
$DB1A            .byte $BF,$E7
$DB1C  B1 7F     LDA ($7F),Y 
$DB1E  FE BF F7  INC $F7BF,X 
$DB21            .byte $FB,$DF,$FB
$DB24  B6 41     LDX $41,Y 
$DB26            .byte $17,$F4,$DF,$F7,$5A,$D7,$FF,$FB
$DB2E            .byte $7B,$FC,$7F
$DB31  BE 41 E7  LDX $E741,Y 
$DB34            .byte $FF,$7F
$DB36  55 DF     EOR $DF,X 
$DB38            .byte $FF,$7F,$BF
$DB3B  BE 5D BF  LDX $BF5D,Y 
$DB3E            .byte $FF,$37
$DB40  D5 BF     CMP $BF,X 
$DB42            .byte $EB,$FF
$DB44  FE F9 F7  INC $F7F9,X 
$DB47            .byte $2F
$DB48  FE 8F 97  INC $978F,X 
$DB4B            .byte $FA,$F7,$7B,$B7,$2B,$F4,$2F
$DB52  EE 27 7F  INC $7F27 
$DB55            .byte $AF,$77,$BF,$EB
$DB59  76 BF     ROR $BF,X 
$DB5B            .byte $FF,$42,$6B,$FF,$FF,$7C,$2F
$DB62  BA        TSX 
$DB63            .byte $FF,$FB,$BF
$DB66  FD FF FF  SBC $FFFF,X 
$DB69  DD EF FF  CMP $FFEF,X 
$DB6C            .byte $FF
$DB6D  FD DE FF  SBC $FFDE,X                          // Read Real-Time Clock
$DB70            .byte $FF
$DB71  EA        NOP 
$DB72            .byte $D7
$DB73  55 FA     EOR $FA,X 
//------------------------------
L_BRS_($DB75)_($DBA9) JAM
//------------------------------
$DB75            .byte $5F
$DB76  55 00     EOR $00,X 
$DB78            .byte $5C,$00,$00,$FF,$80
$DB7D  2A        ROL A 
$DB7E  05 0F     ORA $0F
$DB80  C0 F8     CPY #$F8
$DB82            .byte $04
$DB83  A0 2A     LDY #$2A
$DB85            .byte $14
$DB86  48        PHA 
$DB87            .byte $5F,$00,$80,$07,$80
$DB8C  60        RTS 
//------------------------------
$DB8D            .byte $03
$DB8E  E0 02     CPX #$02
$DB90            .byte $47,$FC,$00,$0F
$DB94  E6 FF     INC $FF 
$DB96            .byte $F8,$4B,$04
$DB99  B0 02     BCS L_BRS_($DB9D)_($DB99) JAM
$DB9B  78        SEI 
//------------------------------
L_BRS_($DB9D)_($DB99) JAM
//------------------------------
$DB9C            .byte $52,$00,$00,$9C
$DBA0  09 C0     ORA #$C0
$DBA2            .byte $07
$DBA3  E0 C6     CPX #$C6
$DBA5            .byte $62
$DBA6  06 20     ASL $20 
$DBA8            .byte $04
$DBA9  10 CA     BPL L_BRS_($DB75)_($DBA9) JAM
$DBAB            .byte $0F,$FF,$DA,$04,$00,$5C,$62,$02
$DBB3            .byte $7F,$00
$DBB5  A2 00     LDX #$00
$DBB7            .byte $7F,$00,$9C,$5C
$DBBB  30 00     BMI L_BRS_($DBBD)_($DBBB) JAM
//------------------------------
L_BRS_($DBBD)_($DBBB) JAM
//------------------------------
$DBBD            .byte $00,$0C
$DBBF  10 00     BPL L_BRS_($DBC1)_($DBBF) OK
//------------------------------
L_BRS_($DBC1)_($DBBF) OK
//------------------------------
$DBC1  0D 00 00  ORA $0000
$DBC4            .byte $17,$07,$74,$80
$DBC8  78        SEI 
$DBC9  09 40     ORA #$40
$DBCB            .byte $1F,$0F
$DBCD  ED 16 70  SBC $7016 
$DBD0            .byte $04
$DBD1  70 6E     BVS L_BRS_($DC41)_($DBD1) BAD
$DBD3            .byte $00,$F4
$DBD5  F1 00     SBC ($00),Y 
$DBD7  D0 6E     BNE L_BRS_($DC47)_($DBD7) BAD
$DBD9  01 00     ORA ($00,X)
$DBDB            .byte $47,$32,$00,$00
$DBDF  3E 05 04  ROL $0405,X 
$DBE2            .byte $00
$DBE3  C0 03     CPY #$03
$DBE5            .byte $5F,$00,$00,$F8,$07,$00,$00,$80
$DBED            .byte $7F,$00,$00
$DBF0  48        PHA 
$DBF1            .byte $14
$DBF2  2A        ROL A 
$DBF3  A0 04     LDY #$04
$DBF5  2A        ROL A 
$DBF6            .byte $00,$3A,$00,$00,$FF
$DBFB  01 54     ORA ($54,X)
$DBFD  A0 F0     LDY #$F0
$DBFF            .byte $03,$1F
$DC01  20 05 54  JSR L_JSR_($5405)_($DC01) BAD
//------------------------------
L_BRS_($DC04)_($DC4B) OK
//------------------------------
$DC04  28        PLP 
$DC05            .byte $12,$FA,$00
$DC08  01 E0     ORA ($E0,X)
$DC0A  01 06     ORA ($06,X)
$DC0C  C0 07     CPY #$07
$DC0E  40        RTI 
//------------------------------
$DC0F            .byte $E2,$3F,$00
$DC12  F0 67     BEQ L_BRS_($DC7B)_($DC12) OK
$DC14            .byte $FF,$1F,$D2
$DC17  20 0D 40  JSR L_JSR_($400D)_($DC17) JAM
$DC1A  1E 4A 00  ASL $004A,X 
$DC1D            .byte $00
$DC1E  39 90 03  AND $0390,Y 
$DC21  E0 07     CPX #$07
$DC23            .byte $63
$DC24  46 60     LSR $60 
$DC26            .byte $04
$DC27  20 08 53  JSR L_JSR_($5308)_($DC27) BAD
//------------------------------
L_BRS_($DC2B)_($DC2A) BAD
//------------------------------
$DC2A  F0 FF     BEQ L_BRS_($DC2B)_($DC2A) BAD
$DC2C            .byte $DA,$04,$00,$3A
$DC30  46 40     LSR $40 
$DC32  FE 00 45  INC $4500,X 
$DC35            .byte $00
$DC36  FE 00 39  INC $3900,X 
$DC39            .byte $3A,$0C,$00,$00
$DC3D  30 08     BMI L_BRS_($DC47)_($DC3D) BAD
$DC3F            .byte $00
//------------------------------
L_BRS_($DC41)_($DBD1) BAD
//------------------------------
$DC40  B0 00     BCS L_BRS_($DC42)_($DC40) JAM
//------------------------------
L_BRS_($DC42)_($DC40) JAM
//------------------------------
$DC42            .byte $00
$DC43  E8        INX 
$DC44  E0 2E     CPX #$2E
//------------------------------
L_BRS_($DC47)_($DBD7) BAD
L_BRS_($DC47)_($DC3D) BAD
//------------------------------
$DC46  01 1E     ORA ($1E,X)
$DC48  90 02     BCC L_BRS_($DC4C)_($DC48) BAD
$DC4A            .byte $F8
//------------------------------
L_BRS_($DC4C)_($DC48) BAD
//------------------------------
$DC4B  F0 B7     BEQ L_BRS_($DC04)_($DC4B) OK
$DC4D  68        PLA 
$DC4E  0E 20 0E  ASL $0E20 
$DC51  76 00     ROR $00,X 
$DC53            .byte $2F,$8F,$00,$0B
$DC57  76 80     ROR $80,X 
$DC59            .byte $00,$E2
$DC5B  4C 00 00  JMP $0000
$DC5E            .byte $7C
$DC5F  A0 20     LDY #$20
$DC61            .byte $00,$03
$DC63  C0 FA     CPY #$FA
$DC65            .byte $00,$00,$1F
$DC68  E0 00     CPX #$00
$DC6A            .byte $00
$DC6B  01 FE     ORA ($FE,X)
$DC6D            .byte $00,$00,$12
$DC70  28        PLP 
$DC71            .byte $54
$DC72  05 20     ORA $20
$DC74            .byte $54
$DC75  94 5D     STY $5D,X 
$DC77            .byte $FF
$DC78  FE FF BF  INC $BFFF,X 
//------------------------------
L_BRS_($DC7B)_($DC12) OK
//------------------------------
$DC7B  AA        TAX 
$DC7C  F5 EF     SBC $EF,X 
$DC7E            .byte $DF,$FB,$F4,$AF
$DC82  AA        TAX 
$DC83  D5 4B     CMP $4B,X 
$DC85            .byte $5F,$FF,$BF,$F7,$BF,$7F,$FB,$EF
$DC8D  EA        NOP 
$DC8E            .byte $47
$DC8F  FD BE 0F  SBC $0FBE,X 
$DC92  E6 FF     INC $FF 
$DC94            .byte $FB,$4B,$F4,$B7,$FA,$7B,$52
$DC9B  FE 7F 9D  INC $9D7F,X 
$DC9E  E9 DF     SBC #$DF
$DCA0            .byte $F7,$EF
$DCA2  C6 62     DEC $62 
$DCA4  F6 2F     INC $2F,X 
$DCA6            .byte $F4,$17
$DCA8  CA        DEX 
$DCA9            .byte $EF,$FF,$3F
$DCAC  FE 7F C0  INC $C07F,X 
$DCAF  5D 62 FA  EOR $FA62,X 
$DCB2            .byte $7F
$DCB3  FE AA FC  INC $FCAA,X 
$DCB6            .byte $7F
$DCB7  FE 9D 5D  INC $5D9D,X 
$DCBA  B6 FE     LDX $FE,Y 
$DCBC            .byte $FF
$DCBD  EC D7 FE  CPX $FED7 
$DCC0  ED FF 7F  SBC $7FFF 
$DCC3            .byte $17,$F7,$74,$BF
$DCC7  78        SEI 
$DCC8  E9 5F     SBC #$5F
$DCCA            .byte $1F,$EF
$DCCC  ED D6 77  SBC $77D6 
$DCCF            .byte $F4,$77
$DCD1  6E FF F5  ROR $F5FF 
$DCD4  F1 FE     SBC ($FE),Y 
$DCD6            .byte $D7
$DCD7  6E FD 7F  ROR $7FFD 
$DCDA            .byte $47,$32,$80,$EF
$DCDE  3E F5 05  ROL $05F5,X 
$DCE1            .byte $FF,$DF,$FB,$5F,$FF,$87,$FB,$F7
$DCE9            .byte $7F,$F8,$BF,$7F,$FF,$87,$4B
$DCF0  D5 AA     CMP $AA,X 
$DCF2            .byte $AF,$F4
$DCF4  AA        TAX 
$DCF5            .byte $00
$DCF6  BA        TSX 
$DCF7            .byte $FF,$7F,$FF
$DCFA  FD 55 AF  SBC $AF55,X 
$DCFD            .byte $F7,$FB,$DF,$2F
$DD01  F5 55     SBC $55,X 
$DD03            .byte $AB,$D2,$FA,$FF
$DD07  FD EF FD  SBC $FDEF,X 
$DD0A  FE DF F7  INC $F7DF,X 
$DD0D            .byte $57,$E2,$BF
$DD10  7D F0 67  ADC $67F0,X 
$DD13            .byte $FF,$DF,$D2,$2F
$DD17  ED 5F DE  SBC $DE5F 
$DD1A  4A        LSR A 
$DD1B            .byte $7F
$DD1C  FE B9 97  INC $97B9,X 
$DD1F            .byte $FB,$EF,$F7,$63
$DD23  46 6F     LSR $6F 
$DD25            .byte $F4,$2F
$DD27  E8        INX 
$DD28            .byte $53,$F7,$FF,$FC,$7F
$DD2D  FE 03 BA  INC $BA03,X 
$DD30  46 5F     LSR $5F 
$DD32  FE 7F 55  INC $557F,X 
$DD35            .byte $3F
$DD36  FE 7F B9  INC $B97F,X 
$DD39  BA        TSX 
$DD3A  6D 7F FF  ADC $FF7F 
$DD3D            .byte $37,$EB,$7F,$B7,$FF
$DD42  FE E8 EF  INC $EFE8,X 
$DD45  2E FD 1E  ROL $1EFD 
$DD48            .byte $97,$FA,$F8,$F7,$B7,$6B
$DD4E  EE 2F EE  INC $EE2F 
$DD51  76 FF     ROR $FF,X 
$DD53            .byte $AF,$8F,$7F,$EB
$DD57  76 BF     ROR $BF,X 
$DD59  FE E2 4C  INC $4CE2,X 
$DD5C  01 F7     ORA ($F7,X)
$DD5E            .byte $7C,$AF
$DD60  A0 FF     LDY #$FF
$DD62            .byte $FB,$DF,$FA,$FF
$DD66  E1 DF     SBC ($DF,X) 
$DD68            .byte $EF
$DD69  FE 1F FD  INC $FD1F,X 
$DD6C  FE FF E1  INC $E1FF,X 
$DD6F            .byte $D2,$AB
$DD71  55 F5     EOR $F5,X 
$DD73            .byte $2F
$DD74  55 00     EOR $00,X 
$DD76            .byte $04,$00,$00,$FF,$80
$DD7B  2A        ROL A 
$DD7C            .byte $00,$0F
$DD7E  40        RTI 
//------------------------------
$DD7F            .byte $F8
$DD80  05 D0     ORA $D0
//------------------------------
L_BRS_($DD83)_($DDA7) JAM
//------------------------------
$DD82            .byte $1A,$14
$DD84  24 FF     BIT $FF 
$DD86            .byte $00,$80,$00,$00
$DD8A  A0 02     LDY #$02
$DD8C  E0 17     CPX #$17
$DD8E            .byte $A3,$FC
$DD90  41 FF     EOR ($FF,X) 
$DD92  AE FF F8  LDX $F8FF 
$DD95            .byte $63
$DD96  06 30     ASL $30 
$DD98            .byte $02
$DD99  58        CLI 
$DD9A            .byte $42,$00,$00,$14
$DD9E  01 40     ORA ($40,X)
$DDA0            .byte $04
$DDA1  E0 C6     CPX #$C6
$DDA3            .byte $5A
$DDA4  05 A0     ORA $A0
$DDA6            .byte $03
$DDA7  10 DA     BPL L_BRS_($DD83)_($DDA7) JAM
$DDA9  01 DA     ORA ($DA,X)
$DDAB            .byte $13,$FF,$00,$00,$00,$3F,$F4
$DDB2  E6 01     INC $01 
$DDB4            .byte $FF,$00
//------------------------------
L_BRS_($DDB7)_($DDD5) BAD
//------------------------------
$DDB6  A2 00     LDX #$00
$DDB8            .byte $3F,$00,$14,$04
$DDBC  30 00     BMI L_BRS_($DDBE)_($DDBC) JAM
//------------------------------
L_BRS_($DDBE)_($DDBC) JAM
//------------------------------
$DDBE            .byte $00
$DDBF  0E 00 00  ASL $0000 
$DDC2  09 00     ORA #$00
$DDC4            .byte $00,$1F
$DDC6  01 0C     ORA ($0C,X)
$DDC8  C0 04     CPY #$04
$DDCA  09 00     ORA #$00
$DDCC            .byte $0F
$DDCD  0E 6D 16  ASL $166D 
$DDD0  F0 06     BEQ L_BRS_($DDD8)_($DDD0) OK
$DDD2  40        RTI 
//------------------------------
$DDD3  24 00     BIT $00 
$DDD5  F0 E0     BEQ L_BRS_($DDB7)_($DDD5) BAD
$DDD7            .byte $00
//------------------------------
L_BRS_($DDD8)_($DDD0) OK
//------------------------------
$DDD8  D0 6E     BNE L_BRS_($DE48)_($DDD8) BAD
$DDDA  01 00     ORA ($00,X)
$DDDC            .byte $6F
$DDDD  D6 7F     DEC $7F,X 
$DDDF  10 3E     BPL L_BRS_($DE1F)_($DDDF) OK
$DDE1  0D 7C 00  ORA $007C
$DDE4            .byte $00,$00,$7F,$00
$DDE8  78        SEI 
$DDE9            .byte $F8,$07,$80,$07,$80,$7F,$00
$DDF0  78        SEI 
$DDF1  24 14     BIT $14 
$DDF3            .byte $1A
$DDF4  D0 05     BNE L_BRS_($DDFB)_($DDF4) JAM
$DDF6  2A        ROL A 
$DDF7            .byte $00
$DDF8  20 00 00  JSR $0000
//------------------------------
L_BRS_($DDFB)_($DDF4) JAM
//------------------------------
$DDFB            .byte $FF
$DDFC  01 54     ORA ($54,X)
$DDFE            .byte $00
$DDFF  F0 02     BEQ L_BRS_($DE03)_($DDFF) BAD
$DE01            .byte $1F
//------------------------------
L_JSR_($DE03)_($A92F) BAD
L_BRS_($DE03)_($DDFF) BAD
L_JSR_($DE03)_($E5AE) BAD
//------------------------------
$DE02  A0 0B     LDY #$0B
$DE04  58        CLI 
$DE05  28        PLP 
$DE06  24 FF     BIT $FF 
$DE08            .byte $00
$DE09  01 00     ORA ($00,X)
$DE0B            .byte $00
$DE0C  05 40     ORA $40
$DE0E            .byte $07
$DE0F  E8        INX 
$DE10  C5 3F     CMP $3F 
$DE12            .byte $82,$FF
$DE14  75 FF     ADC $FF,X 
$DE16            .byte $1F
$DE17  C6 60     DEC $60 
$DE19            .byte $0C
$DE1A  40        RTI 
//------------------------------
$DE1B            .byte $1A,$42,$00,$00
//------------------------------
L_BRS_($DE1F)_($DDDF) OK
//------------------------------
$DE1F  28        PLP 
$DE20            .byte $80,$02
$DE22  20 07 63  JSR L_JSR_($6307)_($DE22) JAM
$DE25            .byte $5A
$DE26  A0 05     LDY #$05
$DE28  C0 08     CPY #$08
$DE2A            .byte $5B
$DE2B  C8        INY 
$DE2C            .byte $FF,$00,$00,$00,$FC,$2F,$67,$80
$DE34            .byte $FF,$00
$DE36  45 00     EOR $00 
$DE38            .byte $FC,$00
$DE3A  28        PLP 
$DE3B  20 0C 00  JSR $000C
$DE3E            .byte $00
$DE3F  70 00     BVS L_BRS_($DE41)_($DE3F) JAM
//------------------------------
L_BRS_($DE41)_($DE3F) JAM
//------------------------------
$DE41            .byte $00
$DE42  90 00     BCC L_BRS_($DE44)_($DE42) JAM
//------------------------------
L_BRS_($DE44)_($DE42) JAM
//------------------------------
$DE44            .byte $00,$F8,$80
//------------------------------
L_BRS_($DE48)_($DDD8) BAD
//------------------------------
$DE47  30 03     BMI L_BRS_($DE4C)_($DE47) OK
$DE49  20 90 00  JSR $0090
//------------------------------
L_BRS_($DE4C)_($DE47) OK
//------------------------------
$DE4C  F0 70     BEQ L_BRS_($DEBE)_($DE4C) BAD
$DE4E  B6 68     LDX $68,Y 
$DE50            .byte $0F
$DE51  60        RTS 
//------------------------------
$DE52            .byte $02
$DE53  24 00     BIT $00 
$DE55            .byte $0F,$07,$00,$0B
$DE59  76 80     ROR $80,X 
$DE5B            .byte $00
$DE5C  F6 6B     INC $6B,X 
$DE5E  FE 08 7C  INC $7C08,X 
$DE61  B0 3E     BCS L_BRS_($DEA1)_($DE61) BAD
$DE63            .byte $00,$00,$00
$DE66  FE 00 1E  INC $1E00,X 
$DE69            .byte $1F
$DE6A  E0 01     CPX #$01
$DE6C  E0 01     CPX #$01
//------------------------------
L_BRS_($DE6F)_($DE7E) BAD
//------------------------------
$DE6E  FE 00 1E  INC $1E00,X 
$DE71  24 28     BIT $28 
$DE73  58        CLI 
$DE74            .byte $0B
$DE75  A0 54     LDY #$54
$DE77            .byte $00
$DE78  05 FF     ORA $FF
$DE7A  FE FF BF  INC $BFFF,X 
$DE7D  AA        TAX 
$DE7E  F0 EF     BEQ L_BRS_($DE6F)_($DE7E) BAD
$DE80            .byte $5F,$FB
$DE82  F5 D7     SBC $D7,X 
$DE84            .byte $DA
$DE85  01 DA     ORA ($DA,X)
$DE87  D5 A5     CMP $A5,X 
$DE89            .byte $FF
$DE8A  FE BF F8  INC $F8BF,X 
$DE8D            .byte $7F,$AF,$FA,$EF,$D7,$A3
$DE93  FD 41 FF  SBC $FF41,X 
$DE96  AE FF FB  LDX $FBFF 
$DE99            .byte $63
$DE9A  F6 37     INC $37,X 
$DE9C            .byte $FA,$5B,$42
//------------------------------
L_BRS_($DEA1)_($DE61) BAD
//------------------------------
$DE9F  FE 7F 15  INC $157F,X 
$DEA2  E1 5F     SBC ($5F,X) 
$DEA4            .byte $F4,$EF
$DEA6  C6 5A     DEC $5A 
$DEA8  F5 AF     SBC $AF,X 
$DEAA            .byte $FB,$17,$DA
$DEAD  01 DA     ORA ($DA,X)
$DEAF            .byte $D3,$FF,$7F
$DEB2  FE 7F BF  INC $BF7F,X 
$DEB5  F5 E6     SBC $E6,X 
$DEB7  FD FF FE  SBC $FEFF,X 
$DEBA  AA        TAX 
$DEBB            .byte $FF,$BF
//------------------------------
L_BRS_($DEBE)_($DE4C) BAD
//------------------------------
$DEBD  FE 15 05  INC $0515,X 
$DEC0  B6 FE     LDX $FE,Y 
$DEC2            .byte $FF
$DEC3  EE EF FE  INC $FEEF 
$DEC6  E9 FF     SBC #$FF
$DEC8            .byte $7F,$1F
$DECA  F9 8C DF  SBC $DF8C,Y 
$DECD            .byte $04
$DECE  E9 1F     SBC #$1F
$DED0            .byte $0F
$DED1  EE 6D D6  INC $D66D 
$DED4            .byte $F7
$DED5  F6 4F     INC $4F,X 
$DED7  A4 FF     LDY $FF 
$DED9            .byte $F3
$DEDA  E0 FE     CPX #$FE
$DEDC            .byte $D7
$DEDD  6E FD 7F  ROR $7FFD 
$DEE0            .byte $6F
$DEE1  D6 7F     DEC $7F,X 
$DEE3  D0 3E     BNE L_BRS_($DF23)_($DEE3) BAD
$DEE5  CD 7D FF  CMP $FF7D 
$DEE8            .byte $3F,$FC,$7F,$FF,$7B,$FB,$F7,$BF
$DEF0            .byte $F7,$BF,$7F,$FF,$7B
$DEF5  A5 D5     LDA $D5 
$DEF7            .byte $DA
$DEF8  01 DA     ORA ($DA,X)
$DEFA            .byte $D7
$DEFB  F5 AA     SBC $AA,X 
$DEFD            .byte $00
$DEFE  A0 FF     LDY #$FF
$DF00            .byte $7F,$FF
$DF02  FD 55 0F  SBC $0F55,X 
$DF05            .byte $F7,$FA,$DF,$AF,$EB,$5B,$AB
$DF0C  A5 FF     LDA $FF 
$DF0E            .byte $7F
$DF0F  FD 1F FE  SBC $FE1F,X 
$DF12  F5 5F     SBC $5F,X 
$DF14            .byte $F7,$EB
$DF16  C5 BF     CMP $BF 
$DF18            .byte $82,$FF
$DF1A  75 FF     ADC $FF,X 
$DF1C            .byte $DF
$DF1D  C6 6F     DEC $6F 
$DF1F  EC 5F DA  CPX $DA5F 
//------------------------------
L_BRS_($DF23)_($DEE3) BAD
//------------------------------
$DF22  01 DA     ORA ($DA,X)
$DF24            .byte $42,$7F
$DF26  FE A8 87  INC $87A8,X 
$DF29            .byte $FA,$2F,$F7,$63,$5A,$AF
$DF2F  F5 DF     SBC $DF,X 
$DF31  E8        INX 
$DF32            .byte $5B,$CB,$FF
$DF35  FE 7F FE  INC $FE7F,X 
$DF38  FD AF 67  SBC $67AF,X 
$DF3B            .byte $BF,$FF,$7F
$DF3E  55 FF     EOR $FF,X 
$DF40  FD 7F A8  SBC $A87F,X 
$DF43  A0 6D     LDY #$6D
$DF45            .byte $7F,$FF,$77,$F7,$7F,$97,$FF
$DF4C  FE F8 9F  INC $9FF8,X 
$DF4F  31 FB     AND ($FB),Y 
$DF51  20 97 F8  JSR L_JSR_($F897)_($DF51) BAD
$DF54  F0 77     BEQ L_BRS_($DFCD)_($DF54) JAM
$DF56  B6 6B     LDX $6B,Y 
$DF58            .byte $EF,$6F,$F2
$DF5B  25 FF     AND $FF
$DF5D            .byte $CF,$07,$7F,$EB
$DF61  76 BF     ROR $BF,X 
$DF63  FE F6 6B  INC $6BF6,X 
$DF66  FE 0B 7C  INC $7C0B,X 
$DF69            .byte $B3
$DF6A  BE FF FC  LDX $FCFF,Y 
$DF6D            .byte $3F
$DF6E  FE FF DE  INC $DEFF,X 
$DF71            .byte $DF,$EF
$DF73  FD EF FD  SBC $FDEF,X 
$DF76  FE FF DE  INC $DEFF,X 
$DF79  A5 AB     LDA $AB 
$DF7B            .byte $5B,$EB,$AF
$DF7E  55 00     EOR $00,X 
$DF80  7E 00 01  ROR $0100,X 
$DF83            .byte $FF,$80
//------------------------------
L_BRS_($DF85)_($DFB1) OK
//------------------------------
$DF85  3E 07 1F  ROL $1F07,X 
$DF88  E0 F8     CPX #$F8
$DF8A  0E 50 1E  ASL $1E50 
$DF8D            .byte $1C,$1C,$1F
$DF90  01 80     ORA ($80,X)
$DF92            .byte $00,$00
$DF94  90 00     BCC L_BRS_($DF96)_($DF94) OK
//------------------------------
L_BRS_($DF96)_($DF94) OK
//------------------------------
$DF96  30 1F     BMI L_BRS_($DFB7)_($DF96) JAM
$DF98            .byte $FB
$DF99  EC 7F FF  CPX $FF7F 
$DF9C  EE FF F8  INC $F8FF 
$DF9F  0E 00 E0  ASL $E000                          // EXP continued From BASIC ROM
$DFA2            .byte $03
$DFA3  18        CLC 
$DFA4  CE 00 00  DEC $0000 
$DFA7  86 08     STX $08 
$DFA9  60        RTS 
//------------------------------
$DFAA            .byte $00
$DFAB  A0 DE     LDY #$DE
$DFAD            .byte $04,$00
$DFAF  40        RTI 
//------------------------------
$DFB0            .byte $02
$DFB1  D0 D2     BNE L_BRS_($DF85)_($DFB1) OK
//------------------------------
L_BRS_($DFB7)_($DF96) JAM
//------------------------------
$DFB3            .byte $0C,$FF,$00,$00,$00
$DFB8  20 46 46  JSR L_JSR_($4646)_($DFB8) JAM
$DFBB            .byte $00,$3F,$00,$E3,$00,$3F,$00
//------------------------------
L_BRS_($DFC3)_($DFDD) BAD
//------------------------------
$DFC2  86 7E     STX $7E 
$DFC4  38        SEC 
$DFC5            .byte $00,$00
$DFC7  0E 00 00  ASL $0000 
$DFCA  09 00     ORA #$00
//------------------------------
L_BRS_($DFCD)_($DF54) JAM
//------------------------------
$DFCC            .byte $00,$E7,$03
$DFCF  1D C0 02  ORA $02C0,X
$DFD2  1E 00 4F  ASL $4F00,X 
$DFD5  0E AD 16  ASL $16AD 
$DFD8  70 04     BVS L_BRS_($DFDE)_($DFD8) BAD
$DFDA  C0 3D     CPY #$3D
$DFDC            .byte $00
//------------------------------
L_BRS_($DFDE)_($DFD8) BAD
//------------------------------
$DFDD  F0 E4     BEQ L_BRS_($DFC3)_($DFDD) BAD
$DFDF            .byte $00
$DFE0  D0 6E     BNE L_BRS_($E050)_($DFE0) JAM
$DFE2  01 00     ORA ($00,X)
$DFE4            .byte $47
$DFE5  F6 FF     INC $FF,X 
$DFE7            .byte $1F
$DFE8  7E 3F 2C  ROR $2C3F,X 
$DFEB            .byte $00,$00,$00,$9F,$00,$5C,$F8,$0F
$DFF3  C0 05     CPY #$05
$DFF5            .byte $80,$FF,$00,$5C,$1C,$1C
$DFFB  1E 50 0E  ASL $0E50,X 
//------------------------------
L_JSR_($DFFF)_($6625) BAD
//------------------------------
$DFFE  3E 00 7E  ROL $7E00,X 
//------------------------------
L_JSR_($E003)_($9D30) JAM
L_JSR_($E003)_($D9A7) JAM
//------------------------------
$E001            .byte $00,$80,$FF
$E004  01 7C     ORA ($7C,X)
$E006  E0 F8     CPX #$F8
$E008            .byte $07,$1F
$E00A  70 0A     BVS L_BRS_($E016)_($E00A) JAM
//------------------------------
L_BRS_($E00C)_($E055) OK
//------------------------------
$E00C  78        SEI 
$E00D  38        SEC 
$E00E  38        SEC 
$E00F            .byte $F8,$80
$E011  01 00     ORA ($00,X)
$E013            .byte $00
$E014  09 00     ORA #$00
//------------------------------
L_BRS_($E016)_($E00A) JAM
//------------------------------
$E016            .byte $0C,$F8,$DF,$37
$E01A  FE FF 77  INC $77FF,X 
$E01D            .byte $FF,$1F
$E01F  70 00     BVS L_BRS_($E021)_($E01F) JAM
//------------------------------
L_BRS_($E021)_($E01F) JAM
//------------------------------
$E021            .byte $07
$E022  C0 18     CPY #$18
$E024            .byte $73,$00,$00
$E027  61 10     ADC ($10,X) 
$E029  06 00     ASL $00 
$E02B  05 7B     ORA $7B
$E02D  20 00 02  JSR $0200
$E030  40        RTI 
//------------------------------
$E031            .byte $0B,$4B
//------------------------------
L_BRS_($E034)_($E033) BAD
//------------------------------
$E033  30 FF     BMI L_BRS_($E034)_($E033) BAD
$E035            .byte $00,$00,$00,$04,$62,$62,$00,$FC
$E03D            .byte $00,$C7,$00,$FC,$00
$E042  61 7E     ADC ($7E,X) 
$E044            .byte $1C,$00,$00
$E047  70 00     BVS L_BRS_($E049)_($E047) JAM
//------------------------------
L_BRS_($E049)_($E047) JAM
//------------------------------
$E049            .byte $00
$E04A  90 00     BCC L_BRS_($E04C)_($E04A) JAM
//------------------------------
L_BRS_($E04C)_($E04A) JAM
//------------------------------
$E04C            .byte $00,$E7
$E04E  C0 B8     CPY #$B8
//------------------------------
L_BRS_($E050)_($DFE0) JAM
//------------------------------
$E050            .byte $03
$E051  40        RTI 
//------------------------------
$E052  78        SEI 
$E053            .byte $00,$F2
$E055  70 B5     BVS L_BRS_($E00C)_($E055) OK
$E057  68        PLA 
$E058  0E 20 03  ASL $0320 
//------------------------------
L_BRS_($E05B)_($E0AA) OK
//------------------------------
$E05B  BC 00 0F  LDY $0F00,X 
$E05E            .byte $27,$00,$0B
$E061  76 80     ROR $80,X 
$E063            .byte $00,$E2,$6F,$FF,$F8
$E068  7E FC 34  ROR $34FC,X 
$E06B            .byte $00,$00,$00
$E06E  F9 00 3A  SBC $3A00,Y 
$E071            .byte $1F
$E072  F0 03     BEQ L_BRS_($E077)_($E072) JAM
$E074  A0 01     LDY #$01
//------------------------------
L_BRS_($E077)_($E072) JAM
//------------------------------
$E076            .byte $FF,$00,$3A
$E079  38        SEC 
$E07A  38        SEC 
$E07B  78        SEI 
$E07C  0A        ASL A 
$E07D  70 7C     BVS L_BRS_($E0FB)_($E07D) BAD
$E07F            .byte $00
$E080  7E FF FD  ROR $FDFF,X 
$E083            .byte $FF,$BF
$E085  BE F7 DF  LDX $DFF7,Y 
$E088            .byte $EF,$FB
$E08A  EE 57 DE  INC $DE57 
$E08D  DD DD 1F  CMP $1FDD,X 
$E090  FD BF FF  SBC $FFBF,X 
$E093            .byte $FF,$97,$F8,$37,$DF,$FB
$E099  ED 7F FF  SBC $FF7F 
$E09C  EE FF FB  INC $FBFF 
$E09F  0E F0 EF  ASL $EFF0 
$E0A2            .byte $FB,$1B
$E0A4  CE FE FF  DEC $FFFE                          // Vector: IRQ
$E0A7  86 E8     STX $E8 
$E0A9            .byte $6F
$E0AA  F0 AF     BEQ L_BRS_($E05B)_($E0AA) OK
$E0AC  DE 05 F0  DEC $F005,X 
$E0AF            .byte $5F,$FA,$D7,$D2
$E0B3  EC FF 7F  CPX $7FFF 
$E0B6  FE 7F A0  INC $A07F,X 
$E0B9  46 46     LSR $46 
$E0BB  FE BF FE  INC $FEBF,X 
$E0BE            .byte $EB,$FF,$BF,$80
$E0C2  86 7E     STX $7E 
$E0C4  BA        TSX 
$E0C5  FE FF EE  INC $EEFF,X 
$E0C8            .byte $FF
$E0C9  FE E9 FF  INC $FFE9,X 
$E0CC            .byte $7F,$E7,$FB
$E0CF  DD DF FA  CMP $FADF,X 
$E0D2  DE 7F 4F  DEC $4F7F,X 
$E0D5  EE AD D6  INC $D6AD 
$E0D8            .byte $77,$F4,$DF
$E0DB  BD FF F7  LDA $F7FF,X 
$E0DE  EE FE D7  INC $D7FE 
$E0E1  6E FD 7F  ROR $7FFD 
$E0E4            .byte $47
$E0E5  F6 FF     INC $FF,X 
$E0E7            .byte $DF
$E0E8  7E BF 2D  ROR $2DBF,X 
$E0EB            .byte $FC,$FF,$FF,$9F
$E0EF  FE 5D FB  INC $FB5D,X 
$E0F2            .byte $EF,$DF
$E0F4  F5 BF     SBC $BF,X 
$E0F6            .byte $FF
$E0F7  FE 5D DD  INC $DD5D,X 
//------------------------------
L_BRS_($E0FB)_($E07D) BAD
//------------------------------
$E0FA  DD DE 57  CMP $57DE,X 
$E0FD  EE BE 00  INC $00BE 
$E100  7E FF BF  ROR $BFFF,X 
$E103            .byte $FF
$E104  FD 7D EF  SBC $EF7D,X 
$E107            .byte $FB,$F7,$DF,$77
$E10B  EA        NOP 
$E10C            .byte $7B,$BB,$BB,$F8,$BF
$E111  FD FF FF  SBC $FFFF,X 
$E114  E9 1F     SBC #$1F
$E116  EC FB DF  CPX $DFFB 
$E119  B5 FE     LDA $FE,X 
$E11B            .byte $FF,$77,$FF,$DF
$E11F  70 0F     BVS L_BRS_($E130)_($E11F) JAM
$E121            .byte $F7,$DF
$E123  D8        CLD 
$E124            .byte $73,$7F,$FF
$E127  61 17     ADC ($17,X) 
$E129  F6 0F     INC $0F,X 
$E12B  F5 7B     SBC $7B,X 
$E12D  A0 0F     LDY #$0F
//------------------------------
L_BRS_($E130)_($E11F) JAM
//------------------------------
$E12F            .byte $FA,$5F,$EB,$4B,$37,$FF
$E135  FE 7F FE  INC $FE7F,X 
$E138  05 62     ORA $62
$E13A            .byte $62,$7F
$E13C  FD 7F D7  SBC $D77F,X 
$E13F            .byte $FF
$E140  FD 01 61  SBC $6101,X 
$E143  7E 5D 7F  ROR $7F5D,X 
//------------------------------
L_BRS_($E14B)_($E1A3) JAM
//------------------------------
$E146            .byte $FF,$77,$FF,$7F,$97,$FF
$E14C  FE E7 DF  INC $DFE7,X 
$E14F            .byte $BB,$FB,$5F,$7B
$E153  FE F2 77  INC $77F2,X 
$E156  B5 6B     LDA $6B,X 
$E158  EE 2F FB  INC $FB2F 
$E15B  BD FF EF  LDA $EFFF,X 
$E15E            .byte $77,$7F,$EB
$E161  76 BF     ROR $BF,X 
$E163  FE E2 6F  INC $6FE2,X 
$E166            .byte $FF,$FB
$E168  7E FD B4  ROR $B4FD,X 
$E16B            .byte $3F,$FF,$FF
$E16E  F9 7F BA  SBC $BA7F,Y 
$E171            .byte $DF,$F7,$FB,$AF
$E175  FD FF 7F  SBC $7FFF,X 
$E178  BA        TSX 
//------------------------------
L_BRS_($E17B)_($E1AB) JAM
//------------------------------
$E179            .byte $BB,$BB,$7B
$E17C  EA        NOP 
$E17D            .byte $77
$E17E  7D 00 2F  ADC $2F00,X 
//------------------------------
L_BRS_($E182)_($E188) JAM
//------------------------------
$E181            .byte $00,$02,$FF,$80
$E185  3E 02 2F  ROL $2F02,X 
$E188  F0 F8     BEQ L_BRS_($E182)_($E188) JAM
$E18A  1E 38 0E  ASL $0E38,X 
$E18D  38        SEC 
$E18E            .byte $0C,$7F,$02,$00,$00,$00
$E194  E0 03     CPX #$03
$E196  F0 1F     BEQ L_BRS_($E1B7)_($E196) JAM
$E198            .byte $9F
$E199  EA        NOP 
$E19A  71 BF     ADC ($BF),Y 
$E19C            .byte $FC,$FF,$F8,$74,$07
$E1A1  40        RTI 
//------------------------------
$E1A2            .byte $00
$E1A3  70 A6     BVS L_BRS_($E14B)_($E1A3) JAM
$E1A5            .byte $00,$00,$FF,$0F
$E1A9  F0 04     BEQ L_BRS_($E1AF)_($E1A9) BAD
$E1AB  30 CE     BMI L_BRS_($E17B)_($E1AB) JAM
//------------------------------
L_BRS_($E1AF)_($E1A9) BAD
L_BRS_($E1AF)_($E1B1) BAD
//------------------------------
$E1AD  7E 07 E0  ROR $E007,X 
$E1B0            .byte $00
$E1B1  30 FC     BMI L_BRS_($E1AF)_($E1B1) BAD
//------------------------------
L_BRS_($E1B7)_($E196) JAM
//------------------------------
$E1B3            .byte $00,$7F,$00,$00,$00,$3F,$E7
$E1BA  E5 00     SBC $00 
//------------------------------
L_BRS_($E1C3)_($E1DD) JAM
//------------------------------
$E1BC            .byte $3F,$00,$E3,$00,$3F,$7F,$FF,$EF
$E1C4            .byte $1C,$00,$00
$E1C7  0E 00 00  ASL $0000 
$E1CA            .byte $04,$00,$00
$E1CD  C6 07     DEC $07 
$E1CF            .byte $3F
$E1D0  C0 03     CPY #$03
$E1D2  3E 00 4F  ROL $4F00,X 
$E1D5  0E CD 16  ASL $16CD 
$E1D8  F0 06     BEQ L_BRS_($E1E0)_($E1D8) OK
$E1DA  C0 7F     CPY #$7F
$E1DC            .byte $00
$E1DD  F0 E4     BEQ L_BRS_($E1C3)_($E1DD) JAM
$E1DF            .byte $00
//------------------------------
L_BRS_($E1E0)_($E1D8) OK
//------------------------------
$E1E0  D0 06     BNE L_BRS_($E1E8)_($E1E0) JAM
$E1E2  01 00     ORA ($00,X)
$E1E4            .byte $6F
$E1E5  FE 6F 1C  INC $1C6F,X 
//------------------------------
L_BRS_($E1E8)_($E1E0) JAM
//------------------------------
$E1E8            .byte $FC,$1F
$E1EA  3E 03 00  ROL $0003,X 
$E1ED            .byte $00
$E1EE  3E 01 04  ROL $0401,X 
$E1F1            .byte $F8,$17
$E1F3  40        RTI 
//------------------------------
$E1F4            .byte $00,$80,$7F
$E1F7  01 04     ORA ($04,X)
$E1F9            .byte $0C
$E1FA  38        SEC 
$E1FB  0E 38 1E  ASL $1E38 
$E1FE  3E 00 F4  ROL $F400,X 
$E201            .byte $00
$E202  40        RTI 
//------------------------------
$E203            .byte $FF
$E204  01 7C     ORA ($7C,X)
$E206  40        RTI 
//------------------------------
$E207            .byte $F4,$0F,$1F
//------------------------------
L_BRS_($E20A)_($E255) OK
//------------------------------
$E20A  78        SEI 
$E20B            .byte $1C
$E20C  70 1C     BVS L_BRS_($E22A)_($E20C) OK
//------------------------------
L_BRS_($E20E)_($E20E) OK
//------------------------------
$E20E  30 FE     BMI L_BRS_($E20E)_($E20E) OK
$E210  40        RTI 
//------------------------------
$E211            .byte $00,$00,$00,$07
$E215  C0 0F     CPY #$0F
$E217            .byte $F8
$E218  F9 57 8E  SBC $8E57,Y 
$E21B  FD 3F FF  SBC $FF3F,X 
$E21E            .byte $1F
$E21F  2E E0 02  ROL $02E0 
$E222            .byte $00
$E223  0E 65 00  ASL $0065 
$E226            .byte $00,$FF
$E228  F0 0F     BEQ L_BRS_($E239)_($E228) JAM
//------------------------------
L_BRS_($E22A)_($E20C) OK
//------------------------------
$E22A  20 0C 73  JSR L_JSR_($730C)_($E22A) OK
$E22D  7E E0 07  ROR $07E0,X 
$E230            .byte $00,$0C,$3F,$00
$E234  FE 00 00  INC $0000,X 
//------------------------------
L_BRS_($E239)_($E228) JAM
//------------------------------
$E237            .byte $00,$FC,$E7,$A7,$00,$FC,$00,$C7
$E23F            .byte $00,$FC
$E241  FE FF F7  INC $F7FF,X 
$E244  38        SEC 
$E245            .byte $00,$00
$E247  70 00     BVS L_BRS_($E249)_($E247) JAM
//------------------------------
L_BRS_($E249)_($E247) JAM
//------------------------------
$E249            .byte $00
$E24A  20 00 00  JSR $0000
$E24D            .byte $63
$E24E  E0 FC     CPX #$FC
$E250            .byte $03
$E251  C0 7C     CPY #$7C
$E253            .byte $00,$F2
$E255  70 B3     BVS L_BRS_($E20A)_($E255) OK
$E257  68        PLA 
$E258            .byte $0F
$E259  60        RTS 
//------------------------------
$E25A            .byte $03
$E25B  FE 00 0F  INC $0F00,X 
$E25E            .byte $27,$00,$0B
$E261  60        RTS 
//------------------------------
$E262            .byte $80,$00
$E264  F6 7F     INC $7F,X 
$E266  F6 38     INC $38,X 
$E268            .byte $3F,$F8,$7C
$E26B  C0 00     CPY #$00
$E26D            .byte $00,$7C,$80
$E270  20 1F E8  JSR L_JSR_($E81F)_($E270) JAM
$E273            .byte $02,$00
$E275  01 FE     ORA ($FE,X)
$E277            .byte $80
$E278  20 30 1C  JSR L_JSR_($1C30)_($E278) OK
$E27B  70 1C     BVS L_BRS_($E299)_($E27B) OK
$E27D  78        SEI 
$E27E            .byte $7C,$00,$AF,$7F,$FA,$FF,$BF
$E285  BE FA AF  LDX $AFFA,Y 
$E288            .byte $F7,$FB
$E28A  A2 BB     LDX #$BB
$E28C  EE BB ED  INC $EDBB 
$E28F            .byte $7F,$FA,$7F,$FF,$FF,$EF,$FB,$F7
$E297            .byte $DF,$9F
//------------------------------
L_BRS_($E299)_($E27B) OK
//------------------------------
$E299  EA        NOP 
$E29A  71 BF     ADC ($BF),Y 
$E29C            .byte $FC,$FF,$FB,$74,$F7,$4F,$F8,$73
$E2A4  A6 FE     LDX $FE 
$E2A6            .byte $FF,$FF,$EF,$F7,$F4,$37
$E2AC  CE 7E F7  DEC $F77E 
$E2AF            .byte $E7,$F8,$37
$E2B2  FD F3 7F  SBC $7FF3,X 
//------------------------------
L_BRS_($E2B5)_($E2F4) JAM
//------------------------------
$E2B5            .byte $7F
$E2B6  FE 7F BF  INC $BF7F,X 
$E2B9            .byte $E7
$E2BA  E5 FF     SBC $FF 
$E2BC            .byte $BF
$E2BD  FE EB FF  INC $FFEB,X 
$E2C0            .byte $BF,$7F,$FF,$EF,$DC
$E2C5  FE FF EE  INC $EEFF,X 
$E2C8            .byte $FF
$E2C9  FE F4 F7  INC $F7F4,X 
$E2CC            .byte $FF
$E2CD  C6 F7     DEC $F7 
$E2CF            .byte $BF,$DF,$FB
$E2D2  BE 7F 4F  LDX $4F7F,Y 
$E2D5  EE CD D6  INC $D6CD 
$E2D8            .byte $F7
$E2D9  F6 DF     INC $DF,X 
$E2DB            .byte $7F,$FF,$F7
$E2DE  E4 FE     CPX $FE 
$E2E0            .byte $D7
$E2E1  06 FD     ASL $FD 
$E2E3            .byte $7F,$6F
$E2E5  FE 6F DC  INC $DC6F,X 
$E2E8            .byte $FC,$9F
$E2EA  3E FB FF  ROL $FFFB,X 
$E2ED            .byte $FF
$E2EE  3E FD 05  ROL $05FD,X 
$E2F1            .byte $FB,$D7,$5F
$E2F4  F0 BF     BEQ L_BRS_($E2B5)_($E2F4) JAM
$E2F6            .byte $7F
$E2F7  FD 05 ED  SBC $ED05,X 
$E2FA            .byte $BB
$E2FB  EE BB A2  INC $A2BB 
$E2FE  BE 00 F5  LDX $F500,Y 
$E301  FE 5F FF  INC $FF5F,X 
$E304  FD 7D 5F  SBC $5F7D,X 
$E307  F5 EF     SBC $EF,X 
$E309            .byte $DF
$E30A  45 DD     EOR $DD 
$E30C            .byte $77
$E30D  DD B7 FE  CMP $FEB7,X 
$E310            .byte $5F
$E311  FE FF FF  INC $FFFF,X 
$E314            .byte $F7,$DF,$EF,$FB
$E318  F9 57 8E  SBC $8E57,Y 
$E31B  FD 3F FF  SBC $FF3F,X 
$E31E            .byte $DF
$E31F  2E EF F2  ROL $F2EF 
$E322            .byte $1F
$E323  CE 65 7F  DEC $7F65 
$E326            .byte $FF,$FF,$F7,$EF,$2F
$E32B  EC 73 7E  CPX $7E73 
$E32E            .byte $EF,$E7,$1F
$E331  EC BF CF  CPX $CFBF 
$E334  FE FE 7F  INC $7FFE,X 
$E337  FE FD E7  INC $E7FD,X 
$E33A            .byte $A7,$FF
$E33C  FD 7F D7  SBC $D77F,X 
$E33F            .byte $FF
$E340  FD FE FF  SBC $FFFE,X                          // Vector: IRQ
$E343            .byte $F7,$3B,$7F,$FF,$77,$FF,$7F,$2F
$E34B            .byte $EF,$FF,$63,$EF
$E34F  FD FB DF  SBC $DFFB,X 
$E352  7D FE F2  ADC $F2FE,X 
$E355            .byte $77,$B3,$6B,$EF,$6F,$FB
$E35B  FE FF EF  INC $EFFF,X 
$E35E            .byte $27,$7F,$EB
$E361  60        RTS 
//------------------------------
$E362            .byte $BF
$E363  FE F6 7F  INC $7FF6,X 
$E366  F6 3B     INC $3B,X 
$E368            .byte $3F
$E369  F9 7C DF  SBC $DF7C,Y 
$E36C            .byte $FF,$FF,$7C,$BF
$E370  A0 DF     LDY #$DF
$E372            .byte $EB,$FA,$0F
$E375  FD FE BF  SBC $BFFE,X 
$E378  A0 B7     LDY #$B7
$E37A  DD 77 DD  CMP $DD77,X 
$E37D  45 7D     EOR $7D 
$E37F            .byte $00,$7F,$80
$E382  01 7E     ORA ($7E,X)
$E384            .byte $80
$E385  7E 07 17  ROR $1707,X 
$E388            .byte $F8
$E389  E8        INX 
$E38A            .byte $3C
$E38B  78        SEI 
$E38C  1E 78 1C  ASL $1C78,X 
$E38F            .byte $80,$02,$00,$00,$00
$E394  70 01     BVS L_BRS_($E397)_($E394) JAM
$E396  78        SEI 
//------------------------------
L_BRS_($E397)_($E394) JAM
//------------------------------
$E397            .byte $1F,$07
$E399  CE 7F 1F  DEC $1F7F 
$E39C  E0 7E     CPX #$7E
$E39E  E8        INX 
$E39F            .byte $17
$E3A0  01 70     ORA ($70,X)
$E3A2            .byte $03
$E3A3  B0 7C     BCS L_BRS_($E421)_($E3A3) OK
$E3A5            .byte $00,$00,$7F,$07,$F8,$07,$F8,$FC
$E3AD            .byte $7F,$07,$F8,$03,$F8
$E3B2  C0 00     CPY #$00
$E3B4            .byte $7F,$00,$00,$00,$4F,$FF,$FF,$00
$E3BC            .byte $3F
$E3BD  01 E7     ORA ($E7,X)
//------------------------------
L_BRS_($E3C3)_($E3DD) JAM
//------------------------------
$E3BF            .byte $00,$3F,$5F,$FF,$FF,$0F,$00,$04
//------------------------------
L_BRS_($E3CA)_($E3E0) JAM
//------------------------------
$E3C7            .byte $0F,$00,$00,$04
$E3CB  08        PHP 
$E3CC            .byte $00
$E3CD  CC 07 7F  CPY $7F07 
$E3D0            .byte $80,$07
$E3D2  7E 00 4F  ROR $4F00,X 
$E3D5  0E EF 1E  ASL $1EEF 
$E3D8  E0 07     CPX #$07
$E3DA  C0 FF     CPY #$FF
$E3DC            .byte $00
$E3DD  F0 E4     BEQ L_BRS_($E3C3)_($E3DD) JAM
$E3DF            .byte $00
$E3E0  F0 E8     BEQ L_BRS_($E3CA)_($E3E0) JAM
$E3E2  01 00     ORA ($00,X)
$E3E4  7E F0 C7  ROR $C7F0,X 
$E3E7            .byte $1F
$E3E8  78        SEI 
$E3E9  0E FE 04  ASL $04FE 
$E3EC            .byte $00,$00
$E3EE  40        RTI 
//------------------------------
$E3EF  01 7C     ORA ($7C,X)
$E3F1  E8        INX 
$E3F2            .byte $0F
$E3F3  E0 07     CPX #$07
$E3F5            .byte $80
$E3F6  FE 00 7E  INC $7E00,X 
$E3F9            .byte $1C
$E3FA  78        SEI 
$E3FB  1E 78 3C  ASL $3C78,X 
$E3FE  7E 00 FE  ROR $FE00,X                          // Set Logical File Parameters/
$E401  01 80     ORA ($80,X)
$E403  7E 01 7E  ROR $7E01,X 
$E406  E0 E8     CPX #$E8
$E408            .byte $1F,$17,$3C
$E40B  1E 78 1E  ASL $1E78,X 
$E40E  38        SEC 
$E40F  01 40     ORA ($40,X)
$E411            .byte $00,$00,$00
$E414  0E 80 1E  ASL $1E80 
$E417            .byte $F8
$E418  E0 73     CPX #$73
$E41A  FE F8 07  INC $07F8,X 
$E41D  7E 17 E8  ROR $E817,X 
$E420            .byte $80
//------------------------------
L_BRS_($E421)_($E3A3) OK
//------------------------------
$E421  0E C0 0D  ASL $0DC0 
$E424  3E 00 00  ROL $0000,X 
$E427  FE E0 1F  INC $1FE0,X 
$E42A  E0 1F     CPX #$1F
$E42C            .byte $3F
$E42D  FE E0 1F  INC $1FE0,X 
$E430  C0 1F     CPY #$1F
$E432            .byte $03,$00
$E434  FE 00 00  INC $0000,X 
$E437            .byte $00,$F2,$FF,$FF,$00,$FC,$80,$E7
$E43F            .byte $00,$FC,$FA,$FF,$FF
$E444  F0 00     BEQ L_BRS_($E446)_($E444) OK
//------------------------------
L_BRS_($E446)_($E444) OK
//------------------------------
$E446  20 F0 00  JSR $00F0
$E449            .byte $00
$E44A  20 10 00  JSR $0010
$E44D            .byte $33
//------------------------------
L_BRS_($E44E)_($E455) OK
//------------------------------
$E44E  E0 FE     CPX #$FE
$E450  01 E0     ORA ($E0,X)
$E452  7E 00 F2  ROR $F200,X 
$E455  70 F7     BVS L_BRS_($E44E)_($E455) OK
$E457  78        SEI 
$E458            .byte $07
$E459  E0 03     CPX #$03
$E45B            .byte $FF,$00,$0F,$27,$00,$0F,$17,$80
$E463            .byte $00
$E464  7E 0F E3  ROR $E30F,X 
$E467            .byte $F8
$E468  1E 70 7F  ASL $7F70,X 
$E46B  20 00 00  JSR $0000
$E46E            .byte $02,$80
$E470  3E 17 F0  ROL $F017,X                          // Send to RS232 Buffer
$E473            .byte $07
$E474  E0 01     CPX #$01
$E476            .byte $7F,$00
$E478  7E 38 1E  ROR $1E38,X 
$E47B  78        SEI 
$E47C  1E 3C 7E  ASL $7E3C,X 
$E47F            .byte $00,$7F,$BF
$E482  FD 7E BF  SBC $BF7E,X 
$E485  7E F7 D7  ROR $D7F7,X 
$E488            .byte $FB,$EB
$E48A  BD 7B DE  LDA $DE7B,X 
$E48D            .byte $7B
$E48E  DD 80 FA  CMP $FA80,X 
$E491            .byte $FF,$FF,$FF,$77
$E495  9D 7B DF  STA $DF7B,X 
$E498            .byte $07
$E499  CE 7F 1F  DEC $1F7F 
$E49C  E1 7E     SBC ($7E,X) 
$E49E            .byte $EB,$17
$E4A0  F1 77     SBC ($77),Y 
$E4A2            .byte $9B,$B7
$E4A4  7D FF 7F  ADC $7FFF,X 
$E4A7            .byte $7F,$F7,$FB,$97,$FB
$E4AC  FD 7F F7  SBC $F77F,X 
$E4AF            .byte $FB,$9B,$FB
$E4B2  C1 FF     CMP ($FF,X) 
$E4B4            .byte $7F,$7F
$E4B6  FE 7F 4F  INC $4F7F,X 
$E4B9            .byte $FF,$FF,$FF,$BF
$E4BD  FD E7 FF  SBC $FFE7,X                          // Close All Channels And Files
$E4C0            .byte $BF,$5F,$FF,$FF,$EF,$FF,$F4,$EF
$E4C8            .byte $FF
$E4C9  FE F4 CB  INC $CBF4,X 
$E4CC            .byte $FF
$E4CD  CD F7 7F  CMP $7FF7 
$E4D0            .byte $BF,$F7
$E4D2  7E 7F 4F  ROR $4F7F,X 
$E4D5  EE EF DE  INC $DEEF 
$E4D8            .byte $E3,$F7,$DF,$FF
$E4DC  FE F7 E4  INC $E4F7,X 
$E4DF  FE F7 E8  INC $E8F7,X 
$E4E2  FD 3F 7E  SBC $7E3F,X 
$E4E5  F1 C7     SBC ($C7),Y 
$E4E7            .byte $DF
$E4E8  79 EE FE  ADC $FEEE,Y 
$E4EB            .byte $F4,$FF,$FF
$E4EE  41 FD     EOR ($FD,X) 
$E4F0  7D EB EF  ADC $EFEB,X 
$E4F3            .byte $EF,$F7,$BF
$E4F6  FE FE 7E  INC $7EFE,X 
$E4F9  DD 7B DE  CMP $DE7B,X 
$E4FC            .byte $7B
$E4FD  BD 7E 00  LDA $007E,X 
//------------------------------
L_JSR_($E501)_($B526) BAD
L_JSR_($E501)_($F1A1) BAD
//------------------------------
$E500  FE FD BF  INC $BFFD,X 
$E503  7E FD 7E  ROR $7EFD,X 
$E506            .byte $EF,$EB,$DF,$D7
$E50A  BD DE 7B  LDA $7BDE,X 
$E50D  DE BB 01  DEC $01BB,X 
$E510            .byte $5F,$FF,$FF,$FF
$E514  EE B9 DE  INC $DEB9 
$E517            .byte $FB
$E518  E0 73     CPX #$73
$E51A  FE F8 87  INC $87F8,X 
$E51D  7E D7 E8  ROR $E8D7,X 
$E520            .byte $8F
$E521  EE D9 ED  INC $EDD9 
$E524  BE FF FE  LDX $FEFF,Y 
$E527  FE EF DF  INC $DFEF,X 
$E52A  E9 DF     SBC #$DF
$E52C            .byte $BF
$E52D  FE EF DF  INC $DFEF,X 
$E530  D9 DF 83  CMP $83DF,Y 
$E533            .byte $FF
$E534  FE FE 7F  INC $7FFE,X 
$E537  FE F2 FF  INC $FFF2,X 
$E53A            .byte $FF,$FF
$E53C  FD BF E7  SBC $E7BF,X 
$E53F            .byte $FF
$E540  FD FA FF  SBC $FFFA,X                          // Vector: NMI
//------------------------------
L_JSR_($E544)_($C012) JAM
L_JSR_($E544)_($FC2E) JAM
//------------------------------
$E543            .byte $FF,$F7,$FF,$2F,$F7,$FF,$7F,$2F
$E54B            .byte $D3,$FF,$B3,$EF
$E54F  FE FD EF  INC $EFFD,X 
//------------------------------
L_BRS_($E553)_($E5A1) BAD
//------------------------------
$E552  7E FE F2  ROR $F2FE,X 
$E555            .byte $77,$F7,$7B,$C7,$EF,$FB,$FF,$7F
$E55D            .byte $EF,$27,$7F,$EF,$17,$BF,$FC
$E564  7E 8F E3  ROR $E38F,X 
$E567            .byte $FB,$9E,$77,$7F,$2F,$FF,$FF,$82
$E56F            .byte $BF
$E570  BE D7 F7  LDX $F7D7,Y                          // Set Buffer Stat / End Pointers
$E573            .byte $F7,$EF
$E575  FD 7F 7F  SBC $7F7F,X 
$E578  7E BB DE  ROR $DEBB,X 
$E57B            .byte $7B
$E57C  DE BD 7E  DEC $7EBD,X 
$E57F  10 00     BPL L_BRS_($E581)_($E57F) JAM
//------------------------------
L_BRS_($E581)_($E57F) JAM
//------------------------------
$E581            .byte $00,$1B
$E583  C0 44     CPY #$44
$E585  98        TYA 
$E586  24 40     BIT $40 
$E588            .byte $00,$00
$E58A  01 BC     ORA ($BC,X)
$E58C            .byte $00,$04
$E58E  49 80     EOR #$80
$E590  01 44     ORA ($44,X)
$E592            .byte $00,$12
$E594  20 02 52  JSR L_JSR_($5202)_($E594) JAM
$E597            .byte $00,$04,$1B
$E59A  01 64     ORA ($64,X)
$E59C            .byte $00,$00,$00
$E59F  38        SEC 
$E5A0            .byte $FC
$E5A1  50 B0     BVC L_BRS_($E553)_($E5A1) BAD
$E5A3            .byte $32,$1F
$E5A5  C0 00     CPY #$00
$E5A7            .byte $00,$00,$03,$8F
$E5AB  C0 0B     CPY #$0B
$E5AD            .byte $03
$E5AE  20 03 DE  JSR L_JSR_($DE03)_($E5AE) BAD
$E5B1            .byte $00,$3F
$E5B3  50 01     BVC L_BRS_($E5B6)_($E5B3) OK
$E5B5            .byte $FC
//------------------------------
L_BRS_($E5B6)_($E5B3) OK
//------------------------------
$E5B6  08        PHP 
$E5B7  38        SEC 
$E5B8  E0 00     CPX #$00
$E5BA            .byte $00,$3C,$FC
$E5BD  5E C6 1D  LSR $1DC6,X 
//------------------------------
L_BRS_($E5C0)_($E5DA) OK
//------------------------------
$E5C0  5E 00 A4  LSR $A400,X 
$E5C3  06 00     ASL $00 
$E5C5  50 5C     BVC L_BRS_($E623)_($E5C5) JAM
$E5C7            .byte $00,$00
$E5C9  D0 14     BNE L_BRS_($E5DF)_($E5C9) BAD
$E5CB            .byte $00,$00,$8F
$E5CE  0E E4 00  ASL $00E4 
$E5D1            .byte $E7,$0C,$80
$E5D4  E4 3E     CPX $3E 
$E5D6            .byte $9C,$0B,$00,$00
$E5DA  F0 E4     BEQ L_BRS_($E5C0)_($E5DA) OK
$E5DC            .byte $00
$E5DD  48        PHA 
//------------------------------
L_BRS_($E5DF)_($E5C9) BAD
//------------------------------
$E5DE  EE 02 C0  INC $C002 
$E5E1  B9 DA 06  LDA $06DA,Y 
$E5E4            .byte $00,$03,$CF
$E5E7  C0 05     CPY #$05
//------------------------------
L_BRS_($E5EB)_($E629) BAD
//------------------------------
$E5E9  EC 60 01  CPX $0160 
$E5EC  B5 E0     LDA $E0,X 
$E5EE  1D 5E 00  ORA $005E,X
$E5F1  05 3C     ORA $3C
$E5F3  7E 00 00  ROR $0000,X 
$E5F6            .byte $00,$07,$1A
$E5F9  A0 4A     LDY #$4A
$E5FB            .byte $00
$E5FC  08        PHP 
$E5FD            .byte $00,$00
$E5FF  D8        CLD 
$E600            .byte $03,$22
$E602  19 24 02  ORA $0224,Y
$E605            .byte $00,$00,$80
$E608  3D 00 20  AND $2000,X 
$E60B            .byte $92
$E60C  01 80     ORA ($80,X)
$E60E            .byte $22,$00
$E610  48        PHA 
$E611            .byte $04
$E612  40        RTI 
//------------------------------
$E613  4A        LSR A 
$E614            .byte $00
$E615  20 D8 80  JSR L_JSR_($80D8)_($E615) JAM
$E618  26 00     ROL $00 
$E61A            .byte $00,$00,$1C,$3F
$E61E  0A        ASL A 
$E61F  0D 4C F8  ORA $F84C
//------------------------------
L_BRS_($E623)_($E5C5) JAM
//------------------------------
$E622            .byte $03,$00,$00,$00
$E626  C0 F1     CPY #$F1
$E628            .byte $03
$E629  D0 C0     BNE L_BRS_($E5EB)_($E629) BAD
$E62B            .byte $04
$E62C  C0 7B     CPY #$7B
$E62E            .byte $00,$FC
$E630  0A        ASL A 
$E631            .byte $80,$3F
$E633  10 1C     BPL L_BRS_($E651)_($E633) JAM
$E635            .byte $07,$00,$00,$3C,$3F,$7A,$63,$B8
$E63D            .byte $7A,$00
$E63F  25 60     AND $60
$E641            .byte $00
$E642  0A        ASL A 
$E643            .byte $3A,$00,$00,$0B
$E647  28        PLP 
$E648            .byte $00,$00
$E64A  F1 70     SBC ($70),Y 
$E64C            .byte $27,$00,$E7
$E64F  30 01     BMI L_BRS_($E652)_($E64F) JAM
//------------------------------
L_BRS_($E651)_($E633) JAM
L_BRS_($E652)_($E64F) JAM
//------------------------------
$E651            .byte $27,$7C
$E653  39 D0 00  AND $00D0,Y 
$E656            .byte $00,$0F,$27,$00,$12,$77
$E65C  40        RTI 
//------------------------------
$E65D            .byte $03
$E65E  9D DA 06  STA $06DA,X 
$E661            .byte $00
$E662  C0 F3     CPY #$F3
$E664            .byte $03
$E665  A0 37     LDY #$37
$E667  06 80     ASL $80 
$E669  AD 07 B8  LDA $B807 
$E66C            .byte $7A,$00
$E66E  A0 3C     LDY #$3C
$E670  7E 00 00  ROR $0000,X 
$E673            .byte $00
$E674  E0 58     CPX #$58
$E676  05 52     ORA $52
$E678            .byte $00,$00,$E3,$FF,$DB,$DF,$44,$9B
$E680  A4 5F     LDY $5F 
$E682  FE 3F FD  INC $FD3F,X 
$E685  BD FF F4  LDA $F4FF,X 
$E688  49 BF     EOR #$BF
$E68A  FD 45 FF  SBC $FF45,X 
$E68D            .byte $D2,$2F,$FA,$52,$FF
$E692  E5 9B     SBC $9B 
$E694  FD 64 E0  SBC $E064,X 
$E697            .byte $7F,$FF,$B8
$E69A  FD 50 B0  SBC $B050,X 
$E69D            .byte $32,$DF,$DF
$E6A0  FE 07 FF  INC $FF07,X                          // NMI RS232 Out
$E6A3            .byte $FB,$8F,$DF,$EB,$03,$2F,$FB
$E6AA  DE FF BF  DEC $BFFF,X 
$E6AD            .byte $57
$E6AE  FD FD 8B  SBC $8BFD,X 
$E6B1            .byte $B8
$E6B2  E0 E1     CPX #$E1
$E6B4            .byte $FF
$E6B5  BC FD 5E  LDY $5EFD,X 
$E6B8  C6 DD     DEC $DD 
$E6BA  5E FF A5  LSR $A5FF,X 
$E6BD  F6 19     INC $19,X 
$E6BF            .byte $57,$5C,$FF,$FF,$D7,$D4,$FF,$7F
$E6C7            .byte $8F
$E6C8  EE E4 FF  INC $FFE4                          // Get From Keyboad
$E6CB            .byte $E7
$E6CC  EC BF E4  CPX $E4BF 
$E6CF  BE 9D EB  LDX $EB9D,Y 
$E6D2            .byte $3F,$FC,$F7
$E6D5  E4 FE     CPX $FE 
$E6D7            .byte $4B
$E6D8  EE FA DF  INC $DFFA 
$E6DB  B9 FE FF  LDA $FFFE,Y                          // Vector: IRQ
$E6DE            .byte $C3
$E6DF  FE 1F FF  INC $FF1F,X 
$E6E2            .byte $FB,$CF,$DF
$E6E5  F5 EC     SBC $EC,X 
$E6E7            .byte $6F
$E6E8  FD B5 EF  SBC $EFB5,X 
$E6EB  DD 5E FF  CMP $FF5E,X 
$E6EE  F5 3C     SBC $3C,X 
$E6F0  7E FF FF  ROR $FFFF,X 
$E6F3            .byte $FF,$F7,$5A,$AF
$E6F7  4A        LSR A 
$E6F8            .byte $FF,$00,$C7,$FF,$DB,$FB,$22
$E6FF  D9 25 FA  CMP $FA25,Y 
$E702            .byte $7F,$FC,$BF
$E705  BD FF 2F  LDA $2FFF,X 
$E708            .byte $92
$E709  FD BF A2  SBC $A2BF,X 
$E70C            .byte $FF,$4B,$F4,$5F
$E710  4A        LSR A 
$E711            .byte $FF,$A7
$E713  D9 BF 26  CMP $26BF,Y 
$E716            .byte $07
$E717  FE FF 1D  INC $1DFF,X 
$E71A            .byte $BF
$E71B  0A        ASL A 
$E71C  0D 4C FB  ORA $FB4C
$E71F            .byte $FB,$7F
$E721  E0 FF     CPX #$FF
$E723            .byte $DF
$E724  F1 FB     SBC ($FB),Y 
$E726            .byte $D7
$E727  C0 F4     CPY #$F4
$E729            .byte $DF,$7B,$FF
$E72C  FD EA BF  SBC $BFEA,X 
$E72F            .byte $BF
$E730  D1 1D     CMP ($1D),Y 
$E732            .byte $07,$87,$FF
$E735  3D BF 7A  AND $7ABF,X 
$E738            .byte $63,$BB,$7A,$FF
$E73C  A5 6F     LDA $6F 
$E73E            .byte $FF
$E73F  EA        NOP 
$E740            .byte $3A,$FF,$FF,$EB,$2B,$FF
$E746  FE F1 77  INC $77F1,X 
$E749            .byte $27,$FF,$E7,$37
$E74D  FD 27 7D  SBC $7D27,X 
$E750  B9 D7 FC  LDA $FCD7,Y 
$E753            .byte $3F,$EF,$27,$7F,$D2,$77,$5F,$FB
$E75B  9D 7F FF  STA $FF7F,X 
$E75E            .byte $C3,$7F,$F8,$FF,$DF,$F3,$FB,$AF
$E766            .byte $37
$E767  F6 BF     INC $BF,X 
$E769  AD F7 BB  LDA $BBF7 
$E76C            .byte $7A,$FF,$AF,$3C
$E770  7E FF FF  ROR $FFFF,X 
$E773            .byte $FF,$EF,$5A
$E776  F5 52     SBC $52,X 
$E778            .byte $FF,$00,$1C,$00,$3F
$E77D  A0 48     LDY #$48
$E77F  90 14     BCC L_BRS_($E795)_($E77F) OK
$E781  40        RTI 
//------------------------------
$E782  01 C0     ORA ($C0,X)
$E784            .byte $03,$FA,$00,$04
$E788  91 00     STA ($00),Y 
$E78A  01 8C     ORA ($8C,X)
$E78C            .byte $00,$12
$E78E  20 04 89  JSR L_JSR_($8904)_($E78E) OK
$E791            .byte $00
$E792  0A        ASL A 
$E793            .byte $7F,$00
//------------------------------
L_BRS_($E795)_($E77F) OK
//------------------------------
$E795  E4 1F     CPX $1F 
$E797            .byte $80,$00,$4F,$C2
$E79B  4E A3 54  LSR $54A3 
$E79E            .byte $1F
$E79F  C0 01     CPY #$01
$E7A1            .byte $F8,$00,$04,$FC
$E7A5  20 0A 35  JSR L_JSR_($350A)_($E7A5) OK
$E7A8  40        RTI 
//------------------------------
$E7A9            .byte $03,$CF,$00,$1F
$E7AD  50 00     BVC L_BRS_($E7AF)_($E7AD) JAM
//------------------------------
L_BRS_($E7AF)_($E7AD) JAM
//------------------------------
$E7AF            .byte $FC,$14,$4F,$3B
$E7B3  1E 00 7D  ASL $7D00,X 
$E7B6            .byte $F4
$E7B7  7D 2E 1D  ADC $1D2E,X 
//------------------------------
L_BRS_($E7BA)_($E7D4) OK
//------------------------------
$E7BA  5E 00 E4  LSR $E400,X 
$E7BD  06 00     ASL $00 
$E7BF  D0 4E     BNE L_BRS_($E80F)_($E7BF) OK
$E7C1            .byte $00,$00
$E7C3  50 12     BVC L_BRS_($E7D7)_($E7C3) OK
$E7C5            .byte $00,$00,$8F,$0F,$F4,$00,$F3,$0C
$E7CD            .byte $80
$E7CE  E8        INX 
$E7CF  26 FE     ROL $FE 
$E7D1            .byte $0F
$E7D2  C0 03     CPY #$03
//------------------------------
L_BRS_($E7D4)_($E826) OK
//------------------------------
$E7D4  70 E4     BVS L_BRS_($E7BA)_($E7D4) OK
$E7D6            .byte $00
//------------------------------
L_BRS_($E7D7)_($E7C3) OK
L_BRS_($E7D7)_($E7F5) OK
//------------------------------
$E7D7  88        DEY 
$E7D8  6E 02 E0  ROR $E002 
$E7DB            .byte $FF,$00,$00,$3C
$E7DF  01 E0     ORA ($E0,X)
$E7E1            .byte $00,$07,$DF
$E7E4  40        RTI 
//------------------------------
$E7E5            .byte $07,$D2
$E7E7  E0 01     CPX #$01
$E7E9            .byte $97
$E7EA  E0 19     CPX #$19
$E7EC  5E 00 04  LSR $0400,X 
$E7EF  FD 1D 00  SBC $001D,X 
$E7F2            .byte $00,$00,$04
$E7F5  90 E0     BCC L_BRS_($E7D7)_($E7F5) OK
$E7F7  45 00     EOR $00 
$E7F9            .byte $00
$E7FA  38        SEC 
$E7FB            .byte $00,$FC
$E7FD  05 12     ORA $12
$E7FF  09 28     ORA #$28
$E801            .byte $02,$80,$03
$E804  C0 5F     CPY #$5F
$E806            .byte $00
$E807  20 89 00  JSR $0089
$E80A            .byte $80
$E80B  31 00     AND ($00),Y 
$E80D  48        PHA 
$E80E            .byte $04
//------------------------------
L_BRS_($E80F)_($E7BF) OK
//------------------------------
$E80F  20 91 00  JSR $0091
//------------------------------
L_BRS_($E812)_($E812) OK
//------------------------------
$E812  50 FE     BVC L_BRS_($E812)_($E812) OK
$E814            .byte $00,$27,$F8
$E817  01 00     ORA ($00,X)
$E819            .byte $F2,$43,$72
$E81C  C5 2A     CMP $2A 
//------------------------------
L_JSR_($E81F)_($A5F1) JAM
L_JSR_($E81F)_($E270) JAM
//------------------------------
$E81E            .byte $F8,$03,$80,$1F,$00
$E823  20 3F 04  JSR $043F
$E826  50 AC     BVC L_BRS_($E7D4)_($E826) OK
$E828            .byte $02
$E829  C0 F3     CPY #$F3
$E82B            .byte $00,$F8
$E82D  0A        ASL A 
$E82E            .byte $00,$3F
$E830  28        PLP 
$E831            .byte $F2,$DC
$E833  78        SEI 
$E834            .byte $00
$E835  BE 2F BE  LDX $BE2F,Y 
$E838            .byte $74,$B8,$7A,$00,$27
$E83D  60        RTS 
//------------------------------
$E83E            .byte $00,$0B,$72,$00,$00
$E843  0A        ASL A 
$E844  48        PHA 
$E845            .byte $00,$00
$E847  F1 F0     SBC ($F0),Y 
$E849            .byte $2F,$00,$CF
$E84C  30 01     BMI L_BRS_($E84F)_($E84C) JAM
//------------------------------
L_BRS_($E84F)_($E84C) JAM
//------------------------------
$E84E            .byte $17,$64,$7F
$E851  F0 03     BEQ L_BRS_($E856)_($E851) JAM
$E853  C0 0E     CPY #$0E
//------------------------------
L_BRS_($E856)_($E851) JAM
//------------------------------
$E855            .byte $27,$00
$E857  11 76     ORA ($76),Y
$E859  40        RTI 
//------------------------------
$E85A            .byte $07,$FF,$00,$00,$3C,$80,$07,$00
$E862  E0 FB     CPX #$FB
$E864            .byte $02
$E865  E0 4B     CPX #$4B
$E867            .byte $07,$80
$E869  E9 07     SBC #$07
$E86B  98        TYA 
$E86C            .byte $7A,$00
$E86E  20 BF B8  JSR L_JSR_($B8BF)_($E86E) JAM
$E871            .byte $00,$00,$00
$E874  20 09 07  JSR $0709
$E877  A2 00     LDX #$00
$E879            .byte $00,$DC,$FF,$BF,$AF
$E87E  48        PHA 
$E87F            .byte $97,$D4,$5F
$E882  FD CF FB  SBC $FBCF,X 
$E885            .byte $FA,$FF,$F4
$E888  91 7F     STA ($7F),Y 
$E88A  FD 8D FF  SBC $FF8D,X                          // Change Vectors For User
$E88D            .byte $D2,$2F,$F4,$89,$7F
$E892  EA        NOP 
$E893            .byte $7F
$E894  FE E4 DF  INC $DFE4,X 
$E897            .byte $9F,$FF,$4F,$C2
$E89B  4E A3 55  LSR $55A3 
$E89E            .byte $DF,$DF
$E8A0  FD F9 FF  SBC $FFF9,X 
$E8A3            .byte $F4,$FC,$2F
$E8A6  EA        NOP 
$E8A7  35 5F     AND $5F,X 
$E8A9            .byte $FB,$CF,$7F
$E8AC  E9 57     SBC #$57
$E8AE  FE FD D5  INC $D5FD,X 
$E8B1            .byte $4F,$3B
$E8B3  DE FF 7D  DEC $7DFF,X 
$E8B6  F5 7D     SBC $7D,X 
$E8B8  2E DD 5E  ROL $5EDD 
$E8BB            .byte $FF
$E8BC  E5 F6     SBC $F6 
$E8BE            .byte $BF,$D7
$E8C0  4E FF FC  LSR $FCFF 
$E8C3            .byte $57,$D2,$FF,$7F,$8F,$EF,$F4,$F8
$E8CB            .byte $F3
$E8CC  EC BF E8  CPX $E8BF 
$E8CF  A6 FE     LDX $FE 
$E8D1            .byte $EF,$DF,$FB,$77
$E8D5  E4 FE     CPX $FE 
$E8D7            .byte $8B
$E8D8  6E FA EF  ROR $EFFA 
$E8DB            .byte $FF
$E8DC  FE FF BD  INC $BDFF,X 
$E8DF  FD EF FF  SBC $FFEF,X 
//------------------------------
L_BRS_($E8E6)_($E8F5) JAM
//------------------------------
$E8E2            .byte $F7,$DF,$5F,$F7,$D2,$EF
$E8E8  FD 97 EF  SBC $EF97,X 
$E8EB  D9 5E FF  CMP $FF5E,Y 
$E8EE            .byte $F4
$E8EF  FD 9D FF  SBC $FF9D,X 
$E8F2            .byte $FF,$FF,$F4
$E8F5  90 EF     BCC L_BRS_($E8E6)_($E8F5) JAM
$E8F7  45 FF     EOR $FF 
$E8F9            .byte $00,$3B,$FF
$E8FC  FD F5 12  SBC $12F5,X 
$E8FF  E9 2B     SBC #$2B
$E901            .byte $FA,$BF,$F3,$DF,$5F,$FF,$2F,$89
$E909  FE BF B1  INC $B1BF,X                          // FAC#1 to Positive Integer
$E90C            .byte $FF,$4B,$F4,$2F
$E910  91 FE     STA ($FE),Y 
$E912            .byte $57
$E913  FE 7F 27  INC $277F,X 
$E916            .byte $FB
$E917  F9 FF F2  SBC $F2FF,Y 
$E91A            .byte $43,$72
$E91C  C5 AA     CMP $AA 
$E91E            .byte $FB,$FB,$BF,$9F,$FF,$2F,$3F,$F4
$E926            .byte $57
$E927  AC FA DF  LDY $DFFA 
$E92A            .byte $F3
$E92B  FE FB EA  INC $EAFB,X 
$E92E            .byte $7F,$BF,$AB,$F2,$DC,$7B,$FF
$E935  BE AF BE  LDX $BEAF,Y 
$E938            .byte $74,$BB,$7A,$FF,$A7,$6F
$E93E  FD EB 72  SBC $72EB,X 
$E941            .byte $FF,$3F
$E943  EA        NOP 
$E944            .byte $4B,$FF
$E946  FE F1 F7  INC $F7F1,X 
$E949            .byte $2F,$1F,$CF,$37
$E94D  FD 17 65  SBC $6517,X 
$E950            .byte $7F,$F7,$FB,$DF
$E954  EE 27 7F  INC $7F27 
$E957  D1 76     CMP ($76),Y 
$E959            .byte $5F,$F7,$FF,$7F,$FF
$E95E  BD BF F7  LDA $F7BF,X 
$E961            .byte $FF,$EF,$FB,$FA,$EF,$4B,$F7,$BF
$E969  E9 F7     SBC #$F7
$E96B            .byte $9B,$7A,$FF,$2F,$BF
$E970  B9 FF FF  LDA $FFFF,Y 
$E973            .byte $FF,$2F
$E975  09 F7     ORA #$F7
$E977  A2 FF     LDX #$FF
$E979            .byte $00,$03,$00
$E97C  6E 10 68  ROR $6810 
$E97F  70 14     BVS L_BRS_($E995)_($E97F) OK
$E981  40        RTI 
//------------------------------
$E982            .byte $00
$E983  30 06     BMI L_BRS_($E98B)_($E983) OK
$E985  E1 00     SBC ($00,X) 
$E987  06 87     ASL $87 
$E989            .byte $00,$00
//------------------------------
L_BRS_($E98B)_($E983) OK
//------------------------------
$E98B  8E 00 12  STX $1200 
$E98E  20 04 88  JSR L_JSR_($8804)_($E98E) OK
$E991            .byte $80
$E992  09 8E     ORA #$8E
$E994            .byte $00
//------------------------------
L_BRS_($E995)_($E97F) OK
//------------------------------
$E995  28        PLP 
$E996            .byte $0F
$E997  E0 00     CPX #$00
$E999  85 C2     STA $C2 
$E99B  48        PHA 
$E99C            .byte $C7
$E99D  8C 1F C0  STY $C01F 
$E9A0            .byte $00
$E9A1  FE 00 08  INC $0800,X 
$E9A4            .byte $5C
$E9A5  20 0C 78  JSR L_JSR_($780C)_($E9A5) BAD
$E9A8  C0 07     CPY #$07
$E9AA            .byte $CF,$80,$1F
$E9AD  20 00 7E  JSR L_JSR_($7E00)_($E9AD) JAM
$E9B0            .byte $12
$E9B1  85 23     STA $23 
$E9B3  21 00     AND ($00,X) 
$E9B5  7E F4 7E  ROR $7EF4,X 
$E9B8  1E 1F 5C  ASL $5C1F,X 
$E9BB            .byte $00
$E9BC  B4 0E     LDY $0E,X 
$E9BE  40        RTI 
//------------------------------
$E9BF  A0 47     LDY #$47
$E9C1            .byte $00,$03
$E9C3  20 17 00  JSR $0017
$E9C6            .byte $00,$9F,$0F,$F4,$07
$E9CB  F1 09     SBC ($09),Y 
$E9CD  40        RTI 
//------------------------------
$E9CE            .byte $EF
$E9CF  1E ED 14  ASL $14ED,X 
$E9D2  20 04 70  JSR L_JSR_($7004)_($E9D2) JAM
$E9D5  E4 00     CPX $00 
$E9D7            .byte $F4
$E9D8  EE 01 D0  INC $D001                          // Sprite 0 Y Pos
$E9DB  6E 01 00  ROR $0001 
$E9DE            .byte $42,$02
$E9E0  10 00     BPL L_BRS_($E9E2)_($E9E0) JAM
//------------------------------
L_BRS_($E9E2)_($E9E0) JAM
//------------------------------
$E9E2            .byte $07,$EF
$E9E4  40        RTI 
//------------------------------
$E9E5            .byte $07
$E9E6  E1 E0     SBC ($E0,X) 
$E9E8  01 95     ORA ($95,X)
$E9EA  E0 19     CPX #$19
$E9EC            .byte $5C,$00
$E9EE  05 FE     ORA $FE
$E9F0            .byte $1C,$00,$00,$00,$04
$E9F5  8D 60 44  STA $4460 
$E9F8            .byte $00,$00
$E9FA  C0 00     CPY #$00
$E9FC  76 08     ROR $08,X 
$E9FE  16 0E     ASL $0E,X 
$EA00  28        PLP 
$EA01            .byte $02,$00,$0C
$EA04  60        RTS 
//------------------------------
$EA05            .byte $87,$00
$EA07  60        RTS 
//------------------------------
$EA08  E1 00     SBC ($00,X) 
$EA0A            .byte $00
$EA0B  71 00     ADC ($00),Y 
$EA0D  48        PHA 
$EA0E            .byte $04
$EA0F  20 11 01  JSR $0111
$EA12  90 71     BCC L_BRS_($EA85)_($EA12) BAD
$EA14            .byte $00,$14
$EA16  F0 07     BEQ L_BRS_($EA1F)_($EA16) JAM
$EA18            .byte $00
$EA19  A1 43     LDA ($43,X) 
$EA1B            .byte $12,$E3
$EA1D  31 F8     AND ($F8),Y 
//------------------------------
L_BRS_($EA1F)_($EA16) JAM
//------------------------------
$EA1F            .byte $03,$00,$7F,$00
$EA23  10 3A     BPL L_BRS_($EA5F)_($EA23) OK
$EA25            .byte $04
$EA26  30 1E     BMI L_BRS_($EA46)_($EA26) JAM
$EA28            .byte $03
$EA29  E0 F3     CPX #$F3
$EA2B  01 F8     ORA ($F8,X)
$EA2D            .byte $04,$00
$EA2F  7E 48 A1  ROR $A148,X 
$EA32  C4 84     CPY $84 
$EA34            .byte $00
$EA35  7E 2F 7E  ROR $7E2F,X 
$EA38  78        SEI 
$EA39            .byte $F8,$3A,$00
$EA3C  2D 70 02  AND $0270 
$EA3F  05 E2     ORA $E2
$EA41            .byte $00
$EA42  C0 04     CPY #$04
$EA44  E8        INX 
//------------------------------
L_BRS_($EA46)_($EA26) JAM
//------------------------------
$EA45            .byte $00,$00
$EA47  F9 F0 2F  SBC $2FF0,Y 
$EA4A  E0 8F     CPX #$8F
$EA4C  90 02     BCC L_BRS_($EA50)_($EA4C) JAM
$EA4E            .byte $F7
$EA4F  78        SEI 
//------------------------------
L_BRS_($EA50)_($EA4C) JAM
//------------------------------
$EA50            .byte $B7
$EA51  28        PLP 
$EA52            .byte $04
$EA53  20 0E 27  JSR L_JSR_($270E)_($EA53) BAD
$EA56            .byte $00,$2F,$77,$80,$0B
$EA5B  76 80     ROR $80,X 
$EA5D            .byte $00,$42
//------------------------------
L_BRS_($EA5F)_($EA23) OK
//------------------------------
$EA5F  40        RTI 
//------------------------------
$EA60  08        PHP 
$EA61            .byte $00
$EA62  E0 F7     CPX #$F7
$EA64            .byte $02
$EA65  E0 87     CPX #$87
$EA67            .byte $07,$80
$EA69  A9 07     LDA #$07
$EA6B  98        TYA 
$EA6C            .byte $3A,$00
$EA6E  A0 7F     LDY #$7F
$EA70  38        SEC 
$EA71            .byte $00,$00,$00
$EA74  20 B1 06  JSR $06B1
$EA77            .byte $22,$00,$00,$C3,$7F
$EA7C  6E 17 68  ROR $6817 
$EA7F            .byte $77,$D4,$5F,$FC,$37
//------------------------------
L_BRS_($EA85)_($EA12) BAD
//------------------------------
$EA84  F6 E1     INC $E1,X 
$EA86            .byte $7F
$EA87  F6 87     INC $87,X 
$EA89            .byte $7F
$EA8A  FE 8E FF  INC $FF8E,X 
$EA8D            .byte $D2,$2F,$F4
$EA90  A8        TAY 
$EA91            .byte $BF
$EA92  E9 8E     SBC #$8E
$EA94            .byte $FF
$EA95  28        PLP 
$EA96            .byte $EF,$EF
$EA98  FE 85 C2  INC $C285,X 
$EA9B  48        PHA 
$EA9C            .byte $C7
$EA9D  8D DF DF  STA $DFDF 
$EAA0  FE FE 7F  INC $7FFE,X 
$EAA3  E8        INX 
$EAA4            .byte $5C,$2F
$EAA6  EC 78 DF  CPX $DF78 
$EAA9            .byte $F7,$CF,$BF
$EAAC  E0 2F     CPX #$2F
$EAAE            .byte $FF
$EAAF  7E D2 85  ROR $85D2,X 
$EAB2            .byte $A3
$EAB3  A1 7F     LDA ($7F,X) 
$EAB5  7E F5 7E  ROR $7EF5,X 
$EAB8  1E DF 5D  ASL $5DDF,X 
$EABB            .byte $FC
$EABC  B5 CE     LDA $CE,X 
$EABE            .byte $5F,$A7,$47,$7F,$FB,$2F,$D7,$FF
$EAC6            .byte $7F,$9F,$EF,$F4,$F7
$EACB  F1 E9     SBC ($E9),Y 
$EACD            .byte $5F,$EF
$EACF  DE ED D4  DEC $D4ED,X 
$EAD2            .byte $2F,$F4,$77
$EAD5  E4 FE     CPX $FE 
$EAD7  F5 EE     SBC $EE,X 
$EAD9  FD D7 6E  SBC $6ED7,X 
$EADC  FD FF 42  SBC $42FF,X 
$EADF            .byte $FA,$17,$FF,$F7,$EF,$5F,$F7
$EAE6  E1 EF     SBC ($EF,X) 
$EAE8  FD 95 EF  SBC $EF95,X 
$EAEB  D9 5D FF  CMP $FF5D,Y 
$EAEE  F5 FE     SBC $FE,X 
$EAF0            .byte $DC,$7F,$FF,$FF,$F4
$EAF5  8D 6F 44  STA $446F 
$EAF8            .byte $7F,$00,$C3
$EAFB  FE 76 E8  INC $E876,X 
$EAFE  16 EE     ASL $EE,X 
$EB00            .byte $2B,$FA,$3F
$EB03  EC 6F 87  CPX $876F 
$EB06  FE 6F E1  INC $E16F,X 
$EB09  FE 7F 71  INC $717F,X 
$EB0C            .byte $FF,$4B,$F4,$2F
$EB10  15 FD     ORA $FD,X
$EB12            .byte $97
$EB13  71 FF     ADC ($FF),Y 
$EB15            .byte $14,$F7,$F7,$7F
$EB19  A1 43     LDA ($43,X) 
$EB1B            .byte $12,$E3
$EB1D  B1 FB     LDA ($FB),Y 
$EB1F            .byte $FB,$7F,$7F
$EB22  FE 17 3A  INC $3A17,X 
$EB25            .byte $F4,$37
$EB27  1E FB EF  ASL $EFFB,X 
$EB2A            .byte $F3
$EB2B  FD FB F4  SBC $F4FB,X 
$EB2E            .byte $FF
$EB2F  7E 4B A1  ROR $A14B,X 
$EB32  C5 85     CMP $85 
$EB34  FE 7E AF  INC $AF7E,X 
$EB37  7E 78 FB  ROR $FB78,X 
$EB3A  BA        TSX 
$EB3B            .byte $3F
$EB3C  AD 73 FA  LDA $FA73 
$EB3F  E5 E2     SBC $E2 
$EB41  FE DF F4  INC $F4DF,X 
$EB44            .byte $EB,$FF
$EB46  FE F9 F7  INC $F7F9,X 
$EB49            .byte $2F,$EF,$8F,$97,$FA,$F7,$7B,$B7
$EB51            .byte $2B,$F4,$2F
$EB54  EE 27 7F  INC $7F27 
$EB57            .byte $AF,$77,$BF,$EB
$EB5B  76 BF     ROR $BF,X 
$EB5D            .byte $FF,$42,$5F
$EB60  E8        INX 
$EB61            .byte $FF,$EF,$F7,$FA,$EF,$87,$F7,$BF
$EB69  A9 F7     LDA #$F7
$EB6B            .byte $9B
$EB6C  BA        TSX 
$EB6D            .byte $FF,$AF,$7F,$3B
$EB71  FE FF FF  INC $FFFF,X 
$EB74            .byte $2F
$EB75  B1 F6     LDA ($F6),Y 
$EB77            .byte $22
$EB78  FE 00 2B  INC $2B00,X 
$EB7B            .byte $80,$44
$EB7D  88        DEY 
$EB7E  24 50     BIT $50 
$EB80            .byte $14
$EB81  40        RTI 
//------------------------------
$EB82            .byte $02,$B8,$04
$EB85  48        PHA 
$EB86            .byte $80,$02
$EB88  45 00     EOR $00 
$EB8A            .byte $00
$EB8B  8D 00 12  STA $1200 
$EB8E  20 04 84  JSR L_JSR_($8404)_($EB8E) JAM
$EB91  40        RTI 
//------------------------------
$EB92            .byte $0B
$EB93  84 00     STY $00 
$EB95  28        PLP 
$EB96  10 70     BPL L_BRS_($EC08)_($EB96) OK
$EB98            .byte $00
$EB99  85 82     STA $82 
$EB9B  28        PLP 
$EB9C            .byte $8F
$EB9D  C4 1F     CPY $1F 
$EB9F  C0 01     CPY #$01
$EBA1            .byte $07,$80
$EBA3  08        PHP 
$EBA4  58        CLI 
$EBA5  20 08 FC  JSR L_JSR_($FC08)_($EBA5) BAD
$EBA8  40        RTI 
//------------------------------
$EBA9            .byte $07,$87,$80,$1F
$EBAD  F0 00     BEQ L_BRS_($EBAF)_($EBAD) JAM
//------------------------------
L_BRS_($EBAF)_($EBAD) JAM
//------------------------------
$EBAF            .byte $FF
$EBB0  16 85     ASL $85,X 
$EBB2            .byte $23,$43,$80,$72
$EBB6  E4 1D     CPX $1D 
$EBB8  FE 1F 5C  INC $5C1F,X 
$EBBB            .byte $03,$B2
$EBBD  3D 60 F0  AND $F060,X 
$EBC0            .byte $27,$80,$04
$EBC3  70 0D     BVS L_BRS_($EBD2)_($EBC3) BAD
$EBC5            .byte $00,$00,$17,$07,$74
$EBCA  08        PHP 
$EBCB  78        SEI 
$EBCC  09 40     ORA #$40
$EBCE            .byte $1F,$0F
//------------------------------
L_BRS_($EBD2)_($EBC3) BAD
//------------------------------
$EBD0  ED 16 70  SBC $7016 
$EBD3            .byte $04
$EBD4  70 6E     BVS L_BRS_($EC44)_($EBD4) BAD
$EBD6            .byte $00,$F4
$EBD8  F1 00     SBC ($00),Y 
$EBDA  D0 6E     BNE L_BRS_($EC4A)_($EBDA) OK
$EBDC  01 00     ORA ($00,X)
$EBDE            .byte $47,$04
$EBE0  38        SEC 
$EBE1            .byte $00,$07
$EBE3  2E 40 01  ROL $0140 
$EBE6            .byte $DF
$EBE7  E0 01     CPX #$01
$EBE9  95 90     STA $90,X 
$EBEB  19 5C 00  ORA $005C,Y
$EBEE            .byte $03,$72
$EBF0  1D 80 00  ORA $0080,X