/*
Total Eclipse
Atari 8-bit port
2015/2016/2017/2018
*/

/*
bt div24x16 "DIV24X16(%04X) dividend=%02X%02X%02X divisor=%02X%02X" dw($101+s)-2 y x db(a) db($8d) db($8c)
bt mult16x8 "MULT16X8(%04X) f1=%02X%02X f2=%02X" dw($101+s)-2 x db(a) y
bt div32x16 "DIV32X16(%04X) dividend=%02X%02X%02X%02X divisor=%02X%02X" dw($101+s)-2 db($8B) db($8A) db($89) db($88) db($8d) db($8c)
bt mult16x16 "MULT16X16(%04X) f1=%02X%02X f2=%02X%02X" dw($101+s)-2 db($89) db($88) db($8d) db($8c)
*/
; Memory map:
; $0200 - $023f: c64 sprite registers shadow
; $0240 - $0243: screen 3d colors
; $0300 - $037f: sun data
; $0380 - $03ff: heart data
; $0439 - $1526: RMT music data
; $1527 - $7ea6: game code
; $7ea7 - $8ba6: 3D buffer
; $8000 - $xxxx: Atari initialization code
; $8ba7 - $8fff: free? (used at least until $8eff)
; $9000 - $92ff: Atari code (sprites)
; $9300 - $93ff: game font
; $9400 - $95ff: sprite data
; $9600 - $bfff: game database
; $c000 - $c7ff: fast multiplication tables
; $c800 - $cfff: Atari code (nmi, fill_polygon, dli, read_keyboard, multiply, divide): note: almost full!
; $d800 - $d8df: display list
; $d8e0 - $e14d: RMT player
; $e14e - $e1ff: free
; $e200 - $e5ff: top part of the screen
; $e600 - $f2ff: 3D view
; $f300 - $faff: bottom part of the screen
; $fb00 - $ffff: PMG data

; TODO:
; 12. Add more colors on credits screen
; 14. Fix fast CPU detection
; 15. Fix keyboard controls
;
; DONE:
; 1. Game progress indicators
; 2. Moon/Sun animation
; 3. New font (prepared by Adam, integrated)
; 4. New column graphics (prepared by Adam, integrated)
; 5. Heart animation
; 6. Compass animation
; 7. Shooting animation (uses C64 sprites)
; 8. Music and sound effects
; 11. Support Atari function keys:
;		START for starting the game
;		SELECT for switching music/sfx
; 13. Add stereo support

; CANCELLED:
; 9. Game save/load
; 10. New multiply routines (use only $200 tables instead of $800)

		icl 'atari.hea'

; defines
multab1		equ $c000
multab2		equ $c200
multab3		equ $c400
multab4		equ $c600

dlist		equ $d800
sprite_reg	equ	$0200 ; $40 bytes
screen_3d_colors	equ $0240	; 4 bytes
ankh_red_gfx 	equ $0244 ; 12 bytes
ankh_yellow_gfx	equ $0250 ; 12 bytes
rmt_regs_save	equ $025c ; 1 byte
Vblank60Hz		equ $025d ; 1 byte (0 = 50Hz, 255 = 60Hz)
FastCPUActive	equ $025e ; 1 byte (0 = standard CPU, 255 = fast CPU)
LastConsolState	equ $025f ; 1 byte - previous state of consol register
SunData			equ $0300-40
HeartData		equ $0380
FontData		equ $9300 ; 256 bytes
SpritesData		equ $9400 ; 512 bytes
RmtSoundData	equ $0439
screen		equ $e200
screen_top	equ $e200
; top ornament $e200 - $e5ff ($0400)
screen_3d	equ $e600
; 3d view $e600 - $f2ff ($0d00)
; bottom ornament $f300 - $faff ($800)
screen_bottom equ $f300
pmgmem		equ $f800

; defines from C64 version
c64_vbl			equ $6bd0
back_buffer		equ $7ea7
c64screen		equ $e000
watch_data		equ $1b4d
compass_data 	equ $1BCD
PrintString	 	equ $686C
PrintString2 	equ $6871
ClearScreen3D	equ $7698

; macros
atari_screen_address_dta .macro c64_addr_param
		?c64_addr 	equ :c64_addr_param - c64screen
		?row_low 	equ ?c64_addr & $07
		?row_high 	equ ?c64_addr / $140
		?row = ?row_low | (?row_high << 3)
		?column 	equ (?c64_addr % $140) / 8
		dta a(screen + $20*(?row) + (?column-4))
		.endm

atari_screen_address_row_column_dta .macro row, column
		dta a(screen + $20*(:row) + (:column-4))
		.endm
		
atari_screen_address_equ .macro atari_equ, c64_addr_param
		?c64_addr 	equ :c64_addr_param - c64screen
		?row_low 	equ ?c64_addr & $07
		?row_high 	equ ?c64_addr / $140
		?row = ?row_low | (?row_high << 3)
		?column 	equ (?c64_addr % $140) / 8
		.def :atari_equ = screen + $20*(?row) + (?column-4)
		.endm



		org $1527
		ins 'te.dmp',+$1527,$AD9 ; code 1527 - 1FFF
		
; table below consists of pairs with input code and action code
; input code comes from routine 6F00 and usually
; it is an ASCII code of pressed key
; this table is used when decoding user input and dispatching
; it to input handlers		
;L18E3   .he 48,01 ; key H - HEIGHT CHANGE  H, stand or crouch
;		 .he 5E,03 ; key ^ (arrow up), move forward
;		 .he 91,03 ; joystick up, move forward
;		 .he 3D,04 ; key =, move backward
;18EB    .he 92,04 ; joystick down, move backward
;		 .he 51,05 ; key Q, turn left
;		 .he 93,05 ; joystick left, turn left
;		 .he 57,06 ; key W, turn right
;18F3    .he 94,06 ; joystick right, turn right
;		 .he 50,07 ; key P, look up
; 		 .he 4C,08 ; key L, look down
; 		 .he 41,0B ; key A, angle change
;18FB    .he 46,0C ; key F, face forward
; 		 .he 55,0D ; key U, turn
;		 .he 53,11 ; key S, step size change
; 		 .he 2B,15 ; key +,
;1903    .he 01,16 ; key shift, fire gun
;		 .he 95,16 ; joystick fire, fire gun
;		 .he 20,1E ; key SPACE, turn shooting mode on/off
;		 .he 52,1F ; key R, rest
;190B    .he 49,29 ; key I, interrupt game

; patches		
		org $18e5
		dta c'-' ; move forward
		
		org $18ed
		dta c'+'
		
		org $18f1
		dta c'*'
		
		org $1901
		dta c'C'
		
		org $1903
		dta c'0'
		
		org $1ac7
		atari_screen_address_dta $FE6B
		atari_screen_address_dta $FE6A
		atari_screen_address_dta $FE69
		atari_screen_address_dta $FE68
		atari_screen_address_dta $FD2F
		atari_screen_address_dta $FD2E
		atari_screen_address_dta $FD2D
		atari_screen_address_dta $FD2C
		atari_screen_address_dta $FD2B
		atari_screen_address_dta $FD2A
		atari_screen_address_dta $FD29
		atari_screen_address_dta $FD28
		atari_screen_address_dta $FBEF
		atari_screen_address_dta $FBEE
		atari_screen_address_dta $FBED
		atari_screen_address_dta $FBEC
		atari_screen_address_dta $FBEB
		atari_screen_address_dta $FBEA
		atari_screen_address_dta $FBE9
		atari_screen_address_dta $FBE8
		atari_screen_address_dta $FAAF
		atari_screen_address_dta $FAAE
		atari_screen_address_dta $FAAD
		atari_screen_address_dta $FAAC
		atari_screen_address_dta $FAAB
		atari_screen_address_dta $FAAA
		atari_screen_address_dta $FAA9
		atari_screen_address_dta $FAA8
		atari_screen_address_dta $F96F
		atari_screen_address_dta $F96E
		atari_screen_address_dta $F96D
		atari_screen_address_dta $F96C
		atari_screen_address_dta $F96B
		atari_screen_address_dta $F96A
		atari_screen_address_dta $F969
	

		;org $0470,$3800+$0470
		;jsr sound_fx_init ; $cd12
		
		;org $0485,$3800+$0485
		;jsr file_set_lfs
		
		;org $04c1,$3800+$04c1
		;jsr file_set_name
	
		;org $0524,$3800+$0524
		;jsr file_save
		
		;org $053f,$3800+$053f
		;jsr file_load_verify
		
		;org $062f,$3800+$062f
		;rts
		;:$0653-* nop
		;ert *<>$0653
		
		; display list
		org dlist,$2000
		.he 70 70 70 
		.he 4E 
		dta a(screen_top)
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 8E 
		.he 0F 0F 0F 0F 0F 0F 8F 0E
		
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E
		.he 4E 00 F0 
		.he 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 8E 0E 0E 0E 0E 0E 0E 8E 
		.he 8E 0E 0E 0E 8E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 0E 0E 0E 0E 0E 0E 0E 0E 
		.he 41 
		dta a(dlist)
		
		; rmt player
		icl 'rmtplayr_reloc.asm'
		
		org $3c00
		;ins 'gfx.fnt', +$0200,$0400-$0100
		;ins 'TotalEclipse_hieroglify2018_v2final_negative.fnt',+$0000,$0100
		;ins 'gfx.fnt', +$1300,$0800
		ins 'gfx7.raw', +$0200,$0400
		ins 'gfx7.raw', +$1300,$0800
		
		
		org $4800
; dane missile'a (kolor pośredni, wypełnione M0 i M3)
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	
	dta $00,$C3,$C3,$C3,$00,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$00,$82,$C3
	dta $00,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	dta $C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C3
	; jar's ornament:
	dta $C7,$C3,$C3,$CB
	dta $C3,$C3,$C3,$CB
	dta $C3,$C3,$C3,$CB
	dta $C3,$C3,$C3,$CB
	dta $C3,$C3,$C3,$CB
	dta $C3,$C3,$C3,$CB
	dta $C3,$C3,$C3,$CB
	dta $C3,$C3,$00,$CB
	; roller's bottom part:
	dta $C3,$00,$00,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$00,$C3,$C3,$C3,$00,$00 
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00	
	
; lewy player ciemny (P0, P2)
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	dta $00,$04,$1A,$3C,$78,$64,$5A,$5C,$3E,$2D,$16,$0D,$16,$00,$08,$3C
	dta $70,$CC,$BA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D
	dta $BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$BE,$5C,$AA,$1D,$AE,$CC,$70,$38
	dta $0C,$00,$10,$0F,$16,$2D,$0E,$54,$4A,$24,$50,$3C,$1A,$04,$00,$00
 
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

; prawy player jasny (P1, P3)
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
 
	dta $00,$F0,$2C,$1E,$07,$0B,$15,$0F,$16,$2C,$14,$28,$18,$08,$70,$3C
	dta $0E,$13,$2D,$1E,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1F
	dta $0F,$17,$2F,$1F,$0F,$17,$2F,$1F,$0F,$17,$2F,$1E,$0D,$13,$06,$1C
	dta $70,$00,$08,$10,$2C,$14,$2E,$17,$0D,$13,$07,$1E,$AC,$50,$00,$00

	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
 
	
		
; main Atari code		
		org $c800,$4b00
atari_code_start
fill_polygon
		sta ($82),y	; 0
		iny
		sta ($82),y ; 1
		iny
		sta ($82),y ; 2
		iny
		sta ($82),y ; 3
		iny
		sta ($82),y ; 4
		iny
		sta ($82),y ; 5
		iny
		sta ($82),y ; 6
		iny
		sta ($82),y ; 7
		iny
		sta ($82),y ; 8
		iny
		sta ($82),y ; 9
		iny
		sta ($82),y ; 10
		iny
		sta ($82),y ; 11
		iny
		sta ($82),y ; 12
		iny
		sta ($82),y ; 13
		iny
		sta ($82),y ; 14
		iny
		sta ($82),y ; 15
		iny
		sta ($82),y ; 16
		iny
		sta ($82),y ; 17
		iny
		sta ($82),y ; 18
		iny
		sta ($82),y ; 19
		iny
		sta ($82),y ; 20
		iny
		sta ($82),y ; 21
		iny
		sta ($82),y ; 22
		iny
		sta ($82),y ; 23
		iny
		sta ($82),y ; 24
		iny
		sta ($82),y ; 25
		iny
		sta ($82),y ; 26
		iny
		sta ($82),y ; 27
		iny
		sta ($82),y ; 28
		iny
		sta ($82),y ; 28
		iny
		sta ($82),y ; 29
		iny
		sta ($82),y ; 30
		iny
		sta ($82),y ; 31
		;iny ; not needed
		jmp jump_fill_polygon_ret
table_fill_polygon :32 dta [<fill_polygon+(32-#)*3]	
		
nmi		bit nmist
		bpl vbl
dli		jmp (dlivector)

vbl		pha
		txa
		pha
		tya
		pha
		; set colours for top of the screen
		lda #$24
VblSetColpf0 equ *-1
		sta colpf0
		lda #$EC
VblSetColpf1 equ *-1		
		sta colpf1
		lda #$1E
VblSetColpf2 equ *-1		
		sta colpf2
		lda #$18
VblSetColpf3 equ *-1		
		sta colpf3
		
		inc FrameCounter
		
		;ldx PAL
		;dex
		;beq VblCallMusicPlayer
		bit Vblank60Hz
		bpl VblCallMusicPlayer
		dec MusicNTSCCounter
		bpl VblCallMusicPlayer
		mva #5 MusicNTSCCounter
		jmp VblCallC64
VblCallMusicPlayer
		jsr RmtSwapRegs
		jsr RASTERMUSICTRACKER+3
		jsr RmtSwapRegs
		
VblCallC64		
		tsx
		lda $0104,x
		and #$04	; check I flag
		bne vbl_exit
		jmp c64_vbl
vbl_exit
		pla
		tay
		pla
		tax
		pla
		rti
		
MusicNTSCCounter
		dta 5
		
FrameCounter
		dta 0
		
dlivector
		dta a(dli0)
	
; dli top text line
dli0	sta dli0a+1
		stx dli0x+1
		ldx #$ea
Dli0Colpf1 equ *-1		
		lda #$e0
Dli0Colpf2 equ *-1		
		sta wsync
		sta colpf2
		stx colpf1
		stx colpf0
		lda #<dli1
		sta dlivector
		.if >dli1 != >dli0
		lda #>dli1
		sta dlivector+1
		.endif		
dli0a	lda #0
dli0x	ldx #0		
		rti
	
; dli 3d view	
dli1	sta dli1a+1
		stx dli1x+1
		sty dli1y+1
		lda screen_3d_colors+1
		ldx screen_3d_colors+2
		ldy screen_3d_colors+3
		sta wsync
		sta colpf0
		stx colpf1
		sty colpf2
		lda #<dli2
		sta dlivector
		.if >dli2 != >dli1
		lda #>dli2
		sta dlivector+1
		.endif		
dli1a	lda #0
dli1x	ldx #0
dli1y	ldy #0
irq		rti

; dli bottom text line
dli2	sta dli2a+1
		stx dli2x+1
		ldx #$ea
Dli2Colpf1 equ *-1		
		lda #$e0
Dli2Colpf2 equ *-1		
		sta wsync
		sta colpf2
		stx colpf1
		stx colpf0
		lda #<dli22
		sta dlivector
		.if >dli22 != >dli2
		lda #>dli22
		sta dlivector+1
		.endif		
dli2a	lda #0
dli2x	ldx #0		
		rti
		
; dli for bottom of bottom status text line
dli22	sta dli22a+1
		lda #$e8
Dli22Colpf1 equ *-1
		sta wsync
		sta colpf1
		lda #<dli3
		sta dlivector
		.if >dli3 != >dli2
		lda #>dli3
		sta dlivector+1
		.endif		
dli22a	lda #$00
		rti
		
; dli bottom part of status window
dli3	sta dli3a+1
		stx dli3x+1
		sty dli3y+1
		lda #$28
Dli3Colpf0 equ *-1
		ldx #$ec
Dli3Colpf1 equ *-1
		ldy #$0e
Dli3Colpf2 equ *-1		
		sta wsync
		sta colpf0
		stx colpf1
		sty colpf2
		lda #<dli4
		sta dlivector
		.if >dli4 != >dli3
		lda #>dli0
		sta dlivector+1
		.endif		
dli3a	lda #0
dli3x	ldx #0
dli3y	ldy #0
		rti
		
dli4	sta dli4a+1
		lda #$26
Dli4Colpf0 equ *-1		
		sta wsync
		sta colpf0
		lda #<dli0
		sta dlivector
		.if >dli0 != >dli4
		lda #>dli0
		sta dlivector+1
		.endif		
dli4a	lda #$ff
		rti
		
read_joystick_2
		lda porta
		lsr @
		lsr @
		lsr @
		lsr @
		lsr trig1
		bcc rj1
		ora #$10
rj1		and #$1f
		rts
		
read_joystick
		lda porta
;		eor #$ff
		and #$0f
		ldy trig0
		beq l1	
		ora #$10
		;lsr trig0
		;bcc l1	
		;ora #$10
l1		and #$1f
		rts

readkey_c64_repeat_last
		lda keys_cols
		beq read_joystick
		bne readkey_c64_again
		
readkey_c64
		eor #$ff
		sta keys_cols
		beq read_joystick
readkey_c64_again
		lda #$ff
		sta key_result
		lda skstat
		and #$04
		bne nokey
		stx rk_save_x+1
		sty rk_save_y+1
		lda kbcode
		bmi key_exit
		tay
		and #$3f
		tax
		lda atari_c64_keys,x
		and #$07
		tax
		lda _bits,x
		and keys_cols
		beq key_exit
		tya
		and #$3f
		tax
		lda atari_c64_keys,x
		lsr @
		lsr @
		lsr @
		lsr @
		tax
		lda _bits,x
		eor #$ff
		sta key_result
key_exit
rk_save_x
		ldx #$00
rk_save_y
		ldy #$00
nokey	lda key_result
		rts

		
keys_cols 	dta $00
key_result	dta $00
		
atari_c64_keys
; c64 keyboard matrix
;  Bit    Col0  Col1  Col2  Col3  Col4  Col5  Col6  Col7
;  Row0   DEL   "3"   "5"   "7"   "9"   "+"   PND   "1"
;  Row1   RET   "W"   "R"   "Y"   "I"   "P"   "*"   <--
;  Row2   RIGHT "A"   "D"   "G"   "J"   "L"   ";"   CTRL
;  Row3   F7    "4"   "6"   "8"   "0"   "-"   HOME  "2"
;  Row4   F1    "Z"   "C"   "B"   "M"   "."  RSHIFT SPC
;  Row5   F3    "S"   "F"   "H"   "K"   ":"   "="   <C=>
;  Row6   F5    "E"   "T"   "U"   "O"   "@"   "^"   "Q"
;  Row7   DOWN LSHIFT "X"   "V"   "N"   ","   "/"   STOP
		dta $25	; L $00
		dta $42	; J $01
		dta $55	; ;: $02
		dta $ff	; F1 $03
		dta $ff	; F2 $04
		dta $54	; K $05
		dta $05	; +\ $06
		dta $16	; *^ $07
		dta $64	; O $08
		dta $ff	;   $09
		dta $15	; P $0A
		dta $63	; U $0B
		dta $17	; RETURN $0C
		dta $14	; I $0D
		dta $35	; -_ $0E
		dta $56	; =| $0F
		dta $73	; $10 V
		dta $ff	; $11 HELP
		dta $42	; $12 C
		dta $ff	; $13 F3
		dta $ff	; $14 F4
		dta $43	; $15 B
		dta $72 ; $16 X
		dta $41 ; $17 Z
		dta $31	; $18 4$
		dta $ff ; $19
		dta $01	; $1a 3#
		dta $32	; $1b 6&
		dta $77 ; $1c ESC (RUN/STOP)
		;dta $ff ; $1c ESC
		dta $02	; $1d 5%
		dta $37 ; $1e 2"
		dta $07 ; $1f 1!
		dta $75 ; $20 ,[
		dta $47 ; $21 SPACE
		;dta $77 ; $21 SPACE (RUN/STOP) (PAUSE)
		dta $45	; $22 .]
		dta $74	; $23 N
		dta $ff	; $24
		dta $44	; $25 M
		dta $76	; $26 /?
		dta $46 ; $27 LOGO (RSHIFT)
		dta $12	; $28 R
		dta $ff	; $29
		dta $61	; $2a E
		dta $13 ; $2b Y
		dta $ff	; $2c TAB
		dta $62	; $2d T
		dta $11	; $2e W
		dta $67	; $2f Q
		dta $04	; $30 9(
		dta $ff ; $31
		dta $34 ; $32 0)
		dta $03 ; $33 7'
		dta $00	; $34 BACKSPACE/DEL
		dta $33 ; $35 8@
		dta $ff ; $36 <CLEAR
		dta $ff ; $37 >INS
		dta $52 ; $38 F
		dta $53 ; $39 H
		dta $22 ; $3a D
		dta $ff ; $3b
		dta $ff ; $3c CAPS
		dta $23	; $3d G
		dta $51	; $3e S
		dta $21 ; $3f A
	
_bits	dta $01, $02, $04, $08, $10, $20, $40, $80

last_key	dta $00	
readkey_c64_wait_for_release
		sta last_key
rk1
		jsr readkey_c64_repeat_last
		cmp last_key
		beq rk1
		lda last_key
		rts
		
sound_fx_flag
		dta $00
sound_fx_init
		rts
;sound_fx_start
;		rts
sound_fx_player
		rts
sound_music_flag
		dta $00
;sound_music_player
;		rts
sound_music_2
		rts
		
;file_set_lfs
;		rts
;file_set_name
;		rts
;file_save
;		rts
;file_load_verify
;		rts

mult16x8_8
		stx $84
		sta m881+1     ;set zp adresses
    	STA m882+1
    	EOR #$ff
    	STA m883+1
    	STA m884+1
		ldy $88
    	SEC
m881    LDA multab1,y
m883    SBC multab3,y
    	;TAX         ;product lo in x
		sta $82
m882   	LDA multab2,y
m884    SBC multab4,y ;product hi in a
		sta $83
		jmp mm1

;mult16x8_ret0
;		lda #$00
;		sta $82
;		sta $83
;		sta $84
;		sta $85
;		rts
		
mult16x8
		sta $88
		stx $89
		sty $8c
;		cmp #$00
;		beq mult16x8lo8
		;ora $89
		;beq mult16x8_ret0
		tya
		;beq mult16x8_ret0
		cpx #0
		beq mult16x8_8
		sta m11+1 
		sta m21+1
    	STA m12+1
		sta m22+1
    	EOR #$ff
    	STA m13+1
		sta m23+1
    	STA m14+1
		sta m24+1
		
		;ldy $88
		ldy $88
    	SEC
m11    	LDA multab1,y
m13    	SBC multab3,y
    	;TAX         ;product lo in x
		sta $82
m12    	LDA multab2,y
m14     SBC multab4,y ;product hi in a
		sta $83

    	SEC
m21    	LDA multab1,x
m23    	SBC multab3,x
    	;TAX         ;product lo in x
		;sta $82
		tay
m22    	LDA multab2,x
m24     SBC multab4,x ;product hi in a
		sta $84
		tya
		clc
		adc $83
		sta $83
		bcc mm1
		inc $84
		
mm1		
		lda $89
		bpl mm2
		sec
		lda $84
		sbc $8c
		sta $84
mm2		
		lda $8c
		bpl mm3
		sec
		lda $83
		sbc $88
		sta $83
		lda $84
		sbc $89
		sta $84
mm3		
        RTS
		
		
mult16x8_34
		; x,y = factor1_lo, factor1_hi
		sec
		lda multab1+$34,x
		sbc multab3+$cb,x
		sta $82
		lda multab2+$34,x
		sbc multab4+$cb,x
		sta $83
		sec
		lda multab1+$34,y
		sbc multab3+$cb,y
		tax
		lda multab2+$34,y
		sbc multab4+$cb,y
		sta $84
		txa
		clc
		adc $83
		sta $83
		scc:inc $84
		tya
		bpl @+
		sec
		lda $84
		sbc #$34
		sta $84
@		jmp $35f4
		
mult16x16_ret0
		lda #$00
		sta $82
		sta $83
		sta $84
		sta $85
		rts

T1 		equ $88
T2		equ $8c
PRODUCT equ $82
square1_lo equ multab1
square2_lo equ multab3
square1_hi equ multab2
square2_hi equ multab4
		
mult8x8u
       lda T1                                                
       sta sm81+1                                             
       sta sm83+1                                             
       eor #$ff                                              
       sta sm82+1                                             
       sta sm84+1 
	   
       ldx T2
       sec   
sm81   lda square1_lo,x
sm82   sbc square2_lo,x
       sta PRODUCT+0   
sm83   lda square1_hi,x
sm84   sbc square2_hi,x
       sta PRODUCT+1   
	   lda #$00
	   sta PRODUCT+2
	   sta PRODUCT+3
       rts	   
mult16x16
		lda $88
		ora $89
		beq mult16x16_ret0
		lda $8c
		ora $8d
		beq mult16x16_ret0
		lda $89
		ora $8d
		beq mult8x8u
		

		lda T1+0         
		sta sm1a+1       
		sta sm3a+1       
		sta sm5a+1       
		sta sm7a+1       
		eor #$ff         
		sta sm2a+1       
		sta sm4a+1       
		sta sm6a+1       
		sta sm8a+1       
		lda T1+1         
		sta sm1b+1       
		sta sm3b+1       
		sta sm5b+1       
		sta sm7b+1       
		eor #$ff         
		sta sm2b+1       
		sta sm4b+1       
		sta sm6b+1       
		sta sm8b+1       
		
				; Perform <T1 * <T2 = AAaa
                ldx T2+0                  
                sec                       
sm1a            lda square1_lo,x          
sm2a            sbc square2_lo,x          
                sta PRODUCT+0             
sm3a            lda square1_hi,x          
sm4a            sbc square2_hi,x          
                sta _AA+1                 

                ; Perform >T1_hi * <T2 = CCcc
                sec                          
sm1b            lda square1_lo,x             
sm2b            sbc square2_lo,x             
                sta _ccl+1                    
sm3b            lda square1_hi,x             
sm4b           sbc square2_hi,x             
                sta _CCH+1                    

                ; Perform <T1 * >T2 = BBbb
                ldx T2+1                  
                sec                       
sm5a            lda square1_lo,x          
sm6a            sbc square2_lo,x          
                sta _bbl+1                 
sm7a            lda square1_hi,x          
sm8a            sbc square2_hi,x          
                sta _BBH+1                 

                ; Perform >T1 * >T2 = DDdd
                sec                       
sm5b            lda square1_lo,x          
sm6b            sbc square2_lo,x          
                sta _dd+1                 
sm7b            lda square1_hi,x          
sm8b            sbc square2_hi,x          
                sta PRODUCT+3             

                ; Add the separate multiplications together
                clc                                        
_AA             lda #0                                     
_bbl            adc #0                                     
                sta PRODUCT+1                              
_BBH            lda #0                                     
_CCH            adc #0                                     
                sta PRODUCT+2                              
                bcc _ccl                                     
                inc PRODUCT+3                          
                clc                                    
_ccl            lda #0                                     
                adc PRODUCT+1                              
                sta PRODUCT+1                              
_dd             lda #0                                     
                adc PRODUCT+2                              
                sta PRODUCT+2                              
                bcc mult16x16_apply_sign                                   
                inc PRODUCT+3   
				
                ; Apply sign (See C=Hacking16 for details).
mult16x16_apply_sign				
                lda T1+1
                bpl mult16x16_apply_sign_2
                    sec
                    lda PRODUCT+2
                    sbc T2+0
                    sta PRODUCT+2
                    lda PRODUCT+3
                    sbc T2+1
                    sta PRODUCT+3
mult16x16_apply_sign_2
                lda T2+1
                bpl mul16x16_ret
                    sec
                    lda PRODUCT+2
                    sbc T1+0
                    sta PRODUCT+2
                    lda PRODUCT+3
                    sbc T1+1
                    sta PRODUCT+3
                
mul16x16_ret
                rts

jmp_1e12
		jmp $1e12
jmp_1e14
		jmp $1e14
		
div24x16_overflow
		lda #$00
		sta $88
		sta $89
		sta $8a
		rts
		
div24x16
		sta $88
		stx $89
		sty $8a
		tya
		sta $1dd1
		eor $8d
		sta $1dd0
		lda $8d
		bpl d1
		lda #$00
		sec
		sbc $8c
		sta $8c
		lda #$00
		sbc $8d
		sta $8d
d1		tya
		bpl d2
		lda #$00
		sec
		sbc $88
		sta $88
		lda #$00
		sbc $89
		sta $89
		lda #$00
		sbc $8a
		sta $8a
d2		lda #$00
		sta $82
		sta $83
		sta $84
		ldy $8a
		bne jmp_1e12
		
		; first 8 iterations
		lda $89
		sta $8a
		lda $88
		sta $89
		sty $88
		ldx #$10

		; check dividend if less than $100 - if yes, go to standard method
		lda $8d
		beq jmp_1e14
		
		ldx #$08
		; shift left divisor as long as zeros come out
		lda $8a
		beq div24x16_overflow
		bmi d3
d4		dex
		asl $89
		rol @
		bpl d4
		; shift everything 8 bits, as dividend is 9 or more bits wide 
d3		sta	$82
		lda $89
		sta $8a
		;txa
		;sec
		;sbc #$08
		;tax
		; final loops
		clc
d6		rol $88
		;rol $89
		;rol $8a
		asl $8a
		rol $82
		rol $83
		sec
		lda $82
		sbc $8c
		tay
		lda $83
		sbc $8d
		bcc d5
		sta $83
		sty $82
d5		dex
		bne d6
		jmp $1e3f

		
;div32x16
		; test
;		lda $88
;		sta dividend
;		lda $89
;		sta dividend+1
;		lda $8a
;		sta dividend+2
;		lda $8b
;		sta dividend+3
;		lda $8c
;		sta divisor
;		lda $8d
;		sta divisor+1
;		jsr $1ede
;		lda $88
;		sta quotient
;		lda $89
;		sta quotient+1
;		lda $8a
;		sta quotient+2
;		lda $8b
;		sta quotient+3
;		lda dividend
;		sta $88
;		lda dividend+1
;		sta $89
;		lda dividend+2
;		sta $8a
;		lda dividend+3
;		sta $8b
;		lda divisor
;		sta $8c
;		lda divisor+1
;		sta $8d
;		jsr div32x16_new
;		lda $88
;		cmp quotient
;		bne div_error
;		lda $89
;		cmp quotient+1
;		bne div_error
;		lda $8a
;		cmp quotient+2
;		bne div_error
;		lda $8b
;		cmp quotient+3
;		bne div_error
;		rts
;div_error
;		brk
;		dta 0
;dividend dta 0,0,0,0	
;quotient dta 0,0,0,0	
;divisor  dta 0,0

div32x16_rts
		rts
		
div32x16_dividend_32bit		
		jmp $1f31
		
div32x16_dividend_16bit
		lda $89
		sta $8b
		lda $88
		sta $8a
		sty $89
		sty $88
		ldx #$10
		jmp $1f33
		
div32x16
		ldy #$00
		sty $82
		sty $83
		sty $1540
		lda $88
		ora $89
		ora $8a
		ora $8b
		beq div32x16_rts
		lda $8c
		ora $8d
		beq div32x16_rts
		lda $8b
		bpl div32x16_dividend_positive
		inc $1540
		tya
		sec
		sbc $88
		sta $88
		tya
		sbc $89
		sta $89
		tya
		sbc $8a
		sta $8a
		tya
		sbc $8b
		sta $8b
div32x16_dividend_positive
		lda $8d
		bpl div32x16_divisor_positive
		inc $1540
		eor #$ff
		sta $8d
		lda $8c
		eor #$ff
		clc
		adc #$01
		sta $8c
		bcc div32x16_divisor_positive
		inc $8d
div32x16_divisor_positive
		lda $8b
		bne div32x16_dividend_32bit
		lda $8d
		beq div32x16_divisor_8bit
		ldx #$18-8
		lda $8a
		beq div32x16_dividend_16bit
		bmi dd1
dd2		dex
		asl $88
		rol $89
		rol @
		bpl dd2
; shift everything 8 bits, as dividend is 9 or more bits wide 
dd1		sta $82
		lda $89
		sta $8a
		lda $88
		sta $89
		sty $88
		;txa ; x adjusted at the begining
		;sec
		;sbc #$08
		;tax
		lda $83	; compare high byte of current quotient with high byte of divider 
dd6		cmp $8d
		bcs dd7
		asl $89	; shift remainder and quotient with comparing quotient and divider (faster)
		rol $8a
		rol $82
		rol @
		dex
		bne dd6
		beq dd8
dd7		inx
		sta $83
		bcs dd5
		; final loops
		clc
dd3		rol $88
		rol $89
		rol $8a
		rol $82
		rol $83
		sec
dd5		lda $82
		sbc $8c
		tay
		lda $83
		sbc $8d
		bcc dd4
		sta $83
		sty $82
dd4		dex
		bne dd3
dd8		rol $88
		rol $89
		rol $8a
		jmp $1f5f

div32x16_divisor_8bit
		lda $8a
		beq div32x16_dividend16_bit_divisor_8bit
		sta $8b
		lda $89
		sta $8a
		lda $88
		sta $89
		sty $88
		ldx #$18
		jmp $1f33
div32x16_dividend16_bit_divisor_8bit
		lda $89
		beq div32x16_dividend8_bit_divisor_8bit
		sta $8b
		lda $88
		sta $8a
		sty $89
		sty $88
		ldx #$10
		jmp $1f33
div32x16_dividend8_bit_divisor_8bit
		lda $88
		sta $8b
		sty $88
		ldx #$08
		jmp $1f33
		
sub_304d_small_y
		tya
		asl @
		asl @
		sta $82
		ldy $b1
		lda $02,y
		ldx $03,y
		ldy $82
		jsr mult16x8
		lda $83
		bne sub_304d_update_3e
		clc
		ldx $b0
		bcc sub_304d_update_3f
		
sub_304d	
		lda $159e
		sta $b2
		ldx #$0a
		lda #$00
		sta $b3
		sta $b0
		sta $b1
sub_304d_305c
		sta $6f,x
		sta $65,x
		sta $5b,x
		sta $51,x
		sta $47,x
		sta $3d,x
		dex
		bne sub_304d_305c
sub_304d_3071
		lda #$03
		sta $b5
sub_304d_3075
		sta $b4
sub_304d_3077
		ldx $b3
		ldy $1556,x
		beq sub_304d_next_iteration
		cpy #$20
		bcc sub_304d_small_y	; note: this makes 1,400 cycles difference - if this is not done, procedure will fit in original location
		sty $82
		ldy $b1
		lda $02,y
		ldx $03,y
		ldy $82
		jsr mult16x8
		lda $83
		asl $82
		rol @
		rol $84
		asl $82
		rol @
		rol $84
sub_304d_update_3e		
		ldx $b0
		clc
		adc $3e,x
		sta $3e,x
sub_304d_update_3f		
		lda $3f,x
		adc $84
		sta $3f,x
sub_304d_next_iteration		
		inc $b3
		inc $b1
		inc $b1
		dec $b4
		bne sub_304d_3077
		inc $b0
		inc $b0
		dec $b5
		beq sub_304d_30c3
		lda $b1
		sec
		sbc #$06
		sta $b1
		lda #$03
		jmp sub_304d_3075
sub_304d_30c3
		lda #$00
		sta $b3
		dec $b2
		bne sub_304d_3071
		rts
	
sub_4608
; render horizon/ground
		cmp #$05
		bcc sub_4608_l1
		jmp $4608	; original code
sub_4608_l1
		sbc #$00 ; carry cleared
		asl @
		asl @
		tax
		lda $960a,x
		sta $b1
		tya
		tax
		ldy #$00
sub_4608_check_remaining_rows		
		lda $b1
		cpx #$08
		bcc sub_4608_last_rows
		; render whole row
sub_4608_loop		
		sta ($7a),y
		iny
		sta ($7a),y
		iny
		sta ($7a),y
		iny
		sta ($7a),y
		iny
		sta ($7a),y
		iny
		sta ($7a),y
		iny
		sta ($7a),y
		iny
		sta ($7a),y
		iny
		bne sub_4608_loop
		inc $7b
		sec
		txa
		sbc #$08
		tax
		bne sub_4608_check_remaining_rows
		rts
sub_4608_last_rows
		sta $b2
		sta $b3
		sta $b4
		jmp $461e
	
copy_back_buffer_to_screen
		ldx #>screen_3d
		stx cbs0+2
		stx cbs1+2
		stx cbs2+2
		stx cbs3+2
		stx cbs4+2
		stx cbs5+2
		stx cbs6+2
		stx cbs7+2		
		ldx #>[back_buffer+$0c00]
		stx cbb0+2
		stx cbb1+2
		stx cbb2+2
		stx cbb3+2
		stx cbb4+2
		stx cbb5+2
		stx cbb6+2
		stx cbb7+2
		
		ldy #$00
cbs_loop_load_x		
		clc
		ldx #$ff
cbs_loop		
cbb0	lda back_buffer+$0c00,x
cbs0	sta screen_3d,y
cbb1	lda back_buffer+$0c00-1,x
cbs1	sta screen_3d+1,y
cbb2	lda back_buffer+$0c00-2,x
cbs2	sta screen_3d+2,y
cbb3	lda back_buffer+$0c00-3,x
cbs3	sta screen_3d+3,y
cbb4	lda back_buffer+$0c00-4,x
cbs4	sta screen_3d+4,y
cbb5	lda back_buffer+$0c00-5,x
cbs5	sta screen_3d+5,y
cbb6	lda back_buffer+$0c00-6,x
cbs6	sta screen_3d+6,y
cbb7	lda back_buffer+$0c00-7,x
cbs7	sta screen_3d+7,y
		;txa
		;sec
		;sbc #$08
		;tax
		;tya
		;clc
		;adc #$08
		;tay
		;bne cbs_loop
		txa
		sbc #$07
		tax
		clc
		tya
		adc #$08
		tay
		bne cbs_loop
		ldx cbs0+2
		inx
		cpx #>[screen_3d+$d00]
		bne cbs_next
		jmp RestoreSpritesOn3DView
cbs_next		
		stx cbs0+2
		stx cbs1+2
		stx cbs2+2
		stx cbs3+2
		stx cbs4+2
		stx cbs5+2
		stx cbs6+2
		stx cbs7+2		
		ldx cbb0+2
		dex
		stx cbb0+2
		stx cbb1+2
		stx cbb2+2
		stx cbb3+2
		stx cbb4+2
		stx cbb5+2
		stx cbb6+2
		stx cbb7+2
		jmp cbs_loop_load_x
	
draw_shape
		sty ds_restore_y+1
		; save 0/1 memory locations
		lda $00
		sta ds_restore_00+1
		lda $01
		sta ds_restore_01+1
		; prologue - load return address, use as source data pointer, update return address
		pla
		sta $00
		clc
		adc #$06	; 6 bytes of parameters
		tay
		pla
		sta $01
		adc #$00
		pha
		tya
		pha
		
		ldy #$01
		lda ($00),y
		sta ds_read+1
		iny
		lda ($00),y
		sta ds_read+2
		iny
		lda ($00),y
		sta ds_write+1
		iny
		lda ($00),y
		sta ds_write+2
		iny
		lda ($00),y
		sta ds_load_width+1
		eor #$ff
		sec
		adc #$20
		sta ds_add_screen_stride+1
		iny
		lda ($00),y
		sta ds_rows
		clc
		ldy #$00
	
ds_loop	
ds_load_width
		ldx #$ff
ds_read
		lda $ffff,y
ds_write
		sta $ffff,y
		iny
		dex
		bne ds_read
		lda ds_write+1
ds_add_screen_stride
		adc #$ff
		sta ds_write+1
		bcc ds_next_row
		clc
		inc ds_write+2
ds_next_row
		dec ds_rows
		bne ds_loop
	
ds_restore_01
		lda #$ff
		sta $01
ds_restore_00
		lda #$ff
		sta $00
ds_restore_y
		ldy #$ff
		rts
ds_rows dta $ff
		
draw_yellow_ankh
		lda #<$e283 ; 2
		sta ankh_yellow_target_address ; 3
@		jsr draw_shape ; 3 ; drawn in main code
		dta a(ankh_yellow_gfx) ; 2
ankh_yellow_target_address		
		dta a($e283) ; 2
		dta 1 ; 1
		dta 12 ; 1
		inc ankh_yellow_target_address ; 3
		dey ; 1
		bne @- ; 2
		rts
		
		ert *>$d000
atari_code_end
		
		org $600
ldsrc	equ $fc
lddest	equ $fe

		sei
		lda #$0
		sta nmien
		lda portb
		ora #$02
		and #$fe
		sta portb
		
		;lda #$20
		;ldy #$c0
		;ldx #$10
		;jsr ldcopy
		;lda #$30
		;ldy #$e6
		;ldx #$08
		;jsr ldcopy
		;lda #$38
		;ldy #$ee
		;ldx #$04
		;jsr ldcopy
		lda #$20
		ldy #$d8
		ldx #$12
		jsr ldcopy ; rmt player
		lda #$3c
		ldy #>screen_top
		ldx #$04
		jsr ldcopy
		lda #$40
		ldy #>screen_bottom
		ldx #$08
		jsr ldcopy
		lda #$48
		ldy #>(pmgmem+$0300)
		ldx #$03
		jsr ldcopy
		lda #$49
		ldy #>(pmgmem+$0600)
		ldx #$02
		jsr ldcopy
		lda #$4b
		ldy #>atari_code_start
		ldx #[>atari_code_end->atari_code_start]+1
		jsr ldcopy
		
		lda portb
		ora #$01
		sta portb
		lda #$40
		sta nmien
		cli
		rts
		
ldcopy	sta ldsrc+1
		sty lddest+1
		ldy #$0
		sty ldsrc
		sty lddest
ld1		lda (ldsrc),y
		sta (lddest),y
		iny
		bne ld1
		inc ldsrc+1
		inc lddest+1
		dex
		bne ld1
		rts
		
		ini $600

; main game		
		org $2000
		ins 'te.dmp',+$2000,$a000
		
; temporary Atari code
		org $8000
		
atariinit
		lda #$00
		tax
@		sta sprite_reg,x
		inx
		cpx #$40
		bne @-
		
; reset consol
		lda #$00
		sta consol
		lda #$07
		sta LastConsolState
		
; detect ANTIC type (PAL/NTSC)
		lda #0
		sta Vblank60Hz
		lda #131-1
@		cmp vcount
		bne @-
		nop
@		cmp vcount
		beq @-
		lda vcount
		bne @+
; 60Hz VBlank detected
		dec Vblank60Hz
@		
		
		lda PAL
		cmp #$0f
		bne PALGTIADetected
		jsr InitNTSCColors
		;jmp @+
PALGTIADetected

		bit Vblank60Hz
		bmi @+
		
		lda #50
		sta $6c47 ; fix clock in 50Hz mode
@		
		ldy #0
@		lda $8e00,y
		sta SunData,y
		iny
		cpy #20*8
		bne @-
		ldy #0
@		lda $8f00,y
		sta HeartData,y
		iny
		cpy #4*16*2
		bne @-
		
		jsr prepare_watch
		jsr prepare_compass
		jsr prepare_ankhs
		jsr init_pmg
		jsr init_mult
		jsr InitFastCPU
		jsr RmtSwapRegs
		ldx #<RmtSoundData
		ldy #>RmtSoundData
		lda #$00
		jsr RASTERMUSICTRACKER
		jsr RmtSwapRegs
		lda #$f0
		sta RMTSFXVOLUME	
		rts
		
memclear
		sta $03
		ldy #$00
		sty $02
		tya
mc1		sta ($02),y
		iny
		bne mc1
		inc $03
		dex
		bne mc1
		rts

ldcopy1	sta ldsrc+1
		sty lddest+1
		ldy #$0
		sty ldsrc
		sty lddest
ld11	lda (ldsrc),y
		sta (lddest),y
		iny
		bne ld11
		inc ldsrc+1
		inc lddest+1
		dex
		bne ld11
		rts
				

prepare_compass
		atari_screen_address_equ screen_fb28,$FB28
		lda #<screen_fb28
		sta $02
		lda #>screen_fb28
		sta $03
		ldx #$00
@		ldy #$00
@		lda ($02),y
		sta compass_data,x
		inx
		iny
		cpy #$04
		bne @-
		lda #$20
		clc
		adc $02
		sta $02
		scc:inc $03
		cpx #32*3
		bne @-1
		rts
		
prepare_watch
		atari_screen_address_equ screen_f938,$F938
		lda #<screen_f938
		sta $02
		lda #>screen_f938
		sta $03
		ldx #$00
@		ldy #$00
@		lda ($02),y
		sta watch_data,x
		inx
		iny
		cpy #$04
		bne @-
		lda #$20
		clc
		adc $02
		sta $02
		scc:inc $03
		cpx #32*4
		bne @-1
		rts
		
prepare_ankhs
		lda #<$e283
		sta $02
		lda #>$e283
		sta $03
		ldx #$00
		ldy #$00
@		lda ($02),y
		sta ankh_yellow_gfx,x
		tya
		clc
		adc #$20
		tay
		scc:inc $03
		inx
		cpx #12
		bne @-
		
		lda #<$e287
		sta $02
		lda #>$e287
		sta $03
		ldx #$00
		ldy #$00
@		lda ($02),y
		sta ankh_red_gfx,x
		tya
		clc
		adc #$20
		tay
		scc:inc $03
		inx
		cpx #12
		bne @-
		rts
		
init_pmg
		; init GTIA
		ldx #$0f
		lda #$00
cleargtia	sta $d000,x
		dex
		bpl cleargtia
	
		lda #>pmgmem
		sta pmbase
		;lda #%00101101
		;sta dmactl
		lda #$03	; enable players
		sta pmcntl
		lda #$11	; PMG priority
		sta gtiactl
		lda #$00
		sta sizep0
		sta sizep1
		sta sizep2
		sta sizep3
		lda #$c3
		sta sizem
		lda #$2f
		sta hposp0
		lda #$37
		sta hposp1
		lda #$C1
		sta hposp2
		lda #$C9
		sta hposp3
		lda #$34
		sta hposm0
		lda #$C6
		sta hposm3
		lda #$f4
InitPMGColpm0 equ *-1		
		sta colpm0
		lda #$1A
InitPMGColpm1 equ *-1		
		sta colpm1
		lda #$f4
InitPMGColpm2 equ *-1		
		sta colpm2
		lda #$1a
InitPMGColpm3 equ *-1		
		sta colpm3
		lda #$69
		sta hposm1
		;lda #$70 ; missile not used?
		;sta hposm2		
		;lda #$18 ; ?
		;sta colpf3
		lda #$00
		sta colbak ; black background
		rts
	
init_mult
		LDX #0      ;build square tables
    	STX multab3+$fe
    	STX multab4+$fe
    	LDY #$ff

im1  TXA
    	LSR
    	CLC
    	ADC multab3+$fe,x
    	STA multab1,x
    	STA multab3+$ff,x
    	STA multab3,y
    	LDA #0
    	ADC multab4+$fe,x
    	STA multab2,x
    	STA multab4+$ff,x
    	STA multab4,y
    	DEY
    	INX
    	BNE im1

im2  	TXA
    	SEC
    	ROR
    	CLC
    	ADC multab1+$ff,x
    	STA multab1+$100,x
    	LDA #0
    	ADC multab2+$ff,x
    	STA multab2+$100,x
    	INX
    	BNE im2

    	RTS		
		
InitNTSCColors
		ldx #15
@		lda c64colors,x
		jsr ConvertColorPAL2NTSC
		sta c64colors,x
		dex
		bpl @-
		
		ldy #$00
		ldx #0
@		lda ColorSetPointers,x
		sta $00
		inx
		lda ColorSetPointers,x
		sta $01
		inx
		lda ($00),y
		jsr ConvertColorPAL2NTSC
		sta ($00),y
		cpx #ColorSetPointersEnd-ColorSetPointers
		bne @-
		
		rts
		
ColorSetPointers
		dta a(VblSetColpf0),a(VblSetColpf1),a(VblSetColpf2),a(VblSetColpf3)
		dta a(Dli0Colpf1),a(Dli0Colpf2)
		dta a(Dli2Colpf1),a(Dli2Colpf2)
		dta a(Dli22Colpf1)
		dta a(Dli3Colpf0),a(Dli3Colpf1),a(Dli3Colpf2)
		dta a(Dli4Colpf0)
		dta a(InitPMGColpm0),a(InitPMGColpm1),a(InitPMGColpm2),a(InitPMGColpm3)
		dta a(CreditsScreenColor1),a(CreditsScreenColor2)
		dta a(InitialScreenColor1),a(InitialScreenColor2)
ColorSetPointersEnd
		
ConvertColorPAL2NTSC
		pha
		and #$f0
		beq NTSCNoColorFix
		cmp #$e0
		beq NTSCFixColorPlus30
		bcs NTSCFixColorPlus30
		pla
		clc
		adc #$10
		rts
NTSCNoColorFix		
		pla
		rts
NTSCFixColorPlus30
		pla
		clc
		adc #$30
		rts
		
InitFastCPU
		lda #$00
		sta FastCPUActive
@		lda vcount
		bne @-
		lda #$00
		clc
@		adc #$1
		bne @-
		lda vcount  ; 6 for 1,79 MHz
					; 0 for 21,48 MHz
		bne StandardCPU
		dec FastCPUActive
		lda #$0
		sta StandardStepValue
		sta SetStandardAngleValue
		lda #$4c
		sta $6032
		lda #<SyncVBLANK
		sta $6033
		lda #>SyncVBLANK
		sta $6034
;		ldx #<Call1F88InGameSync
;		ldy #>Call1F88InGameSync
;		stx $414f+1
;		sty $414f+2
StandardCPU
		rts
		

		ert *>= $9000
; Sprite handling code
		org $9000
		
SpriteShow
		cmp #1 ; ignore sprite #1 (additional sprite for target indicator)
		sne:rts
		sta SpriteNum
		; convert to screen coordinates
		txa
		sec
		sbc #$38 ; #$18 for standard screen, $32 for narrow screen
;		bcs @+
;		ldx $172d ; high byte of x position
;		bne @+
;		lda #0
;@		
		and #$fe
		sta SpriteXPos
		tya
		sec
		sbc #$32
		bpl @+
		lda #$00
@		sta SpriteYPos
		
		; clip target indicator sprite (#0)
		lda SpriteNum
		bne SpriteClipDone
		lda SpriteYPos
		cmp #30
		scs:lda #30
		cmp #120
		scc:lda #120
		sta SpriteYPos
		;lda SpriteXPos
		;cmp #4
		;scs:lda #4
		;cmp #230
		;scc:lda #230
		;sta SpriteXPos
		
SpriteClipDone		
		;jsr SpriteHide
		jsr SpriteCalculateSpriteAddress
		jsr SpriteCalculatePosition
		jsr SetSpriteBlitOp
		lda #$00
		sta SpriteDataIndex
		sta SpriteScreenIndex
		lda SpriteXPos
		and #$07
		cmp #$04
		bcs SpriteSetupShiftLeft; ShiftLeft
		sta SpriteShiftRightCounter+1
		lda #<SpriteShiftRight
		sta SpriteShowLoop+1
		jmp SpriteShowLoop
SpriteSetupShiftLeft
		eor #$ff
		sec
		adc #$08
		;and #$07
		sta SpriteShiftLeftCounter+1
		lda #<SpriteShiftLeft
		sta SpriteShowLoop+1
SpriteShowLoop
		jsr SpriteShiftRight
SpriteBlit
		ldx #00
		ldy SpriteScreenIndex
SpriteBlitLoop		
		lda (SpritePtr),y
		;sta SpriteBackbuffer,y
SpriteBlitOp		
		eor SpriteLineBuffer,x
		sta (SpritePtr),y
		iny
		inx
		cpx #4
		bne SpriteBlitLoop
		sty SpriteScreenIndex
		lda SpritePtr
		clc
		adc #32-4
		sta SpritePtr
		scc:inc SpritePtr+1
		cpy #21*4
		bne SpriteShowLoop
		rts
	
		ert >SpriteShiftRight != >SpriteShiftLeft
	
SpriteShiftRight
		lda #$00
		sta SpriteLineBuffer+2
		ldy SpriteDataIndex
		ldx #$00
SpriteShiftRightCopyLoop		
		lda $ffff,y
;SpriteShiftLeftEor
;		eor #00
		sta SpriteLineBuffer,x
		iny
		inx
		cpx #3
		bne SpriteShiftRightCopyLoop
		sty SpriteDataIndex
SpriteShiftRightCounter		
		ldx #3	; number of shifts
		beq NoShiftRight
SpriteShiftRightShiftLoop
		clc
		ror SpriteLineBuffer
		ror SpriteLineBuffer+1
		ror SpriteLineBuffer+2
		ror SpriteLineBuffer+3
		dex
		bne SpriteShiftRightShiftLoop
NoShiftRight
		rts
		
SpriteShiftLeft
		lda #$00
		sta SpriteLineBuffer
		ldy SpriteDataIndex
		ldx #$00
SpriteShiftLeftCopyLoop
		lda $ffff,y
;SpriteShiftRightEor
;		eor #00
		sta SpriteLineBuffer+1,x
		iny
		inx
		cpx #3
		bne SpriteShiftLeftCopyLoop
		sty SpriteDataIndex
SpriteShiftLeftCounter		
		ldx #3 ; number of shifts
		beq NoShiftLeft
SpriteShiftLeftLoop		
		clc
		rol SpriteLineBuffer+3
		rol SpriteLineBuffer+2
		rol SpriteLineBuffer+1
		rol SpriteLineBuffer
		dex
		bne SpriteShiftLeftLoop
NoShiftLeft
		rts
		
SpriteCalculateSpriteAddress
		lda #$00
		sta SpritePtr
		lda SpriteNum
		lsr @
		ror SpritePtr
		lsr @
		ror SpritePtr
		clc
		adc #>SpritesData
		sta SpriteShiftRightCopyLoop+2
		sta SpriteShiftLeftCopyLoop+2
		lda SpritePtr
		sta SpriteShiftRightCopyLoop+1
		sta SpriteShiftLeftCopyLoop+1
		rts
		
SpriteCalculatePosition
		; Y*20 + X>>8 + screen
		lda #$00
		sta SpritePtr
		lda SpriteYPos
		lsr @
		ror SpritePtr
		lsr @
		ror SpritePtr
		lsr @
		ror SpritePtr
		sta SpritePtr+1
		lda SpriteXPos
		lsr @
		lsr @
		lsr @
		clc
		adc SpritePtr
		sta SpritePtr
		scc:inc SpritePtr+1
		clc
		adc #<screen
		sta SpritePtr
		sta SpriteLastScreenPosLow
		lda #>screen
		adc SpritePtr+1
		sta SpritePtr+1
		sta SpriteLastScreenPosHi	; SpritePtr/SpritePtr+1 += bitmapscreen
		rts
		
SpriteBlitOpSetWithMask
		; A = screen data
		; (SpriteLineBuffer,x) = sprite data
		; all registers must be saved
		pha
		lda SpriteLineBuffer,x
		sta SpriteMask
		and #%10101010
		lsr @
		ora SpriteMask
		sta SpriteMask
		lda SpriteLineBuffer,x
		and #%01010101
		asl @
		ora SpriteMask
		eor #$ff
		sta SpriteMask
		pla
		and #$ff
SpriteMask equ *-1
		ora SpriteLineBuffer,x
		rts
		
SetSpriteBlitOp
		lda SpriteNum
		cmp #$2
		bne @+
		lda #$20 ; jsr SpriteBlitOpSetWithMask
		ldx #<SpriteBlitOpSetWithMask
		ldy #>SpriteBlitOpSetWithMask
		jmp @+1
@		lda #$5d ; eor SpriteLineBuffer,x
		ldx #<SpriteLineBuffer
		ldy #>SpriteLineBuffer
@		sta SpriteBlitOp
		stx SpriteBlitOp+1
		sty SpriteBlitOp+2
		rts
		
SpriteLastScreenPosLow	dta 0
SpriteLastScreenPosHi	dta 0
SpriteDataIndex			dta 0
SpriteScreenIndex		dta 0
SpriteLineBuffer		dta 0, 0, 0, 0
SpriteXPos				dta 0
SpriteYPos				dta 0
SpriteNum				dta 0
SpritePtr				equ 0
		
SpriteShowPrologue
		;sei
		stx $82
		sta $83
		tax
		lda sprite_reg+$15
		and _bits,x
		beq @+1
		tya
		pha
		; eor previous sprite (to hide it)
		lda $83
		cmp #$2
		beq @+ ; not for moon sprite
		asl @
		tax
		ldy sprite_reg+1,x
		lda sprite_reg,x
		tax
		lda $83
		jsr SpriteShow
@		pla
		tay
@		ldx $82
		lda $83
		rts
		
SpriteShowWrapper
		jsr SpriteShow
		lda $1ac6
		bne @+
		cli
@		rts

SpriteHide
		;sei
		and #$07
		pha
		asl @
		tax
		ldy sprite_reg+1,x
		lda sprite_reg,x
		tax
		pla
		pha
		jsr SpriteShow
		pla
		rts
	
RestoreSpritesOn3DViewSetSpritesEnabledReg
		sta sprite_reg+$15
		
RestoreSpritesOn3DView
		ldx #$0
RestoreSpritesOn3DViewLoop		
		cpx #$02
		beq @+
		lda sprite_reg+$15
		and _bits,x
		beq @+
		txa
		pha
		asl @
		tax
		ldy sprite_reg+1,x
		lda sprite_reg,x
		tax
		pla
		pha
		jsr SpriteShow
		pla
		tax
@		inx
		cpx #$08
		bne RestoreSpritesOn3DViewLoop
		rts
		
HideSpritesOn3DView
		pha
		jsr RestoreSpritesOn3DView
		pla
		sta sprite_reg+$15
		rts
		
DrawShapeVBL
		sty dsv_restore_y+1
		; prologue - load return address, use as source data pointer, update return address
		pla
		sta $fc
		clc
		adc #$06	; 6 bytes of parameters
		tay
		pla
		sta $fd
		adc #$00
		pha
		tya
		pha
		
		ldy #$01
		lda ($fc),y
		sta dsv_read+1
		iny
		lda ($fc),y
		sta dsv_read+2
		iny
		lda ($fc),y
		sta dsv_write+1
		iny
		lda ($fc),y
		sta dsv_write+2
		iny
		lda ($fc),y
		sta dsv_load_width+1
		eor #$ff
		sec
		adc #$20
		sta dsv_add_screen_stride+1
		iny
		lda ($fc),y
		sta dsv_rows
		clc
		ldy #$00
	
dsv_loop	
dsv_load_width
		ldx #$ff
dsv_read
		lda $ffff,y
dsv_write
		sta $ffff,y
		iny
		dex
		bne dsv_read
		lda dsv_write+1
dsv_add_screen_stride
		adc #$ff
		sta dsv_write+1
		bcc dsv_next_row
		clc
		inc dsv_write+2
dsv_next_row
		dec dsv_rows
		bne dsv_loop
	
dsv_restore_y
		ldy #$ff
		rts
dsv_rows dta $ff
		
;Call1F88InGameSync
;		lda FrameCounter
;		pha
;		jsr $1f88
;		pla
;		eor #$ff
;		sec
;		adc FrameCounter
;		cmp #1
;		bcc Call1F88InGameSyncShortCall
;		eor #$ff
;		sec
;		adc #3
;		tax
;		sne:inx
;		jsr MultiSyncVBLANK
;Call1F88InGameSyncShortCall
;		rts
		
;		org $8f00
PrintCreditsMain2
		lda #<[screen_3d-$100]
		sta $7c
		lda #>[screen_3d-$100]
		sta $7d
PrintCreditsMain2Loop		
		lda TextTotalEclipse2
CreditsSourcePtr equ *-2
		php
		inc CreditsSourcePtr
		sne:inc CreditsSourcePtr+1
		plp
		bne @+
		rts ; 0 = end of text
@		bpl @+1
		inc $7d ; go to next line
		and #$7f
		sta $7c
		jmp PrintCreditsMain2Loop
@		cmp #$3
		bcs @+
		sta PrintCredits2CharBits01	; change color pen
		asl @
		asl @
		sta PrintCredits2CharBits23
		asl @
		asl @
		sta PrintCredits2CharBits45
		asl @
		asl @
		sta PrintCredits2CharBits67
		jmp PrintCreditsMain2Loop
@		sbc #$20
		sta PrintCreditsMain2Tmp
		asl @
		clc
		adc PrintCreditsMain2Tmp
		tax
		and #$01
		adc #$ff
		sta PrintCreditsMain2Tmp
		bmi @+
		dex
		dex
		dex
@		ldy #$20
PrintCredits2CharLoop
		lda FontData,x
		bit PrintCreditsMain2Tmp
		bmi @+
		asl @
		asl @
		asl @
		asl @
@		sta $82
		lda #$00
		asl $82
		bcc @+
		ora #$c0
PrintCredits2CharBits67 equ *-1		
@		asl $82
		bcc @+
		ora #$30
PrintCredits2CharBits45 equ *-1		
@		asl $82
		bcc @+
		ora #$0c
PrintCredits2CharBits23 equ *-1				
@		asl $82
		bcc @+
		ora #$03
PrintCredits2CharBits01 equ *-1		
@		eor ($7c),y
		sta ($7c),y
		inx
		tya
		clc
		adc #$20
		tay
		cpy #$e0
		bne PrintCredits2CharLoop
		inc $7c ; move to next char
		jmp PrintCreditsMain2Loop

PrintCreditsMain2Tmp dta 0
			
		ert *>$9300
		
		org SpritesData
		ins 'te.dmp',+$c000,$200
		
		org SpritesData
		; target indicator
		.he 00 00 00
		.he 00 00 00
		.he 00 04 00
		.he 00 04 00
		.he 00 55 40
		.he 01 44 50
		.he 01 04 10
		.he 00 00 00
		.he 05 40 54
		.he 00 00 00
		.he 01 04 10
		.he 01 44 50
		.he 00 55 40
		.he 00 04 00
		.he 00 04 00
		.he 00 00 00
		.he 00 00 00
		.he 00 00 00
		.he 00 00 00
		.he 00 00 00
		.he 00 00 00
		
		org SpritesData+$0080
		
		; moon
		.he 00 00 00
		.he 00 00 00
		.he 00 54 00
		.he 01 55 00
		.he 05 55 40
		.he 05 55 40
		.he 15 55 50
		.he 15 55 50
		.he 15 55 50
		.he 15 55 50
		.he 15 55 50
		.he 15 55 50
		.he 15 55 50
		.he 15 55 50
		.he 05 55 40
		.he 05 55 40
		.he 01 55 00
		.he 00 54 00
		.he 00 00 00
		.he 00 00 00
		
		;org $0800
		;ins 'te.dmp',+$0800,  $1800
		org FontData
		ins 'te.dmp',+$0800,$100 ; font
				
; patches
		org $2d6e	; sorting routine
		pla			; here B1 |= $01
		jmp $2da6	; and this is guaranteed to execute swap code later, so do not run rest of iterations
		:$2d77-* nop
		ert *<>$2d77
		pla			; here B1 |= $02
		jmp $2dc5	; and this is guaranteed to not execute swap code later, so do not run rest of iterations
		:$2d7d-* nop
		ert *<>$2d7d
		
		org $304d
		; free space

HandleSunMoonAnimation
		txa
		pha
		tya
		pha
		jsr draw_shape ; drawn in main code
		dta a(SunData)
		dta a(screen+$018-2)
		dta 6+2
		dta 20
		pla
		tay
		pla
		clc
		adc #3
		tax
		lda #$2
		jmp $79f8
		
EndAnimationCall1F88Sync
		lda FrameCounter
		pha
		jsr $1f88
		pla
		eor #$ff
		sec
		adc FrameCounter
		cmp #20
		bcs EndAnimationCall1F88End
		eor #$ff
		sec
		adc #20
		tax
		jsr MultiSyncVBLANK
EndAnimationCall1F88End
		rts
		
EndAnimationCall7D0CSync
		stx EndAnimationCall7D0CSyncRestoreX
		lda FrameCounter
		pha
		jsr $7d0c
		pla
		eor #$ff
		sec
		adc FrameCounter
		cmp #3
		bcs EndAnimationCall7D0CEnd
		eor #$ff
		sec
		adc #3
		tax
		jsr MultiSyncVBLANK
EndAnimationCall7D0CEnd
		ldx #$ff
EndAnimationCall7D0CSyncRestoreX equ *-1		
		rts
		
MultiSyncVBLANK
		lda FrameCounter
MultiSyncVBLANKLoop		
		cmp FrameCounter
		beq MultiSyncVBLANKLoop
		dex
		bne MultiSyncVBLANK
		rts
		
SetStandardStep
		ldx #$02 ; standard
		lda $1577
		cmp #$03
		beq SetStandardStepDemo
		ldx #$02
StandardStepValue equ *-1		
SetStandardStepDemo
		stx $1c37
		lda $152c,x
		sta $1c36
		rts
		
		:$30cc-* nop
		ert *<> $30cc
		
		;org $3087
		;jsr mult16x8
		
		org $3134
		jsr mult16x16

		org $314f
		jsr div32x16
		
		org $3187
		jsr mult16x16

		org $31a2
		jsr div32x16
		
		org $31fa
		jsr mult16x16

		org $3215
		jsr div32x16
		
		org $324d
		jsr mult16x16

		org $3268
		jsr div32x16
		
		org $32c0
		jsr mult16x16

		org $32db
		jsr div32x16

		org $3306
		jsr mult16x16

		org $3321
		jsr div32x16

		org $3379
		jsr mult16x16
		
		org $3394
		jsr div32x16
		
		org $33bf
		jsr mult16x16
		
		org $33da
		jsr div32x16
		
		org $3415
		jsr mult16x16
		
		org $3430
		jsr div32x16
		
		org $3457
		jsr mult16x16
		
		org $3472
		jsr div32x16
		
		org $35b2
		jsr div24x16
		
		;org $35f1
		;jsr mult16x8
		org $35e8
		ldy $41,x
		lda $40,x
		tax
		jmp mult16x8_34
		
		
		org $3604
		jsr div24x16
		
		org $3621
		jsr sub_304d
		
		org $3826
		jsr mult16x16
		
		org $3857
		jsr mult16x16
		
		org $3884
render_polygon
		lda $153e
		sta $b0
		ldy $172f
		dey
		tya
		asl @
		asl @
		tay
		ldx #$04
sub_3884_3894
		lda $960a,y
		sta $b0,x
		iny
		dex
		bne sub_3884_3894
		;
		lda $b2
		sta $00
		eor $b1
		sta $01
		;
		stx $82
		lda $b0
		lsr @
		ror $82
		lsr
		ror $82
		lsr @
		tax
		ror $82
		lda $82
		clc
		adc $158e
		sta $82
		txa
		adc $158f
		sta $83
sub_3884_38bc
		ldy $b0
sub_3884_loop
		;tya
		;and #$03
		;tax
		;lda $b1,x
		lda $00
		eor $01
		sta $00
		ldx $16ad,y
		lda #$00
		sta $16ad,y
		txa
		bne sub_3884_38cd
		jmp sub_3884_39c7
sub_3884_38cd
		cmp #$02
		beq sub_3884_38d7
		lda $15db,y
		sta $1644,y
sub_3884_limits_equal_prepare		
		tax
		and #$7f
		lsr @
		lsr @
		sta $b5
		sta $b6
		jmp sub_3884_limits_equal
sub_3884_38d7
		lda $15db,y
		cmp $1644,y
		bcc sub_3884_38eb
		beq sub_3884_limits_equal_prepare
		ldx $1644,y
		sta $1644,y
		txa
		sta $15db,y
sub_3884_38eb
		tax
		and #$7f
		lsr @
		lsr @
		sta $b5
		lda $1644,y
		and #$7f
		lsr @
		lsr @
		sta $b6
		cmp $b5
		bne sub_3884_395b
sub_3884_limits_equal		
		txa
		and #$03
		tax
		lda table_3884_3904,x
		sta $84
sub_3884_391d
		lda $1644,y
		and #$03
		tax
		lda table_3884_3925,x
		and $84
		sta $84
sub_3884_393e
		ldy $b5
		lda $00
		eor ($82),y
		and $84
		eor ($82),y
		sta ($82),y
		jmp sub_3884_39c7
sub_3884_395b
		txa
		and #$03
		beq sub_3884_397b
		tax
		ldy $b5
		lda ($82),y
		eor $00
		and table_3884_387c_eor_ff,x
		eor $00
		sta ($82),y
		inc $b5
sub_3884_397b
		ldy $b0
		lda $1644,y
		and #$03
		cmp #$03
		beq sub_3884_39a3
		tax
		ldy $b6
		lda ($82),y
		eor $00
		and table_3884_3880_eor_ff,x
		eor $00
		sta ($82),y
		dec $b6
		bmi sub_3884_39c7
sub_3884_39a3
		lda $b6
		sec
		sbc $b5
		bmi sub_3884_39c7
		tay
		lda table_fill_polygon,y
		sta jump_fill_polygon+1
		ldy $b5
		lda $00
jump_fill_polygon
		jmp fill_polygon
jump_fill_polygon_ret
sub_3884_39c7
		lda $82
		clc
		adc #$20
		sta $82
		bcc sub_3884_39d2
		inc $83
sub_3884_39d2
		inc $b0
		lda $153d
		cmp $b0
		bmi sub_3884_39de		
		jmp sub_3884_38bc
sub_3884_39de
		rts

table_3884_387c_eor_ff
		dta $ff;, $03, $0f, $3f (last three bytes the same like in next table)
		
table_3884_3925
		dta $03, $0f, $3f;, $ff (last byte the same as in next table)		
table_3884_3904
		dta $ff;, $fc, $f0, $c0 (last three bytes the same as in next table)
		
table_3884_3880_eor_ff	
		dta $fc, $f0, $c0, $00
		
ClearScreen3DView
		lda #<screen_3d
		sta $00
		lda #>screen_3d
		sta $01
		ldx #>[screen_bottom-screen_3d]
		lda #$ff
		ldy #$00
@		sta ($00),y
		iny
		bne @-
		inc $01
		dex
		bne @-
		rts
		
PrintCredits
		bit CreditsPrintedFlag
		bpl @+
		jmp PrintString
@		dec CreditsPrintedFlag
		lda #$f2
CreditsScreenColor1 equ *-1		
		sta screen_3d_colors+1
		lda #$1c
CreditsScreenColor2 equ *-1		
		sta screen_3d_colors+2
		jmp PrintCreditsMain2
		
		:$39df-* nop
		ert *<>$39df
		
		org $404c
		sei
		lda #0
		sta nmien	; disable interrupts
		sta irqen
		sta dmactl	; disable screen
		lda #$02
		sta chrctl
		lda #%11111110
		sta portb
		
		lda #<nmi
		sta $fffa
		lda #>nmi
		sta $fffb
		lda #<irq
		sta $fffe
		lda #>irq
		sta $ffff

; memclear
		ldx #0
		txa
mm4		sta $0,x
		inx
		bne mm4

		;lda #$c0
		;ldy #$08
		;ldx #$10
		;jsr ldcopy1
		;lda #$e6
		;ldy #$18
		;ldx #$08
		;jsr ldcopy1
		;lda #$ee
		;ldy #$04
		;ldx #$04
		;jsr ldcopy1
	
		;lda #$c0
		;ldx #$10
		;jsr memclear
		lda #>screen_3d
		ldx #[>screen_bottom - >screen_3d]
		jsr memclear
		
		jsr atariinit
		
		; init POKEY
		ldx #$08
		lda #$00
		sta skctl
clear	sta $d200,x
		dex
		bpl clear
		lda #$03
		sta skctl

		
		; one byte left!
				
		; original c64 code
		lda #$01
		sta $1736
		sta $1737
		sta $1577
		sta $1589
		jsr $6bae
		jsr $4891
		jsr sound_fx_init ; $cd12
		lda #$fd
		sta $1543
		lda #$FF
		sta $1544
		jsr $1f88
		jsr ClearScreen3DView
		; init compass
		lda #$47
		jsr $76f9

		; set screen
@		lda vcount
		bne @-
		lda #<dlist
		sta dlptr
		lda #>dlist
		sta dlptr+1
		lda #%00111101
		sta dmactl
		lda #$c0
		sta nmien
			
		jmp $4113
		
WaitForKeyDepressRestoreColors
		lda #$ff
		sta LastInput
		jsr $6f00
		bcs @+
		lda #$ec
InitialScreenColor1 equ *-1		
		sta screen_3d_colors+1
		lda #$9a
InitialScreenColor2 equ *-1		
		sta screen_3d_colors+2
@		rts

		
		:$40fc-* nop
		ert *<>$40fc
		jsr sound_fx_init	; $cd12
		
		org $411f
		jsr PrintCredits
		
		org $412c
		jsr WaitForKeyDepressRestoreColors
		
		org $4133
		jsr sound_fx_start ; $cb4b
		
		org $4387
		jsr sound_fx_init	; $cd12
		
		org $4399
		sta sound_music_flag
		jsr sound_music_2
		
		org $43a1
		jsr sound_fx_start	; $cb4b
		
		org $43b2
		and sprite_reg+$15
		sta sprite_reg+$15
		
		org $43f7
		jsr sound_fx_start	; cb4b
		
		org $44e4
		jsr sound_fx_start
		jmp copy_back_buffer_to_screen
		; free space
; copy backbuffer to screen - old version, causes swipes
;		ldy #$00
;		ldx #$ff
;cbs1	lda back_buffer+$0c00,x
;		sta screen_3d,y
;		lda back_buffer+$0b00,x
;		sta screen_3d+$0100,y
;		lda back_buffer+$0a00,x
;		sta screen_3d+$0200,y
;		lda back_buffer+$0900,x
;		sta screen_3d+$0300,y
;		lda back_buffer+$0800,x
;		sta screen_3d+$0400,y
;		lda back_buffer+$0700,x
;		sta screen_3d+$0500,y
;		lda back_buffer+$0600,x
;		sta screen_3d+$0600,y
;		lda back_buffer+$0500,x
;		sta screen_3d+$0700,y
;		lda back_buffer+$0400,x
;		sta screen_3d+$0800,y
;		lda back_buffer+$0300,x
;		sta screen_3d+$0900,y
;		lda back_buffer+$0200,x
;		sta screen_3d+$0a00,y
;		lda back_buffer+$0100,x
;		sta screen_3d+$0b00,y
;		lda back_buffer+$0000,x
;		sta screen_3d+$0c00,y
;		dex
;		iny
;		bne cbs1
;		rts

; sounds in RMT file:
; 0C - ping
; 0D - buzz
; 0E - fire
; 0F - activate, fall
; 10 - bump	
; 11 - fail
; 12 - bonus 1
; 13 - bonus 2
; 14 - bonus 3
; 15 - dooropen
; 16 - doorclose

; sound effects in Freescape
; 00 - silence
; 01 - ping
; 02 - buzz
; 03 - fire
; 04 - activate
; 05 - bump
; 06 - fall
; 07 - fail
; 08 - bonus 1
; 09 - bonus 2
; 0a - bonus 3
; 0b - dooropen
; 0c - doorclose
SoundFxMappingTable
	dta $0c*2 ; ping
	dta $0d*2 ; buzz
	dta $0e*2 ; fire
	dta $0f*2 ; activate
	dta $10*2 ; bump
	dta $0f*2 ; fall
	dta $11*2 ; fail
	dta $12*2 ; bonus 1
	dta $13*2 ; bonus 2
	dta $14*2 ; bonus 3
	dta $15*2 ; dooropen
	dta $16*2 ; doorclose
	dta $17*2 ;
	dta $18*2 ; 
	dta $19*2
	dta $1A*2
	dta $1B*2
	dta $1C*2
	dta $1D*2
	dta $1E*2
	dta $1F*2
	

sound_fx_start
		ldx $1736
		bne SoundFxDisabled
		pha
		jsr RmtSwapRegs
		pla
		cmp #$ff ; ping
		bne SoundFxNotHeart
		ldy #$20*2
		ldx #1
		lda #0
		beq SoundFxPlay
SoundFxNotHeart
		tax
		ldy SoundFxMappingTable-1,x 
		ldx #0
		;lda #12
		txa
SoundFxPlay
		jsr RASTERMUSICTRACKER+15
		jsr RmtSwapRegs
SoundFxDisabled
		rts
		
RmtSwitchMusicSoundEffects ; A = 1: music, A = 0: sound effects
		pha
		jsr RmtSwapRegs
		pla
		beq @+
		lda #$00
		beq @+1
@		lda #$2c
@		ldx #<RmtSoundData
		ldy #>RmtSoundData
		jsr RASTERMUSICTRACKER
		jmp RmtSwapRegs
		
RmtSwapRegs
;		ldx #19-1
;@		ldy rmt_regs_save,x
;		lda $ed,x
;		sty $ed,x
;		sta rmt_regs_save,x
;		dex
;		bpl @-
;		rts
		ldy rmt_regs_save
		lda $8d
		sty $8d
		sta rmt_regs_save
		rts
		
SyncVBLANK
		lda FrameCounter
@		cmp FrameCounter
		beq @-
		rts

draw_red_ankh
		;lda #<$e284 ; 2
		;sta ankh_red_target_address ; 3
@		jsr draw_shape ; 3 ; drawn in main code
		dta a(ankh_red_gfx) ; 2
ankh_red_target_address		
		dta a($e283) ; 2
		dta 1 ; 1
		dta 12 ; 1
		inc ankh_red_target_address ; 3
		dey ; 1
		bne @- ; 2
		rts
		
		
		:$455e-* nop
		ert *<>$455e
		
		org $45f5
		jsr sub_4608	

		org $4601
		jsr sub_4608	
		
		org $48a9
		jsr SetStandardAngle
		
		org $49a7
		jsr SetStandardStep
		:$49b0-* nop
		
		org $592e
		jsr mult16x8

		org $597c
		jsr mult16x8

		org $5af5
		jsr mult16x8
		
		org $5b33
; set colors
		lda #$00
		sta $145f
		sty sc_restory_y+1
		ldx #$04		
sc1		lda $1c63,x
		sta $1c5f,x
		and #$0f
		tay
		lda c64colors,y
		sta screen_3d_colors-1,x
		dex
		bne sc1
sc_restory_y
		ldy #$ff
		rts
		;9c - niebo
;c64colors	dta $00, $0e, $26, $9c, $58, $ba, $74, $ee, $18, $e6, $2a, $06, $0a, $be, $7a, $0e
;c64colors	dta $00, $08, $24, $9a, $56, $b8, $72, $ec, $16, $e4, $2a, $04, $08, $bc, $78, $08
;c64colors	dta $00, $0c, $24, $9a, $58, $ba, $74, $ec, $18, $e6, $2a, $06, $0a, $be, $7a, $0e
c64colors dta $00, $0a, $34, $9a, $58, $ba, $74, $ec, $18, $e6, $2a, $04, $06, $be, $7a, $0a

		
LastInput
		dta b($ff)
LastInputFrame
		dta b(0)
CurrentInputDelay
		dta b(0)
		
HandleInputRepeat
		bcs @+
		jsr InputHandleStart
@		
		bit FastCPUActive
		bpl @+ ; skip shooting mode check on standard CPU
		bit $1c91 ; $ff = shooting mode active
		bmi HandleInputRepeatEnd
@		lda $18db
		bcc HandleInputRepeatEnd
		cmp LastInput
		bne @+
		cmp #'R' ; do not apply delay to 'R' key (REST), as game checks how long it is pressed
		beq @+
		
		ldx #2 ; standard delay for key autorepeat is 2 frames
		cmp #'H'
		sne:ldx #8 ; for 'H' and 'U' delay is 8 frames
		cmp #'U'
		sne:ldx #8
		stx CurrentInputDelay
		
		sec
		lda FrameCounter
		sbc LastInputFrame
		;cmp #2
		cmp CurrentInputDelay
		bcs @+
		 ; clc = 0 here; key is repeated (we read the same value within last two frames)
		lda $18db	
		rts
@
		lda FrameCounter
		sta LastInputFrame
		lda $18db
		sta LastInput
		sec
		
HandleInputRepeatEnd		
		rts
			
		:$5bbb-* nop
		; $59 bytes free
		ert *<>$5bbb
		
		;org $5bcb	; TODO: enable when compass and watch clearing done
		;rts
		
; plot pixel
		org $5d9e
		lda $172b	; x coordinate
		lsr @
		lsr @
		clc
		ert *<> $5da4
		
		org $5db0
		lda #$00
		sta $83
		lda $172c	; y coordinate
		asl @
		rol $83
		asl @
		rol $83
		asl @
		rol $83
		asl @
		rol $83
		asl @
		rol $83
		sta $82
		jmp $5de1
		
SetStandardAngle
		lda $1577
		cmp #$03
		beq SetStandardAngleDemo
		lda #$01
SetStandardAngleValue equ *-1
		rts
SetStandardAngleDemo
		lda $96c3
		rts
					
		:$5de1-* nop
		ert *<>$5de1

		org $5e39
		nop
		nop
		nop
		
		org $5e4b
		jsr sound_fx_player ; $cc2d
		
		org $5f42
		jsr sound_fx_start	;CB4B
		
;		org $6032
;		lda FrameCounter
;@		cmp FrameCounter
;		beq @-
;@		lda vcount
;		bne @-
;		rts
;		:$603d-* nop
		
		org $6211
		jsr mult16x8
		
		org $66de
		jsr sound_fx_start	;CB4B
		
		org $6853
		jsr div32x16
		
		org $686c
		lda #$ff
		
		org $6853
		jsr div32x16
		
		org $68c2	; part of draw string procedure
		lda FontData,x
		sty sub_68c2_restore_y+1
		ldy $82
		bne sub_68c2_68d4
		lsr @
		lsr @
		lsr @
		lsr @
sub_68c2_68d4
		and #$0f
		tay
		lda sub_68c2_pixel_data,y
sub_68c2_restore_y		
		ldy #$00 		
		eor $686b
		jmp $6913
sub_68c2_pixel_data
		dta %00000000	; 0
		dta %00000011	; 1
		dta %00001100	; 2
		dta %00001111	; 3
		dta %00110000	; 4
		dta %00110011	; 5
		dta %00111100	; 6
		dta %00111111	; 7
		dta %11000000	; 8
		dta %11000011	; 9
		dta %11001100	; A
		dta %11001111	; B
		dta %11110000	; C
		dta %11110011	; D
		dta %11111100	; E
		dta %11111111	; F
		; free space 32-8 bytes
		
RmtSwitchMusicSoundEffectPlayEffect
		jsr RmtSwitchMusicSoundEffects
		lda #$03
		jmp sound_fx_start
		
InputHandleStart
		lda consol
		and #%001
		bne @+
		lda #$96 ; fake input function code
		sta $18db
		inc $18da
		sec
@		
		rts

		:$6910-* nop
		ert *<> $6910
		
		org $692e
; draw char
; fix stride for position of next character (+1 instead +8)
		inc $7c
		bne $6939
		inc $7d
		bne $6939
		:$6939-* nop
		ert *<>$6939
		
		org $6948
; write one byte to screen ram (used by draw char)
; fix stride of position of next byte of character (+$20 instead +1)
		sta $ffff
		lda $6949
		clc
		adc #$20
		sta $6949
		bcc wbsr1
		inc $694a
wbsr1	rts
		:$696c-* nop
		ert *<>$696c
		
		org $69ad
		; handle sun/moon animation
		jsr HandleSunMoonAnimation
		
		org $6a2c
; update game progress indicators
		jsr draw_yellow_ankh
		:$6a38-* nop		
		
		org $6a39
; update game progress indicators
		pha
		clc
		adc #<$e283
		sta ankh_red_target_address
		pla
		eor #$ff
		sec
		adc #$05
		tay
		beq @+
		jsr draw_red_ankh
@		
		:$6a51-* nop
		
		; fixes for bottle level drawing
		org $6b5b
		ldy #$04	; byte stride for 16 pixels
		
		org $6b93
		ldy #$04	; byte stride for 16 pixels
		
		org $6b62
; bottle level
		dey			; adjust y for previous screen byte
		bne $6b5d
		beq $6b69
		:$6b69-* nop
		ert *<>$6b69
		
		org $6b9a
		dey			; adjust y for previous screen byte
		bne $6b95
		beq $6ba1
		:$6ba1-* nop
		ert *<>$6ba1
		
		org $6baf
		:$6bc3-* nop
		ert *<>$6bc3
		
		org $6c05
		lda consol
		pha
		and #%010
		bne @+
		eor LastConsolState
		and #%010
		beq @+
		; SELECT pressed, switch music <-> sound effects
		lda $1737
		eor #$01
		sta $1737
		sta $1736
		sta sound_music_flag
		jsr RmtSwitchMusicSoundEffectPlayEffect
		nop ; code alignment
		nop
		
@		pla
		sta LastConsolState
		;jmp $6c2b ; skips jumps to c64 music/sfx handlers
		
		;org $6c16
		;jsr sound_music_player ; $0900
		
		;org $6c28
		;jsr sound_fx_player ; $c22d
		:$6c2b-* nop
		ert *<>$6c2b
		
		org $6d68
		lda sound_fx_flag	; $c801
		
		org $6d6d
		lda #$ff
		jsr sound_fx_start ; $cb4b
		
		org $6d72
		;:$6d80-* nop
		jsr DrawShapeVBL ; drawn in interrupt
		dta a(BigHeartData)
		atari_screen_address_dta $fae8
		dta 4
		dta 16
		jmp $6d9d
		:$6d83-* nop
		
		org $6d8c
		;:$6d9a-* nop
		jsr DrawShapeVBL ; drawn in interrupt
		dta a(SmallHeartData)
		atari_screen_address_dta $fae8
		dta 4
		dta 16
		jmp $6d9d
		:$6d9d-* nop
		
		org $6deb
		jsr sound_fx_start ; $cb4b
		
		org $6ea9
		nop		; irq ack
		nop
		nop
		
		org $6f02
		jsr read_joystick
		
		org $6f4a
		jsr readkey_c64
		:$6f55-* nop
		ert *<>$6f55
		
		org $6F8B
		jmp HandleInputRepeat
		
		org $6fc3
;screen pointer
		atari_screen_address_equ screen_last_row,$fe27
		lda #<screen_last_row
		sta $1731
		lda #>screen_last_row
		sta $1732

		org $70e0
		jsr mult16x8
		
		org $719D
		dta c'  ESC-ABORT   '
		
		org $71e3
		lda sprite_reg+$15
		
		org $71eb
		and sprite_reg+$15
		;sta sprite_reg+$15
		jsr HideSpritesOn3DView
		
		org $7215
		:$7224-* nop
		
		org $7228
		lda #$a2
		
		org $7262
		jmp $7275
		:$7275-* nop
		
		org $728d
		sta sound_music_flag
		jsr RmtSwitchMusicSoundEffects
		
		org $72b6
		jsr sound_fx_start ; $cb4b

		org $72cc
		;sta sprite_reg+$15
		jsr RestoreSpritesOn3DViewSetSpritesEnabledReg
		
		org $7578
		atari_screen_address_equ screen_3d_top_left,$e7dc
		lda #<screen_3d_top_left
		sta $7a
		lda #>screen_3d_top_left
		sta $7b
		
		org $75b5
		adc #$60/8
		
		org $75cd
		adc #$50/8
		
		org $75e2
		adc #$30/8
		
		org $7605
		lda $7a
		clc
		adc #$20
		sta $7a
		bcc sub_7605_l1
		inc $7b
sub_7605_l1
		bne $761e
		:$761e-* nop
		ert *<>$761e
		
		org $7666
		iny
		pla
		tax
		dex
		bne $7652
		rts
		:$7671-* nop
		ert *<>$7671
		
		org $7686
		iny
		jmp $768d
		:$768d-* nop
		ert *<>$768d
	
		org $76fa
; TODO update compass
		sty sub76fa_save_y
		jsr draw_shape ; drawn in main code
		dta a(compass_data)
		atari_screen_address_dta $fb28
		dta 4
		dta 3*8	
		ldy #$ff
sub76fa_save_y equ *-1		
		:$7711-* nop
		
; TODO show sprite
		org $79f8
		jsr SpriteShowPrologue
		
		org $7a03
		sta sprite_reg+$27,x
		org $7a0a
		sta sprite_reg+$1,x
		org $7a0f
		sta sprite_reg,x
		org $7a1d
		ora sprite_reg+$15
		sta sprite_reg+$15
		org $7A24
		ldx $172d
		
		org $7a29
		ora sprite_reg+$10
		sta sprite_reg+$10
		org $7a34
		and sprite_reg+$10
		sta sprite_reg+$10

		org $7a3a
		lda $83
		ldx $82
		jmp SpriteShowWrapper
		
; TODO: hide sprite
		org $7a41
		jsr SpriteHide
		
		org $7a51
		and sprite_reg+$15
		sta sprite_reg+$15
		
;		org $7aa4
; TODO: update watch on screen
;		:$7abc-* nop
;		ert *<>$7abc

		org $7aa2
		jsr DrawShapeVBL ; drawn in interrupt
		dta a(watch_data)
		atari_screen_address_dta $f938
		dta 4
		dta 4*8
		:$7abf-* nop
		ert *<>$7abf
		
		;org $7ac9
		;lda #$00	; color of watch
		org $7b7d
		stx $172f	; color of small indicator of watch
		
		org $7bfc
		jsr EndAnimationCall1F88Sync
		
		org $7c7d
		jsr EndAnimationCall7D0CSync

		org $7c94
		jsr EndAnimationCall7D0CSync
		
		org $7c3b
		jsr sound_fx_start ; $cb4b

		org $7c48
		jsr EndAnimationCall7D0CSync
		
		org $7c60
		jsr sound_fx_start ; $cb4b
		
		org $7ca4
		jsr sound_fx_start ; $cb4b

		org $7ccd
		ldx #5
		jsr MultiSyncVBLANK
		:$7CD7-* nop
		
		org $7dcf
		
TextTotalEclipse2
		dta $80 | ((32-14)/2)
		dta $01
		dta c'TOTAL  ECLIPSE'
		dta $80
		dta $80 | ((32-18)/2)
		dta $02
		dta c'ORIGINAL GAME 1989' 
		dta $80 | ((32-22)/2)
		dta c'BY  '
		dta $01
		dta c'INCENTIVE SOFTWARE'
		dta $80
		dta $80 | ((32-18)/2)
		dta $02
		dta c'ATARI VERSION 2018'
		dta $80 | ((32-14)/2)
		dta c'CODE:  '
		dta $01
		dta c'MARIUSZ'
		dta $80 | ((32-10)/2)
		dta $02
		dta c'GFX:  '
		dta $01
		dta c'ADAM'
		dta $80 | ((32-22)/2)
		dta $02
		dta c'MUSIC AND SFX:  '
		dta $01
		dta c'STRING'	
		dta $80 | ((32-14)/2)
		dta $02
		dta c'ADD. GFX: '
		dta $01
		dta c'JOSE'
		dta $80 | ((32-26)/2)
		dta $02
		dta c'THANX TO:  '
		dta $01
		dta c'ODYN1EC AND PIN'
		dta $80
		dta $80 | ((32-18)/2)
		dta $02
		dta c'PRESS FIRE TO PLAY'		
		dta 0
		
CreditsPrintedFlag		
		dta b(0)
		
		ert *>$7ea7
		
		;org $7e8c
		;rts
		;:$7ea7-* nop
		;ert *<>$7ea7
		
		org $9651
		atari_screen_address_dta $E520
		org $9675
		atari_screen_address_dta $E086
		org $9678
		atari_screen_address_dta $F5A1
		org $967b
		atari_screen_address_dta $F569
		org $967e
		atari_screen_address_dta $F589
		org $9681
		dta a($ffff)
		org $9684
		dta a($ffff)
		org $9687
		dta a($ffff)
		org $968a
		atari_screen_address_dta $ECF8
		org $968d
		dta a($ffff)
		org $9690
		atari_screen_address_dta $E096
		org $9693
		atari_screen_address_dta $e0b6
		org $9696
		atari_screen_address_dta $F639
		org $9699
		atari_screen_address_dta $F629
		org $969c
		atari_screen_address_dta $F649
		org $969f
		atari_screen_address_dta $F480
		org $96A2
		atari_screen_address_dta $EA68
		org $96A5
		atari_screen_address_dta $EBA8
		org $96A8
		atari_screen_address_dta $ECE8
		org $96Ab
		atari_screen_address_dta $EE28
		org $96Ae
		atari_screen_address_dta $EF68
		
		; sound data
		org RmtSoundData
		;opt h-
		ins "te7.rmt",+6
		;opt h+
				
		org SunData,$8e00
		.he 00 00 00 A8 00 00 00 00
		.he 00 00 03 FF 00 00 00 00
		.he 00 00 0F FF C0 00 00 00
		.he 00 00 0F FF C0 00 00 00
		.he 00 00 3F FF F0 00 00 00
		.he 00 00 3F FF F0 00 00 00
		.he 00 00 BF FF F8 00 00 00
		.he 00 00 BF FF F8 00 00 00
		.he 00 00 FF FF FC 00 00 00
		.he 00 00 FF FF FC 00 00 00
		.he 00 00 FF FF FC 00 00 00
		.he 00 00 FF FF FC 00 00 00
		.he 00 00 BF FF F8 00 00 00
		.he 00 00 BF FF F8 00 00 00
		.he 00 00 3F FF F0 00 00 00
		.he 00 00 3F FF F0 00 00 00
		.he 00 00 0F FF C0 00 00 00
		.he 00 00 0F FF C0 00 00 00
		.he 00 00 03 FF 00 00 00 00
		.he 00 00 00 A8 00 00 00 00 
		
		org HeartData,$8f00
SmallHeartData
		.he 55 55 55 55
		.he 55 55 55 55
		.he 55 50 41 55
 		.he 55 46 24 55
 		.he 55 4A 78 55
 		.he 55 4A B8 55
 		.he 55 46 A4 55
 		.he 55 52 A1 55
 		.he 55 51 91 55
 		.he 55 54 85 55
 		.he 55 54 45 55
 		.he 55 55 15 55
 		.he 55 55 15 55
 		.he 55 55 55 55
 		.he 55 55 55 55
 		.he 15 55 55 55
		
BigHeartData
		.he 55 40 40 55
		.he 55 19 19 15
		.he 55 2A 2E 15
 		.he 55 2A 6E 15
 		.he 55 2A AE 15
 		.he 55 1A A9 15
 		.he 55 1A A9 15
 		.he 55 46 A4 55
 		.he 55 46 A4 55
 		.he 55 51 91 55
 		.he 55 51 91 55
 		.he 55 54 45 55
 		.he 55 54 45 55
 		.he 55 55 15 55
 		.he 55 55 15 55
 		.he 15 55 55 55		
		
		run $404c
		